/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.hardware.location.GeofenceHardwareImpl;
import android.location.FusedBatchOptions;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.IGpsGeofenceHardware;
import android.location.INetInitiatedListener;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.Log;
import android.util.StatsLog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.location.GpsNetInitiatedHandler;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.internal.location.gnssmetrics.GnssMetrics;
import com.android.server.location.AbstractLocationProvider;
import com.android.server.location.ExponentialBackOff;
import com.android.server.location.GnssBatchingProvider;
import com.android.server.location.GnssCapabilitiesProvider;
import com.android.server.location.GnssConfiguration;
import com.android.server.location.GnssGeofenceProvider;
import com.android.server.location.GnssMeasurementCorrectionsProvider;
import com.android.server.location.GnssMeasurementsProvider;
import com.android.server.location.GnssNavigationMessageProvider;
import com.android.server.location.GnssNetworkConnectivityHandler;
import com.android.server.location.GnssPositionMode;
import com.android.server.location.GnssSatelliteBlacklistHelper;
import com.android.server.location.GnssStatusListenerHelper;
import com.android.server.location.GnssVisibilityControl;
import com.android.server.location.GpsPsdsDownloader;
import com.android.server.location.NtpTimeHelper;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;

public class GnssLocationProvider
extends AbstractLocationProvider
implements NtpTimeHelper.InjectNtpTimeCallback,
GnssSatelliteBlacklistHelper.GnssSatelliteBlacklistCallback {
    private static final String TAG = "GnssLocationProvider";
    private static final boolean DEBUG = Log.isLoggable("GnssLocationProvider", 3);
    private static final boolean VERBOSE = Log.isLoggable("GnssLocationProvider", 2);
    private static final ProviderProperties PROPERTIES = new ProviderProperties(true, true, false, false, true, true, true, 3, 1);
    private static final int GPS_POSITION_MODE_STANDALONE = 0;
    private static final int GPS_POSITION_MODE_MS_BASED = 1;
    private static final int GPS_POSITION_MODE_MS_ASSISTED = 2;
    private static final int GPS_POSITION_RECURRENCE_PERIODIC = 0;
    private static final int GPS_POSITION_RECURRENCE_SINGLE = 1;
    private static final int GPS_STATUS_NONE = 0;
    private static final int GPS_STATUS_SESSION_BEGIN = 1;
    private static final int GPS_STATUS_SESSION_END = 2;
    private static final int GPS_STATUS_ENGINE_ON = 3;
    private static final int GPS_STATUS_ENGINE_OFF = 4;
    private static final int LOCATION_INVALID = 0;
    private static final int LOCATION_HAS_LAT_LONG = 1;
    private static final int LOCATION_HAS_ALTITUDE = 2;
    private static final int LOCATION_HAS_SPEED = 4;
    private static final int LOCATION_HAS_BEARING = 8;
    private static final int LOCATION_HAS_HORIZONTAL_ACCURACY = 16;
    private static final int LOCATION_HAS_VERTICAL_ACCURACY = 32;
    private static final int LOCATION_HAS_SPEED_ACCURACY = 64;
    private static final int LOCATION_HAS_BEARING_ACCURACY = 128;
    private static final int ELAPSED_REALTIME_HAS_TIMESTAMP_NS = 1;
    private static final int ELAPSED_REALTIME_HAS_TIME_UNCERTAINTY_NS = 2;
    private static final int GPS_DELETE_EPHEMERIS = 1;
    private static final int GPS_DELETE_ALMANAC = 2;
    private static final int GPS_DELETE_POSITION = 4;
    private static final int GPS_DELETE_TIME = 8;
    private static final int GPS_DELETE_IONO = 16;
    private static final int GPS_DELETE_UTC = 32;
    private static final int GPS_DELETE_HEALTH = 64;
    private static final int GPS_DELETE_SVDIR = 128;
    private static final int GPS_DELETE_SVSTEER = 256;
    private static final int GPS_DELETE_SADATA = 512;
    private static final int GPS_DELETE_RTI = 1024;
    private static final int GPS_DELETE_CELLDB_INFO = 32768;
    private static final int GPS_DELETE_ALL = 65535;
    private static final int GPS_CAPABILITY_SCHEDULING = 1;
    private static final int GPS_CAPABILITY_MSB = 2;
    private static final int GPS_CAPABILITY_MSA = 4;
    private static final int GPS_CAPABILITY_SINGLE_SHOT = 8;
    private static final int GPS_CAPABILITY_ON_DEMAND_TIME = 16;
    public static final int GPS_CAPABILITY_GEOFENCING = 32;
    public static final int GPS_CAPABILITY_MEASUREMENTS = 64;
    public static final int GPS_CAPABILITY_NAV_MESSAGES = 128;
    public static final int GPS_CAPABILITY_LOW_POWER_MODE = 256;
    public static final int GPS_CAPABILITY_SATELLITE_BLACKLIST = 512;
    public static final int GPS_CAPABILITY_MEASUREMENT_CORRECTIONS = 1024;
    private static final int AGPS_SUPL_MODE_MSA = 2;
    private static final int AGPS_SUPL_MODE_MSB = 1;
    private static final int SET_REQUEST = 3;
    private static final int INJECT_NTP_TIME = 5;
    private static final int DOWNLOAD_PSDS_DATA = 6;
    private static final int UPDATE_LOCATION = 7;
    private static final int DOWNLOAD_PSDS_DATA_FINISHED = 11;
    private static final int INITIALIZE_HANDLER = 13;
    private static final int REQUEST_LOCATION = 16;
    private static final int REPORT_LOCATION = 17;
    private static final int REPORT_SV_STATUS = 18;
    private static final int AGPS_RIL_REQUEST_SETID_IMSI = 1;
    private static final int AGPS_RIL_REQUEST_SETID_MSISDN = 2;
    private static final int AGPS_REF_LOCATION_TYPE_GSM_CELLID = 1;
    private static final int AGPS_REF_LOCATION_TYPE_UMTS_CELLID = 2;
    private static final int AGPS_SETID_TYPE_NONE = 0;
    private static final int AGPS_SETID_TYPE_IMSI = 1;
    private static final int AGPS_SETID_TYPE_MSISDN = 2;
    private static final int GPS_GEOFENCE_UNAVAILABLE = 1;
    private static final int GPS_GEOFENCE_AVAILABLE = 2;
    private static final int GPS_GEOFENCE_OPERATION_SUCCESS = 0;
    private static final int GPS_GEOFENCE_ERROR_TOO_MANY_GEOFENCES = 100;
    private static final int GPS_GEOFENCE_ERROR_ID_EXISTS = -101;
    private static final int GPS_GEOFENCE_ERROR_ID_UNKNOWN = -102;
    private static final int GPS_GEOFENCE_ERROR_INVALID_TRANSITION = -103;
    private static final int GPS_GEOFENCE_ERROR_GENERIC = -149;
    private static final int TCP_MIN_PORT = 0;
    private static final int TCP_MAX_PORT = 65535;
    private static final long LOCATION_UPDATE_MIN_TIME_INTERVAL_MILLIS = 1000L;
    private static final long LOCATION_UPDATE_DURATION_MILLIS = 10000L;
    private static final int EMERGENCY_LOCATION_UPDATE_DURATION_MULTIPLIER = 3;
    private final Object mLock = new Object();
    private int mStatus = 1;
    private long mStatusUpdateTime = SystemClock.elapsedRealtime();
    private static final long RECENT_FIX_TIMEOUT = 10000L;
    private static final int NO_FIX_TIMEOUT = 60000;
    private static final int GPS_POLLING_THRESHOLD_INTERVAL = 10000;
    private static final long RETRY_INTERVAL = 300000L;
    private static final long MAX_RETRY_INTERVAL = 14400000L;
    private static final long DOWNLOAD_PSDS_DATA_TIMEOUT_MS = 60000L;
    private final ExponentialBackOff mPsdsBackOff = new ExponentialBackOff(300000L, 14400000L);
    @GuardedBy(value={"mLock"})
    private boolean mGpsEnabled;
    private boolean mShutdown;
    private static final int STATE_PENDING_NETWORK = 0;
    private static final int STATE_DOWNLOADING = 1;
    private static final int STATE_IDLE = 2;
    private int mDownloadPsdsDataPending = 0;
    private boolean mNavigating;
    private int mFixInterval = 1000;
    private boolean mLowPowerMode = false;
    private boolean mStarted;
    private long mStartedChangedElapsedRealtime;
    private static final long LOCATION_OFF_DELAY_THRESHOLD_WARN_MILLIS = 2000L;
    private static final long LOCATION_OFF_DELAY_THRESHOLD_ERROR_MILLIS = 15000L;
    private volatile int mTopHalCapabilities;
    private boolean mSupportsPsds;
    private long mFixRequestTime = 0L;
    private int mTimeToFirstFix = 0;
    private long mLastFixTime;
    private int mPositionMode;
    private GnssPositionMode mLastPositionMode;
    private ProviderRequest mProviderRequest;
    private WorkSource mWorkSource = null;
    private boolean mDisableGpsForPowerManager = false;
    private GnssConfiguration mGnssConfiguration;
    private String mSuplServerHost;
    private int mSuplServerPort = 0;
    private String mC2KServerHost;
    private int mC2KServerPort;
    private boolean mSuplEsEnabled = false;
    private final Looper mLooper;
    private final LocationExtras mLocationExtras = new LocationExtras();
    private final GnssStatusListenerHelper mGnssStatusListenerHelper;
    private final GnssMeasurementsProvider mGnssMeasurementsProvider;
    private final GnssMeasurementCorrectionsProvider mGnssMeasurementCorrectionsProvider;
    private final GnssNavigationMessageProvider mGnssNavigationMessageProvider;
    private final LocationChangeListener mNetworkLocationListener = new NetworkLocationListener();
    private final LocationChangeListener mFusedLocationListener = new FusedLocationListener();
    private final NtpTimeHelper mNtpTimeHelper;
    private final GnssBatchingProvider mGnssBatchingProvider;
    private final GnssGeofenceProvider mGnssGeofenceProvider;
    private final GnssCapabilitiesProvider mGnssCapabilitiesProvider;
    private GnssVisibilityControl mGnssVisibilityControl;
    private Handler mHandler;
    private final GnssNetworkConnectivityHandler mNetworkConnectivityHandler;
    private final GpsNetInitiatedHandler mNIHandler;
    private static final String WAKELOCK_KEY = "GnssLocationProvider";
    private final PowerManager.WakeLock mWakeLock;
    private static final String DOWNLOAD_EXTRA_WAKELOCK_KEY = "GnssLocationProviderPsdsDownload";
    @GuardedBy(value={"mLock"})
    private final PowerManager.WakeLock mDownloadPsdsWakeLock;
    private static final String ALARM_WAKEUP = "com.android.internal.location.ALARM_WAKEUP";
    private static final String ALARM_TIMEOUT = "com.android.internal.location.ALARM_TIMEOUT";
    private final PowerManager mPowerManager;
    private final AlarmManager mAlarmManager;
    private final PendingIntent mWakeupIntent;
    private final PendingIntent mTimeoutIntent;
    private final AppOpsManager mAppOps;
    private final IBatteryStats mBatteryStats;
    private WorkSource mClientSource = new WorkSource();
    private GeofenceHardwareImpl mGeofenceHardwareImpl;
    private volatile int mHardwareYear = 0;
    private volatile String mHardwareModelName;
    private static final float ITAR_SPEED_LIMIT_METERS_PER_SECOND = 400.0f;
    private volatile boolean mItarSpeedLimitExceeded = false;
    private GnssMetrics mGnssMetrics;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (DEBUG) {
                Log.d("GnssLocationProvider", "receive broadcast intent, action: " + action);
            }
            if (action == null) {
                return;
            }
            switch (action) {
                case "com.android.internal.location.ALARM_WAKEUP": {
                    GnssLocationProvider.this.startNavigating();
                    break;
                }
                case "com.android.internal.location.ALARM_TIMEOUT": {
                    GnssLocationProvider.this.hibernate();
                    break;
                }
                case "android.os.action.POWER_SAVE_MODE_CHANGED": 
                case "android.os.action.DEVICE_IDLE_MODE_CHANGED": 
                case "android.intent.action.SCREEN_OFF": 
                case "android.intent.action.SCREEN_ON": {
                    GnssLocationProvider.this.updateLowPowerMode();
                    break;
                }
                case "android.telephony.action.CARRIER_CONFIG_CHANGED": 
                case "android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED": {
                    GnssLocationProvider.this.subscriptionOrCarrierConfigChanged(context);
                }
            }
        }
    };
    private final INetInitiatedListener mNetInitiatedListener = new INetInitiatedListener.Stub(){

        @Override
        public boolean sendNiResponse(int notificationId, int userResponse) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "sendNiResponse, notifId: " + notificationId + ", response: " + userResponse);
            }
            GnssLocationProvider.this.native_send_ni_response(notificationId, userResponse);
            StatsLog.write(124, 2, notificationId, 0, false, false, false, 0, 0, null, null, 0, 0, GnssLocationProvider.this.mSuplEsEnabled, GnssLocationProvider.this.isGpsEnabled(), userResponse);
            return true;
        }
    };
    private byte[] mNmeaBuffer = new byte[120];

    public GnssStatusListenerHelper getGnssStatusProvider() {
        return this.mGnssStatusListenerHelper;
    }

    public IGpsGeofenceHardware getGpsGeofenceProxy() {
        return this.mGnssGeofenceProvider;
    }

    public GnssMeasurementsProvider getGnssMeasurementsProvider() {
        return this.mGnssMeasurementsProvider;
    }

    public GnssMeasurementCorrectionsProvider getGnssMeasurementCorrectionsProvider() {
        return this.mGnssMeasurementCorrectionsProvider;
    }

    public GnssNavigationMessageProvider getGnssNavigationMessageProvider() {
        return this.mGnssNavigationMessageProvider;
    }

    @Override
    public void onUpdateSatelliteBlacklist(int[] constellations, int[] svids) {
        this.mHandler.post(() -> this.mGnssConfiguration.setSatelliteBlacklist(constellations, svids));
        this.mGnssMetrics.resetConstellationTypes();
    }

    private void subscriptionOrCarrierConfigChanged(Context context) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "received SIM related action: ");
        }
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        int ddSubId = SubscriptionManager.getDefaultDataSubscriptionId();
        String mccMnc = SubscriptionManager.isValidSubscriptionId(ddSubId) ? phone.getSimOperator(ddSubId) : phone.getSimOperator();
        boolean isKeepLppProfile = false;
        if (!TextUtils.isEmpty(mccMnc)) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "SIM MCC/MNC is available: " + mccMnc);
            }
            if (configManager != null) {
                PersistableBundle b;
                PersistableBundle persistableBundle = b = SubscriptionManager.isValidSubscriptionId(ddSubId) ? configManager.getConfigForSubId(ddSubId) : null;
                if (b != null) {
                    isKeepLppProfile = b.getBoolean("gps.persist_lpp_mode_bool");
                }
            }
            if (isKeepLppProfile) {
                this.mGnssConfiguration.loadPropertiesFromCarrierConfig();
                String lpp_profile = this.mGnssConfiguration.getLppProfile();
                if (lpp_profile != null) {
                    SystemProperties.set("persist.sys.gps.lpp", lpp_profile);
                }
            } else {
                SystemProperties.set("persist.sys.gps.lpp", "");
            }
            this.reloadGpsProperties();
        } else if (DEBUG) {
            Log.d("GnssLocationProvider", "SIM MCC/MNC is still not available");
        }
    }

    private void updateLowPowerMode() {
        boolean disableGpsForPowerManager = this.mPowerManager.isDeviceIdleMode();
        PowerSaveState result = this.mPowerManager.getPowerSaveState(1);
        switch (result.locationMode) {
            case 1: 
            case 2: {
                disableGpsForPowerManager |= result.batterySaverEnabled && !this.mPowerManager.isInteractive();
            }
        }
        if (disableGpsForPowerManager != this.mDisableGpsForPowerManager) {
            this.mDisableGpsForPowerManager = disableGpsForPowerManager;
            this.updateEnabled();
            this.updateRequirements();
        }
    }

    public static boolean isSupported() {
        return GnssLocationProvider.native_is_supported();
    }

    private void reloadGpsProperties() {
        this.mGnssConfiguration.reloadGpsProperties();
        this.setSuplHostPort();
        this.mC2KServerHost = this.mGnssConfiguration.getC2KHost();
        this.mC2KServerPort = this.mGnssConfiguration.getC2KPort(0);
        this.mNIHandler.setEmergencyExtensionSeconds(this.mGnssConfiguration.getEsExtensionSec());
        this.mSuplEsEnabled = this.mGnssConfiguration.getSuplEs(0) == 1;
        this.mNIHandler.setSuplEsEnabled(this.mSuplEsEnabled);
        if (this.mGnssVisibilityControl != null) {
            this.mGnssVisibilityControl.onConfigurationUpdated(this.mGnssConfiguration);
        }
    }

    public GnssLocationProvider(Context context, AbstractLocationProvider.LocationProviderManager locationProviderManager, Looper looper) {
        super(context, locationProviderManager);
        this.mLooper = looper;
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = this.mPowerManager.newWakeLock(1, "GnssLocationProvider");
        this.mWakeLock.setReferenceCounted(true);
        this.mDownloadPsdsWakeLock = this.mPowerManager.newWakeLock(1, DOWNLOAD_EXTRA_WAKELOCK_KEY);
        this.mDownloadPsdsWakeLock.setReferenceCounted(true);
        this.mAlarmManager = (AlarmManager)this.mContext.getSystemService("alarm");
        this.mWakeupIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ALARM_WAKEUP), 0);
        this.mTimeoutIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ALARM_TIMEOUT), 0);
        this.mNetworkConnectivityHandler = new GnssNetworkConnectivityHandler(context, this::onNetworkAvailable, looper);
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mHandler = new ProviderHandler(looper);
        this.mGnssConfiguration = new GnssConfiguration(this.mContext);
        this.mGnssCapabilitiesProvider = new GnssCapabilitiesProvider();
        this.mNIHandler = new GpsNetInitiatedHandler(context, this.mNetInitiatedListener, this.mSuplEsEnabled);
        this.sendMessage(13, 0, null);
        this.mGnssStatusListenerHelper = new GnssStatusListenerHelper(this.mContext, this.mHandler){

            @Override
            protected boolean isAvailableInPlatform() {
                return GnssLocationProvider.isSupported();
            }

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isGpsEnabled();
            }
        };
        this.mGnssMeasurementsProvider = new GnssMeasurementsProvider(this.mContext, this.mHandler){

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isGpsEnabled();
            }
        };
        this.mGnssMeasurementCorrectionsProvider = new GnssMeasurementCorrectionsProvider(this.mHandler);
        this.mGnssNavigationMessageProvider = new GnssNavigationMessageProvider(this.mContext, this.mHandler){

            @Override
            protected boolean isGpsEnabled() {
                return GnssLocationProvider.this.isGpsEnabled();
            }
        };
        this.mGnssMetrics = new GnssMetrics(this.mBatteryStats);
        this.mNtpTimeHelper = new NtpTimeHelper(this.mContext, looper, this);
        GnssSatelliteBlacklistHelper gnssSatelliteBlacklistHelper = new GnssSatelliteBlacklistHelper(this.mContext, looper, this);
        this.mHandler.post(gnssSatelliteBlacklistHelper::updateSatelliteBlacklist);
        this.mGnssBatchingProvider = new GnssBatchingProvider();
        this.mGnssGeofenceProvider = new GnssGeofenceProvider();
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (this.getSendingUserId() == -1) {
                    GnssLocationProvider.this.mShutdown = true;
                    GnssLocationProvider.this.updateEnabled();
                }
            }
        }, UserHandle.ALL, new IntentFilter("android.intent.action.ACTION_SHUTDOWN"), null, this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor("location_mode"), true, new ContentObserver(this.mHandler){

            @Override
            public void onChange(boolean selfChange) {
                GnssLocationProvider.this.updateEnabled();
            }
        }, -1);
        this.setProperties(PROPERTIES);
        this.setEnabled(true);
    }

    @Override
    public void injectTime(long time, long timeReference, int uncertainty) {
        this.native_inject_time(time, timeReference, uncertainty);
    }

    private void onNetworkAvailable() {
        this.mNtpTimeHelper.onNetworkAvailable();
        if (this.mDownloadPsdsDataPending == 0 && this.mSupportsPsds) {
            this.psdsDownloadRequest();
        }
    }

    private void handleRequestLocation(boolean independentFromGnss, boolean isUserEmergency) {
        LocationChangeListener locationListener;
        String provider;
        if (this.isRequestLocationRateLimited()) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "RequestLocation is denied due to too frequent requests.");
            }
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        long durationMillis = Settings.Global.getLong(resolver, "gnss_hal_location_request_duration_millis", 10000L);
        if (durationMillis == 0L) {
            Log.i("GnssLocationProvider", "GNSS HAL location request is disabled by Settings.");
            return;
        }
        LocationManager locationManager = (LocationManager)this.mContext.getSystemService("location");
        LocationRequest locationRequest = new LocationRequest().setInterval(1000L).setFastestInterval(1000L);
        if (independentFromGnss) {
            provider = "network";
            locationListener = this.mNetworkLocationListener;
            locationRequest.setQuality(201);
        } else {
            provider = "fused";
            locationListener = this.mFusedLocationListener;
            locationRequest.setQuality(100);
        }
        locationRequest.setProvider(provider);
        if (isUserEmergency && this.mNIHandler.getInEmergency()) {
            locationRequest.setLocationSettingsIgnored(true);
            durationMillis *= 3L;
        }
        Log.i("GnssLocationProvider", String.format("GNSS HAL Requesting location updates from %s provider for %d millis.", provider, durationMillis));
        try {
            locationManager.requestLocationUpdates(locationRequest, locationListener, this.mHandler.getLooper());
            locationListener.mNumLocationUpdateRequest++;
            this.mHandler.postDelayed(() -> {
                if (--locationListener.mNumLocationUpdateRequest == 0) {
                    Log.i("GnssLocationProvider", String.format("Removing location updates from %s provider.", provider));
                    locationManager.removeUpdates(locationListener);
                }
            }, durationMillis);
        }
        catch (IllegalArgumentException e) {
            Log.w("GnssLocationProvider", "Unable to request location.", e);
        }
    }

    private void injectBestLocation(Location location) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "injectBestLocation: " + location);
        }
        int gnssLocationFlags = 1 | (location.hasAltitude() ? 2 : 0) | (location.hasSpeed() ? 4 : 0) | (location.hasBearing() ? 8 : 0) | (location.hasAccuracy() ? 16 : 0) | (location.hasVerticalAccuracy() ? 32 : 0) | (location.hasSpeedAccuracy() ? 64 : 0) | (location.hasBearingAccuracy() ? 128 : 0);
        double latitudeDegrees = location.getLatitude();
        double longitudeDegrees = location.getLongitude();
        double altitudeMeters = location.getAltitude();
        float speedMetersPerSec = location.getSpeed();
        float bearingDegrees = location.getBearing();
        float horizontalAccuracyMeters = location.getAccuracy();
        float verticalAccuracyMeters = location.getVerticalAccuracyMeters();
        float speedAccuracyMetersPerSecond = location.getSpeedAccuracyMetersPerSecond();
        float bearingAccuracyDegrees = location.getBearingAccuracyDegrees();
        long timestamp = location.getTime();
        int elapsedRealtimeFlags = 1 | (location.hasElapsedRealtimeUncertaintyNanos() ? 2 : 0);
        long elapsedRealtimeNanos = location.getElapsedRealtimeNanos();
        double elapsedRealtimeUncertaintyNanos = location.getElapsedRealtimeUncertaintyNanos();
        this.native_inject_best_location(gnssLocationFlags, latitudeDegrees, longitudeDegrees, altitudeMeters, speedMetersPerSec, bearingDegrees, horizontalAccuracyMeters, verticalAccuracyMeters, speedAccuracyMetersPerSecond, bearingAccuracyDegrees, timestamp, elapsedRealtimeFlags, elapsedRealtimeNanos, elapsedRealtimeUncertaintyNanos);
    }

    private boolean isRequestLocationRateLimited() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDownloadPsdsData() {
        if (!this.mSupportsPsds) {
            Log.d("GnssLocationProvider", "handleDownloadPsdsData() called when PSDS not supported");
            return;
        }
        if (this.mDownloadPsdsDataPending == 1) {
            return;
        }
        if (!this.mNetworkConnectivityHandler.isDataNetworkConnected()) {
            this.mDownloadPsdsDataPending = 0;
            return;
        }
        this.mDownloadPsdsDataPending = 1;
        Object object = this.mLock;
        synchronized (object) {
            this.mDownloadPsdsWakeLock.acquire(60000L);
        }
        Log.i("GnssLocationProvider", "WakeLock acquired by handleDownloadPsdsData()");
        AsyncTask.THREAD_POOL_EXECUTOR.execute(() -> {
            GpsPsdsDownloader psdsDownloader = new GpsPsdsDownloader(this.mGnssConfiguration.getProperties());
            byte[] data = psdsDownloader.downloadPsdsData();
            if (data != null) {
                if (DEBUG) {
                    Log.d("GnssLocationProvider", "calling native_inject_psds_data");
                }
                this.native_inject_psds_data(data, data.length);
                this.mPsdsBackOff.reset();
            }
            this.sendMessage(11, 0, null);
            if (data == null) {
                this.mHandler.sendEmptyMessageDelayed(6, this.mPsdsBackOff.nextBackoffMillis());
            }
            Object object = this.mLock;
            synchronized (object) {
                if (this.mDownloadPsdsWakeLock.isHeld()) {
                    try {
                        this.mDownloadPsdsWakeLock.release();
                        if (DEBUG) {
                            Log.d("GnssLocationProvider", "WakeLock released by handleDownloadPsdsData()");
                        }
                    }
                    catch (Exception e) {
                        Log.i("GnssLocationProvider", "Wakelock timeout & release race exception in handleDownloadPsdsData()", e);
                    }
                } else {
                    Log.e("GnssLocationProvider", "WakeLock expired before release in handleDownloadPsdsData()");
                }
            }
        });
    }

    private void handleUpdateLocation(Location location) {
        if (location.hasAccuracy()) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "injectLocation: " + location);
            }
            this.native_inject_location(location.getLatitude(), location.getLongitude(), location.getAccuracy());
        }
    }

    private void setSuplHostPort() {
        this.mSuplServerHost = this.mGnssConfiguration.getSuplHost();
        this.mSuplServerPort = this.mGnssConfiguration.getSuplPort(0);
        if (this.mSuplServerHost != null && this.mSuplServerPort > 0 && this.mSuplServerPort <= 65535) {
            this.native_set_agps_server(1, this.mSuplServerHost, this.mSuplServerPort);
        }
    }

    private int getSuplMode(boolean agpsEnabled) {
        if (agpsEnabled) {
            int suplMode = this.mGnssConfiguration.getSuplMode(0);
            if (suplMode == 0) {
                return 0;
            }
            if (this.hasCapability(2) && (suplMode & 1) != 0) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGpsEnabled(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mGpsEnabled = enabled;
        }
    }

    private void handleEnable() {
        boolean inited;
        if (DEBUG) {
            Log.d("GnssLocationProvider", "handleEnable");
        }
        if (inited = this.native_init()) {
            this.setGpsEnabled(true);
            this.mSupportsPsds = this.native_supports_psds();
            if (this.mSuplServerHost != null) {
                this.native_set_agps_server(1, this.mSuplServerHost, this.mSuplServerPort);
            }
            if (this.mC2KServerHost != null) {
                this.native_set_agps_server(2, this.mC2KServerHost, this.mC2KServerPort);
            }
            this.mGnssMeasurementsProvider.onGpsEnabledChanged();
            this.mGnssNavigationMessageProvider.onGpsEnabledChanged();
            this.mGnssBatchingProvider.enable();
            if (this.mGnssVisibilityControl != null) {
                this.mGnssVisibilityControl.onGpsEnabledChanged(true);
            }
        } else {
            this.setGpsEnabled(false);
            Log.w("GnssLocationProvider", "Failed to enable location provider");
        }
    }

    private void handleDisable() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "handleDisable");
        }
        this.setGpsEnabled(false);
        this.updateClientUids(new WorkSource());
        this.stopNavigating();
        this.mAlarmManager.cancel(this.mWakeupIntent);
        this.mAlarmManager.cancel(this.mTimeoutIntent);
        if (this.mGnssVisibilityControl != null) {
            this.mGnssVisibilityControl.onGpsEnabledChanged(false);
        }
        this.mGnssBatchingProvider.disable();
        this.native_cleanup();
        this.mGnssMeasurementsProvider.onGpsEnabledChanged();
        this.mGnssNavigationMessageProvider.onGpsEnabledChanged();
    }

    private void updateEnabled() {
        boolean enabled = this.mContext.getSystemService(LocationManager.class).isLocationEnabledForUser(UserHandle.CURRENT);
        enabled &= !this.mDisableGpsForPowerManager;
        enabled |= this.mProviderRequest != null && this.mProviderRequest.reportLocation && this.mProviderRequest.locationSettingsIgnored;
        if ((enabled &= !this.mShutdown) == this.isGpsEnabled()) {
            return;
        }
        if (enabled) {
            this.handleEnable();
        } else {
            this.handleDisable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isGpsEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mGpsEnabled;
        }
    }

    @Override
    public int getStatus(Bundle extras) {
        this.mLocationExtras.setBundle(extras);
        return this.mStatus;
    }

    private void updateStatus(int status) {
        if (status != this.mStatus) {
            this.mStatus = status;
            this.mStatusUpdateTime = SystemClock.elapsedRealtime();
        }
    }

    @Override
    public long getStatusUpdateTime() {
        return this.mStatusUpdateTime;
    }

    @Override
    public void setRequest(ProviderRequest request, WorkSource source) {
        this.sendMessage(3, 0, new GpsRequest(request, source));
    }

    private void handleSetRequest(ProviderRequest request, WorkSource source) {
        this.mProviderRequest = request;
        this.mWorkSource = source;
        this.updateEnabled();
        this.updateRequirements();
    }

    private void updateRequirements() {
        if (this.mProviderRequest == null || this.mWorkSource == null) {
            return;
        }
        if (DEBUG) {
            Log.d("GnssLocationProvider", "setRequest " + this.mProviderRequest);
        }
        if (this.mProviderRequest.reportLocation && this.isGpsEnabled()) {
            this.updateClientUids(this.mWorkSource);
            this.mFixInterval = (int)this.mProviderRequest.interval;
            this.mLowPowerMode = this.mProviderRequest.lowPowerMode;
            if ((long)this.mFixInterval != this.mProviderRequest.interval) {
                Log.w("GnssLocationProvider", "interval overflow: " + this.mProviderRequest.interval);
                this.mFixInterval = Integer.MAX_VALUE;
            }
            if (this.mStarted && this.hasCapability(1)) {
                if (!this.setPositionMode(this.mPositionMode, 0, this.mFixInterval, 0, 0, this.mLowPowerMode)) {
                    Log.e("GnssLocationProvider", "set_position_mode failed in updateRequirements");
                }
            } else if (!this.mStarted) {
                this.startNavigating();
            } else {
                this.mAlarmManager.cancel(this.mTimeoutIntent);
                if (this.mFixInterval >= 60000) {
                    this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 60000L, this.mTimeoutIntent);
                }
            }
        } else {
            this.updateClientUids(new WorkSource());
            this.stopNavigating();
            this.mAlarmManager.cancel(this.mWakeupIntent);
            this.mAlarmManager.cancel(this.mTimeoutIntent);
        }
    }

    private boolean setPositionMode(int mode, int recurrence, int minInterval, int preferredAccuracy, int preferredTime, boolean lowPowerMode) {
        GnssPositionMode positionMode = new GnssPositionMode(mode, recurrence, minInterval, preferredAccuracy, preferredTime, lowPowerMode);
        if (this.mLastPositionMode != null && this.mLastPositionMode.equals(positionMode)) {
            return true;
        }
        boolean result = this.native_set_position_mode(mode, recurrence, minInterval, preferredAccuracy, preferredTime, lowPowerMode);
        this.mLastPositionMode = result ? positionMode : null;
        return result;
    }

    private void updateClientUids(WorkSource source) {
        WorkSource[] changes;
        if (source.equals(this.mClientSource)) {
            return;
        }
        try {
            this.mBatteryStats.noteGpsChanged(this.mClientSource, source);
        }
        catch (RemoteException e) {
            Log.w("GnssLocationProvider", "RemoteException", e);
        }
        ArrayList<WorkSource.WorkChain>[] diffs = WorkSource.diffChains(this.mClientSource, source);
        if (diffs != null) {
            ArrayList<WorkSource.WorkChain> newChains = diffs[0];
            ArrayList<WorkSource.WorkChain> goneChains = diffs[1];
            if (newChains != null) {
                for (WorkSource.WorkChain newChain : newChains) {
                    this.mAppOps.startOpNoThrow(2, newChain.getAttributionUid(), newChain.getAttributionTag());
                }
            }
            if (goneChains != null) {
                for (WorkSource.WorkChain goneChain : goneChains) {
                    this.mAppOps.finishOp(2, goneChain.getAttributionUid(), goneChain.getAttributionTag());
                }
            }
            this.mClientSource.transferWorkChains(source);
        }
        if ((changes = this.mClientSource.setReturningDiffs(source)) != null) {
            WorkSource newWork = changes[0];
            WorkSource goneWork = changes[1];
            if (newWork != null) {
                for (int i = 0; i < newWork.size(); ++i) {
                    this.mAppOps.startOpNoThrow(2, newWork.get(i), newWork.getName(i));
                }
            }
            if (goneWork != null) {
                for (int i = 0; i < goneWork.size(); ++i) {
                    this.mAppOps.finishOp(2, goneWork.get(i), goneWork.getName(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendExtraCommand(String command, Bundle extras) {
        long identity = Binder.clearCallingIdentity();
        try {
            if ("delete_aiding_data".equals(command)) {
                this.deleteAidingData(extras);
            } else if ("force_time_injection".equals(command)) {
                this.requestUtcTime();
            } else if ("force_psds_injection".equals(command)) {
                if (this.mSupportsPsds) {
                    this.psdsDownloadRequest();
                }
            } else {
                Log.w("GnssLocationProvider", "sendExtraCommand: unknown command " + command);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void deleteAidingData(Bundle extras) {
        int flags;
        if (extras == null) {
            flags = 65535;
        } else {
            flags = 0;
            if (extras.getBoolean("ephemeris")) {
                flags |= 1;
            }
            if (extras.getBoolean("almanac")) {
                flags |= 2;
            }
            if (extras.getBoolean("position")) {
                flags |= 4;
            }
            if (extras.getBoolean("time")) {
                flags |= 8;
            }
            if (extras.getBoolean("iono")) {
                flags |= 0x10;
            }
            if (extras.getBoolean("utc")) {
                flags |= 0x20;
            }
            if (extras.getBoolean("health")) {
                flags |= 0x40;
            }
            if (extras.getBoolean("svdir")) {
                flags |= 0x80;
            }
            if (extras.getBoolean("svsteer")) {
                flags |= 0x100;
            }
            if (extras.getBoolean("sadata")) {
                flags |= 0x200;
            }
            if (extras.getBoolean("rti")) {
                flags |= 0x400;
            }
            if (extras.getBoolean("celldb-info")) {
                flags |= 0x8000;
            }
            if (extras.getBoolean("all")) {
                flags |= 0xFFFF;
            }
        }
        if (flags != 0) {
            this.native_delete_aiding_data(flags);
        }
    }

    private void startNavigating() {
        if (!this.mStarted) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "startNavigating");
            }
            this.mTimeToFirstFix = 0;
            this.mLastFixTime = 0L;
            this.setStarted(true);
            this.mPositionMode = 0;
            if (this.mItarSpeedLimitExceeded) {
                Log.i("GnssLocationProvider", "startNavigating with ITAR limit in place. Output limited  until slow enough speed reported.");
            }
            boolean agpsEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "assisted_gps_enabled", 1) != 0;
            this.mPositionMode = this.getSuplMode(agpsEnabled);
            if (DEBUG) {
                String mode;
                switch (this.mPositionMode) {
                    case 0: {
                        mode = "standalone";
                        break;
                    }
                    case 2: {
                        mode = "MS_ASSISTED";
                        break;
                    }
                    case 1: {
                        mode = "MS_BASED";
                        break;
                    }
                    default: {
                        mode = "unknown";
                    }
                }
                Log.d("GnssLocationProvider", "setting position_mode to " + mode);
            }
            int interval = this.hasCapability(1) ? this.mFixInterval : 1000;
            this.mLowPowerMode = this.mProviderRequest.lowPowerMode;
            if (!this.setPositionMode(this.mPositionMode, 0, interval, 0, 0, this.mLowPowerMode)) {
                this.setStarted(false);
                Log.e("GnssLocationProvider", "set_position_mode failed in startNavigating()");
                return;
            }
            if (!this.native_start()) {
                this.setStarted(false);
                Log.e("GnssLocationProvider", "native_start failed in startNavigating()");
                return;
            }
            this.updateStatus(1);
            this.mLocationExtras.reset();
            this.mFixRequestTime = SystemClock.elapsedRealtime();
            if (!this.hasCapability(1) && this.mFixInterval >= 60000) {
                this.mAlarmManager.set(2, SystemClock.elapsedRealtime() + 60000L, this.mTimeoutIntent);
            }
        }
    }

    private void stopNavigating() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "stopNavigating");
        }
        if (this.mStarted) {
            this.setStarted(false);
            this.native_stop();
            this.mLastFixTime = 0L;
            this.mLastPositionMode = null;
            this.updateStatus(1);
            this.mLocationExtras.reset();
        }
    }

    private void setStarted(boolean started) {
        if (this.mStarted != started) {
            this.mStarted = started;
            this.mStartedChangedElapsedRealtime = SystemClock.elapsedRealtime();
        }
    }

    private void hibernate() {
        this.stopNavigating();
        this.mAlarmManager.cancel(this.mTimeoutIntent);
        this.mAlarmManager.cancel(this.mWakeupIntent);
        long now = SystemClock.elapsedRealtime();
        this.mAlarmManager.set(2, now + (long)this.mFixInterval, this.mWakeupIntent);
    }

    private boolean hasCapability(int capability) {
        return (this.mTopHalCapabilities & capability) != 0;
    }

    private void reportLocation(boolean hasLatLong, Location location) {
        this.sendMessage(17, hasLatLong ? 1 : 0, location);
    }

    private void handleReportLocation(boolean hasLatLong, Location location) {
        if (location.hasSpeed()) {
            boolean bl = this.mItarSpeedLimitExceeded = location.getSpeed() > 400.0f;
        }
        if (this.mItarSpeedLimitExceeded) {
            Log.i("GnssLocationProvider", "Hal reported a speed in excess of ITAR limit.  GPS/GNSS Navigation output blocked.");
            if (this.mStarted) {
                this.mGnssMetrics.logReceivedLocationStatus(false);
            }
            return;
        }
        if (VERBOSE) {
            Log.v("GnssLocationProvider", "reportLocation " + location.toString());
        }
        location.setExtras(this.mLocationExtras.getBundle());
        this.reportLocation(location);
        if (this.mStarted) {
            this.mGnssMetrics.logReceivedLocationStatus(hasLatLong);
            if (hasLatLong) {
                if (location.hasAccuracy()) {
                    this.mGnssMetrics.logPositionAccuracyMeters(location.getAccuracy());
                }
                if (this.mTimeToFirstFix > 0) {
                    int timeBetweenFixes = (int)(SystemClock.elapsedRealtime() - this.mLastFixTime);
                    this.mGnssMetrics.logMissedReports(this.mFixInterval, timeBetweenFixes);
                }
            }
        } else {
            long locationAfterStartedFalseMillis = SystemClock.elapsedRealtime() - this.mStartedChangedElapsedRealtime;
            if (locationAfterStartedFalseMillis > 2000L) {
                String logMessage = "Unexpected GNSS Location report " + TimeUtils.formatDuration(locationAfterStartedFalseMillis) + " after location turned off";
                if (locationAfterStartedFalseMillis > 15000L) {
                    Log.e("GnssLocationProvider", logMessage);
                } else {
                    Log.w("GnssLocationProvider", logMessage);
                }
            }
        }
        this.mLastFixTime = SystemClock.elapsedRealtime();
        if (this.mTimeToFirstFix == 0 && hasLatLong) {
            this.mTimeToFirstFix = (int)(this.mLastFixTime - this.mFixRequestTime);
            if (DEBUG) {
                Log.d("GnssLocationProvider", "TTFF: " + this.mTimeToFirstFix);
            }
            if (this.mStarted) {
                this.mGnssMetrics.logTimeToFirstFixMilliSecs(this.mTimeToFirstFix);
            }
            this.mGnssStatusListenerHelper.onFirstFix(this.mTimeToFirstFix);
        }
        if (this.mStarted && this.mStatus != 2) {
            if (!this.hasCapability(1) && this.mFixInterval < 60000) {
                this.mAlarmManager.cancel(this.mTimeoutIntent);
            }
            this.updateStatus(2);
        }
        if (!this.hasCapability(1) && this.mStarted && this.mFixInterval > 10000) {
            if (DEBUG) {
                Log.d("GnssLocationProvider", "got fix, hibernating");
            }
            this.hibernate();
        }
    }

    private void reportStatus(int status) {
        if (DEBUG) {
            Log.v("GnssLocationProvider", "reportStatus status: " + status);
        }
        boolean wasNavigating = this.mNavigating;
        switch (status) {
            case 1: {
                this.mNavigating = true;
                break;
            }
            case 2: {
                this.mNavigating = false;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mNavigating = false;
            }
        }
        if (wasNavigating != this.mNavigating) {
            this.mGnssStatusListenerHelper.onStatusChanged(this.mNavigating);
        }
    }

    private void reportSvStatus(int svCount, int[] svidWithFlags, float[] cn0s, float[] svElevations, float[] svAzimuths, float[] svCarrierFreqs) {
        SvStatusInfo svStatusInfo = new SvStatusInfo();
        svStatusInfo.mSvCount = svCount;
        SvStatusInfo.access$1302(svStatusInfo, svidWithFlags);
        SvStatusInfo.access$1402(svStatusInfo, cn0s);
        SvStatusInfo.access$1502(svStatusInfo, svElevations);
        SvStatusInfo.access$1602(svStatusInfo, svAzimuths);
        SvStatusInfo.access$1702(svStatusInfo, svCarrierFreqs);
        this.sendMessage(18, 0, svStatusInfo);
    }

    private void handleReportSvStatus(SvStatusInfo info) {
        this.mGnssStatusListenerHelper.onSvStatusChanged(info.mSvCount, info.mSvidWithFlags, info.mCn0s, info.mSvElevations, info.mSvAzimuths, info.mSvCarrierFreqs);
        this.mGnssMetrics.logCn0(info.mCn0s, info.mSvCount);
        if (VERBOSE) {
            Log.v("GnssLocationProvider", "SV count: " + info.mSvCount);
        }
        int usedInFixCount = 0;
        int maxCn0 = 0;
        int meanCn0 = 0;
        for (int i = 0; i < info.mSvCount; ++i) {
            if ((info.mSvidWithFlags[i] & 4) != 0) {
                ++usedInFixCount;
                if (info.mCn0s[i] > (float)maxCn0) {
                    maxCn0 = (int)info.mCn0s[i];
                }
                meanCn0 = (int)((float)meanCn0 + info.mCn0s[i]);
            }
            if (VERBOSE) {
                Log.v("GnssLocationProvider", "svid: " + (info.mSvidWithFlags[i] >> 8) + " cn0: " + info.mCn0s[i] + " elev: " + info.mSvElevations[i] + " azimuth: " + info.mSvAzimuths[i] + " carrier frequency: " + info.mSvCarrierFreqs[i] + ((info.mSvidWithFlags[i] & 1) == 0 ? "  " : " E") + ((info.mSvidWithFlags[i] & 2) == 0 ? "  " : " A") + ((info.mSvidWithFlags[i] & 4) == 0 ? "" : "U") + ((info.mSvidWithFlags[i] & 8) == 0 ? "" : "F"));
            }
            if ((info.mSvidWithFlags[i] & 4) == 0) continue;
            int constellationType = info.mSvidWithFlags[i] >> 4 & 0xF;
            this.mGnssMetrics.logConstellationType(constellationType);
        }
        if (usedInFixCount > 0) {
            meanCn0 /= usedInFixCount;
        }
        this.mLocationExtras.set(usedInFixCount, meanCn0, maxCn0);
        if (this.mNavigating && this.mStatus == 2 && this.mLastFixTime > 0L && SystemClock.elapsedRealtime() - this.mLastFixTime > 10000L) {
            this.updateStatus(1);
        }
    }

    private void reportAGpsStatus(int agpsType, int agpsStatus, byte[] suplIpAddr) {
        this.mNetworkConnectivityHandler.onReportAGpsStatus(agpsType, agpsStatus, suplIpAddr);
    }

    private void reportNmea(long timestamp) {
        if (!this.mItarSpeedLimitExceeded) {
            int length = this.native_read_nmea(this.mNmeaBuffer, this.mNmeaBuffer.length);
            String nmea = new String(this.mNmeaBuffer, 0, length);
            this.mGnssStatusListenerHelper.onNmeaReceived(timestamp, nmea);
        }
    }

    private void reportMeasurementData(GnssMeasurementsEvent event) {
        if (!this.mItarSpeedLimitExceeded) {
            this.mHandler.post(() -> this.mGnssMeasurementsProvider.onMeasurementsAvailable(event));
        }
    }

    private void reportNavigationMessage(GnssNavigationMessage event) {
        if (!this.mItarSpeedLimitExceeded) {
            this.mHandler.post(() -> this.mGnssNavigationMessageProvider.onNavigationMessageAvailable(event));
        }
    }

    private void setTopHalCapabilities(int topHalCapabilities) {
        this.mHandler.post(() -> {
            this.mTopHalCapabilities = topHalCapabilities;
            if (this.hasCapability(16)) {
                this.mNtpTimeHelper.enablePeriodicTimeInjection();
                this.requestUtcTime();
            }
            this.mGnssMeasurementsProvider.onCapabilitiesUpdated(this.hasCapability(64));
            this.mGnssNavigationMessageProvider.onCapabilitiesUpdated(this.hasCapability(128));
            this.restartRequests();
            this.mGnssCapabilitiesProvider.setTopHalCapabilities(this.mTopHalCapabilities);
        });
    }

    private void setSubHalMeasurementCorrectionsCapabilities(int subHalCapabilities) {
        this.mHandler.post(() -> {
            if (!this.mGnssMeasurementCorrectionsProvider.onCapabilitiesUpdated(subHalCapabilities)) {
                return;
            }
            this.mGnssCapabilitiesProvider.setSubHalMeasurementCorrectionsCapabilities(subHalCapabilities);
        });
    }

    private void restartRequests() {
        Log.i("GnssLocationProvider", "restartRequests");
        this.restartLocationRequest();
        this.mGnssMeasurementsProvider.resumeIfStarted();
        this.mGnssNavigationMessageProvider.resumeIfStarted();
        this.mGnssBatchingProvider.resumeIfStarted();
        this.mGnssGeofenceProvider.resumeIfStarted();
    }

    private void restartLocationRequest() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "restartLocationRequest");
        }
        this.setStarted(false);
        this.updateRequirements();
    }

    private void setGnssYearOfHardware(int yearOfHardware) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "setGnssYearOfHardware called with " + yearOfHardware);
        }
        this.mHardwareYear = yearOfHardware;
    }

    private void setGnssHardwareModelName(String modelName) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "setGnssModelName called with " + modelName);
        }
        this.mHardwareModelName = modelName;
    }

    private void reportGnssServiceDied() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "reportGnssServiceDied");
        }
        this.mHandler.post(() -> {
            this.setupNativeGnssService(true);
            if (this.isGpsEnabled()) {
                this.setGpsEnabled(false);
                this.updateEnabled();
                this.reloadGpsProperties();
            }
        });
    }

    public GnssSystemInfoProvider getGnssSystemInfoProvider() {
        return new GnssSystemInfoProvider(){

            @Override
            public int getGnssYearOfHardware() {
                return GnssLocationProvider.this.mHardwareYear;
            }

            @Override
            public String getGnssHardwareModelName() {
                return GnssLocationProvider.this.mHardwareModelName;
            }
        };
    }

    public GnssBatchingProvider getGnssBatchingProvider() {
        return this.mGnssBatchingProvider;
    }

    public GnssMetricsProvider getGnssMetricsProvider() {
        return () -> this.mGnssMetrics.dumpGnssMetricsAsProtoString();
    }

    public GnssCapabilitiesProvider getGnssCapabilitiesProvider() {
        return this.mGnssCapabilitiesProvider;
    }

    private void reportLocationBatch(Location[] locationArray) {
        ArrayList<Location> locations = new ArrayList<Location>(Arrays.asList(locationArray));
        if (DEBUG) {
            Log.d("GnssLocationProvider", "Location batch of size " + locationArray.length + " reported");
        }
        this.reportLocation(locations);
    }

    private void psdsDownloadRequest() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "psdsDownloadRequest");
        }
        this.sendMessage(6, 0, null);
    }

    private static int getGeofenceStatus(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case -149: {
                return 5;
            }
            case -101: {
                return 2;
            }
            case -103: {
                return 4;
            }
            case 100: {
                return 1;
            }
            case -102: {
                return 3;
            }
        }
        return -1;
    }

    private void reportGeofenceTransition(int geofenceId, Location location, int transition2, long transitionTimestamp) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            this.mGeofenceHardwareImpl.reportGeofenceTransition(geofenceId, location, transition2, transitionTimestamp, 0, FusedBatchOptions.SourceTechnologies.GNSS);
        });
    }

    private void reportGeofenceStatus(int status, Location location) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            int monitorStatus = 1;
            if (status == 2) {
                monitorStatus = 0;
            }
            this.mGeofenceHardwareImpl.reportGeofenceMonitorStatus(0, monitorStatus, location, FusedBatchOptions.SourceTechnologies.GNSS);
        });
    }

    private void reportGeofenceAddStatus(int geofenceId, int status) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            this.mGeofenceHardwareImpl.reportGeofenceAddStatus(geofenceId, GnssLocationProvider.getGeofenceStatus(status));
        });
    }

    private void reportGeofenceRemoveStatus(int geofenceId, int status) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            this.mGeofenceHardwareImpl.reportGeofenceRemoveStatus(geofenceId, GnssLocationProvider.getGeofenceStatus(status));
        });
    }

    private void reportGeofencePauseStatus(int geofenceId, int status) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            this.mGeofenceHardwareImpl.reportGeofencePauseStatus(geofenceId, GnssLocationProvider.getGeofenceStatus(status));
        });
    }

    private void reportGeofenceResumeStatus(int geofenceId, int status) {
        this.mHandler.post(() -> {
            if (this.mGeofenceHardwareImpl == null) {
                this.mGeofenceHardwareImpl = GeofenceHardwareImpl.getInstance(this.mContext);
            }
            this.mGeofenceHardwareImpl.reportGeofenceResumeStatus(geofenceId, GnssLocationProvider.getGeofenceStatus(status));
        });
    }

    public INetInitiatedListener getNetInitiatedListener() {
        return this.mNetInitiatedListener;
    }

    public void reportNiNotification(int notificationId, int niType, int notifyFlags, int timeout, int defaultResponse, String requestorId, String text, int requestorIdEncoding, int textEncoding) {
        Log.i("GnssLocationProvider", "reportNiNotification: entered");
        Log.i("GnssLocationProvider", "notificationId: " + notificationId + ", niType: " + niType + ", notifyFlags: " + notifyFlags + ", timeout: " + timeout + ", defaultResponse: " + defaultResponse);
        Log.i("GnssLocationProvider", "requestorId: " + requestorId + ", text: " + text + ", requestorIdEncoding: " + requestorIdEncoding + ", textEncoding: " + textEncoding);
        GpsNetInitiatedHandler.GpsNiNotification notification = new GpsNetInitiatedHandler.GpsNiNotification();
        notification.notificationId = notificationId;
        notification.niType = niType;
        notification.needNotify = (notifyFlags & 1) != 0;
        notification.needVerify = (notifyFlags & 2) != 0;
        notification.privacyOverride = (notifyFlags & 4) != 0;
        notification.timeout = timeout;
        notification.defaultResponse = defaultResponse;
        notification.requestorId = requestorId;
        notification.text = text;
        notification.requestorIdEncoding = requestorIdEncoding;
        notification.textEncoding = textEncoding;
        this.mNIHandler.handleNiNotification(notification);
        StatsLog.write(124, 1, notification.notificationId, notification.niType, notification.needNotify, notification.needVerify, notification.privacyOverride, notification.timeout, notification.defaultResponse, notification.requestorId, notification.text, notification.requestorIdEncoding, notification.textEncoding, this.mSuplEsEnabled, this.isGpsEnabled(), 0);
    }

    private void requestSetID(int flags) {
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        int type = 0;
        String setId = null;
        int ddSubId = SubscriptionManager.getDefaultDataSubscriptionId();
        if ((flags & 1) == 1) {
            if (SubscriptionManager.isValidSubscriptionId(ddSubId)) {
                setId = phone.getSubscriberId(ddSubId);
            }
            if (setId == null) {
                setId = phone.getSubscriberId();
            }
            if (setId != null) {
                type = 1;
            }
        } else if ((flags & 2) == 2) {
            if (SubscriptionManager.isValidSubscriptionId(ddSubId)) {
                setId = phone.getLine1Number(ddSubId);
            }
            if (setId == null) {
                setId = phone.getLine1Number();
            }
            if (setId != null) {
                type = 2;
            }
        }
        this.native_agps_set_id(type, setId == null ? "" : setId);
    }

    private void requestLocation(boolean independentFromGnss, boolean isUserEmergency) {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "requestLocation. independentFromGnss: " + independentFromGnss + ", isUserEmergency: " + isUserEmergency);
        }
        this.sendMessage(16, independentFromGnss ? 1 : 0, isUserEmergency);
    }

    private void requestUtcTime() {
        if (DEBUG) {
            Log.d("GnssLocationProvider", "utcTimeRequest");
        }
        this.sendMessage(5, 0, null);
    }

    private void requestRefLocation() {
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        int phoneType = phone.getPhoneType();
        if (phoneType == 1) {
            GsmCellLocation gsm_cell = (GsmCellLocation)phone.getCellLocation();
            if (gsm_cell != null && phone.getNetworkOperator() != null && phone.getNetworkOperator().length() > 3) {
                int mcc = Integer.parseInt(phone.getNetworkOperator().substring(0, 3));
                int mnc = Integer.parseInt(phone.getNetworkOperator().substring(3));
                int networkType = phone.getNetworkType();
                int type = networkType == 3 || networkType == 8 || networkType == 9 || networkType == 10 || networkType == 15 ? 2 : 1;
                this.native_agps_set_ref_location_cellid(type, mcc, mnc, gsm_cell.getLac(), gsm_cell.getCid());
            } else {
                Log.e("GnssLocationProvider", "Error getting cell location info.");
            }
        } else if (phoneType == 2) {
            Log.e("GnssLocationProvider", "CDMA not supported.");
        }
    }

    private void reportNfwNotification(String proxyAppPackageName, byte protocolStack, String otherProtocolStackName, byte requestor, String requestorId, byte responseType, boolean inEmergencyMode, boolean isCachedLocation) {
        if (this.mGnssVisibilityControl == null) {
            Log.e("GnssLocationProvider", "reportNfwNotification: mGnssVisibilityControl is not initialized.");
            return;
        }
        this.mGnssVisibilityControl.reportNfwNotification(proxyAppPackageName, protocolStack, otherProtocolStackName, requestor, requestorId, responseType, inEmergencyMode, isCachedLocation);
    }

    boolean isInEmergencySession() {
        return this.mNIHandler.getInEmergency();
    }

    private void sendMessage(int message, int arg, Object obj) {
        this.mWakeLock.acquire();
        if (DEBUG) {
            Log.d("GnssLocationProvider", "WakeLock acquired by sendMessage(" + this.messageIdAsString(message) + ", " + arg + ", " + obj + ")");
        }
        this.mHandler.obtainMessage(message, arg, 1, obj).sendToTarget();
    }

    private String messageIdAsString(int message) {
        switch (message) {
            case 3: {
                return "SET_REQUEST";
            }
            case 5: {
                return "INJECT_NTP_TIME";
            }
            case 16: {
                return "REQUEST_LOCATION";
            }
            case 6: {
                return "DOWNLOAD_PSDS_DATA";
            }
            case 11: {
                return "DOWNLOAD_PSDS_DATA_FINISHED";
            }
            case 7: {
                return "UPDATE_LOCATION";
            }
            case 13: {
                return "INITIALIZE_HANDLER";
            }
            case 17: {
                return "REPORT_LOCATION";
            }
            case 18: {
                return "REPORT_SV_STATUS";
            }
        }
        return "<Unknown>";
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        StringBuilder s = new StringBuilder();
        s.append("  mStarted=").append(this.mStarted).append("   (changed ");
        TimeUtils.formatDuration(SystemClock.elapsedRealtime() - this.mStartedChangedElapsedRealtime, s);
        s.append(" ago)").append('\n');
        s.append("  mFixInterval=").append(this.mFixInterval).append('\n');
        s.append("  mLowPowerMode=").append(this.mLowPowerMode).append('\n');
        s.append("  mGnssMeasurementsProvider.isRegistered()=").append(this.mGnssMeasurementsProvider.isRegistered()).append('\n');
        s.append("  mGnssNavigationMessageProvider.isRegistered()=").append(this.mGnssNavigationMessageProvider.isRegistered()).append('\n');
        s.append("  mDisableGpsForPowerManager=").append(this.mDisableGpsForPowerManager).append('\n');
        s.append("  mTopHalCapabilities=0x").append(Integer.toHexString(this.mTopHalCapabilities));
        s.append(" ( ");
        if (this.hasCapability(1)) {
            s.append("SCHEDULING ");
        }
        if (this.hasCapability(2)) {
            s.append("MSB ");
        }
        if (this.hasCapability(4)) {
            s.append("MSA ");
        }
        if (this.hasCapability(8)) {
            s.append("SINGLE_SHOT ");
        }
        if (this.hasCapability(16)) {
            s.append("ON_DEMAND_TIME ");
        }
        if (this.hasCapability(32)) {
            s.append("GEOFENCING ");
        }
        if (this.hasCapability(64)) {
            s.append("MEASUREMENTS ");
        }
        if (this.hasCapability(128)) {
            s.append("NAV_MESSAGES ");
        }
        if (this.hasCapability(256)) {
            s.append("LOW_POWER_MODE ");
        }
        if (this.hasCapability(512)) {
            s.append("SATELLITE_BLACKLIST ");
        }
        if (this.hasCapability(1024)) {
            s.append("MEASUREMENT_CORRECTIONS ");
        }
        s.append(")\n");
        if (this.hasCapability(1024)) {
            s.append("  SubHal=MEASUREMENT_CORRECTIONS[");
            s.append(this.mGnssMeasurementCorrectionsProvider.toStringCapabilities());
            s.append("]\n");
        }
        s.append(this.mGnssMetrics.dumpGnssMetricsAsText());
        s.append("  native internal state: ").append(this.native_get_internal_state());
        s.append("\n");
        pw.append(s);
    }

    private void setupNativeGnssService(boolean reinitializeGnssServiceHandle) {
        GnssLocationProvider.native_init_once(reinitializeGnssServiceHandle);
        boolean isInitialized = this.native_init();
        if (!isInitialized) {
            Log.w("GnssLocationProvider", "Native initialization failed.");
        } else {
            this.native_cleanup();
        }
    }

    private static native void class_init_native();

    private static native boolean native_is_supported();

    private static native boolean native_is_gnss_visibility_control_supported();

    private static native void native_init_once(boolean var0);

    private native boolean native_init();

    private native void native_cleanup();

    private native boolean native_set_position_mode(int var1, int var2, int var3, int var4, int var5, boolean var6);

    private native boolean native_start();

    private native boolean native_stop();

    private native void native_delete_aiding_data(int var1);

    private native int native_read_nmea(byte[] var1, int var2);

    private native void native_inject_best_location(int var1, double var2, double var4, double var6, float var8, float var9, float var10, float var11, float var12, float var13, long var14, int var16, long var17, double var19);

    private native void native_inject_location(double var1, double var3, float var5);

    private native void native_inject_time(long var1, long var3, int var5);

    private native boolean native_supports_psds();

    private native void native_inject_psds_data(byte[] var1, int var2);

    private native String native_get_internal_state();

    private native void native_agps_ni_message(byte[] var1, int var2);

    private native void native_set_agps_server(int var1, String var2, int var3);

    private native void native_send_ni_response(int var1, int var2);

    private native void native_agps_set_ref_location_cellid(int var1, int var2, int var3, int var4, int var5);

    private native void native_agps_set_id(int var1, String var2);

    static {
        GnssLocationProvider.class_init_native();
    }

    private final class FusedLocationListener
    extends LocationChangeListener {
        private FusedLocationListener() {
        }

        @Override
        public void onLocationChanged(Location location) {
            if ("fused".equals(location.getProvider())) {
                GnssLocationProvider.this.injectBestLocation(location);
            }
        }
    }

    private final class NetworkLocationListener
    extends LocationChangeListener {
        private NetworkLocationListener() {
        }

        @Override
        public void onLocationChanged(Location location) {
            if ("network".equals(location.getProvider())) {
                GnssLocationProvider.this.handleUpdateLocation(location);
            }
        }
    }

    private abstract class LocationChangeListener
    implements LocationListener {
        private int mNumLocationUpdateRequest;

        private LocationChangeListener() {
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    }

    private final class ProviderHandler
    extends Handler {
        public ProviderHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            int message = msg.what;
            switch (message) {
                case 3: {
                    GpsRequest gpsRequest = (GpsRequest)msg.obj;
                    GnssLocationProvider.this.handleSetRequest(gpsRequest.request, gpsRequest.source);
                    break;
                }
                case 5: {
                    GnssLocationProvider.this.mNtpTimeHelper.retrieveAndInjectNtpTime();
                    break;
                }
                case 16: {
                    GnssLocationProvider.this.handleRequestLocation(msg.arg1 == 1, (Boolean)msg.obj);
                    break;
                }
                case 6: {
                    GnssLocationProvider.this.handleDownloadPsdsData();
                    break;
                }
                case 11: {
                    GnssLocationProvider.this.mDownloadPsdsDataPending = 2;
                    break;
                }
                case 7: {
                    GnssLocationProvider.this.handleUpdateLocation((Location)msg.obj);
                    break;
                }
                case 13: {
                    this.handleInitialize();
                    break;
                }
                case 17: {
                    GnssLocationProvider.this.handleReportLocation(msg.arg1 == 1, (Location)msg.obj);
                    break;
                }
                case 18: {
                    GnssLocationProvider.this.handleReportSvStatus((SvStatusInfo)msg.obj);
                }
            }
            if (msg.arg2 == 1) {
                GnssLocationProvider.this.mWakeLock.release();
                if (DEBUG) {
                    Log.d("GnssLocationProvider", "WakeLock released by handleMessage(" + GnssLocationProvider.this.messageIdAsString(message) + ", " + msg.arg1 + ", " + msg.obj + ")");
                }
            }
        }

        private void handleInitialize() {
            GnssLocationProvider.this.setupNativeGnssService(false);
            if (GnssLocationProvider.native_is_gnss_visibility_control_supported()) {
                GnssLocationProvider.this.mGnssVisibilityControl = new GnssVisibilityControl(GnssLocationProvider.this.mContext, GnssLocationProvider.this.mLooper, GnssLocationProvider.this.mNIHandler);
            }
            GnssLocationProvider.this.reloadGpsProperties();
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction(GnssLocationProvider.ALARM_WAKEUP);
            intentFilter.addAction(GnssLocationProvider.ALARM_TIMEOUT);
            intentFilter.addAction("android.os.action.POWER_SAVE_MODE_CHANGED");
            intentFilter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
            intentFilter.addAction("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
            GnssLocationProvider.this.mContext.registerReceiver(GnssLocationProvider.this.mBroadcastReceiver, intentFilter, null, this);
            GnssLocationProvider.this.mNetworkConnectivityHandler.registerNetworkCallbacks();
            LocationManager locManager = (LocationManager)GnssLocationProvider.this.mContext.getSystemService("location");
            long minTime = 0L;
            float minDistance = 0.0f;
            LocationRequest request = LocationRequest.createFromDeprecatedProvider("passive", minTime, minDistance, false);
            request.setHideFromAppOps(true);
            locManager.requestLocationUpdates(request, new NetworkLocationListener(), this.getLooper());
            GnssLocationProvider.this.updateEnabled();
        }
    }

    public static interface GnssMetricsProvider {
        public String getGnssMetricsAsProtoString();
    }

    public static interface GnssSystemInfoProvider {
        public int getGnssYearOfHardware();

        public String getGnssHardwareModelName();
    }

    private static class SvStatusInfo {
        private int mSvCount;
        private int[] mSvidWithFlags;
        private float[] mCn0s;
        private float[] mSvElevations;
        private float[] mSvAzimuths;
        private float[] mSvCarrierFreqs;

        private SvStatusInfo() {
        }

        static /* synthetic */ int[] access$1302(SvStatusInfo x0, int[] x1) {
            x0.mSvidWithFlags = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1402(SvStatusInfo x0, float[] x1) {
            x0.mCn0s = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1502(SvStatusInfo x0, float[] x1) {
            x0.mSvElevations = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1602(SvStatusInfo x0, float[] x1) {
            x0.mSvAzimuths = x1;
            return x1;
        }

        static /* synthetic */ float[] access$1702(SvStatusInfo x0, float[] x1) {
            x0.mSvCarrierFreqs = x1;
            return x1;
        }
    }

    private static class LocationExtras {
        private int mSvCount;
        private int mMeanCn0;
        private int mMaxCn0;
        private final Bundle mBundle = new Bundle();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(int svCount, int meanCn0, int maxCn0) {
            LocationExtras locationExtras = this;
            synchronized (locationExtras) {
                this.mSvCount = svCount;
                this.mMeanCn0 = meanCn0;
                this.mMaxCn0 = maxCn0;
            }
            this.setBundle(this.mBundle);
        }

        public void reset() {
            this.set(0, 0, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setBundle(Bundle extras) {
            if (extras != null) {
                LocationExtras locationExtras = this;
                synchronized (locationExtras) {
                    extras.putInt("satellites", this.mSvCount);
                    extras.putInt("meanCn0", this.mMeanCn0);
                    extras.putInt("maxCn0", this.mMaxCn0);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Bundle getBundle() {
            LocationExtras locationExtras = this;
            synchronized (locationExtras) {
                return new Bundle(this.mBundle);
            }
        }
    }

    private static class GpsRequest {
        public ProviderRequest request;
        public WorkSource source;

        public GpsRequest(ProviderRequest request, WorkSource source) {
            this.request = request;
            this.source = source;
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface NativeEntryPoint {
    }
}

