/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.GnssMeasurementCorrections;
import android.os.Handler;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;

public class GnssMeasurementCorrectionsProvider {
    private static final String TAG = "GnssMeasurementCorrectionsProvider";
    static final int CAPABILITY_LOS_SATS = 1;
    static final int CAPABILITY_EXCESS_PATH_LENGTH = 2;
    static final int CAPABILITY_REFLECTING_PLANE = 4;
    private static final int INVALID_CAPABILITIES = Integer.MIN_VALUE;
    private final Handler mHandler;
    private final GnssMeasurementCorrectionsProviderNative mNative;
    private volatile int mCapabilities = Integer.MIN_VALUE;

    GnssMeasurementCorrectionsProvider(Handler handler) {
        this(handler, new GnssMeasurementCorrectionsProviderNative());
    }

    @VisibleForTesting
    GnssMeasurementCorrectionsProvider(Handler handler, GnssMeasurementCorrectionsProviderNative aNative) {
        this.mHandler = handler;
        this.mNative = aNative;
    }

    public boolean isAvailableInPlatform() {
        return this.mNative.isMeasurementCorrectionsSupported();
    }

    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections measurementCorrections) {
        if (!this.isCapabilitiesReceived()) {
            Log.w(TAG, "Failed to inject GNSS measurement corrections. Capabilities not received yet.");
            return;
        }
        this.mHandler.post(() -> {
            if (!this.mNative.injectGnssMeasurementCorrections(measurementCorrections)) {
                Log.e(TAG, "Failure in injecting GNSS corrections.");
            }
        });
    }

    boolean onCapabilitiesUpdated(int capabilities) {
        if (GnssMeasurementCorrectionsProvider.hasCapability(capabilities, 1) || GnssMeasurementCorrectionsProvider.hasCapability(capabilities, 2)) {
            this.mCapabilities = capabilities;
            return true;
        }
        Log.e(TAG, "Failed to set capabilities. Received capabilities 0x" + Integer.toHexString(capabilities) + " does not contain the mandatory LOS_SATS or the EXCESS_PATH_LENGTH capability.");
        return false;
    }

    int getCapabilities() {
        return this.mCapabilities;
    }

    String toStringCapabilities() {
        int capabilities = this.getCapabilities();
        StringBuilder s = new StringBuilder();
        s.append("mCapabilities=0x").append(Integer.toHexString(capabilities));
        s.append(" ( ");
        if (GnssMeasurementCorrectionsProvider.hasCapability(capabilities, 1)) {
            s.append("LOS_SATS ");
        }
        if (GnssMeasurementCorrectionsProvider.hasCapability(capabilities, 2)) {
            s.append("EXCESS_PATH_LENGTH ");
        }
        if (GnssMeasurementCorrectionsProvider.hasCapability(capabilities, 4)) {
            s.append("REFLECTING_PLANE ");
        }
        s.append(")");
        return s.toString();
    }

    private static boolean hasCapability(int halCapabilities, int capability) {
        return (halCapabilities & capability) != 0;
    }

    private boolean isCapabilitiesReceived() {
        return this.mCapabilities != Integer.MIN_VALUE;
    }

    private static native boolean native_is_measurement_corrections_supported();

    private static native boolean native_inject_gnss_measurement_corrections(GnssMeasurementCorrections var0);

    @VisibleForTesting
    static class GnssMeasurementCorrectionsProviderNative {
        GnssMeasurementCorrectionsProviderNative() {
        }

        public boolean isMeasurementCorrectionsSupported() {
            return GnssMeasurementCorrectionsProvider.native_is_measurement_corrections_supported();
        }

        public boolean injectGnssMeasurementCorrections(GnssMeasurementCorrections measurementCorrections) {
            return GnssMeasurementCorrectionsProvider.native_inject_gnss_measurement_corrections(measurementCorrections);
        }
    }
}

