/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.GnssMeasurementsEvent;
import android.location.IGnssMeasurementsListener;
import android.os.Handler;
import android.os.RemoteException;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.location.CallerIdentity;
import com.android.server.location.RemoteListenerHelper;

public abstract class GnssMeasurementsProvider
extends RemoteListenerHelper<IGnssMeasurementsListener> {
    private static final String TAG = "GnssMeasurementsProvider";
    private static final boolean DEBUG = Log.isLoggable("GnssMeasurementsProvider", 3);
    private final GnssMeasurementProviderNative mNative;
    private boolean mIsCollectionStarted;
    private boolean mEnableFullTracking;

    protected GnssMeasurementsProvider(Context context, Handler handler) {
        this(context, handler, new GnssMeasurementProviderNative());
    }

    @VisibleForTesting
    GnssMeasurementsProvider(Context context, Handler handler, GnssMeasurementProviderNative aNative) {
        super(context, handler, TAG);
        this.mNative = aNative;
    }

    void resumeIfStarted() {
        if (DEBUG) {
            Log.d(TAG, "resumeIfStarted");
        }
        if (this.mIsCollectionStarted) {
            this.mNative.startMeasurementCollection(this.mEnableFullTracking);
        }
    }

    @Override
    public boolean isAvailableInPlatform() {
        return this.mNative.isMeasurementSupported();
    }

    @Override
    protected int registerWithService() {
        int devOptions = Settings.Secure.getInt(this.mContext.getContentResolver(), "development_settings_enabled", 0);
        int fullTrackingToggled = Settings.Global.getInt(this.mContext.getContentResolver(), "enable_gnss_raw_meas_full_tracking", 0);
        boolean enableFullTracking = devOptions == 1 && fullTrackingToggled == 1;
        boolean result = this.mNative.startMeasurementCollection(enableFullTracking);
        if (result) {
            this.mIsCollectionStarted = true;
            this.mEnableFullTracking = enableFullTracking;
            return 0;
        }
        return 4;
    }

    @Override
    protected void unregisterFromService() {
        boolean stopped = this.mNative.stopMeasurementCollection();
        if (stopped) {
            this.mIsCollectionStarted = false;
        }
    }

    public void onMeasurementsAvailable(GnssMeasurementsEvent event) {
        this.foreach((listener, callerIdentity) -> {
            if (!this.hasPermission(this.mContext, callerIdentity)) {
                this.logPermissionDisabledEventNotReported(TAG, callerIdentity.mPackageName, "GNSS measurements");
                return;
            }
            listener.onGnssMeasurementsReceived(event);
        });
    }

    public void onCapabilitiesUpdated(boolean isGnssMeasurementsSupported) {
        this.setSupported(isGnssMeasurementsSupported);
        this.updateResult();
    }

    public void onGpsEnabledChanged() {
        this.tryUpdateRegistrationWithService();
        this.updateResult();
    }

    @Override
    protected RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener> getHandlerOperation(int result) {
        int status;
        switch (result) {
            case 0: {
                status = 1;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                status = 0;
                break;
            }
            case 6: {
                status = 3;
                break;
            }
            case 3: {
                status = 2;
                break;
            }
            case 5: {
                return null;
            }
            default: {
                Log.v(TAG, "Unhandled addListener result: " + result);
                return null;
            }
        }
        return new StatusChangedOperation(status);
    }

    private static native boolean native_is_measurement_supported();

    private static native boolean native_start_measurement_collection(boolean var0);

    private static native boolean native_stop_measurement_collection();

    @VisibleForTesting
    static class GnssMeasurementProviderNative {
        GnssMeasurementProviderNative() {
        }

        public boolean isMeasurementSupported() {
            return GnssMeasurementsProvider.native_is_measurement_supported();
        }

        public boolean startMeasurementCollection(boolean enableFullTracking) {
            return GnssMeasurementsProvider.native_start_measurement_collection(enableFullTracking);
        }

        public boolean stopMeasurementCollection() {
            return GnssMeasurementsProvider.native_stop_measurement_collection();
        }
    }

    private static class StatusChangedOperation
    implements RemoteListenerHelper.ListenerOperation<IGnssMeasurementsListener> {
        private final int mStatus;

        public StatusChangedOperation(int status) {
            this.mStatus = status;
        }

        @Override
        public void execute(IGnssMeasurementsListener listener, CallerIdentity callerIdentity) throws RemoteException {
            listener.onStatusChanged(this.mStatus);
        }
    }
}

