/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.provider.Telephony;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;

class GnssNetworkConnectivityHandler {
    static final String TAG = "GnssNetworkConnectivityHandler";
    private static final boolean DEBUG = Log.isLoggable("GnssNetworkConnectivityHandler", 3);
    private static final boolean VERBOSE = Log.isLoggable("GnssNetworkConnectivityHandler", 2);
    private static final int AGPS_DATA_CONNECTION_CLOSED = 0;
    private static final int AGPS_DATA_CONNECTION_OPENING = 1;
    private static final int AGPS_DATA_CONNECTION_OPEN = 2;
    private static final int GPS_REQUEST_AGPS_DATA_CONN = 1;
    private static final int GPS_RELEASE_AGPS_DATA_CONN = 2;
    private static final int GPS_AGPS_DATA_CONNECTED = 3;
    private static final int GPS_AGPS_DATA_CONN_DONE = 4;
    private static final int GPS_AGPS_DATA_CONN_FAILED = 5;
    private static final int APN_INVALID = 0;
    private static final int APN_IPV4 = 1;
    private static final int APN_IPV6 = 2;
    private static final int APN_IPV4V6 = 3;
    private static final int AGNSS_NET_CAPABILITY_NOT_METERED = 1;
    private static final int AGNSS_NET_CAPABILITY_NOT_ROAMING = 2;
    public static final int AGPS_TYPE_SUPL = 1;
    public static final int AGPS_TYPE_C2K = 2;
    private static final int AGPS_TYPE_EIMS = 3;
    private static final int AGPS_TYPE_IMS = 4;
    private static final int SUPL_NETWORK_REQUEST_TIMEOUT_MILLIS = 10000;
    private static final int HASH_MAP_INITIAL_CAPACITY_TO_TRACK_CONNECTED_NETWORKS = 5;
    private HashMap<Network, NetworkAttributes> mAvailableNetworkAttributes = new HashMap(5);
    private final ConnectivityManager mConnMgr;
    private final Handler mHandler;
    private final GnssNetworkListener mGnssNetworkListener;
    private int mAGpsDataConnectionState;
    private InetAddress mAGpsDataConnectionIpAddr;
    private int mAGpsType;
    private final Context mContext;
    private static final String WAKELOCK_KEY = "GnssNetworkConnectivityHandler";
    private static final long WAKELOCK_TIMEOUT_MILLIS = 60000L;
    private final PowerManager.WakeLock mWakeLock;
    private ConnectivityManager.NetworkCallback mNetworkConnectivityCallback;
    private ConnectivityManager.NetworkCallback mSuplConnectivityCallback;

    GnssNetworkConnectivityHandler(Context context, GnssNetworkListener gnssNetworkListener, Looper looper) {
        this.mContext = context;
        this.mGnssNetworkListener = gnssNetworkListener;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "GnssNetworkConnectivityHandler");
        this.mHandler = new Handler(looper);
        this.mConnMgr = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        this.mSuplConnectivityCallback = this.createSuplConnectivityCallback();
    }

    void registerNetworkCallbacks() {
        NetworkRequest.Builder networkRequestBuilder = new NetworkRequest.Builder();
        networkRequestBuilder.addCapability(12);
        networkRequestBuilder.addCapability(16);
        networkRequestBuilder.removeCapability(15);
        NetworkRequest networkRequest = networkRequestBuilder.build();
        this.mNetworkConnectivityCallback = this.createNetworkConnectivityCallback();
        this.mConnMgr.registerNetworkCallback(networkRequest, this.mNetworkConnectivityCallback, this.mHandler);
    }

    boolean isDataNetworkConnected() {
        NetworkInfo activeNetworkInfo = this.mConnMgr.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    void onReportAGpsStatus(int agpsType, int agpsStatus, byte[] suplIpAddr) {
        if (DEBUG) {
            Log.d("GnssNetworkConnectivityHandler", "AGPS_DATA_CONNECTION: " + this.agpsDataConnStatusAsString(agpsStatus));
        }
        switch (agpsStatus) {
            case 1: {
                this.runOnHandler(() -> this.handleRequestSuplConnection(agpsType, suplIpAddr));
                break;
            }
            case 2: {
                this.runOnHandler(() -> this.handleReleaseSuplConnection(2));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                Log.w("GnssNetworkConnectivityHandler", "Received unknown AGPS status: " + agpsStatus);
            }
        }
    }

    private ConnectivityManager.NetworkCallback createNetworkConnectivityCallback() {
        return new ConnectivityManager.NetworkCallback(){
            private HashMap<Network, NetworkCapabilities> mAvailableNetworkCapabilities = new HashMap(5);

            @Override
            public void onCapabilitiesChanged(Network network, NetworkCapabilities capabilities) {
                if (!NetworkAttributes.hasCapabilitiesChanged(this.mAvailableNetworkCapabilities.get(network), capabilities)) {
                    if (VERBOSE) {
                        Log.v("GnssNetworkConnectivityHandler", "Relevant network capabilities unchanged. Capabilities: " + capabilities);
                    }
                    return;
                }
                this.mAvailableNetworkCapabilities.put(network, capabilities);
                if (DEBUG) {
                    Log.d("GnssNetworkConnectivityHandler", "Network connected/capabilities updated. Available networks count: " + this.mAvailableNetworkCapabilities.size());
                }
                GnssNetworkConnectivityHandler.this.mGnssNetworkListener.onNetworkAvailable();
                GnssNetworkConnectivityHandler.this.handleUpdateNetworkState(network, true, capabilities);
            }

            @Override
            public void onLost(Network network) {
                if (this.mAvailableNetworkCapabilities.remove(network) == null) {
                    Log.w("GnssNetworkConnectivityHandler", "Incorrectly received network callback onLost() before onCapabilitiesChanged() for network: " + network);
                    return;
                }
                Log.i("GnssNetworkConnectivityHandler", "Network connection lost. Available networks count: " + this.mAvailableNetworkCapabilities.size());
                GnssNetworkConnectivityHandler.this.handleUpdateNetworkState(network, false, null);
            }
        };
    }

    private ConnectivityManager.NetworkCallback createSuplConnectivityCallback() {
        return new ConnectivityManager.NetworkCallback(){

            @Override
            public void onAvailable(Network network) {
                if (DEBUG) {
                    Log.d("GnssNetworkConnectivityHandler", "SUPL network connection available.");
                }
                GnssNetworkConnectivityHandler.this.handleSuplConnectionAvailable(network);
            }

            @Override
            public void onLost(Network network) {
                Log.i("GnssNetworkConnectivityHandler", "SUPL network connection lost.");
                GnssNetworkConnectivityHandler.this.handleReleaseSuplConnection(2);
            }

            @Override
            public void onUnavailable() {
                Log.i("GnssNetworkConnectivityHandler", "SUPL network connection request timed out.");
                GnssNetworkConnectivityHandler.this.handleReleaseSuplConnection(5);
            }
        };
    }

    private void runOnHandler(Runnable event) {
        this.mWakeLock.acquire(60000L);
        if (!this.mHandler.post(this.runEventAndReleaseWakeLock(event))) {
            this.mWakeLock.release();
        }
    }

    private Runnable runEventAndReleaseWakeLock(Runnable event) {
        return () -> {
            try {
                event.run();
            }
            finally {
                this.mWakeLock.release();
            }
        };
    }

    private void handleUpdateNetworkState(Network network, boolean isConnected, NetworkCapabilities capabilities) {
        boolean networkAvailable = isConnected && TelephonyManager.getDefault().getDataEnabled();
        NetworkAttributes networkAttributes = this.updateTrackedNetworksState(isConnected, network, capabilities);
        String apn = networkAttributes.mApn;
        int type = networkAttributes.mType;
        capabilities = networkAttributes.mCapabilities;
        Log.i("GnssNetworkConnectivityHandler", String.format("updateNetworkState, state=%s, connected=%s, network=%s, capabilities=%s, apn: %s, availableNetworkCount: %d", this.agpsDataConnStateAsString(), isConnected, network, capabilities, apn, this.mAvailableNetworkAttributes.size()));
        if (GnssNetworkConnectivityHandler.native_is_agps_ril_supported()) {
            this.native_update_network_state(isConnected, type, !capabilities.hasTransport(18), networkAvailable, apn != null ? apn : "", network.getNetworkHandle(), NetworkAttributes.getCapabilityFlags(capabilities));
        } else if (DEBUG) {
            Log.d("GnssNetworkConnectivityHandler", "Skipped network state update because GPS HAL AGPS-RIL is not  supported");
        }
    }

    private NetworkAttributes updateTrackedNetworksState(boolean isConnected, Network network, NetworkCapabilities capabilities) {
        if (!isConnected) {
            return this.mAvailableNetworkAttributes.remove(network);
        }
        NetworkAttributes networkAttributes = this.mAvailableNetworkAttributes.get(network);
        if (networkAttributes != null) {
            networkAttributes.mCapabilities = capabilities;
            return networkAttributes;
        }
        networkAttributes = new NetworkAttributes();
        networkAttributes.mCapabilities = capabilities;
        NetworkInfo info = this.mConnMgr.getNetworkInfo(network);
        if (info != null) {
            networkAttributes.mApn = info.getExtraInfo();
            networkAttributes.mType = info.getType();
        }
        this.mAvailableNetworkAttributes.put(network, networkAttributes);
        return networkAttributes;
    }

    private void handleSuplConnectionAvailable(Network network) {
        NetworkInfo info = this.mConnMgr.getNetworkInfo(network);
        String apn = null;
        if (info != null) {
            apn = info.getExtraInfo();
        }
        if (DEBUG) {
            String message = String.format("handleSuplConnectionAvailable: state=%s, suplNetwork=%s, info=%s", this.agpsDataConnStateAsString(), network, info);
            Log.d("GnssNetworkConnectivityHandler", message);
        }
        if (this.mAGpsDataConnectionState == 1) {
            if (apn == null) {
                apn = "dummy-apn";
            }
            if (this.mAGpsDataConnectionIpAddr != null) {
                this.setRouting();
            }
            int apnIpType = this.getApnIpType(apn);
            if (DEBUG) {
                String message = String.format("native_agps_data_conn_open: mAgpsApn=%s, mApnIpType=%s", apn, apnIpType);
                Log.d("GnssNetworkConnectivityHandler", message);
            }
            this.native_agps_data_conn_open(network.getNetworkHandle(), apn, apnIpType);
            this.mAGpsDataConnectionState = 2;
        }
    }

    private void handleRequestSuplConnection(int agpsType, byte[] suplIpAddr) {
        this.mAGpsDataConnectionIpAddr = null;
        this.mAGpsType = agpsType;
        if (suplIpAddr != null) {
            if (VERBOSE) {
                Log.v("GnssNetworkConnectivityHandler", "Received SUPL IP addr[]: " + Arrays.toString(suplIpAddr));
            }
            try {
                this.mAGpsDataConnectionIpAddr = InetAddress.getByAddress(suplIpAddr);
                if (DEBUG) {
                    Log.d("GnssNetworkConnectivityHandler", "IP address converted to: " + this.mAGpsDataConnectionIpAddr);
                }
            }
            catch (UnknownHostException e) {
                Log.e("GnssNetworkConnectivityHandler", "Bad IP Address: " + suplIpAddr, e);
            }
        }
        if (DEBUG) {
            String message = String.format("requestSuplConnection, state=%s, agpsType=%s, address=%s", this.agpsDataConnStateAsString(), this.agpsTypeAsString(agpsType), this.mAGpsDataConnectionIpAddr);
            Log.d("GnssNetworkConnectivityHandler", message);
        }
        if (this.mAGpsDataConnectionState != 0) {
            return;
        }
        this.mAGpsDataConnectionState = 1;
        NetworkRequest.Builder networkRequestBuilder = new NetworkRequest.Builder();
        networkRequestBuilder.addCapability(this.getNetworkCapability(this.mAGpsType));
        networkRequestBuilder.addTransportType(0);
        NetworkRequest networkRequest = networkRequestBuilder.build();
        this.mConnMgr.requestNetwork(networkRequest, this.mSuplConnectivityCallback, this.mHandler, 10000);
    }

    private int getNetworkCapability(int agpsType) {
        switch (agpsType) {
            case 1: 
            case 2: {
                return 1;
            }
            case 3: {
                return 10;
            }
            case 4: {
                return 4;
            }
        }
        throw new IllegalArgumentException("agpsType: " + agpsType);
    }

    private void handleReleaseSuplConnection(int agpsDataConnStatus) {
        if (DEBUG) {
            String message = String.format("releaseSuplConnection, state=%s, status=%s", this.agpsDataConnStateAsString(), this.agpsDataConnStatusAsString(agpsDataConnStatus));
            Log.d("GnssNetworkConnectivityHandler", message);
        }
        if (this.mAGpsDataConnectionState == 0) {
            return;
        }
        this.mAGpsDataConnectionState = 0;
        this.mConnMgr.unregisterNetworkCallback(this.mSuplConnectivityCallback);
        switch (agpsDataConnStatus) {
            case 5: {
                this.native_agps_data_conn_failed();
                break;
            }
            case 2: {
                this.native_agps_data_conn_closed();
                break;
            }
            default: {
                Log.e("GnssNetworkConnectivityHandler", "Invalid status to release SUPL connection: " + agpsDataConnStatus);
            }
        }
    }

    private void setRouting() {
        boolean result = this.mConnMgr.requestRouteToHostAddress(3, this.mAGpsDataConnectionIpAddr);
        if (!result) {
            Log.e("GnssNetworkConnectivityHandler", "Error requesting route to host: " + this.mAGpsDataConnectionIpAddr);
        } else if (DEBUG) {
            Log.d("GnssNetworkConnectivityHandler", "Successfully requested route to host: " + this.mAGpsDataConnectionIpAddr);
        }
    }

    private void ensureInHandlerThread() {
        if (this.mHandler != null && Looper.myLooper() == this.mHandler.getLooper()) {
            return;
        }
        throw new IllegalStateException("This method must run on the Handler thread.");
    }

    private String agpsDataConnStateAsString() {
        switch (this.mAGpsDataConnectionState) {
            case 0: {
                return "CLOSED";
            }
            case 2: {
                return "OPEN";
            }
            case 1: {
                return "OPENING";
            }
        }
        return "<Unknown>(" + this.mAGpsDataConnectionState + ")";
    }

    private String agpsDataConnStatusAsString(int agpsDataConnStatus) {
        switch (agpsDataConnStatus) {
            case 3: {
                return "CONNECTED";
            }
            case 4: {
                return "DONE";
            }
            case 5: {
                return "FAILED";
            }
            case 2: {
                return "RELEASE";
            }
            case 1: {
                return "REQUEST";
            }
        }
        return "<Unknown>(" + agpsDataConnStatus + ")";
    }

    private String agpsTypeAsString(int agpsType) {
        switch (agpsType) {
            case 1: {
                return "SUPL";
            }
            case 2: {
                return "C2K";
            }
            case 3: {
                return "EIMS";
            }
            case 4: {
                return "IMS";
            }
        }
        return "<Unknown>(" + agpsType + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getApnIpType(String apn) {
        this.ensureInHandlerThread();
        if (apn == null) {
            return 0;
        }
        TelephonyManager phone = (TelephonyManager)this.mContext.getSystemService("phone");
        ServiceState serviceState = phone.getServiceState();
        String projection = null;
        String selection = null;
        projection = serviceState != null && serviceState.getDataRoamingFromRegistration() ? "roaming_protocol" : "protocol";
        selection = 0 == phone.getNetworkType() && 3 == this.mAGpsType ? String.format("type like '%%emergency%%' and apn = '%s' and carrier_enabled = 1", apn) : String.format("current = 1 and apn = '%s' and carrier_enabled = 1", apn);
        try (Cursor cursor = this.mContext.getContentResolver().query(Telephony.Carriers.CONTENT_URI, new String[]{projection}, selection, null, "name ASC");){
            if (null != cursor && cursor.moveToFirst()) {
                int n = this.translateToApnIpType(cursor.getString(0), apn);
                return n;
            }
            Log.e("GnssNetworkConnectivityHandler", "No entry found in query for APN: " + apn);
            return 3;
        }
        catch (Exception e) {
            Log.e("GnssNetworkConnectivityHandler", "Error encountered on APN query for: " + apn, e);
        }
        return 3;
    }

    private int translateToApnIpType(String ipProtocol, String apn) {
        if ("IP".equals(ipProtocol)) {
            return 1;
        }
        if ("IPV6".equals(ipProtocol)) {
            return 2;
        }
        if ("IPV4V6".equals(ipProtocol)) {
            return 3;
        }
        String message = String.format("Unknown IP Protocol: %s, for APN: %s", ipProtocol, apn);
        Log.e("GnssNetworkConnectivityHandler", message);
        return 3;
    }

    private native void native_agps_data_conn_open(long var1, String var3, int var4);

    private native void native_agps_data_conn_closed();

    private native void native_agps_data_conn_failed();

    private static native boolean native_is_agps_ril_supported();

    private native void native_update_network_state(boolean var1, int var2, boolean var3, boolean var4, String var5, long var6, short var8);

    static interface GnssNetworkListener {
        public void onNetworkAvailable();
    }

    private static class NetworkAttributes {
        private NetworkCapabilities mCapabilities;
        private String mApn;
        private int mType = -1;

        private NetworkAttributes() {
        }

        private static boolean hasCapabilitiesChanged(NetworkCapabilities curCapabilities, NetworkCapabilities newCapabilities) {
            if (curCapabilities == null || newCapabilities == null) {
                return true;
            }
            return NetworkAttributes.hasCapabilityChanged(curCapabilities, newCapabilities, 18) || NetworkAttributes.hasCapabilityChanged(curCapabilities, newCapabilities, 11);
        }

        private static boolean hasCapabilityChanged(NetworkCapabilities curCapabilities, NetworkCapabilities newCapabilities, int capability) {
            return curCapabilities.hasCapability(capability) != newCapabilities.hasCapability(capability);
        }

        private static short getCapabilityFlags(NetworkCapabilities capabilities) {
            short capabilityFlags = 0;
            if (capabilities.hasCapability(18)) {
                capabilityFlags = (short)(capabilityFlags | 2);
            }
            if (capabilities.hasCapability(11)) {
                capabilityFlags = (short)(capabilityFlags | 1);
            }
            return capabilityFlags;
        }
    }
}

