/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.location.IGnssStatusListener;
import android.os.Handler;
import android.util.Log;
import com.android.server.location.GnssLocationProvider;
import com.android.server.location.RemoteListenerHelper;

public abstract class GnssStatusListenerHelper
extends RemoteListenerHelper<IGnssStatusListener> {
    private static final String TAG = "GnssStatusListenerHelper";
    private static final boolean DEBUG = Log.isLoggable("GnssStatusListenerHelper", 3);

    protected GnssStatusListenerHelper(Context context, Handler handler) {
        super(context, handler, TAG);
        this.setSupported(GnssLocationProvider.isSupported());
    }

    @Override
    protected int registerWithService() {
        return 0;
    }

    @Override
    protected void unregisterFromService() {
    }

    @Override
    protected RemoteListenerHelper.ListenerOperation<IGnssStatusListener> getHandlerOperation(int result) {
        return null;
    }

    public void onStatusChanged(boolean isNavigating) {
        if (isNavigating) {
            this.foreach((listener, callerIdentity) -> listener.onGnssStarted());
        } else {
            this.foreach((listener, callerIdentity) -> listener.onGnssStopped());
        }
    }

    public void onFirstFix(int timeToFirstFix) {
        this.foreach((listener, callerIdentity) -> listener.onFirstFix(timeToFirstFix));
    }

    public void onSvStatusChanged(int svCount, int[] prnWithFlags, float[] cn0s, float[] elevations, float[] azimuths, float[] carrierFreqs) {
        this.foreach((listener, callerIdentity) -> {
            if (!this.hasPermission(this.mContext, callerIdentity)) {
                this.logPermissionDisabledEventNotReported(TAG, callerIdentity.mPackageName, "GNSS status");
                return;
            }
            listener.onSvStatusChanged(svCount, prnWithFlags, cn0s, elevations, azimuths, carrierFreqs);
        });
    }

    public void onNmeaReceived(long timestamp, String nmea) {
        this.foreach((listener, callerIdentity) -> {
            if (!this.hasPermission(this.mContext, callerIdentity)) {
                this.logPermissionDisabledEventNotReported(TAG, callerIdentity.mPackageName, "NMEA");
                return;
            }
            listener.onNmeaReceived(timestamp, nmea);
        });
    }
}

