/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.annotation.SuppressLint;
import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.StatsLog;
import com.android.internal.location.GpsNetInitiatedHandler;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.server.location.GnssConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class GnssVisibilityControl {
    private static final String TAG = "GnssVisibilityControl";
    private static final boolean DEBUG = Log.isLoggable("GnssVisibilityControl", 3);
    private static final String LOCATION_PERMISSION_NAME = "android.permission.ACCESS_FINE_LOCATION";
    private static final String[] NO_LOCATION_ENABLED_PROXY_APPS = new String[0];
    private static final long ON_GPS_ENABLED_CHANGED_TIMEOUT_MILLIS = 3000L;
    private static final long LOCATION_ICON_DISPLAY_DURATION_MILLIS = 5000L;
    private static final String WAKELOCK_KEY = "GnssVisibilityControl";
    private static final long WAKELOCK_TIMEOUT_MILLIS = 60000L;
    private final PowerManager.WakeLock mWakeLock;
    private final AppOpsManager mAppOps;
    private final PackageManager mPackageManager;
    private final Handler mHandler;
    private final Context mContext;
    private final GpsNetInitiatedHandler mNiHandler;
    private boolean mIsGpsEnabled;
    private static final int ARRAY_MAP_INITIAL_CAPACITY_PROXY_APPS_STATE = 5;
    private ArrayMap<String, ProxyAppState> mProxyAppsState = new ArrayMap(5);
    private PackageManager.OnPermissionsChangedListener mOnPermissionsChangedListener = uid -> this.runOnHandler(() -> this.handlePermissionsChanged(uid));

    GnssVisibilityControl(Context context, Looper looper, GpsNetInitiatedHandler niHandler) {
        this.mContext = context;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mWakeLock = powerManager.newWakeLock(1, "GnssVisibilityControl");
        this.mHandler = new Handler(looper);
        this.mNiHandler = niHandler;
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        this.mPackageManager = this.mContext.getPackageManager();
        this.runOnHandler(this::handleInitialize);
    }

    void onGpsEnabledChanged(boolean isEnabled) {
        if (this.mHandler.runWithScissors(() -> this.handleGpsEnabledChanged(isEnabled), 3000L)) {
            return;
        }
        if (!isEnabled) {
            Log.w("GnssVisibilityControl", "Native call to disable non-framework location access in GNSS HAL may get executed after native_cleanup().");
        }
    }

    void reportNfwNotification(String proxyAppPackageName, byte protocolStack, String otherProtocolStackName, byte requestor, String requestorId, byte responseType, boolean inEmergencyMode, boolean isCachedLocation) {
        this.runOnHandler(() -> this.handleNfwNotification(new NfwNotification(proxyAppPackageName, protocolStack, otherProtocolStackName, requestor, requestorId, responseType, inEmergencyMode, isCachedLocation)));
    }

    void onConfigurationUpdated(GnssConfiguration configuration) {
        List<String> nfwLocationAccessProxyApps = configuration.getProxyApps();
        this.runOnHandler(() -> this.handleUpdateProxyApps(nfwLocationAccessProxyApps));
    }

    private void handleInitialize() {
        this.listenForProxyAppsPackageUpdates();
    }

    private void listenForProxyAppsPackageUpdates() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addAction("android.intent.action.PACKAGE_REPLACED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                switch (action) {
                    case "android.intent.action.PACKAGE_ADDED": 
                    case "android.intent.action.PACKAGE_REMOVED": 
                    case "android.intent.action.PACKAGE_REPLACED": 
                    case "android.intent.action.PACKAGE_CHANGED": {
                        String pkgName = intent.getData().getEncodedSchemeSpecificPart();
                        GnssVisibilityControl.this.handleProxyAppPackageUpdate(pkgName, action);
                    }
                }
            }
        }, UserHandle.ALL, intentFilter, null, this.mHandler);
    }

    private void handleProxyAppPackageUpdate(String pkgName, String action) {
        ProxyAppState proxyAppState = this.mProxyAppsState.get(pkgName);
        if (proxyAppState == null) {
            return;
        }
        if (DEBUG) {
            Log.d("GnssVisibilityControl", "Proxy app " + pkgName + " package changed: " + action);
        }
        boolean updatedLocationPermission = this.shouldEnableLocationPermissionInGnssHal(pkgName);
        if (proxyAppState.mHasLocationPermission != updatedLocationPermission) {
            Log.i("GnssVisibilityControl", "Proxy app " + pkgName + " location permission changed. IsLocationPermissionEnabled: " + updatedLocationPermission);
            proxyAppState.mHasLocationPermission = updatedLocationPermission;
            this.updateNfwLocationAccessProxyAppsInGnssHal();
        }
    }

    private void handleUpdateProxyApps(List<String> nfwLocationAccessProxyApps) {
        if (!this.isProxyAppListUpdated(nfwLocationAccessProxyApps)) {
            return;
        }
        if (nfwLocationAccessProxyApps.isEmpty()) {
            if (!this.mProxyAppsState.isEmpty()) {
                this.mPackageManager.removeOnPermissionsChangeListener(this.mOnPermissionsChangedListener);
                this.resetProxyAppsState();
                this.updateNfwLocationAccessProxyAppsInGnssHal();
            }
            return;
        }
        if (this.mProxyAppsState.isEmpty()) {
            this.mPackageManager.addOnPermissionsChangeListener(this.mOnPermissionsChangedListener);
        } else {
            this.resetProxyAppsState();
        }
        for (String proxyAppPkgName : nfwLocationAccessProxyApps) {
            ProxyAppState proxyAppState = new ProxyAppState(this.shouldEnableLocationPermissionInGnssHal(proxyAppPkgName));
            this.mProxyAppsState.put(proxyAppPkgName, proxyAppState);
        }
        this.updateNfwLocationAccessProxyAppsInGnssHal();
    }

    private void resetProxyAppsState() {
        for (Map.Entry<String, ProxyAppState> entry : this.mProxyAppsState.entrySet()) {
            ProxyAppState proxyAppState = entry.getValue();
            if (!proxyAppState.mIsLocationIconOn) continue;
            this.mHandler.removeCallbacksAndMessages(proxyAppState);
            ApplicationInfo proxyAppInfo = this.getProxyAppInfo(entry.getKey());
            if (proxyAppInfo == null) continue;
            this.clearLocationIcon(proxyAppState, proxyAppInfo.uid, entry.getKey());
        }
        this.mProxyAppsState.clear();
    }

    private boolean isProxyAppListUpdated(List<String> nfwLocationAccessProxyApps) {
        if (nfwLocationAccessProxyApps.size() != this.mProxyAppsState.size()) {
            return true;
        }
        for (String nfwLocationAccessProxyApp : nfwLocationAccessProxyApps) {
            if (this.mProxyAppsState.containsKey(nfwLocationAccessProxyApp)) continue;
            return true;
        }
        return false;
    }

    private void handleGpsEnabledChanged(boolean isGpsEnabled) {
        if (DEBUG) {
            Log.d("GnssVisibilityControl", "handleGpsEnabledChanged, mIsGpsEnabled: " + this.mIsGpsEnabled + ", isGpsEnabled: " + isGpsEnabled);
        }
        this.mIsGpsEnabled = isGpsEnabled;
        if (!this.mIsGpsEnabled) {
            this.disableNfwLocationAccess();
            return;
        }
        this.setNfwLocationAccessProxyAppsInGnssHal(this.getLocationPermissionEnabledProxyApps());
    }

    private void disableNfwLocationAccess() {
        this.setNfwLocationAccessProxyAppsInGnssHal(NO_LOCATION_ENABLED_PROXY_APPS);
    }

    private void handlePermissionsChanged(int uid) {
        if (this.mProxyAppsState.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ProxyAppState> entry : this.mProxyAppsState.entrySet()) {
            ProxyAppState proxyAppState;
            String proxyAppPkgName = entry.getKey();
            ApplicationInfo proxyAppInfo = this.getProxyAppInfo(proxyAppPkgName);
            if (proxyAppInfo == null || proxyAppInfo.uid != uid) continue;
            boolean isLocationPermissionEnabled = this.shouldEnableLocationPermissionInGnssHal(proxyAppPkgName);
            if (isLocationPermissionEnabled != (proxyAppState = entry.getValue()).mHasLocationPermission) {
                Log.i("GnssVisibilityControl", "Proxy app " + proxyAppPkgName + " location permission changed. IsLocationPermissionEnabled: " + isLocationPermissionEnabled);
                proxyAppState.mHasLocationPermission = isLocationPermissionEnabled;
                this.updateNfwLocationAccessProxyAppsInGnssHal();
            }
            return;
        }
    }

    private ApplicationInfo getProxyAppInfo(String proxyAppPkgName) {
        try {
            return this.mPackageManager.getApplicationInfo(proxyAppPkgName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            if (DEBUG) {
                Log.d("GnssVisibilityControl", "Proxy app " + proxyAppPkgName + " is not found.");
            }
            return null;
        }
    }

    private boolean shouldEnableLocationPermissionInGnssHal(String proxyAppPkgName) {
        return this.isProxyAppInstalled(proxyAppPkgName) && this.hasLocationPermission(proxyAppPkgName);
    }

    private boolean isProxyAppInstalled(String pkgName) {
        ApplicationInfo proxyAppInfo = this.getProxyAppInfo(pkgName);
        return proxyAppInfo != null && proxyAppInfo.enabled;
    }

    private boolean hasLocationPermission(String pkgName) {
        return this.mPackageManager.checkPermission(LOCATION_PERMISSION_NAME, pkgName) == 0;
    }

    private void updateNfwLocationAccessProxyAppsInGnssHal() {
        if (!this.mIsGpsEnabled) {
            return;
        }
        this.setNfwLocationAccessProxyAppsInGnssHal(this.getLocationPermissionEnabledProxyApps());
    }

    private void setNfwLocationAccessProxyAppsInGnssHal(String[] locationPermissionEnabledProxyApps) {
        String proxyAppsStr = Arrays.toString(locationPermissionEnabledProxyApps);
        Log.i("GnssVisibilityControl", "Updating non-framework location access proxy apps in the GNSS HAL to: " + proxyAppsStr);
        boolean result = this.native_enable_nfw_location_access(locationPermissionEnabledProxyApps);
        if (!result) {
            Log.e("GnssVisibilityControl", "Failed to update non-framework location access proxy apps in the GNSS HAL to: " + proxyAppsStr);
        }
    }

    private String[] getLocationPermissionEnabledProxyApps() {
        int countLocationPermissionEnabledProxyApps = 0;
        for (ProxyAppState proxyAppState : this.mProxyAppsState.values()) {
            if (!proxyAppState.mHasLocationPermission) continue;
            ++countLocationPermissionEnabledProxyApps;
        }
        int i = 0;
        String[] locationPermissionEnabledProxyApps = new String[countLocationPermissionEnabledProxyApps];
        for (Map.Entry<String, ProxyAppState> entry : this.mProxyAppsState.entrySet()) {
            String proxyApp = entry.getKey();
            if (!entry.getValue().mHasLocationPermission) continue;
            locationPermissionEnabledProxyApps[i++] = proxyApp;
        }
        return locationPermissionEnabledProxyApps;
    }

    private void handleNfwNotification(NfwNotification nfwNotification) {
        if (DEBUG) {
            Log.d("GnssVisibilityControl", "Non-framework location access notification: " + nfwNotification);
        }
        if (nfwNotification.isEmergencyRequestNotification()) {
            this.handleEmergencyNfwNotification(nfwNotification);
            return;
        }
        String proxyAppPkgName = nfwNotification.mProxyAppPackageName;
        ProxyAppState proxyAppState = this.mProxyAppsState.get(proxyAppPkgName);
        boolean isLocationRequestAccepted = nfwNotification.isRequestAccepted();
        boolean isPermissionMismatched = this.isPermissionMismatched(proxyAppState, nfwNotification);
        this.logEvent(nfwNotification, isPermissionMismatched);
        if (!nfwNotification.isRequestAttributedToProxyApp()) {
            if (!isLocationRequestAccepted) {
                if (DEBUG) {
                    Log.d("GnssVisibilityControl", "Non-framework location request rejected. ProxyAppPackageName field is not set in the notification: " + nfwNotification + ". Number of configured proxy apps: " + this.mProxyAppsState.size());
                }
                return;
            }
            Log.e("GnssVisibilityControl", "ProxyAppPackageName field is not set. AppOps service not notified for notification: " + nfwNotification);
            return;
        }
        if (proxyAppState == null) {
            Log.w("GnssVisibilityControl", "Could not find proxy app " + proxyAppPkgName + " in the value specified for config parameter: " + "NFW_PROXY_APPS" + ". AppOps service not notified for notification: " + nfwNotification);
            return;
        }
        ApplicationInfo proxyAppInfo = this.getProxyAppInfo(proxyAppPkgName);
        if (proxyAppInfo == null) {
            Log.e("GnssVisibilityControl", "Proxy app " + proxyAppPkgName + " is not found. AppOps service not notified for notification: " + nfwNotification);
            return;
        }
        if (nfwNotification.isLocationProvided()) {
            this.showLocationIcon(proxyAppState, nfwNotification, proxyAppInfo.uid, proxyAppPkgName);
            this.mAppOps.noteOpNoThrow(1, proxyAppInfo.uid, proxyAppPkgName);
        }
        if (isPermissionMismatched) {
            Log.w("GnssVisibilityControl", "Permission mismatch. Proxy app " + proxyAppPkgName + " location permission is set to " + proxyAppState.mHasLocationPermission + " and GNSS HAL enabled is set to " + this.mIsGpsEnabled + " but GNSS non-framework location access response type is " + nfwNotification.getResponseTypeAsString() + " for notification: " + nfwNotification);
        }
    }

    private boolean isPermissionMismatched(ProxyAppState proxyAppState, NfwNotification nfwNotification) {
        boolean isLocationRequestAccepted = nfwNotification.isRequestAccepted();
        return proxyAppState == null || !this.mIsGpsEnabled ? isLocationRequestAccepted : proxyAppState.mHasLocationPermission != isLocationRequestAccepted;
    }

    private void showLocationIcon(ProxyAppState proxyAppState, NfwNotification nfwNotification, int uid, String proxyAppPkgName) {
        boolean isLocationIconOn = proxyAppState.mIsLocationIconOn;
        if (!isLocationIconOn) {
            if (!this.updateLocationIcon(true, uid, proxyAppPkgName)) {
                Log.w("GnssVisibilityControl", "Failed to show Location icon for notification: " + nfwNotification);
                return;
            }
            proxyAppState.mIsLocationIconOn = true;
        } else {
            this.mHandler.removeCallbacksAndMessages(proxyAppState);
        }
        if (DEBUG) {
            Log.d("GnssVisibilityControl", "Location icon on. " + (isLocationIconOn ? "Extending" : "Setting") + " icon display timer. Uid: " + uid + ", proxyAppPkgName: " + proxyAppPkgName);
        }
        if (!this.mHandler.postDelayed(() -> this.handleLocationIconTimeout(proxyAppPkgName), proxyAppState, 5000L)) {
            this.clearLocationIcon(proxyAppState, uid, proxyAppPkgName);
            Log.w("GnssVisibilityControl", "Failed to show location icon for the full duration for notification: " + nfwNotification);
        }
    }

    private void handleLocationIconTimeout(String proxyAppPkgName) {
        ApplicationInfo proxyAppInfo = this.getProxyAppInfo(proxyAppPkgName);
        if (proxyAppInfo != null) {
            this.clearLocationIcon(this.mProxyAppsState.get(proxyAppPkgName), proxyAppInfo.uid, proxyAppPkgName);
        }
    }

    private void clearLocationIcon(ProxyAppState proxyAppState, int uid, String proxyAppPkgName) {
        this.updateLocationIcon(false, uid, proxyAppPkgName);
        if (proxyAppState != null) {
            proxyAppState.mIsLocationIconOn = false;
        }
        if (DEBUG) {
            Log.d("GnssVisibilityControl", "Location icon off. Uid: " + uid + ", proxyAppPkgName: " + proxyAppPkgName);
        }
    }

    private boolean updateLocationIcon(boolean displayLocationIcon, int uid, String proxyAppPkgName) {
        if (displayLocationIcon) {
            if (this.mAppOps.startOpNoThrow(41, uid, proxyAppPkgName) != 0) {
                return false;
            }
            if (this.mAppOps.startOpNoThrow(42, uid, proxyAppPkgName) != 0) {
                this.mAppOps.finishOp(41, uid, proxyAppPkgName);
                return false;
            }
        } else {
            this.mAppOps.finishOp(41, uid, proxyAppPkgName);
            this.mAppOps.finishOp(42, uid, proxyAppPkgName);
        }
        this.sendHighPowerMonitoringBroadcast();
        return true;
    }

    private void sendHighPowerMonitoringBroadcast() {
        Intent intent = new Intent("android.location.HIGH_POWER_REQUEST_CHANGE");
        this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void handleEmergencyNfwNotification(NfwNotification nfwNotification) {
        boolean isPermissionMismatched = false;
        if (!nfwNotification.isRequestAccepted()) {
            Log.e("GnssVisibilityControl", "Emergency non-framework location request incorrectly rejected. Notification: " + nfwNotification);
            isPermissionMismatched = true;
        }
        if (!this.mNiHandler.getInEmergency()) {
            Log.w("GnssVisibilityControl", "Emergency state mismatch. Device currently not in user initiated emergency session. Notification: " + nfwNotification);
            isPermissionMismatched = true;
        }
        this.logEvent(nfwNotification, isPermissionMismatched);
        if (nfwNotification.isLocationProvided()) {
            this.postEmergencyLocationUserNotification(nfwNotification);
        }
    }

    private void postEmergencyLocationUserNotification(NfwNotification nfwNotification) {
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (notificationManager == null) {
            Log.w("GnssVisibilityControl", "Could not notify user of emergency location request. Notification: " + nfwNotification);
            return;
        }
        notificationManager.notifyAsUser(null, 0, GnssVisibilityControl.createEmergencyLocationUserNotification(this.mContext), UserHandle.ALL);
    }

    private static Notification createEmergencyLocationUserNotification(Context context) {
        String firstLineText = context.getString(17040069);
        String secondLineText = context.getString(17040051);
        String accessibilityServicesText = firstLineText + " (" + secondLineText + ")";
        return new Notification.Builder(context, SystemNotificationChannels.NETWORK_ALERTS).setSmallIcon(0x1080808).setWhen(0L).setOngoing(true).setAutoCancel(true).setColor(context.getColor(17170460)).setDefaults(0).setTicker(accessibilityServicesText).setContentTitle(firstLineText).setContentText(secondLineText).setContentIntent(PendingIntent.getBroadcast(context, 0, new Intent(), 0)).build();
    }

    private void logEvent(NfwNotification notification, boolean isPermissionMismatched) {
        StatsLog.write(131, notification.mProxyAppPackageName, (int)notification.mProtocolStack, notification.mOtherProtocolStackName, (int)notification.mRequestor, notification.mRequestorId, (int)notification.mResponseType, notification.mInEmergencyMode, notification.mIsCachedLocation, isPermissionMismatched);
    }

    private void runOnHandler(Runnable event) {
        this.mWakeLock.acquire(60000L);
        if (!this.mHandler.post(this.runEventAndReleaseWakeLock(event))) {
            this.mWakeLock.release();
        }
    }

    private Runnable runEventAndReleaseWakeLock(Runnable event) {
        return () -> {
            try {
                event.run();
            }
            finally {
                this.mWakeLock.release();
            }
        };
    }

    private native boolean native_enable_nfw_location_access(String[] var1);

    private static class NfwNotification {
        private static final byte NFW_RESPONSE_TYPE_REJECTED = 0;
        private static final byte NFW_RESPONSE_TYPE_ACCEPTED_NO_LOCATION_PROVIDED = 1;
        private static final byte NFW_RESPONSE_TYPE_ACCEPTED_LOCATION_PROVIDED = 2;
        private final String mProxyAppPackageName;
        private final byte mProtocolStack;
        private final String mOtherProtocolStackName;
        private final byte mRequestor;
        private final String mRequestorId;
        private final byte mResponseType;
        private final boolean mInEmergencyMode;
        private final boolean mIsCachedLocation;

        private NfwNotification(String proxyAppPackageName, byte protocolStack, String otherProtocolStackName, byte requestor, String requestorId, byte responseType, boolean inEmergencyMode, boolean isCachedLocation) {
            this.mProxyAppPackageName = proxyAppPackageName;
            this.mProtocolStack = protocolStack;
            this.mOtherProtocolStackName = otherProtocolStackName;
            this.mRequestor = requestor;
            this.mRequestorId = requestorId;
            this.mResponseType = responseType;
            this.mInEmergencyMode = inEmergencyMode;
            this.mIsCachedLocation = isCachedLocation;
        }

        @SuppressLint(value={"DefaultLocale"})
        public String toString() {
            return String.format("{proxyAppPackageName: %s, protocolStack: %d, otherProtocolStackName: %s, requestor: %d, requestorId: %s, responseType: %s, inEmergencyMode: %b, isCachedLocation: %b}", this.mProxyAppPackageName, this.mProtocolStack, this.mOtherProtocolStackName, this.mRequestor, this.mRequestorId, this.getResponseTypeAsString(), this.mInEmergencyMode, this.mIsCachedLocation);
        }

        private String getResponseTypeAsString() {
            switch (this.mResponseType) {
                case 0: {
                    return "REJECTED";
                }
                case 1: {
                    return "ACCEPTED_NO_LOCATION_PROVIDED";
                }
                case 2: {
                    return "ACCEPTED_LOCATION_PROVIDED";
                }
            }
            return "<Unknown>";
        }

        private boolean isRequestAccepted() {
            return this.mResponseType != 0;
        }

        private boolean isLocationProvided() {
            return this.mResponseType == 2;
        }

        private boolean isRequestAttributedToProxyApp() {
            return !TextUtils.isEmpty(this.mProxyAppPackageName);
        }

        private boolean isEmergencyRequestNotification() {
            return this.mInEmergencyMode && !this.isRequestAttributedToProxyApp();
        }
    }

    private static final class ProxyAppState {
        private boolean mHasLocationPermission;
        private boolean mIsLocationIconOn;

        private ProxyAppState(boolean hasLocationPermission) {
            this.mHasLocationPermission = hasLocationPermission;
        }
    }
}

