/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.net.TrafficStats;
import android.text.TextUtils;
import android.util.Log;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class GpsPsdsDownloader {
    private static final String TAG = "GpsPsdsDownloader";
    private static final boolean DEBUG = Log.isLoggable("GpsPsdsDownloader", 3);
    private static final long MAXIMUM_CONTENT_LENGTH_BYTES = 1000000L;
    private static final String DEFAULT_USER_AGENT = "Android";
    private static final int CONNECTION_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int READ_TIMEOUT_MS = (int)TimeUnit.SECONDS.toMillis(60L);
    private final String[] mPsdsServers;
    private int mNextServerIndex;
    private final String mUserAgent;

    GpsPsdsDownloader(Properties properties) {
        String agent;
        int count = 0;
        String server1 = properties.getProperty("XTRA_SERVER_1");
        String server2 = properties.getProperty("XTRA_SERVER_2");
        String server3 = properties.getProperty("XTRA_SERVER_3");
        if (server1 != null) {
            ++count;
        }
        if (server2 != null) {
            ++count;
        }
        if (server3 != null) {
            ++count;
        }
        this.mUserAgent = TextUtils.isEmpty(agent = properties.getProperty("XTRA_USER_AGENT")) ? DEFAULT_USER_AGENT : agent;
        if (count == 0) {
            Log.e(TAG, "No PSDS servers were specified in the GPS configuration");
            this.mPsdsServers = null;
        } else {
            this.mPsdsServers = new String[count];
            count = 0;
            if (server1 != null) {
                this.mPsdsServers[count++] = server1;
            }
            if (server2 != null) {
                this.mPsdsServers[count++] = server2;
            }
            if (server3 != null) {
                this.mPsdsServers[count++] = server3;
            }
            Random random = new Random();
            this.mNextServerIndex = random.nextInt(count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] downloadPsdsData() {
        byte[] result = null;
        int startIndex = this.mNextServerIndex;
        if (this.mPsdsServers == null) {
            return null;
        }
        while (result == null) {
            int oldTag = TrafficStats.getAndSetThreadStatsTag(-188);
            try {
                result = this.doDownload(this.mPsdsServers[this.mNextServerIndex]);
            }
            finally {
                TrafficStats.setThreadStatsTag(oldTag);
            }
            ++this.mNextServerIndex;
            if (this.mNextServerIndex == this.mPsdsServers.length) {
                this.mNextServerIndex = 0;
            }
            if (this.mNextServerIndex != startIndex) continue;
            break;
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    protected byte[] doDownload(String url) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

