/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.database.ContentObserver;
import android.location.Location;
import android.os.Handler;
import android.os.SystemClock;
import android.provider.Settings;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.security.SecureRandom;

public class LocationFudger {
    private static final boolean D = false;
    private static final String TAG = "LocationFudge";
    private static final float DEFAULT_ACCURACY_IN_METERS = 2000.0f;
    private static final float MINIMUM_ACCURACY_IN_METERS = 200.0f;
    private static final String COARSE_ACCURACY_CONFIG_NAME = "locationCoarseAccuracy";
    public static final long FASTEST_INTERVAL_MS = 600000L;
    private static final long CHANGE_INTERVAL_MS = 3600000L;
    private static final double CHANGE_PER_INTERVAL = 0.03;
    private static final double NEW_WEIGHT = 0.03;
    private static final double PREVIOUS_WEIGHT = Math.sqrt(0.9991);
    private static final int APPROXIMATE_METERS_PER_DEGREE_AT_EQUATOR = 111000;
    private static final double MAX_LATITUDE = 89.999990990991;
    private final Object mLock = new Object();
    private final SecureRandom mRandom = new SecureRandom();
    private final ContentObserver mSettingsObserver;
    private final Context mContext;
    private double mOffsetLatitudeMeters;
    private double mOffsetLongitudeMeters;
    private long mNextInterval;
    private float mAccuracyInMeters;
    private double mGridSizeInMeters;
    private double mStandardDeviationInMeters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationFudger(Context context, Handler handler) {
        this.mContext = context;
        this.mSettingsObserver = new ContentObserver(handler){

            @Override
            public void onChange(boolean selfChange) {
                LocationFudger.this.setAccuracyInMeters(LocationFudger.this.loadCoarseAccuracy());
            }
        };
        this.mContext.getContentResolver().registerContentObserver(Settings.Secure.getUriFor(COARSE_ACCURACY_CONFIG_NAME), false, this.mSettingsObserver);
        float accuracy = this.loadCoarseAccuracy();
        Object object = this.mLock;
        synchronized (object) {
            this.setAccuracyInMetersLocked(accuracy);
            this.mOffsetLatitudeMeters = this.nextOffsetLocked();
            this.mOffsetLongitudeMeters = this.nextOffsetLocked();
            this.mNextInterval = SystemClock.elapsedRealtime() + 3600000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getOrCreate(Location location) {
        Object object = this.mLock;
        synchronized (object) {
            Location coarse = location.getExtraLocation("coarseLocation");
            if (coarse == null) {
                return this.addCoarseLocationExtraLocked(location);
            }
            if (coarse.getAccuracy() < this.mAccuracyInMeters) {
                return this.addCoarseLocationExtraLocked(location);
            }
            return coarse;
        }
    }

    private Location addCoarseLocationExtraLocked(Location location) {
        Location coarse = this.createCoarseLocked(location);
        location.setExtraLocation("coarseLocation", coarse);
        return coarse;
    }

    private Location createCoarseLocked(Location fine) {
        Location coarse = new Location(fine);
        coarse.removeBearing();
        coarse.removeSpeed();
        coarse.removeAltitude();
        coarse.setExtras(null);
        double lat = coarse.getLatitude();
        double lon = coarse.getLongitude();
        lat = LocationFudger.wrapLatitude(lat);
        lon = LocationFudger.wrapLongitude(lon);
        this.updateRandomOffsetLocked();
        lon += LocationFudger.metersToDegreesLongitude(this.mOffsetLongitudeMeters, lat);
        lat += LocationFudger.metersToDegreesLatitude(this.mOffsetLatitudeMeters);
        lat = LocationFudger.wrapLatitude(lat);
        lon = LocationFudger.wrapLongitude(lon);
        double latGranularity = LocationFudger.metersToDegreesLatitude(this.mGridSizeInMeters);
        lat = (double)Math.round(lat / latGranularity) * latGranularity;
        double lonGranularity = LocationFudger.metersToDegreesLongitude(this.mGridSizeInMeters, lat);
        lon = (double)Math.round(lon / lonGranularity) * lonGranularity;
        lat = LocationFudger.wrapLatitude(lat);
        lon = LocationFudger.wrapLongitude(lon);
        coarse.setLatitude(lat);
        coarse.setLongitude(lon);
        coarse.setAccuracy(Math.max(this.mAccuracyInMeters, coarse.getAccuracy()));
        return coarse;
    }

    private void updateRandomOffsetLocked() {
        long now = SystemClock.elapsedRealtime();
        if (now < this.mNextInterval) {
            return;
        }
        this.mNextInterval = now + 3600000L;
        this.mOffsetLatitudeMeters *= PREVIOUS_WEIGHT;
        this.mOffsetLatitudeMeters += 0.03 * this.nextOffsetLocked();
        this.mOffsetLongitudeMeters *= PREVIOUS_WEIGHT;
        this.mOffsetLongitudeMeters += 0.03 * this.nextOffsetLocked();
    }

    private double nextOffsetLocked() {
        return this.mRandom.nextGaussian() * this.mStandardDeviationInMeters;
    }

    private static double wrapLatitude(double lat) {
        if (lat > 89.999990990991) {
            lat = 89.999990990991;
        }
        if (lat < -89.999990990991) {
            lat = -89.999990990991;
        }
        return lat;
    }

    private static double wrapLongitude(double lon) {
        if ((lon %= 360.0) >= 180.0) {
            lon -= 360.0;
        }
        if (lon < -180.0) {
            lon += 360.0;
        }
        return lon;
    }

    private static double metersToDegreesLatitude(double distance) {
        return distance / 111000.0;
    }

    private static double metersToDegreesLongitude(double distance, double lat) {
        return distance / 111000.0 / Math.cos(Math.toRadians(lat));
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println(String.format("offset: %.0f, %.0f (meters)", this.mOffsetLongitudeMeters, this.mOffsetLatitudeMeters));
    }

    private void setAccuracyInMetersLocked(float accuracyInMeters) {
        this.mAccuracyInMeters = Math.max(accuracyInMeters, 200.0f);
        this.mGridSizeInMeters = this.mAccuracyInMeters;
        this.mStandardDeviationInMeters = this.mGridSizeInMeters / 4.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAccuracyInMeters(float accuracyInMeters) {
        Object object = this.mLock;
        synchronized (object) {
            this.setAccuracyInMetersLocked(accuracyInMeters);
        }
    }

    private float loadCoarseAccuracy() {
        String newSetting = Settings.Secure.getString(this.mContext.getContentResolver(), COARSE_ACCURACY_CONFIG_NAME);
        if (newSetting == null) {
            return 2000.0f;
        }
        try {
            return Float.parseFloat(newSetting);
        }
        catch (NumberFormatException e) {
            return 2000.0f;
        }
    }
}

