/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.content.Context;
import android.content.pm.PackageManager;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.WorkSource;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.location.ILocationProvider;
import com.android.internal.location.ILocationProviderManager;
import com.android.internal.location.ProviderProperties;
import com.android.internal.location.ProviderRequest;
import com.android.server.FgThread;
import com.android.server.LocationManagerService;
import com.android.server.ServiceWatcher;
import com.android.server.location.AbstractLocationProvider;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LocationProviderProxy
extends AbstractLocationProvider {
    private static final String TAG = "LocationProviderProxy";
    private static final boolean D = LocationManagerService.D;
    private final Object mProviderPackagesLock = new Object();
    private final Object mRequestLock = new Object();
    private final ILocationProviderManager.Stub mManager = new ILocationProviderManager.Stub(){

        @Override
        public void onSetAdditionalProviderPackages(List<String> packageNames) {
            LocationProviderProxy.this.onSetAdditionalProviderPackages(packageNames);
        }

        @Override
        public void onSetEnabled(boolean enabled) {
            LocationProviderProxy.this.setEnabled(enabled);
        }

        @Override
        public void onSetProperties(ProviderProperties properties) {
            LocationProviderProxy.this.setProperties(properties);
        }

        @Override
        public void onReportLocation(Location location) {
            LocationProviderProxy.this.reportLocation(location);
        }
    };
    private final ServiceWatcher mServiceWatcher;
    @GuardedBy(value={"mProviderPackagesLock"})
    private final CopyOnWriteArrayList<String> mProviderPackages = new CopyOnWriteArrayList();
    @GuardedBy(value={"mRequestLock"})
    private ProviderRequest mRequest;
    @GuardedBy(value={"mRequestLock"})
    private WorkSource mWorkSource;

    public static LocationProviderProxy createAndBind(Context context, AbstractLocationProvider.LocationProviderManager locationProviderManager, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId) {
        LocationProviderProxy proxy = new LocationProviderProxy(context, locationProviderManager, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId);
        if (proxy.bind()) {
            return proxy;
        }
        return null;
    }

    private LocationProviderProxy(Context context, AbstractLocationProvider.LocationProviderManager locationProviderManager, String action, int overlaySwitchResId, int defaultServicePackageNameResId, int initialPackageNamesResId) {
        super(context, locationProviderManager);
        this.mServiceWatcher = new ServiceWatcher(context, TAG, action, overlaySwitchResId, defaultServicePackageNameResId, initialPackageNamesResId, FgThread.getHandler()){

            @Override
            protected void onBind() {
                this.runOnBinder(x$0 -> LocationProviderProxy.this.initializeService(x$0));
            }

            @Override
            protected void onUnbind() {
                LocationProviderProxy.this.resetProviderPackages(Collections.emptyList());
                LocationProviderProxy.this.setEnabled(false);
                LocationProviderProxy.this.setProperties(null);
            }
        };
        this.mRequest = null;
        this.mWorkSource = new WorkSource();
    }

    private boolean bind() {
        return this.mServiceWatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeService(IBinder binder) throws RemoteException {
        ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
        if (D) {
            Log.d(TAG, "applying state to connected service " + this.mServiceWatcher);
        }
        this.resetProviderPackages(Collections.emptyList());
        service.setLocationProviderManager(this.mManager);
        Object object = this.mRequestLock;
        synchronized (object) {
            if (this.mRequest != null) {
                service.setRequest(this.mRequest, this.mWorkSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getProviderPackages() {
        Object object = this.mProviderPackagesLock;
        synchronized (object) {
            return this.mProviderPackages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequest(ProviderRequest request, WorkSource source) {
        Object object = this.mRequestLock;
        synchronized (object) {
            this.mRequest = request;
            this.mWorkSource = source;
        }
        this.mServiceWatcher.runOnBinder(binder -> {
            ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
            service.setRequest(request, source);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("    service=" + this.mServiceWatcher);
        Object object = this.mProviderPackagesLock;
        synchronized (object) {
            if (this.mProviderPackages.size() > 1) {
                pw.println("    additional packages=" + this.mProviderPackages);
            }
        }
    }

    @Override
    public int getStatus(Bundle extras) {
        return this.mServiceWatcher.runOnBinderBlocking(binder -> {
            ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
            return service.getStatus(extras);
        }, 1);
    }

    @Override
    public long getStatusUpdateTime() {
        return this.mServiceWatcher.runOnBinderBlocking(binder -> {
            ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
            return service.getStatusUpdateTime();
        }, 0L);
    }

    @Override
    public void sendExtraCommand(String command, Bundle extras) {
        this.mServiceWatcher.runOnBinder(binder -> {
            ILocationProvider service = ILocationProvider.Stub.asInterface(binder);
            service.sendExtraCommand(command, extras);
        });
    }

    private void onSetAdditionalProviderPackages(List<String> packageNames) {
        this.resetProviderPackages(packageNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetProviderPackages(List<String> additionalPackageNames) {
        ArrayList<String> permittedPackages = new ArrayList<String>(additionalPackageNames.size());
        for (String packageName : additionalPackageNames) {
            try {
                this.mContext.getPackageManager().getPackageInfo(packageName, 0x100000);
                permittedPackages.add(packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w(TAG, this.mServiceWatcher + " specified unknown additional provider package: " + packageName);
            }
        }
        Object object = this.mProviderPackagesLock;
        synchronized (object) {
            this.mProviderPackages.clear();
            String myPackage = this.mServiceWatcher.getCurrentPackageName();
            if (myPackage != null) {
                this.mProviderPackages.add(myPackage);
                this.mProviderPackages.addAll(permittedPackages);
            }
        }
    }
}

