/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.os.SystemClock;
import android.util.Log;
import java.util.HashMap;

public class LocationRequestStatistics {
    private static final String TAG = "LocationStats";
    public final HashMap<PackageProviderKey, PackageStatistics> statistics = new HashMap();

    public void startRequesting(String packageName, String providerName, long intervalMs, boolean isForeground) {
        PackageProviderKey key = new PackageProviderKey(packageName, providerName);
        PackageStatistics stats = this.statistics.get(key);
        if (stats == null) {
            stats = new PackageStatistics();
            this.statistics.put(key, stats);
        }
        stats.startRequesting(intervalMs);
        stats.updateForeground(isForeground);
    }

    public void stopRequesting(String packageName, String providerName) {
        PackageProviderKey key = new PackageProviderKey(packageName, providerName);
        PackageStatistics stats = this.statistics.get(key);
        if (stats != null) {
            stats.stopRequesting();
        }
    }

    public void updateForeground(String packageName, String providerName, boolean isForeground) {
        PackageProviderKey key = new PackageProviderKey(packageName, providerName);
        PackageStatistics stats = this.statistics.get(key);
        if (stats != null) {
            stats.updateForeground(isForeground);
        }
    }

    public static class PackageStatistics {
        private final long mInitialElapsedTimeMs = SystemClock.elapsedRealtime();
        private int mNumActiveRequests = 0;
        private long mLastActivitationElapsedTimeMs;
        private long mFastestIntervalMs = Long.MAX_VALUE;
        private long mSlowestIntervalMs = 0L;
        private long mTotalDurationMs = 0L;
        private long mLastForegroundElapsedTimeMs = 0L;
        private long mForegroundDurationMs = 0L;
        private long mLastStopElapsedTimeMs = 0L;

        private PackageStatistics() {
        }

        private void startRequesting(long intervalMs) {
            if (this.mNumActiveRequests == 0) {
                this.mLastActivitationElapsedTimeMs = SystemClock.elapsedRealtime();
            }
            if (intervalMs < this.mFastestIntervalMs) {
                this.mFastestIntervalMs = intervalMs;
            }
            if (intervalMs > this.mSlowestIntervalMs) {
                this.mSlowestIntervalMs = intervalMs;
            }
            ++this.mNumActiveRequests;
        }

        private void updateForeground(boolean isForeground) {
            long nowElapsedTimeMs = SystemClock.elapsedRealtime();
            if (this.mLastForegroundElapsedTimeMs != 0L) {
                this.mForegroundDurationMs += nowElapsedTimeMs - this.mLastForegroundElapsedTimeMs;
            }
            this.mLastForegroundElapsedTimeMs = isForeground ? nowElapsedTimeMs : 0L;
        }

        private void stopRequesting() {
            if (this.mNumActiveRequests <= 0) {
                Log.e(LocationRequestStatistics.TAG, "Reference counting corrupted in usage statistics.");
                return;
            }
            --this.mNumActiveRequests;
            if (this.mNumActiveRequests == 0) {
                this.mLastStopElapsedTimeMs = SystemClock.elapsedRealtime();
                long lastDurationMs = this.mLastStopElapsedTimeMs - this.mLastActivitationElapsedTimeMs;
                this.mTotalDurationMs += lastDurationMs;
                this.updateForeground(false);
            }
        }

        public long getDurationMs() {
            long currentDurationMs = this.mTotalDurationMs;
            if (this.mNumActiveRequests > 0) {
                currentDurationMs += SystemClock.elapsedRealtime() - this.mLastActivitationElapsedTimeMs;
            }
            return currentDurationMs;
        }

        public long getForegroundDurationMs() {
            long currentDurationMs = this.mForegroundDurationMs;
            if (this.mLastForegroundElapsedTimeMs != 0L) {
                currentDurationMs += SystemClock.elapsedRealtime() - this.mLastForegroundElapsedTimeMs;
            }
            return currentDurationMs;
        }

        public long getTimeSinceFirstRequestMs() {
            return SystemClock.elapsedRealtime() - this.mInitialElapsedTimeMs;
        }

        public long getTimeSinceLastRequestStoppedMs() {
            return SystemClock.elapsedRealtime() - this.mLastStopElapsedTimeMs;
        }

        public long getFastestIntervalMs() {
            return this.mFastestIntervalMs;
        }

        public long getSlowestIntervalMs() {
            return this.mSlowestIntervalMs;
        }

        public boolean isActive() {
            return this.mNumActiveRequests > 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            if (this.mFastestIntervalMs == this.mSlowestIntervalMs) {
                s.append("Interval ").append(this.mFastestIntervalMs / 1000L).append(" seconds");
            } else {
                s.append("Min interval ").append(this.mFastestIntervalMs / 1000L).append(" seconds");
                s.append(": Max interval ").append(this.mSlowestIntervalMs / 1000L).append(" seconds");
            }
            s.append(": Duration requested ").append(this.getDurationMs() / 1000L / 60L).append(" total, ").append(this.getForegroundDurationMs() / 1000L / 60L).append(" foreground, out of the last ").append(this.getTimeSinceFirstRequestMs() / 1000L / 60L).append(" minutes");
            if (this.isActive()) {
                s.append(": Currently active");
            } else {
                s.append(": Last active ").append(this.getTimeSinceLastRequestStoppedMs() / 1000L / 60L).append(" minutes ago");
            }
            return s.toString();
        }
    }

    public static class PackageProviderKey {
        public final String packageName;
        public final String providerName;

        public PackageProviderKey(String packageName, String providerName) {
            this.packageName = packageName;
            this.providerName = providerName;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PackageProviderKey)) {
                return false;
            }
            PackageProviderKey otherKey = (PackageProviderKey)other;
            return this.packageName.equals(otherKey.packageName) && this.providerName.equals(otherKey.providerName);
        }

        public int hashCode() {
            return this.packageName.hashCode() + 31 * this.providerName.hashCode();
        }
    }
}

