/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.hardware.contexthub.V1_0.HubAppInfo;
import android.hardware.location.NanoAppInstanceInfo;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;

class NanoAppStateManager {
    private static final String TAG = "NanoAppStateManager";
    private static final boolean ENABLE_LOG_DEBUG = true;
    private final HashMap<Integer, NanoAppInstanceInfo> mNanoAppHash = new HashMap();
    private int mNextHandle = 0;

    NanoAppStateManager() {
    }

    synchronized NanoAppInstanceInfo getNanoAppInstanceInfo(int nanoAppHandle) {
        return this.mNanoAppHash.get(nanoAppHandle);
    }

    synchronized void foreachNanoAppInstanceInfo(Consumer<NanoAppInstanceInfo> consumer) {
        for (NanoAppInstanceInfo info : this.mNanoAppHash.values()) {
            consumer.accept(info);
        }
    }

    synchronized int getNanoAppHandle(int contextHubId, long nanoAppId) {
        for (NanoAppInstanceInfo info : this.mNanoAppHash.values()) {
            if (info.getContexthubId() != contextHubId || info.getAppId() != nanoAppId) continue;
            return info.getHandle();
        }
        return -1;
    }

    synchronized void addNanoAppInstance(int contextHubId, long nanoAppId, int nanoAppVersion) {
        this.removeNanoAppInstance(contextHubId, nanoAppId);
        if (this.mNanoAppHash.size() == Integer.MAX_VALUE) {
            Log.e(TAG, "Error adding nanoapp instance: max limit exceeded");
            return;
        }
        int nanoAppHandle = this.mNextHandle;
        for (int i = 0; i <= Integer.MAX_VALUE; ++i) {
            if (!this.mNanoAppHash.containsKey(nanoAppHandle)) {
                this.mNanoAppHash.put(nanoAppHandle, new NanoAppInstanceInfo(nanoAppHandle, nanoAppId, nanoAppVersion, contextHubId));
                this.mNextHandle = nanoAppHandle == Integer.MAX_VALUE ? 0 : nanoAppHandle + 1;
                break;
            }
            nanoAppHandle = nanoAppHandle == Integer.MAX_VALUE ? 0 : nanoAppHandle + 1;
        }
        Log.v(TAG, "Added app instance with handle " + nanoAppHandle + " to hub " + contextHubId + ": ID=0x" + Long.toHexString(nanoAppId) + ", version=0x" + Integer.toHexString(nanoAppVersion));
    }

    synchronized void removeNanoAppInstance(int contextHubId, long nanoAppId) {
        int nanoAppHandle = this.getNanoAppHandle(contextHubId, nanoAppId);
        this.mNanoAppHash.remove(nanoAppHandle);
    }

    synchronized void updateCache(int contextHubId, List<HubAppInfo> nanoAppInfoList) {
        HashSet<Long> nanoAppIdSet = new HashSet<Long>();
        for (HubAppInfo appInfo : nanoAppInfoList) {
            this.handleQueryAppEntry(contextHubId, appInfo.appId, appInfo.version);
            nanoAppIdSet.add(appInfo.appId);
        }
        Iterator<NanoAppInstanceInfo> iterator = this.mNanoAppHash.values().iterator();
        while (iterator.hasNext()) {
            NanoAppInstanceInfo info = iterator.next();
            if (info.getContexthubId() != contextHubId || nanoAppIdSet.contains(info.getAppId())) continue;
            iterator.remove();
        }
    }

    private void handleQueryAppEntry(int contextHubId, long nanoAppId, int nanoAppVersion) {
        int nanoAppHandle = this.getNanoAppHandle(contextHubId, nanoAppId);
        if (nanoAppHandle == -1) {
            this.addNanoAppInstance(contextHubId, nanoAppId, nanoAppVersion);
        } else {
            NanoAppInstanceInfo info = this.mNanoAppHash.get(nanoAppHandle);
            if (info.getAppVersion() != nanoAppVersion) {
                this.mNanoAppHash.put(nanoAppHandle, new NanoAppInstanceInfo(nanoAppHandle, nanoAppId, nanoAppVersion, contextHubId));
                Log.v(TAG, "Updated app instance with handle " + nanoAppHandle + " at hub " + contextHubId + ": ID=0x" + Long.toHexString(nanoAppId) + ", version=0x" + Integer.toHexString(nanoAppVersion));
            }
        }
    }
}

