/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.app.AppOpsManager;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.android.server.location.CallerIdentity;
import com.android.server.location.LocationPermissionUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class RemoteListenerHelper<TListener extends IInterface> {
    protected static final int RESULT_SUCCESS = 0;
    protected static final int RESULT_NOT_AVAILABLE = 1;
    protected static final int RESULT_NOT_SUPPORTED = 2;
    protected static final int RESULT_GPS_LOCATION_DISABLED = 3;
    protected static final int RESULT_INTERNAL_ERROR = 4;
    protected static final int RESULT_UNKNOWN = 5;
    protected static final int RESULT_NOT_ALLOWED = 6;
    protected final Handler mHandler;
    private final String mTag;
    private final Map<IBinder, IdentifiedListener> mListenerMap = new HashMap<IBinder, IdentifiedListener>();
    protected final Context mContext;
    protected final AppOpsManager mAppOps;
    private volatile boolean mIsRegistered;
    private boolean mHasIsSupported;
    private boolean mIsSupported;
    private int mLastReportedResult = 5;

    protected RemoteListenerHelper(Context context, Handler handler, String name) {
        Preconditions.checkNotNull(name);
        this.mHandler = handler;
        this.mTag = name;
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
    }

    public boolean isRegistered() {
        return this.mIsRegistered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TListener listener, CallerIdentity callerIdentity) {
        Preconditions.checkNotNull(listener, "Attempted to register a 'null' listener.");
        IBinder binder = listener.asBinder();
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            int result;
            if (this.mListenerMap.containsKey(binder)) {
                return;
            }
            IdentifiedListener identifiedListener = new IdentifiedListener(this, (IInterface)listener, callerIdentity);
            this.mListenerMap.put(binder, identifiedListener);
            if (!this.isAvailableInPlatform()) {
                result = 1;
            } else if (this.mHasIsSupported && !this.mIsSupported) {
                result = 2;
            } else if (!this.isGpsEnabled()) {
                result = 3;
            } else if (this.mHasIsSupported && this.mIsSupported) {
                this.tryRegister();
                result = 0;
            } else {
                return;
            }
            this.post(identifiedListener, this.getHandlerOperation(result));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TListener listener) {
        Preconditions.checkNotNull(listener, "Attempted to remove a 'null' listener.");
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            this.mListenerMap.remove(listener.asBinder());
            if (this.mListenerMap.isEmpty()) {
                this.tryUnregister();
            }
        }
    }

    protected abstract boolean isAvailableInPlatform();

    protected abstract boolean isGpsEnabled();

    protected abstract int registerWithService();

    protected abstract void unregisterFromService();

    protected abstract ListenerOperation<TListener> getHandlerOperation(int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void foreach(ListenerOperation<TListener> operation) {
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            this.foreachUnsafe(operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupported(boolean value) {
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            this.mHasIsSupported = true;
            this.mIsSupported = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryUpdateRegistrationWithService() {
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            if (!this.isGpsEnabled()) {
                this.tryUnregister();
                return;
            }
            if (this.mListenerMap.isEmpty()) {
                return;
            }
            this.tryRegister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResult() {
        Map<IBinder, IdentifiedListener> map = this.mListenerMap;
        synchronized (map) {
            int newResult = this.calculateCurrentResultUnsafe();
            if (this.mLastReportedResult == newResult) {
                return;
            }
            this.foreachUnsafe(this.getHandlerOperation(newResult));
            this.mLastReportedResult = newResult;
        }
    }

    protected boolean hasPermission(Context context, CallerIdentity callerIdentity) {
        if (LocationPermissionUtil.doesCallerReportToAppOps(context, callerIdentity)) {
            return this.mAppOps.checkOpNoThrow(1, callerIdentity.mUid, callerIdentity.mPackageName) == 0;
        }
        return this.mAppOps.noteOpNoThrow(1, callerIdentity.mUid, callerIdentity.mPackageName) == 0;
    }

    protected void logPermissionDisabledEventNotReported(String tag, String packageName, String event) {
        if (Log.isLoggable(tag, 3)) {
            Log.d(tag, "Location permission disabled. Skipping " + event + " reporting for app: " + packageName);
        }
    }

    private void foreachUnsafe(ListenerOperation<TListener> operation) {
        for (IdentifiedListener identifiedListener : this.mListenerMap.values()) {
            this.post(identifiedListener, operation);
        }
    }

    private void post(IdentifiedListener identifiedListener, ListenerOperation<TListener> operation) {
        if (operation != null) {
            this.mHandler.post(new HandlerRunnable(identifiedListener, operation));
        }
    }

    private void tryRegister() {
        this.mHandler.post(new Runnable(){
            int registrationState = 4;

            @Override
            public void run() {
                if (!RemoteListenerHelper.this.mIsRegistered) {
                    this.registrationState = RemoteListenerHelper.this.registerWithService();
                    RemoteListenerHelper.this.mIsRegistered = this.registrationState == 0;
                }
                if (!RemoteListenerHelper.this.mIsRegistered) {
                    RemoteListenerHelper.this.mHandler.post(() -> {
                        Map map = RemoteListenerHelper.this.mListenerMap;
                        synchronized (map) {
                            RemoteListenerHelper.this.foreachUnsafe(RemoteListenerHelper.this.getHandlerOperation(this.registrationState));
                        }
                    });
                }
            }
        });
    }

    private void tryUnregister() {
        this.mHandler.post(() -> {
            if (!this.mIsRegistered) {
                return;
            }
            this.unregisterFromService();
            this.mIsRegistered = false;
        });
    }

    private int calculateCurrentResultUnsafe() {
        if (!this.isAvailableInPlatform()) {
            return 1;
        }
        if (!this.mHasIsSupported || this.mListenerMap.isEmpty()) {
            return 5;
        }
        if (!this.mIsSupported) {
            return 2;
        }
        if (!this.isGpsEnabled()) {
            return 3;
        }
        return 0;
    }

    private class HandlerRunnable
    implements Runnable {
        private final IdentifiedListener mIdentifiedListener;
        private final ListenerOperation<TListener> mOperation;

        private HandlerRunnable(IdentifiedListener identifiedListener, ListenerOperation<TListener> operation) {
            this.mIdentifiedListener = identifiedListener;
            this.mOperation = operation;
        }

        @Override
        public void run() {
            try {
                this.mOperation.execute(this.mIdentifiedListener.mListener, this.mIdentifiedListener.mCallerIdentity);
            }
            catch (RemoteException e) {
                Log.v(RemoteListenerHelper.this.mTag, "Error in monitored listener.", e);
            }
        }
    }

    private static class IdentifiedListener {
        private final TListener mListener;
        private final CallerIdentity mCallerIdentity;
        final /* synthetic */ RemoteListenerHelper this$0;

        private IdentifiedListener(TListener listener, CallerIdentity callerIdentity) {
            this.this$0 = var1_1;
            this.mListener = listener;
            this.mCallerIdentity = callerIdentity;
        }
    }

    protected static interface ListenerOperation<TListener extends IInterface> {
        public void execute(TListener var1, CallerIdentity var2) throws RemoteException;
    }
}

