/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.KeyguardManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.admin.PasswordMetrics;
import android.app.backup.BackupManager;
import android.app.trust.IStrongAuthTracker;
import android.app.trust.TrustManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteDatabase;
import android.hardware.authsecret.V1_0.IAuthSecret;
import android.hardware.biometrics.BiometricManager;
import android.hardware.face.FaceManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IProgressListener;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.StrictMode;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.KeyProtection;
import android.security.keystore.UserNotAuthenticatedException;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.service.gatekeeper.GateKeeperResponse;
import android.service.gatekeeper.IGateKeeperService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.ICheckCredentialProgressCallback;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.LockSettingsInternal;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.locksettings.LockSettingsShellCommand;
import com.android.server.locksettings.LockSettingsStorage;
import com.android.server.locksettings.LockSettingsStrongAuth;
import com.android.server.locksettings.PasswordSlotManager;
import com.android.server.locksettings.SyntheticPasswordManager;
import com.android.server.locksettings.recoverablekeystore.RecoverableKeyStoreManager;
import com.android.server.wm.WindowManagerInternal;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import libcore.util.HexEncoding;

public class LockSettingsService
extends ILockSettings.Stub {
    private static final String TAG = "LockSettingsService";
    private static final String PERMISSION = "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE";
    private static final boolean DEBUG = false;
    private static final int PROFILE_KEY_IV_SIZE = 12;
    private static final String SEPARATE_PROFILE_CHALLENGE_KEY = "lockscreen.profilechallenge";
    private static final int SYNTHETIC_PASSWORD_ENABLED_BY_DEFAULT = 1;
    private final Object mSeparateChallengeLock = new Object();
    private final DeviceProvisionedObserver mDeviceProvisionedObserver = new DeviceProvisionedObserver();
    private final Injector mInjector;
    private final Context mContext;
    @VisibleForTesting
    protected final Handler mHandler;
    @VisibleForTesting
    protected final LockSettingsStorage mStorage;
    private final LockSettingsStrongAuth mStrongAuth;
    private final SynchronizedStrongAuthTracker mStrongAuthTracker;
    private final LockPatternUtils mLockPatternUtils;
    private final NotificationManager mNotificationManager;
    private final UserManager mUserManager;
    private final IStorageManager mStorageManager;
    private final IActivityManager mActivityManager;
    private final SyntheticPasswordManager mSpManager;
    private final KeyStore mKeyStore;
    private final RecoverableKeyStoreManager mRecoverableKeyStoreManager;
    private boolean mFirstCallToVold;
    protected IGateKeeperService mGateKeeperService;
    protected IAuthSecret mAuthSecretService;
    private static final String GSI_RUNNING_PROP = "ro.gsid.image_running";
    private static final int[] SYSTEM_CREDENTIAL_UIDS = new int[]{1010, 1016, 0, 1000};
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int userHandle;
            if ("android.intent.action.USER_ADDED".equals(intent.getAction())) {
                int userHandle2 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                if (userHandle2 > 0) {
                    LockSettingsService.this.removeUser(userHandle2, true);
                }
                KeyStore ks = KeyStore.getInstance();
                UserInfo parentInfo = LockSettingsService.this.mUserManager.getProfileParent(userHandle2);
                int parentHandle = parentInfo != null ? parentInfo.id : -1;
                ks.onUserAdded(userHandle2, parentHandle);
            } else if ("android.intent.action.USER_STARTING".equals(intent.getAction())) {
                int userHandle3 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                LockSettingsService.this.mStorage.prefetchUser(userHandle3);
            } else if ("android.intent.action.USER_REMOVED".equals(intent.getAction()) && (userHandle = intent.getIntExtra("android.intent.extra.user_handle", 0)) > 0) {
                LockSettingsService.this.removeUser(userHandle, false);
            }
        }
    };
    private static final String[] VALID_SETTINGS = new String[]{"lockscreen.lockedoutpermanently", "lockscreen.patterneverchosen", "lockscreen.password_type", "lockscreen.password_type_alternate", "lockscreen.password_salt", "lockscreen.disabled", "lockscreen.options", "lockscreen.biometric_weak_fallback", "lockscreen.biometricweakeverchosen", "lockscreen.power_button_instantly_locks", "lockscreen.passwordhistory", "lock_pattern_autolock", "lock_biometric_weak_flags", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled"};
    private static final String[] READ_CONTACTS_PROTECTED_SETTINGS = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};
    private static final String[] READ_PASSWORD_PROTECTED_SETTINGS = new String[]{"lockscreen.password_salt", "lockscreen.passwordhistory", "lockscreen.password_type", "lockscreen.profilechallenge"};
    private static final String[] SETTINGS_TO_BACKUP = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info", "lock_pattern_visible_pattern", "lockscreen.power_button_instantly_locks"};
    @GuardedBy(value={"mSpManager"})
    private SparseArray<SyntheticPasswordManager.AuthenticationToken> mSpCache = new SparseArray();

    public void tieManagedProfileLockIfNecessary(int managedUserId, byte[] managedUserPassword) {
        if (!this.mUserManager.getUserInfo(managedUserId).isManagedProfile()) {
            return;
        }
        if (this.mLockPatternUtils.isSeparateProfileChallengeEnabled(managedUserId)) {
            return;
        }
        if (this.mStorage.hasChildProfileLock(managedUserId)) {
            return;
        }
        int parentId = this.mUserManager.getProfileParent((int)managedUserId).id;
        if (!this.isUserSecure(parentId)) {
            return;
        }
        try {
            if (this.getGateKeeperService().getSecureUserId(parentId) == 0L) {
                return;
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to talk to GateKeeper service", e);
            return;
        }
        byte[] randomLockSeed = new byte[]{};
        try {
            randomLockSeed = SecureRandom.getInstance("SHA1PRNG").generateSeed(40);
            char[] newPasswordChars = HexEncoding.encode(randomLockSeed);
            byte[] newPassword = new byte[newPasswordChars.length];
            for (int i = 0; i < newPasswordChars.length; ++i) {
                newPassword[i] = (byte)newPasswordChars[i];
            }
            Arrays.fill(newPasswordChars, '\u0000');
            int quality = 327680;
            this.setLockCredentialInternal(newPassword, 2, managedUserPassword, 327680, managedUserId, false, true);
            this.setLong("lockscreen.password_type", 327680L, managedUserId);
            this.tieProfileLockToParent(managedUserId, newPassword);
            Arrays.fill(newPassword, (byte)0);
        }
        catch (RemoteException | NoSuchAlgorithmException e) {
            Slog.e(TAG, "Fail to tie managed profile", e);
        }
    }

    public LockSettingsService(Context context) {
        this(new Injector(context));
    }

    @VisibleForTesting
    protected LockSettingsService(Injector injector) {
        this.mInjector = injector;
        this.mContext = injector.getContext();
        this.mKeyStore = injector.getKeyStore();
        this.mRecoverableKeyStoreManager = injector.getRecoverableKeyStoreManager(this.mKeyStore);
        this.mHandler = injector.getHandler();
        this.mStrongAuth = injector.getStrongAuth();
        this.mActivityManager = injector.getActivityManager();
        this.mLockPatternUtils = injector.getLockPatternUtils();
        this.mFirstCallToVold = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_STARTING");
        filter.addAction("android.intent.action.USER_REMOVED");
        injector.getContext().registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
        this.mStorage = injector.getStorage();
        this.mNotificationManager = injector.getNotificationManager();
        this.mUserManager = injector.getUserManager();
        this.mStorageManager = injector.getStorageManager();
        this.mStrongAuthTracker = injector.getStrongAuthTracker();
        this.mStrongAuthTracker.register(this.mStrongAuth);
        this.mSpManager = injector.getSyntheticPasswordManager(this.mStorage);
        LocalServices.addService(LockSettingsInternal.class, new LocalService());
    }

    private void maybeShowEncryptionNotificationForUser(int userId) {
        UserInfo parent;
        UserInfo user = this.mUserManager.getUserInfo(userId);
        if (!user.isManagedProfile()) {
            return;
        }
        if (this.isUserKeyUnlocked(userId)) {
            return;
        }
        UserHandle userHandle = user.getUserHandle();
        boolean isSecure = this.isUserSecure(userId);
        if (isSecure && !this.mUserManager.isUserUnlockingOrUnlocked(userHandle) && (parent = this.mUserManager.getProfileParent(userId)) != null && this.mUserManager.isUserUnlockingOrUnlocked(parent.getUserHandle()) && !this.mUserManager.isQuietModeEnabled(userHandle)) {
            this.showEncryptionNotificationForProfile(userHandle);
        }
    }

    private void showEncryptionNotificationForProfile(UserHandle user) {
        Resources r = this.mContext.getResources();
        CharSequence title = r.getText(17040887);
        CharSequence message = r.getText(17040886);
        CharSequence detail = r.getText(17040885);
        KeyguardManager km = (KeyguardManager)this.mContext.getSystemService("keyguard");
        Intent unlockIntent = km.createConfirmDeviceCredentialIntent(null, null, user.getIdentifier());
        if (unlockIntent == null) {
            return;
        }
        unlockIntent.setFlags(0x10800000);
        PendingIntent intent = PendingIntent.getActivity(this.mContext, 0, unlockIntent, 0x8000000);
        this.showEncryptionNotification(user, title, message, detail, intent);
    }

    private void showEncryptionNotification(UserHandle user, CharSequence title, CharSequence message, CharSequence detail, PendingIntent intent) {
        if (!StorageManager.isFileEncryptedNativeOrEmulated()) {
            return;
        }
        Notification notification = new Notification.Builder(this.mContext, SystemNotificationChannels.DEVICE_ADMIN).setSmallIcon(17302831).setWhen(0L).setOngoing(true).setTicker(title).setColor(this.mContext.getColor(17170460)).setContentTitle(title).setContentText(message).setSubText(detail).setVisibility(1).setContentIntent(intent).build();
        this.mNotificationManager.notifyAsUser(null, 9, notification, user);
    }

    private void hideEncryptionNotification(UserHandle userHandle) {
        this.mNotificationManager.cancelAsUser(null, 9, userHandle);
    }

    public void onCleanupUser(int userId) {
        this.hideEncryptionNotification(new UserHandle(userId));
        int strongAuthRequired = LockPatternUtils.StrongAuthTracker.getDefaultFlags(this.mContext);
        this.requireStrongAuth(strongAuthRequired, userId);
    }

    public void onStartUser(int userId) {
        this.maybeShowEncryptionNotificationForUser(userId);
    }

    private void ensureProfileKeystoreUnlocked(int userId) {
        KeyStore ks = KeyStore.getInstance();
        if (ks.state(userId) == KeyStore.State.LOCKED && this.tiedManagedProfileReadyToUnlock(this.mUserManager.getUserInfo(userId))) {
            Slog.i(TAG, "Managed profile got unlocked, will unlock its keystore");
            try {
                this.unlockChildProfile(userId, true);
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to unlock child profile");
            }
        }
    }

    public void onUnlockUser(final int userId) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                LockSettingsService.this.ensureProfileKeystoreUnlocked(userId);
                LockSettingsService.this.hideEncryptionNotification(new UserHandle(userId));
                if (LockSettingsService.this.mUserManager.getUserInfo(userId).isManagedProfile()) {
                    LockSettingsService.this.tieManagedProfileLockIfNecessary(userId, null);
                }
                if (LockSettingsService.this.mUserManager.getUserInfo(userId).isPrimary() && !LockSettingsService.this.isUserSecure(userId)) {
                    LockSettingsService.this.tryDeriveAuthTokenForUnsecuredPrimaryUser(userId);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryDeriveAuthTokenForUnsecuredPrimaryUser(int userId) {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (!this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                return;
            }
            try {
                long handle = this.getSyntheticPasswordHandleLocked(userId);
                byte[] noCredential = null;
                SyntheticPasswordManager.AuthenticationResult result = this.mSpManager.unwrapPasswordBasedSyntheticPassword(this.getGateKeeperService(), handle, noCredential, userId, null);
                if (result.authToken != null) {
                    Slog.i(TAG, "Retrieved auth token for user " + userId);
                    this.onAuthTokenKnownForUser(userId, result.authToken);
                } else {
                    Slog.e(TAG, "Auth token not available for user " + userId);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failure retrieving auth token", e);
            }
        }
    }

    @Override
    public void systemReady() {
        if (this.mContext.checkCallingOrSelfPermission(PERMISSION) != 0) {
            EventLog.writeEvent(1397638484, "28251513", LockSettingsService.getCallingUid(), "");
        }
        this.checkWritePermission(0);
        this.migrateOldData();
        try {
            this.getGateKeeperService();
            this.mSpManager.initWeaverService();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failure retrieving IGateKeeperService", e);
        }
        try {
            this.mAuthSecretService = IAuthSecret.getService();
        }
        catch (NoSuchElementException e) {
            Slog.i(TAG, "Device doesn't implement AuthSecret HAL");
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to get AuthSecret HAL", e);
        }
        this.mDeviceProvisionedObserver.onSystemReady();
        this.mStorage.prefetchUser(0);
    }

    private void migrateOldData() {
        int i;
        List<UserInfo> users;
        ContentResolver cr;
        if (this.getString("migrated", null, 0) == null) {
            cr = this.mContext.getContentResolver();
            for (String validSetting : VALID_SETTINGS) {
                String value = Settings.Secure.getString(cr, validSetting);
                if (value == null) continue;
                this.setString(validSetting, value, 0);
            }
            this.setString("migrated", "true", 0);
            Slog.i(TAG, "Migrated lock settings to new location");
        }
        if (this.getString("migrated_user_specific", null, 0) == null) {
            cr = this.mContext.getContentResolver();
            List<UserInfo> users2 = this.mUserManager.getUsers();
            for (int user = 0; user < users2.size(); ++user) {
                int userId;
                block23: {
                    userId = users2.get((int)user).id;
                    String OWNER_INFO = "lock_screen_owner_info";
                    String ownerInfo = Settings.Secure.getStringForUser(cr, "lock_screen_owner_info", userId);
                    if (!TextUtils.isEmpty(ownerInfo)) {
                        this.setString("lock_screen_owner_info", ownerInfo, userId);
                        Settings.Secure.putStringForUser(cr, "lock_screen_owner_info", "", userId);
                    }
                    String OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
                    try {
                        int ivalue = Settings.Secure.getIntForUser(cr, "lock_screen_owner_info_enabled", userId);
                        boolean enabled = ivalue != 0;
                        this.setLong("lock_screen_owner_info_enabled", enabled ? 1L : 0L, userId);
                    }
                    catch (Settings.SettingNotFoundException e) {
                        if (TextUtils.isEmpty(ownerInfo)) break block23;
                        this.setLong("lock_screen_owner_info_enabled", 1L, userId);
                    }
                }
                Settings.Secure.putIntForUser(cr, "lock_screen_owner_info_enabled", 0, userId);
            }
            this.setString("migrated_user_specific", "true", 0);
            Slog.i(TAG, "Migrated per-user lock settings to new location");
        }
        if (this.getString("migrated_biometric_weak", null, 0) == null) {
            users = this.mUserManager.getUsers();
            for (int i2 = 0; i2 < users.size(); ++i2) {
                int userId = users.get((int)i2).id;
                long type = this.getLong("lockscreen.password_type", 0L, userId);
                long alternateType = this.getLong("lockscreen.password_type_alternate", 0L, userId);
                if (type == 32768L) {
                    this.setLong("lockscreen.password_type", alternateType, userId);
                }
                this.setLong("lockscreen.password_type_alternate", 0L, userId);
            }
            this.setString("migrated_biometric_weak", "true", 0);
            Slog.i(TAG, "Migrated biometric weak to use the fallback instead");
        }
        if (this.getString("migrated_lockscreen_disabled", null, 0) == null) {
            users = this.mUserManager.getUsers();
            int userCount = users.size();
            int switchableUsers = 0;
            for (i = 0; i < userCount; ++i) {
                if (!users.get(i).supportsSwitchTo()) continue;
                ++switchableUsers;
            }
            if (switchableUsers > 1) {
                for (i = 0; i < userCount; ++i) {
                    int id2 = users.get((int)i).id;
                    if (!this.getBoolean("lockscreen.disabled", false, id2)) continue;
                    this.setBoolean("lockscreen.disabled", false, id2);
                }
            }
            this.setString("migrated_lockscreen_disabled", "true", 0);
            Slog.i(TAG, "Migrated lockscreen disabled flag");
        }
        users = this.mUserManager.getUsers();
        for (int i3 = 0; i3 < users.size(); ++i3) {
            UserInfo userInfo = users.get(i3);
            if (userInfo.isManagedProfile() && this.mStorage.hasChildProfileLock(userInfo.id)) {
                long quality = this.getLong("lockscreen.password_type", 0L, userInfo.id);
                if (quality == 0L) {
                    Slog.i(TAG, "Migrated tied profile lock type");
                    this.setLong("lockscreen.password_type", 327680L, userInfo.id);
                } else if (quality != 327680L) {
                    Slog.e(TAG, "Invalid tied profile lock type: " + quality);
                }
            }
            try {
                String alias = "profile_key_name_encrypt_" + userInfo.id;
                java.security.KeyStore keyStore = java.security.KeyStore.getInstance("AndroidKeyStore");
                keyStore.load(null);
                if (!keyStore.containsAlias(alias)) continue;
                keyStore.deleteEntry(alias);
                continue;
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                Slog.e(TAG, "Unable to remove tied profile key", e);
            }
        }
        boolean isWatch = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        if (isWatch && this.getString("migrated_wear_lockscreen_disabled", null, 0) == null) {
            int userCount = users.size();
            for (i = 0; i < userCount; ++i) {
                int id3 = users.get((int)i).id;
                this.setBoolean("lockscreen.disabled", false, id3);
            }
            this.setString("migrated_wear_lockscreen_disabled", "true", 0);
            Slog.i(TAG, "Migrated lockscreen_disabled for Wear devices");
        }
    }

    private void migrateOldDataAfterSystemReady() {
        try {
            if (LockPatternUtils.frpCredentialEnabled(this.mContext) && !this.getBoolean("migrated_frp", false, 0)) {
                this.migrateFrpCredential();
                this.setBoolean("migrated_frp", true, 0);
                Slog.i(TAG, "Migrated migrated_frp.");
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to migrateOldDataAfterSystemReady", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void migrateFrpCredential() throws RemoteException {
        if (this.mStorage.readPersistentDataBlock() != LockSettingsStorage.PersistentData.NONE) {
            return;
        }
        for (UserInfo userInfo : this.mUserManager.getUsers()) {
            if (!LockPatternUtils.userOwnsFrpCredential(this.mContext, userInfo) || !this.isUserSecure(userInfo.id)) continue;
            SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
            synchronized (syntheticPasswordManager) {
                if (this.isSyntheticPasswordBasedCredentialLocked(userInfo.id)) {
                    int actualQuality = (int)this.getLong("lockscreen.password_type", 0L, userInfo.id);
                    this.mSpManager.migrateFrpPasswordLocked(this.getSyntheticPasswordHandleLocked(userInfo.id), userInfo, this.redactActualQualityToMostLenientEquivalentQuality(actualQuality));
                }
            }
            return;
        }
    }

    private int redactActualQualityToMostLenientEquivalentQuality(int quality) {
        switch (quality) {
            case 262144: 
            case 327680: 
            case 393216: {
                return 262144;
            }
            case 131072: 
            case 196608: {
                return 131072;
            }
        }
        return quality;
    }

    private final void checkWritePermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsWrite");
    }

    private final void checkPasswordReadPermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsRead");
    }

    private final void checkPasswordHavePermission(int userId) {
        if (this.mContext.checkCallingOrSelfPermission(PERMISSION) != 0) {
            EventLog.writeEvent(1397638484, "28251513", LockSettingsService.getCallingUid(), "");
        }
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsHave");
    }

    private final void checkReadPermission(String requestedKey, int userId) {
        String key;
        int i;
        int callingUid = Binder.getCallingUid();
        for (i = 0; i < READ_CONTACTS_PROTECTED_SETTINGS.length; ++i) {
            key = READ_CONTACTS_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission("android.permission.READ_CONTACTS") == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + "android.permission.READ_CONTACTS" + " to read " + requestedKey + " for user " + userId);
        }
        for (i = 0; i < READ_PASSWORD_PROTECTED_SETTINGS.length; ++i) {
            key = READ_PASSWORD_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission(PERMISSION) == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + PERMISSION + " to read " + requestedKey + " for user " + userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSeparateProfileChallengeEnabled(int userId) {
        this.checkReadPermission(SEPARATE_PROFILE_CHALLENGE_KEY, userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            return this.getBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, false, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSeparateProfileChallengeEnabled(int userId, boolean enabled, byte[] managedUserPassword) {
        this.checkWritePermission(userId);
        if (!this.mLockPatternUtils.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires secure lock screen feature.");
        }
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            this.setSeparateProfileChallengeEnabledLocked(userId, enabled, managedUserPassword);
        }
        this.notifySeparateProfileChallengeChanged(userId);
    }

    @GuardedBy(value={"mSeparateChallengeLock"})
    private void setSeparateProfileChallengeEnabledLocked(int userId, boolean enabled, byte[] managedUserPassword) {
        boolean old = this.getBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, false, userId);
        this.setBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, enabled, userId);
        try {
            if (enabled) {
                this.mStorage.removeChildProfileLock(userId);
                this.removeKeystoreProfileKey(userId);
            } else {
                this.tieManagedProfileLockIfNecessary(userId, managedUserPassword);
            }
        }
        catch (IllegalStateException e) {
            this.setBoolean(SEPARATE_PROFILE_CHALLENGE_KEY, old, userId);
            throw e;
        }
    }

    private void notifySeparateProfileChallengeChanged(int userId) {
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        if (dpmi != null) {
            dpmi.reportSeparateProfileChallengeChanged(userId);
        }
    }

    @Override
    public void setBoolean(String key, boolean value, int userId) {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value ? "1" : "0");
    }

    @Override
    public void setLong(String key, long value, int userId) {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, Long.toString(value));
    }

    @Override
    public void setString(String key, String value, int userId) {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value);
    }

    private void setStringUnchecked(String key, int userId, String value) {
        Preconditions.checkArgument(userId != -9999, "cannot store lock settings for FRP user");
        this.mStorage.writeKeyValue(key, value, userId);
        if (ArrayUtils.contains(SETTINGS_TO_BACKUP, key)) {
            BackupManager.dataChanged("com.android.providers.settings");
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, int userId) {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : value.equals("1") || value.equals("true");
    }

    @Override
    public long getLong(String key, long defaultValue, int userId) {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : Long.parseLong(value);
    }

    @Override
    public String getString(String key, String defaultValue, int userId) {
        this.checkReadPermission(key, userId);
        return this.getStringUnchecked(key, defaultValue, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringUnchecked(String key, String defaultValue, int userId) {
        if ("lock_pattern_autolock".equals(key)) {
            long ident = Binder.clearCallingIdentity();
            try {
                String string2 = this.mLockPatternUtils.isLockPatternEnabled(userId) ? "1" : "0";
                return string2;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        if (userId == -9999) {
            return this.getFrpStringUnchecked(key);
        }
        if ("legacy_lock_pattern_enabled".equals(key)) {
            key = "lock_pattern_autolock";
        }
        return this.mStorage.readKeyValue(key, defaultValue, userId);
    }

    private String getFrpStringUnchecked(String key) {
        if ("lockscreen.password_type".equals(key)) {
            return String.valueOf(this.readFrpPasswordQuality());
        }
        return null;
    }

    private int readFrpPasswordQuality() {
        return this.mStorage.readPersistentDataBlock().qualityForUi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean havePassword(int userId) {
        this.checkPasswordHavePermission(userId);
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                long handle = this.getSyntheticPasswordHandleLocked(userId);
                boolean bl = this.mSpManager.getCredentialType(handle, userId) == 2;
                return bl;
            }
            return this.mStorage.hasPassword(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean havePattern(int userId) {
        this.checkPasswordHavePermission(userId);
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                long handle = this.getSyntheticPasswordHandleLocked(userId);
                boolean bl = this.mSpManager.getCredentialType(handle, userId) == 1;
                return bl;
            }
            return this.mStorage.hasPattern(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserSecure(int userId) {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                long handle = this.getSyntheticPasswordHandleLocked(userId);
                boolean bl = this.mSpManager.getCredentialType(handle, userId) != -1;
                return bl;
            }
            return this.mStorage.hasCredential(userId);
        }
    }

    private void setKeystorePassword(byte[] password, int userHandle) {
        KeyStore ks = KeyStore.getInstance();
        String passwordString = password == null ? null : new String(password);
        ks.onUserPasswordChanged(userHandle, passwordString);
    }

    private void unlockKeystore(byte[] password, int userHandle) {
        String passwordString = password == null ? null : new String(password);
        KeyStore ks = KeyStore.getInstance();
        ks.unlock(userHandle, passwordString);
    }

    @VisibleForTesting
    protected byte[] getDecryptedPasswordForTiedProfile(int userId) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, CertificateException, IOException {
        byte[] storedData = this.mStorage.readChildProfileLock(userId);
        if (storedData == null) {
            throw new FileNotFoundException("Child profile lock file not found");
        }
        byte[] iv = Arrays.copyOfRange(storedData, 0, 12);
        byte[] encryptedPassword = Arrays.copyOfRange(storedData, 12, storedData.length);
        java.security.KeyStore keyStore = java.security.KeyStore.getInstance("AndroidKeyStore");
        keyStore.load(null);
        SecretKey decryptionKey = (SecretKey)keyStore.getKey("profile_key_name_decrypt_" + userId, null);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(2, (Key)decryptionKey, new GCMParameterSpec(128, iv));
        byte[] decryptionResult = cipher.doFinal(encryptedPassword);
        return decryptionResult;
    }

    private void unlockChildProfile(int profileHandle, boolean ignoreUserNotAuthenticated) throws RemoteException {
        try {
            this.doVerifyCredential(this.getDecryptedPasswordForTiedProfile(profileHandle), 2, false, 0L, profileHandle, null);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            if (e instanceof FileNotFoundException) {
                Slog.i(TAG, "Child profile key not found");
            }
            if (ignoreUserNotAuthenticated && e instanceof UserNotAuthenticatedException) {
                Slog.i(TAG, "Parent keystore seems locked, ignoring");
            }
            Slog.e(TAG, "Failed to decrypt child profile key", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockUser(int userId, byte[] token, byte[] secret) {
        boolean alreadyUnlocked = this.mUserManager.isUserUnlockingOrUnlocked(userId);
        final CountDownLatch latch = new CountDownLatch(1);
        IProgressListener.Stub listener = new IProgressListener.Stub(){

            @Override
            public void onStarted(int id2, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser started");
            }

            @Override
            public void onProgress(int id2, int progress, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser progress " + progress);
            }

            @Override
            public void onFinished(int id2, Bundle extras) throws RemoteException {
                Log.d(LockSettingsService.TAG, "unlockUser finished");
                latch.countDown();
            }
        };
        try {
            this.mActivityManager.unlockUser(userId, token, secret, listener);
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        try {
            latch.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            return;
        }
        for (UserInfo profile : this.mUserManager.getProfiles(userId)) {
            if (this.tiedManagedProfileReadyToUnlock(profile)) {
                try {
                    this.unlockChildProfile(profile.id, false);
                }
                catch (RemoteException e) {
                    Log.d(TAG, "Failed to unlock child profile", e);
                }
            }
            if (alreadyUnlocked) continue;
            long ident = LockSettingsService.clearCallingIdentity();
            try {
                this.maybeShowEncryptionNotificationForUser(profile.id);
            }
            finally {
                LockSettingsService.restoreCallingIdentity(ident);
            }
        }
    }

    private boolean tiedManagedProfileReadyToUnlock(UserInfo userInfo) {
        return userInfo.isManagedProfile() && !this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userInfo.id) && this.mStorage.hasChildProfileLock(userInfo.id) && this.mUserManager.isUserRunning(userInfo.id);
    }

    private Map<Integer, byte[]> getDecryptedPasswordsForAllTiedProfiles(int userId) {
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            return null;
        }
        ArrayMap<Integer, byte[]> result = new ArrayMap<Integer, byte[]>();
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        int size = profiles.size();
        for (int i = 0; i < size; ++i) {
            int managedUserId;
            UserInfo profile = profiles.get(i);
            if (!profile.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(managedUserId = profile.id)) continue;
            try {
                result.put(managedUserId, this.getDecryptedPasswordForTiedProfile(managedUserId));
                continue;
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                Slog.e(TAG, "getDecryptedPasswordsForAllTiedProfiles failed for user " + managedUserId, e);
            }
        }
        return result;
    }

    private void synchronizeUnifiedWorkChallengeForProfiles(int userId, Map<Integer, byte[]> profilePasswordMap) throws RemoteException {
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            return;
        }
        boolean isSecure = this.isUserSecure(userId);
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        int size = profiles.size();
        for (int i = 0; i < size; ++i) {
            int managedUserId;
            UserInfo profile = profiles.get(i);
            if (!profile.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(managedUserId = profile.id)) continue;
            if (isSecure) {
                this.tieManagedProfileLockIfNecessary(managedUserId, null);
                continue;
            }
            if (profilePasswordMap != null && profilePasswordMap.containsKey(managedUserId)) {
                this.setLockCredentialInternal(null, -1, profilePasswordMap.get(managedUserId), 0, managedUserId, false, true);
            } else {
                Slog.wtf(TAG, "clear tied profile challenges, but no password supplied.");
                this.setLockCredentialInternal(null, -1, null, 0, managedUserId, true, true);
            }
            this.mStorage.removeChildProfileLock(managedUserId);
            this.removeKeystoreProfileKey(managedUserId);
        }
    }

    private boolean isManagedProfileWithUnifiedLock(int userId) {
        return this.mUserManager.getUserInfo(userId).isManagedProfile() && !this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId);
    }

    private boolean isManagedProfileWithSeparatedLock(int userId) {
        return this.mUserManager.getUserInfo(userId).isManagedProfile() && this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId);
    }

    private void sendCredentialsOnUnlockIfRequired(int credentialType, byte[] credential, int userId) {
        if (userId == -9999) {
            return;
        }
        if (this.isManagedProfileWithUnifiedLock(userId)) {
            return;
        }
        for (int profileId : this.getProfilesWithSameLockScreen(userId)) {
            this.mRecoverableKeyStoreManager.lockScreenSecretAvailable(credentialType, credential, profileId);
        }
    }

    private void sendCredentialsOnChangeIfRequired(int credentialType, byte[] credential, int userId, boolean isLockTiedToParent) {
        if (isLockTiedToParent) {
            return;
        }
        for (int profileId : this.getProfilesWithSameLockScreen(userId)) {
            this.mRecoverableKeyStoreManager.lockScreenSecretChanged(credentialType, credential, profileId);
        }
    }

    private Set<Integer> getProfilesWithSameLockScreen(int userId) {
        ArraySet<Integer> profiles = new ArraySet<Integer>();
        for (UserInfo profile : this.mUserManager.getProfiles(userId)) {
            if (profile.id != userId && (profile.profileGroupId != userId || !this.isManagedProfileWithUnifiedLock(profile.id))) continue;
            profiles.add(profile.id);
        }
        return profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockCredential(byte[] credential, int type, byte[] savedCredential, int requestedQuality, int userId, boolean allowUntrustedChange) throws RemoteException {
        if (!this.mLockPatternUtils.hasSecureLockScreen()) {
            throw new UnsupportedOperationException("This operation requires secure lock screen feature");
        }
        this.checkWritePermission(userId);
        Object object = this.mSeparateChallengeLock;
        synchronized (object) {
            this.setLockCredentialInternal(credential, type, savedCredential, requestedQuality, userId, allowUntrustedChange, false);
            this.setSeparateProfileChallengeEnabledLocked(userId, true, null);
            this.notifyPasswordChanged(userId);
        }
        if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            this.setDeviceUnlockedForUser(userId);
        }
        this.notifySeparateProfileChallengeChanged(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLockCredentialInternal(byte[] credential, int credentialType, byte[] savedCredential, int requestedQuality, int userId, boolean allowUntrustedChange, boolean isLockTiedToParent) throws RemoteException {
        block22: {
            block23: {
                if (savedCredential == null || savedCredential.length == 0) {
                    savedCredential = null;
                }
                if (credential == null || credential.length == 0) {
                    credential = null;
                }
                SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
                synchronized (syntheticPasswordManager) {
                    if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                        this.spBasedSetLockCredentialInternalLocked(credential, credentialType, savedCredential, requestedQuality, userId, allowUntrustedChange, isLockTiedToParent);
                        return;
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 5] lbl13 : MonitorExitStatement: MONITOREXIT : var8_8
                    if (credentialType != -1) break block22;
                    if (credential == null) break block23;
                }
                Slog.wtf(TAG, "CredentialType is none, but credential is non-null.");
            }
            this.clearUserKeyProtection(userId);
            this.getGateKeeperService().clearSecureUserId(userId);
            this.mStorage.writeCredentialHash(LockSettingsStorage.CredentialHash.createEmptyHash(), userId);
            this.setKeystorePassword(null, userId);
            this.fixateNewestUserKeyAuth(userId);
            this.synchronizeUnifiedWorkChallengeForProfiles(userId, null);
            this.notifyActivePasswordMetricsAvailable(-1, null, userId);
            this.sendCredentialsOnChangeIfRequired(credentialType, credential, userId, isLockTiedToParent);
            return;
        }
        if (credential == null) {
            throw new RemoteException("Null credential with mismatched credential type");
        }
        LockSettingsStorage.CredentialHash currentHandle = this.mStorage.readCredentialHash(userId);
        if (this.isManagedProfileWithUnifiedLock(userId)) {
            if (savedCredential == null) {
                try {
                    savedCredential = this.getDecryptedPasswordForTiedProfile(userId);
                }
                catch (FileNotFoundException e) {
                    Slog.i(TAG, "Child profile key not found");
                }
                catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                    Slog.e(TAG, "Failed to decrypt child profile key", e);
                }
            }
        } else if (currentHandle.hash == null) {
            if (savedCredential != null) {
                Slog.w(TAG, "Saved credential provided, but none stored");
            }
            savedCredential = null;
        }
        SyntheticPasswordManager e = this.mSpManager;
        synchronized (e) {
            if (this.shouldMigrateToSyntheticPasswordLocked(userId)) {
                this.initializeSyntheticPasswordLocked(currentHandle.hash, savedCredential, currentHandle.type, requestedQuality, userId);
                this.spBasedSetLockCredentialInternalLocked(credential, credentialType, savedCredential, requestedQuality, userId, allowUntrustedChange, isLockTiedToParent);
                return;
            }
        }
        byte[] enrolledHandle = this.enrollCredential(currentHandle.hash, savedCredential, credential, userId);
        if (enrolledHandle == null) {
            throw new RemoteException("Failed to enroll " + (credentialType == 2 ? "password" : "pattern"));
        }
        LockSettingsStorage.CredentialHash willStore = LockSettingsStorage.CredentialHash.create(enrolledHandle, credentialType);
        this.mStorage.writeCredentialHash(willStore, userId);
        GateKeeperResponse gkResponse = this.getGateKeeperService().verifyChallenge(userId, 0L, willStore.hash, credential);
        this.setUserKeyProtection(userId, credential, this.convertResponse(gkResponse));
        this.fixateNewestUserKeyAuth(userId);
        this.doVerifyCredential(credential, credentialType, true, 0L, userId, null);
        this.synchronizeUnifiedWorkChallengeForProfiles(userId, null);
        this.sendCredentialsOnChangeIfRequired(credentialType, credential, userId, isLockTiedToParent);
    }

    private VerifyCredentialResponse convertResponse(GateKeeperResponse gateKeeperResponse) {
        return VerifyCredentialResponse.fromGateKeeperResponse(gateKeeperResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void tieProfileLockToParent(int userId, byte[] password) {
        byte[] iv;
        byte[] encryptionResult;
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(new SecureRandom());
            SecretKey secretKey = keyGenerator.generateKey();
            java.security.KeyStore keyStore = java.security.KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            try {
                keyStore.setEntry("profile_key_name_encrypt_" + userId, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(1).setBlockModes("GCM").setEncryptionPaddings("NoPadding").build());
                keyStore.setEntry("profile_key_name_decrypt_" + userId, new KeyStore.SecretKeyEntry(secretKey), new KeyProtection.Builder(2).setBlockModes("GCM").setEncryptionPaddings("NoPadding").setUserAuthenticationRequired(true).setUserAuthenticationValidityDurationSeconds(30).setCriticalToDeviceEncryption(true).build());
                SecretKey keyStoreEncryptionKey = (SecretKey)keyStore.getKey("profile_key_name_encrypt_" + userId, null);
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                cipher.init(1, keyStoreEncryptionKey);
                encryptionResult = cipher.doFinal(password);
                iv = cipher.getIV();
            }
            finally {
                keyStore.deleteEntry("profile_key_name_encrypt_" + userId);
            }
        }
        catch (IOException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new RuntimeException("Failed to encrypt key", e);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            if (iv.length != 12) {
                throw new RuntimeException("Invalid iv length: " + iv.length);
            }
            outputStream.write(iv);
            outputStream.write(encryptionResult);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to concatenate byte arrays", e);
        }
        this.mStorage.writeChildProfileLock(userId, outputStream.toByteArray());
    }

    private byte[] enrollCredential(byte[] enrolledHandle, byte[] enrolledCredential, byte[] toEnroll, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        GateKeeperResponse response = this.getGateKeeperService().enroll(userId, enrolledHandle, enrolledCredential, toEnroll);
        if (response == null) {
            return null;
        }
        byte[] hash = response.getPayload();
        if (hash != null) {
            this.setKeystorePassword(toEnroll, userId);
        } else {
            Slog.e(TAG, "Throttled while enrolling a password");
        }
        return hash;
    }

    private void setAuthlessUserKeyProtection(int userId, byte[] key) throws RemoteException {
        this.addUserKeyAuth(userId, null, key);
    }

    private void setUserKeyProtection(int userId, byte[] credential, VerifyCredentialResponse vcr) throws RemoteException {
        if (vcr == null) {
            throw new RemoteException("Null response verifying a credential we just set");
        }
        if (vcr.getResponseCode() != 0) {
            throw new RemoteException("Non-OK response verifying a credential we just set: " + vcr.getResponseCode());
        }
        byte[] token = vcr.getPayload();
        if (token == null) {
            throw new RemoteException("Empty payload verifying a credential we just set");
        }
        this.addUserKeyAuth(userId, token, LockSettingsService.secretFromCredential(credential));
    }

    private void clearUserKeyProtection(int userId) throws RemoteException {
        this.addUserKeyAuth(userId, null, null);
    }

    private static byte[] secretFromCredential(byte[] credential) throws RemoteException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] personalization = "Android FBE credential hash".getBytes();
            personalization = Arrays.copyOf(personalization, 128);
            digest.update(personalization);
            digest.update(credential);
            return digest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("NoSuchAlgorithmException for SHA-512");
        }
    }

    private boolean isUserKeyUnlocked(int userId) {
        try {
            return this.mStorageManager.isUserKeyUnlocked(userId);
        }
        catch (RemoteException e) {
            Log.e(TAG, "failed to check user key locked state", e);
            return false;
        }
    }

    private void unlockUserKey(int userId, byte[] token, byte[] secret) throws RemoteException {
        UserInfo userInfo = this.mUserManager.getUserInfo(userId);
        this.mStorageManager.unlockUserKey(userId, userInfo.serialNumber, token, secret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUserKeyAuth(int userId, byte[] token, byte[] secret) throws RemoteException {
        UserInfo userInfo = this.mUserManager.getUserInfo(userId);
        long callingId = Binder.clearCallingIdentity();
        try {
            this.mStorageManager.addUserKeyAuth(userId, userInfo.serialNumber, token, secret);
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixateNewestUserKeyAuth(int userId) throws RemoteException {
        long callingId = Binder.clearCallingIdentity();
        try {
            this.mStorageManager.fixateNewestUserKeyAuth(userId);
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetKeyStore(int userId) throws RemoteException {
        this.checkWritePermission(userId);
        int managedUserId = -1;
        byte[] managedUserDecryptedPassword = null;
        List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
        for (UserInfo pi : profiles) {
            if (!pi.isManagedProfile() || this.mLockPatternUtils.isSeparateProfileChallengeEnabled(pi.id) || !this.mStorage.hasChildProfileLock(pi.id)) continue;
            try {
                if (managedUserId == -1) {
                    managedUserDecryptedPassword = this.getDecryptedPasswordForTiedProfile(pi.id);
                    managedUserId = pi.id;
                    continue;
                }
                Slog.e(TAG, "More than one managed profile, uid1:" + managedUserId + ", uid2:" + pi.id);
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                Slog.e(TAG, "Failed to decrypt child profile key", e);
            }
        }
        try {
            for (Object profileId : (Object)this.mUserManager.getProfileIdsWithDisabled(userId)) {
                for (int uid : SYSTEM_CREDENTIAL_UIDS) {
                    this.mKeyStore.clearUid(UserHandle.getUid((int)profileId, uid));
                }
            }
        }
        finally {
            if (managedUserId != -1 && managedUserDecryptedPassword != null) {
                this.tieProfileLockToParent(managedUserId, managedUserDecryptedPassword);
            }
        }
        if (managedUserDecryptedPassword != null && managedUserDecryptedPassword.length > 0) {
            Arrays.fill(managedUserDecryptedPassword, (byte)0);
        }
    }

    @Override
    public VerifyCredentialResponse checkCredential(byte[] credential, int type, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        return this.doVerifyCredential(credential, type, false, 0L, userId, progressCallback);
    }

    @Override
    public VerifyCredentialResponse verifyCredential(byte[] credential, int type, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        return this.doVerifyCredential(credential, type, true, challenge, userId, null);
    }

    private VerifyCredentialResponse doVerifyCredential(byte[] credential, int credentialType, boolean hasChallenge, long challenge, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        if (credential == null || credential.length == 0) {
            throw new IllegalArgumentException("Credential can't be null or empty");
        }
        if (userId == -9999 && Settings.Global.getInt(this.mContext.getContentResolver(), "device_provisioned", 0) != 0) {
            Slog.e(TAG, "FRP credential can only be verified prior to provisioning.");
            return VerifyCredentialResponse.ERROR;
        }
        VerifyCredentialResponse response = null;
        response = this.spBasedDoVerifyCredential(credential, credentialType, hasChallenge, challenge, userId, progressCallback);
        if (response != null) {
            if (response.getResponseCode() == 0) {
                this.sendCredentialsOnUnlockIfRequired(credentialType, credential, userId);
            }
            return response;
        }
        if (userId == -9999) {
            Slog.wtf(TAG, "Unexpected FRP credential type, should be SP based.");
            return VerifyCredentialResponse.ERROR;
        }
        LockSettingsStorage.CredentialHash storedHash = this.mStorage.readCredentialHash(userId);
        if (storedHash.type != credentialType) {
            Slog.wtf(TAG, "doVerifyCredential type mismatch with stored credential?? stored: " + storedHash.type + " passed in: " + credentialType);
            return VerifyCredentialResponse.ERROR;
        }
        boolean shouldReEnrollBaseZero = storedHash.type == 1 && storedHash.isBaseZeroPattern;
        byte[] credentialToVerify = shouldReEnrollBaseZero ? LockPatternUtils.patternByteArrayToBaseZero(credential) : credential;
        response = this.verifyCredential(userId, storedHash, credentialToVerify, hasChallenge, challenge, progressCallback);
        if (response.getResponseCode() == 0) {
            this.mStrongAuth.reportSuccessfulStrongAuthUnlock(userId);
            if (shouldReEnrollBaseZero) {
                this.setLockCredentialInternal(credential, storedHash.type, credentialToVerify, 65536, userId, false, false);
            }
        }
        return response;
    }

    @Override
    public VerifyCredentialResponse verifyTiedProfileChallenge(byte[] credential, int type, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        if (!this.isManagedProfileWithUnifiedLock(userId)) {
            throw new RemoteException("User id must be managed profile with unified lock");
        }
        int parentProfileId = this.mUserManager.getProfileParent((int)userId).id;
        VerifyCredentialResponse parentResponse = this.doVerifyCredential(credential, type, true, challenge, parentProfileId, null);
        if (parentResponse.getResponseCode() != 0) {
            return parentResponse;
        }
        try {
            return this.doVerifyCredential(this.getDecryptedPasswordForTiedProfile(userId), 2, true, challenge, userId, null);
        }
        catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            Slog.e(TAG, "Failed to decrypt child profile key", e);
            throw new RemoteException("Unable to get tied profile token");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyCredentialResponse verifyCredential(int userId, LockSettingsStorage.CredentialHash storedHash, byte[] credential, boolean hasChallenge, long challenge, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        if (!(storedHash != null && storedHash.hash.length != 0 || credential != null && credential.length != 0)) {
            return VerifyCredentialResponse.OK;
        }
        if (storedHash == null || credential == null || credential.length == 0) {
            return VerifyCredentialResponse.ERROR;
        }
        StrictMode.noteDiskRead();
        if (storedHash.version == 0) {
            byte[] hash = storedHash.type == 1 ? LockPatternUtils.patternToHash(LockPatternUtils.byteArrayToPattern(credential)) : this.mLockPatternUtils.legacyPasswordToHash(credential, userId).getBytes();
            if (Arrays.equals(hash, storedHash.hash)) {
                if (storedHash.type == 1) {
                    this.unlockKeystore(LockPatternUtils.patternByteArrayToBaseZero(credential), userId);
                } else {
                    this.unlockKeystore(credential, userId);
                }
                Slog.i(TAG, "Unlocking user with fake token: " + userId);
                byte[] fakeToken = String.valueOf(userId).getBytes();
                this.unlockUser(userId, fakeToken, fakeToken);
                this.setLockCredentialInternal(credential, storedHash.type, null, storedHash.type == 1 ? 65536 : 327680, userId, false, false);
                if (!hasChallenge) {
                    this.notifyActivePasswordMetricsAvailable(storedHash.type, credential, userId);
                    this.sendCredentialsOnUnlockIfRequired(storedHash.type, credential, userId);
                    return VerifyCredentialResponse.OK;
                }
            } else {
                return VerifyCredentialResponse.ERROR;
            }
        }
        GateKeeperResponse gateKeeperResponse = this.getGateKeeperService().verifyChallenge(userId, challenge, storedHash.hash, credential);
        VerifyCredentialResponse response = this.convertResponse(gateKeeperResponse);
        boolean shouldReEnroll = gateKeeperResponse.getShouldReEnroll();
        if (response.getResponseCode() == 0) {
            int reEnrollQuality;
            if (progressCallback != null) {
                progressCallback.onCredentialVerified();
            }
            this.notifyActivePasswordMetricsAvailable(storedHash.type, credential, userId);
            this.unlockKeystore(credential, userId);
            Slog.i(TAG, "Unlocking user " + userId + " with token length " + response.getPayload().length);
            this.unlockUser(userId, response.getPayload(), LockSettingsService.secretFromCredential(credential));
            if (this.isManagedProfileWithSeparatedLock(userId)) {
                this.setDeviceUnlockedForUser(userId);
            }
            int n = reEnrollQuality = storedHash.type == 1 ? 65536 : 327680;
            if (shouldReEnroll) {
                this.setLockCredentialInternal(credential, storedHash.type, credential, reEnrollQuality, userId, false, false);
            } else {
                SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
                synchronized (syntheticPasswordManager) {
                    if (this.shouldMigrateToSyntheticPasswordLocked(userId)) {
                        SyntheticPasswordManager.AuthenticationToken auth = this.initializeSyntheticPasswordLocked(storedHash.hash, credential, storedHash.type, reEnrollQuality, userId);
                        this.activateEscrowTokens(auth, userId);
                    }
                }
            }
            this.sendCredentialsOnUnlockIfRequired(storedHash.type, credential, userId);
        } else if (response.getResponseCode() == 1 && response.getTimeout() > 0) {
            this.requireStrongAuth(8, userId);
        }
        return response;
    }

    private void notifyActivePasswordMetricsAvailable(int credentialType, byte[] password, int userId) {
        PasswordMetrics metrics = PasswordMetrics.computeForCredential(credentialType, password);
        this.mHandler.post(() -> {
            DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            dpm.setActivePasswordState(metrics, userId);
        });
    }

    private void notifyPasswordChanged(int userId) {
        this.mHandler.post(() -> {
            DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            dpm.reportPasswordChanged(userId);
            LocalServices.getService(WindowManagerInternal.class).reportPasswordChanged(userId);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkVoldPassword(int userId) throws RemoteException {
        String password;
        if (!this.mFirstCallToVold) {
            return false;
        }
        this.mFirstCallToVold = false;
        this.checkPasswordReadPermission(userId);
        IStorageManager service = this.mInjector.getStorageManager();
        long identity = Binder.clearCallingIdentity();
        try {
            password = service.getPassword();
            service.clearPassword();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (password == null) {
            return false;
        }
        try {
            if (this.mLockPatternUtils.isLockPatternEnabled(userId) && this.checkCredential(password.getBytes(), 1, userId, null).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.mLockPatternUtils.isLockPasswordEnabled(userId) && this.checkCredential(password.getBytes(), 2, userId, null).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void removeUser(int userId, boolean unknownUser) {
        this.mSpManager.removeUser(userId);
        this.mStorage.removeUser(userId);
        this.mStrongAuth.removeUser(userId);
        this.tryRemoveUserFromSpCacheLater(userId);
        KeyStore ks = KeyStore.getInstance();
        ks.onUserRemoved(userId);
        try {
            IGateKeeperService gk = this.getGateKeeperService();
            if (gk != null) {
                gk.clearSecureUserId(userId);
            }
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "unable to clear GK secure user id");
        }
        if (unknownUser || this.mUserManager.getUserInfo(userId).isManagedProfile()) {
            this.removeKeystoreProfileKey(userId);
        }
    }

    private void removeKeystoreProfileKey(int targetUserId) {
        try {
            java.security.KeyStore keyStore = java.security.KeyStore.getInstance("AndroidKeyStore");
            keyStore.load(null);
            keyStore.deleteEntry("profile_key_name_encrypt_" + targetUserId);
            keyStore.deleteEntry("profile_key_name_decrypt_" + targetUserId);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Slog.e(TAG, "Unable to remove keystore profile key for user:" + targetUserId, e);
        }
    }

    @Override
    public void registerStrongAuthTracker(IStrongAuthTracker tracker) {
        this.checkPasswordReadPermission(-1);
        this.mStrongAuth.registerStrongAuthTracker(tracker);
    }

    @Override
    public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) {
        this.checkPasswordReadPermission(-1);
        this.mStrongAuth.unregisterStrongAuthTracker(tracker);
    }

    @Override
    public void requireStrongAuth(int strongAuthReason, int userId) {
        this.checkWritePermission(userId);
        this.mStrongAuth.requireStrongAuth(strongAuthReason, userId);
    }

    @Override
    public void userPresent(int userId) {
        this.checkWritePermission(userId);
        this.mStrongAuth.reportUnlock(userId);
    }

    @Override
    public int getStrongAuthForUser(int userId) {
        this.checkPasswordReadPermission(userId);
        return this.mStrongAuthTracker.getStrongAuthForUser(userId);
    }

    private boolean isCallerShell() {
        int callingUid = Binder.getCallingUid();
        return callingUid == 2000 || callingUid == 0;
    }

    private void enforceShell() {
        if (!this.isCallerShell()) {
            throw new SecurityException("Caller must be shell");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
        this.enforceShell();
        long origId = Binder.clearCallingIdentity();
        try {
            new LockSettingsShellCommand(new LockPatternUtils(this.mContext)).exec(this, in, out, err, args, callback, resultReceiver);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    @Override
    public void initRecoveryServiceWithSigFile(String rootCertificateAlias, byte[] recoveryServiceCertFile, byte[] recoveryServiceSigFile) throws RemoteException {
        this.mRecoverableKeyStoreManager.initRecoveryServiceWithSigFile(rootCertificateAlias, recoveryServiceCertFile, recoveryServiceSigFile);
    }

    @Override
    public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException {
        return this.mRecoverableKeyStoreManager.getKeyChainSnapshot();
    }

    @Override
    public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws RemoteException {
        this.mRecoverableKeyStoreManager.setSnapshotCreatedPendingIntent(intent);
    }

    @Override
    public void setServerParams(byte[] serverParams) throws RemoteException {
        this.mRecoverableKeyStoreManager.setServerParams(serverParams);
    }

    @Override
    public void setRecoveryStatus(String alias, int status) throws RemoteException {
        this.mRecoverableKeyStoreManager.setRecoveryStatus(alias, status);
    }

    @Override
    public Map getRecoveryStatus() throws RemoteException {
        return this.mRecoverableKeyStoreManager.getRecoveryStatus();
    }

    @Override
    public void setRecoverySecretTypes(int[] secretTypes) throws RemoteException {
        this.mRecoverableKeyStoreManager.setRecoverySecretTypes(secretTypes);
    }

    @Override
    public int[] getRecoverySecretTypes() throws RemoteException {
        return this.mRecoverableKeyStoreManager.getRecoverySecretTypes();
    }

    @Override
    public byte[] startRecoverySessionWithCertPath(String sessionId, String rootCertificateAlias, RecoveryCertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
        return this.mRecoverableKeyStoreManager.startRecoverySessionWithCertPath(sessionId, rootCertificateAlias, verifierCertPath, vaultParams, vaultChallenge, secrets);
    }

    @Override
    public Map<String, String> recoverKeyChainSnapshot(String sessionId, byte[] recoveryKeyBlob, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
        return this.mRecoverableKeyStoreManager.recoverKeyChainSnapshot(sessionId, recoveryKeyBlob, applicationKeys);
    }

    @Override
    public void closeSession(String sessionId) throws RemoteException {
        this.mRecoverableKeyStoreManager.closeSession(sessionId);
    }

    @Override
    public void removeKey(String alias) throws RemoteException {
        this.mRecoverableKeyStoreManager.removeKey(alias);
    }

    @Override
    public String generateKey(String alias) throws RemoteException {
        return this.mRecoverableKeyStoreManager.generateKey(alias);
    }

    @Override
    public String generateKeyWithMetadata(String alias, byte[] metadata) throws RemoteException {
        return this.mRecoverableKeyStoreManager.generateKeyWithMetadata(alias, metadata);
    }

    @Override
    public String importKey(String alias, byte[] keyBytes) throws RemoteException {
        return this.mRecoverableKeyStoreManager.importKey(alias, keyBytes);
    }

    @Override
    public String importKeyWithMetadata(String alias, byte[] keyBytes, byte[] metadata) throws RemoteException {
        return this.mRecoverableKeyStoreManager.importKeyWithMetadata(alias, keyBytes, metadata);
    }

    @Override
    public String getKey(String alias) throws RemoteException {
        return this.mRecoverableKeyStoreManager.getKey(alias);
    }

    protected synchronized IGateKeeperService getGateKeeperService() throws RemoteException {
        if (this.mGateKeeperService != null) {
            return this.mGateKeeperService;
        }
        IBinder service = ServiceManager.getService("android.service.gatekeeper.IGateKeeperService");
        if (service != null) {
            service.linkToDeath(new GateKeeperDiedRecipient(), 0);
            this.mGateKeeperService = IGateKeeperService.Stub.asInterface(service);
            return this.mGateKeeperService;
        }
        Slog.e(TAG, "Unable to acquire GateKeeperService");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAuthTokenKnownForUser(int userId, SyntheticPasswordManager.AuthenticationToken auth) {
        Slog.i(TAG, "Caching SP for user " + userId);
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            this.mSpCache.put(userId, auth);
        }
        this.tryRemoveUserFromSpCacheLater(userId);
        if (this.mInjector.isGsiRunning()) {
            Slog.w(TAG, "AuthSecret disabled in GSI");
            return;
        }
        if (this.mAuthSecretService != null && this.mUserManager.getUserInfo(userId).isPrimary()) {
            try {
                byte[] rawSecret = auth.deriveVendorAuthSecret();
                ArrayList<Byte> secret = new ArrayList<Byte>(rawSecret.length);
                for (int i = 0; i < rawSecret.length; ++i) {
                    secret.add(rawSecret[i]);
                }
                this.mAuthSecretService.primaryUserCredential(secret);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed to pass primary user secret to AuthSecret HAL", e);
            }
        }
    }

    private void tryRemoveUserFromSpCacheLater(int userId) {
        this.mHandler.post(() -> {
            if (!this.shouldCacheSpForUser(userId)) {
                Slog.i(TAG, "Removing SP from cache for user " + userId);
                SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
                synchronized (syntheticPasswordManager) {
                    this.mSpCache.remove(userId);
                }
            }
        });
    }

    private boolean shouldCacheSpForUser(int userId) {
        if (Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 0, userId) == 0) {
            return true;
        }
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        if (dpmi == null) {
            return false;
        }
        return dpmi.canUserHaveUntrustedCredentialReset(userId);
    }

    @GuardedBy(value={"mSpManager"})
    @VisibleForTesting
    protected SyntheticPasswordManager.AuthenticationToken initializeSyntheticPasswordLocked(byte[] credentialHash, byte[] credential, int credentialType, int requestedQuality, int userId) throws RemoteException {
        Slog.i(TAG, "Initialize SyntheticPassword for user: " + userId);
        SyntheticPasswordManager.AuthenticationToken auth = this.mSpManager.newSyntheticPasswordAndSid(this.getGateKeeperService(), credentialHash, credential, userId);
        this.onAuthTokenKnownForUser(userId, auth);
        if (auth == null) {
            Slog.wtf(TAG, "initializeSyntheticPasswordLocked returns null auth token");
            return null;
        }
        long handle = this.mSpManager.createPasswordBasedSyntheticPassword(this.getGateKeeperService(), credential, credentialType, auth, requestedQuality, userId);
        if (credential != null) {
            if (credentialHash == null) {
                this.mSpManager.newSidForUser(this.getGateKeeperService(), auth, userId);
            }
            this.mSpManager.verifyChallenge(this.getGateKeeperService(), auth, 0L, userId);
            this.setAuthlessUserKeyProtection(userId, auth.deriveDiskEncryptionKey());
            this.setKeystorePassword(auth.deriveKeyStorePassword(), userId);
        } else {
            this.clearUserKeyProtection(userId);
            this.setKeystorePassword(null, userId);
            this.getGateKeeperService().clearSecureUserId(userId);
        }
        this.fixateNewestUserKeyAuth(userId);
        this.setLong("sp-handle", handle, userId);
        return auth;
    }

    private long getSyntheticPasswordHandleLocked(int userId) {
        return this.getLong("sp-handle", 0L, userId);
    }

    private boolean isSyntheticPasswordBasedCredentialLocked(int userId) {
        if (userId == -9999) {
            int type = this.mStorage.readPersistentDataBlock().type;
            return type == 1 || type == 2;
        }
        long handle = this.getSyntheticPasswordHandleLocked(userId);
        long enabled = this.getLong("enable-sp", 1L, 0);
        return enabled != 0L && handle != 0L;
    }

    @VisibleForTesting
    protected boolean shouldMigrateToSyntheticPasswordLocked(int userId) {
        long handle = this.getSyntheticPasswordHandleLocked(userId);
        long enabled = this.getLong("enable-sp", 1L, 0);
        return enabled != 0L && handle == 0L;
    }

    private void enableSyntheticPasswordLocked() {
        this.setLong("enable-sp", 1L, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyCredentialResponse spBasedDoVerifyCredential(byte[] userCredential, int credentialType, boolean hasChallenge, long challenge, int userId, ICheckCredentialProgressCallback progressCallback) throws RemoteException {
        VerifyCredentialResponse response;
        block15: {
            block13: {
                SyntheticPasswordManager.AuthenticationResult authResult;
                block14: {
                    BiometricManager bm;
                    if (credentialType == -1) {
                        userCredential = null;
                    }
                    PackageManager pm = this.mContext.getPackageManager();
                    if (!hasChallenge && pm.hasSystemFeature("android.hardware.biometrics.face") && this.mInjector.hasEnrolledBiometrics()) {
                        challenge = this.mContext.getSystemService(FaceManager.class).generateChallenge();
                    }
                    SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
                    synchronized (syntheticPasswordManager) {
                        if (!this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                            return null;
                        }
                        if (userId == -9999) {
                            return this.mSpManager.verifyFrpCredential(this.getGateKeeperService(), userCredential, credentialType, progressCallback);
                        }
                        long handle = this.getSyntheticPasswordHandleLocked(userId);
                        authResult = this.mSpManager.unwrapPasswordBasedSyntheticPassword(this.getGateKeeperService(), handle, userCredential, userId, progressCallback);
                        if (authResult.credentialType != credentialType) {
                            Slog.e(TAG, "Credential type mismatch.");
                            return VerifyCredentialResponse.ERROR;
                        }
                        response = authResult.gkResponse;
                        if (response.getResponseCode() == 0 && (response = this.mSpManager.verifyChallenge(this.getGateKeeperService(), authResult.authToken, challenge, userId)).getResponseCode() != 0) {
                            Slog.wtf(TAG, "verifyChallenge with SP failed.");
                            return VerifyCredentialResponse.ERROR;
                        }
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl29 : MonitorExitStatement: MONITOREXIT : var11_8
                        if (response.getResponseCode() != 0) break block13;
                        this.notifyActivePasswordMetricsAvailable(credentialType, userCredential, userId);
                        this.unlockKeystore(authResult.authToken.deriveKeyStorePassword(), userId);
                        if (!this.mInjector.hasEnrolledBiometrics()) break block14;
                        bm = this.mContext.getSystemService(BiometricManager.class);
                    }
                    Slog.i(TAG, "Resetting lockout, length: " + authResult.gkResponse.getPayload().length);
                    bm.resetLockout(authResult.gkResponse.getPayload());
                    if (!hasChallenge && pm.hasSystemFeature("android.hardware.biometrics.face")) {
                        this.mContext.getSystemService(FaceManager.class).revokeChallenge();
                    }
                }
                byte[] secret = authResult.authToken.deriveDiskEncryptionKey();
                Slog.i(TAG, "Unlocking user " + userId + " with secret only, length " + secret.length);
                this.unlockUser(userId, null, secret);
                this.activateEscrowTokens(authResult.authToken, userId);
                if (this.isManagedProfileWithSeparatedLock(userId)) {
                    this.setDeviceUnlockedForUser(userId);
                }
                this.mStrongAuth.reportSuccessfulStrongAuthUnlock(userId);
                this.onAuthTokenKnownForUser(userId, authResult.authToken);
                break block15;
            }
            if (response.getResponseCode() == 1 && response.getTimeout() > 0) {
                this.requireStrongAuth(8, userId);
            }
        }
        return response;
    }

    private void setDeviceUnlockedForUser(int userId) {
        TrustManager trustManager = this.mContext.getSystemService(TrustManager.class);
        trustManager.setDeviceLockedForUser(userId, false);
    }

    @GuardedBy(value={"mSpManager"})
    private long setLockCredentialWithAuthTokenLocked(byte[] credential, int credentialType, SyntheticPasswordManager.AuthenticationToken auth, int requestedQuality, int userId) throws RemoteException {
        Map<Integer, byte[]> profilePasswords;
        long newHandle = this.mSpManager.createPasswordBasedSyntheticPassword(this.getGateKeeperService(), credential, credentialType, auth, requestedQuality, userId);
        if (credential != null) {
            profilePasswords = null;
            if (this.mSpManager.hasSidForUser(userId)) {
                this.mSpManager.verifyChallenge(this.getGateKeeperService(), auth, 0L, userId);
            } else {
                this.mSpManager.newSidForUser(this.getGateKeeperService(), auth, userId);
                this.mSpManager.verifyChallenge(this.getGateKeeperService(), auth, 0L, userId);
                this.setAuthlessUserKeyProtection(userId, auth.deriveDiskEncryptionKey());
                this.fixateNewestUserKeyAuth(userId);
                this.setKeystorePassword(auth.deriveKeyStorePassword(), userId);
            }
        } else {
            profilePasswords = this.getDecryptedPasswordsForAllTiedProfiles(userId);
            this.mSpManager.clearSidForUser(userId);
            this.getGateKeeperService().clearSecureUserId(userId);
            this.unlockUserKey(userId, null, auth.deriveDiskEncryptionKey());
            this.clearUserKeyProtection(userId);
            this.fixateNewestUserKeyAuth(userId);
            this.unlockKeystore(auth.deriveKeyStorePassword(), userId);
            this.setKeystorePassword(null, userId);
        }
        this.setLong("sp-handle", newHandle, userId);
        this.synchronizeUnifiedWorkChallengeForProfiles(userId, profilePasswords);
        this.notifyActivePasswordMetricsAvailable(credentialType, credential, userId);
        if (profilePasswords != null) {
            for (Map.Entry<Integer, byte[]> entry : profilePasswords.entrySet()) {
                Arrays.fill(entry.getValue(), (byte)0);
            }
        }
        return newHandle;
    }

    @GuardedBy(value={"mSpManager"})
    private void spBasedSetLockCredentialInternalLocked(byte[] credential, int credentialType, byte[] savedCredential, int requestedQuality, int userId, boolean allowUntrustedChange, boolean isLockTiedToParent) throws RemoteException {
        if (this.isManagedProfileWithUnifiedLock(userId)) {
            try {
                savedCredential = this.getDecryptedPasswordForTiedProfile(userId);
            }
            catch (FileNotFoundException e) {
                Slog.i(TAG, "Child profile key not found");
            }
            catch (IOException | InvalidAlgorithmParameterException | InvalidKeyException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                Slog.e(TAG, "Failed to decrypt child profile key", e);
            }
        }
        long handle = this.getSyntheticPasswordHandleLocked(userId);
        SyntheticPasswordManager.AuthenticationResult authResult = this.mSpManager.unwrapPasswordBasedSyntheticPassword(this.getGateKeeperService(), handle, savedCredential, userId, null);
        VerifyCredentialResponse response = authResult.gkResponse;
        SyntheticPasswordManager.AuthenticationToken auth = authResult.authToken;
        if (savedCredential != null && auth == null) {
            throw new IllegalStateException("Failed to enroll " + (credentialType == 2 ? "password" : "pattern"));
        }
        boolean untrustedReset = false;
        if (auth != null) {
            this.onAuthTokenKnownForUser(userId, auth);
        } else {
            if (response == null) {
                throw new IllegalStateException("Password change failed.");
            }
            if (response.getResponseCode() == -1) {
                Slog.w(TAG, "Untrusted credential change invoked");
                auth = this.mSpCache.get(userId);
                if (!allowUntrustedChange) {
                    throw new IllegalStateException("Untrusted credential change was invoked but it was not allowed. This is likely a bug. Auth token is null: " + Boolean.toString(auth == null));
                }
                untrustedReset = true;
            } else {
                throw new IllegalStateException("Rate limit exceeded, so password was not changed.");
            }
        }
        if (auth != null) {
            if (untrustedReset) {
                this.mSpManager.newSidForUser(this.getGateKeeperService(), auth, userId);
            }
        } else {
            throw new IllegalStateException("Untrusted credential reset not possible without cached SP");
        }
        this.setLockCredentialWithAuthTokenLocked(credential, credentialType, auth, requestedQuality, userId);
        this.mSpManager.destroyPasswordBasedSyntheticPassword(handle, userId);
        this.sendCredentialsOnChangeIfRequired(credentialType, credential, userId, isLockTiedToParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getHashFactor(byte[] currentCredential, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        if (currentCredential == null || currentCredential.length == 0) {
            currentCredential = null;
        }
        if (this.isManagedProfileWithUnifiedLock(userId)) {
            try {
                currentCredential = this.getDecryptedPasswordForTiedProfile(userId);
            }
            catch (Exception e) {
                Slog.e(TAG, "Failed to get work profile credential", e);
                return null;
            }
        }
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (!this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                Slog.w(TAG, "Synthetic password not enabled");
                return null;
            }
            long handle = this.getSyntheticPasswordHandleLocked(userId);
            SyntheticPasswordManager.AuthenticationResult auth = this.mSpManager.unwrapPasswordBasedSyntheticPassword(this.getGateKeeperService(), handle, currentCredential, userId, null);
            if (auth.authToken == null) {
                Slog.w(TAG, "Current credential is incorrect");
                return null;
            }
            return auth.authToken.derivePasswordHashFactor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addEscrowToken(byte[] token, int userId, LockPatternUtils.EscrowTokenStateChangeCallback callback) throws RemoteException {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            this.enableSyntheticPasswordLocked();
            SyntheticPasswordManager.AuthenticationToken auth = null;
            if (!this.isUserSecure(userId)) {
                if (this.shouldMigrateToSyntheticPasswordLocked(userId)) {
                    auth = this.initializeSyntheticPasswordLocked(null, null, -1, 0, userId);
                } else {
                    long pwdHandle = this.getSyntheticPasswordHandleLocked(userId);
                    auth = this.mSpManager.unwrapPasswordBasedSyntheticPassword((IGateKeeperService)this.getGateKeeperService(), (long)pwdHandle, null, (int)userId, null).authToken;
                }
            }
            if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                this.disableEscrowTokenOnNonManagedDevicesIfNeeded(userId);
                if (!this.mSpManager.hasEscrowData(userId)) {
                    throw new SecurityException("Escrow token is disabled on the current user");
                }
            }
            long handle = this.mSpManager.createTokenBasedSyntheticPassword(token, userId, callback);
            if (auth != null) {
                this.mSpManager.activateTokenBasedSyntheticPassword(handle, auth, userId);
            }
            return handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateEscrowTokens(SyntheticPasswordManager.AuthenticationToken auth, int userId) {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            this.disableEscrowTokenOnNonManagedDevicesIfNeeded(userId);
            for (long handle : this.mSpManager.getPendingTokensForUser(userId)) {
                Slog.i(TAG, String.format("activateEscrowTokens: %x %d ", handle, userId));
                this.mSpManager.activateTokenBasedSyntheticPassword(handle, auth, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEscrowTokenActive(long handle, int userId) {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            return this.mSpManager.existsHandle(handle, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingEscrowToken(int userId) {
        this.checkPasswordReadPermission(userId);
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            return !this.mSpManager.getPendingTokensForUser(userId).isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeEscrowToken(long handle, int userId) {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (handle == this.getSyntheticPasswordHandleLocked(userId)) {
                Slog.w(TAG, "Cannot remove password handle");
                return false;
            }
            if (this.mSpManager.removePendingToken(handle, userId)) {
                return true;
            }
            if (this.mSpManager.existsHandle(handle, userId)) {
                this.mSpManager.destroyTokenBasedSyntheticPassword(handle, userId);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setLockCredentialWithToken(byte[] credential, int type, long tokenHandle, byte[] token, int requestedQuality, int userId) throws RemoteException {
        boolean result;
        Object object = this.mSpManager;
        synchronized (object) {
            if (!this.mSpManager.hasEscrowData(userId)) {
                throw new SecurityException("Escrow token is disabled on the current user");
            }
            result = this.setLockCredentialWithTokenInternalLocked(credential, type, tokenHandle, token, requestedQuality, userId);
        }
        if (result) {
            object = this.mSeparateChallengeLock;
            synchronized (object) {
                this.setSeparateProfileChallengeEnabledLocked(userId, true, null);
            }
            if (credential == null) {
                this.mHandler.post(() -> this.unlockUser(userId, null, null));
            }
            this.notifyPasswordChanged(userId);
            this.notifySeparateProfileChallengeChanged(userId);
        }
        return result;
    }

    @GuardedBy(value={"mSpManager"})
    private boolean setLockCredentialWithTokenInternalLocked(byte[] credential, int type, long tokenHandle, byte[] token, int requestedQuality, int userId) throws RemoteException {
        SyntheticPasswordManager.AuthenticationResult result = this.mSpManager.unwrapTokenBasedSyntheticPassword(this.getGateKeeperService(), tokenHandle, token, userId);
        if (result.authToken == null) {
            Slog.w(TAG, "Invalid escrow token supplied");
            return false;
        }
        if (result.gkResponse.getResponseCode() != 0) {
            Slog.e(TAG, "Obsolete token: synthetic password derived but it fails GK verification.");
            return false;
        }
        this.setLong("lockscreen.password_type", requestedQuality, userId);
        long oldHandle = this.getSyntheticPasswordHandleLocked(userId);
        this.setLockCredentialWithAuthTokenLocked(credential, type, result.authToken, requestedQuality, userId);
        this.mSpManager.destroyPasswordBasedSyntheticPassword(oldHandle, userId);
        this.onAuthTokenKnownForUser(userId, result.authToken);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unlockUserWithToken(long tokenHandle, byte[] token, int userId) throws RemoteException {
        SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
        synchronized (syntheticPasswordManager) {
            if (!this.mSpManager.hasEscrowData(userId)) {
                throw new SecurityException("Escrow token is disabled on the current user");
            }
            SyntheticPasswordManager.AuthenticationResult authResult = this.mSpManager.unwrapTokenBasedSyntheticPassword(this.getGateKeeperService(), tokenHandle, token, userId);
            if (authResult.authToken == null) {
                Slog.w(TAG, "Invalid escrow token supplied");
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl13 : MonitorExitStatement: MONITOREXIT : var6_4
            this.unlockUser(userId, null, authResult.authToken.deriveDiskEncryptionKey());
            this.onAuthTokenKnownForUser(userId, authResult.authToken);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, pw)) {
            return;
        }
        pw.println("Current lock settings service state:");
        pw.println(String.format("SP Enabled = %b", this.mLockPatternUtils.isSyntheticPasswordEnabled()));
        List<UserInfo> users = this.mUserManager.getUsers();
        for (int user = 0; user < users.size(); ++user) {
            int userId = users.get((int)user).id;
            pw.println("    User " + userId);
            SyntheticPasswordManager syntheticPasswordManager = this.mSpManager;
            synchronized (syntheticPasswordManager) {
                pw.println(String.format("        SP Handle = %x", this.getSyntheticPasswordHandleLocked(userId)));
            }
            try {
                pw.println(String.format("        SID = %x", this.getGateKeeperService().getSecureUserId(userId)));
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableEscrowTokenOnNonManagedDevicesIfNeeded(int userId) {
        long ident = Binder.clearCallingIdentity();
        try {
            if (this.mUserManager.getUserInfo(userId).isManagedProfile()) {
                Slog.i(TAG, "Managed profile can have escrow token");
                return;
            }
            DevicePolicyManager dpm = this.mInjector.getDevicePolicyManager();
            if (dpm.getDeviceOwnerComponentOnAnyUser() != null) {
                Slog.i(TAG, "Corp-owned device can have escrow token");
                return;
            }
            if (dpm.getProfileOwnerAsUser(userId) != null) {
                Slog.i(TAG, "User with profile owner can have escrow token");
                return;
            }
            if (!dpm.isDeviceProvisioned()) {
                Slog.i(TAG, "Postpone disabling escrow tokens until device is provisioned");
                return;
            }
            if (this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.automotive")) {
                return;
            }
            Slog.i(TAG, "Disabling escrow token on user " + userId);
            if (this.isSyntheticPasswordBasedCredentialLocked(userId)) {
                this.mSpManager.destroyEscrowData(userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private final class LocalService
    extends LockSettingsInternal {
        private LocalService() {
        }

        @Override
        public long addEscrowToken(byte[] token, int userId, LockPatternUtils.EscrowTokenStateChangeCallback callback) {
            try {
                return LockSettingsService.this.addEscrowToken(token, userId, callback);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }

        @Override
        public boolean removeEscrowToken(long handle, int userId) {
            return LockSettingsService.this.removeEscrowToken(handle, userId);
        }

        @Override
        public boolean isEscrowTokenActive(long handle, int userId) {
            return LockSettingsService.this.isEscrowTokenActive(handle, userId);
        }

        @Override
        public boolean setLockCredentialWithToken(byte[] credential, int type, long tokenHandle, byte[] token, int requestedQuality, int userId) {
            if (!LockSettingsService.this.mLockPatternUtils.hasSecureLockScreen()) {
                throw new UnsupportedOperationException("This operation requires secure lock screen feature.");
            }
            try {
                return LockSettingsService.this.setLockCredentialWithToken(credential, type, tokenHandle, token, requestedQuality, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }

        @Override
        public boolean unlockUserWithToken(long tokenHandle, byte[] token, int userId) {
            try {
                return LockSettingsService.this.unlockUserWithToken(tokenHandle, token, userId);
            }
            catch (RemoteException re) {
                throw re.rethrowFromSystemServer();
            }
        }
    }

    private class DeviceProvisionedObserver
    extends ContentObserver {
        private final Uri mDeviceProvisionedUri;
        private final Uri mUserSetupCompleteUri;
        private boolean mRegistered;

        public DeviceProvisionedObserver() {
            super(null);
            this.mDeviceProvisionedUri = Settings.Global.getUriFor("device_provisioned");
            this.mUserSetupCompleteUri = Settings.Secure.getUriFor("user_setup_complete");
        }

        @Override
        public void onChange(boolean selfChange, Uri uri, int userId) {
            if (this.mDeviceProvisionedUri.equals(uri)) {
                this.updateRegistration();
                if (this.isProvisioned()) {
                    Slog.i(LockSettingsService.TAG, "Reporting device setup complete to IGateKeeperService");
                    this.reportDeviceSetupComplete();
                    this.clearFrpCredentialIfOwnerNotSecure();
                }
            } else if (this.mUserSetupCompleteUri.equals(uri)) {
                LockSettingsService.this.tryRemoveUserFromSpCacheLater(userId);
            }
        }

        public void onSystemReady() {
            if (LockPatternUtils.frpCredentialEnabled(LockSettingsService.this.mContext)) {
                this.updateRegistration();
            } else if (!this.isProvisioned()) {
                Slog.i(LockSettingsService.TAG, "FRP credential disabled, reporting device setup complete to Gatekeeper immediately");
                this.reportDeviceSetupComplete();
            }
        }

        private void reportDeviceSetupComplete() {
            try {
                LockSettingsService.this.getGateKeeperService().reportDeviceSetupComplete();
            }
            catch (RemoteException e) {
                Slog.e(LockSettingsService.TAG, "Failure reporting to IGateKeeperService", e);
            }
        }

        private void clearFrpCredentialIfOwnerNotSecure() {
            List<UserInfo> users = LockSettingsService.this.mUserManager.getUsers();
            for (UserInfo user : users) {
                if (!LockPatternUtils.userOwnsFrpCredential(LockSettingsService.this.mContext, user)) continue;
                if (!LockSettingsService.this.isUserSecure(user.id)) {
                    LockSettingsService.this.mStorage.writePersistentDataBlock(0, user.id, 0, null);
                }
                return;
            }
        }

        private void updateRegistration() {
            boolean register;
            boolean bl = register = !this.isProvisioned();
            if (register == this.mRegistered) {
                return;
            }
            if (register) {
                LockSettingsService.this.mContext.getContentResolver().registerContentObserver(this.mDeviceProvisionedUri, false, this);
                LockSettingsService.this.mContext.getContentResolver().registerContentObserver(this.mUserSetupCompleteUri, false, this, -1);
            } else {
                LockSettingsService.this.mContext.getContentResolver().unregisterContentObserver(this);
            }
            this.mRegistered = register;
        }

        private boolean isProvisioned() {
            return Settings.Global.getInt(LockSettingsService.this.mContext.getContentResolver(), "device_provisioned", 0) != 0;
        }
    }

    private class GateKeeperDiedRecipient
    implements IBinder.DeathRecipient {
        private GateKeeperDiedRecipient() {
        }

        @Override
        public void binderDied() {
            LockSettingsService.this.mGateKeeperService.asBinder().unlinkToDeath(this, 0);
            LockSettingsService.this.mGateKeeperService = null;
        }
    }

    static class Injector {
        protected Context mContext;

        public Injector(Context context) {
            this.mContext = context;
        }

        public Context getContext() {
            return this.mContext;
        }

        public Handler getHandler() {
            return new Handler();
        }

        public LockSettingsStorage getStorage() {
            final LockSettingsStorage storage = new LockSettingsStorage(this.mContext);
            storage.setDatabaseOnCreateCallback(new LockSettingsStorage.Callback(){

                @Override
                public void initialize(SQLiteDatabase db) {
                    boolean lockScreenDisable = SystemProperties.getBoolean("ro.lockscreen.disable.default", false);
                    if (lockScreenDisable) {
                        storage.writeKeyValue(db, "lockscreen.disabled", "1", 0);
                    }
                }
            });
            return storage;
        }

        public LockSettingsStrongAuth getStrongAuth() {
            return new LockSettingsStrongAuth(this.mContext);
        }

        public SynchronizedStrongAuthTracker getStrongAuthTracker() {
            return new SynchronizedStrongAuthTracker(this.mContext);
        }

        public IActivityManager getActivityManager() {
            return ActivityManager.getService();
        }

        public LockPatternUtils getLockPatternUtils() {
            return new LockPatternUtils(this.mContext);
        }

        public NotificationManager getNotificationManager() {
            return (NotificationManager)this.mContext.getSystemService("notification");
        }

        public UserManager getUserManager() {
            return (UserManager)this.mContext.getSystemService("user");
        }

        public DevicePolicyManager getDevicePolicyManager() {
            return (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        }

        public KeyStore getKeyStore() {
            return KeyStore.getInstance();
        }

        public RecoverableKeyStoreManager getRecoverableKeyStoreManager(KeyStore keyStore) {
            return RecoverableKeyStoreManager.getInstance(this.mContext, keyStore);
        }

        public IStorageManager getStorageManager() {
            IBinder service = ServiceManager.getService("mount");
            if (service != null) {
                return IStorageManager.Stub.asInterface(service);
            }
            return null;
        }

        public SyntheticPasswordManager getSyntheticPasswordManager(LockSettingsStorage storage) {
            return new SyntheticPasswordManager(this.getContext(), storage, this.getUserManager(), new PasswordSlotManager());
        }

        public boolean hasEnrolledBiometrics() {
            BiometricManager bm = this.mContext.getSystemService(BiometricManager.class);
            return bm.canAuthenticate() == 0;
        }

        public int binderGetCallingUid() {
            return Binder.getCallingUid();
        }

        public boolean isGsiRunning() {
            return SystemProperties.getInt(LockSettingsService.GSI_RUNNING_PROP, 0) > 0;
        }
    }

    @VisibleForTesting
    protected static class SynchronizedStrongAuthTracker
    extends LockPatternUtils.StrongAuthTracker {
        public SynchronizedStrongAuthTracker(Context context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void handleStrongAuthRequiredChanged(int strongAuthFlags, int userId) {
            SynchronizedStrongAuthTracker synchronizedStrongAuthTracker = this;
            synchronized (synchronizedStrongAuthTracker) {
                super.handleStrongAuthRequiredChanged(strongAuthFlags, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStrongAuthForUser(int userId) {
            SynchronizedStrongAuthTracker synchronizedStrongAuthTracker = this;
            synchronized (synchronizedStrongAuthTracker) {
                return super.getStrongAuthForUser(userId);
            }
        }

        void register(LockSettingsStrongAuth strongAuth) {
            strongAuth.registerStrongAuthTracker(this.mStub);
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private LockSettingsService mLockSettingsService;

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            AndroidKeyStoreProvider.install();
            this.mLockSettingsService = new LockSettingsService(this.getContext());
            this.publishBinderService("lock_settings", this.mLockSettingsService);
        }

        @Override
        public void onBootPhase(int phase) {
            super.onBootPhase(phase);
            if (phase == 550) {
                this.mLockSettingsService.migrateOldDataAfterSystemReady();
            }
        }

        @Override
        public void onStartUser(int userHandle) {
            this.mLockSettingsService.onStartUser(userHandle);
        }

        @Override
        public void onUnlockUser(int userHandle) {
            this.mLockSettingsService.onUnlockUser(userHandle);
        }

        @Override
        public void onCleanupUser(int userHandle) {
            this.mLockSettingsService.onCleanupUser(userHandle);
        }
    }
}

