/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.app.ActivityManager;
import android.os.ShellCommand;
import com.android.internal.widget.LockPatternUtils;
import java.io.PrintWriter;

class LockSettingsShellCommand
extends ShellCommand {
    private static final String COMMAND_SET_PATTERN = "set-pattern";
    private static final String COMMAND_SET_PIN = "set-pin";
    private static final String COMMAND_SET_PASSWORD = "set-password";
    private static final String COMMAND_CLEAR = "clear";
    private static final String COMMAND_SP = "sp";
    private static final String COMMAND_SET_DISABLED = "set-disabled";
    private static final String COMMAND_VERIFY = "verify";
    private static final String COMMAND_GET_DISABLED = "get-disabled";
    private static final String COMMAND_HELP = "help";
    private int mCurrentUserId;
    private final LockPatternUtils mLockPatternUtils;
    private String mOld = "";
    private String mNew = "";

    LockSettingsShellCommand(LockPatternUtils lockPatternUtils) {
        this.mLockPatternUtils = lockPatternUtils;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        try {
            this.mCurrentUserId = ActivityManager.getService().getCurrentUser().id;
            this.parseArgs();
            if (!this.mLockPatternUtils.hasSecureLockScreen()) {
                switch (cmd) {
                    case "help": 
                    case "get-disabled": 
                    case "set-disabled": {
                        break;
                    }
                    default: {
                        this.getErrPrintWriter().println("The device does not support lock screen - ignoring the command.");
                        return -1;
                    }
                }
            }
            if (!this.checkCredential()) {
                return -1;
            }
            switch (cmd) {
                case "set-pattern": {
                    this.runSetPattern();
                    break;
                }
                case "set-password": {
                    this.runSetPassword();
                    break;
                }
                case "set-pin": {
                    this.runSetPin();
                    break;
                }
                case "clear": {
                    this.runClear();
                    break;
                }
                case "sp": {
                    this.runChangeSp();
                    break;
                }
                case "set-disabled": {
                    this.runSetDisabled();
                    break;
                }
                case "verify": {
                    this.runVerify();
                    break;
                }
                case "get-disabled": {
                    this.runGetDisabled();
                    break;
                }
                case "help": {
                    this.onHelp();
                    break;
                }
                default: {
                    this.getErrPrintWriter().println("Unknown command: " + cmd);
                }
            }
            return 0;
        }
        catch (Exception e) {
            this.getErrPrintWriter().println("Error while executing command: " + cmd);
            e.printStackTrace(this.getErrPrintWriter());
            return -1;
        }
    }

    private void runVerify() {
        this.getOutPrintWriter().println("Lock credential verified successfully");
    }

    @Override
    public void onHelp() {
        try (PrintWriter pw = this.getOutPrintWriter();){
            pw.println("lockSettings service commands:");
            pw.println("");
            pw.println("NOTE: when lock screen is set, all commands require the --old <CREDENTIAL> argument.");
            pw.println("");
            pw.println("  help");
            pw.println("    Prints this help text.");
            pw.println("");
            pw.println("  get-disabled [--old <CREDENTIAL>] [--user USER_ID]");
            pw.println("    Checks whether lock screen is disabled.");
            pw.println("");
            pw.println("  set-disabled [--old <CREDENTIAL>] [--user USER_ID] <true|false>");
            pw.println("    When true, disables lock screen.");
            pw.println("");
            pw.println("  set-pattern [--old <CREDENTIAL>] [--user USER_ID] <PATTERN>");
            pw.println("    Sets the lock screen as pattern, using the given PATTERN to unlock.");
            pw.println("");
            pw.println("  set-pin [--old <CREDENTIAL>] [--user USER_ID] <PIN>");
            pw.println("    Sets the lock screen as PIN, using the given PIN to unlock.");
            pw.println("");
            pw.println("  set-pin [--old <CREDENTIAL>] [--user USER_ID] <PASSWORD>");
            pw.println("    Sets the lock screen as password, using the given PASSOWRD to unlock.");
            pw.println("");
            pw.println("  sp [--old <CREDENTIAL>] [--user USER_ID]");
            pw.println("    Gets whether synthetic password is enabled.");
            pw.println("");
            pw.println("  sp [--old <CREDENTIAL>] [--user USER_ID] <1|0>");
            pw.println("    Enables / disables synthetic password.");
            pw.println("");
            pw.println("  clear [--old <CREDENTIAL>] [--user USER_ID]");
            pw.println("    Clears the lock credentials.");
            pw.println("");
            pw.println("  verify [--old <CREDENTIAL>] [--user USER_ID]");
            pw.println("    Verifies the lock credentials.");
            pw.println("");
        }
    }

    private void parseArgs() {
        String opt;
        while ((opt = this.getNextOption()) != null) {
            if ("--old".equals(opt)) {
                this.mOld = this.getNextArgRequired();
                continue;
            }
            if ("--user".equals(opt)) {
                this.mCurrentUserId = Integer.parseInt(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Unknown option: " + opt);
            throw new IllegalArgumentException();
        }
        this.mNew = this.getNextArg();
    }

    private void runChangeSp() {
        if (this.mNew != null) {
            if ("1".equals(this.mNew)) {
                this.mLockPatternUtils.enableSyntheticPassword();
                this.getOutPrintWriter().println("Synthetic password enabled");
            } else if ("0".equals(this.mNew)) {
                this.mLockPatternUtils.disableSyntheticPassword();
                this.getOutPrintWriter().println("Synthetic password disabled");
            }
        }
        this.getOutPrintWriter().println(String.format("SP Enabled = %b", this.mLockPatternUtils.isSyntheticPasswordEnabled()));
    }

    private void runSetPattern() {
        byte[] oldBytes = this.mOld != null ? this.mOld.getBytes() : null;
        this.mLockPatternUtils.saveLockPattern(LockPatternUtils.stringToPattern(this.mNew), oldBytes, this.mCurrentUserId);
        this.getOutPrintWriter().println("Pattern set to '" + this.mNew + "'");
    }

    private void runSetPassword() {
        byte[] newBytes = this.mNew != null ? this.mNew.getBytes() : null;
        byte[] oldBytes = this.mOld != null ? this.mOld.getBytes() : null;
        this.mLockPatternUtils.saveLockPassword(newBytes, oldBytes, 262144, this.mCurrentUserId);
        this.getOutPrintWriter().println("Password set to '" + this.mNew + "'");
    }

    private void runSetPin() {
        byte[] newBytes = this.mNew != null ? this.mNew.getBytes() : null;
        byte[] oldBytes = this.mOld != null ? this.mOld.getBytes() : null;
        this.mLockPatternUtils.saveLockPassword(newBytes, oldBytes, 131072, this.mCurrentUserId);
        this.getOutPrintWriter().println("Pin set to '" + this.mNew + "'");
    }

    private void runClear() {
        byte[] oldBytes = this.mOld != null ? this.mOld.getBytes() : null;
        this.mLockPatternUtils.clearLock(oldBytes, this.mCurrentUserId);
        this.getOutPrintWriter().println("Lock credential cleared");
    }

    private void runSetDisabled() {
        boolean disabled = Boolean.parseBoolean(this.mNew);
        this.mLockPatternUtils.setLockScreenDisabled(disabled, this.mCurrentUserId);
        this.getOutPrintWriter().println("Lock screen disabled set to " + disabled);
    }

    private void runGetDisabled() {
        boolean isLockScreenDisabled = this.mLockPatternUtils.isLockScreenDisabled(this.mCurrentUserId);
        this.getOutPrintWriter().println(isLockScreenDisabled);
    }

    private boolean checkCredential() {
        boolean havePassword = this.mLockPatternUtils.isLockPasswordEnabled(this.mCurrentUserId);
        boolean havePattern = this.mLockPatternUtils.isLockPatternEnabled(this.mCurrentUserId);
        if (havePassword || havePattern) {
            if (this.mLockPatternUtils.isManagedProfileWithUnifiedChallenge(this.mCurrentUserId)) {
                this.getOutPrintWriter().println("Profile uses unified challenge");
                return false;
            }
            try {
                boolean result;
                if (havePassword) {
                    byte[] passwordBytes = this.mOld != null ? this.mOld.getBytes() : null;
                    result = this.mLockPatternUtils.checkPassword(passwordBytes, this.mCurrentUserId);
                } else {
                    result = this.mLockPatternUtils.checkPattern(LockPatternUtils.stringToPattern(this.mOld), this.mCurrentUserId);
                }
                if (!result) {
                    if (!this.mLockPatternUtils.isManagedProfileWithUnifiedChallenge(this.mCurrentUserId)) {
                        this.mLockPatternUtils.reportFailedPasswordAttempt(this.mCurrentUserId);
                    }
                    this.getOutPrintWriter().println("Old password '" + this.mOld + "' didn't match");
                } else {
                    this.mLockPatternUtils.reportSuccessfulPasswordAttempt(this.mCurrentUserId);
                }
                return result;
            }
            catch (LockPatternUtils.RequestThrottledException e) {
                this.getOutPrintWriter().println("Request throttled");
                return false;
            }
        }
        if (!this.mOld.isEmpty()) {
            this.getOutPrintWriter().println("Old password provided but user has no password");
            return false;
        }
        return true;
    }
}

