/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.app.AlarmManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.IStrongAuthTracker;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.internal.widget.LockPatternUtils;

public class LockSettingsStrongAuth {
    private static final String TAG = "LockSettings";
    private static final int MSG_REQUIRE_STRONG_AUTH = 1;
    private static final int MSG_REGISTER_TRACKER = 2;
    private static final int MSG_UNREGISTER_TRACKER = 3;
    private static final int MSG_REMOVE_USER = 4;
    private static final int MSG_SCHEDULE_STRONG_AUTH_TIMEOUT = 5;
    private static final String STRONG_AUTH_TIMEOUT_ALARM_TAG = "LockSettingsStrongAuth.timeoutForUser";
    private final RemoteCallbackList<IStrongAuthTracker> mTrackers = new RemoteCallbackList();
    private final SparseIntArray mStrongAuthForUser = new SparseIntArray();
    private final ArrayMap<Integer, StrongAuthTimeoutAlarmListener> mStrongAuthTimeoutAlarmListenerForUser = new ArrayMap();
    private final int mDefaultStrongAuthFlags;
    private final Context mContext;
    private AlarmManager mAlarmManager;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    LockSettingsStrongAuth.this.handleAddStrongAuthTracker((IStrongAuthTracker)msg.obj);
                    break;
                }
                case 3: {
                    LockSettingsStrongAuth.this.handleRemoveStrongAuthTracker((IStrongAuthTracker)msg.obj);
                    break;
                }
                case 1: {
                    LockSettingsStrongAuth.this.handleRequireStrongAuth(msg.arg1, msg.arg2);
                    break;
                }
                case 4: {
                    LockSettingsStrongAuth.this.handleRemoveUser(msg.arg1);
                    break;
                }
                case 5: {
                    LockSettingsStrongAuth.this.handleScheduleStrongAuthTimeout(msg.arg1);
                }
            }
        }
    };

    public LockSettingsStrongAuth(Context context) {
        this.mContext = context;
        this.mDefaultStrongAuthFlags = LockPatternUtils.StrongAuthTracker.getDefaultFlags(context);
        this.mAlarmManager = context.getSystemService(AlarmManager.class);
    }

    private void handleAddStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mTrackers.register(tracker);
        for (int i = 0; i < this.mStrongAuthForUser.size(); ++i) {
            int key = this.mStrongAuthForUser.keyAt(i);
            int value = this.mStrongAuthForUser.valueAt(i);
            try {
                tracker.onStrongAuthRequiredChanged(value, key);
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while adding StrongAuthTracker.", e);
            }
        }
    }

    private void handleRemoveStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mTrackers.unregister(tracker);
    }

    private void handleRequireStrongAuth(int strongAuthReason, int userId) {
        if (userId == -1) {
            for (int i = 0; i < this.mStrongAuthForUser.size(); ++i) {
                int key = this.mStrongAuthForUser.keyAt(i);
                this.handleRequireStrongAuthOneUser(strongAuthReason, key);
            }
        } else {
            this.handleRequireStrongAuthOneUser(strongAuthReason, userId);
        }
    }

    private void handleRequireStrongAuthOneUser(int strongAuthReason, int userId) {
        int newValue;
        int oldValue = this.mStrongAuthForUser.get(userId, this.mDefaultStrongAuthFlags);
        int n = newValue = strongAuthReason == 0 ? 0 : oldValue | strongAuthReason;
        if (oldValue != newValue) {
            this.mStrongAuthForUser.put(userId, newValue);
            this.notifyStrongAuthTrackers(newValue, userId);
        }
    }

    private void handleRemoveUser(int userId) {
        int index = this.mStrongAuthForUser.indexOfKey(userId);
        if (index >= 0) {
            this.mStrongAuthForUser.removeAt(index);
            this.notifyStrongAuthTrackers(this.mDefaultStrongAuthFlags, userId);
        }
    }

    private void handleScheduleStrongAuthTimeout(int userId) {
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        long when = SystemClock.elapsedRealtime() + dpm.getRequiredStrongAuthTimeout(null, userId);
        StrongAuthTimeoutAlarmListener alarm = this.mStrongAuthTimeoutAlarmListenerForUser.get(userId);
        if (alarm != null) {
            this.mAlarmManager.cancel(alarm);
        } else {
            alarm = new StrongAuthTimeoutAlarmListener(userId);
            this.mStrongAuthTimeoutAlarmListenerForUser.put(userId, alarm);
        }
        this.mAlarmManager.set(3, when, STRONG_AUTH_TIMEOUT_ALARM_TAG, alarm, this.mHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStrongAuthTrackers(int strongAuthReason, int userId) {
        int i = this.mTrackers.beginBroadcast();
        try {
            while (i > 0) {
                --i;
                try {
                    this.mTrackers.getBroadcastItem(i).onStrongAuthRequiredChanged(strongAuthReason, userId);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Exception while notifying StrongAuthTracker.", e);
                }
            }
        }
        finally {
            this.mTrackers.finishBroadcast();
        }
    }

    public void registerStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mHandler.obtainMessage(2, tracker).sendToTarget();
    }

    public void unregisterStrongAuthTracker(IStrongAuthTracker tracker) {
        this.mHandler.obtainMessage(3, tracker).sendToTarget();
    }

    public void removeUser(int userId) {
        boolean argNotUsed = false;
        this.mHandler.obtainMessage(4, userId, 0).sendToTarget();
    }

    public void requireStrongAuth(int strongAuthReason, int userId) {
        if (userId != -1 && userId < 0) {
            throw new IllegalArgumentException("userId must be an explicit user id or USER_ALL");
        }
        this.mHandler.obtainMessage(1, strongAuthReason, userId).sendToTarget();
    }

    public void reportUnlock(int userId) {
        this.requireStrongAuth(0, userId);
    }

    public void reportSuccessfulStrongAuthUnlock(int userId) {
        boolean argNotUsed = false;
        this.mHandler.obtainMessage(5, userId, 0).sendToTarget();
    }

    private class StrongAuthTimeoutAlarmListener
    implements AlarmManager.OnAlarmListener {
        private final int mUserId;

        public StrongAuthTimeoutAlarmListener(int userId) {
            this.mUserId = userId;
        }

        @Override
        public void onAlarm() {
            LockSettingsStrongAuth.this.requireStrongAuth(16, this.mUserId);
        }
    }
}

