/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings;

import android.os.SystemProperties;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class PasswordSlotManager {
    private static final String TAG = "PasswordSlotManager";
    private static final String GSI_RUNNING_PROP = "ro.gsid.image_running";
    private static final String SLOT_MAP_DIR = "/metadata/password_slots";
    private Map<Integer, String> mSlotMap;
    private Set<Integer> mActiveSlots;

    @VisibleForTesting
    protected String getSlotMapDir() {
        return SLOT_MAP_DIR;
    }

    @VisibleForTesting
    protected int getGsiImageNumber() {
        return SystemProperties.getInt(GSI_RUNNING_PROP, 0);
    }

    public void refreshActiveSlots(Set<Integer> activeSlots) throws RuntimeException {
        if (this.mSlotMap == null) {
            this.mActiveSlots = new HashSet<Integer>(activeSlots);
            return;
        }
        HashSet<Integer> slotsToDelete = new HashSet<Integer>();
        for (Map.Entry<Integer, String> entry : this.mSlotMap.entrySet()) {
            if (!entry.getValue().equals(this.getMode())) continue;
            slotsToDelete.add(entry.getKey());
        }
        for (Integer slot : slotsToDelete) {
            this.mSlotMap.remove(slot);
        }
        for (Integer slot : activeSlots) {
            this.mSlotMap.put(slot, this.getMode());
        }
        this.saveSlotMap();
    }

    public void markSlotInUse(int slot) throws RuntimeException {
        this.ensureSlotMapLoaded();
        if (this.mSlotMap.containsKey(slot) && !this.mSlotMap.get(slot).equals(this.getMode())) {
            throw new RuntimeException("password slot " + slot + " is not available");
        }
        this.mSlotMap.put(slot, this.getMode());
        this.saveSlotMap();
    }

    public void markSlotDeleted(int slot) throws RuntimeException {
        this.ensureSlotMapLoaded();
        if (this.mSlotMap.containsKey(slot) && !this.mSlotMap.get(slot).equals(this.getMode())) {
            throw new RuntimeException("password slot " + slot + " cannot be deleted");
        }
        this.mSlotMap.remove(slot);
        this.saveSlotMap();
    }

    public Set<Integer> getUsedSlots() {
        this.ensureSlotMapLoaded();
        return Collections.unmodifiableSet(this.mSlotMap.keySet());
    }

    private File getSlotMapFile() {
        return Paths.get(this.getSlotMapDir(), "slot_map").toFile();
    }

    private String getMode() {
        int gsiIndex = this.getGsiImageNumber();
        if (gsiIndex > 0) {
            return "gsi" + gsiIndex;
        }
        return "host";
    }

    @VisibleForTesting
    protected Map<Integer, String> loadSlotMap(InputStream stream) throws IOException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        Properties props = new Properties();
        props.load(stream);
        for (String slotString : props.stringPropertyNames()) {
            int slot = Integer.parseInt(slotString);
            String owner = props.getProperty(slotString);
            map.put(slot, owner);
        }
        return map;
    }

    private Map<Integer, String> loadSlotMap() {
        File file = this.getSlotMapFile();
        if (file.exists()) {
            Map<Integer, String> map;
            FileInputStream stream = new FileInputStream(file);
            Throwable throwable = null;
            try {
                map = this.loadSlotMap(stream);
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        PasswordSlotManager.$closeResource(throwable, stream);
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    Slog.e(TAG, "Could not load slot map file", e);
                }
            }
            PasswordSlotManager.$closeResource(throwable, stream);
            return map;
        }
        return new HashMap<Integer, String>();
    }

    private void ensureSlotMapLoaded() {
        if (this.mSlotMap == null) {
            this.mSlotMap = this.loadSlotMap();
            if (this.mActiveSlots != null) {
                this.refreshActiveSlots(this.mActiveSlots);
                this.mActiveSlots = null;
            }
        }
    }

    @VisibleForTesting
    protected void saveSlotMap(OutputStream stream) throws IOException {
        if (this.mSlotMap == null) {
            return;
        }
        Properties props = new Properties();
        for (Map.Entry<Integer, String> entry : this.mSlotMap.entrySet()) {
            props.setProperty(entry.getKey().toString(), entry.getValue());
        }
        props.store(stream, "");
    }

    private void saveSlotMap() {
        if (this.mSlotMap == null) {
            return;
        }
        if (!this.getSlotMapFile().getParentFile().exists()) {
            Slog.w(TAG, "Not saving slot map, " + this.getSlotMapDir() + " does not exist");
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(this.getSlotMapFile());){
            this.saveSlotMap(fos);
        }
        catch (IOException e) {
            Slog.e(TAG, "failed to save password slot map", e);
        }
    }
}

