/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.content.Context;
import android.os.RemoteException;
import android.security.Scrypt;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.KeyDerivationParams;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.ArrayUtils;
import com.android.server.locksettings.recoverablekeystore.BadPlatformKeyException;
import com.android.server.locksettings.recoverablekeystore.InsecureUserException;
import com.android.server.locksettings.recoverablekeystore.KeySyncUtils;
import com.android.server.locksettings.recoverablekeystore.PlatformDecryptionKey;
import com.android.server.locksettings.recoverablekeystore.PlatformKeyManager;
import com.android.server.locksettings.recoverablekeystore.RecoverySnapshotListenersStorage;
import com.android.server.locksettings.recoverablekeystore.TestOnlyInsecureCertificateHelper;
import com.android.server.locksettings.recoverablekeystore.WrappedKey;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDb;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySnapshotStorage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;

public class KeySyncTask
implements Runnable {
    private static final String TAG = "KeySyncTask";
    private static final String RECOVERY_KEY_ALGORITHM = "AES";
    private static final int RECOVERY_KEY_SIZE_BITS = 256;
    private static final int SALT_LENGTH_BYTES = 16;
    private static final int LENGTH_PREFIX_BYTES = 4;
    private static final String LOCK_SCREEN_HASH_ALGORITHM = "SHA-256";
    private static final int TRUSTED_HARDWARE_MAX_ATTEMPTS = 10;
    @VisibleForTesting
    static final int SCRYPT_PARAM_N = 4096;
    @VisibleForTesting
    static final int SCRYPT_PARAM_R = 8;
    @VisibleForTesting
    static final int SCRYPT_PARAM_P = 1;
    @VisibleForTesting
    static final int SCRYPT_PARAM_OUTLEN_BYTES = 32;
    private final RecoverableKeyStoreDb mRecoverableKeyStoreDb;
    private final int mUserId;
    private final int mCredentialType;
    private final byte[] mCredential;
    private final boolean mCredentialUpdated;
    private final PlatformKeyManager mPlatformKeyManager;
    private final RecoverySnapshotStorage mRecoverySnapshotStorage;
    private final RecoverySnapshotListenersStorage mSnapshotListenersStorage;
    private final TestOnlyInsecureCertificateHelper mTestOnlyInsecureCertificateHelper;
    private final Scrypt mScrypt;

    public static KeySyncTask newInstance(Context context, RecoverableKeyStoreDb recoverableKeyStoreDb, RecoverySnapshotStorage snapshotStorage, RecoverySnapshotListenersStorage recoverySnapshotListenersStorage, int userId, int credentialType, byte[] credential, boolean credentialUpdated) throws NoSuchAlgorithmException, KeyStoreException, InsecureUserException {
        return new KeySyncTask(recoverableKeyStoreDb, snapshotStorage, recoverySnapshotListenersStorage, userId, credentialType, credential, credentialUpdated, PlatformKeyManager.getInstance(context, recoverableKeyStoreDb), new TestOnlyInsecureCertificateHelper(), new Scrypt());
    }

    @VisibleForTesting
    KeySyncTask(RecoverableKeyStoreDb recoverableKeyStoreDb, RecoverySnapshotStorage snapshotStorage, RecoverySnapshotListenersStorage recoverySnapshotListenersStorage, int userId, int credentialType, byte[] credential, boolean credentialUpdated, PlatformKeyManager platformKeyManager, TestOnlyInsecureCertificateHelper testOnlyInsecureCertificateHelper, Scrypt scrypt) {
        this.mSnapshotListenersStorage = recoverySnapshotListenersStorage;
        this.mRecoverableKeyStoreDb = recoverableKeyStoreDb;
        this.mUserId = userId;
        this.mCredentialType = credentialType;
        this.mCredential = credential;
        this.mCredentialUpdated = credentialUpdated;
        this.mPlatformKeyManager = platformKeyManager;
        this.mRecoverySnapshotStorage = snapshotStorage;
        this.mTestOnlyInsecureCertificateHelper = testOnlyInsecureCertificateHelper;
        this.mScrypt = scrypt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Class<KeySyncTask> clazz = KeySyncTask.class;
            synchronized (KeySyncTask.class) {
                this.syncKeys();
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            Log.e(TAG, "Unexpected exception thrown during KeySyncTask", e);
        }
        {
            return;
        }
    }

    private void syncKeys() throws RemoteException {
        if (this.mCredentialType == -1) {
            Log.w(TAG, "Credentials are not set for user " + this.mUserId);
            int generation = this.mPlatformKeyManager.getGenerationId(this.mUserId);
            this.mPlatformKeyManager.invalidatePlatformKey(this.mUserId, generation);
            return;
        }
        if (this.isCustomLockScreen()) {
            Log.w(TAG, "Unsupported credential type " + this.mCredentialType + "for user " + this.mUserId);
            this.mRecoverableKeyStoreDb.invalidateKeysForUserIdOnCustomScreenLock(this.mUserId);
            return;
        }
        List<Integer> recoveryAgents = this.mRecoverableKeyStoreDb.getRecoveryAgents(this.mUserId);
        for (int uid : recoveryAgents) {
            try {
                this.syncKeysForAgent(uid);
            }
            catch (IOException e) {
                Log.e(TAG, "IOException during sync for agent " + uid, e);
            }
        }
        if (recoveryAgents.isEmpty()) {
            Log.w(TAG, "No recovery agent initialized for user " + this.mUserId);
        }
    }

    private boolean isCustomLockScreen() {
        return this.mCredentialType != -1 && this.mCredentialType != 1 && this.mCredentialType != 2;
    }

    private void syncKeysForAgent(int recoveryAgentUid) throws IOException, RemoteException {
        byte[] encryptedRecoveryKey;
        Long counterId;
        Map<String, byte[]> encryptedApplicationKeys;
        SecretKey recoveryKey;
        Map<String, Pair<SecretKey, byte[]>> rawKeysWithMetadata;
        PublicKey publicKey;
        boolean shouldRecreateCurrentVersion = false;
        if (!this.shouldCreateSnapshot(recoveryAgentUid)) {
            boolean bl = shouldRecreateCurrentVersion = this.mRecoverableKeyStoreDb.getSnapshotVersion(this.mUserId, recoveryAgentUid) != null && this.mRecoverySnapshotStorage.get(recoveryAgentUid) == null;
            if (shouldRecreateCurrentVersion) {
                Log.d(TAG, "Recreating most recent snapshot");
            } else {
                Log.d(TAG, "Key sync not needed.");
                return;
            }
        }
        String rootCertAlias = this.mRecoverableKeyStoreDb.getActiveRootOfTrust(this.mUserId, recoveryAgentUid);
        CertPath certPath = this.mRecoverableKeyStoreDb.getRecoveryServiceCertPath(this.mUserId, recoveryAgentUid, rootCertAlias = this.mTestOnlyInsecureCertificateHelper.getDefaultCertificateAliasIfEmpty(rootCertAlias));
        if (certPath != null) {
            Log.d(TAG, "Using the public key in stored CertPath for syncing");
            publicKey = certPath.getCertificates().get(0).getPublicKey();
        } else {
            Log.d(TAG, "Using the stored raw public key for syncing");
            publicKey = this.mRecoverableKeyStoreDb.getRecoveryServicePublicKey(this.mUserId, recoveryAgentUid);
        }
        if (publicKey == null) {
            Log.w(TAG, "Not initialized for KeySync: no public key set. Cancelling task.");
            return;
        }
        byte[] vaultHandle = this.mRecoverableKeyStoreDb.getServerParams(this.mUserId, recoveryAgentUid);
        if (vaultHandle == null) {
            Log.w(TAG, "No device ID set for user " + this.mUserId);
            return;
        }
        if (this.mTestOnlyInsecureCertificateHelper.isTestOnlyCertificateAlias(rootCertAlias)) {
            Log.w(TAG, "Insecure root certificate is used by recovery agent " + recoveryAgentUid);
            if (this.mTestOnlyInsecureCertificateHelper.doesCredentialSupportInsecureMode(this.mCredentialType, this.mCredential)) {
                Log.w(TAG, "Whitelisted credential is used to generate snapshot by recovery agent " + recoveryAgentUid);
            } else {
                Log.w(TAG, "Non whitelisted credential is used to generate recovery snapshot by " + recoveryAgentUid + " - ignore attempt.");
                return;
            }
        }
        boolean useScryptToHashCredential = this.shouldUseScryptToHashCredential();
        byte[] salt = KeySyncTask.generateSalt();
        byte[] localLskfHash = useScryptToHashCredential ? this.hashCredentialsByScrypt(salt, this.mCredential) : KeySyncTask.hashCredentialsBySaltedSha256(salt, this.mCredential);
        try {
            rawKeysWithMetadata = this.getKeysToSync(recoveryAgentUid);
        }
        catch (GeneralSecurityException e) {
            Log.e(TAG, "Failed to load recoverable keys for sync", e);
            return;
        }
        catch (InsecureUserException e) {
            Log.e(TAG, "A screen unlock triggered the key sync flow, so user must have lock screen. This should be impossible.", e);
            return;
        }
        catch (BadPlatformKeyException e) {
            Log.e(TAG, "Loaded keys for same generation ID as platform key, so BadPlatformKeyException should be impossible.", e);
            return;
        }
        catch (IOException e) {
            Log.e(TAG, "Local database error.", e);
            return;
        }
        if (this.mTestOnlyInsecureCertificateHelper.isTestOnlyCertificateAlias(rootCertAlias)) {
            rawKeysWithMetadata = this.mTestOnlyInsecureCertificateHelper.keepOnlyWhitelistedInsecureKeys(rawKeysWithMetadata);
        }
        try {
            recoveryKey = KeySyncTask.generateRecoveryKey();
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf("AES should never be unavailable", e);
            return;
        }
        try {
            encryptedApplicationKeys = KeySyncUtils.encryptKeysWithRecoveryKey(recoveryKey, rawKeysWithMetadata);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            Log.wtf(TAG, "Should be impossible: could not encrypt application keys with random key", e);
            return;
        }
        if (this.mCredentialUpdated) {
            counterId = this.generateAndStoreCounterId(recoveryAgentUid);
        } else {
            counterId = this.mRecoverableKeyStoreDb.getCounterId(this.mUserId, recoveryAgentUid);
            if (counterId == null) {
                counterId = this.generateAndStoreCounterId(recoveryAgentUid);
            }
        }
        byte[] vaultParams = KeySyncUtils.packVaultParams(publicKey, counterId, 10, vaultHandle);
        try {
            encryptedRecoveryKey = KeySyncUtils.thmEncryptRecoveryKey(publicKey, localLskfHash, vaultParams, recoveryKey);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "SecureBox encrypt algorithms unavailable", e);
            return;
        }
        catch (InvalidKeyException e) {
            Log.e(TAG, "Could not encrypt with recovery key", e);
            return;
        }
        KeyDerivationParams keyDerivationParams = useScryptToHashCredential ? KeyDerivationParams.createScryptParams(salt, 4096) : KeyDerivationParams.createSha256Params(salt);
        KeyChainProtectionParams keyChainProtectionParams = new KeyChainProtectionParams.Builder().setUserSecretType(100).setLockScreenUiFormat(KeySyncTask.getUiFormat(this.mCredentialType, this.mCredential)).setKeyDerivationParams(keyDerivationParams).setSecret(new byte[0]).build();
        ArrayList<KeyChainProtectionParams> metadataList = new ArrayList<KeyChainProtectionParams>();
        metadataList.add(keyChainProtectionParams);
        KeyChainSnapshot.Builder keyChainSnapshotBuilder = new KeyChainSnapshot.Builder().setSnapshotVersion(this.getSnapshotVersion(recoveryAgentUid, shouldRecreateCurrentVersion)).setMaxAttempts(10).setCounterId(counterId).setServerParams(vaultHandle).setKeyChainProtectionParams(metadataList).setWrappedApplicationKeys(KeySyncTask.createApplicationKeyEntries(encryptedApplicationKeys, rawKeysWithMetadata)).setEncryptedRecoveryKeyBlob(encryptedRecoveryKey);
        try {
            keyChainSnapshotBuilder.setTrustedHardwareCertPath(certPath);
        }
        catch (CertificateException e) {
            Log.wtf(TAG, "Cannot serialize CertPath when calling setTrustedHardwareCertPath", e);
            return;
        }
        this.mRecoverySnapshotStorage.put(recoveryAgentUid, keyChainSnapshotBuilder.build());
        this.mSnapshotListenersStorage.recoverySnapshotAvailable(recoveryAgentUid);
        this.mRecoverableKeyStoreDb.setShouldCreateSnapshot(this.mUserId, recoveryAgentUid, false);
    }

    @VisibleForTesting
    int getSnapshotVersion(int recoveryAgentUid, boolean shouldRecreateCurrentVersion) throws IOException {
        Long snapshotVersion = this.mRecoverableKeyStoreDb.getSnapshotVersion(this.mUserId, recoveryAgentUid);
        snapshotVersion = shouldRecreateCurrentVersion ? Long.valueOf(snapshotVersion == null ? 1L : snapshotVersion) : Long.valueOf(snapshotVersion == null ? 1L : snapshotVersion + 1L);
        long updatedRows = this.mRecoverableKeyStoreDb.setSnapshotVersion(this.mUserId, recoveryAgentUid, snapshotVersion);
        if (updatedRows < 0L) {
            Log.e(TAG, "Failed to set the snapshot version in the local DB.");
            throw new IOException("Failed to set the snapshot version in the local DB.");
        }
        return snapshotVersion.intValue();
    }

    private long generateAndStoreCounterId(int recoveryAgentUid) throws IOException {
        long counter = new SecureRandom().nextLong();
        long updatedRows = this.mRecoverableKeyStoreDb.setCounterId(this.mUserId, recoveryAgentUid, counter);
        if (updatedRows < 0L) {
            Log.e(TAG, "Failed to set the snapshot version in the local DB.");
            throw new IOException("Failed to set counterId in the local DB.");
        }
        return counter;
    }

    private Map<String, Pair<SecretKey, byte[]>> getKeysToSync(int recoveryAgentUid) throws InsecureUserException, KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchPaddingException, BadPlatformKeyException, InvalidKeyException, InvalidAlgorithmParameterException, IOException, RemoteException {
        PlatformDecryptionKey decryptKey = this.mPlatformKeyManager.getDecryptKey(this.mUserId);
        Map<String, WrappedKey> wrappedKeys = this.mRecoverableKeyStoreDb.getAllKeys(this.mUserId, recoveryAgentUid, decryptKey.getGenerationId());
        return WrappedKey.unwrapKeys(decryptKey, wrappedKeys);
    }

    private boolean shouldCreateSnapshot(int recoveryAgentUid) {
        int[] types = this.mRecoverableKeyStoreDb.getRecoverySecretTypes(this.mUserId, recoveryAgentUid);
        if (!ArrayUtils.contains(types, 100)) {
            return false;
        }
        if (this.mCredentialUpdated && this.mRecoverableKeyStoreDb.getSnapshotVersion(this.mUserId, recoveryAgentUid) != null) {
            this.mRecoverableKeyStoreDb.setShouldCreateSnapshot(this.mUserId, recoveryAgentUid, true);
            return true;
        }
        return this.mRecoverableKeyStoreDb.getShouldCreateSnapshot(this.mUserId, recoveryAgentUid);
    }

    @VisibleForTesting
    static int getUiFormat(int credentialType, byte[] credential) {
        if (credentialType == 1) {
            return 3;
        }
        if (KeySyncTask.isPin(credential)) {
            return 1;
        }
        return 2;
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[16];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    @VisibleForTesting
    static boolean isPin(byte[] credential) {
        if (credential == null) {
            return false;
        }
        int length = credential.length;
        for (int i = 0; i < length; ++i) {
            if (Character.isDigit((char)credential[i])) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static byte[] hashCredentialsBySaltedSha256(byte[] salt, byte[] credentialsBytes) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(salt.length + credentialsBytes.length + 8);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(salt.length);
        byteBuffer.put(salt);
        byteBuffer.putInt(credentialsBytes.length);
        byteBuffer.put(credentialsBytes);
        byte[] bytes = byteBuffer.array();
        try {
            byte[] hash = MessageDigest.getInstance(LOCK_SCREEN_HASH_ALGORITHM).digest(bytes);
            Arrays.fill(bytes, (byte)0);
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] hashCredentialsByScrypt(byte[] salt, byte[] credentials) {
        return this.mScrypt.scrypt(credentials, salt, 4096, 8, 1, 32);
    }

    private static SecretKey generateRecoveryKey() throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance(RECOVERY_KEY_ALGORITHM);
        keyGenerator.init(256);
        return keyGenerator.generateKey();
    }

    private static List<WrappedApplicationKey> createApplicationKeyEntries(Map<String, byte[]> encryptedApplicationKeys, Map<String, Pair<SecretKey, byte[]>> originalKeysWithMetadata) {
        ArrayList<WrappedApplicationKey> keyEntries = new ArrayList<WrappedApplicationKey>();
        for (String alias : encryptedApplicationKeys.keySet()) {
            keyEntries.add(new WrappedApplicationKey.Builder().setAlias(alias).setEncryptedKeyMaterial(encryptedApplicationKeys.get(alias)).setMetadata((byte[])originalKeysWithMetadata.get((Object)alias).second).build());
        }
        return keyEntries;
    }

    private boolean shouldUseScryptToHashCredential() {
        return this.mCredentialType == 2;
    }
}

