/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.security.KeyStore;
import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.RecoveryCertPath;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.HexDump;
import com.android.internal.util.Preconditions;
import com.android.server.locksettings.recoverablekeystore.InsecureUserException;
import com.android.server.locksettings.recoverablekeystore.KeySyncTask;
import com.android.server.locksettings.recoverablekeystore.KeySyncUtils;
import com.android.server.locksettings.recoverablekeystore.PlatformEncryptionKey;
import com.android.server.locksettings.recoverablekeystore.PlatformKeyManager;
import com.android.server.locksettings.recoverablekeystore.RecoverableKeyGenerator;
import com.android.server.locksettings.recoverablekeystore.RecoverableKeyStorageException;
import com.android.server.locksettings.recoverablekeystore.RecoverySnapshotListenersStorage;
import com.android.server.locksettings.recoverablekeystore.SecureBox;
import com.android.server.locksettings.recoverablekeystore.TestOnlyInsecureCertificateHelper;
import com.android.server.locksettings.recoverablekeystore.certificate.CertParsingException;
import com.android.server.locksettings.recoverablekeystore.certificate.CertUtils;
import com.android.server.locksettings.recoverablekeystore.certificate.CertValidationException;
import com.android.server.locksettings.recoverablekeystore.certificate.CertXml;
import com.android.server.locksettings.recoverablekeystore.certificate.SigXml;
import com.android.server.locksettings.recoverablekeystore.storage.ApplicationKeyStorage;
import com.android.server.locksettings.recoverablekeystore.storage.CleanupManager;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDb;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySessionStorage;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySnapshotStorage;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.crypto.AEADBadTagException;

public class RecoverableKeyStoreManager {
    private static final String TAG = "RecoverableKeyStoreMgr";
    private static RecoverableKeyStoreManager mInstance;
    private final Context mContext;
    private final RecoverableKeyStoreDb mDatabase;
    private final RecoverySessionStorage mRecoverySessionStorage;
    private final ExecutorService mExecutorService;
    private final RecoverySnapshotListenersStorage mListenersStorage;
    private final RecoverableKeyGenerator mRecoverableKeyGenerator;
    private final RecoverySnapshotStorage mSnapshotStorage;
    private final PlatformKeyManager mPlatformKeyManager;
    private final ApplicationKeyStorage mApplicationKeyStorage;
    private final TestOnlyInsecureCertificateHelper mTestCertHelper;
    private final CleanupManager mCleanupManager;

    public static synchronized RecoverableKeyStoreManager getInstance(Context context, KeyStore keystore) {
        if (mInstance == null) {
            ApplicationKeyStorage applicationKeyStorage;
            PlatformKeyManager platformKeyManager;
            RecoverableKeyStoreDb db = RecoverableKeyStoreDb.newInstance(context);
            try {
                platformKeyManager = PlatformKeyManager.getInstance(context, db);
                applicationKeyStorage = ApplicationKeyStorage.getInstance(keystore);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (KeyStoreException e) {
                throw new ServiceSpecificException(22, e.getMessage());
            }
            RecoverySnapshotStorage snapshotStorage = RecoverySnapshotStorage.newInstance();
            CleanupManager cleanupManager = CleanupManager.getInstance(context.getApplicationContext(), snapshotStorage, db, applicationKeyStorage);
            mInstance = new RecoverableKeyStoreManager(context.getApplicationContext(), db, new RecoverySessionStorage(), Executors.newSingleThreadExecutor(), snapshotStorage, new RecoverySnapshotListenersStorage(), platformKeyManager, applicationKeyStorage, new TestOnlyInsecureCertificateHelper(), cleanupManager);
        }
        return mInstance;
    }

    @VisibleForTesting
    RecoverableKeyStoreManager(Context context, RecoverableKeyStoreDb recoverableKeyStoreDb, RecoverySessionStorage recoverySessionStorage, ExecutorService executorService, RecoverySnapshotStorage snapshotStorage, RecoverySnapshotListenersStorage listenersStorage, PlatformKeyManager platformKeyManager, ApplicationKeyStorage applicationKeyStorage, TestOnlyInsecureCertificateHelper testOnlyInsecureCertificateHelper, CleanupManager cleanupManager) {
        this.mContext = context;
        this.mDatabase = recoverableKeyStoreDb;
        this.mRecoverySessionStorage = recoverySessionStorage;
        this.mExecutorService = executorService;
        this.mListenersStorage = listenersStorage;
        this.mSnapshotStorage = snapshotStorage;
        this.mPlatformKeyManager = platformKeyManager;
        this.mApplicationKeyStorage = applicationKeyStorage;
        this.mTestCertHelper = testOnlyInsecureCertificateHelper;
        this.mCleanupManager = cleanupManager;
        this.mCleanupManager.verifyKnownUsers();
        try {
            this.mRecoverableKeyGenerator = RecoverableKeyGenerator.newInstance(this.mDatabase);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "AES keygen algorithm not available. AOSP must support this.", e);
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    @VisibleForTesting
    void initRecoveryService(String rootCertificateAlias, byte[] recoveryServiceCertFile) throws RemoteException {
        CertPath certPath;
        CertXml certXml;
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        rootCertificateAlias = this.mTestCertHelper.getDefaultCertificateAliasIfEmpty(rootCertificateAlias);
        if (!this.mTestCertHelper.isValidRootCertificateAlias(rootCertificateAlias)) {
            throw new ServiceSpecificException(28, "Invalid root certificate alias");
        }
        String activeRootAlias = this.mDatabase.getActiveRootOfTrust(userId, uid);
        if (activeRootAlias == null) {
            Log.d(TAG, "Root of trust for recovery agent + " + uid + " is assigned for the first time to " + rootCertificateAlias);
        } else if (!activeRootAlias.equals(rootCertificateAlias)) {
            Log.i(TAG, "Root of trust for recovery agent " + uid + " is changed to " + rootCertificateAlias + " from  " + activeRootAlias);
        }
        long updatedRows = this.mDatabase.setActiveRootOfTrust(userId, uid, rootCertificateAlias);
        if (updatedRows < 0L) {
            throw new ServiceSpecificException(22, "Failed to set the root of trust in the local DB.");
        }
        try {
            certXml = CertXml.parse(recoveryServiceCertFile);
        }
        catch (CertParsingException e) {
            Log.d(TAG, "Failed to parse the input as a cert file: " + HexDump.toHexString(recoveryServiceCertFile));
            throw new ServiceSpecificException(25, e.getMessage());
        }
        long newSerial = certXml.getSerial();
        Long oldSerial = this.mDatabase.getRecoveryServiceCertSerial(userId, uid, rootCertificateAlias);
        if (oldSerial != null && oldSerial >= newSerial && !this.mTestCertHelper.isTestOnlyCertificateAlias(rootCertificateAlias)) {
            if (oldSerial != newSerial) {
                Log.e(TAG, "The cert file serial number is older than the one in database.");
                throw new ServiceSpecificException(29, "The cert file serial number is older than the one in database.");
            }
            Log.i(TAG, "The cert file serial number is the same, so skip updating.");
            return;
        }
        Log.i(TAG, "Updating the certificate with the new serial number " + newSerial);
        X509Certificate rootCert = this.mTestCertHelper.getRootCertificate(rootCertificateAlias);
        try {
            Log.d(TAG, "Getting and validating a random endpoint certificate");
            certPath = certXml.getRandomEndpointCert(rootCert);
        }
        catch (CertValidationException e) {
            Log.e(TAG, "Invalid endpoint cert", e);
            throw new ServiceSpecificException(28, e.getMessage());
        }
        try {
            Log.d(TAG, "Saving the randomly chosen endpoint certificate to database");
            long updatedCertPathRows = this.mDatabase.setRecoveryServiceCertPath(userId, uid, rootCertificateAlias, certPath);
            if (updatedCertPathRows > 0L) {
                long updatedCertSerialRows = this.mDatabase.setRecoveryServiceCertSerial(userId, uid, rootCertificateAlias, newSerial);
                if (updatedCertSerialRows < 0L) {
                    throw new ServiceSpecificException(22, "Failed to set the certificate serial number in the local DB.");
                }
                if (this.mDatabase.getSnapshotVersion(userId, uid) != null) {
                    this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
                    Log.i(TAG, "This is a certificate change. Snapshot must be updated");
                } else {
                    Log.i(TAG, "This is a certificate change. Snapshot didn't exist");
                }
                long updatedCounterIdRows = this.mDatabase.setCounterId(userId, uid, new SecureRandom().nextLong());
                if (updatedCounterIdRows < 0L) {
                    Log.e(TAG, "Failed to set the counter id in the local DB.");
                }
            } else if (updatedCertPathRows < 0L) {
                throw new ServiceSpecificException(22, "Failed to set the certificate path in the local DB.");
            }
        }
        catch (CertificateEncodingException e) {
            Log.e(TAG, "Failed to encode CertPath", e);
            throw new ServiceSpecificException(25, e.getMessage());
        }
    }

    public void initRecoveryServiceWithSigFile(String rootCertificateAlias, byte[] recoveryServiceCertFile, byte[] recoveryServiceSigFile) throws RemoteException {
        SigXml sigXml;
        this.checkRecoverKeyStorePermission();
        rootCertificateAlias = this.mTestCertHelper.getDefaultCertificateAliasIfEmpty(rootCertificateAlias);
        Preconditions.checkNotNull(recoveryServiceCertFile, "recoveryServiceCertFile is null");
        Preconditions.checkNotNull(recoveryServiceSigFile, "recoveryServiceSigFile is null");
        try {
            sigXml = SigXml.parse(recoveryServiceSigFile);
        }
        catch (CertParsingException e) {
            Log.d(TAG, "Failed to parse the sig file: " + HexDump.toHexString(recoveryServiceSigFile));
            throw new ServiceSpecificException(25, e.getMessage());
        }
        X509Certificate rootCert = this.mTestCertHelper.getRootCertificate(rootCertificateAlias);
        try {
            sigXml.verifyFileSignature(rootCert, recoveryServiceCertFile);
        }
        catch (CertValidationException e) {
            Log.d(TAG, "The signature over the cert file is invalid. Cert: " + HexDump.toHexString(recoveryServiceCertFile) + " Sig: " + HexDump.toHexString(recoveryServiceSigFile));
            throw new ServiceSpecificException(28, e.getMessage());
        }
        this.initRecoveryService(rootCertificateAlias, recoveryServiceCertFile);
    }

    public KeyChainSnapshot getKeyChainSnapshot() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        KeyChainSnapshot snapshot = this.mSnapshotStorage.get(uid);
        if (snapshot == null) {
            throw new ServiceSpecificException(21);
        }
        return snapshot;
    }

    public void setSnapshotCreatedPendingIntent(PendingIntent intent) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        this.mListenersStorage.setSnapshotListener(uid, intent);
    }

    public void setServerParams(byte[] serverParams) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        byte[] currentServerParams = this.mDatabase.getServerParams(userId, uid);
        if (Arrays.equals(serverParams, currentServerParams)) {
            Log.v(TAG, "Not updating server params - same as old value.");
            return;
        }
        long updatedRows = this.mDatabase.setServerParams(userId, uid, serverParams);
        if (updatedRows < 0L) {
            throw new ServiceSpecificException(22, "Database failure trying to set server params.");
        }
        if (currentServerParams == null) {
            Log.i(TAG, "Initialized server params.");
            return;
        }
        if (this.mDatabase.getSnapshotVersion(userId, uid) != null) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
            Log.i(TAG, "Updated server params. Snapshot must be updated");
        } else {
            Log.i(TAG, "Updated server params. Snapshot didn't exist");
        }
    }

    public void setRecoveryStatus(String alias, int status) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(alias, "alias is null");
        long updatedRows = this.mDatabase.setRecoveryStatus(Binder.getCallingUid(), alias, status);
        if (updatedRows < 0L) {
            throw new ServiceSpecificException(22, "Failed to set the key recovery status in the local DB.");
        }
    }

    public Map<String, Integer> getRecoveryStatus() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        return this.mDatabase.getStatusForAllKeys(Binder.getCallingUid());
    }

    public void setRecoverySecretTypes(int[] secretTypes) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(secretTypes, "secretTypes is null");
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        int[] currentSecretTypes = this.mDatabase.getRecoverySecretTypes(userId, uid);
        if (Arrays.equals(secretTypes, currentSecretTypes)) {
            Log.v(TAG, "Not updating secret types - same as old value.");
            return;
        }
        long updatedRows = this.mDatabase.setRecoverySecretTypes(userId, uid, secretTypes);
        if (updatedRows < 0L) {
            throw new ServiceSpecificException(22, "Database error trying to set secret types.");
        }
        if (currentSecretTypes.length == 0) {
            Log.i(TAG, "Initialized secret types.");
            return;
        }
        Log.i(TAG, "Updated secret types. Snapshot pending.");
        if (this.mDatabase.getSnapshotVersion(userId, uid) != null) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
            Log.i(TAG, "Updated secret types. Snapshot must be updated");
        } else {
            Log.i(TAG, "Updated secret types. Snapshot didn't exist");
        }
    }

    public int[] getRecoverySecretTypes() throws RemoteException {
        this.checkRecoverKeyStorePermission();
        return this.mDatabase.getRecoverySecretTypes(UserHandle.getCallingUserId(), Binder.getCallingUid());
    }

    @VisibleForTesting
    byte[] startRecoverySession(String sessionId, byte[] verifierPublicKey, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
        PublicKey publicKey;
        this.checkRecoverKeyStorePermission();
        int uid = Binder.getCallingUid();
        if (secrets.size() != 1) {
            throw new UnsupportedOperationException("Only a single KeyChainProtectionParams is supported");
        }
        try {
            publicKey = KeySyncUtils.deserializePublicKey(verifierPublicKey);
        }
        catch (InvalidKeySpecException e) {
            throw new ServiceSpecificException(25, e.getMessage());
        }
        if (!this.publicKeysMatch(publicKey, vaultParams)) {
            throw new ServiceSpecificException(28, "The public keys given in verifierPublicKey and vaultParams do not match.");
        }
        byte[] keyClaimant = KeySyncUtils.generateKeyClaimant();
        byte[] kfHash = secrets.get(0).getSecret();
        this.mRecoverySessionStorage.add(uid, new RecoverySessionStorage.Entry(sessionId, kfHash, keyClaimant, vaultParams));
        Log.i(TAG, "Received VaultParams for recovery: " + HexDump.toHexString(vaultParams));
        try {
            byte[] thmKfHash = KeySyncUtils.calculateThmKfHash(kfHash);
            return KeySyncUtils.encryptRecoveryClaim(publicKey, vaultParams, vaultChallenge, thmKfHash, keyClaimant);
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "SecureBox algorithm missing. AOSP must support this.", e);
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new ServiceSpecificException(25, e.getMessage());
        }
    }

    public byte[] startRecoverySessionWithCertPath(String sessionId, String rootCertificateAlias, RecoveryCertPath verifierCertPath, byte[] vaultParams, byte[] vaultChallenge, List<KeyChainProtectionParams> secrets) throws RemoteException {
        CertPath certPath;
        this.checkRecoverKeyStorePermission();
        rootCertificateAlias = this.mTestCertHelper.getDefaultCertificateAliasIfEmpty(rootCertificateAlias);
        Preconditions.checkNotNull(sessionId, "invalid session");
        Preconditions.checkNotNull(verifierCertPath, "verifierCertPath is null");
        Preconditions.checkNotNull(vaultParams, "vaultParams is null");
        Preconditions.checkNotNull(vaultChallenge, "vaultChallenge is null");
        Preconditions.checkNotNull(secrets, "secrets is null");
        try {
            certPath = verifierCertPath.getCertPath();
        }
        catch (CertificateException e) {
            throw new ServiceSpecificException(25, e.getMessage());
        }
        try {
            CertUtils.validateCertPath(this.mTestCertHelper.getRootCertificate(rootCertificateAlias), certPath);
        }
        catch (CertValidationException e) {
            Log.e(TAG, "Failed to validate the given cert path", e);
            throw new ServiceSpecificException(28, e.getMessage());
        }
        byte[] verifierPublicKey = certPath.getCertificates().get(0).getPublicKey().getEncoded();
        if (verifierPublicKey == null) {
            Log.e(TAG, "Failed to encode verifierPublicKey");
            throw new ServiceSpecificException(25, "Failed to encode verifierPublicKey");
        }
        return this.startRecoverySession(sessionId, verifierPublicKey, vaultParams, vaultChallenge, secrets);
    }

    public Map<String, String> recoverKeyChainSnapshot(String sessionId, byte[] encryptedRecoveryKey, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        RecoverySessionStorage.Entry sessionEntry = this.mRecoverySessionStorage.get(uid, sessionId);
        if (sessionEntry == null) {
            throw new ServiceSpecificException(24, String.format(Locale.US, "Application uid=%d does not have pending session '%s'", uid, sessionId));
        }
        try {
            byte[] recoveryKey = this.decryptRecoveryKey(sessionEntry, encryptedRecoveryKey);
            Map<String, byte[]> keysByAlias = this.recoverApplicationKeys(recoveryKey, applicationKeys);
            Map<String, String> map = this.importKeyMaterials(userId, uid, keysByAlias);
            return map;
        }
        catch (KeyStoreException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        finally {
            sessionEntry.destroy();
            this.mRecoverySessionStorage.remove(uid);
        }
    }

    private Map<String, String> importKeyMaterials(int userId, int uid, Map<String, byte[]> keysByAlias) throws KeyStoreException {
        ArrayMap<String, String> grantAliasesByAlias = new ArrayMap<String, String>(keysByAlias.size());
        for (String alias : keysByAlias.keySet()) {
            this.mApplicationKeyStorage.setSymmetricKeyEntry(userId, uid, alias, keysByAlias.get(alias));
            String grantAlias = this.getAlias(userId, uid, alias);
            Log.i(TAG, String.format(Locale.US, "Import %s -> %s", alias, grantAlias));
            grantAliasesByAlias.put(alias, grantAlias);
        }
        return grantAliasesByAlias;
    }

    private String getAlias(int userId, int uid, String alias) {
        return this.mApplicationKeyStorage.getGrantAlias(userId, uid, alias);
    }

    public void closeSession(String sessionId) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(sessionId, "invalid session");
        this.mRecoverySessionStorage.remove(Binder.getCallingUid(), sessionId);
    }

    public void removeKey(String alias) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(alias, "alias is null");
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        boolean wasRemoved = this.mDatabase.removeKey(uid, alias);
        if (wasRemoved) {
            this.mDatabase.setShouldCreateSnapshot(userId, uid, true);
            this.mApplicationKeyStorage.deleteEntry(userId, uid, alias);
        }
    }

    @Deprecated
    public String generateKey(String alias) throws RemoteException {
        return this.generateKeyWithMetadata(alias, null);
    }

    public String generateKeyWithMetadata(String alias, byte[] metadata) throws RemoteException {
        PlatformEncryptionKey encryptionKey;
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(alias, "alias is null");
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        try {
            encryptionKey = this.mPlatformKeyManager.getEncryptKey(userId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | KeyStoreException | UnrecoverableKeyException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InsecureUserException e) {
            throw new ServiceSpecificException(23, e.getMessage());
        }
        try {
            byte[] secretKey = this.mRecoverableKeyGenerator.generateAndStoreKey(encryptionKey, userId, uid, alias, metadata);
            this.mApplicationKeyStorage.setSymmetricKeyEntry(userId, uid, alias, secretKey);
            return this.getAlias(userId, uid, alias);
        }
        catch (RecoverableKeyStorageException | InvalidKeyException | KeyStoreException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    @Deprecated
    public String importKey(String alias, byte[] keyBytes) throws RemoteException {
        return this.importKeyWithMetadata(alias, keyBytes, null);
    }

    public String importKeyWithMetadata(String alias, byte[] keyBytes, byte[] metadata) throws RemoteException {
        PlatformEncryptionKey encryptionKey;
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(alias, "alias is null");
        Preconditions.checkNotNull(keyBytes, "keyBytes is null");
        if (keyBytes.length != 32) {
            Log.e(TAG, "The given key for import doesn't have the required length 256");
            throw new ServiceSpecificException(27, "The given key does not contain 256 bits.");
        }
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        try {
            encryptionKey = this.mPlatformKeyManager.getEncryptKey(userId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException | KeyStoreException | UnrecoverableKeyException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        catch (InsecureUserException e) {
            throw new ServiceSpecificException(23, e.getMessage());
        }
        try {
            this.mRecoverableKeyGenerator.importKey(encryptionKey, userId, uid, alias, keyBytes, metadata);
            this.mApplicationKeyStorage.setSymmetricKeyEntry(userId, uid, alias, keyBytes);
            return this.getAlias(userId, uid, alias);
        }
        catch (RecoverableKeyStorageException | InvalidKeyException | KeyStoreException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    public String getKey(String alias) throws RemoteException {
        this.checkRecoverKeyStorePermission();
        Preconditions.checkNotNull(alias, "alias is null");
        int uid = Binder.getCallingUid();
        int userId = UserHandle.getCallingUserId();
        return this.getAlias(userId, uid, alias);
    }

    private byte[] decryptRecoveryKey(RecoverySessionStorage.Entry sessionEntry, byte[] encryptedClaimResponse) throws RemoteException, ServiceSpecificException {
        byte[] locallyEncryptedKey;
        try {
            locallyEncryptedKey = KeySyncUtils.decryptRecoveryClaimResponse(sessionEntry.getKeyClaimant(), sessionEntry.getVaultParams(), encryptedClaimResponse);
        }
        catch (InvalidKeyException e) {
            Log.e(TAG, "Got InvalidKeyException during decrypting recovery claim response", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (AEADBadTagException e) {
            Log.e(TAG, "Got AEADBadTagException during decrypting recovery claim response", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
        try {
            return KeySyncUtils.decryptRecoveryKey(sessionEntry.getLskfHash(), locallyEncryptedKey);
        }
        catch (InvalidKeyException e) {
            Log.e(TAG, "Got InvalidKeyException during decrypting recovery key", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (AEADBadTagException e) {
            Log.e(TAG, "Got AEADBadTagException during decrypting recovery key", e);
            throw new ServiceSpecificException(26, "Failed to decrypt recovery key " + e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceSpecificException(22, e.getMessage());
        }
    }

    private Map<String, byte[]> recoverApplicationKeys(byte[] recoveryKey, List<WrappedApplicationKey> applicationKeys) throws RemoteException {
        HashMap<String, byte[]> keyMaterialByAlias = new HashMap<String, byte[]>();
        for (WrappedApplicationKey applicationKey : applicationKeys) {
            String alias = applicationKey.getAlias();
            byte[] encryptedKeyMaterial = applicationKey.getEncryptedKeyMaterial();
            byte[] keyMetadata = applicationKey.getMetadata();
            try {
                byte[] keyMaterial = KeySyncUtils.decryptApplicationKey(recoveryKey, encryptedKeyMaterial, keyMetadata);
                keyMaterialByAlias.put(alias, keyMaterial);
            }
            catch (NoSuchAlgorithmException e) {
                Log.wtf(TAG, "Missing SecureBox algorithm. AOSP required to support this.", e);
                throw new ServiceSpecificException(22, e.getMessage());
            }
            catch (InvalidKeyException e) {
                Log.e(TAG, "Got InvalidKeyException during decrypting application key with alias: " + alias, e);
                throw new ServiceSpecificException(26, "Failed to recover key with alias '" + alias + "': " + e.getMessage());
            }
            catch (AEADBadTagException e) {
                Log.e(TAG, "Got AEADBadTagException during decrypting application key with alias: " + alias, e);
            }
        }
        if (!applicationKeys.isEmpty() && keyMaterialByAlias.isEmpty()) {
            Log.e(TAG, "Failed to recover any of the application keys.");
            throw new ServiceSpecificException(26, "Failed to recover any of the application keys.");
        }
        return keyMaterialByAlias;
    }

    public void lockScreenSecretAvailable(int storedHashType, byte[] credential, int userId) {
        try {
            this.mExecutorService.execute(KeySyncTask.newInstance(this.mContext, this.mDatabase, this.mSnapshotStorage, this.mListenersStorage, userId, storedHashType, credential, false));
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "Should never happen - algorithm unavailable for KeySync", e);
        }
        catch (KeyStoreException e) {
            Log.e(TAG, "Key store error encountered during recoverable key sync", e);
        }
        catch (InsecureUserException e) {
            Log.wtf(TAG, "Impossible - insecure user, but user just entered lock screen", e);
        }
    }

    public void lockScreenSecretChanged(int storedHashType, byte[] credential, int userId) {
        try {
            this.mExecutorService.execute(KeySyncTask.newInstance(this.mContext, this.mDatabase, this.mSnapshotStorage, this.mListenersStorage, userId, storedHashType, credential, true));
        }
        catch (NoSuchAlgorithmException e) {
            Log.wtf(TAG, "Should never happen - algorithm unavailable for KeySync", e);
        }
        catch (KeyStoreException e) {
            Log.e(TAG, "Key store error encountered during recoverable key sync", e);
        }
        catch (InsecureUserException e) {
            Log.e(TAG, "InsecureUserException during lock screen secret update", e);
        }
    }

    private void checkRecoverKeyStorePermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.RECOVER_KEYSTORE", "Caller " + Binder.getCallingUid() + " doesn't have RecoverKeyStore permission.");
        int userId = UserHandle.getCallingUserId();
        int uid = Binder.getCallingUid();
        this.mCleanupManager.registerRecoveryAgent(userId, uid);
    }

    private boolean publicKeysMatch(PublicKey publicKey, byte[] vaultParams) {
        byte[] encodedPublicKey = SecureBox.encodePublicKey(publicKey);
        return Arrays.equals(encodedPublicKey, Arrays.copyOf(vaultParams, encodedPublicKey.length));
    }
}

