/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.serialization;

import android.security.keystore.recovery.KeyChainProtectionParams;
import android.security.keystore.recovery.KeyChainSnapshot;
import android.security.keystore.recovery.KeyDerivationParams;
import android.security.keystore.recovery.WrappedApplicationKey;
import android.util.Base64;
import android.util.Xml;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotParserException;
import com.android.server.locksettings.recoverablekeystore.serialization.KeyChainSnapshotSchema;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KeyChainSnapshotDeserializer {
    public static KeyChainSnapshot deserialize(InputStream inputStream) throws KeyChainSnapshotParserException, IOException {
        try {
            return KeyChainSnapshotDeserializer.deserializeInternal(inputStream);
        }
        catch (XmlPullParserException e) {
            throw new KeyChainSnapshotParserException("Malformed KeyChainSnapshot XML", e);
        }
    }

    private static KeyChainSnapshot deserializeInternal(InputStream inputStream) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(inputStream, "UTF-8");
        parser.nextTag();
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "keyChainSnapshot");
        KeyChainSnapshot.Builder builder = new KeyChainSnapshot.Builder();
        block26: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "snapshotVersion": {
                    builder.setSnapshotVersion(KeyChainSnapshotDeserializer.readIntTag(parser, "snapshotVersion"));
                    continue block26;
                }
                case "recoveryKeyMaterial": {
                    builder.setEncryptedRecoveryKeyBlob(KeyChainSnapshotDeserializer.readBlobTag(parser, "recoveryKeyMaterial"));
                    continue block26;
                }
                case "counterId": {
                    builder.setCounterId(KeyChainSnapshotDeserializer.readLongTag(parser, "counterId"));
                    continue block26;
                }
                case "serverParams": {
                    builder.setServerParams(KeyChainSnapshotDeserializer.readBlobTag(parser, "serverParams"));
                    continue block26;
                }
                case "maxAttempts": {
                    builder.setMaxAttempts(KeyChainSnapshotDeserializer.readIntTag(parser, "maxAttempts"));
                    continue block26;
                }
                case "thmCertPath": {
                    try {
                        builder.setTrustedHardwareCertPath(KeyChainSnapshotDeserializer.readCertPathTag(parser, "thmCertPath"));
                        continue block26;
                    }
                    catch (CertificateException e) {
                        throw new KeyChainSnapshotParserException("Could not set trustedHardwareCertPath", e);
                    }
                }
                case "backendPublicKey": {
                    continue block26;
                }
                case "keyChainProtectionParamsList": {
                    builder.setKeyChainProtectionParams(KeyChainSnapshotDeserializer.readKeyChainProtectionParamsList(parser));
                    continue block26;
                }
                case "applicationKeysList": {
                    builder.setWrappedApplicationKeys(KeyChainSnapshotDeserializer.readWrappedApplicationKeys(parser));
                    continue block26;
                }
            }
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "Unexpected tag %s in keyChainSnapshot", name));
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "keyChainSnapshot");
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            throw new KeyChainSnapshotParserException("Failed to build KeyChainSnapshot", e);
        }
    }

    private static List<WrappedApplicationKey> readWrappedApplicationKeys(XmlPullParser parser) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "applicationKeysList");
        ArrayList<WrappedApplicationKey> keys = new ArrayList<WrappedApplicationKey>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            keys.add(KeyChainSnapshotDeserializer.readWrappedApplicationKey(parser));
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "applicationKeysList");
        return keys;
    }

    private static WrappedApplicationKey readWrappedApplicationKey(XmlPullParser parser) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "applicationKey");
        WrappedApplicationKey.Builder builder = new WrappedApplicationKey.Builder();
        block12: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "alias": {
                    builder.setAlias(KeyChainSnapshotDeserializer.readStringTag(parser, "alias"));
                    continue block12;
                }
                case "keyMaterial": {
                    builder.setEncryptedKeyMaterial(KeyChainSnapshotDeserializer.readBlobTag(parser, "keyMaterial"));
                    continue block12;
                }
                case "keyMetadata": {
                    builder.setMetadata(KeyChainSnapshotDeserializer.readBlobTag(parser, "keyMetadata"));
                    continue block12;
                }
            }
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "Unexpected tag %s in wrappedApplicationKey", name));
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "applicationKey");
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            throw new KeyChainSnapshotParserException("Failed to build WrappedApplicationKey", e);
        }
    }

    private static List<KeyChainProtectionParams> readKeyChainProtectionParamsList(XmlPullParser parser) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParamsList");
        ArrayList<KeyChainProtectionParams> keyChainProtectionParamsList = new ArrayList<KeyChainProtectionParams>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            keyChainProtectionParamsList.add(KeyChainSnapshotDeserializer.readKeyChainProtectionParams(parser));
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParamsList");
        return keyChainProtectionParamsList;
    }

    private static KeyChainProtectionParams readKeyChainProtectionParams(XmlPullParser parser) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParams");
        KeyChainProtectionParams.Builder builder = new KeyChainProtectionParams.Builder();
        block12: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "lockScreenUiType": {
                    builder.setLockScreenUiFormat(KeyChainSnapshotDeserializer.readIntTag(parser, "lockScreenUiType"));
                    continue block12;
                }
                case "userSecretType": {
                    builder.setUserSecretType(KeyChainSnapshotDeserializer.readIntTag(parser, "userSecretType"));
                    continue block12;
                }
                case "keyDerivationParams": {
                    builder.setKeyDerivationParams(KeyChainSnapshotDeserializer.readKeyDerivationParams(parser));
                    continue block12;
                }
            }
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "Unexpected tag %s in keyChainProtectionParams", name));
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "keyChainProtectionParams");
        try {
            return builder.build();
        }
        catch (NullPointerException e) {
            throw new KeyChainSnapshotParserException("Failed to build KeyChainProtectionParams", e);
        }
    }

    private static KeyDerivationParams readKeyDerivationParams(XmlPullParser parser) throws XmlPullParserException, IOException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, "keyDerivationParams");
        int memoryDifficulty = -1;
        int algorithm = -1;
        byte[] salt = null;
        block14: while (parser.next() != 3) {
            String name;
            if (parser.getEventType() != 2) continue;
            switch (name = parser.getName()) {
                case "memoryDifficulty": {
                    memoryDifficulty = KeyChainSnapshotDeserializer.readIntTag(parser, "memoryDifficulty");
                    continue block14;
                }
                case "algorithm": {
                    algorithm = KeyChainSnapshotDeserializer.readIntTag(parser, "algorithm");
                    continue block14;
                }
                case "salt": {
                    salt = KeyChainSnapshotDeserializer.readBlobTag(parser, "salt");
                    continue block14;
                }
            }
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "Unexpected tag %s in keyDerivationParams", name));
        }
        if (salt == null) {
            throw new KeyChainSnapshotParserException("salt was not set in keyDerivationParams");
        }
        KeyDerivationParams keyDerivationParams = null;
        switch (algorithm) {
            case 1: {
                keyDerivationParams = KeyDerivationParams.createSha256Params(salt);
                break;
            }
            case 2: {
                keyDerivationParams = KeyDerivationParams.createScryptParams(salt, memoryDifficulty);
                break;
            }
            default: {
                throw new KeyChainSnapshotParserException("Unknown algorithm in keyDerivationParams");
            }
        }
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, "keyDerivationParams");
        return keyDerivationParams;
    }

    private static int readIntTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, tagName);
        String text = KeyChainSnapshotDeserializer.readText(parser);
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, tagName);
        try {
            return Integer.valueOf(text);
        }
        catch (NumberFormatException e) {
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "%s expected int but got '%s'", tagName, text), e);
        }
    }

    private static long readLongTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, tagName);
        String text = KeyChainSnapshotDeserializer.readText(parser);
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, tagName);
        try {
            return Long.valueOf(text);
        }
        catch (NumberFormatException e) {
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "%s expected long but got '%s'", tagName, text), e);
        }
    }

    private static String readStringTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, tagName);
        String text = KeyChainSnapshotDeserializer.readText(parser);
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, tagName);
        return text;
    }

    private static byte[] readBlobTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        parser.require(2, KeyChainSnapshotSchema.NAMESPACE, tagName);
        String text = KeyChainSnapshotDeserializer.readText(parser);
        parser.require(3, KeyChainSnapshotSchema.NAMESPACE, tagName);
        try {
            return Base64.decode(text, 0);
        }
        catch (IllegalArgumentException e) {
            throw new KeyChainSnapshotParserException(String.format(Locale.US, "%s expected base64 encoded bytes but got '%s'", tagName, text), e);
        }
    }

    private static CertPath readCertPathTag(XmlPullParser parser, String tagName) throws IOException, XmlPullParserException, KeyChainSnapshotParserException {
        byte[] bytes = KeyChainSnapshotDeserializer.readBlobTag(parser, tagName);
        try {
            return CertificateFactory.getInstance("X.509").generateCertPath(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            throw new KeyChainSnapshotParserException("Could not parse CertPath in tag " + tagName, e);
        }
    }

    private static String readText(XmlPullParser parser) throws IOException, XmlPullParserException {
        String result = "";
        if (parser.next() == 4) {
            result = parser.getText();
            parser.nextTag();
        }
        return result;
    }

    private KeyChainSnapshotDeserializer() {
    }
}

