/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.storage;

import android.content.Context;
import android.os.ServiceSpecificException;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.locksettings.recoverablekeystore.WrappedKey;
import com.android.server.locksettings.recoverablekeystore.storage.ApplicationKeyStorage;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverableKeyStoreDb;
import com.android.server.locksettings.recoverablekeystore.storage.RecoverySnapshotStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CleanupManager {
    private static final String TAG = "CleanupManager";
    private final Context mContext;
    private final UserManager mUserManager;
    private final RecoverableKeyStoreDb mDatabase;
    private final RecoverySnapshotStorage mSnapshotStorage;
    private final ApplicationKeyStorage mApplicationKeyStorage;
    private Map<Integer, Long> mSerialNumbers;

    public static CleanupManager getInstance(Context context, RecoverySnapshotStorage snapshotStorage, RecoverableKeyStoreDb recoverableKeyStoreDb, ApplicationKeyStorage applicationKeyStorage) {
        return new CleanupManager(context, snapshotStorage, recoverableKeyStoreDb, UserManager.get(context), applicationKeyStorage);
    }

    @VisibleForTesting
    CleanupManager(Context context, RecoverySnapshotStorage snapshotStorage, RecoverableKeyStoreDb recoverableKeyStoreDb, UserManager userManager, ApplicationKeyStorage applicationKeyStorage) {
        this.mContext = context;
        this.mSnapshotStorage = snapshotStorage;
        this.mDatabase = recoverableKeyStoreDb;
        this.mUserManager = userManager;
        this.mApplicationKeyStorage = applicationKeyStorage;
    }

    public synchronized void registerRecoveryAgent(int userId, int uid) {
        Long storedSerialNumber;
        if (this.mSerialNumbers == null) {
            this.verifyKnownUsers();
        }
        if ((storedSerialNumber = this.mSerialNumbers.get(userId)) == null) {
            storedSerialNumber = -1L;
        }
        if (storedSerialNumber != -1L) {
            return;
        }
        long currentSerialNumber = this.mUserManager.getSerialNumberForUser(UserHandle.of(userId));
        if (currentSerialNumber != -1L) {
            this.storeUserSerialNumber(userId, currentSerialNumber);
        }
    }

    public synchronized void verifyKnownUsers() {
        this.mSerialNumbers = this.mDatabase.getUserSerialNumbers();
        ArrayList<Integer> deletedUserIds = new ArrayList<Integer>(){};
        for (Map.Entry<Integer, Long> entry : this.mSerialNumbers.entrySet()) {
            long currentSerialNumber;
            Integer userId = entry.getKey();
            Long storedSerialNumber = entry.getValue();
            if (storedSerialNumber == null) {
                storedSerialNumber = -1L;
            }
            if ((currentSerialNumber = this.mUserManager.getSerialNumberForUser(UserHandle.of(userId))) == -1L) {
                deletedUserIds.add(userId);
                this.removeDataForUser(userId);
                continue;
            }
            if (storedSerialNumber == -1L) {
                this.storeUserSerialNumber(userId, currentSerialNumber);
                continue;
            }
            if (storedSerialNumber == currentSerialNumber) continue;
            deletedUserIds.add(userId);
            this.removeDataForUser(userId);
            this.storeUserSerialNumber(userId, currentSerialNumber);
        }
        for (Integer deletedUser : deletedUserIds) {
            this.mSerialNumbers.remove(deletedUser);
        }
    }

    private void storeUserSerialNumber(int userId, long userSerialNumber) {
        Log.d(TAG, "Storing serial number for user " + userId + ".");
        this.mSerialNumbers.put(userId, userSerialNumber);
        this.mDatabase.setUserSerialNumber(userId, userSerialNumber);
    }

    private void removeDataForUser(int userId) {
        Log.d(TAG, "Removing data for user " + userId + ".");
        List<Integer> recoveryAgents = this.mDatabase.getRecoveryAgents(userId);
        for (Integer uid : recoveryAgents) {
            this.mSnapshotStorage.remove(uid);
            this.removeAllKeysForRecoveryAgent(userId, uid);
        }
        this.mDatabase.removeUserFromAllTables(userId);
    }

    private void removeAllKeysForRecoveryAgent(int userId, int uid) {
        int generationId = this.mDatabase.getPlatformKeyGenerationId(userId);
        Map<String, WrappedKey> allKeys = this.mDatabase.getAllKeys(userId, uid, generationId);
        for (String alias : allKeys.keySet()) {
            try {
                this.mApplicationKeyStorage.deleteEntry(userId, uid, alias);
            }
            catch (ServiceSpecificException e) {
                Log.e(TAG, "Error while removing recoverable key " + alias + " : " + e);
            }
        }
    }
}

