/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.locksettings.recoverablekeystore.storage;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;

class RecoverableKeyStoreDbHelper
extends SQLiteOpenHelper {
    private static final String TAG = "RecoverableKeyStoreDbHp";
    static final int DATABASE_VERSION = 6;
    private static final String DATABASE_NAME = "recoverablekeystore.db";
    private static final String SQL_CREATE_KEYS_ENTRY = "CREATE TABLE keys( _id INTEGER PRIMARY KEY,user_id INTEGER,uid INTEGER,alias TEXT,nonce BLOB,wrapped_key BLOB,platform_key_generation_id INTEGER,last_synced_at INTEGER,recovery_status INTEGER,key_metadata BLOB,UNIQUE(uid,alias))";
    private static final String SQL_CREATE_USER_METADATA_ENTRY = "CREATE TABLE user_metadata( _id INTEGER PRIMARY KEY,user_id INTEGER UNIQUE,platform_key_generation_id INTEGER,user_serial_number INTEGER DEFAULT -1)";
    private static final String SQL_CREATE_RECOVERY_SERVICE_METADATA_ENTRY = "CREATE TABLE recovery_service_metadata (_id INTEGER PRIMARY KEY,user_id INTEGER,uid INTEGER,snapshot_version INTEGER,should_create_snapshot INTEGER,active_root_of_trust TEXT,public_key BLOB,cert_path BLOB,cert_serial INTEGER,secret_types TEXT,counter_id INTEGER,server_params BLOB,UNIQUE(user_id,uid))";
    private static final String SQL_CREATE_ROOT_OF_TRUST_ENTRY = "CREATE TABLE root_of_trust (_id INTEGER PRIMARY KEY,user_id INTEGER,uid INTEGER,root_alias TEXT,cert_path BLOB,cert_serial INTEGER,UNIQUE(user_id,uid,root_alias))";
    private static final String SQL_DELETE_KEYS_ENTRY = "DROP TABLE IF EXISTS keys";
    private static final String SQL_DELETE_USER_METADATA_ENTRY = "DROP TABLE IF EXISTS user_metadata";
    private static final String SQL_DELETE_RECOVERY_SERVICE_METADATA_ENTRY = "DROP TABLE IF EXISTS recovery_service_metadata";
    private static final String SQL_DELETE_ROOT_OF_TRUST_ENTRY = "DROP TABLE IF EXISTS root_of_trust";

    RecoverableKeyStoreDbHelper(Context context) {
        super(context, DATABASE_NAME, null, 6);
    }

    @Override
    public void onCreate(SQLiteDatabase db) {
        db.execSQL(SQL_CREATE_KEYS_ENTRY);
        db.execSQL(SQL_CREATE_USER_METADATA_ENTRY);
        db.execSQL(SQL_CREATE_RECOVERY_SERVICE_METADATA_ENTRY);
        db.execSQL(SQL_CREATE_ROOT_OF_TRUST_ENTRY);
    }

    @Override
    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Log.e(TAG, "Recreating recoverablekeystore after unexpected version downgrade.");
        this.dropAllKnownTables(db);
        this.onCreate(db);
    }

    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 2) {
            this.dropAllKnownTables(db);
            this.onCreate(db);
            return;
        }
        if (oldVersion < 3 && newVersion >= 3) {
            this.upgradeDbForVersion3(db);
            oldVersion = 3;
        }
        if (oldVersion < 4 && newVersion >= 4) {
            this.upgradeDbForVersion4(db);
            oldVersion = 4;
        }
        if (oldVersion < 5 && newVersion >= 5) {
            this.upgradeDbForVersion5(db);
            oldVersion = 5;
        }
        if (oldVersion < 6 && newVersion >= 6) {
            this.upgradeDbForVersion6(db);
            oldVersion = 6;
        }
        if (oldVersion != newVersion) {
            Log.e(TAG, "Failed to update recoverablekeystore database to the most recent version");
        }
    }

    private void dropAllKnownTables(SQLiteDatabase db) {
        db.execSQL(SQL_DELETE_KEYS_ENTRY);
        db.execSQL(SQL_DELETE_USER_METADATA_ENTRY);
        db.execSQL(SQL_DELETE_RECOVERY_SERVICE_METADATA_ENTRY);
        db.execSQL(SQL_DELETE_ROOT_OF_TRUST_ENTRY);
    }

    private void upgradeDbForVersion3(SQLiteDatabase db) {
        RecoverableKeyStoreDbHelper.addColumnToTable(db, "recovery_service_metadata", "cert_path", "BLOB", null);
        RecoverableKeyStoreDbHelper.addColumnToTable(db, "recovery_service_metadata", "cert_serial", "INTEGER", null);
    }

    private void upgradeDbForVersion4(SQLiteDatabase db) {
        Log.d(TAG, "Updating recoverable keystore database to version 4");
        db.execSQL(SQL_CREATE_ROOT_OF_TRUST_ENTRY);
        RecoverableKeyStoreDbHelper.addColumnToTable(db, "recovery_service_metadata", "active_root_of_trust", "TEXT", null);
    }

    private void upgradeDbForVersion5(SQLiteDatabase db) {
        Log.d(TAG, "Updating recoverable keystore database to version 5");
        RecoverableKeyStoreDbHelper.addColumnToTable(db, "keys", "key_metadata", "BLOB", null);
    }

    private void upgradeDbForVersion6(SQLiteDatabase db) {
        Log.d(TAG, "Updating recoverable keystore database to version 6");
        RecoverableKeyStoreDbHelper.addColumnToTable(db, "user_metadata", "user_serial_number", "INTEGER DEFAULT -1", null);
    }

    private static void addColumnToTable(SQLiteDatabase db, String tableName, String column, String columnType, String defaultStr) {
        Log.d(TAG, "Adding column " + column + " to " + tableName + ".");
        String alterStr = "ALTER TABLE " + tableName + " ADD COLUMN " + column + " " + columnType;
        if (defaultStr != null && !defaultStr.isEmpty()) {
            alterStr = alterStr + " DEFAULT " + defaultStr;
        }
        db.execSQL(alterStr + ";");
    }
}

