/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.Context;
import android.media.AudioManager;
import android.media.AudioPlaybackConfiguration;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AudioPlayerStateMonitor {
    private static boolean DEBUG = MediaSessionService.DEBUG;
    private static String TAG = "AudioPlayerStateMonitor";
    private static AudioPlayerStateMonitor sInstance;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final Map<OnAudioPlayerActiveStateChangedListener, MessageHandler> mListenerMap = new ArrayMap<OnAudioPlayerActiveStateChangedListener, MessageHandler>();
    @GuardedBy(value={"mLock"})
    final Set<Integer> mActiveAudioUids = new ArraySet<Integer>();
    @GuardedBy(value={"mLock"})
    ArrayMap<Integer, AudioPlaybackConfiguration> mPrevActiveAudioPlaybackConfigs = new ArrayMap();
    @GuardedBy(value={"mLock"})
    final IntArray mSortedAudioPlaybackClientUids = new IntArray();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AudioPlayerStateMonitor getInstance(Context context) {
        Class<AudioPlayerStateMonitor> clazz = AudioPlayerStateMonitor.class;
        synchronized (AudioPlayerStateMonitor.class) {
            if (sInstance == null) {
                sInstance = new AudioPlayerStateMonitor(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    private AudioPlayerStateMonitor(Context context) {
        AudioManager am = (AudioManager)context.getSystemService("audio");
        am.registerAudioPlaybackCallback(new AudioManagerPlaybackListener(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(OnAudioPlayerActiveStateChangedListener listener, Handler handler) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.put(listener, new MessageHandler(handler == null ? Looper.myLooper() : handler.getLooper(), listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(OnAudioPlayerActiveStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListenerMap.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntArray getSortedAudioPlaybackClientUids() {
        IntArray sortedAudioPlaybackClientUids = new IntArray();
        Object object = this.mLock;
        synchronized (object) {
            sortedAudioPlaybackClientUids.addAll(this.mSortedAudioPlaybackClientUids);
        }
        return sortedAudioPlaybackClientUids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveAudioUids.contains(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpAudioPlaybackUids(int mediaButtonSessionUid) {
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getUserId(mediaButtonSessionUid);
            for (int i = this.mSortedAudioPlaybackClientUids.size() - 1; i >= 0 && this.mSortedAudioPlaybackClientUids.get(i) != mediaButtonSessionUid; --i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                if (userId != UserHandle.getUserId(uid) || this.isPlaybackActive(uid)) continue;
                this.mSortedAudioPlaybackClientUids.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Context context, PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + "Audio playback (lastly played comes first)");
            String indent = prefix + "  ";
            for (int i = 0; i < this.mSortedAudioPlaybackClientUids.size(); ++i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                pw.print(indent + "uid=" + uid + " packages=");
                String[] packages = context.getPackageManager().getPackagesForUid(uid);
                if (packages != null && packages.length > 0) {
                    for (int j = 0; j < packages.length; ++j) {
                        pw.print(packages[j] + " ");
                    }
                }
                pw.println();
            }
        }
    }

    @GuardedBy(value={"mLock"})
    private void sendAudioPlayerActiveStateChangedMessageLocked(AudioPlaybackConfiguration config, boolean isRemoved) {
        for (MessageHandler messageHandler : this.mListenerMap.values()) {
            messageHandler.sendAudioPlayerActiveStateChangedMessage(config, isRemoved);
        }
    }

    private class AudioManagerPlaybackListener
    extends AudioManager.AudioPlaybackCallback {
        private AudioManagerPlaybackListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPlaybackConfigChanged(List<AudioPlaybackConfiguration> configs) {
            Object object = AudioPlayerStateMonitor.this.mLock;
            synchronized (object) {
                AudioPlayerStateMonitor.this.mActiveAudioUids.clear();
                ArrayMap<Integer, AudioPlaybackConfiguration> activeAudioPlaybackConfigs = new ArrayMap<Integer, AudioPlaybackConfiguration>();
                for (AudioPlaybackConfiguration config : configs) {
                    if (!config.isActive()) continue;
                    AudioPlayerStateMonitor.this.mActiveAudioUids.add(config.getClientUid());
                    activeAudioPlaybackConfigs.put(config.getPlayerInterfaceId(), config);
                }
                for (int i = 0; i < activeAudioPlaybackConfigs.size(); ++i) {
                    int index;
                    AudioPlaybackConfiguration config;
                    config = (AudioPlaybackConfiguration)activeAudioPlaybackConfigs.valueAt(i);
                    int uid = config.getClientUid();
                    if (AudioPlayerStateMonitor.this.mPrevActiveAudioPlaybackConfigs.containsKey(config.getPlayerInterfaceId())) continue;
                    if (DEBUG) {
                        Log.d(TAG, "Found a new active media playback. " + AudioPlaybackConfiguration.toLogFriendlyString(config));
                    }
                    if ((index = AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.indexOf(uid)) == 0) continue;
                    if (index > 0) {
                        AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.remove(index);
                    }
                    AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.add(0, uid);
                }
                if (AudioPlayerStateMonitor.this.mActiveAudioUids.size() > 0 && !AudioPlayerStateMonitor.this.mActiveAudioUids.contains(AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.get(0))) {
                    int i;
                    int firstActiveUid = -1;
                    int firatActiveUidIndex = -1;
                    for (i = 1; i < AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.size(); ++i) {
                        int uid = AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.get(i);
                        if (!AudioPlayerStateMonitor.this.mActiveAudioUids.contains(uid)) continue;
                        firatActiveUidIndex = i;
                        firstActiveUid = uid;
                        break;
                    }
                    for (i = firatActiveUidIndex; i > 0; --i) {
                        AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.set(i, AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.get(i - 1));
                    }
                    AudioPlayerStateMonitor.this.mSortedAudioPlaybackClientUids.set(0, firstActiveUid);
                }
                for (AudioPlaybackConfiguration config : configs) {
                    int pii = config.getPlayerInterfaceId();
                    boolean wasActive = AudioPlayerStateMonitor.this.mPrevActiveAudioPlaybackConfigs.remove(pii) != null;
                    if (wasActive == config.isActive()) continue;
                    AudioPlayerStateMonitor.this.sendAudioPlayerActiveStateChangedMessageLocked(config, false);
                }
                for (AudioPlaybackConfiguration config : AudioPlayerStateMonitor.this.mPrevActiveAudioPlaybackConfigs.values()) {
                    AudioPlayerStateMonitor.this.sendAudioPlayerActiveStateChangedMessageLocked(config, true);
                }
                AudioPlayerStateMonitor.this.mPrevActiveAudioPlaybackConfigs = activeAudioPlaybackConfigs;
            }
        }
    }

    private static final class MessageHandler
    extends Handler {
        private static final int MSG_AUDIO_PLAYER_ACTIVE_STATE_CHANGED = 1;
        private final OnAudioPlayerActiveStateChangedListener mListener;

        MessageHandler(Looper looper, OnAudioPlayerActiveStateChangedListener listener) {
            super(looper);
            this.mListener = listener;
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mListener.onAudioPlayerActiveStateChanged((AudioPlaybackConfiguration)msg.obj, msg.arg1 != 0);
                }
            }
        }

        void sendAudioPlayerActiveStateChangedMessage(AudioPlaybackConfiguration config, boolean isRemoved) {
            this.obtainMessage(1, isRemoved ? 1 : 0, 0, config).sendToTarget();
        }
    }

    static interface OnAudioPlayerActiveStateChangedListener {
        public void onAudioPlayerActiveStateChanged(AudioPlaybackConfiguration var1, boolean var2);
    }
}

