/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.AudioSystem;
import android.media.MediaMetadata;
import android.media.Rating;
import android.media.session.ISession;
import android.media.session.ISessionCallback;
import android.media.session.ISessionController;
import android.media.session.ISessionControllerCallback;
import android.media.session.MediaController;
import android.media.session.MediaSession;
import android.media.session.PlaybackState;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.SystemClock;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import com.android.server.LocalServices;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class MediaSessionRecord
implements IBinder.DeathRecipient {
    private static final String TAG = "MediaSessionRecord";
    private static final boolean DEBUG = Log.isLoggable("MediaSessionRecord", 3);
    private static final int OPTIMISTIC_VOLUME_TIMEOUT = 1000;
    private final MessageHandler mHandler;
    private final int mOwnerPid;
    private final int mOwnerUid;
    private final int mUserId;
    private final String mPackageName;
    private final String mTag;
    private final Bundle mSessionInfo;
    private final ControllerStub mController;
    private final MediaSession.Token mSessionToken;
    private final SessionStub mSession;
    private final SessionCb mSessionCb;
    private final MediaSessionService mService;
    private final Context mContext;
    private final Object mLock = new Object();
    private final ArrayList<ISessionControllerCallbackHolder> mControllerCallbackHolders = new ArrayList();
    private long mFlags;
    private PendingIntent mMediaButtonReceiver;
    private PendingIntent mLaunchIntent;
    private Bundle mExtras;
    private MediaMetadata mMetadata;
    private PlaybackState mPlaybackState;
    private List<MediaSession.QueueItem> mQueue;
    private CharSequence mQueueTitle;
    private int mRatingType;
    private AudioAttributes mAudioAttrs;
    private AudioManager mAudioManager;
    private AudioManagerInternal mAudioManagerInternal;
    private int mVolumeType = 1;
    private int mVolumeControlType = 2;
    private int mMaxVolume = 0;
    private int mCurrentVolume = 0;
    private int mOptimisticVolume = -1;
    private boolean mIsActive = false;
    private boolean mDestroyed = false;
    private long mDuration = -1L;
    private String mMetadataDescription;
    private final Runnable mClearOptimisticVolumeRunnable = new Runnable(){

        @Override
        public void run() {
            boolean needUpdate = MediaSessionRecord.this.mOptimisticVolume != MediaSessionRecord.this.mCurrentVolume;
            MediaSessionRecord.this.mOptimisticVolume = -1;
            if (needUpdate) {
                MediaSessionRecord.this.pushVolumeUpdate();
            }
        }
    };

    public MediaSessionRecord(int ownerPid, int ownerUid, int userId, String ownerPackageName, ISessionCallback cb, String tag, Bundle sessionInfo, MediaSessionService service, Looper handlerLooper) {
        this.mOwnerPid = ownerPid;
        this.mOwnerUid = ownerUid;
        this.mUserId = userId;
        this.mPackageName = ownerPackageName;
        this.mTag = tag;
        this.mSessionInfo = sessionInfo;
        this.mController = new ControllerStub();
        this.mSessionToken = new MediaSession.Token(this.mController);
        this.mSession = new SessionStub();
        this.mSessionCb = new SessionCb(cb);
        this.mService = service;
        this.mContext = this.mService.getContext();
        this.mHandler = new MessageHandler(handlerLooper);
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mAudioManagerInternal = LocalServices.getService(AudioManagerInternal.class);
        this.mAudioAttrs = new AudioAttributes.Builder().setUsage(1).build();
    }

    public ISession getSessionBinder() {
        return this.mSession;
    }

    public ISessionController getControllerBinder() {
        return this.mController;
    }

    public MediaSession.Token getSessionToken() {
        return this.mSessionToken;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getTag() {
        return this.mTag;
    }

    public PendingIntent getMediaButtonReceiver() {
        return this.mMediaButtonReceiver;
    }

    public long getFlags() {
        return this.mFlags;
    }

    public boolean hasFlag(int flag) {
        return (this.mFlags & (long)flag) != 0L;
    }

    public int getUid() {
        return this.mOwnerUid;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public boolean isSystemPriority() {
        return (this.mFlags & 0x10000L) != 0L;
    }

    public void adjustVolume(String packageName, String opPackageName, int pid, int uid, ISessionControllerCallback caller, boolean asSystemService, int direction, int flags, boolean useSuggested) {
        int previousFlagPlaySound = flags & 4;
        if (this.isPlaybackActive() || this.hasFlag(65536)) {
            flags &= 0xFFFFFFFB;
        }
        if (this.mVolumeType == 1) {
            int stream = AudioAttributes.toLegacyStreamType(this.mAudioAttrs);
            this.postAdjustLocalVolume(stream, direction, flags, opPackageName, pid, uid, asSystemService, useSuggested, previousFlagPlaySound);
        } else {
            if (this.mVolumeControlType == 0) {
                return;
            }
            if (direction == 101 || direction == -100 || direction == 100) {
                Log.w(TAG, "Muting remote playback is not supported");
                return;
            }
            if (DEBUG) {
                Log.w(TAG, "adjusting volume, pkg=" + packageName + ", asSystemService=" + asSystemService + ", dir=" + direction);
            }
            this.mSessionCb.adjustVolume(packageName, pid, uid, caller, asSystemService, direction);
            int volumeBefore = this.mOptimisticVolume < 0 ? this.mCurrentVolume : this.mOptimisticVolume;
            this.mOptimisticVolume = volumeBefore + direction;
            this.mOptimisticVolume = Math.max(0, Math.min(this.mOptimisticVolume, this.mMaxVolume));
            this.mHandler.removeCallbacks(this.mClearOptimisticVolumeRunnable);
            this.mHandler.postDelayed(this.mClearOptimisticVolumeRunnable, 1000L);
            if (volumeBefore != this.mOptimisticVolume) {
                this.pushVolumeUpdate();
            }
            this.mService.notifyRemoteVolumeChanged(flags, this);
            if (DEBUG) {
                Log.d(TAG, "Adjusted optimistic volume to " + this.mOptimisticVolume + " max is " + this.mMaxVolume);
            }
        }
    }

    private void setVolumeTo(String packageName, final String opPackageName, int pid, final int uid, ISessionControllerCallback caller, int value, final int flags) {
        if (this.mVolumeType == 1) {
            final int stream = AudioAttributes.toLegacyStreamType(this.mAudioAttrs);
            final int volumeValue = value;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        MediaSessionRecord.this.mAudioManagerInternal.setStreamVolumeForUid(stream, volumeValue, flags, opPackageName, uid);
                    }
                    catch (IllegalArgumentException | SecurityException e) {
                        Log.e(MediaSessionRecord.TAG, "Cannot set volume: stream=" + stream + ", value=" + volumeValue + ", flags=" + flags, e);
                    }
                }
            });
        } else {
            if (this.mVolumeControlType != 2) {
                return;
            }
            value = Math.max(0, Math.min(value, this.mMaxVolume));
            this.mSessionCb.setVolumeTo(packageName, pid, uid, caller, value);
            int volumeBefore = this.mOptimisticVolume < 0 ? this.mCurrentVolume : this.mOptimisticVolume;
            this.mOptimisticVolume = Math.max(0, Math.min(value, this.mMaxVolume));
            this.mHandler.removeCallbacks(this.mClearOptimisticVolumeRunnable);
            this.mHandler.postDelayed(this.mClearOptimisticVolumeRunnable, 1000L);
            if (volumeBefore != this.mOptimisticVolume) {
                this.pushVolumeUpdate();
            }
            this.mService.notifyRemoteVolumeChanged(flags, this);
            if (DEBUG) {
                Log.d(TAG, "Set optimistic volume to " + this.mOptimisticVolume + " max is " + this.mMaxVolume);
            }
        }
    }

    public boolean isActive() {
        return this.mIsActive && !this.mDestroyed;
    }

    public PlaybackState getPlaybackState() {
        return this.mPlaybackState;
    }

    public boolean isPlaybackActive() {
        int state = this.mPlaybackState == null ? 0 : this.mPlaybackState.getState();
        return MediaSession.isActiveState(state);
    }

    public int getPlaybackType() {
        return this.mVolumeType;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttrs;
    }

    public int getVolumeControl() {
        return this.mVolumeControlType;
    }

    public int getMaxVolume() {
        return this.mMaxVolume;
    }

    public int getCurrentVolume() {
        return this.mCurrentVolume;
    }

    public int getOptimisticVolume() {
        return this.mOptimisticVolume;
    }

    public boolean isTransportControlEnabled() {
        return this.hasFlag(2);
    }

    @Override
    public void binderDied() {
        this.mService.sessionDied(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            this.mDestroyed = true;
            this.mHandler.post(9);
        }
    }

    public ISessionCallback getCallback() {
        return this.mSessionCb.mCb;
    }

    public boolean sendMediaButton(String packageName, int pid, int uid, boolean asSystemService, KeyEvent ke, int sequenceId, ResultReceiver cb) {
        return this.mSessionCb.sendMediaButton(packageName, pid, uid, asSystemService, ke, sequenceId, cb);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.println(prefix + this.mTag + " " + this);
        String indent = prefix + "  ";
        pw.println(indent + "ownerPid=" + this.mOwnerPid + ", ownerUid=" + this.mOwnerUid + ", userId=" + this.mUserId);
        pw.println(indent + "package=" + this.mPackageName);
        pw.println(indent + "launchIntent=" + this.mLaunchIntent);
        pw.println(indent + "mediaButtonReceiver=" + this.mMediaButtonReceiver);
        pw.println(indent + "active=" + this.mIsActive);
        pw.println(indent + "flags=" + this.mFlags);
        pw.println(indent + "rating type=" + this.mRatingType);
        pw.println(indent + "controllers: " + this.mControllerCallbackHolders.size());
        pw.println(indent + "state=" + (this.mPlaybackState == null ? null : this.mPlaybackState.toString()));
        pw.println(indent + "audioAttrs=" + this.mAudioAttrs);
        pw.println(indent + "volumeType=" + this.mVolumeType + ", controlType=" + this.mVolumeControlType + ", max=" + this.mMaxVolume + ", current=" + this.mCurrentVolume);
        pw.println(indent + "metadata: " + this.mMetadataDescription);
        pw.println(indent + "queueTitle=" + this.mQueueTitle + ", size=" + (this.mQueue == null ? 0 : this.mQueue.size()));
    }

    public String toString() {
        return this.mPackageName + "/" + this.mTag + " (userId=" + this.mUserId + ")";
    }

    private void postAdjustLocalVolume(final int stream, final int direction, final int flags, String callingOpPackageName, int callingPid, int callingUid, boolean asSystemService, final boolean useSuggested, final int previousFlagPlaySound) {
        int uid;
        String opPackageName;
        if (DEBUG) {
            Log.w(TAG, "adjusting local volume, stream=" + stream + ", dir=" + direction + ", asSystemService=" + asSystemService + ", useSuggested=" + useSuggested);
        }
        if (asSystemService) {
            opPackageName = this.mContext.getOpPackageName();
            uid = 1000;
        } else {
            opPackageName = callingOpPackageName;
            uid = callingUid;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (useSuggested) {
                        if (AudioSystem.isStreamActive(stream, 0)) {
                            MediaSessionRecord.this.mAudioManagerInternal.adjustSuggestedStreamVolumeForUid(stream, direction, flags, opPackageName, uid);
                        } else {
                            MediaSessionRecord.this.mAudioManagerInternal.adjustSuggestedStreamVolumeForUid(Integer.MIN_VALUE, direction, flags | previousFlagPlaySound, opPackageName, uid);
                        }
                    } else {
                        MediaSessionRecord.this.mAudioManagerInternal.adjustStreamVolumeForUid(stream, direction, flags, opPackageName, uid);
                    }
                }
                catch (IllegalArgumentException | SecurityException e) {
                    Log.e(MediaSessionRecord.TAG, "Cannot adjust volume: direction=" + direction + ", stream=" + stream + ", flags=" + flags + ", opPackageName=" + opPackageName + ", uid=" + uid + ", useSuggested=" + useSuggested + ", previousFlagPlaySound=" + previousFlagPlaySound, e);
                }
            }
        });
    }

    private void logCallbackException(String msg, ISessionControllerCallbackHolder holder, Exception e) {
        Log.v(TAG, msg + ", this=" + this + ", callback package=" + holder.mPackageName + ", exception=" + e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushPlaybackStateUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onPlaybackStateChanged(this.mPlaybackState);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushPlaybackStateUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushPlaybackStateUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushMetadataUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onMetadataChanged(this.mMetadata);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushMetadataUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushMetadataUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushQueueUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onQueueChanged(this.mQueue == null ? null : new ParceledListSlice<MediaSession.QueueItem>(this.mQueue));
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushQueueUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushQueueUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushQueueTitleUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onQueueTitleChanged(this.mQueueTitle);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushQueueTitleUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushQueueTitleUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushExtrasUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onExtrasChanged(this.mExtras);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushExtrasUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushExtrasUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushVolumeUpdate() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            MediaController.PlaybackInfo info = this.getVolumeAttributes();
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onVolumeInfoChanged(info);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushVolumeUpdate", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushVolumeUpdate", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushEvent(String event, Bundle data) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onEvent(event, data);
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushEvent", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushEvent", holder, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSessionDestroyed() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mDestroyed) {
                return;
            }
            for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
                ISessionControllerCallbackHolder holder = this.mControllerCallbackHolders.get(i);
                try {
                    holder.mCallback.onSessionDestroyed();
                    continue;
                }
                catch (DeadObjectException e) {
                    this.mControllerCallbackHolders.remove(i);
                    this.logCallbackException("Removing dead callback in pushSessionDestroyed", holder, e);
                    continue;
                }
                catch (RemoteException e) {
                    this.logCallbackException("unexpected exception in pushSessionDestroyed", holder, e);
                }
            }
            this.mControllerCallbackHolders.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlaybackState getStateWithUpdatedPosition() {
        long duration;
        PlaybackState state;
        Object object = this.mLock;
        synchronized (object) {
            state = this.mPlaybackState;
            duration = this.mDuration;
        }
        PlaybackState result = null;
        if (state != null && (state.getState() == 3 || state.getState() == 4 || state.getState() == 5)) {
            long updateTime = state.getLastPositionUpdateTime();
            long currentTime = SystemClock.elapsedRealtime();
            if (updateTime > 0L) {
                long position = (long)(state.getPlaybackSpeed() * (float)(currentTime - updateTime)) + state.getPosition();
                if (duration >= 0L && position > duration) {
                    position = duration;
                } else if (position < 0L) {
                    position = 0L;
                }
                PlaybackState.Builder builder = new PlaybackState.Builder(state);
                builder.setState(state.getState(), position, state.getPlaybackSpeed(), currentTime);
                result = builder.build();
            }
        }
        return result == null ? state : result;
    }

    private int getControllerHolderIndexForCb(ISessionControllerCallback cb) {
        IBinder binder = cb.asBinder();
        for (int i = this.mControllerCallbackHolders.size() - 1; i >= 0; --i) {
            if (!binder.equals(this.mControllerCallbackHolders.get(i).mCallback.asBinder())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaController.PlaybackInfo getVolumeAttributes() {
        AudioAttributes attributes;
        int volumeType;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVolumeType == 2) {
                int current = this.mOptimisticVolume != -1 ? this.mOptimisticVolume : this.mCurrentVolume;
                return new MediaController.PlaybackInfo(this.mVolumeType, this.mVolumeControlType, this.mMaxVolume, current, this.mAudioAttrs);
            }
            volumeType = this.mVolumeType;
            attributes = this.mAudioAttrs;
        }
        int stream = AudioAttributes.toLegacyStreamType(attributes);
        int max = this.mAudioManager.getStreamMaxVolume(stream);
        int current = this.mAudioManager.getStreamVolume(stream);
        return new MediaController.PlaybackInfo(volumeType, 2, max, current, attributes);
    }

    private class MessageHandler
    extends Handler {
        private static final int MSG_UPDATE_METADATA = 1;
        private static final int MSG_UPDATE_PLAYBACK_STATE = 2;
        private static final int MSG_UPDATE_QUEUE = 3;
        private static final int MSG_UPDATE_QUEUE_TITLE = 4;
        private static final int MSG_UPDATE_EXTRAS = 5;
        private static final int MSG_SEND_EVENT = 6;
        private static final int MSG_UPDATE_SESSION_STATE = 7;
        private static final int MSG_UPDATE_VOLUME = 8;
        private static final int MSG_DESTROYED = 9;

        public MessageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaSessionRecord.this.pushMetadataUpdate();
                    break;
                }
                case 2: {
                    MediaSessionRecord.this.pushPlaybackStateUpdate();
                    break;
                }
                case 3: {
                    MediaSessionRecord.this.pushQueueUpdate();
                    break;
                }
                case 4: {
                    MediaSessionRecord.this.pushQueueTitleUpdate();
                    break;
                }
                case 5: {
                    MediaSessionRecord.this.pushExtrasUpdate();
                    break;
                }
                case 6: {
                    MediaSessionRecord.this.pushEvent((String)msg.obj, msg.getData());
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    MediaSessionRecord.this.pushVolumeUpdate();
                    break;
                }
                case 9: {
                    MediaSessionRecord.this.pushSessionDestroyed();
                }
            }
        }

        public void post(int what) {
            this.post(what, null);
        }

        public void post(int what, Object obj) {
            this.obtainMessage(what, obj).sendToTarget();
        }

        public void post(int what, Object obj, Bundle data) {
            Message msg = this.obtainMessage(what, obj);
            msg.setData(data);
            msg.sendToTarget();
        }
    }

    private class ISessionControllerCallbackHolder {
        private final ISessionControllerCallback mCallback;
        private final String mPackageName;
        private final int mUid;

        ISessionControllerCallbackHolder(ISessionControllerCallback callback, String packageName, int uid) {
            this.mCallback = callback;
            this.mPackageName = packageName;
            this.mUid = uid;
        }
    }

    class ControllerStub
    extends ISessionController.Stub {
        ControllerStub() {
        }

        @Override
        public void sendCommand(String packageName, ISessionControllerCallback caller, String command, Bundle args, ResultReceiver cb) {
            MediaSessionRecord.this.mSessionCb.sendCommand(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, command, args, cb);
        }

        @Override
        public boolean sendMediaButton(String packageName, ISessionControllerCallback cb, KeyEvent keyEvent) {
            return MediaSessionRecord.this.mSessionCb.sendMediaButton(packageName, Binder.getCallingPid(), Binder.getCallingUid(), cb, false, keyEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerCallback(String packageName, ISessionControllerCallback cb) {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                if (MediaSessionRecord.this.mDestroyed) {
                    try {
                        cb.onSessionDestroyed();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                if (MediaSessionRecord.this.getControllerHolderIndexForCb(cb) < 0) {
                    MediaSessionRecord.this.mControllerCallbackHolders.add(new ISessionControllerCallbackHolder(cb, packageName, Binder.getCallingUid()));
                    if (DEBUG) {
                        Log.d(MediaSessionRecord.TAG, "registering controller callback " + cb + " from controller" + packageName);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterCallback(ISessionControllerCallback cb) {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                int index = MediaSessionRecord.this.getControllerHolderIndexForCb(cb);
                if (index != -1) {
                    MediaSessionRecord.this.mControllerCallbackHolders.remove(index);
                }
                if (DEBUG) {
                    Log.d(MediaSessionRecord.TAG, "unregistering callback " + cb.asBinder());
                }
            }
        }

        @Override
        public String getPackageName() {
            return MediaSessionRecord.this.mPackageName;
        }

        @Override
        public String getTag() {
            return MediaSessionRecord.this.mTag;
        }

        @Override
        public Bundle getSessionInfo() {
            return MediaSessionRecord.this.mSessionInfo;
        }

        @Override
        public PendingIntent getLaunchPendingIntent() {
            return MediaSessionRecord.this.mLaunchIntent;
        }

        @Override
        public long getFlags() {
            return MediaSessionRecord.this.mFlags;
        }

        @Override
        public MediaController.PlaybackInfo getVolumeAttributes() {
            return MediaSessionRecord.this.getVolumeAttributes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adjustVolume(String packageName, String opPackageName, ISessionControllerCallback caller, int direction, int flags) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.adjustVolume(packageName, opPackageName, pid, uid, caller, false, direction, flags, false);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVolumeTo(String packageName, String opPackageName, ISessionControllerCallback caller, int value, int flags) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.setVolumeTo(packageName, opPackageName, pid, uid, caller, value, flags);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void prepare(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.prepare(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void prepareFromMediaId(String packageName, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.prepareFromMediaId(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, mediaId, extras);
        }

        @Override
        public void prepareFromSearch(String packageName, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.prepareFromSearch(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, query, extras);
        }

        @Override
        public void prepareFromUri(String packageName, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.prepareFromUri(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, uri, extras);
        }

        @Override
        public void play(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.play(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void playFromMediaId(String packageName, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.playFromMediaId(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, mediaId, extras);
        }

        @Override
        public void playFromSearch(String packageName, ISessionControllerCallback caller, String query, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.playFromSearch(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, query, extras);
        }

        @Override
        public void playFromUri(String packageName, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            MediaSessionRecord.this.mSessionCb.playFromUri(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, uri, extras);
        }

        @Override
        public void skipToQueueItem(String packageName, ISessionControllerCallback caller, long id2) {
            MediaSessionRecord.this.mSessionCb.skipToTrack(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, id2);
        }

        @Override
        public void pause(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.pause(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void stop(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.stop(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void next(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.next(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void previous(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.previous(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void fastForward(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.fastForward(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void rewind(String packageName, ISessionControllerCallback caller) {
            MediaSessionRecord.this.mSessionCb.rewind(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller);
        }

        @Override
        public void seekTo(String packageName, ISessionControllerCallback caller, long pos) {
            MediaSessionRecord.this.mSessionCb.seekTo(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, pos);
        }

        @Override
        public void rate(String packageName, ISessionControllerCallback caller, Rating rating) {
            MediaSessionRecord.this.mSessionCb.rate(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, rating);
        }

        @Override
        public void setPlaybackSpeed(String packageName, ISessionControllerCallback caller, float speed) {
            MediaSessionRecord.this.mSessionCb.setPlaybackSpeed(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, speed);
        }

        @Override
        public void sendCustomAction(String packageName, ISessionControllerCallback caller, String action, Bundle args) {
            MediaSessionRecord.this.mSessionCb.sendCustomAction(packageName, Binder.getCallingPid(), Binder.getCallingUid(), caller, action, args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MediaMetadata getMetadata() {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                return MediaSessionRecord.this.mMetadata;
            }
        }

        @Override
        public PlaybackState getPlaybackState() {
            return MediaSessionRecord.this.getStateWithUpdatedPosition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice getQueue() {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                return MediaSessionRecord.this.mQueue == null ? null : new ParceledListSlice(MediaSessionRecord.this.mQueue);
            }
        }

        @Override
        public CharSequence getQueueTitle() {
            return MediaSessionRecord.this.mQueueTitle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle getExtras() {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                return MediaSessionRecord.this.mExtras;
            }
        }

        @Override
        public int getRatingType() {
            return MediaSessionRecord.this.mRatingType;
        }
    }

    class SessionCb {
        private final ISessionCallback mCb;

        SessionCb(ISessionCallback cb) {
            this.mCb = cb;
        }

        public boolean sendMediaButton(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, int sequenceId, ResultReceiver cb) {
            try {
                if (asSystemService) {
                    this.mCb.onMediaButton(MediaSessionRecord.this.mContext.getPackageName(), Process.myPid(), 1000, this.createMediaButtonIntent(keyEvent), sequenceId, cb);
                } else {
                    this.mCb.onMediaButton(packageName, pid, uid, this.createMediaButtonIntent(keyEvent), sequenceId, cb);
                }
                return true;
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in sendMediaRequest.", e);
                return false;
            }
        }

        public boolean sendMediaButton(String packageName, int pid, int uid, ISessionControllerCallback caller, boolean asSystemService, KeyEvent keyEvent) {
            try {
                if (asSystemService) {
                    this.mCb.onMediaButton(MediaSessionRecord.this.mContext.getPackageName(), Process.myPid(), 1000, this.createMediaButtonIntent(keyEvent), 0, null);
                } else {
                    this.mCb.onMediaButtonFromController(packageName, pid, uid, caller, this.createMediaButtonIntent(keyEvent));
                }
                return true;
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in sendMediaRequest.", e);
                return false;
            }
        }

        public void sendCommand(String packageName, int pid, int uid, ISessionControllerCallback caller, String command, Bundle args, ResultReceiver cb) {
            try {
                this.mCb.onCommand(packageName, pid, uid, caller, command, args, cb);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in sendCommand.", e);
            }
        }

        public void sendCustomAction(String packageName, int pid, int uid, ISessionControllerCallback caller, String action, Bundle args) {
            try {
                this.mCb.onCustomAction(packageName, pid, uid, caller, action, args);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in sendCustomAction.", e);
            }
        }

        public void prepare(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onPrepare(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in prepare.", e);
            }
        }

        public void prepareFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            try {
                this.mCb.onPrepareFromMediaId(packageName, pid, uid, caller, mediaId, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in prepareFromMediaId.", e);
            }
        }

        public void prepareFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            try {
                this.mCb.onPrepareFromSearch(packageName, pid, uid, caller, query, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in prepareFromSearch.", e);
            }
        }

        public void prepareFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            try {
                this.mCb.onPrepareFromUri(packageName, pid, uid, caller, uri, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in prepareFromUri.", e);
            }
        }

        public void play(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onPlay(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in play.", e);
            }
        }

        public void playFromMediaId(String packageName, int pid, int uid, ISessionControllerCallback caller, String mediaId, Bundle extras) {
            try {
                this.mCb.onPlayFromMediaId(packageName, pid, uid, caller, mediaId, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in playFromMediaId.", e);
            }
        }

        public void playFromSearch(String packageName, int pid, int uid, ISessionControllerCallback caller, String query, Bundle extras) {
            try {
                this.mCb.onPlayFromSearch(packageName, pid, uid, caller, query, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in playFromSearch.", e);
            }
        }

        public void playFromUri(String packageName, int pid, int uid, ISessionControllerCallback caller, Uri uri, Bundle extras) {
            try {
                this.mCb.onPlayFromUri(packageName, pid, uid, caller, uri, extras);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in playFromUri.", e);
            }
        }

        public void skipToTrack(String packageName, int pid, int uid, ISessionControllerCallback caller, long id2) {
            try {
                this.mCb.onSkipToTrack(packageName, pid, uid, caller, id2);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in skipToTrack", e);
            }
        }

        public void pause(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onPause(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in pause.", e);
            }
        }

        public void stop(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onStop(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in stop.", e);
            }
        }

        public void next(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onNext(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in next.", e);
            }
        }

        public void previous(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onPrevious(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in previous.", e);
            }
        }

        public void fastForward(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onFastForward(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in fastForward.", e);
            }
        }

        public void rewind(String packageName, int pid, int uid, ISessionControllerCallback caller) {
            try {
                this.mCb.onRewind(packageName, pid, uid, caller);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in rewind.", e);
            }
        }

        public void seekTo(String packageName, int pid, int uid, ISessionControllerCallback caller, long pos) {
            try {
                this.mCb.onSeekTo(packageName, pid, uid, caller, pos);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in seekTo.", e);
            }
        }

        public void rate(String packageName, int pid, int uid, ISessionControllerCallback caller, Rating rating) {
            try {
                this.mCb.onRate(packageName, pid, uid, caller, rating);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in rate.", e);
            }
        }

        public void setPlaybackSpeed(String packageName, int pid, int uid, ISessionControllerCallback caller, float speed) {
            try {
                this.mCb.onSetPlaybackSpeed(packageName, pid, uid, caller, speed);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in setPlaybackSpeed.", e);
            }
        }

        public void adjustVolume(String packageName, int pid, int uid, ISessionControllerCallback caller, boolean asSystemService, int direction) {
            try {
                if (asSystemService) {
                    this.mCb.onAdjustVolume(MediaSessionRecord.this.mContext.getPackageName(), Process.myPid(), 1000, null, direction);
                } else {
                    this.mCb.onAdjustVolume(packageName, pid, uid, caller, direction);
                }
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in adjustVolume.", e);
            }
        }

        public void setVolumeTo(String packageName, int pid, int uid, ISessionControllerCallback caller, int value) {
            try {
                this.mCb.onSetVolumeTo(packageName, pid, uid, caller, value);
            }
            catch (RemoteException e) {
                Slog.e(MediaSessionRecord.TAG, "Remote failure in setVolumeTo.", e);
            }
        }

        private Intent createMediaButtonIntent(KeyEvent keyEvent) {
            Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
            mediaButtonIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
            return mediaButtonIntent;
        }
    }

    private final class SessionStub
    extends ISession.Stub {
        private SessionStub() {
        }

        @Override
        public void destroySession() throws RemoteException {
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.mService.destroySession(MediaSessionRecord.this);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void sendEvent(String event, Bundle data) throws RemoteException {
            MediaSessionRecord.this.mHandler.post(6, event, data == null ? null : new Bundle(data));
        }

        @Override
        public ISessionController getController() throws RemoteException {
            return MediaSessionRecord.this.mController;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setActive(boolean active) throws RemoteException {
            MediaSessionRecord.this.mIsActive = active;
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.mService.updateSession(MediaSessionRecord.this);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            MediaSessionRecord.this.mHandler.post(7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setFlags(int flags) throws RemoteException {
            if ((flags & 0x10000) != 0) {
                int pid = Binder.getCallingPid();
                int uid = Binder.getCallingUid();
                MediaSessionRecord.this.mService.enforcePhoneStatePermission(pid, uid);
            }
            MediaSessionRecord.this.mFlags = flags;
            if ((flags & 0x10000) != 0) {
                long token = Binder.clearCallingIdentity();
                try {
                    MediaSessionRecord.this.mService.setGlobalPrioritySession(MediaSessionRecord.this);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
            MediaSessionRecord.this.mHandler.post(7);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMediaButtonReceiver(PendingIntent pi) throws RemoteException {
            MediaSessionRecord.this.mMediaButtonReceiver = pi;
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.mService.onMediaButtonReceiverChanged(MediaSessionRecord.this);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void setLaunchPendingIntent(PendingIntent pi) throws RemoteException {
            MediaSessionRecord.this.mLaunchIntent = pi;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMetadata(MediaMetadata metadata, long duration, String metadataDescription) throws RemoteException {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                MediaMetadata temp;
                MediaMetadata mediaMetadata = temp = metadata == null ? null : new MediaMetadata.Builder(metadata).build();
                if (temp != null) {
                    temp.size();
                }
                MediaSessionRecord.this.mMetadata = temp;
                MediaSessionRecord.this.mDuration = duration;
                MediaSessionRecord.this.mMetadataDescription = metadataDescription;
            }
            MediaSessionRecord.this.mHandler.post(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPlaybackState(PlaybackState state) throws RemoteException {
            int oldState = MediaSessionRecord.this.mPlaybackState == null ? 0 : MediaSessionRecord.this.mPlaybackState.getState();
            int newState = state == null ? 0 : state.getState();
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                MediaSessionRecord.this.mPlaybackState = state;
            }
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionRecord.this.mService.onSessionPlaystateChanged(MediaSessionRecord.this, oldState, newState);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            MediaSessionRecord.this.mHandler.post(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setQueue(ParceledListSlice queue) throws RemoteException {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                MediaSessionRecord.this.mQueue = queue == null ? null : queue.getList();
            }
            MediaSessionRecord.this.mHandler.post(3);
        }

        @Override
        public void setQueueTitle(CharSequence title) throws RemoteException {
            MediaSessionRecord.this.mQueueTitle = title;
            MediaSessionRecord.this.mHandler.post(4);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExtras(Bundle extras) throws RemoteException {
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                MediaSessionRecord.this.mExtras = extras == null ? null : new Bundle(extras);
            }
            MediaSessionRecord.this.mHandler.post(5);
        }

        @Override
        public void setRatingType(int type) throws RemoteException {
            MediaSessionRecord.this.mRatingType = type;
        }

        @Override
        public void setCurrentVolume(int volume) throws RemoteException {
            MediaSessionRecord.this.mCurrentVolume = volume;
            MediaSessionRecord.this.mHandler.post(8);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPlaybackToLocal(AudioAttributes attributes) throws RemoteException {
            boolean typeChanged;
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                typeChanged = MediaSessionRecord.this.mVolumeType == 2;
                MediaSessionRecord.this.mVolumeType = 1;
                if (attributes != null) {
                    MediaSessionRecord.this.mAudioAttrs = attributes;
                } else {
                    Log.e(MediaSessionRecord.TAG, "Received null audio attributes, using existing attributes");
                }
            }
            if (typeChanged) {
                long token = Binder.clearCallingIdentity();
                try {
                    MediaSessionRecord.this.mService.onSessionPlaybackTypeChanged(MediaSessionRecord.this);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
                MediaSessionRecord.this.mHandler.post(8);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setPlaybackToRemote(int control, int max) throws RemoteException {
            boolean typeChanged;
            Object object = MediaSessionRecord.this.mLock;
            synchronized (object) {
                typeChanged = MediaSessionRecord.this.mVolumeType == 1;
                MediaSessionRecord.this.mVolumeType = 2;
                MediaSessionRecord.this.mVolumeControlType = control;
                MediaSessionRecord.this.mMaxVolume = max;
            }
            if (typeChanged) {
                long token = Binder.clearCallingIdentity();
                try {
                    MediaSessionRecord.this.mService.onSessionPlaybackTypeChanged(MediaSessionRecord.this);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
                MediaSessionRecord.this.mHandler.post(8);
            }
        }
    }
}

