/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.app.ActivityManager;
import android.app.INotificationManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.media.AudioManagerInternal;
import android.media.AudioSystem;
import android.media.IAudioService;
import android.media.IRemoteVolumeController;
import android.media.MediaController2;
import android.media.Session2CommandGroup;
import android.media.Session2Token;
import android.media.session.IActiveSessionsListener;
import android.media.session.ICallback;
import android.media.session.IOnMediaKeyListener;
import android.media.session.IOnVolumeKeyLongPressListener;
import android.media.session.ISession;
import android.media.session.ISession2TokensListener;
import android.media.session.ISessionCallback;
import android.media.session.ISessionManager;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.KeyEvent;
import android.view.ViewConfiguration;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.DumpUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import com.android.server.media.AudioPlayerStateMonitor;
import com.android.server.media.MediaSessionRecord;
import com.android.server.media.MediaSessionStack;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MediaSessionService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "MediaSessionService";
    static final boolean DEBUG = Log.isLoggable("MediaSessionService", 3);
    private static final boolean DEBUG_KEY_EVENT = true;
    private static final int WAKELOCK_TIMEOUT = 5000;
    private static final int MEDIA_KEY_LISTENER_TIMEOUT = 1000;
    private final Context mContext;
    private final SessionManagerImpl mSessionManagerImpl;
    private final MessageHandler mHandler = new MessageHandler();
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private final int mLongPressTimeout;
    private final INotificationManager mNotificationManager;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private final SparseIntArray mFullUserIds = new SparseIntArray();
    @GuardedBy(value={"mLock"})
    private final SparseArray<FullUserRecord> mUserRecords = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final ArrayList<SessionsListenerRecord> mSessionsListeners = new ArrayList();
    @GuardedBy(value={"mLock"})
    private final SparseArray<List<Session2Token>> mSession2TokensPerUser = new SparseArray();
    @GuardedBy(value={"mLock"})
    private final List<Session2TokensListenerRecord> mSession2TokensListenerRecords = new ArrayList<Session2TokensListenerRecord>();
    private KeyguardManager mKeyguardManager;
    private IAudioService mAudioService;
    private AudioManagerInternal mAudioManagerInternal;
    private ActivityManager mActivityManager;
    private ContentResolver mContentResolver;
    private SettingsObserver mSettingsObserver;
    private boolean mHasFeatureLeanback;
    private FullUserRecord mCurrentFullUserRecord;
    private MediaSessionRecord mGlobalPrioritySession;
    private AudioPlayerStateMonitor mAudioPlayerStateMonitor;
    @GuardedBy(value={"mLock"})
    final RemoteCallbackList<IRemoteVolumeController> mRemoteVolumeControllers = new RemoteCallbackList();

    public MediaSessionService(Context context) {
        super(context);
        this.mContext = context;
        this.mSessionManagerImpl = new SessionManagerImpl();
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
        this.mLongPressTimeout = ViewConfiguration.getLongPressTimeout();
        this.mNotificationManager = INotificationManager.Stub.asInterface(ServiceManager.getService("notification"));
    }

    @Override
    public void onStart() {
        this.publishBinderService("media_session", this.mSessionManagerImpl);
        Watchdog.getInstance().addMonitor(this);
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mAudioService = this.getAudioService();
        this.mAudioManagerInternal = LocalServices.getService(AudioManagerInternal.class);
        this.mActivityManager = (ActivityManager)this.mContext.getSystemService("activity");
        this.mAudioPlayerStateMonitor = AudioPlayerStateMonitor.getInstance(this.mContext);
        this.mAudioPlayerStateMonitor.registerListener((config, isRemoved) -> {
            if (config.getPlayerType() == 3) {
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                FullUserRecord user = this.getFullUserRecordLocked(UserHandle.getUserId(config.getClientUid()));
                if (user != null) {
                    user.mPriorityStack.updateMediaButtonSessionIfNeeded();
                }
            }
        }, null);
        this.mContentResolver = this.mContext.getContentResolver();
        this.mSettingsObserver = new SettingsObserver();
        this.mSettingsObserver.observe();
        this.mHasFeatureLeanback = this.mContext.getPackageManager().hasSystemFeature("android.software.leanback");
        this.updateUser();
    }

    private IAudioService getAudioService() {
        IBinder b = ServiceManager.getService("audio");
        return IAudioService.Stub.asInterface(b);
    }

    private boolean isGlobalPriorityActiveLocked() {
        return this.mGlobalPrioritySession != null && this.mGlobalPrioritySession.isActive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSession(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null) {
                Log.w(TAG, "Unknown session updated. Ignoring.");
                return;
            }
            if ((record.getFlags() & 0x10000L) != 0L) {
                Log.d(TAG, "Global priority session is updated, active=" + record.isActive());
                user.pushAddressedPlayerChangedLocked();
            } else {
                if (!user.mPriorityStack.contains(record)) {
                    Log.w(TAG, "Unknown session updated. Ignoring.");
                    return;
                }
                user.mPriorityStack.onSessionStateChange(record);
            }
            this.mHandler.postSessionsChanged(record.getUserId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGlobalPrioritySession(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (this.mGlobalPrioritySession != record) {
                Log.d(TAG, "Global priority session is changed from " + this.mGlobalPrioritySession + " to " + record);
                this.mGlobalPrioritySession = record;
                if (user != null && user.mPriorityStack.contains(record)) {
                    user.mPriorityStack.removeSession(record);
                }
            }
        }
    }

    private List<MediaSessionRecord> getActiveSessionsLocked(int userId) {
        ArrayList<MediaSessionRecord> records = new ArrayList<MediaSessionRecord>();
        if (userId == -1) {
            int size = this.mUserRecords.size();
            for (int i = 0; i < size; ++i) {
                records.addAll(this.mUserRecords.valueAt(i).mPriorityStack.getActiveSessions(userId));
            }
        } else {
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user == null) {
                Log.w(TAG, "getSessions failed. Unknown user " + userId);
                return records;
            }
            records.addAll(user.mPriorityStack.getActiveSessions(userId));
        }
        if (this.isGlobalPriorityActiveLocked() && (userId == -1 || userId == this.mGlobalPrioritySession.getUserId())) {
            records.add(0, this.mGlobalPrioritySession);
        }
        return records;
    }

    List<Session2Token> getSession2TokensLocked(int userId) {
        ArrayList<Session2Token> list = new ArrayList<Session2Token>();
        if (userId == -1) {
            for (int i = 0; i < this.mSession2TokensPerUser.size(); ++i) {
                list.addAll((Collection<Session2Token>)this.mSession2TokensPerUser.valueAt(i));
            }
        } else {
            list.addAll((Collection)this.mSession2TokensPerUser.get(userId));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyRemoteVolumeChanged(int flags, MediaSessionRecord session) {
        if (!session.isActive()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mRemoteVolumeControllers.beginBroadcast();
            MediaSession.Token token = session.getSessionToken();
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IRemoteVolumeController cb = this.mRemoteVolumeControllers.getBroadcastItem(i);
                    cb.remoteVolumeChanged(token, flags);
                    continue;
                }
                catch (Exception e) {
                    Log.w(TAG, "Error sending volume change.", e);
                }
            }
            this.mRemoteVolumeControllers.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionPlaystateChanged(MediaSessionRecord record, int oldState, int newState) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null || !user.mPriorityStack.contains(record)) {
                Log.d(TAG, "Unknown session changed playback state. Ignoring.");
                return;
            }
            user.mPriorityStack.onPlaystateChanged(record, oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSessionPlaybackTypeChanged(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            if (user == null || !user.mPriorityStack.contains(record)) {
                Log.d(TAG, "Unknown session changed playback type. Ignoring.");
                return;
            }
            this.pushRemoteVolumeUpdateLocked(record.getUserId());
        }
    }

    @Override
    public void onStartUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStartUser: " + userId);
        }
        this.updateUser();
    }

    @Override
    public void onSwitchUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onSwitchUser: " + userId);
        }
        this.updateUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStopUser(int userId) {
        if (DEBUG) {
            Log.d(TAG, "onStopUser: " + userId);
        }
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user != null) {
                if (user.mFullUserId == userId) {
                    user.destroySessionsForUserLocked(-1);
                    this.mUserRecords.remove(userId);
                } else {
                    user.destroySessionsForUserLocked(userId);
                }
            }
            this.mSession2TokensPerUser.remove(userId);
            this.updateUser();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    protected void enforcePhoneStatePermission(int pid, int uid) {
        if (this.mContext.checkPermission("android.permission.MODIFY_PHONE_STATE", pid, uid) != 0) {
            throw new SecurityException("Must hold the MODIFY_PHONE_STATE permission.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionDied(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroySession(MediaSessionRecord session) {
        Object object = this.mLock;
        synchronized (object) {
            this.destroySessionLocked(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUser() {
        Object object = this.mLock;
        synchronized (object) {
            UserManager manager = (UserManager)this.mContext.getSystemService("user");
            this.mFullUserIds.clear();
            List<UserInfo> allUsers = manager.getUsers();
            if (allUsers != null) {
                for (UserInfo userInfo : allUsers) {
                    if (userInfo.isManagedProfile()) {
                        this.mFullUserIds.put(userInfo.id, userInfo.profileGroupId);
                    } else {
                        this.mFullUserIds.put(userInfo.id, userInfo.id);
                        if (this.mUserRecords.get(userInfo.id) == null) {
                            this.mUserRecords.put(userInfo.id, new FullUserRecord(userInfo.id));
                        }
                    }
                    if (this.mSession2TokensPerUser.get(userInfo.id) != null) continue;
                    this.mSession2TokensPerUser.put(userInfo.id, new ArrayList());
                }
            }
            int currentFullUserId = ActivityManager.getCurrentUser();
            this.mCurrentFullUserRecord = this.mUserRecords.get(currentFullUserId);
            if (this.mCurrentFullUserRecord == null) {
                Log.w(TAG, "Cannot find FullUserInfo for the current user " + currentFullUserId);
                this.mCurrentFullUserRecord = new FullUserRecord(currentFullUserId);
                this.mUserRecords.put(currentFullUserId, this.mCurrentFullUserRecord);
                if (this.mSession2TokensPerUser.get(currentFullUserId) == null) {
                    this.mSession2TokensPerUser.put(currentFullUserId, new ArrayList());
                }
            }
            this.mFullUserIds.put(currentFullUserId, currentFullUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateActiveSessionListeners() {
        Object object = this.mLock;
        synchronized (object) {
            for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord listener = this.mSessionsListeners.get(i);
                try {
                    this.enforceMediaPermissions(listener.componentName, listener.pid, listener.uid, listener.userId);
                    continue;
                }
                catch (SecurityException e) {
                    Log.i(TAG, "ActiveSessionsListener " + listener.componentName + " is no longer authorized. Disconnecting.");
                    this.mSessionsListeners.remove(i);
                    try {
                        listener.listener.onActiveSessionsChanged(new ArrayList<MediaSession.Token>());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void destroySessionLocked(MediaSessionRecord session) {
        if (DEBUG) {
            Log.d(TAG, "Destroying " + session);
        }
        FullUserRecord user = this.getFullUserRecordLocked(session.getUserId());
        if (this.mGlobalPrioritySession == session) {
            this.mGlobalPrioritySession = null;
            if (session.isActive() && user != null) {
                user.pushAddressedPlayerChangedLocked();
            }
        } else if (user != null) {
            user.mPriorityStack.removeSession(session);
        }
        try {
            session.getCallback().asBinder().unlinkToDeath(session, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        session.onDestroy();
        this.mHandler.postSessionsChanged(session.getUserId());
    }

    private void enforcePackageName(String packageName, int uid) {
        if (TextUtils.isEmpty(packageName)) {
            throw new IllegalArgumentException("packageName may not be empty");
        }
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        int packageCount = packages.length;
        for (int i = 0; i < packageCount; ++i) {
            if (!packageName.equals(packages[i])) continue;
            return;
        }
        throw new IllegalArgumentException("packageName is not owned by the calling process");
    }

    private void enforceMediaPermissions(ComponentName compName, int pid, int uid, int resolvedUserId) {
        if (this.hasStatusBarServicePermission(pid, uid)) {
            return;
        }
        if (this.mContext.checkPermission("android.permission.MEDIA_CONTENT_CONTROL", pid, uid) != 0 && !this.isEnabledNotificationListener(compName, UserHandle.getUserId(uid), resolvedUserId)) {
            throw new SecurityException("Missing permission to control media.");
        }
    }

    private boolean hasStatusBarServicePermission(int pid, int uid) {
        return this.mContext.checkPermission("android.permission.STATUS_BAR_SERVICE", pid, uid) == 0;
    }

    private void enforceStatusBarServicePermission(String action, int pid, int uid) {
        if (!this.hasStatusBarServicePermission(pid, uid)) {
            throw new SecurityException("Only System UI and Settings may " + action);
        }
    }

    private boolean isEnabledNotificationListener(ComponentName compName, int userId, int forUserId) {
        if (userId != forUserId) {
            return false;
        }
        if (DEBUG) {
            Log.d(TAG, "Checking if enabled notification listener " + compName);
        }
        if (compName != null) {
            try {
                return this.mNotificationManager.isNotificationListenerAccessGrantedForUser(compName, userId);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Dead NotificationManager in isEnabledNotificationListener", e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaSessionRecord createSessionInternal(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag, Bundle sessionInfo) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            return this.createSessionLocked(callerPid, callerUid, userId, callerPackageName, cb, tag, sessionInfo);
        }
    }

    private MediaSessionRecord createSessionLocked(int callerPid, int callerUid, int userId, String callerPackageName, ISessionCallback cb, String tag, Bundle sessionInfo) {
        FullUserRecord user = this.getFullUserRecordLocked(userId);
        if (user == null) {
            Log.w(TAG, "Request from invalid user: " + userId + ", pkg=" + callerPackageName);
            throw new RuntimeException("Session request from invalid user.");
        }
        MediaSessionRecord session = new MediaSessionRecord(callerPid, callerUid, userId, callerPackageName, cb, tag, sessionInfo, this, this.mHandler.getLooper());
        try {
            cb.asBinder().linkToDeath(session, 0);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Media Session owner died prematurely.", e);
        }
        user.mPriorityStack.addSession(session);
        this.mHandler.postSessionsChanged(userId);
        if (DEBUG) {
            Log.d(TAG, "Created session for " + callerPackageName + " with tag " + tag);
        }
        return session;
    }

    private int findIndexOfSessionsListenerLocked(IActiveSessionsListener listener) {
        for (int i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
            if (this.mSessionsListeners.get((int)i).listener.asBinder() != listener.asBinder()) continue;
            return i;
        }
        return -1;
    }

    private int findIndexOfSession2TokensListenerLocked(ISession2TokensListener listener) {
        for (int i = this.mSession2TokensListenerRecords.size() - 1; i >= 0; --i) {
            if (this.mSession2TokensListenerRecords.get((int)i).listener.asBinder() != listener.asBinder()) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSessionsChanged(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int i;
            FullUserRecord user = this.getFullUserRecordLocked(userId);
            if (user == null) {
                Log.w(TAG, "pushSessionsChanged failed. No user with id=" + userId);
                return;
            }
            List<MediaSessionRecord> records = this.getActiveSessionsLocked(userId);
            int size = records.size();
            ArrayList<MediaSession.Token> tokens = new ArrayList<MediaSession.Token>();
            for (i = 0; i < size; ++i) {
                tokens.add(records.get(i).getSessionToken());
            }
            this.pushRemoteVolumeUpdateLocked(userId);
            for (i = this.mSessionsListeners.size() - 1; i >= 0; --i) {
                SessionsListenerRecord record = this.mSessionsListeners.get(i);
                if (record.userId != -1 && record.userId != userId) continue;
                try {
                    record.listener.onActiveSessionsChanged(tokens);
                    continue;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Dead ActiveSessionsListener in pushSessionsChanged, removing", e);
                    this.mSessionsListeners.remove(i);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushRemoteVolumeUpdateLocked(int userId) {
        FullUserRecord user = this.getFullUserRecordLocked(userId);
        if (user == null) {
            Log.w(TAG, "pushRemoteVolumeUpdateLocked failed. No user with id=" + userId);
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            int size = this.mRemoteVolumeControllers.beginBroadcast();
            MediaSessionRecord record = user.mPriorityStack.getDefaultRemoteSession(userId);
            MediaSession.Token token = record == null ? null : record.getSessionToken();
            for (int i = size - 1; i >= 0; --i) {
                try {
                    IRemoteVolumeController cb = this.mRemoteVolumeControllers.getBroadcastItem(i);
                    cb.updateRemoteController(token);
                    continue;
                }
                catch (Exception e) {
                    Log.w(TAG, "Error sending default remote volume.", e);
                }
            }
            this.mRemoteVolumeControllers.finishBroadcast();
        }
    }

    void pushSession2TokensChangedLocked(int userId) {
        List<Session2Token> allSession2Tokens = this.getSession2TokensLocked(-1);
        List<Session2Token> session2Tokens = this.getSession2TokensLocked(userId);
        for (int i = this.mSession2TokensListenerRecords.size() - 1; i >= 0; --i) {
            Session2TokensListenerRecord listenerRecord = this.mSession2TokensListenerRecords.get(i);
            try {
                if (listenerRecord.userId == -1) {
                    listenerRecord.listener.onSession2TokensChanged(allSession2Tokens);
                    continue;
                }
                if (listenerRecord.userId != userId) continue;
                listenerRecord.listener.onSession2TokensChanged(session2Tokens);
                continue;
            }
            catch (RemoteException e) {
                Log.w(TAG, "Failed to notify Session2Token change. Removing listener.", e);
                this.mSession2TokensListenerRecords.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMediaButtonReceiverChanged(MediaSessionRecord record) {
        Object object = this.mLock;
        synchronized (object) {
            FullUserRecord user = this.getFullUserRecordLocked(record.getUserId());
            MediaSessionRecord mediaButtonSession = user.mPriorityStack.getMediaButtonSession();
            if (record == mediaButtonSession) {
                user.rememberMediaButtonReceiverLocked(mediaButtonSession);
            }
        }
    }

    private String getCallingPackageName(int uid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        if (packages != null && packages.length > 0) {
            return packages[0];
        }
        return "";
    }

    private void dispatchVolumeKeyLongPressLocked(KeyEvent keyEvent) {
        if (this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener == null) {
            return;
        }
        try {
            this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener.onVolumeKeyLongPress(keyEvent);
        }
        catch (RemoteException e) {
            Log.w(TAG, "Failed to send " + keyEvent + " to volume key long-press listener");
        }
    }

    private FullUserRecord getFullUserRecordLocked(int userId) {
        int fullUserId = this.mFullUserIds.get(userId, -1);
        if (fullUserId < 0) {
            return null;
        }
        return this.mUserRecords.get(fullUserId);
    }

    private MediaSessionRecord getMediaSessionRecordLocked(MediaSession.Token sessionToken) {
        FullUserRecord user = this.getFullUserRecordLocked(UserHandle.getUserId(sessionToken.getUid()));
        if (user != null) {
            return user.mPriorityStack.getMediaSessionRecord(sessionToken);
        }
        return null;
    }

    private class Controller2Callback
    extends MediaController2.ControllerCallback {
        private final Session2Token mToken;

        Controller2Callback(Session2Token token) {
            this.mToken = token;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnected(MediaController2 controller, Session2CommandGroup allowedCommands) {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int userId = UserHandle.getUserId(this.mToken.getUid());
                ((List)MediaSessionService.this.mSession2TokensPerUser.get(userId)).add(this.mToken);
                MediaSessionService.this.pushSession2TokensChangedLocked(userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisconnected(MediaController2 controller) {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int userId = UserHandle.getUserId(this.mToken.getUid());
                ((List)MediaSessionService.this.mSession2TokensPerUser.get(userId)).remove(this.mToken);
                MediaSessionService.this.pushSession2TokensChangedLocked(userId);
            }
        }
    }

    final class MessageHandler
    extends Handler {
        private static final int MSG_SESSIONS_CHANGED = 1;
        private static final int MSG_VOLUME_INITIAL_DOWN = 2;
        private final SparseArray<Integer> mIntegerCache = new SparseArray();

        MessageHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaSessionService.this.pushSessionsChanged((Integer)msg.obj);
                    break;
                }
                case 2: {
                    Object object = MediaSessionService.this.mLock;
                    synchronized (object) {
                        FullUserRecord user = (FullUserRecord)MediaSessionService.this.mUserRecords.get(msg.arg1);
                        if (user != null && user.mInitialDownVolumeKeyEvent != null) {
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(user.mInitialDownVolumeKeyEvent);
                            user.mInitialDownVolumeKeyEvent = null;
                        }
                        break;
                    }
                }
            }
        }

        public void postSessionsChanged(int userId) {
            Integer userIdInteger = this.mIntegerCache.get(userId);
            if (userIdInteger == null) {
                userIdInteger = userId;
                this.mIntegerCache.put(userId, userIdInteger);
            }
            this.removeMessages(1, userIdInteger);
            this.obtainMessage(1, userIdInteger).sendToTarget();
        }
    }

    class SessionManagerImpl
    extends ISessionManager.Stub {
        private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
        private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
        private boolean mVoiceButtonDown = false;
        private boolean mVoiceButtonHandled = false;
        private KeyEventWakeLockReceiver mKeyEventReceiver = new KeyEventWakeLockReceiver(MediaSessionService.access$1300(MediaSessionService.this));
        BroadcastReceiver mKeyEventDone = new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent == null) {
                    return;
                }
                Bundle extras = intent.getExtras();
                if (extras == null) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (extras.containsKey(SessionManagerImpl.EXTRA_WAKELOCK_ACQUIRED) && MediaSessionService.this.mMediaEventWakeLock.isHeld()) {
                        MediaSessionService.this.mMediaEventWakeLock.release();
                    }
                }
            }
        };

        SessionManagerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ISession createSession(String packageName, ISessionCallback cb, String tag, Bundle sessionInfo, int userId) throws RemoteException {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                MediaSessionService.this.enforcePackageName(packageName, uid);
                int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, false, true, "createSession", packageName);
                if (cb == null) {
                    throw new IllegalArgumentException("Controller callback cannot be null");
                }
                ISession iSession = MediaSessionService.this.createSessionInternal(pid, uid, resolvedUserId, packageName, cb, tag, sessionInfo).getSessionBinder();
                return iSession;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifySession2Created(Session2Token sessionToken) throws RemoteException {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                if (DEBUG) {
                    Log.d(MediaSessionService.TAG, "Session2 is created " + sessionToken);
                }
                if (uid != sessionToken.getUid()) {
                    throw new SecurityException("Unexpected Session2Token's UID, expected=" + uid + " but actually=" + sessionToken.getUid());
                }
                Controller2Callback callback = new Controller2Callback(sessionToken);
                MediaController2 mediaController2 = new MediaController2.Builder(MediaSessionService.this.mContext, sessionToken).setControllerCallback(new HandlerExecutor(MediaSessionService.this.mHandler), callback).build();
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<MediaSession.Token> getSessions(ComponentName componentName, int userId) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                ArrayList<MediaSession.Token> tokens = new ArrayList<MediaSession.Token>();
                ArrayList<MediaSession.Token> arrayList = MediaSessionService.this.mLock;
                synchronized (arrayList) {
                    List records = MediaSessionService.this.getActiveSessionsLocked(resolvedUserId);
                    for (MediaSessionRecord record : records) {
                        tokens.add(record.getSessionToken());
                    }
                }
                arrayList = tokens;
                return arrayList;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice getSession2Tokens(int userId) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                List<Session2Token> result;
                int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, true, true, "getSession2Tokens", null);
                ParceledListSlice<Session2Token> parceledListSlice = MediaSessionService.this.mLock;
                synchronized (parceledListSlice) {
                    result = MediaSessionService.this.getSession2TokensLocked(resolvedUserId);
                }
                parceledListSlice = new ParceledListSlice<Session2Token>(result);
                return parceledListSlice;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void addSessionsListener(IActiveSessionsListener listener, ComponentName componentName, int userId) throws RemoteException {
            int resolvedUserId;
            long token;
            int uid;
            int pid;
            block10: {
                pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                resolvedUserId = this.verifySessionsRequest(componentName, userId, pid, uid);
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index == -1) break block10;
                Log.w(MediaSessionService.TAG, "ActiveSessionsListener is already added, ignoring");
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            SessionsListenerRecord record = new SessionsListenerRecord(listener, componentName, resolvedUserId, pid, uid);
            try {
                listener.asBinder().linkToDeath(record, 0);
            }
            catch (RemoteException e) {
                Log.e(MediaSessionService.TAG, "ActiveSessionsListener is dead, ignoring it", e);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                MediaSessionService.this.mSessionsListeners.add(record);
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSessionsListener(IActiveSessionsListener listener) throws RemoteException {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                int index = MediaSessionService.this.findIndexOfSessionsListenerLocked(listener);
                if (index != -1) {
                    SessionsListenerRecord record = (SessionsListenerRecord)MediaSessionService.this.mSessionsListeners.remove(index);
                    try {
                        record.listener.asBinder().unlinkToDeath(record, 0);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addSession2TokensListener(ISession2TokensListener listener, int userId) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, true, true, "addSession2TokensListener", null);
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    block8: {
                        int index = MediaSessionService.this.findIndexOfSession2TokensListenerLocked(listener);
                        if (index < 0) break block8;
                        Log.w(MediaSessionService.TAG, "addSession2TokensListener is already added, ignoring");
                        return;
                    }
                    MediaSessionService.this.mSession2TokensListenerRecords.add(new Session2TokensListenerRecord(listener, resolvedUserId));
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeSession2TokensListener(ISession2TokensListener listener) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    int index = MediaSessionService.this.findIndexOfSession2TokensListenerLocked(listener);
                    if (index >= 0) {
                        Session2TokensListenerRecord listenerRecord = (Session2TokensListenerRecord)MediaSessionService.this.mSession2TokensListenerRecords.remove(index);
                        try {
                            listenerRecord.listener.asBinder().unlinkToDeath(listenerRecord, 0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void dispatchMediaKeyEvent(String packageName, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            if (keyEvent == null || !KeyEvent.isMediaSessionKey(keyEvent.getKeyCode())) {
                Log.w("MediaSessionService", "Attempted to dispatch null or non-media key event.");
                return;
            }
            pid = Binder.getCallingPid();
            uid = Binder.getCallingUid();
            token = Binder.clearCallingIdentity();
            if (MediaSessionService.DEBUG) {
                Log.d("MediaSessionService", "dispatchMediaKeyEvent, pkg=" + packageName + " pid=" + pid + ", uid=" + uid + ", asSystem=" + asSystemService + ", event=" + keyEvent);
            }
            if (!this.isUserSetupComplete()) {
                Slog.i("MediaSessionService", "Not dispatching media key event because user setup is in progress.");
            }
            ** GOTO lbl-1000
            {
                catch (Throwable var13_11) {
                    throw var13_11;
                }
                Binder.restoreCallingIdentity(token);
                return;
lbl-1000:
                // 1 sources

                {
                    var9_8 = MediaSessionService.access$1200(MediaSessionService.this);
                    synchronized (var9_8) {
                        isGlobalPriorityActive = MediaSessionService.access$1500(MediaSessionService.this);
                        if (!isGlobalPriorityActive || uid == 1000) ** break block17
                        Slog.i("MediaSessionService", "Only the system can dispatch media key event to the global priority session.");
                    }
                }
                Binder.restoreCallingIdentity(token);
                return;
                {
                    if (!isGlobalPriorityActive && FullUserRecord.access$2600(MediaSessionService.access$1400(MediaSessionService.this)) != null) {
                        Log.d("MediaSessionService", "Send " + keyEvent + " to the media key listener");
                        try {
                            FullUserRecord.access$2600(MediaSessionService.access$1400(MediaSessionService.this)).onMediaKey(keyEvent, new MediaKeyListenerResultReceiver(packageName, pid, uid, asSystemService, keyEvent, needWakeLock));
                        }
                        catch (RemoteException e) {}
                        ** try [egrp 5[TRYBLOCK] [9 : 279->372)] { 
lbl38:
                        // 1 sources

                        Log.w("MediaSessionService", "Failed to send " + keyEvent + " to the media key listener");
                    }
                    if (!isGlobalPriorityActive && this.isVoiceKey(keyEvent.getKeyCode())) {
                        this.handleVoiceKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                    } else {
                        this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                    }
                    return;
lbl45:
                    // 1 sources

                    finally {
                        Binder.restoreCallingIdentity(token);
                    }
                }
            }
            Binder.restoreCallingIdentity(token);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispatchMediaKeyEventToSessionAsSystemService(String packageName, MediaSession.Token sessionToken, KeyEvent keyEvent) {
            MediaSessionRecord record;
            long token;
            int uid;
            int pid;
            block7: {
                boolean bl;
                pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                try {
                    Object object = MediaSessionService.this.mLock;
                    // MONITORENTER : object
                    record = MediaSessionService.this.getMediaSessionRecordLocked(sessionToken);
                    if (record != null) break block7;
                    Log.w(MediaSessionService.TAG, "Failed to find session to dispatch key event.");
                    bl = false;
                    // MONITOREXIT : object
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(token);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(token);
                return bl;
            }
            if (DEBUG) {
                Log.d(MediaSessionService.TAG, "dispatchMediaKeyEventToSessionAsSystemService, pkg=" + packageName + ", pid=" + pid + ", uid=" + uid + ", sessionToken=" + sessionToken + ", event=" + keyEvent + ", session=" + record);
            }
            boolean bl = record.sendMediaButton(packageName, pid, uid, true, keyEvent, 0, null);
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(token);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setCallback(ICallback callback) {
            FullUserRecord user;
            long token;
            int uid;
            block12: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (!UserHandle.isSameApp(uid, 1002)) {
                    throw new SecurityException("Only Bluetooth service processes can set Callback");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block12;
                Log.w(MediaSessionService.TAG, "Only the full user can set the callback, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            user.mCallback = callback;
            Log.d(MediaSessionService.TAG, "The callback " + user.mCallback + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
            if (user.mCallback == null) {
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                try {
                    user.mCallback.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void binderDied() {
                            Object object = MediaSessionService.this.mLock;
                            synchronized (object) {
                                user.mCallback = null;
                            }
                        }
                    }, 0);
                    user.pushAddressedPlayerChangedLocked();
                    return;
                }
                catch (RemoteException e) {
                    Log.w(MediaSessionService.TAG, "Failed to set callback", e);
                    user.mCallback = null;
                }
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setOnVolumeKeyLongPressListener(IOnVolumeKeyLongPressListener listener) {
            FullUserRecord user;
            long token;
            int uid;
            block13: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (MediaSessionService.this.mContext.checkPermission("android.permission.SET_VOLUME_KEY_LONG_PRESS_LISTENER", pid, uid) != 0) {
                    throw new SecurityException("Must hold the SET_VOLUME_KEY_LONG_PRESS_LISTENER permission.");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block13;
                Log.w(MediaSessionService.TAG, "Only the full user can set the volume key long-press listener, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            if (user.mOnVolumeKeyLongPressListener != null && user.mOnVolumeKeyLongPressListenerUid != uid) {
                Log.w(MediaSessionService.TAG, "The volume key long-press listener cannot be reset by another app , mOnVolumeKeyLongPressListener=" + user.mOnVolumeKeyLongPressListenerUid + ", uid=" + uid);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                user.mOnVolumeKeyLongPressListener = listener;
                user.mOnVolumeKeyLongPressListenerUid = uid;
                Log.d(MediaSessionService.TAG, "The volume key long-press listener " + listener + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
                if (user.mOnVolumeKeyLongPressListener != null) {
                    try {
                        user.mOnVolumeKeyLongPressListener.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void binderDied() {
                                Object object = MediaSessionService.this.mLock;
                                synchronized (object) {
                                    user.mOnVolumeKeyLongPressListener = null;
                                }
                            }
                        }, 0);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to set death recipient " + user.mOnVolumeKeyLongPressListener);
                        user.mOnVolumeKeyLongPressListener = null;
                    }
                }
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void setOnMediaKeyListener(IOnMediaKeyListener listener) {
            FullUserRecord user;
            long token;
            int uid;
            block13: {
                int pid = Binder.getCallingPid();
                uid = Binder.getCallingUid();
                token = Binder.clearCallingIdentity();
                if (MediaSessionService.this.mContext.checkPermission("android.permission.SET_MEDIA_KEY_LISTENER", pid, uid) != 0) {
                    throw new SecurityException("Must hold the SET_MEDIA_KEY_LISTENER permission.");
                }
                Object object = MediaSessionService.this.mLock;
                // MONITORENTER : object
                int userId = UserHandle.getUserId(uid);
                user = MediaSessionService.this.getFullUserRecordLocked(userId);
                if (user != null && user.mFullUserId == userId) break block13;
                Log.w(MediaSessionService.TAG, "Only the full user can set the media key listener, userId=" + userId);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            if (user.mOnMediaKeyListener != null && user.mOnMediaKeyListenerUid != uid) {
                Log.w(MediaSessionService.TAG, "The media key listener cannot be reset by another app. , mOnMediaKeyListenerUid=" + user.mOnMediaKeyListenerUid + ", uid=" + uid);
                // MONITOREXIT : object
                Binder.restoreCallingIdentity(token);
                return;
            }
            try {
                user.mOnMediaKeyListener = listener;
                user.mOnMediaKeyListenerUid = uid;
                Log.d(MediaSessionService.TAG, "The media key listener " + user.mOnMediaKeyListener + " is set by " + MediaSessionService.this.getCallingPackageName(uid));
                if (user.mOnMediaKeyListener != null) {
                    try {
                        user.mOnMediaKeyListener.asBinder().linkToDeath(new IBinder.DeathRecipient(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void binderDied() {
                                Object object = MediaSessionService.this.mLock;
                                synchronized (object) {
                                    user.mOnMediaKeyListener = null;
                                }
                            }
                        }, 0);
                        return;
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to set death recipient " + user.mOnMediaKeyListener);
                        user.mOnMediaKeyListener = null;
                    }
                }
                // MONITOREXIT : object
                return;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchVolumeKeyEvent(String packageName, String opPackageName, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
            if (keyEvent == null || keyEvent.getKeyCode() != 24 && keyEvent.getKeyCode() != 25 && keyEvent.getKeyCode() != 164) {
                Log.w(MediaSessionService.TAG, "Attempted to dispatch null or non-volume key event.");
                return;
            }
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            Log.d(MediaSessionService.TAG, "dispatchVolumeKeyEvent, pkg=" + packageName + ", opPkg=" + opPackageName + ", pid=" + pid + ", uid=" + uid + ", asSystem=" + asSystemService + ", event=" + keyEvent + ", stream=" + stream + ", musicOnly=" + musicOnly);
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (MediaSessionService.this.isGlobalPriorityActiveLocked() || MediaSessionService.this.mCurrentFullUserRecord.mOnVolumeKeyLongPressListener == null) {
                        this.dispatchVolumeKeyEventLocked(packageName, opPackageName, pid, uid, asSystemService, keyEvent, stream, musicOnly);
                    } else if (keyEvent.getAction() == 0) {
                        if (keyEvent.getRepeatCount() == 0) {
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent = KeyEvent.obtain(keyEvent);
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeStream = stream;
                            MediaSessionService.this.mCurrentFullUserRecord.mInitialDownMusicOnly = musicOnly;
                            MediaSessionService.this.mHandler.sendMessageDelayed(MediaSessionService.this.mHandler.obtainMessage(2, MediaSessionService.this.mCurrentFullUserRecord.mFullUserId, 0), MediaSessionService.this.mLongPressTimeout);
                        }
                        if (keyEvent.getRepeatCount() > 0 || keyEvent.isLongPress()) {
                            MediaSessionService.this.mHandler.removeMessages(2);
                            if (MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent != null) {
                                MediaSessionService.this.dispatchVolumeKeyLongPressLocked(MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent);
                                MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent = null;
                            }
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(keyEvent);
                        }
                    } else {
                        MediaSessionService.this.mHandler.removeMessages(2);
                        if (MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent != null && MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent.getDownTime() == keyEvent.getDownTime()) {
                            this.dispatchVolumeKeyEventLocked(packageName, opPackageName, pid, uid, asSystemService, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeKeyEvent, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownVolumeStream, MediaSessionService.this.mCurrentFullUserRecord.mInitialDownMusicOnly);
                            this.dispatchVolumeKeyEventLocked(packageName, opPackageName, pid, uid, asSystemService, keyEvent, stream, musicOnly);
                        } else {
                            MediaSessionService.this.dispatchVolumeKeyLongPressLocked(keyEvent);
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private void dispatchVolumeKeyEventLocked(String packageName, String opPackageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, int stream, boolean musicOnly) {
            boolean down = keyEvent.getAction() == 0;
            boolean up = keyEvent.getAction() == 1;
            int direction = 0;
            boolean isMute = false;
            switch (keyEvent.getKeyCode()) {
                case 24: {
                    direction = 1;
                    break;
                }
                case 25: {
                    direction = -1;
                    break;
                }
                case 164: {
                    isMute = true;
                }
            }
            if (down || up) {
                int flags = 4096;
                flags = musicOnly ? (flags |= 0x200) : (up ? (flags |= 0x14) : (flags |= 0x11));
                if (direction != 0) {
                    if (up) {
                        direction = 0;
                    }
                    this.dispatchAdjustVolumeLocked(packageName, opPackageName, pid, uid, asSystemService, stream, direction, flags);
                } else if (isMute && down && keyEvent.getRepeatCount() == 0) {
                    this.dispatchAdjustVolumeLocked(packageName, opPackageName, pid, uid, asSystemService, stream, 101, flags);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchVolumeKeyEventToSessionAsSystemService(String packageName, String opPackageName, MediaSession.Token sessionToken, KeyEvent keyEvent) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    MediaSessionRecord record;
                    block18: {
                        record = MediaSessionService.this.getMediaSessionRecordLocked(sessionToken);
                        if (record != null) break block18;
                        Log.w(MediaSessionService.TAG, "Failed to find session to dispatch key event, token=" + sessionToken + ". Fallbacks to the default handling.");
                        this.dispatchVolumeKeyEventLocked(packageName, opPackageName, pid, uid, true, keyEvent, Integer.MIN_VALUE, false);
                        return;
                    }
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "dispatchVolumeKeyEventToSessionAsSystemService, pkg=" + packageName + ", opPkg=" + opPackageName + ", pid=" + pid + ", uid=" + uid + ", sessionToken=" + sessionToken + ", event=" + keyEvent + ", session=" + record);
                    }
                    switch (keyEvent.getAction()) {
                        case 0: {
                            int direction = 0;
                            switch (keyEvent.getKeyCode()) {
                                case 24: {
                                    direction = 1;
                                    break;
                                }
                                case 25: {
                                    direction = -1;
                                    break;
                                }
                                case 164: {
                                    direction = 101;
                                }
                            }
                            record.adjustVolume(packageName, opPackageName, pid, uid, null, true, direction, 1, false);
                            break;
                        }
                        case 1: {
                            int flags = 4116;
                            record.adjustVolume(packageName, opPackageName, pid, uid, null, true, 0, 4116, false);
                        }
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dispatchAdjustVolume(String packageName, String opPackageName, int suggestedStream, int delta, int flags) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    this.dispatchAdjustVolumeLocked(packageName, opPackageName, pid, uid, false, suggestedStream, delta, flags);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerRemoteVolumeController(IRemoteVolumeController rvc) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                try {
                    MediaSessionService.this.enforceStatusBarServicePermission("listen for volume changes", pid, uid);
                    MediaSessionService.this.mRemoteVolumeControllers.register(rvc);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterRemoteVolumeController(IRemoteVolumeController rvc) {
            int pid = Binder.getCallingPid();
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                try {
                    MediaSessionService.this.enforceStatusBarServicePermission("listen for volume changes", pid, uid);
                    MediaSessionService.this.mRemoteVolumeControllers.unregister(rvc);
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isGlobalPriorityActive() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                return MediaSessionService.this.isGlobalPriorityActiveLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(MediaSessionService.this.mContext, MediaSessionService.TAG, pw)) {
                return;
            }
            pw.println("MEDIA SESSION SERVICE (dumpsys media_session)");
            pw.println();
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                pw.println(MediaSessionService.this.mSessionsListeners.size() + " sessions listeners.");
                pw.println("Global priority session is " + MediaSessionService.this.mGlobalPrioritySession);
                if (MediaSessionService.this.mGlobalPrioritySession != null) {
                    MediaSessionService.this.mGlobalPrioritySession.dump(pw, "  ");
                }
                pw.println("User Records:");
                int count = MediaSessionService.this.mUserRecords.size();
                for (int i = 0; i < count; ++i) {
                    ((FullUserRecord)MediaSessionService.this.mUserRecords.valueAt(i)).dumpLocked(pw, "");
                }
                MediaSessionService.this.mAudioPlayerStateMonitor.dump(MediaSessionService.this.mContext, pw, "");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isTrusted(String controllerPackageName, int controllerPid, int controllerUid) throws RemoteException {
            int uid = Binder.getCallingUid();
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = this.hasMediaControlPermission(UserHandle.getUserId(uid), controllerPackageName, controllerPid, controllerUid);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private int verifySessionsRequest(ComponentName componentName, int userId, int pid, int uid) {
            String packageName = null;
            if (componentName != null) {
                packageName = componentName.getPackageName();
                MediaSessionService.this.enforcePackageName(packageName, uid);
            }
            int resolvedUserId = ActivityManager.handleIncomingUser(pid, uid, userId, true, true, "getSessions", packageName);
            MediaSessionService.this.enforceMediaPermissions(componentName, pid, uid, resolvedUserId);
            return resolvedUserId;
        }

        private boolean hasMediaControlPermission(int resolvedUserId, String packageName, int pid, int uid) throws RemoteException {
            int userId;
            if (MediaSessionService.this.hasStatusBarServicePermission(pid, uid)) {
                return true;
            }
            if (uid == 1000 || MediaSessionService.this.mContext.checkPermission("android.permission.MEDIA_CONTENT_CONTROL", pid, uid) == 0) {
                return true;
            }
            if (DEBUG) {
                Log.d(MediaSessionService.TAG, packageName + " (uid=" + uid + ") hasn't granted MEDIA_CONTENT_CONTROL");
            }
            if (resolvedUserId != (userId = UserHandle.getUserId(uid))) {
                return false;
            }
            List<ComponentName> enabledNotificationListeners = MediaSessionService.this.mNotificationManager.getEnabledNotificationListeners(userId);
            if (enabledNotificationListeners != null) {
                for (int i = 0; i < enabledNotificationListeners.size(); ++i) {
                    if (!TextUtils.equals(packageName, enabledNotificationListeners.get(i).getPackageName())) continue;
                    return true;
                }
            }
            if (DEBUG) {
                Log.d(MediaSessionService.TAG, packageName + " (uid=" + uid + ") doesn't have an enabled notification listener");
            }
            return false;
        }

        private void dispatchAdjustVolumeLocked(final String packageName, final String opPackageName, int pid, final int uid, final boolean asSystemService, final int suggestedStream, final int direction, final int flags) {
            MediaSessionRecord session = MediaSessionService.this.isGlobalPriorityActiveLocked() ? MediaSessionService.this.mGlobalPrioritySession : MediaSessionService.this.mCurrentFullUserRecord.mPriorityStack.getDefaultVolumeSession();
            boolean preferSuggestedStream = false;
            if (this.isValidLocalStreamType(suggestedStream) && AudioSystem.isStreamActive(suggestedStream, 0)) {
                preferSuggestedStream = true;
            }
            Log.d(MediaSessionService.TAG, "Adjusting " + session + " by " + direction + ". flags=" + flags + ", suggestedStream=" + suggestedStream + ", preferSuggestedStream=" + preferSuggestedStream);
            if (session == null || preferSuggestedStream) {
                if ((flags & 0x200) != 0 && !AudioSystem.isStreamActive(3, 0)) {
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "No active session to adjust, skipping media only volume event");
                    }
                    return;
                }
                MediaSessionService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        int callingUid;
                        String callingOpPackageName;
                        if (asSystemService) {
                            callingOpPackageName = MediaSessionService.this.mContext.getOpPackageName();
                            callingUid = Process.myUid();
                        } else {
                            callingOpPackageName = opPackageName;
                            callingUid = uid;
                        }
                        try {
                            MediaSessionService.this.mAudioManagerInternal.adjustSuggestedStreamVolumeForUid(suggestedStream, direction, flags, callingOpPackageName, callingUid);
                        }
                        catch (IllegalArgumentException | SecurityException e) {
                            Log.e(MediaSessionService.TAG, "Cannot adjust volume: direction=" + direction + ", suggestedStream=" + suggestedStream + ", flags=" + flags + ", packageName=" + packageName + ", uid=" + uid + ", asSystemService=" + asSystemService, e);
                        }
                    }
                });
            } else {
                session.adjustVolume(packageName, opPackageName, pid, uid, null, asSystemService, direction, flags, true);
            }
        }

        private void handleVoiceKeyEventLocked(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            boolean isLongPress;
            int action = keyEvent.getAction();
            boolean bl = isLongPress = (keyEvent.getFlags() & 0x80) != 0;
            if (action == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && isLongPress) {
                    this.mVoiceButtonHandled = true;
                    this.startVoiceInput(needWakeLock);
                }
            } else if (action == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    KeyEvent downEvent = KeyEvent.changeAction(keyEvent, 0);
                    this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, downEvent, needWakeLock);
                    this.dispatchMediaKeyEventLocked(packageName, pid, uid, asSystemService, keyEvent, needWakeLock);
                }
            }
        }

        private void dispatchMediaKeyEventLocked(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
            block20: {
                MediaSessionRecord session = MediaSessionService.this.mCurrentFullUserRecord.getMediaButtonSessionLocked();
                if (session != null) {
                    Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to " + session);
                    if (needWakeLock) {
                        this.mKeyEventReceiver.aquireWakeLockLocked();
                    }
                    session.sendMediaButton(packageName, pid, uid, asSystemService, keyEvent, needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, this.mKeyEventReceiver);
                    if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null) {
                        try {
                            MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaSession(keyEvent, session.getSessionToken());
                        }
                        catch (RemoteException e) {
                            Log.w(MediaSessionService.TAG, "Failed to send callback", e);
                        }
                    }
                } else if (MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver != null || MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiver != null) {
                    if (needWakeLock) {
                        this.mKeyEventReceiver.aquireWakeLockLocked();
                    }
                    Intent mediaButtonIntent = new Intent("android.intent.action.MEDIA_BUTTON");
                    mediaButtonIntent.addFlags(0x10000000);
                    mediaButtonIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
                    String callerPackageName = asSystemService ? MediaSessionService.this.mContext.getPackageName() : packageName;
                    mediaButtonIntent.putExtra("android.intent.extra.PACKAGE_NAME", callerPackageName);
                    try {
                        if (MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver != null) {
                            ComponentName componentName;
                            PendingIntent receiver = MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver;
                            Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to the last known PendingIntent " + receiver);
                            receiver.send(MediaSessionService.this.mContext, needWakeLock ? this.mKeyEventReceiver.mLastTimeoutId : -1, mediaButtonIntent, this.mKeyEventReceiver, MediaSessionService.this.mHandler);
                            if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null && (componentName = MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver.getIntent().getComponent()) != null) {
                                MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaButtonReceiver(keyEvent, componentName);
                            }
                            break block20;
                        }
                        ComponentName receiver = MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiver;
                        int componentType = MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiverComponentType;
                        UserHandle userHandle = UserHandle.of(MediaSessionService.this.mCurrentFullUserRecord.mRestoredMediaButtonReceiverUserId);
                        Log.d(MediaSessionService.TAG, "Sending " + keyEvent + " to the restored intent " + receiver + ", type=" + componentType);
                        mediaButtonIntent.setComponent(receiver);
                        try {
                            switch (componentType) {
                                case 2: {
                                    MediaSessionService.this.mContext.startActivityAsUser(mediaButtonIntent, userHandle);
                                    break;
                                }
                                case 3: {
                                    MediaSessionService.this.mContext.startForegroundServiceAsUser(mediaButtonIntent, userHandle);
                                    break;
                                }
                                default: {
                                    MediaSessionService.this.mContext.sendBroadcastAsUser(mediaButtonIntent, userHandle);
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            Log.w(MediaSessionService.TAG, "Error sending media button to the restored intent " + receiver + ", type=" + componentType, e);
                        }
                        if (MediaSessionService.this.mCurrentFullUserRecord.mCallback != null) {
                            MediaSessionService.this.mCurrentFullUserRecord.mCallback.onMediaKeyEventDispatchedToMediaButtonReceiver(keyEvent, receiver);
                        }
                    }
                    catch (PendingIntent.CanceledException e) {
                        Log.i(MediaSessionService.TAG, "Error sending key event to media button receiver " + MediaSessionService.this.mCurrentFullUserRecord.mLastMediaButtonReceiver, e);
                    }
                    catch (RemoteException e) {
                        Log.w(MediaSessionService.TAG, "Failed to send callback", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startVoiceInput(boolean needWakeLock) {
            boolean isLocked;
            Intent voiceIntent = null;
            PowerManager pm = (PowerManager)MediaSessionService.this.mContext.getSystemService("power");
            boolean bl = isLocked = MediaSessionService.this.mKeyguardManager != null && MediaSessionService.this.mKeyguardManager.isKeyguardLocked();
            if (!isLocked && pm.isScreenOn()) {
                voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
            } else {
                voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
                voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && MediaSessionService.this.mKeyguardManager.isKeyguardSecure());
                Log.i(MediaSessionService.TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
            }
            if (needWakeLock) {
                MediaSessionService.this.mMediaEventWakeLock.acquire();
            }
            try {
                if (voiceIntent != null) {
                    voiceIntent.setFlags(0x10800000);
                    if (DEBUG) {
                        Log.d(MediaSessionService.TAG, "voiceIntent: " + voiceIntent);
                    }
                    MediaSessionService.this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT);
                }
            }
            catch (ActivityNotFoundException e) {
                Log.w(MediaSessionService.TAG, "No activity for search: " + e);
            }
            finally {
                if (needWakeLock) {
                    MediaSessionService.this.mMediaEventWakeLock.release();
                }
            }
        }

        private boolean isVoiceKey(int keyCode) {
            return keyCode == 79 || !MediaSessionService.this.mHasFeatureLeanback && keyCode == 85;
        }

        private boolean isUserSetupComplete() {
            return Settings.Secure.getIntForUser(MediaSessionService.this.mContext.getContentResolver(), "user_setup_complete", 0, -2) != 0;
        }

        private boolean isValidLocalStreamType(int streamType) {
            return streamType >= 0 && streamType <= 5;
        }

        class KeyEventWakeLockReceiver
        extends ResultReceiver
        implements Runnable,
        PendingIntent.OnFinished {
            private final Handler mHandler;
            private int mRefCount;
            private int mLastTimeoutId;

            KeyEventWakeLockReceiver(Handler handler) {
                super(handler);
                this.mRefCount = 0;
                this.mLastTimeoutId = 0;
                this.mHandler = handler;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTimeout() {
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount == 0) {
                        return;
                    }
                    ++this.mLastTimeoutId;
                    this.mRefCount = 0;
                    this.releaseWakeLockLocked();
                }
            }

            public void aquireWakeLockLocked() {
                if (this.mRefCount == 0) {
                    MediaSessionService.this.mMediaEventWakeLock.acquire();
                }
                ++this.mRefCount;
                this.mHandler.removeCallbacks(this);
                this.mHandler.postDelayed(this, 5000L);
            }

            @Override
            public void run() {
                this.onTimeout();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode < this.mLastTimeoutId) {
                    return;
                }
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (this.mRefCount > 0) {
                        --this.mRefCount;
                        if (this.mRefCount == 0) {
                            this.releaseWakeLockLocked();
                        }
                    }
                }
            }

            private void releaseWakeLockLocked() {
                MediaSessionService.this.mMediaEventWakeLock.release();
                this.mHandler.removeCallbacks(this);
            }

            @Override
            public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
                this.onReceiveResult(resultCode, null);
            }
        }

        private class MediaKeyListenerResultReceiver
        extends ResultReceiver
        implements Runnable {
            private final String mPackageName;
            private final int mPid;
            private final int mUid;
            private final boolean mAsSystemService;
            private final KeyEvent mKeyEvent;
            private final boolean mNeedWakeLock;
            private boolean mHandled;

            private MediaKeyListenerResultReceiver(String packageName, int pid, int uid, boolean asSystemService, KeyEvent keyEvent, boolean needWakeLock) {
                super(MediaSessionService.this.mHandler);
                MediaSessionService.this.mHandler.postDelayed(this, 1000L);
                this.mPackageName = packageName;
                this.mPid = pid;
                this.mUid = uid;
                this.mAsSystemService = asSystemService;
                this.mKeyEvent = keyEvent;
                this.mNeedWakeLock = needWakeLock;
            }

            @Override
            public void run() {
                Log.d(MediaSessionService.TAG, "The media key listener is timed-out for " + this.mKeyEvent);
                this.dispatchMediaKeyEvent();
            }

            @Override
            protected void onReceiveResult(int resultCode, Bundle resultData) {
                if (resultCode == 1) {
                    this.mHandled = true;
                    MediaSessionService.this.mHandler.removeCallbacks(this);
                    return;
                }
                this.dispatchMediaKeyEvent();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void dispatchMediaKeyEvent() {
                if (this.mHandled) {
                    return;
                }
                this.mHandled = true;
                MediaSessionService.this.mHandler.removeCallbacks(this);
                Object object = MediaSessionService.this.mLock;
                synchronized (object) {
                    if (!MediaSessionService.this.isGlobalPriorityActiveLocked() && SessionManagerImpl.this.isVoiceKey(this.mKeyEvent.getKeyCode())) {
                        SessionManagerImpl.this.handleVoiceKeyEventLocked(this.mPackageName, this.mPid, this.mUid, this.mAsSystemService, this.mKeyEvent, this.mNeedWakeLock);
                    } else {
                        SessionManagerImpl.this.dispatchMediaKeyEventLocked(this.mPackageName, this.mPid, this.mUid, this.mAsSystemService, this.mKeyEvent, this.mNeedWakeLock);
                    }
                }
            }
        }
    }

    final class SettingsObserver
    extends ContentObserver {
        private final Uri mSecureSettingsUri;

        private SettingsObserver() {
            super(null);
            this.mSecureSettingsUri = Settings.Secure.getUriFor("enabled_notification_listeners");
        }

        private void observe() {
            MediaSessionService.this.mContentResolver.registerContentObserver(this.mSecureSettingsUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            MediaSessionService.this.updateActiveSessionListeners();
        }
    }

    final class Session2TokensListenerRecord
    implements IBinder.DeathRecipient {
        public final ISession2TokensListener listener;
        public final int userId;

        Session2TokensListenerRecord(ISession2TokensListener listener, int userId) {
            this.listener = listener;
            this.userId = userId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                MediaSessionService.this.mSession2TokensListenerRecords.remove(this);
            }
        }
    }

    final class SessionsListenerRecord
    implements IBinder.DeathRecipient {
        public final IActiveSessionsListener listener;
        public final ComponentName componentName;
        public final int userId;
        public final int pid;
        public final int uid;

        SessionsListenerRecord(IActiveSessionsListener listener, ComponentName componentName, int userId, int pid, int uid) {
            this.listener = listener;
            this.componentName = componentName;
            this.userId = userId;
            this.pid = pid;
            this.uid = uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                MediaSessionService.this.mSessionsListeners.remove(this);
            }
        }
    }

    final class FullUserRecord
    implements MediaSessionStack.OnMediaButtonSessionChangedListener {
        public static final int COMPONENT_TYPE_INVALID = 0;
        public static final int COMPONENT_TYPE_BROADCAST = 1;
        public static final int COMPONENT_TYPE_ACTIVITY = 2;
        public static final int COMPONENT_TYPE_SERVICE = 3;
        private static final String COMPONENT_NAME_USER_ID_DELIM = ",";
        private final int mFullUserId;
        private final MediaSessionStack mPriorityStack;
        private PendingIntent mLastMediaButtonReceiver;
        private ComponentName mRestoredMediaButtonReceiver;
        private int mRestoredMediaButtonReceiverComponentType;
        private int mRestoredMediaButtonReceiverUserId;
        private IOnVolumeKeyLongPressListener mOnVolumeKeyLongPressListener;
        private int mOnVolumeKeyLongPressListenerUid;
        private KeyEvent mInitialDownVolumeKeyEvent;
        private int mInitialDownVolumeStream;
        private boolean mInitialDownMusicOnly;
        private IOnMediaKeyListener mOnMediaKeyListener;
        private int mOnMediaKeyListenerUid;
        private ICallback mCallback;

        FullUserRecord(int fullUserId) {
            this.mFullUserId = fullUserId;
            this.mPriorityStack = new MediaSessionStack(MediaSessionService.this.mAudioPlayerStateMonitor, this);
            String mediaButtonReceiverInfo = Settings.Secure.getStringForUser(MediaSessionService.this.mContentResolver, "media_button_receiver", this.mFullUserId);
            if (mediaButtonReceiverInfo == null) {
                return;
            }
            String[] tokens = mediaButtonReceiverInfo.split(COMPONENT_NAME_USER_ID_DELIM);
            if (tokens == null || tokens.length != 2 && tokens.length != 3) {
                return;
            }
            this.mRestoredMediaButtonReceiver = ComponentName.unflattenFromString(tokens[0]);
            this.mRestoredMediaButtonReceiverUserId = Integer.parseInt(tokens[1]);
            this.mRestoredMediaButtonReceiverComponentType = tokens.length == 3 ? Integer.parseInt(tokens[2]) : this.getComponentType(this.mRestoredMediaButtonReceiver);
        }

        public void destroySessionsForUserLocked(int userId) {
            ArrayList<MediaSessionRecord> sessions = this.mPriorityStack.getPriorityList(false, userId);
            for (MediaSessionRecord session : sessions) {
                MediaSessionService.this.destroySessionLocked(session);
            }
        }

        public void dumpLocked(PrintWriter pw, String prefix) {
            pw.print(prefix + "Record for full_user=" + this.mFullUserId);
            int size = MediaSessionService.this.mFullUserIds.size();
            for (int i = 0; i < size; ++i) {
                if (MediaSessionService.this.mFullUserIds.keyAt(i) == MediaSessionService.this.mFullUserIds.valueAt(i) || MediaSessionService.this.mFullUserIds.valueAt(i) != this.mFullUserId) continue;
                pw.print(", profile_user=" + MediaSessionService.this.mFullUserIds.keyAt(i));
            }
            pw.println();
            String indent = prefix + "  ";
            pw.println(indent + "Volume key long-press listener: " + this.mOnVolumeKeyLongPressListener);
            pw.println(indent + "Volume key long-press listener package: " + MediaSessionService.this.getCallingPackageName(this.mOnVolumeKeyLongPressListenerUid));
            pw.println(indent + "Media key listener: " + this.mOnMediaKeyListener);
            pw.println(indent + "Media key listener package: " + MediaSessionService.this.getCallingPackageName(this.mOnMediaKeyListenerUid));
            pw.println(indent + "Callback: " + this.mCallback);
            pw.println(indent + "Last MediaButtonReceiver: " + this.mLastMediaButtonReceiver);
            pw.println(indent + "Restored MediaButtonReceiver: " + this.mRestoredMediaButtonReceiver);
            pw.println(indent + "Restored MediaButtonReceiverComponentType: " + this.mRestoredMediaButtonReceiverComponentType);
            this.mPriorityStack.dump(pw, indent);
            pw.println(indent + "Session2Tokens:");
            for (int i = 0; i < MediaSessionService.this.mSession2TokensPerUser.size(); ++i) {
                List list = (List)MediaSessionService.this.mSession2TokensPerUser.valueAt(i);
                if (list == null || list.size() == 0) continue;
                for (Session2Token token : list) {
                    pw.println(indent + "  " + token);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMediaButtonSessionChanged(MediaSessionRecord oldMediaButtonSession, MediaSessionRecord newMediaButtonSession) {
            Log.d(MediaSessionService.TAG, "Media button session is changed to " + newMediaButtonSession);
            Object object = MediaSessionService.this.mLock;
            synchronized (object) {
                if (oldMediaButtonSession != null) {
                    MediaSessionService.this.mHandler.postSessionsChanged(oldMediaButtonSession.getUserId());
                }
                if (newMediaButtonSession != null) {
                    this.rememberMediaButtonReceiverLocked(newMediaButtonSession);
                    MediaSessionService.this.mHandler.postSessionsChanged(newMediaButtonSession.getUserId());
                }
                this.pushAddressedPlayerChangedLocked();
            }
        }

        public void rememberMediaButtonReceiverLocked(MediaSessionRecord record) {
            ComponentName component;
            PendingIntent receiver;
            this.mLastMediaButtonReceiver = receiver = record.getMediaButtonReceiver();
            this.mRestoredMediaButtonReceiver = null;
            this.mRestoredMediaButtonReceiverComponentType = 0;
            String mediaButtonReceiverInfo = "";
            if (receiver != null && (component = receiver.getIntent().getComponent()) != null && record.getPackageName().equals(component.getPackageName())) {
                String componentName = component.flattenToString();
                int componentType = this.getComponentType(component);
                mediaButtonReceiverInfo = String.join((CharSequence)COMPONENT_NAME_USER_ID_DELIM, componentName, String.valueOf(record.getUserId()), String.valueOf(componentType));
            }
            Settings.Secure.putStringForUser(MediaSessionService.this.mContentResolver, "media_button_receiver", mediaButtonReceiverInfo, this.mFullUserId);
        }

        private void pushAddressedPlayerChangedLocked() {
            if (this.mCallback == null) {
                return;
            }
            try {
                MediaSessionRecord mediaButtonSession = this.getMediaButtonSessionLocked();
                if (mediaButtonSession != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaSession(mediaButtonSession.getSessionToken());
                } else if (((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mLastMediaButtonReceiver != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaButtonReceiver(((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mLastMediaButtonReceiver.getIntent().getComponent());
                } else if (((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mRestoredMediaButtonReceiver != null) {
                    this.mCallback.onAddressedPlayerChangedToMediaButtonReceiver(((MediaSessionService)MediaSessionService.this).mCurrentFullUserRecord.mRestoredMediaButtonReceiver);
                }
            }
            catch (RemoteException e) {
                Log.w(MediaSessionService.TAG, "Failed to pushAddressedPlayerChangedLocked", e);
            }
        }

        private MediaSessionRecord getMediaButtonSessionLocked() {
            return MediaSessionService.this.isGlobalPriorityActiveLocked() ? MediaSessionService.this.mGlobalPrioritySession : this.mPriorityStack.getMediaButtonSession();
        }

        private int getComponentType(ComponentName componentName) {
            if (componentName == null) {
                return 0;
            }
            PackageManager pm = MediaSessionService.this.mContext.getPackageManager();
            try {
                ActivityInfo activityInfo = pm.getActivityInfo(componentName, 786433);
                if (activityInfo != null) {
                    return 2;
                }
            }
            catch (PackageManager.NameNotFoundException activityInfo) {
                // empty catch block
            }
            try {
                ServiceInfo serviceInfo = pm.getServiceInfo(componentName, 786436);
                if (serviceInfo != null) {
                    return 3;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return 1;
        }
    }
}

