/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;

public class DelayedDiskWrite {
    private HandlerThread mDiskWriteHandlerThread;
    private Handler mDiskWriteHandler;
    private int mWriteSequence = 0;
    private final String TAG = "DelayedDiskWrite";

    public void write(String filePath, Writer w) {
        this.write(filePath, w, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(final String filePath, final Writer w, final boolean open) {
        if (TextUtils.isEmpty(filePath)) {
            throw new IllegalArgumentException("empty file path");
        }
        DelayedDiskWrite delayedDiskWrite = this;
        synchronized (delayedDiskWrite) {
            if (++this.mWriteSequence == 1) {
                this.mDiskWriteHandlerThread = new HandlerThread("DelayedDiskWriteThread");
                this.mDiskWriteHandlerThread.start();
                this.mDiskWriteHandler = new Handler(this.mDiskWriteHandlerThread.getLooper());
            }
        }
        this.mDiskWriteHandler.post(new Runnable(){

            @Override
            public void run() {
                DelayedDiskWrite.this.doWrite(filePath, w, open);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(String filePath, Writer w, boolean open) {
        FilterOutputStream out = null;
        try {
            if (open) {
                out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filePath)));
            }
            w.onWriteCalled((DataOutputStream)out);
        }
        catch (IOException e) {
            this.loge("Error writing data file " + filePath);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            DelayedDiskWrite delayedDiskWrite = this;
            synchronized (delayedDiskWrite) {
                if (--this.mWriteSequence == 0) {
                    this.mDiskWriteHandler.getLooper().quit();
                    this.mDiskWriteHandler = null;
                    this.mDiskWriteHandlerThread = null;
                }
            }
        }
    }

    private void loge(String s) {
        Log.e("DelayedDiskWrite", s);
    }

    public static interface Writer {
        public void onWriteCalled(DataOutputStream var1) throws IOException;
    }
}

