/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.ActivityManagerInternal;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.IUidObserver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkIdentity;
import android.net.NetworkPolicy;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.NetworkState;
import android.net.NetworkStats;
import android.net.NetworkTemplate;
import android.net.StringNetworkSpecifier;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.BestClock;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IDeviceIdleController;
import android.os.INetworkManagementService;
import android.os.Message;
import android.os.MessageQueue;
import android.os.PersistableBundle;
import android.os.PowerManagerInternal;
import android.os.PowerSaveState;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.SubscriptionPlan;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.DataUnit;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.RecurrenceRule;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.SparseLongArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.RoSystemProperties;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.StatLogger;
import com.android.internal.util.XmlUtils;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.NetworkPolicyLogger;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.net.NetworkPolicyManagerShellCommand;
import com.android.server.net.NetworkStatsManagerInternal;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;

public class NetworkPolicyManagerService
extends INetworkPolicyManager.Stub {
    static final String TAG = "NetworkPolicy";
    private static final boolean LOGD = NetworkPolicyLogger.LOGD;
    private static final boolean LOGV = NetworkPolicyLogger.LOGV;
    public static final int OPPORTUNISTIC_QUOTA_UNKNOWN = -1;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADDED_SNOOZE = 2;
    private static final int VERSION_ADDED_RESTRICT_BACKGROUND = 3;
    private static final int VERSION_ADDED_METERED = 4;
    private static final int VERSION_SPLIT_SNOOZE = 5;
    private static final int VERSION_ADDED_TIMEZONE = 6;
    private static final int VERSION_ADDED_INFERRED = 7;
    private static final int VERSION_SWITCH_APP_ID = 8;
    private static final int VERSION_ADDED_NETWORK_ID = 9;
    private static final int VERSION_SWITCH_UID = 10;
    private static final int VERSION_ADDED_CYCLE = 11;
    private static final int VERSION_LATEST = 11;
    @VisibleForTesting
    public static final int TYPE_WARNING = 34;
    @VisibleForTesting
    public static final int TYPE_LIMIT = 35;
    @VisibleForTesting
    public static final int TYPE_LIMIT_SNOOZED = 36;
    @VisibleForTesting
    public static final int TYPE_RAPID = 45;
    private static final String TAG_POLICY_LIST = "policy-list";
    private static final String TAG_NETWORK_POLICY = "network-policy";
    private static final String TAG_SUBSCRIPTION_PLAN = "subscription-plan";
    private static final String TAG_UID_POLICY = "uid-policy";
    private static final String TAG_APP_POLICY = "app-policy";
    private static final String TAG_WHITELIST = "whitelist";
    private static final String TAG_RESTRICT_BACKGROUND = "restrict-background";
    private static final String TAG_REVOKED_RESTRICT_BACKGROUND = "revoked-restrict-background";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_RESTRICT_BACKGROUND = "restrictBackground";
    private static final String ATTR_NETWORK_TEMPLATE = "networkTemplate";
    private static final String ATTR_SUBSCRIBER_ID = "subscriberId";
    private static final String ATTR_NETWORK_ID = "networkId";
    @Deprecated
    private static final String ATTR_CYCLE_DAY = "cycleDay";
    @Deprecated
    private static final String ATTR_CYCLE_TIMEZONE = "cycleTimezone";
    private static final String ATTR_CYCLE_START = "cycleStart";
    private static final String ATTR_CYCLE_END = "cycleEnd";
    private static final String ATTR_CYCLE_PERIOD = "cyclePeriod";
    private static final String ATTR_WARNING_BYTES = "warningBytes";
    private static final String ATTR_LIMIT_BYTES = "limitBytes";
    private static final String ATTR_LAST_SNOOZE = "lastSnooze";
    private static final String ATTR_LAST_WARNING_SNOOZE = "lastWarningSnooze";
    private static final String ATTR_LAST_LIMIT_SNOOZE = "lastLimitSnooze";
    private static final String ATTR_METERED = "metered";
    private static final String ATTR_INFERRED = "inferred";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_APP_ID = "appId";
    private static final String ATTR_POLICY = "policy";
    private static final String ATTR_SUB_ID = "subId";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_SUMMARY = "summary";
    private static final String ATTR_LIMIT_BEHAVIOR = "limitBehavior";
    private static final String ATTR_USAGE_BYTES = "usageBytes";
    private static final String ATTR_USAGE_TIME = "usageTime";
    private static final String ATTR_OWNER_PACKAGE = "ownerPackage";
    private static final String ACTION_ALLOW_BACKGROUND = "com.android.server.net.action.ALLOW_BACKGROUND";
    private static final String ACTION_SNOOZE_WARNING = "com.android.server.net.action.SNOOZE_WARNING";
    private static final String ACTION_SNOOZE_RAPID = "com.android.server.net.action.SNOOZE_RAPID";
    private static final long WAIT_FOR_ADMIN_DATA_TIMEOUT_MS = 10000L;
    private static final long QUOTA_UNLIMITED_DEFAULT = DataUnit.MEBIBYTES.toBytes(20L);
    private static final float QUOTA_LIMITED_DEFAULT = 0.1f;
    private static final float QUOTA_FRAC_JOBS_DEFAULT = 0.5f;
    private static final float QUOTA_FRAC_MULTIPATH_DEFAULT = 0.5f;
    private static final int MSG_RULES_CHANGED = 1;
    private static final int MSG_METERED_IFACES_CHANGED = 2;
    private static final int MSG_LIMIT_REACHED = 5;
    private static final int MSG_RESTRICT_BACKGROUND_CHANGED = 6;
    private static final int MSG_ADVISE_PERSIST_THRESHOLD = 7;
    private static final int MSG_UPDATE_INTERFACE_QUOTA = 10;
    private static final int MSG_REMOVE_INTERFACE_QUOTA = 11;
    private static final int MSG_POLICIES_CHANGED = 13;
    private static final int MSG_RESET_FIREWALL_RULES_BY_UID = 15;
    private static final int MSG_SUBSCRIPTION_OVERRIDE = 16;
    private static final int MSG_METERED_RESTRICTED_PACKAGES_CHANGED = 17;
    private static final int MSG_SET_NETWORK_TEMPLATE_ENABLED = 18;
    private static final int UID_MSG_STATE_CHANGED = 100;
    private static final int UID_MSG_GONE = 101;
    private static final String PROP_SUB_PLAN_OWNER = "persist.sys.sub_plan_owner";
    private final Context mContext;
    private final IActivityManager mActivityManager;
    private NetworkStatsManagerInternal mNetworkStats;
    private final INetworkManagementService mNetworkManager;
    private UsageStatsManagerInternal mUsageStats;
    private final Clock mClock;
    private final UserManager mUserManager;
    private final CarrierConfigManager mCarrierConfigManager;
    private IConnectivityManager mConnManager;
    private PowerManagerInternal mPowerManagerInternal;
    private IDeviceIdleController mDeviceIdleController;
    @GuardedBy(value={"mUidRulesFirstLock"})
    private PowerSaveState mRestrictBackgroundPowerState;
    private boolean mRestrictBackgroundBeforeBsm;
    private boolean mLoadedRestrictBackground;
    final Object mUidRulesFirstLock = new Object();
    final Object mNetworkPoliciesSecondLock = new Object();
    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    volatile boolean mSystemReady;
    @GuardedBy(value={"mUidRulesFirstLock"})
    volatile boolean mRestrictBackground;
    @GuardedBy(value={"mUidRulesFirstLock"})
    volatile boolean mRestrictPower;
    @GuardedBy(value={"mUidRulesFirstLock"})
    volatile boolean mDeviceIdleMode;
    @GuardedBy(value={"mUidRulesFirstLock"})
    volatile boolean mRestrictBackgroundChangedInBsm;
    private final boolean mSuppressDefaultPolicy;
    private final CountDownLatch mAdminDataAvailableLatch = new CountDownLatch(1);
    private volatile boolean mNetworkManagerReady;
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    final ArrayMap<NetworkTemplate, NetworkPolicy> mNetworkPolicy = new ArrayMap();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    final SparseArray<SubscriptionPlan[]> mSubscriptionPlans = new SparseArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    final SparseArray<String> mSubscriptionPlansOwner = new SparseArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    final SparseLongArray mSubscriptionOpportunisticQuota = new SparseLongArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidPolicy = new SparseIntArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidRules = new SparseIntArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidFirewallStandbyRules = new SparseIntArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidFirewallDozableRules = new SparseIntArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidFirewallPowerSaveRules = new SparseIntArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseBooleanArray mFirewallChainStates = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mPowerSaveWhitelistAppIds = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mPowerSaveTempWhitelistAppIds = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mAppIdleTempWhitelistAppIds = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mDefaultRestrictBackgroundWhitelistUids = new SparseBooleanArray();
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseBooleanArray mRestrictBackgroundWhitelistRevokedUids = new SparseBooleanArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private ArraySet<String> mMeteredIfaces = new ArraySet();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final ArraySet<NetworkTemplate> mOverLimitNotified = new ArraySet();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final ArraySet<NotificationId> mActiveNotifs = new ArraySet();
    @GuardedBy(value={"mUidRulesFirstLock"})
    final SparseIntArray mUidState = new SparseIntArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final SparseBooleanArray mNetworkMetered = new SparseBooleanArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final SparseBooleanArray mNetworkRoaming = new SparseBooleanArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final SparseIntArray mNetIdToSubId = new SparseIntArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private final SparseArray<String> mSubIdToSubscriberId = new SparseArray();
    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private String[] mMergedSubscriberIds = EmptyArray.STRING;
    @GuardedBy(value={"mUidRulesFirstLock"})
    private final SparseArray<Set<Integer>> mMeteredRestrictedUids = new SparseArray();
    private final RemoteCallbackList<INetworkPolicyListener> mListeners = new RemoteCallbackList();
    final Handler mHandler;
    @VisibleForTesting
    final Handler mUidEventHandler;
    private final ServiceThread mUidEventThread;
    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    private final AtomicFile mPolicyFile;
    private final AppOpsManager mAppOps;
    private final IPackageManager mIPm;
    private ActivityManagerInternal mActivityManagerInternal;
    private final NetworkPolicyLogger mLogger = new NetworkPolicyLogger();
    public final StatLogger mStatLogger = new StatLogger(new String[]{"updateNetworkEnabledNL()", "isUidNetworkingBlocked()"});
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        @Override
        public void onUidStateChanged(int uid, int procState, long procStateSeq) {
            NetworkPolicyManagerService.this.mUidEventHandler.obtainMessage(100, uid, procState, procStateSeq).sendToTarget();
        }

        @Override
        public void onUidGone(int uid, boolean disabled) {
            NetworkPolicyManagerService.this.mUidEventHandler.obtainMessage(101, uid, 0).sendToTarget();
        }

        @Override
        public void onUidActive(int uid) {
        }

        @Override
        public void onUidIdle(int uid, boolean disabled) {
        }

        @Override
        public void onUidCachedChanged(int uid, boolean cached) {
        }
    };
    private final BroadcastReceiver mPowerSaveWhitelistReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updatePowerSaveWhitelistUL();
                NetworkPolicyManagerService.this.updateRulesForRestrictPowerUL();
                NetworkPolicyManagerService.this.updateRulesForAppIdleUL();
            }
        }
    };
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                if (LOGV) {
                    Slog.v(NetworkPolicyManagerService.TAG, "ACTION_PACKAGE_ADDED for uid=" + uid);
                }
                Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRestrictionRulesForUidUL(uid);
                }
            }
        }
    };
    private final BroadcastReceiver mUidRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            if (LOGV) {
                Slog.v(NetworkPolicyManagerService.TAG, "ACTION_UID_REMOVED for uid=" + uid);
            }
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.onUidDeletedUL(uid);
                Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    NetworkPolicyManagerService.this.writePolicyAL();
                }
            }
        }
    };
    private final BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_ADDED": {
                    Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                    synchronized (object) {
                        NetworkPolicyManagerService.this.removeUserStateUL(userId, true);
                        NetworkPolicyManagerService.this.mMeteredRestrictedUids.remove(userId);
                        if (action == "android.intent.action.USER_ADDED") {
                            NetworkPolicyManagerService.this.addDefaultRestrictBackgroundWhitelistUidsUL(userId);
                        }
                        Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                        synchronized (object2) {
                            NetworkPolicyManagerService.this.updateRulesForGlobalChangeAL(true);
                        }
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mStatsReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateNetworkEnabledNL();
                NetworkPolicyManagerService.this.updateNotificationsNL();
            }
        }
    };
    private final BroadcastReceiver mAllowReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.setRestrictBackground(false);
        }
    };
    private final BroadcastReceiver mSnoozeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkTemplate template = (NetworkTemplate)intent.getParcelableExtra("android.net.NETWORK_TEMPLATE");
            if (NetworkPolicyManagerService.ACTION_SNOOZE_WARNING.equals(intent.getAction())) {
                NetworkPolicyManagerService.this.performSnooze(template, 34);
            } else if (NetworkPolicyManagerService.ACTION_SNOOZE_RAPID.equals(intent.getAction())) {
                NetworkPolicyManagerService.this.performSnooze(template, 45);
            }
        }
    };
    private final BroadcastReceiver mWifiReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    NetworkPolicyManagerService.this.upgradeWifiMeteredOverrideAL();
                }
            }
            NetworkPolicyManagerService.this.mContext.unregisterReceiver(this);
        }
    };
    private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
            if (network == null || networkCapabilities == null) {
                return;
            }
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                boolean newMetered = !networkCapabilities.hasCapability(11);
                boolean meteredChanged = NetworkPolicyManagerService.updateCapabilityChange(NetworkPolicyManagerService.this.mNetworkMetered, newMetered, network);
                boolean newRoaming = !networkCapabilities.hasCapability(18);
                boolean roamingChanged = NetworkPolicyManagerService.updateCapabilityChange(NetworkPolicyManagerService.this.mNetworkRoaming, newRoaming, network);
                if (meteredChanged || roamingChanged) {
                    NetworkPolicyManagerService.this.mLogger.meterednessChanged(network.netId, newMetered);
                    NetworkPolicyManagerService.this.updateNetworkRulesNL();
                }
            }
        }
    };
    private final INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        @Override
        public void limitReached(String limitName, String iface) {
            NetworkPolicyManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkPolicyManagerService.TAG);
            if (!"globalAlert".equals(limitName)) {
                NetworkPolicyManagerService.this.mHandler.obtainMessage(5, iface).sendToTarget();
            }
        }
    };
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.updateNetworksInternal();
        }
    };
    private BroadcastReceiver mCarrierConfigReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (!intent.hasExtra("subscription")) {
                return;
            }
            int subId = intent.getIntExtra("subscription", -1);
            NetworkPolicyManagerService.this.updateSubscriptions();
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    String subscriberId = NetworkPolicyManagerService.this.mSubIdToSubscriberId.get(subId, null);
                    if (subscriberId != null) {
                        NetworkPolicyManagerService.this.ensureActiveMobilePolicyAL(subId, subscriberId);
                        NetworkPolicyManagerService.this.maybeUpdateMobilePolicyCycleAL(subId, subscriberId);
                    } else {
                        Slog.wtf(NetworkPolicyManagerService.TAG, "Missing subscriberId for subId " + subId);
                    }
                    NetworkPolicyManagerService.this.handleNetworkPoliciesUpdateAL(true);
                }
            }
        }
    };
    private static final int TYPE_RESTRICT_BACKGROUND = 1;
    private static final int TYPE_RESTRICT_POWER = 2;
    private final Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    int uidRules = msg.arg2;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchUidRulesChanged(listener, uid, uidRules);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 2: {
                    String[] meteredIfaces = (String[])msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchMeteredIfacesChanged(listener, meteredIfaces);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 5: {
                    String iface = (String)msg.obj;
                    Object length = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                    synchronized (length) {
                        if (NetworkPolicyManagerService.this.mMeteredIfaces.contains(iface)) {
                            NetworkPolicyManagerService.this.mNetworkStats.forceUpdate();
                            NetworkPolicyManagerService.this.updateNetworkEnabledNL();
                            NetworkPolicyManagerService.this.updateNotificationsNL();
                        }
                    }
                    return true;
                }
                case 6: {
                    boolean restrictBackground = msg.arg1 != 0;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchRestrictBackgroundChanged(listener, restrictBackground);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    Intent intent = new Intent("android.net.conn.RESTRICT_BACKGROUND_CHANGED");
                    intent.setFlags(0x40000000);
                    NetworkPolicyManagerService.this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
                    return true;
                }
                case 13: {
                    int uid = msg.arg1;
                    int policy = msg.arg2;
                    Boolean notifyApp = (Boolean)msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchUidPoliciesChanged(listener, uid, policy);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    if (notifyApp.booleanValue()) {
                        NetworkPolicyManagerService.this.broadcastRestrictBackgroundChanged(uid, notifyApp);
                    }
                    return true;
                }
                case 7: {
                    long lowestRule = (Long)msg.obj;
                    long persistThreshold = lowestRule / 1000L;
                    NetworkPolicyManagerService.this.mNetworkStats.advisePersistThreshold(persistThreshold);
                    return true;
                }
                case 10: {
                    NetworkPolicyManagerService.this.removeInterfaceQuota((String)msg.obj);
                    NetworkPolicyManagerService.this.setInterfaceQuota((String)msg.obj, (long)msg.arg1 << 32 | (long)msg.arg2 & 0xFFFFFFFFL);
                    return true;
                }
                case 11: {
                    NetworkPolicyManagerService.this.removeInterfaceQuota((String)msg.obj);
                    return true;
                }
                case 15: {
                    NetworkPolicyManagerService.this.resetUidFirewallRules(msg.arg1);
                    return true;
                }
                case 16: {
                    int overrideMask = msg.arg1;
                    int overrideValue = msg.arg2;
                    int subId = (Integer)msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        NetworkPolicyManagerService.this.dispatchSubscriptionOverride(listener, subId, overrideMask, overrideValue);
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 17: {
                    int userId = msg.arg1;
                    Set packageNames = (Set)msg.obj;
                    NetworkPolicyManagerService.this.setMeteredRestrictedPackagesInternal(packageNames, userId);
                    return true;
                }
                case 18: {
                    NetworkTemplate template = (NetworkTemplate)msg.obj;
                    boolean enabled = msg.arg1 != 0;
                    NetworkPolicyManagerService.this.setNetworkTemplateEnabledInner(template, enabled);
                    return true;
                }
            }
            return false;
        }
    };
    private final Handler.Callback mUidEventHandlerCallback = new Handler.Callback(){

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    int uid = msg.arg1;
                    int procState = msg.arg2;
                    long procStateSeq = (Long)msg.obj;
                    NetworkPolicyManagerService.this.handleUidChanged(uid, procState, procStateSeq);
                    return true;
                }
                case 101: {
                    int uid = msg.arg1;
                    NetworkPolicyManagerService.this.handleUidGone(uid);
                    return true;
                }
            }
            return false;
        }
    };
    private static final int CHAIN_TOGGLE_NONE = 0;
    private static final int CHAIN_TOGGLE_ENABLE = 1;
    private static final int CHAIN_TOGGLE_DISABLE = 2;

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, INetworkManagementService networkManagement) {
        this(context, activityManager, networkManagement, AppGlobals.getPackageManager(), NetworkPolicyManagerService.getDefaultClock(), NetworkPolicyManagerService.getDefaultSystemDir(), false);
    }

    private static File getDefaultSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    private static Clock getDefaultClock() {
        return new BestClock(ZoneOffset.UTC, SystemClock.currentNetworkTimeClock(), Clock.systemUTC());
    }

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, INetworkManagementService networkManagement, IPackageManager pm, Clock clock, File systemDir, boolean suppressDefaultPolicy) {
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mActivityManager = Preconditions.checkNotNull(activityManager, "missing activityManager");
        this.mNetworkManager = Preconditions.checkNotNull(networkManagement, "missing networkManagement");
        this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        this.mClock = Preconditions.checkNotNull(clock, "missing Clock");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mCarrierConfigManager = this.mContext.getSystemService(CarrierConfigManager.class);
        this.mIPm = pm;
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this.mHandlerCallback);
        this.mUidEventThread = new ServiceThread("NetworkPolicy.uid", -2, false);
        this.mUidEventThread.start();
        this.mUidEventHandler = new Handler(this.mUidEventThread.getLooper(), this.mUidEventHandlerCallback);
        this.mSuppressDefaultPolicy = suppressDefaultPolicy;
        this.mPolicyFile = new AtomicFile(new File(systemDir, "netpolicy.xml"), "net-policy");
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        LocalServices.addService(NetworkPolicyManagerInternal.class, new NetworkPolicyManagerInternalImpl());
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = Preconditions.checkNotNull(connManager, "missing IConnectivityManager");
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updatePowerSaveWhitelistUL() {
        try {
            int[] whitelist = this.mDeviceIdleController.getAppIdWhitelistExceptIdle();
            this.mPowerSaveWhitelistExceptIdleAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistExceptIdleAppIds.put(uid, true);
                }
            }
            whitelist = this.mDeviceIdleController.getAppIdWhitelist();
            this.mPowerSaveWhitelistAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistAppIds.put(uid, true);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    boolean addDefaultRestrictBackgroundWhitelistUidsUL() {
        List<UserInfo> users = this.mUserManager.getUsers();
        int numberUsers = users.size();
        boolean changed = false;
        for (int i = 0; i < numberUsers; ++i) {
            UserInfo user = users.get(i);
            changed = this.addDefaultRestrictBackgroundWhitelistUidsUL(user.id) || changed;
        }
        return changed;
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean addDefaultRestrictBackgroundWhitelistUidsUL(int userId) {
        SystemConfig sysConfig = SystemConfig.getInstance();
        PackageManager pm = this.mContext.getPackageManager();
        ArraySet<String> allowDataUsage = sysConfig.getAllowInDataUsageSave();
        boolean changed = false;
        for (int i = 0; i < allowDataUsage.size(); ++i) {
            ApplicationInfo app;
            String pkg = allowDataUsage.valueAt(i);
            if (LOGD) {
                Slog.d(TAG, "checking restricted background whitelisting for package " + pkg + " and user " + userId);
            }
            try {
                app = pm.getApplicationInfoAsUser(pkg, 0x100000, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
                if (!LOGD) continue;
                Slog.d(TAG, "No ApplicationInfo for package " + pkg);
                continue;
            }
            if (!app.isPrivilegedApp()) {
                Slog.e(TAG, "addDefaultRestrictBackgroundWhitelistUidsUL(): skipping non-privileged app  " + pkg);
                continue;
            }
            int uid = UserHandle.getUid(userId, app.uid);
            this.mDefaultRestrictBackgroundWhitelistUids.append(uid, true);
            if (LOGD) {
                Slog.d(TAG, "Adding uid " + uid + " (user " + userId + ") to default restricted background whitelist. Revoked status: " + this.mRestrictBackgroundWhitelistRevokedUids.get(uid));
            }
            if (this.mRestrictBackgroundWhitelistRevokedUids.get(uid)) continue;
            if (LOGD) {
                Slog.d(TAG, "adding default package " + pkg + " (uid " + uid + " for user " + userId + ") to restrict background whitelist");
            }
            this.setUidPolicyUncheckedUL(uid, 4, false);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initService(CountDownLatch initCompleteSignal) {
        Trace.traceBegin(0x200000L, "systemReady");
        int oldPriority = Process.getThreadPriority(Process.myTid());
        try {
            Process.setThreadPriority(-2);
            if (!this.isBandwidthControlEnabled()) {
                Slog.w(TAG, "bandwidth controls disabled, unable to enforce policy");
                return;
            }
            this.mUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
            this.mNetworkStats = LocalServices.getService(NetworkStatsManagerInternal.class);
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    this.updatePowerSaveWhitelistUL();
                    this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
                    this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                        @Override
                        public int getServiceType() {
                            return 6;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onLowPowerModeChanged(PowerSaveState result) {
                            boolean enabled = result.batterySaverEnabled;
                            if (LOGD) {
                                Slog.d(NetworkPolicyManagerService.TAG, "onLowPowerModeChanged(" + enabled + ")");
                            }
                            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                            synchronized (object) {
                                if (NetworkPolicyManagerService.this.mRestrictPower != enabled) {
                                    NetworkPolicyManagerService.this.mRestrictPower = enabled;
                                    NetworkPolicyManagerService.this.updateRulesForRestrictPowerUL();
                                }
                            }
                        }
                    });
                    this.mRestrictPower = this.mPowerManagerInternal.getLowPowerState((int)6).batterySaverEnabled;
                    this.mSystemReady = true;
                    this.waitForAdminData();
                    this.readPolicyAL();
                    this.mRestrictBackgroundBeforeBsm = this.mLoadedRestrictBackground;
                    this.mRestrictBackgroundPowerState = this.mPowerManagerInternal.getLowPowerState(10);
                    boolean localRestrictBackground = this.mRestrictBackgroundPowerState.batterySaverEnabled;
                    if (localRestrictBackground && !this.mLoadedRestrictBackground) {
                        this.mLoadedRestrictBackground = true;
                    }
                    this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                        @Override
                        public int getServiceType() {
                            return 10;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onLowPowerModeChanged(PowerSaveState result) {
                            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                            synchronized (object) {
                                NetworkPolicyManagerService.this.updateRestrictBackgroundByLowPowerModeUL(result);
                            }
                        }
                    });
                    if (this.addDefaultRestrictBackgroundWhitelistUidsUL()) {
                        this.writePolicyAL();
                    }
                    this.setRestrictBackgroundUL(this.mLoadedRestrictBackground);
                    this.updateRulesForGlobalChangeAL(false);
                    this.updateNotificationsNL();
                }
            }
            this.mActivityManagerInternal = LocalServices.getService(ActivityManagerInternal.class);
            try {
                this.mActivityManager.registerUidObserver(this.mUidObserver, 3, 6, "android");
                this.mNetworkManager.registerObserver(this.mAlertObserver);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            IntentFilter whitelistFilter = new IntentFilter("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
            this.mContext.registerReceiver(this.mPowerSaveWhitelistReceiver, whitelistFilter, null, this.mHandler);
            IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
            IntentFilter packageFilter = new IntentFilter();
            packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
            packageFilter.addDataScheme("package");
            this.mContext.registerReceiver(this.mPackageReceiver, packageFilter, null, this.mHandler);
            this.mContext.registerReceiver(this.mUidRemovedReceiver, new IntentFilter("android.intent.action.UID_REMOVED"), null, this.mHandler);
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_ADDED");
            userFilter.addAction("android.intent.action.USER_REMOVED");
            this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
            IntentFilter statsFilter = new IntentFilter("com.android.server.action.NETWORK_STATS_UPDATED");
            this.mContext.registerReceiver(this.mStatsReceiver, statsFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
            IntentFilter allowFilter = new IntentFilter(ACTION_ALLOW_BACKGROUND);
            this.mContext.registerReceiver(this.mAllowReceiver, allowFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
            this.mContext.registerReceiver(this.mSnoozeReceiver, new IntentFilter(ACTION_SNOOZE_WARNING), "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
            this.mContext.registerReceiver(this.mSnoozeReceiver, new IntentFilter(ACTION_SNOOZE_RAPID), "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
            IntentFilter wifiFilter = new IntentFilter("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
            this.mContext.registerReceiver(this.mWifiReceiver, wifiFilter, null, this.mHandler);
            IntentFilter carrierConfigFilter = new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED");
            this.mContext.registerReceiver(this.mCarrierConfigReceiver, carrierConfigFilter, null, this.mHandler);
            this.mContext.getSystemService(ConnectivityManager.class).registerNetworkCallback(new NetworkRequest.Builder().build(), this.mNetworkCallback);
            this.mUsageStats.addAppIdleStateChangeListener(new AppIdleStateChangeListener());
            this.mContext.getSystemService(SubscriptionManager.class).addOnSubscriptionsChangedListener(new SubscriptionManager.OnSubscriptionsChangedListener(this.mHandler.getLooper()){

                @Override
                public void onSubscriptionsChanged() {
                    NetworkPolicyManagerService.this.updateNetworksInternal();
                }
            });
            initCompleteSignal.countDown();
        }
        finally {
            Process.setThreadPriority(oldPriority);
            Trace.traceEnd(0x200000L);
        }
    }

    public CountDownLatch networkScoreAndNetworkManagementServiceReady() {
        this.mNetworkManagerReady = true;
        CountDownLatch initCompleteSignal = new CountDownLatch(1);
        this.mHandler.post(() -> this.initService(initCompleteSignal));
        return initCompleteSignal;
    }

    public void systemReady(CountDownLatch initCompleteSignal) {
        try {
            if (!initCompleteSignal.await(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Service NetworkPolicy init timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Service NetworkPolicy init interrupted", e);
        }
    }

    private static boolean updateCapabilityChange(SparseBooleanArray lastValues, boolean newValue, Network network) {
        boolean changed;
        boolean lastValue = lastValues.get(network.netId, false);
        boolean bl = changed = lastValue != newValue || lastValues.indexOfKey(network.netId) < 0;
        if (changed) {
            lastValues.put(network.netId, newValue);
        }
        return changed;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    void updateNotificationsNL() {
        int i;
        if (LOGV) {
            Slog.v(TAG, "updateNotificationsNL()");
        }
        Trace.traceBegin(0x200000L, "updateNotificationsNL");
        ArraySet<NotificationId> beforeNotifs = new ArraySet<NotificationId>(this.mActiveNotifs);
        this.mActiveNotifs.clear();
        long now = this.mClock.millis();
        for (i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            boolean snoozedRecently;
            boolean snoozedThisCycle;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            int subId = this.findRelevantSubIdNL(policy.template);
            if (subId == -1 || !policy.hasCycle()) continue;
            Pair<ZonedDateTime, ZonedDateTime> cycle = NetworkPolicyManager.cycleIterator(policy).next();
            long cycleStart = ((ZonedDateTime)cycle.first).toInstant().toEpochMilli();
            long cycleEnd = ((ZonedDateTime)cycle.second).toInstant().toEpochMilli();
            long totalBytes = this.getTotalBytes(policy.template, cycleStart, cycleEnd);
            PersistableBundle config = this.mCarrierConfigManager.getConfigForSubId(subId);
            if (!CarrierConfigManager.isConfigForIdentifiedCarrier(config)) {
                if (LOGV) {
                    Slog.v(TAG, "isConfigForIdentifiedCarrier returned false");
                }
                return;
            }
            boolean notifyWarning = NetworkPolicyManagerService.getBooleanDefeatingNullable(config, "data_warning_notification_bool", true);
            boolean notifyLimit = NetworkPolicyManagerService.getBooleanDefeatingNullable(config, "data_limit_notification_bool", true);
            boolean notifyRapid = NetworkPolicyManagerService.getBooleanDefeatingNullable(config, "data_rapid_notification_bool", true);
            if (notifyWarning && policy.isOverWarning(totalBytes) && !policy.isOverLimit(totalBytes)) {
                boolean bl = snoozedThisCycle = policy.lastWarningSnooze >= cycleStart;
                if (!snoozedThisCycle) {
                    this.enqueueNotification(policy, 34, totalBytes, null);
                }
            }
            if (notifyLimit) {
                if (policy.isOverLimit(totalBytes)) {
                    boolean bl = snoozedThisCycle = policy.lastLimitSnooze >= cycleStart;
                    if (snoozedThisCycle) {
                        this.enqueueNotification(policy, 36, totalBytes, null);
                    } else {
                        this.enqueueNotification(policy, 35, totalBytes, null);
                        this.notifyOverLimitNL(policy.template);
                    }
                } else {
                    this.notifyUnderLimitNL(policy.template);
                }
            }
            if (!notifyRapid || policy.limitBytes == -1L) continue;
            long recentDuration = TimeUnit.DAYS.toMillis(4L);
            long recentStart = now - recentDuration;
            long recentEnd = now;
            long recentBytes = this.getTotalBytes(policy.template, recentStart, recentEnd);
            long cycleDuration = cycleEnd - cycleStart;
            long projectedBytes = recentBytes * cycleDuration / recentDuration;
            long alertBytes = policy.limitBytes * 3L / 2L;
            if (LOGD) {
                Slog.d(TAG, "Rapid usage considering recent " + recentBytes + " projected " + projectedBytes + " alert " + alertBytes);
            }
            boolean bl = snoozedRecently = policy.lastRapidSnooze >= now - 86400000L;
            if (projectedBytes <= alertBytes || snoozedRecently) continue;
            this.enqueueNotification(policy, 45, 0L, this.findRapidBlame(policy.template, recentStart, recentEnd));
        }
        for (i = beforeNotifs.size() - 1; i >= 0; --i) {
            NotificationId notificationId = beforeNotifs.valueAt(i);
            if (this.mActiveNotifs.contains(notificationId)) continue;
            this.cancelNotification(notificationId);
        }
        Trace.traceEnd(0x200000L);
    }

    private ApplicationInfo findRapidBlame(NetworkTemplate template, long start, long end) {
        String[] packageNames;
        long totalBytes = 0L;
        long maxBytes = 0L;
        int maxUid = 0;
        NetworkStats stats = this.getNetworkUidBytes(template, start, end);
        NetworkStats.Entry entry = null;
        for (int i = 0; i < stats.size(); ++i) {
            entry = stats.getValues(i, entry);
            long bytes = entry.rxBytes + entry.txBytes;
            totalBytes += bytes;
            if (bytes <= maxBytes) continue;
            maxBytes = bytes;
            maxUid = entry.uid;
        }
        if (maxBytes > 0L && maxBytes > totalBytes / 2L && (packageNames = this.mContext.getPackageManager().getPackagesForUid(maxUid)) != null && packageNames.length == 1) {
            try {
                return this.mContext.getPackageManager().getApplicationInfo(packageNames[0], 4989440);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private int findRelevantSubIdNL(NetworkTemplate template) {
        for (int i = 0; i < this.mSubIdToSubscriberId.size(); ++i) {
            int subId = this.mSubIdToSubscriberId.keyAt(i);
            String subscriberId = this.mSubIdToSubscriberId.valueAt(i);
            NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true, true);
            if (!template.matches(probeIdent)) continue;
            return subId;
        }
        return -1;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private void notifyOverLimitNL(NetworkTemplate template) {
        if (!this.mOverLimitNotified.contains(template)) {
            this.mContext.startActivity(NetworkPolicyManagerService.buildNetworkOverLimitIntent(this.mContext.getResources(), template));
            this.mOverLimitNotified.add(template);
        }
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private void notifyUnderLimitNL(NetworkTemplate template) {
        this.mOverLimitNotified.remove(template);
    }

    private void enqueueNotification(NetworkPolicy policy, int type, long totalBytes, ApplicationInfo rapidBlame) {
        CharSequence body;
        CharSequence title;
        NotificationId notificationId = new NotificationId(policy, type);
        Notification.Builder builder = new Notification.Builder(this.mContext, SystemNotificationChannels.NETWORK_ALERTS);
        builder.setOnlyAlertOnce(true);
        builder.setWhen(0L);
        builder.setColor(this.mContext.getColor(17170460));
        Resources res = this.mContext.getResources();
        switch (type) {
            case 34: {
                title = res.getText(17039812);
                body = res.getString(17039811, Formatter.formatFileSize(this.mContext, totalBytes, 8));
                builder.setSmallIcon(17301624);
                Intent snoozeIntent = NetworkPolicyManagerService.buildSnoozeWarningIntent(policy.template);
                builder.setDeleteIntent(PendingIntent.getBroadcast(this.mContext, 0, snoozeIntent, 0x8000000));
                Intent viewIntent = NetworkPolicyManagerService.buildViewDataUsageIntent(res, policy.template);
                if (NetworkPolicyManagerService.isHeadlessSystemUserBuild()) {
                    builder.setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, viewIntent, 0x8000000, null, UserHandle.CURRENT));
                    break;
                }
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, viewIntent, 0x8000000));
                break;
            }
            case 35: {
                switch (policy.template.getMatchRule()) {
                    case 1: {
                        title = res.getText(17039805);
                        break;
                    }
                    case 4: {
                        title = res.getText(17039814);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                body = res.getText(17039802);
                builder.setOngoing(true);
                builder.setSmallIcon(17303509);
                Intent intent = NetworkPolicyManagerService.buildNetworkOverLimitIntent(res, policy.template);
                if (NetworkPolicyManagerService.isHeadlessSystemUserBuild()) {
                    builder.setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x8000000, null, UserHandle.CURRENT));
                    break;
                }
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
            case 36: {
                switch (policy.template.getMatchRule()) {
                    case 1: {
                        title = res.getText(17039804);
                        break;
                    }
                    case 4: {
                        title = res.getText(17039813);
                        break;
                    }
                    default: {
                        return;
                    }
                }
                long overBytes = totalBytes - policy.limitBytes;
                body = res.getString(17039803, Formatter.formatFileSize(this.mContext, overBytes, 8));
                builder.setOngoing(true);
                builder.setSmallIcon(17301624);
                builder.setChannelId(SystemNotificationChannels.NETWORK_STATUS);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(res, policy.template);
                if (NetworkPolicyManagerService.isHeadlessSystemUserBuild()) {
                    builder.setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x8000000, null, UserHandle.CURRENT));
                    break;
                }
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
            case 45: {
                title = res.getText(17039808);
                body = rapidBlame != null ? res.getString(17039806, rapidBlame.loadLabel(this.mContext.getPackageManager())) : res.getString(17039807);
                builder.setSmallIcon(17301624);
                Intent snoozeIntent = NetworkPolicyManagerService.buildSnoozeRapidIntent(policy.template);
                builder.setDeleteIntent(PendingIntent.getBroadcast(this.mContext, 0, snoozeIntent, 0x8000000));
                Intent viewIntent = NetworkPolicyManagerService.buildViewDataUsageIntent(res, policy.template);
                if (NetworkPolicyManagerService.isHeadlessSystemUserBuild()) {
                    builder.setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, viewIntent, 0x8000000, null, UserHandle.CURRENT));
                    break;
                }
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, viewIntent, 0x8000000));
                break;
            }
            default: {
                return;
            }
        }
        builder.setTicker(title);
        builder.setContentTitle(title);
        builder.setContentText(body);
        builder.setStyle(new Notification.BigTextStyle().bigText(body));
        this.mContext.getSystemService(NotificationManager.class).notifyAsUser(notificationId.getTag(), notificationId.getId(), builder.build(), UserHandle.ALL);
        this.mActiveNotifs.add(notificationId);
    }

    private void cancelNotification(NotificationId notificationId) {
        this.mContext.getSystemService(NotificationManager.class).cancel(notificationId.getTag(), notificationId.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworksInternal() {
        this.updateSubscriptions();
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                this.ensureActiveMobilePolicyAL();
                this.normalizePoliciesNL();
                this.updateNetworkEnabledNL();
                this.updateNetworkRulesNL();
                this.updateNotificationsNL();
            }
        }
    }

    @VisibleForTesting
    void updateNetworks() throws InterruptedException {
        this.updateNetworksInternal();
        CountDownLatch latch = new CountDownLatch(1);
        this.mHandler.post(() -> latch.countDown());
        latch.await(5L, TimeUnit.SECONDS);
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private boolean maybeUpdateMobilePolicyCycleAL(int subId, String subscriberId) {
        if (LOGV) {
            Slog.v(TAG, "maybeUpdateMobilePolicyCycleAL()");
        }
        boolean policyUpdated = false;
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true, true);
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkTemplate template = this.mNetworkPolicy.keyAt(i);
            if (!template.matches(probeIdent)) continue;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            policyUpdated |= this.updateDefaultMobilePolicyAL(subId, policy);
        }
        return policyUpdated;
    }

    @VisibleForTesting
    int getCycleDayFromCarrierConfig(PersistableBundle config, int fallbackCycleDay) {
        if (config == null) {
            return fallbackCycleDay;
        }
        int cycleDay = config.getInt("monthly_data_cycle_day_int");
        if (cycleDay == -1) {
            return fallbackCycleDay;
        }
        Calendar cal = Calendar.getInstance();
        if (cycleDay < cal.getMinimum(5) || cycleDay > cal.getMaximum(5)) {
            Slog.e(TAG, "Invalid date in CarrierConfigManager.KEY_MONTHLY_DATA_CYCLE_DAY_INT: " + cycleDay);
            return fallbackCycleDay;
        }
        return cycleDay;
    }

    @VisibleForTesting
    long getWarningBytesFromCarrierConfig(PersistableBundle config, long fallbackWarningBytes) {
        if (config == null) {
            return fallbackWarningBytes;
        }
        long warningBytes = config.getLong("data_warning_threshold_bytes_long");
        if (warningBytes == -2L) {
            return -1L;
        }
        if (warningBytes == -1L) {
            return this.getPlatformDefaultWarningBytes();
        }
        if (warningBytes < 0L) {
            Slog.e(TAG, "Invalid value in CarrierConfigManager.KEY_DATA_WARNING_THRESHOLD_BYTES_LONG; expected a non-negative value but got: " + warningBytes);
            return fallbackWarningBytes;
        }
        return warningBytes;
    }

    @VisibleForTesting
    long getLimitBytesFromCarrierConfig(PersistableBundle config, long fallbackLimitBytes) {
        if (config == null) {
            return fallbackLimitBytes;
        }
        long limitBytes = config.getLong("data_limit_threshold_bytes_long");
        if (limitBytes == -2L) {
            return -1L;
        }
        if (limitBytes == -1L) {
            return this.getPlatformDefaultLimitBytes();
        }
        if (limitBytes < 0L) {
            Slog.e(TAG, "Invalid value in CarrierConfigManager.KEY_DATA_LIMIT_THRESHOLD_BYTES_LONG; expected a non-negative value but got: " + limitBytes);
            return fallbackLimitBytes;
        }
        return limitBytes;
    }

    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    void handleNetworkPoliciesUpdateAL(boolean shouldNormalizePolicies) {
        if (shouldNormalizePolicies) {
            this.normalizePoliciesNL();
        }
        this.updateNetworkEnabledNL();
        this.updateNetworkRulesNL();
        this.updateNotificationsNL();
        this.writePolicyAL();
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    void updateNetworkEnabledNL() {
        if (LOGV) {
            Slog.v(TAG, "updateNetworkEnabledNL()");
        }
        Trace.traceBegin(0x200000L, "updateNetworkEnabledNL");
        long startTime = this.mStatLogger.getTime();
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            long end;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (policy.limitBytes == -1L || !policy.hasCycle()) {
                this.setNetworkTemplateEnabled(policy.template, true);
                continue;
            }
            Pair<ZonedDateTime, ZonedDateTime> cycle = NetworkPolicyManager.cycleIterator(policy).next();
            long start = ((ZonedDateTime)cycle.first).toInstant().toEpochMilli();
            long totalBytes = this.getTotalBytes(policy.template, start, end = ((ZonedDateTime)cycle.second).toInstant().toEpochMilli());
            boolean overLimitWithoutSnooze = policy.isOverLimit(totalBytes) && policy.lastLimitSnooze < start;
            boolean networkEnabled = !overLimitWithoutSnooze;
            this.setNetworkTemplateEnabled(policy.template, networkEnabled);
        }
        this.mStatLogger.logDurationStat(0, startTime);
        Trace.traceEnd(0x200000L);
    }

    private void setNetworkTemplateEnabled(NetworkTemplate template, boolean enabled) {
        this.mHandler.obtainMessage(18, enabled ? 1 : 0, 0, template).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNetworkTemplateEnabledInner(NetworkTemplate template, boolean enabled) {
        if (template.getMatchRule() == 1) {
            int subId;
            int i;
            IntArray matchingSubIds = new IntArray();
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                for (i = 0; i < this.mSubIdToSubscriberId.size(); ++i) {
                    subId = this.mSubIdToSubscriberId.keyAt(i);
                    String subscriberId = this.mSubIdToSubscriberId.valueAt(i);
                    NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true, true);
                    if (!template.matches(probeIdent)) continue;
                    matchingSubIds.add(subId);
                }
            }
            TelephonyManager tm = this.mContext.getSystemService(TelephonyManager.class);
            for (i = 0; i < matchingSubIds.size(); ++i) {
                subId = matchingSubIds.get(i);
                tm.setPolicyDataEnabled(enabled, subId);
            }
        }
    }

    private static void collectIfaces(ArraySet<String> ifaces, NetworkState state) {
        String baseIface = state.linkProperties.getInterfaceName();
        if (baseIface != null) {
            ifaces.add(baseIface);
        }
        for (LinkProperties stackedLink : state.linkProperties.getStackedLinks()) {
            String stackedIface = stackedLink.getInterfaceName();
            if (stackedIface == null) continue;
            ifaces.add(stackedIface);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSubscriptions() {
        if (LOGV) {
            Slog.v(TAG, "updateSubscriptions()");
        }
        Trace.traceBegin(0x200000L, "updateSubscriptions");
        TelephonyManager tm = this.mContext.getSystemService(TelephonyManager.class);
        SubscriptionManager sm = this.mContext.getSystemService(SubscriptionManager.class);
        int[] subIds = ArrayUtils.defeatNullable(sm.getActiveSubscriptionIdList());
        String[] mergedSubscriberIds = ArrayUtils.defeatNullable(tm.getMergedSubscriberIds());
        SparseArray<String> subIdToSubscriberId = new SparseArray<String>(subIds.length);
        for (int subId : subIds) {
            String subscriberId = tm.getSubscriberId(subId);
            if (!TextUtils.isEmpty(subscriberId)) {
                subIdToSubscriberId.put(subId, subscriberId);
                continue;
            }
            Slog.wtf(TAG, "Missing subscriberId for subId " + subId);
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            this.mSubIdToSubscriberId.clear();
            for (int i = 0; i < subIdToSubscriberId.size(); ++i) {
                this.mSubIdToSubscriberId.put(subIdToSubscriberId.keyAt(i), (String)subIdToSubscriberId.valueAt(i));
            }
            this.mMergedSubscriberIds = mergedSubscriberIds;
        }
        Trace.traceEnd(0x200000L);
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    void updateNetworkRulesNL() {
        NetworkState[] states;
        if (LOGV) {
            Slog.v(TAG, "updateNetworkRulesNL()");
        }
        Trace.traceBegin(0x200000L, "updateNetworkRulesNL");
        try {
            states = NetworkPolicyManagerService.defeatNullable(this.mConnManager.getAllNetworkState());
        }
        catch (RemoteException e) {
            return;
        }
        this.mNetIdToSubId.clear();
        ArrayMap<NetworkState, NetworkIdentity> identified = new ArrayMap<NetworkState, NetworkIdentity>();
        for (NetworkState state : states) {
            if (state.network != null) {
                this.mNetIdToSubId.put(state.network.netId, this.parseSubId(state));
            }
            if (state.networkInfo == null || !state.networkInfo.isConnected()) continue;
            NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state, true);
            identified.put(state, ident);
        }
        ArraySet<Object> newMeteredIfaces = new ArraySet<Object>();
        long lowestRule = Long.MAX_VALUE;
        ArraySet<String> matchingIfaces = new ArraySet<String>();
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            boolean hasLimit;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            matchingIfaces.clear();
            for (int j = identified.size() - 1; j >= 0; --j) {
                if (!policy.template.matches((NetworkIdentity)identified.valueAt(j))) continue;
                NetworkPolicyManagerService.collectIfaces(matchingIfaces, (NetworkState)identified.keyAt(j));
            }
            if (LOGD) {
                Slog.d(TAG, "Applying " + policy + " to ifaces " + matchingIfaces);
            }
            int hasWarning = policy.warningBytes != -1L ? 1 : 0;
            boolean bl = hasLimit = policy.limitBytes != -1L;
            if (hasLimit || policy.metered) {
                long quotaBytes;
                if (hasLimit && policy.hasCycle()) {
                    Pair<ZonedDateTime, ZonedDateTime> cycle = NetworkPolicyManager.cycleIterator(policy).next();
                    long start = ((ZonedDateTime)cycle.first).toInstant().toEpochMilli();
                    long end = ((ZonedDateTime)cycle.second).toInstant().toEpochMilli();
                    long totalBytes = this.getTotalBytes(policy.template, start, end);
                    quotaBytes = policy.lastLimitSnooze >= start ? Long.MAX_VALUE : Math.max(1L, policy.limitBytes - totalBytes);
                } else {
                    quotaBytes = Long.MAX_VALUE;
                }
                if (matchingIfaces.size() > 1) {
                    Slog.w(TAG, "shared quota unsupported; generating rule for each iface");
                }
                for (int j = matchingIfaces.size() - 1; j >= 0; --j) {
                    String iface = matchingIfaces.valueAt(j);
                    this.setInterfaceQuotaAsync(iface, quotaBytes);
                    newMeteredIfaces.add(iface);
                }
            }
            if (hasWarning != 0 && policy.warningBytes < lowestRule) {
                lowestRule = policy.warningBytes;
            }
            if (!hasLimit || policy.limitBytes >= lowestRule) continue;
            lowestRule = policy.limitBytes;
        }
        for (NetworkState state : states) {
            if (state.networkInfo == null || !state.networkInfo.isConnected() || state.networkCapabilities.hasCapability(11)) continue;
            matchingIfaces.clear();
            NetworkPolicyManagerService.collectIfaces(matchingIfaces, state);
            for (int j = matchingIfaces.size() - 1; j >= 0; --j) {
                NetworkState[] iface = matchingIfaces.valueAt(j);
                if (newMeteredIfaces.contains(iface)) continue;
                this.setInterfaceQuotaAsync((String)iface, Long.MAX_VALUE);
                newMeteredIfaces.add(iface);
            }
        }
        for (int i = this.mMeteredIfaces.size() - 1; i >= 0; --i) {
            String iface = this.mMeteredIfaces.valueAt(i);
            if (newMeteredIfaces.contains(iface)) continue;
            this.removeInterfaceQuotaAsync(iface);
        }
        this.mMeteredIfaces = newMeteredIfaces;
        ContentResolver cr = this.mContext.getContentResolver();
        boolean quotaEnabled = Settings.Global.getInt(cr, "netpolicy_quota_enabled", 1) != 0;
        long quotaUnlimited = Settings.Global.getLong(cr, "netpolicy_quota_unlimited", QUOTA_UNLIMITED_DEFAULT);
        float quotaLimited = Settings.Global.getFloat(cr, "netpolicy_quota_limited", 0.1f);
        this.mSubscriptionOpportunisticQuota.clear();
        for (NetworkState state : states) {
            long quotaBytes;
            int subId;
            SubscriptionPlan plan;
            if (!quotaEnabled || state.network == null || (plan = this.getPrimarySubscriptionPlanLocked(subId = this.getSubIdLocked(state.network))) == null) continue;
            long limitBytes = plan.getDataLimitBytes();
            if (!state.networkCapabilities.hasCapability(18)) {
                quotaBytes = 0L;
            } else if (limitBytes == -1L) {
                quotaBytes = -1L;
            } else if (limitBytes == Long.MAX_VALUE) {
                quotaBytes = quotaUnlimited;
            } else {
                Range<ZonedDateTime> cycle = plan.cycleIterator().next();
                long start = cycle.getLower().toInstant().toEpochMilli();
                long end = cycle.getUpper().toInstant().toEpochMilli();
                Instant now = this.mClock.instant();
                long startOfDay = ZonedDateTime.ofInstant(now, cycle.getLower().getZone()).truncatedTo(ChronoUnit.DAYS).toInstant().toEpochMilli();
                long totalBytes = this.getTotalBytes(NetworkTemplate.buildTemplateMobileAll(state.subscriberId), start, startOfDay);
                long remainingBytes = limitBytes - totalBytes;
                long remainingDays = 1L + (end - now.toEpochMilli() - 1L) / TimeUnit.DAYS.toMillis(1L);
                quotaBytes = Math.max(0L, (long)((float)(remainingBytes / remainingDays) * quotaLimited));
            }
            this.mSubscriptionOpportunisticQuota.put(subId, quotaBytes);
        }
        String[] meteredIfaces = this.mMeteredIfaces.toArray(new String[this.mMeteredIfaces.size()]);
        this.mHandler.obtainMessage(2, meteredIfaces).sendToTarget();
        this.mHandler.obtainMessage(7, lowestRule).sendToTarget();
        Trace.traceEnd(0x200000L);
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private void ensureActiveMobilePolicyAL() {
        if (LOGV) {
            Slog.v(TAG, "ensureActiveMobilePolicyAL()");
        }
        if (this.mSuppressDefaultPolicy) {
            return;
        }
        for (int i = 0; i < this.mSubIdToSubscriberId.size(); ++i) {
            int subId = this.mSubIdToSubscriberId.keyAt(i);
            String subscriberId = this.mSubIdToSubscriberId.valueAt(i);
            this.ensureActiveMobilePolicyAL(subId, subscriberId);
        }
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private boolean ensureActiveMobilePolicyAL(int subId, String subscriberId) {
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false, true, true);
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkTemplate template = this.mNetworkPolicy.keyAt(i);
            if (!template.matches(probeIdent)) continue;
            if (LOGD) {
                Slog.d(TAG, "Found template " + template + " which matches subscriber " + NetworkIdentity.scrubSubscriberId(subscriberId));
            }
            return false;
        }
        Slog.i(TAG, "No policy for subscriber " + NetworkIdentity.scrubSubscriberId(subscriberId) + "; generating default policy");
        NetworkPolicy policy = this.buildDefaultMobilePolicy(subId, subscriberId);
        this.addNetworkPolicyAL(policy);
        return true;
    }

    private long getPlatformDefaultWarningBytes() {
        int dataWarningConfig = this.mContext.getResources().getInteger(17694853);
        if ((long)dataWarningConfig == -1L) {
            return -1L;
        }
        return (long)dataWarningConfig * 0x100000L;
    }

    private long getPlatformDefaultLimitBytes() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    NetworkPolicy buildDefaultMobilePolicy(int subId, String subscriberId) {
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
        RecurrenceRule cycleRule = NetworkPolicy.buildRule(ZonedDateTime.now().getDayOfMonth(), ZoneId.systemDefault());
        NetworkPolicy policy = new NetworkPolicy(template, cycleRule, this.getPlatformDefaultWarningBytes(), this.getPlatformDefaultLimitBytes(), -1L, -1L, true, true);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                this.updateDefaultMobilePolicyAL(subId, policy);
            }
        }
        return policy;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private boolean updateDefaultMobilePolicyAL(int subId, NetworkPolicy policy) {
        if (!policy.inferred) {
            if (LOGD) {
                Slog.d(TAG, "Ignoring user-defined policy " + policy);
            }
            return false;
        }
        NetworkPolicy original = new NetworkPolicy(policy.template, policy.cycleRule, policy.warningBytes, policy.limitBytes, policy.lastWarningSnooze, policy.lastLimitSnooze, policy.metered, policy.inferred);
        SubscriptionPlan[] plans = this.mSubscriptionPlans.get(subId);
        if (!ArrayUtils.isEmpty(plans)) {
            SubscriptionPlan plan = plans[0];
            policy.cycleRule = plan.getCycleRule();
            long planLimitBytes = plan.getDataLimitBytes();
            if (planLimitBytes == -1L) {
                policy.warningBytes = this.getPlatformDefaultWarningBytes();
                policy.limitBytes = this.getPlatformDefaultLimitBytes();
            } else if (planLimitBytes == Long.MAX_VALUE) {
                policy.warningBytes = -1L;
                policy.limitBytes = -1L;
            } else {
                policy.warningBytes = planLimitBytes * 9L / 10L;
                switch (plan.getDataLimitBehavior()) {
                    case 0: 
                    case 1: {
                        policy.limitBytes = planLimitBytes;
                        break;
                    }
                    default: {
                        policy.limitBytes = -1L;
                    }
                }
            }
        } else {
            PersistableBundle config = this.mCarrierConfigManager.getConfigForSubId(subId);
            int currentCycleDay = policy.cycleRule.isMonthly() ? policy.cycleRule.start.getDayOfMonth() : -1;
            int cycleDay = this.getCycleDayFromCarrierConfig(config, currentCycleDay);
            policy.cycleRule = NetworkPolicy.buildRule(cycleDay, ZoneId.systemDefault());
            policy.warningBytes = this.getWarningBytesFromCarrierConfig(config, policy.warningBytes);
            policy.limitBytes = this.getLimitBytesFromCarrierConfig(config, policy.limitBytes);
        }
        if (policy.equals(original)) {
            return false;
        }
        Slog.d(TAG, "Updated " + original + " to " + policy);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    private void readPolicyAL() {
        if (LOGV) {
            Slog.v(TAG, "readPolicyAL()");
        }
        this.mNetworkPolicy.clear();
        this.mSubscriptionPlans.clear();
        this.mSubscriptionPlansOwner.clear();
        this.mUidPolicy.clear();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mPolicyFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            SparseBooleanArray whitelistedRestrictBackground = new SparseBooleanArray();
            int version = 1;
            boolean insideWhitelist = false;
            while ((type = in.next()) != 1) {
                String tag = in.getName();
                if (type == 2) {
                    if (TAG_POLICY_LIST.equals(tag)) {
                        boolean oldValue = this.mRestrictBackground;
                        version = XmlUtils.readIntAttribute(in, ATTR_VERSION);
                        this.mLoadedRestrictBackground = version >= 3 && XmlUtils.readBooleanAttribute(in, ATTR_RESTRICT_BACKGROUND);
                        continue;
                    }
                    if (TAG_NETWORK_POLICY.equals(tag)) {
                        boolean metered;
                        RecurrenceRule cycleRule;
                        int networkTemplate = XmlUtils.readIntAttribute(in, ATTR_NETWORK_TEMPLATE);
                        String subscriberId = in.getAttributeValue(null, ATTR_SUBSCRIBER_ID);
                        String networkId = version >= 9 ? in.getAttributeValue(null, ATTR_NETWORK_ID) : null;
                        if (version >= 11) {
                            String start = XmlUtils.readStringAttribute(in, ATTR_CYCLE_START);
                            String end = XmlUtils.readStringAttribute(in, ATTR_CYCLE_END);
                            String period = XmlUtils.readStringAttribute(in, ATTR_CYCLE_PERIOD);
                            cycleRule = new RecurrenceRule(RecurrenceRule.convertZonedDateTime(start), RecurrenceRule.convertZonedDateTime(end), RecurrenceRule.convertPeriod(period));
                        } else {
                            int cycleDay = XmlUtils.readIntAttribute(in, ATTR_CYCLE_DAY);
                            String cycleTimezone = version >= 6 ? in.getAttributeValue(null, ATTR_CYCLE_TIMEZONE) : "UTC";
                            cycleRule = NetworkPolicy.buildRule(cycleDay, ZoneId.of(cycleTimezone));
                        }
                        long warningBytes = XmlUtils.readLongAttribute(in, ATTR_WARNING_BYTES);
                        long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES);
                        long lastLimitSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_LIMIT_SNOOZE) : (version >= 2 ? XmlUtils.readLongAttribute(in, ATTR_LAST_SNOOZE) : -1L);
                        if (version >= 4) {
                            metered = XmlUtils.readBooleanAttribute(in, ATTR_METERED);
                        } else {
                            switch (networkTemplate) {
                                case 1: {
                                    metered = true;
                                    break;
                                }
                                default: {
                                    metered = false;
                                }
                            }
                        }
                        long lastWarningSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_WARNING_SNOOZE) : -1L;
                        boolean inferred = version >= 7 ? XmlUtils.readBooleanAttribute(in, ATTR_INFERRED) : false;
                        NetworkTemplate template = new NetworkTemplate(networkTemplate, subscriberId, networkId);
                        if (!template.isPersistable()) continue;
                        this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleRule, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, metered, inferred));
                        continue;
                    }
                    if (TAG_SUBSCRIPTION_PLAN.equals(tag)) {
                        String start = XmlUtils.readStringAttribute(in, ATTR_CYCLE_START);
                        String end = XmlUtils.readStringAttribute(in, ATTR_CYCLE_END);
                        String period = XmlUtils.readStringAttribute(in, ATTR_CYCLE_PERIOD);
                        SubscriptionPlan.Builder builder = new SubscriptionPlan.Builder(RecurrenceRule.convertZonedDateTime(start), RecurrenceRule.convertZonedDateTime(end), RecurrenceRule.convertPeriod(period));
                        builder.setTitle(XmlUtils.readStringAttribute(in, ATTR_TITLE));
                        builder.setSummary(XmlUtils.readStringAttribute(in, ATTR_SUMMARY));
                        long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES, -1L);
                        int limitBehavior = XmlUtils.readIntAttribute(in, ATTR_LIMIT_BEHAVIOR, -1);
                        if (limitBytes != -1L && limitBehavior != -1) {
                            builder.setDataLimit(limitBytes, limitBehavior);
                        }
                        long usageBytes = XmlUtils.readLongAttribute(in, ATTR_USAGE_BYTES, -1L);
                        long usageTime = XmlUtils.readLongAttribute(in, ATTR_USAGE_TIME, -1L);
                        if (usageBytes != -1L && usageTime != -1L) {
                            builder.setDataUsage(usageBytes, usageTime);
                        }
                        int subId = XmlUtils.readIntAttribute(in, ATTR_SUB_ID);
                        SubscriptionPlan plan = builder.build();
                        this.mSubscriptionPlans.put(subId, ArrayUtils.appendElement(SubscriptionPlan.class, this.mSubscriptionPlans.get(subId), plan));
                        String ownerPackage = XmlUtils.readStringAttribute(in, ATTR_OWNER_PACKAGE);
                        this.mSubscriptionPlansOwner.put(subId, ownerPackage);
                        continue;
                    }
                    if (TAG_UID_POLICY.equals(tag)) {
                        int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                        int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                        if (UserHandle.isApp(uid)) {
                            this.setUidPolicyUncheckedUL(uid, policy, false);
                            continue;
                        }
                        Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                        continue;
                    }
                    if (TAG_APP_POLICY.equals(tag)) {
                        int appId = XmlUtils.readIntAttribute(in, ATTR_APP_ID);
                        int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                        int uid = UserHandle.getUid(0, appId);
                        if (UserHandle.isApp(uid)) {
                            this.setUidPolicyUncheckedUL(uid, policy, false);
                            continue;
                        }
                        Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                        continue;
                    }
                    if (TAG_WHITELIST.equals(tag)) {
                        insideWhitelist = true;
                        continue;
                    }
                    if (TAG_RESTRICT_BACKGROUND.equals(tag) && insideWhitelist) {
                        int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                        whitelistedRestrictBackground.append(uid, true);
                        continue;
                    }
                    if (!TAG_REVOKED_RESTRICT_BACKGROUND.equals(tag) || !insideWhitelist) continue;
                    int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                    this.mRestrictBackgroundWhitelistRevokedUids.put(uid, true);
                    continue;
                }
                if (type != 3 || !TAG_WHITELIST.equals(tag)) continue;
                insideWhitelist = false;
            }
            int size = whitelistedRestrictBackground.size();
            for (int i = 0; i < size; ++i) {
                int uid = whitelistedRestrictBackground.keyAt(i);
                int policy = this.mUidPolicy.get(uid, 0);
                if ((policy & 1) != 0) {
                    Slog.w(TAG, "ignoring restrict-background-whitelist for " + uid + " because its policy is " + NetworkPolicyManager.uidPoliciesToString(policy));
                    continue;
                }
                if (UserHandle.isApp(uid)) {
                    int newPolicy = policy | 4;
                    if (LOGV) {
                        Log.v(TAG, "new policy for " + uid + ": " + NetworkPolicyManager.uidPoliciesToString(newPolicy));
                    }
                    this.setUidPolicyUncheckedUL(uid, newPolicy, false);
                    continue;
                }
                Slog.w(TAG, "unable to update policy on UID " + uid);
            }
        }
        catch (FileNotFoundException e) {
            this.upgradeDefaultBackgroundDataUL();
        }
        catch (Exception e) {
            Log.wtf(TAG, "problem reading network policy", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    private void upgradeDefaultBackgroundDataUL() {
        this.mLoadedRestrictBackground = Settings.Global.getInt(this.mContext.getContentResolver(), "default_restrict_background_data", 0) == 1;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock", "mUidRulesFirstLock"})
    private void upgradeWifiMeteredOverrideAL() {
        boolean modified = false;
        WifiManager wm = this.mContext.getSystemService(WifiManager.class);
        List<WifiConfiguration> configs = wm.getConfiguredNetworks();
        int i = 0;
        while (i < this.mNetworkPolicy.size()) {
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (policy.template.getMatchRule() == 4 && !policy.inferred) {
                this.mNetworkPolicy.removeAt(i);
                modified = true;
                String networkId = NetworkPolicyManager.resolveNetworkId(policy.template.getNetworkId());
                for (WifiConfiguration config : configs) {
                    if (!Objects.equals(NetworkPolicyManager.resolveNetworkId(config), networkId)) continue;
                    Slog.d(TAG, "Found network " + networkId + "; upgrading metered hint");
                    config.meteredOverride = policy.metered ? 1 : 2;
                    wm.updateNetwork(config);
                }
                continue;
            }
            ++i;
        }
        if (modified) {
            this.writePolicyAL();
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    void writePolicyAL() {
        block10: {
            if (LOGV) {
                Slog.v(TAG, "writePolicyAL()");
            }
            FileOutputStream fos = null;
            try {
                int i;
                fos = this.mPolicyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_POLICY_LIST);
                XmlUtils.writeIntAttribute(out, ATTR_VERSION, 11);
                XmlUtils.writeBooleanAttribute(out, ATTR_RESTRICT_BACKGROUND, this.mRestrictBackground);
                for (i = 0; i < this.mNetworkPolicy.size(); ++i) {
                    String networkId;
                    NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
                    NetworkTemplate template = policy.template;
                    if (!template.isPersistable()) continue;
                    out.startTag(null, TAG_NETWORK_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_NETWORK_TEMPLATE, template.getMatchRule());
                    String subscriberId = template.getSubscriberId();
                    if (subscriberId != null) {
                        out.attribute(null, ATTR_SUBSCRIBER_ID, subscriberId);
                    }
                    if ((networkId = template.getNetworkId()) != null) {
                        out.attribute(null, ATTR_NETWORK_ID, networkId);
                    }
                    XmlUtils.writeStringAttribute(out, ATTR_CYCLE_START, RecurrenceRule.convertZonedDateTime(policy.cycleRule.start));
                    XmlUtils.writeStringAttribute(out, ATTR_CYCLE_END, RecurrenceRule.convertZonedDateTime(policy.cycleRule.end));
                    XmlUtils.writeStringAttribute(out, ATTR_CYCLE_PERIOD, RecurrenceRule.convertPeriod(policy.cycleRule.period));
                    XmlUtils.writeLongAttribute(out, ATTR_WARNING_BYTES, policy.warningBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LIMIT_BYTES, policy.limitBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_WARNING_SNOOZE, policy.lastWarningSnooze);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_LIMIT_SNOOZE, policy.lastLimitSnooze);
                    XmlUtils.writeBooleanAttribute(out, ATTR_METERED, policy.metered);
                    XmlUtils.writeBooleanAttribute(out, ATTR_INFERRED, policy.inferred);
                    out.endTag(null, TAG_NETWORK_POLICY);
                }
                for (i = 0; i < this.mSubscriptionPlans.size(); ++i) {
                    int subId = this.mSubscriptionPlans.keyAt(i);
                    String ownerPackage = this.mSubscriptionPlansOwner.get(subId);
                    SubscriptionPlan[] plans = this.mSubscriptionPlans.valueAt(i);
                    if (ArrayUtils.isEmpty(plans)) continue;
                    for (SubscriptionPlan plan : plans) {
                        out.startTag(null, TAG_SUBSCRIPTION_PLAN);
                        XmlUtils.writeIntAttribute(out, ATTR_SUB_ID, subId);
                        XmlUtils.writeStringAttribute(out, ATTR_OWNER_PACKAGE, ownerPackage);
                        RecurrenceRule cycleRule = plan.getCycleRule();
                        XmlUtils.writeStringAttribute(out, ATTR_CYCLE_START, RecurrenceRule.convertZonedDateTime(cycleRule.start));
                        XmlUtils.writeStringAttribute(out, ATTR_CYCLE_END, RecurrenceRule.convertZonedDateTime(cycleRule.end));
                        XmlUtils.writeStringAttribute(out, ATTR_CYCLE_PERIOD, RecurrenceRule.convertPeriod(cycleRule.period));
                        XmlUtils.writeStringAttribute(out, ATTR_TITLE, plan.getTitle());
                        XmlUtils.writeStringAttribute(out, ATTR_SUMMARY, plan.getSummary());
                        XmlUtils.writeLongAttribute(out, ATTR_LIMIT_BYTES, plan.getDataLimitBytes());
                        XmlUtils.writeIntAttribute(out, ATTR_LIMIT_BEHAVIOR, plan.getDataLimitBehavior());
                        XmlUtils.writeLongAttribute(out, ATTR_USAGE_BYTES, plan.getDataUsageBytes());
                        XmlUtils.writeLongAttribute(out, ATTR_USAGE_TIME, plan.getDataUsageTime());
                        out.endTag(null, TAG_SUBSCRIPTION_PLAN);
                    }
                }
                for (i = 0; i < this.mUidPolicy.size(); ++i) {
                    int uid = this.mUidPolicy.keyAt(i);
                    int policy = this.mUidPolicy.valueAt(i);
                    if (policy == 0) continue;
                    out.startTag(null, TAG_UID_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    XmlUtils.writeIntAttribute(out, ATTR_POLICY, policy);
                    out.endTag(null, TAG_UID_POLICY);
                }
                out.endTag(null, TAG_POLICY_LIST);
                out.startTag(null, TAG_WHITELIST);
                int size = this.mRestrictBackgroundWhitelistRevokedUids.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    int uid = this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i2);
                    out.startTag(null, TAG_REVOKED_RESTRICT_BACKGROUND);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    out.endTag(null, TAG_REVOKED_RESTRICT_BACKGROUND);
                }
                out.endTag(null, TAG_WHITELIST);
                out.endDocument();
                this.mPolicyFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block10;
                this.mPolicyFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            long token = Binder.clearCallingIdentity();
            try {
                int oldPolicy = this.mUidPolicy.get(uid, 0);
                if (oldPolicy != policy) {
                    this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
                    this.mLogger.uidPolicyChanged(uid, oldPolicy, policy);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            if (oldPolicy != (policy |= oldPolicy)) {
                this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
                this.mLogger.uidPolicyChanged(uid, oldPolicy, policy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            policy = oldPolicy & ~policy;
            if (oldPolicy != policy) {
                this.setUidPolicyUncheckedUL(uid, oldPolicy, policy, true);
                this.mLogger.uidPolicyChanged(uid, oldPolicy, policy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    private void setUidPolicyUncheckedUL(int uid, int oldPolicy, int policy, boolean persist) {
        boolean notifyApp;
        this.setUidPolicyUncheckedUL(uid, policy, false);
        if (!this.isUidValidForWhitelistRules(uid)) {
            notifyApp = false;
        } else {
            boolean isBlocked;
            boolean wasBlacklisted = oldPolicy == 1;
            boolean isBlacklisted = policy == 1;
            boolean wasWhitelisted = oldPolicy == 4;
            boolean isWhitelisted = policy == 4;
            boolean wasBlocked = wasBlacklisted || this.mRestrictBackground && !wasWhitelisted;
            boolean bl = isBlocked = isBlacklisted || this.mRestrictBackground && !isWhitelisted;
            if (wasWhitelisted && (!isWhitelisted || isBlacklisted) && this.mDefaultRestrictBackgroundWhitelistUids.get(uid) && !this.mRestrictBackgroundWhitelistRevokedUids.get(uid)) {
                if (LOGD) {
                    Slog.d(TAG, "Adding uid " + uid + " to revoked restrict background whitelist");
                }
                this.mRestrictBackgroundWhitelistRevokedUids.append(uid, true);
            }
            notifyApp = wasBlocked != isBlocked;
        }
        this.mHandler.obtainMessage(13, uid, policy, notifyApp).sendToTarget();
        if (persist) {
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                this.writePolicyAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    private void setUidPolicyUncheckedUL(int uid, int policy, boolean persist) {
        if (policy == 0) {
            this.mUidPolicy.delete(uid);
        } else {
            this.mUidPolicy.put(uid, policy);
        }
        this.updateRulesForDataUsageRestrictionsUL(uid);
        if (persist) {
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                this.writePolicyAL();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidPolicy(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.mUidPolicy.get(uid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getUidsWithPolicy(int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        int[] uids = new int[]{};
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int uidPolicy = this.mUidPolicy.valueAt(i);
                if ((policy != 0 || uidPolicy != 0) && (uidPolicy & policy) == 0) continue;
                uids = ArrayUtils.appendInt(uids, uid);
            }
        }
        return uids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    boolean removeUserStateUL(int userId, boolean writePolicy) {
        this.mLogger.removingUserState(userId);
        boolean changed = false;
        for (int i = this.mRestrictBackgroundWhitelistRevokedUids.size() - 1; i >= 0; --i) {
            int uid = this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            this.mRestrictBackgroundWhitelistRevokedUids.removeAt(i);
            changed = true;
        }
        int[] uids = new int[]{};
        for (int i = 0; i < this.mUidPolicy.size(); ++i) {
            int uid = this.mUidPolicy.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            uids = ArrayUtils.appendInt(uids, uid);
        }
        if (uids.length > 0) {
            for (int uid : uids) {
                this.mUidPolicy.delete(uid);
            }
            changed = true;
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            this.updateRulesForGlobalChangeAL(true);
            if (writePolicy && changed) {
                this.writePolicyAL();
            }
        }
        return changed;
    }

    @Override
    public void registerListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.register(listener);
    }

    @Override
    public void unregisterListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkPolicies(NetworkPolicy[] policies) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    this.normalizePoliciesNL(policies);
                    this.handleNetworkPoliciesUpdateAL(false);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void addNetworkPolicyAL(NetworkPolicy policy) {
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        policies = ArrayUtils.appendElement(NetworkPolicy.class, policies, policy);
        this.setNetworkPolicies(policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkPolicy[] getNetworkPolicies(String callingPackage) {
        block6: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", TAG);
            }
            catch (SecurityException e) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", TAG);
                if (this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0) break block6;
                return new NetworkPolicy[0];
            }
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            int size = this.mNetworkPolicy.size();
            NetworkPolicy[] policies = new NetworkPolicy[size];
            for (int i = 0; i < size; ++i) {
                policies[i] = this.mNetworkPolicy.valueAt(i);
            }
            return policies;
        }
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private void normalizePoliciesNL() {
        this.normalizePoliciesNL(this.getNetworkPolicies(this.mContext.getOpPackageName()));
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private void normalizePoliciesNL(NetworkPolicy[] policies) {
        this.mNetworkPolicy.clear();
        for (NetworkPolicy policy : policies) {
            if (policy == null) continue;
            policy.template = NetworkTemplate.normalize(policy.template, this.mMergedSubscriberIds);
            NetworkPolicy existing = this.mNetworkPolicy.get(policy.template);
            if (existing != null && existing.compareTo(policy) <= 0) continue;
            if (existing != null) {
                Slog.d(TAG, "Normalization replaced " + existing + " with " + policy);
            }
            this.mNetworkPolicy.put(policy.template, policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snoozeLimit(NetworkTemplate template) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.performSnooze(template, 35);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performSnooze(NetworkTemplate template, int type) {
        long currentTime = this.mClock.millis();
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                NetworkPolicy policy = this.mNetworkPolicy.get(template);
                if (policy == null) {
                    throw new IllegalArgumentException("unable to find policy for " + template);
                }
                switch (type) {
                    case 34: {
                        policy.lastWarningSnooze = currentTime;
                        break;
                    }
                    case 35: {
                        policy.lastLimitSnooze = currentTime;
                        break;
                    }
                    case 45: {
                        policy.lastRapidSnooze = currentTime;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("unexpected type");
                    }
                }
                this.handleNetworkPoliciesUpdateAL(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTetheringChanged(String iface, boolean tethering) {
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            if (this.mRestrictBackground && tethering) {
                Log.d(TAG, "Tethering on (" + iface + "); disable Data Saver");
                this.setRestrictBackground(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictBackground(boolean restrictBackground) {
        Trace.traceBegin(0x200000L, "setRestrictBackground");
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
            long token = Binder.clearCallingIdentity();
            try {
                Object object = this.mUidRulesFirstLock;
                synchronized (object) {
                    this.setRestrictBackgroundUL(restrictBackground);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    private void setRestrictBackgroundUL(boolean restrictBackground) {
        Trace.traceBegin(0x200000L, "setRestrictBackgroundUL");
        try {
            if (restrictBackground == this.mRestrictBackground) {
                Slog.w(TAG, "setRestrictBackgroundUL: already " + restrictBackground);
                return;
            }
            Slog.d(TAG, "setRestrictBackgroundUL(): " + restrictBackground);
            boolean oldRestrictBackground = this.mRestrictBackground;
            this.mRestrictBackground = restrictBackground;
            this.updateRulesForRestrictBackgroundUL();
            try {
                if (!this.mNetworkManager.setDataSaverModeEnabled(this.mRestrictBackground)) {
                    Slog.e(TAG, "Could not change Data Saver Mode on NMS to " + this.mRestrictBackground);
                    this.mRestrictBackground = oldRestrictBackground;
                    return;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.sendRestrictBackgroundChangedMsg();
            this.mLogger.restrictBackgroundChanged(oldRestrictBackground, this.mRestrictBackground);
            if (this.mRestrictBackgroundPowerState.globalBatterySaverEnabled) {
                this.mRestrictBackgroundChangedInBsm = true;
            }
            Object object = this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                this.updateNotificationsNL();
                this.writePolicyAL();
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    private void sendRestrictBackgroundChangedMsg() {
        this.mHandler.removeMessages(6);
        this.mHandler.obtainMessage(6, this.mRestrictBackground ? 1 : 0, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRestrictBackgroundByCaller() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        int uid = Binder.getCallingUid();
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int policy;
            long token = Binder.clearCallingIdentity();
            try {
                policy = this.getUidPolicy(uid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (policy == 1) {
                return 3;
            }
            if (!this.mRestrictBackground) {
                return 1;
            }
            return (this.mUidPolicy.get(uid) & 4) != 0 ? 2 : 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRestrictBackground() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.mRestrictBackground;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceIdleMode(boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Trace.traceBegin(0x200000L, "setDeviceIdleMode");
        try {
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                block11: {
                    if (this.mDeviceIdleMode != enabled) break block11;
                    return;
                }
                this.mDeviceIdleMode = enabled;
                this.mLogger.deviceIdleModeEnabled(enabled);
                if (this.mSystemReady) {
                    this.updateRulesForRestrictPowerUL();
                }
            }
            if (enabled) {
                EventLogTags.writeDeviceIdleOnPhase("net");
            } else {
                EventLogTags.writeDeviceIdleOffPhase("net");
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWifiMeteredOverride(String networkId, int meteredOverride) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            WifiManager wm = this.mContext.getSystemService(WifiManager.class);
            List<WifiConfiguration> configs = wm.getConfiguredNetworks();
            for (WifiConfiguration config : configs) {
                if (!Objects.equals(NetworkPolicyManager.resolveNetworkId(config), networkId)) continue;
                config.meteredOverride = meteredOverride;
                wm.updateNetwork(config);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    @Deprecated
    public NetworkQuotaInfo getNetworkQuotaInfo(NetworkState state) {
        Log.w(TAG, "Shame on UID " + Binder.getCallingUid() + " for calling the hidden API getNetworkQuotaInfo(). Shame!");
        return new NetworkQuotaInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceSubscriptionPlanAccess(int subId, int callingUid, String callingPackage) {
        String overridePackage;
        PersistableBundle config;
        SubscriptionInfo si;
        this.mAppOps.checkPackage(callingUid, callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            si = this.mContext.getSystemService(SubscriptionManager.class).getActiveSubscriptionInfo(subId);
            config = this.mCarrierConfigManager.getConfigForSubId(subId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (si != null && si.isEmbedded() && si.canManageSubscription(this.mContext, callingPackage)) {
            return;
        }
        if (config != null && !TextUtils.isEmpty(overridePackage = config.getString("config_plans_package_override_string", null)) && Objects.equals(overridePackage, callingPackage)) {
            return;
        }
        String defaultPackage = this.mCarrierConfigManager.getDefaultCarrierServicePackageName();
        if (!TextUtils.isEmpty(defaultPackage) && Objects.equals(defaultPackage, callingPackage)) {
            return;
        }
        String testPackage = SystemProperties.get("persist.sys.sub_plan_owner." + subId, null);
        if (!TextUtils.isEmpty(testPackage) && Objects.equals(testPackage, callingPackage)) {
            return;
        }
        String legacyTestPackage = SystemProperties.get("fw.sub_plan_owner." + subId, null);
        if (!TextUtils.isEmpty(legacyTestPackage) && Objects.equals(legacyTestPackage, callingPackage)) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_SUBSCRIPTION_PLANS", TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionPlan[] getSubscriptionPlans(int subId, String callingPackage) {
        this.enforceSubscriptionPlanAccess(subId, Binder.getCallingUid(), callingPackage);
        String fake = SystemProperties.get("fw.fake_plan");
        if (!TextUtils.isEmpty(fake)) {
            ArrayList<SubscriptionPlan> plans = new ArrayList<SubscriptionPlan>();
            if ("month_hard".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2007-03-14T00:00:00.000Z")).setTitle("G-Mobile").setDataLimit(0x140000000L, 1).setDataUsage(0x40000000L, ZonedDateTime.now().minusHours(36L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile Happy").setDataLimit(Long.MAX_VALUE, 1).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(36L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile, Charged after limit").setDataLimit(0x140000000L, 1).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(36L).toInstant().toEpochMilli()).build());
            } else if ("month_soft".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2007-03-14T00:00:00.000Z")).setTitle("G-Mobile is the carriers name who this plan belongs to").setSummary("Crazy unlimited bandwidth plan with incredibly long title that should be cut off to prevent UI from looking terrible").setDataLimit(0x140000000L, 2).setDataUsage(0x40000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile, Throttled after limit").setDataLimit(0x140000000L, 2).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile, No data connection after limit").setDataLimit(0x140000000L, 0).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
            } else if ("month_over".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2007-03-14T00:00:00.000Z")).setTitle("G-Mobile is the carriers name who this plan belongs to").setDataLimit(0x140000000L, 2).setDataUsage(0x180000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile, Throttled after limit").setDataLimit(0x140000000L, 2).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2017-03-14T00:00:00.000Z")).setTitle("G-Mobile, No data connection after limit").setDataLimit(0x140000000L, 0).setDataUsage(0x140000000L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
            } else if ("month_none".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createRecurringMonthly(ZonedDateTime.parse("2007-03-14T00:00:00.000Z")).setTitle("G-Mobile").build());
            } else if ("prepaid".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createNonrecurring(ZonedDateTime.now().minusDays(20L), ZonedDateTime.now().plusDays(10L)).setTitle("G-Mobile").setDataLimit(0x20000000L, 0).setDataUsage(0x6400000L, ZonedDateTime.now().minusHours(3L).toInstant().toEpochMilli()).build());
            } else if ("prepaid_crazy".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createNonrecurring(ZonedDateTime.now().minusDays(20L), ZonedDateTime.now().plusDays(10L)).setTitle("G-Mobile Anytime").setDataLimit(0x20000000L, 0).setDataUsage(0x6400000L, ZonedDateTime.now().minusHours(3L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createNonrecurring(ZonedDateTime.now().minusDays(10L), ZonedDateTime.now().plusDays(20L)).setTitle("G-Mobile Nickel Nights").setSummary("5\u00a2/GB between 1-5AM").setDataLimit(0x140000000L, 2).setDataUsage(0xF00000L, ZonedDateTime.now().minusHours(30L).toInstant().toEpochMilli()).build());
                plans.add(SubscriptionPlan.Builder.createNonrecurring(ZonedDateTime.now().minusDays(10L), ZonedDateTime.now().plusDays(20L)).setTitle("G-Mobile Bonus 3G").setSummary("Unlimited 3G data").setDataLimit(0x40000000L, 2).setDataUsage(314572800L, ZonedDateTime.now().minusHours(1L).toInstant().toEpochMilli()).build());
            } else if ("unlimited".equals(fake)) {
                plans.add(SubscriptionPlan.Builder.createNonrecurring(ZonedDateTime.now().minusDays(20L), ZonedDateTime.now().plusDays(10L)).setTitle("G-Mobile Awesome").setDataLimit(Long.MAX_VALUE, 2).setDataUsage(0x3200000L, ZonedDateTime.now().minusHours(3L).toInstant().toEpochMilli()).build());
            }
            return plans.toArray(new SubscriptionPlan[plans.size()]);
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            String ownerPackage = this.mSubscriptionPlansOwner.get(subId);
            if (Objects.equals(ownerPackage, callingPackage) || UserHandle.getCallingAppId() == 1000) {
                return this.mSubscriptionPlans.get(subId);
            }
            Log.w(TAG, "Not returning plans because caller " + callingPackage + " doesn't match owner " + ownerPackage);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubscriptionPlans(int subId, SubscriptionPlan[] plans, String callingPackage) {
        this.enforceSubscriptionPlanAccess(subId, Binder.getCallingUid(), callingPackage);
        for (SubscriptionPlan plan : plans) {
            Preconditions.checkNotNull(plan);
        }
        long token = Binder.clearCallingIdentity();
        try {
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                Object object2 = this.mNetworkPoliciesSecondLock;
                synchronized (object2) {
                    this.mSubscriptionPlans.put(subId, plans);
                    this.mSubscriptionPlansOwner.put(subId, callingPackage);
                    String subscriberId = this.mSubIdToSubscriberId.get(subId, null);
                    if (subscriberId != null) {
                        this.ensureActiveMobilePolicyAL(subId, subscriberId);
                        this.maybeUpdateMobilePolicyCycleAL(subId, subscriberId);
                    } else {
                        Slog.wtf(TAG, "Missing subscriberId for subId " + subId);
                    }
                    this.handleNetworkPoliciesUpdateAL(true);
                }
            }
            Intent intent = new Intent("android.telephony.action.SUBSCRIPTION_PLANS_CHANGED");
            intent.addFlags(0x40000000);
            intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
            this.mContext.sendBroadcast(intent, "android.permission.MANAGE_SUBSCRIPTION_PLANS");
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void setSubscriptionPlansOwner(int subId, String packageName) {
        SystemProperties.set("persist.sys.sub_plan_owner." + subId, packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubscriptionPlansOwner(int subId) {
        if (UserHandle.getCallingAppId() != 1000) {
            throw new SecurityException();
        }
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            return this.mSubscriptionPlansOwner.get(subId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubscriptionOverride(int subId, int overrideMask, int overrideValue, long timeoutMillis, String callingPackage) {
        boolean overrideEnabled;
        this.enforceSubscriptionPlanAccess(subId, Binder.getCallingUid(), callingPackage);
        Object object = this.mNetworkPoliciesSecondLock;
        synchronized (object) {
            SubscriptionPlan plan = this.getPrimarySubscriptionPlanLocked(subId);
            if (plan == null || plan.getDataLimitBehavior() == -1) {
                throw new IllegalStateException("Must provide valid SubscriptionPlan to enable overriding");
            }
        }
        boolean bl = overrideEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "netpolicy_override_enabled", 1) != 0;
        if (overrideEnabled || overrideValue == 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(16, overrideMask, overrideValue, subId));
            if (timeoutMillis > 0L) {
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(16, overrideMask, 0, subId), timeoutMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, writer)) {
            return;
        }
        IndentingPrintWriter fout = new IndentingPrintWriter((Writer)writer, "  ");
        ArraySet<String> argSet = new ArraySet<String>(args.length);
        for (String arg : args) {
            argSet.add(arg);
        }
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            Object object2 = this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                int i;
                int i2;
                int i3;
                if (argSet.contains("--unsnooze")) {
                    for (int i32 = this.mNetworkPolicy.size() - 1; i32 >= 0; --i32) {
                        this.mNetworkPolicy.valueAt(i32).clearSnooze();
                    }
                    this.handleNetworkPoliciesUpdateAL(true);
                    fout.println("Cleared snooze timestamps");
                    return;
                }
                fout.print("System ready: ");
                fout.println(this.mSystemReady);
                fout.print("Restrict background: ");
                fout.println(this.mRestrictBackground);
                fout.print("Restrict power: ");
                fout.println(this.mRestrictPower);
                fout.print("Device idle: ");
                fout.println(this.mDeviceIdleMode);
                fout.print("Metered ifaces: ");
                fout.println(String.valueOf(this.mMeteredIfaces));
                fout.println();
                fout.println("Network policies:");
                fout.increaseIndent();
                for (i3 = 0; i3 < this.mNetworkPolicy.size(); ++i3) {
                    fout.println(this.mNetworkPolicy.valueAt(i3).toString());
                }
                fout.decreaseIndent();
                fout.println();
                fout.println("Subscription plans:");
                fout.increaseIndent();
                for (i3 = 0; i3 < this.mSubscriptionPlans.size(); ++i3) {
                    int subId = this.mSubscriptionPlans.keyAt(i3);
                    fout.println("Subscriber ID " + subId + ":");
                    fout.increaseIndent();
                    SubscriptionPlan[] plans = this.mSubscriptionPlans.valueAt(i3);
                    if (!ArrayUtils.isEmpty(plans)) {
                        for (SubscriptionPlan plan : plans) {
                            fout.println(plan);
                        }
                    }
                    fout.decreaseIndent();
                }
                fout.decreaseIndent();
                fout.println();
                fout.println("Active subscriptions:");
                fout.increaseIndent();
                for (i3 = 0; i3 < this.mSubIdToSubscriberId.size(); ++i3) {
                    int subId = this.mSubIdToSubscriberId.keyAt(i3);
                    String subscriberId = this.mSubIdToSubscriberId.valueAt(i3);
                    fout.println(subId + "=" + NetworkIdentity.scrubSubscriberId(subscriberId));
                }
                fout.decreaseIndent();
                fout.println();
                fout.println("Merged subscriptions: " + Arrays.toString(NetworkIdentity.scrubSubscriberId(this.mMergedSubscriberIds)));
                fout.println();
                fout.println("Policy for UIDs:");
                fout.increaseIndent();
                int size = this.mUidPolicy.size();
                for (int i22 = 0; i22 < size; ++i22) {
                    int uid = this.mUidPolicy.keyAt(i22);
                    int policy = this.mUidPolicy.valueAt(i22);
                    fout.print("UID=");
                    fout.print(uid);
                    fout.print(" policy=");
                    fout.print(NetworkPolicyManager.uidPoliciesToString(policy));
                    fout.println();
                }
                fout.decreaseIndent();
                size = this.mPowerSaveWhitelistExceptIdleAppIds.size();
                if (size > 0) {
                    fout.println("Power save whitelist (except idle) app ids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.keyAt(i2));
                        fout.print(": ");
                        fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.valueAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mPowerSaveWhitelistAppIds.size()) > 0) {
                    fout.println("Power save whitelist app ids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mPowerSaveWhitelistAppIds.keyAt(i2));
                        fout.print(": ");
                        fout.print(this.mPowerSaveWhitelistAppIds.valueAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mAppIdleTempWhitelistAppIds.size()) > 0) {
                    fout.println("App idle whitelist app ids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mAppIdleTempWhitelistAppIds.keyAt(i2));
                        fout.print(": ");
                        fout.print(this.mAppIdleTempWhitelistAppIds.valueAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mDefaultRestrictBackgroundWhitelistUids.size()) > 0) {
                    fout.println("Default restrict background whitelist uids:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mDefaultRestrictBackgroundWhitelistUids.keyAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                if ((size = this.mRestrictBackgroundWhitelistRevokedUids.size()) > 0) {
                    fout.println("Default restrict background whitelist uids revoked by users:");
                    fout.increaseIndent();
                    for (i2 = 0; i2 < size; ++i2) {
                        fout.print("UID=");
                        fout.print(this.mRestrictBackgroundWhitelistRevokedUids.keyAt(i2));
                        fout.println();
                    }
                    fout.decreaseIndent();
                }
                SparseBooleanArray knownUids = new SparseBooleanArray();
                NetworkPolicyManagerService.collectKeys(this.mUidState, knownUids);
                NetworkPolicyManagerService.collectKeys(this.mUidRules, knownUids);
                fout.println("Status for all known UIDs:");
                fout.increaseIndent();
                size = knownUids.size();
                for (i = 0; i < size; ++i) {
                    int uid = knownUids.keyAt(i);
                    fout.print("UID=");
                    fout.print(uid);
                    int state = this.mUidState.get(uid, 20);
                    fout.print(" state=");
                    fout.print(state);
                    if (state <= 2) {
                        fout.print(" (fg)");
                    } else {
                        fout.print(state <= 6 ? " (fg svc)" : " (bg)");
                    }
                    int uidRules = this.mUidRules.get(uid, 0);
                    fout.print(" rules=");
                    fout.print(NetworkPolicyManager.uidRulesToString(uidRules));
                    fout.println();
                }
                fout.decreaseIndent();
                fout.println("Status for just UIDs with rules:");
                fout.increaseIndent();
                size = this.mUidRules.size();
                for (i = 0; i < size; ++i) {
                    int uid = this.mUidRules.keyAt(i);
                    fout.print("UID=");
                    fout.print(uid);
                    int uidRules = this.mUidRules.get(uid, 0);
                    fout.print(" rules=");
                    fout.print(NetworkPolicyManager.uidRulesToString(uidRules));
                    fout.println();
                }
                fout.decreaseIndent();
                fout.println("Admin restricted uids for metered data:");
                fout.increaseIndent();
                size = this.mMeteredRestrictedUids.size();
                for (i = 0; i < size; ++i) {
                    fout.print("u" + this.mMeteredRestrictedUids.keyAt(i) + ": ");
                    fout.println(this.mMeteredRestrictedUids.valueAt(i));
                }
                fout.decreaseIndent();
                fout.println();
                this.mStatLogger.dump(fout);
                this.mLogger.dumpLogs(fout);
            }
        }
    }

    @Override
    public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
        new NetworkPolicyManagerShellCommand(this.mContext, this).exec(this, in, out, err, args, callback, resultReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isUidForeground(int uid) {
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            return this.isUidStateForeground(this.mUidState.get(uid, 20));
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean isUidForegroundOnRestrictBackgroundUL(int uid) {
        int procState = this.mUidState.get(uid, 20);
        return NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(procState);
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean isUidForegroundOnRestrictPowerUL(int uid) {
        int procState = this.mUidState.get(uid, 20);
        return NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(procState);
    }

    private boolean isUidStateForeground(int state) {
        return state <= 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean updateUidStateUL(int uid, int uidState) {
        Trace.traceBegin(0x200000L, "updateUidStateUL");
        try {
            int oldUidState = this.mUidState.get(uid, 20);
            if (oldUidState != uidState) {
                this.mUidState.put(uid, uidState);
                this.updateRestrictBackgroundRulesOnUidStatusChangedUL(uid, oldUidState, uidState);
                if (NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(oldUidState) != NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(uidState)) {
                    this.updateRuleForAppIdleUL(uid);
                    if (this.mDeviceIdleMode) {
                        this.updateRuleForDeviceIdleUL(uid);
                    }
                    if (this.mRestrictPower) {
                        this.updateRuleForRestrictPowerUL(uid);
                    }
                    this.updateRulesForPowerRestrictionsUL(uid);
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
        return false;
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean removeUidStateUL(int uid) {
        int index = this.mUidState.indexOfKey(uid);
        if (index >= 0) {
            int oldUidState = this.mUidState.valueAt(index);
            this.mUidState.removeAt(index);
            if (oldUidState != 20) {
                this.updateRestrictBackgroundRulesOnUidStatusChangedUL(uid, oldUidState, 20);
                if (this.mDeviceIdleMode) {
                    this.updateRuleForDeviceIdleUL(uid);
                }
                if (this.mRestrictPower) {
                    this.updateRuleForRestrictPowerUL(uid);
                }
                this.updateRulesForPowerRestrictionsUL(uid);
                return true;
            }
        }
        return false;
    }

    private void updateNetworkStats(int uid, boolean uidForeground) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateNetworkStats: " + uid + "/" + (uidForeground ? "F" : "B"));
        }
        try {
            this.mNetworkStats.setUidForeground(uid, uidForeground);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    private void updateRestrictBackgroundRulesOnUidStatusChangedUL(int uid, int oldUidState, int newUidState) {
        boolean newForeground;
        boolean oldForeground = NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(oldUidState);
        if (oldForeground != (newForeground = NetworkPolicyManager.isProcStateAllowedWhileOnRestrictBackground(newUidState))) {
            this.updateRulesForDataUsageRestrictionsUL(uid);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRulesForPowerSaveUL() {
        Trace.traceBegin(0x200000L, "updateRulesForPowerSaveUL");
        try {
            this.updateRulesForWhitelistedPowerSaveUL(this.mRestrictPower, 3, this.mUidFirewallPowerSaveRules);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRuleForRestrictPowerUL(int uid) {
        this.updateRulesForWhitelistedPowerSaveUL(uid, this.mRestrictPower, 3);
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRulesForDeviceIdleUL() {
        Trace.traceBegin(0x200000L, "updateRulesForDeviceIdleUL");
        try {
            this.updateRulesForWhitelistedPowerSaveUL(this.mDeviceIdleMode, 1, this.mUidFirewallDozableRules);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRuleForDeviceIdleUL(int uid) {
        this.updateRulesForWhitelistedPowerSaveUL(uid, this.mDeviceIdleMode, 1);
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForWhitelistedPowerSaveUL(boolean enabled, int chain, SparseIntArray rules) {
        if (enabled) {
            SparseIntArray uidRules = rules;
            uidRules.clear();
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int ui = users.size() - 1; ui >= 0; --ui) {
                UserInfo user = users.get(ui);
                this.updateRulesForWhitelistedAppIds(uidRules, this.mPowerSaveTempWhitelistAppIds, user.id);
                this.updateRulesForWhitelistedAppIds(uidRules, this.mPowerSaveWhitelistAppIds, user.id);
                if (chain != 3) continue;
                this.updateRulesForWhitelistedAppIds(uidRules, this.mPowerSaveWhitelistExceptIdleAppIds, user.id);
            }
            for (int i = this.mUidState.size() - 1; i >= 0; --i) {
                if (!NetworkPolicyManager.isProcStateAllowedWhileIdleOrPowerSaveMode(this.mUidState.valueAt(i))) continue;
                uidRules.put(this.mUidState.keyAt(i), 1);
            }
            this.setUidFirewallRulesUL(chain, uidRules, 1);
        } else {
            this.setUidFirewallRulesUL(chain, null, 2);
        }
    }

    private void updateRulesForWhitelistedAppIds(SparseIntArray uidRules, SparseBooleanArray whitelistedAppIds, int userId) {
        for (int i = whitelistedAppIds.size() - 1; i >= 0; --i) {
            if (!whitelistedAppIds.valueAt(i)) continue;
            int appId = whitelistedAppIds.keyAt(i);
            int uid = UserHandle.getUid(userId, appId);
            uidRules.put(uid, 1);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean isWhitelistedFromPowerSaveUL(int uid, boolean deviceIdleMode) {
        boolean isWhitelisted;
        int appId = UserHandle.getAppId(uid);
        boolean bl = isWhitelisted = this.mPowerSaveTempWhitelistAppIds.get(appId) || this.mPowerSaveWhitelistAppIds.get(appId);
        if (!deviceIdleMode) {
            isWhitelisted = isWhitelisted || this.mPowerSaveWhitelistExceptIdleAppIds.get(appId);
        }
        return isWhitelisted;
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForWhitelistedPowerSaveUL(int uid, boolean enabled, int chain) {
        if (enabled) {
            boolean isWhitelisted = this.isWhitelistedFromPowerSaveUL(uid, chain == 1);
            if (isWhitelisted || this.isUidForegroundOnRestrictPowerUL(uid)) {
                this.setUidFirewallRule(chain, uid, 1);
            } else {
                this.setUidFirewallRule(chain, uid, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRulesForAppIdleUL() {
        Trace.traceBegin(0x200000L, "updateRulesForAppIdleUL");
        try {
            SparseIntArray uidRules = this.mUidFirewallStandbyRules;
            uidRules.clear();
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int ui = users.size() - 1; ui >= 0; --ui) {
                int[] idleUids;
                UserInfo user = users.get(ui);
                for (int uid : idleUids = this.mUsageStats.getIdleUidsForUser(user.id)) {
                    if (this.mPowerSaveTempWhitelistAppIds.get(UserHandle.getAppId(uid), false) || !this.hasInternetPermissions(uid)) continue;
                    uidRules.put(uid, 2);
                }
            }
            this.setUidFirewallRulesUL(2, uidRules, 0);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRuleForAppIdleUL(int uid) {
        if (!this.isUidValidForBlacklistRules(uid)) {
            return;
        }
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateRuleForAppIdleUL: " + uid);
        }
        try {
            int appId = UserHandle.getAppId(uid);
            if (!this.mPowerSaveTempWhitelistAppIds.get(appId) && this.isUidIdle(uid) && !this.isUidForegroundOnRestrictPowerUL(uid)) {
                this.setUidFirewallRule(2, uid, 2);
                if (LOGD) {
                    Log.d(TAG, "updateRuleForAppIdleUL DENY " + uid);
                }
            } else {
                this.setUidFirewallRule(2, uid, 0);
                if (LOGD) {
                    Log.d(TAG, "updateRuleForAppIdleUL " + uid + " to DEFAULT");
                }
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    void updateRulesForAppIdleParoleUL() {
        boolean paroled = this.mUsageStats.isAppIdleParoleOn();
        boolean enableChain = !paroled;
        this.enableFirewallChainUL(2, enableChain);
        int ruleCount = this.mUidFirewallStandbyRules.size();
        for (int i = 0; i < ruleCount; ++i) {
            int uid = this.mUidFirewallStandbyRules.keyAt(i);
            int oldRules = this.mUidRules.get(uid);
            if (enableChain) {
                oldRules &= 0xF;
            } else if ((oldRules & 0xF0) == 0) continue;
            int newUidRules = this.updateRulesForPowerRestrictionsUL(uid, oldRules, paroled);
            if (newUidRules == 0) {
                this.mUidRules.delete(uid);
                continue;
            }
            this.mUidRules.put(uid, newUidRules);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock", "mNetworkPoliciesSecondLock"})
    private void updateRulesForGlobalChangeAL(boolean restrictedNetworksChanged) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateRulesForGlobalChangeAL: " + (restrictedNetworksChanged ? "R" : "-"));
        }
        try {
            this.updateRulesForAppIdleUL();
            this.updateRulesForRestrictPowerUL();
            this.updateRulesForRestrictBackgroundUL();
            if (restrictedNetworksChanged) {
                this.normalizePoliciesNL();
                this.updateNetworkRulesNL();
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForRestrictPowerUL() {
        Trace.traceBegin(0x200000L, "updateRulesForRestrictPowerUL");
        try {
            this.updateRulesForDeviceIdleUL();
            this.updateRulesForPowerSaveUL();
            this.updateRulesForAllAppsUL(2);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForRestrictBackgroundUL() {
        Trace.traceBegin(0x200000L, "updateRulesForRestrictBackgroundUL");
        try {
            this.updateRulesForAllAppsUL(1);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForAllAppsUL(int type) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateRulesForRestrictPowerUL-" + type);
        }
        try {
            List<ApplicationInfo> apps;
            List<UserInfo> users;
            PackageManager pm = this.mContext.getPackageManager();
            Trace.traceBegin(0x200000L, "list-users");
            try {
                users = this.mUserManager.getUsers();
            }
            finally {
                Trace.traceEnd(0x200000L);
            }
            Trace.traceBegin(0x200000L, "list-uids");
            try {
                apps = pm.getInstalledApplications(4981248);
            }
            finally {
                Trace.traceEnd(0x200000L);
            }
            int usersSize = users.size();
            int appsSize = apps.size();
            for (int i = 0; i < usersSize; ++i) {
                UserInfo user = users.get(i);
                block14: for (int j = 0; j < appsSize; ++j) {
                    ApplicationInfo app = apps.get(j);
                    int uid = UserHandle.getUid(user.id, app.uid);
                    switch (type) {
                        case 1: {
                            this.updateRulesForDataUsageRestrictionsUL(uid);
                            continue block14;
                        }
                        case 2: {
                            this.updateRulesForPowerRestrictionsUL(uid);
                            continue block14;
                        }
                        default: {
                            Slog.w(TAG, "Invalid type for updateRulesForAllApps: " + type);
                        }
                    }
                }
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForTempWhitelistChangeUL(int appId) {
        List<UserInfo> users = this.mUserManager.getUsers();
        int numUsers = users.size();
        for (int i = 0; i < numUsers; ++i) {
            UserInfo user = users.get(i);
            int uid = UserHandle.getUid(user.id, appId);
            this.updateRuleForAppIdleUL(uid);
            this.updateRuleForDeviceIdleUL(uid);
            this.updateRuleForRestrictPowerUL(uid);
            this.updateRulesForPowerRestrictionsUL(uid);
        }
    }

    private boolean isUidValidForBlacklistRules(int uid) {
        return uid == 1013 || uid == 1019 || UserHandle.isApp(uid) && this.hasInternetPermissions(uid);
    }

    private boolean isUidValidForWhitelistRules(int uid) {
        return UserHandle.isApp(uid) && this.hasInternetPermissions(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setAppIdleWhitelist(int uid, boolean shouldWhitelist) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            if (this.mAppIdleTempWhitelistAppIds.get(uid) == shouldWhitelist) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                this.mLogger.appIdleWlChanged(uid, shouldWhitelist);
                if (shouldWhitelist) {
                    this.mAppIdleTempWhitelistAppIds.put(uid, true);
                } else {
                    this.mAppIdleTempWhitelistAppIds.delete(uid);
                }
                this.updateRuleForAppIdleUL(uid);
                this.updateRulesForPowerRestrictionsUL(uid);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int[] getAppIdleWhitelist() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            int len = this.mAppIdleTempWhitelistAppIds.size();
            int[] uids = new int[len];
            for (int i = 0; i < len; ++i) {
                uids[i] = this.mAppIdleTempWhitelistAppIds.keyAt(i);
            }
            return uids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean isUidIdle(int uid) {
        String[] packages;
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            if (this.mAppIdleTempWhitelistAppIds.get(uid)) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        }
        int userId = UserHandle.getUserId(uid);
        if (packages != null) {
            for (String packageName : packages) {
                if (this.mUsageStats.isAppIdle(packageName, uid, userId)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean hasInternetPermissions(int uid) {
        try {
            if (this.mIPm.checkUidPermission("android.permission.INTERNET", uid) != 0) {
                return false;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return true;
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void onUidDeletedUL(int uid) {
        this.mUidRules.delete(uid);
        this.mUidPolicy.delete(uid);
        this.mUidFirewallStandbyRules.delete(uid);
        this.mUidFirewallDozableRules.delete(uid);
        this.mUidFirewallPowerSaveRules.delete(uid);
        this.mPowerSaveWhitelistExceptIdleAppIds.delete(uid);
        this.mPowerSaveWhitelistAppIds.delete(uid);
        this.mPowerSaveTempWhitelistAppIds.delete(uid);
        this.mAppIdleTempWhitelistAppIds.delete(uid);
        this.mHandler.obtainMessage(15, uid, 0).sendToTarget();
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRestrictionRulesForUidUL(int uid) {
        this.updateRuleForDeviceIdleUL(uid);
        this.updateRuleForAppIdleUL(uid);
        this.updateRuleForRestrictPowerUL(uid);
        this.updateRulesForPowerRestrictionsUL(uid);
        this.updateRulesForDataUsageRestrictionsUL(uid);
    }

    private void updateRulesForDataUsageRestrictionsUL(int uid) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateRulesForDataUsageRestrictionsUL: " + uid);
        }
        try {
            this.updateRulesForDataUsageRestrictionsULInner(uid);
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    private void updateRulesForDataUsageRestrictionsULInner(int uid) {
        if (!this.isUidValidForWhitelistRules(uid)) {
            if (LOGD) {
                Slog.d(TAG, "no need to update restrict data rules for uid " + uid);
            }
            return;
        }
        int uidPolicy = this.mUidPolicy.get(uid, 0);
        int oldUidRules = this.mUidRules.get(uid, 0);
        boolean isForeground = this.isUidForegroundOnRestrictBackgroundUL(uid);
        boolean isRestrictedByAdmin = this.isRestrictedByAdminUL(uid);
        boolean isBlacklisted = (uidPolicy & 1) != 0;
        boolean isWhitelisted = (uidPolicy & 4) != 0;
        int oldRule = oldUidRules & 0xF;
        int newRule = 0;
        if (isRestrictedByAdmin) {
            newRule = 4;
        } else if (isForeground) {
            if (isBlacklisted || this.mRestrictBackground && !isWhitelisted) {
                newRule = 2;
            } else if (isWhitelisted) {
                newRule = 1;
            }
        } else if (isBlacklisted) {
            newRule = 4;
        } else if (this.mRestrictBackground && isWhitelisted) {
            newRule = 1;
        }
        int newUidRules = newRule | oldUidRules & 0xF0;
        if (LOGV) {
            Log.v(TAG, "updateRuleForRestrictBackgroundUL(" + uid + "): isForeground=" + isForeground + ", isBlacklisted=" + isBlacklisted + ", isWhitelisted=" + isWhitelisted + ", isRestrictedByAdmin=" + isRestrictedByAdmin + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldRule) + ", newRule=" + NetworkPolicyManager.uidRulesToString(newRule) + ", newUidRules=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldUidRules=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
        }
        if (newUidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, newUidRules);
        }
        if (newRule != oldRule) {
            if (NetworkPolicyManagerService.hasRule(newRule, 2)) {
                this.setMeteredNetworkWhitelist(uid, true);
                if (isBlacklisted) {
                    this.setMeteredNetworkBlacklist(uid, false);
                }
            } else if (NetworkPolicyManagerService.hasRule(oldRule, 2)) {
                if (!isWhitelisted) {
                    this.setMeteredNetworkWhitelist(uid, false);
                }
                if (isBlacklisted || isRestrictedByAdmin) {
                    this.setMeteredNetworkBlacklist(uid, true);
                }
            } else if (NetworkPolicyManagerService.hasRule(newRule, 4) || NetworkPolicyManagerService.hasRule(oldRule, 4)) {
                this.setMeteredNetworkBlacklist(uid, isBlacklisted || isRestrictedByAdmin);
                if (NetworkPolicyManagerService.hasRule(oldRule, 4) && isWhitelisted) {
                    this.setMeteredNetworkWhitelist(uid, isWhitelisted);
                }
            } else if (NetworkPolicyManagerService.hasRule(newRule, 1) || NetworkPolicyManagerService.hasRule(oldRule, 1)) {
                this.setMeteredNetworkWhitelist(uid, isWhitelisted);
            } else {
                Log.wtf(TAG, "Unexpected change of metered UID state for " + uid + ": foreground=" + isForeground + ", whitelisted=" + isWhitelisted + ", blacklisted=" + isBlacklisted + ", isRestrictedByAdmin=" + isRestrictedByAdmin + ", newRule=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
            }
            this.mHandler.obtainMessage(1, uid, newUidRules).sendToTarget();
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void updateRulesForPowerRestrictionsUL(int uid) {
        int oldUidRules = this.mUidRules.get(uid, 0);
        int newUidRules = this.updateRulesForPowerRestrictionsUL(uid, oldUidRules, false);
        if (newUidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, newUidRules);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateRulesForPowerRestrictionsUL(int uid, int oldUidRules, boolean paroled) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "updateRulesForPowerRestrictionsUL: " + uid + "/" + oldUidRules + "/" + (paroled ? "P" : "-"));
        }
        try {
            int n = this.updateRulesForPowerRestrictionsULInner(uid, oldUidRules, paroled);
            return n;
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    private int updateRulesForPowerRestrictionsULInner(int uid, int oldUidRules, boolean paroled) {
        if (!this.isUidValidForBlacklistRules(uid)) {
            if (LOGD) {
                Slog.d(TAG, "no need to update restrict power rules for uid " + uid);
            }
            return 0;
        }
        boolean isIdle = !paroled && this.isUidIdle(uid);
        boolean restrictMode = isIdle || this.mRestrictPower || this.mDeviceIdleMode;
        boolean isForeground = this.isUidForegroundOnRestrictPowerUL(uid);
        boolean isWhitelisted = this.isWhitelistedFromPowerSaveUL(uid, this.mDeviceIdleMode);
        int oldRule = oldUidRules & 0xF0;
        int newRule = 0;
        if (isForeground) {
            if (restrictMode) {
                newRule = 32;
            }
        } else if (restrictMode) {
            newRule = isWhitelisted ? 32 : 64;
        }
        int newUidRules = oldUidRules & 0xF | newRule;
        if (LOGV) {
            Log.v(TAG, "updateRulesForPowerRestrictionsUL(" + uid + "), isIdle: " + isIdle + ", mRestrictPower: " + this.mRestrictPower + ", mDeviceIdleMode: " + this.mDeviceIdleMode + ", isForeground=" + isForeground + ", isWhitelisted=" + isWhitelisted + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldRule) + ", newRule=" + NetworkPolicyManager.uidRulesToString(newRule) + ", newUidRules=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldUidRules=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
        }
        if (newRule != oldRule) {
            if (newRule == 0 || NetworkPolicyManagerService.hasRule(newRule, 32)) {
                if (LOGV) {
                    Log.v(TAG, "Allowing non-metered access for UID " + uid);
                }
            } else if (NetworkPolicyManagerService.hasRule(newRule, 64)) {
                if (LOGV) {
                    Log.v(TAG, "Rejecting non-metered access for UID " + uid);
                }
            } else {
                Log.wtf(TAG, "Unexpected change of non-metered UID state for " + uid + ": foreground=" + isForeground + ", whitelisted=" + isWhitelisted + ", newRule=" + NetworkPolicyManager.uidRulesToString(newUidRules) + ", oldRule=" + NetworkPolicyManager.uidRulesToString(oldUidRules));
            }
            this.mHandler.obtainMessage(1, uid, newUidRules).sendToTarget();
        }
        return newUidRules;
    }

    private void dispatchUidRulesChanged(INetworkPolicyListener listener, int uid, int uidRules) {
        if (listener != null) {
            try {
                listener.onUidRulesChanged(uid, uidRules);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchMeteredIfacesChanged(INetworkPolicyListener listener, String[] meteredIfaces) {
        if (listener != null) {
            try {
                listener.onMeteredIfacesChanged(meteredIfaces);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchRestrictBackgroundChanged(INetworkPolicyListener listener, boolean restrictBackground) {
        if (listener != null) {
            try {
                listener.onRestrictBackgroundChanged(restrictBackground);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchUidPoliciesChanged(INetworkPolicyListener listener, int uid, int uidPolicies) {
        if (listener != null) {
            try {
                listener.onUidPoliciesChanged(uid, uidPolicies);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void dispatchSubscriptionOverride(INetworkPolicyListener listener, int subId, int overrideMask, int overrideValue) {
        if (listener != null) {
            try {
                listener.onSubscriptionOverride(subId, overrideMask, overrideValue);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUidChanged(int uid, int procState, long procStateSeq) {
        Trace.traceBegin(0x200000L, "onUidStateChanged");
        try {
            boolean updated;
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                this.mLogger.uidStateChanged(uid, procState, procStateSeq);
                updated = this.updateUidStateUL(uid, procState);
                this.mActivityManagerInternal.notifyNetworkPolicyRulesUpdated(uid, procStateSeq);
            }
            if (updated) {
                this.updateNetworkStats(uid, this.isUidStateForeground(procState));
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUidGone(int uid) {
        Trace.traceBegin(0x200000L, "onUidGone");
        try {
            boolean updated;
            Object object = this.mUidRulesFirstLock;
            synchronized (object) {
                updated = this.removeUidStateUL(uid);
            }
            if (updated) {
                this.updateNetworkStats(uid, false);
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    private void broadcastRestrictBackgroundChanged(int uid, Boolean changed) {
        PackageManager pm = this.mContext.getPackageManager();
        String[] packages = pm.getPackagesForUid(uid);
        if (packages != null) {
            int userId = UserHandle.getUserId(uid);
            for (String packageName : packages) {
                Intent intent = new Intent("android.net.conn.RESTRICT_BACKGROUND_CHANGED");
                intent.setPackage(packageName);
                intent.setFlags(0x40000000);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.of(userId));
            }
        }
    }

    private void setInterfaceQuotaAsync(String iface, long quotaBytes) {
        this.mHandler.obtainMessage(10, (int)(quotaBytes >> 32), (int)(quotaBytes & 0xFFFFFFFFFFFFFFFFL), iface).sendToTarget();
    }

    private void setInterfaceQuota(String iface, long quotaBytes) {
        try {
            this.mNetworkManager.setInterfaceQuota(iface, quotaBytes);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void removeInterfaceQuotaAsync(String iface) {
        this.mHandler.obtainMessage(11, iface).sendToTarget();
    }

    private void removeInterfaceQuota(String iface) {
        try {
            this.mNetworkManager.removeInterfaceQuota(iface);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem removing interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setMeteredNetworkBlacklist(int uid, boolean enable) {
        if (LOGV) {
            Slog.v(TAG, "setMeteredNetworkBlacklist " + uid + ": " + enable);
        }
        try {
            this.mNetworkManager.setUidMeteredNetworkBlacklist(uid, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting blacklist (" + enable + ") rules for " + uid, e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setMeteredNetworkWhitelist(int uid, boolean enable) {
        if (LOGV) {
            Slog.v(TAG, "setMeteredNetworkWhitelist " + uid + ": " + enable);
        }
        try {
            this.mNetworkManager.setUidMeteredNetworkWhitelist(uid, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting whitelist (" + enable + ") rules for " + uid, e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void setUidFirewallRulesUL(int chain, SparseIntArray uidRules, int toggle) {
        if (uidRules != null) {
            this.setUidFirewallRulesUL(chain, uidRules);
        }
        if (toggle != 0) {
            this.enableFirewallChainUL(chain, toggle == 1);
        }
    }

    private void setUidFirewallRulesUL(int chain, SparseIntArray uidRules) {
        try {
            int size = uidRules.size();
            int[] uids = new int[size];
            int[] rules = new int[size];
            for (int index = size - 1; index >= 0; --index) {
                uids[index] = uidRules.keyAt(index);
                rules[index] = uidRules.valueAt(index);
            }
            this.mNetworkManager.setFirewallUidRules(chain, uids, rules);
            this.mLogger.firewallRulesChanged(chain, uids, rules);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting firewall uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUidFirewallRule(int chain, int uid, int rule) {
        if (Trace.isTagEnabled(0x200000L)) {
            Trace.traceBegin(0x200000L, "setUidFirewallRule: " + chain + "/" + uid + "/" + rule);
        }
        try {
            if (chain == 1) {
                this.mUidFirewallDozableRules.put(uid, rule);
            } else if (chain == 2) {
                this.mUidFirewallStandbyRules.put(uid, rule);
            } else if (chain == 3) {
                this.mUidFirewallPowerSaveRules.put(uid, rule);
            }
            try {
                this.mNetworkManager.setFirewallUidRule(chain, uid, rule);
                this.mLogger.uidFirewallRuleChanged(chain, uid, rule);
            }
            catch (IllegalStateException e) {
                Log.wtf(TAG, "problem setting firewall uid rules", e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        finally {
            Trace.traceEnd(0x200000L);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private void enableFirewallChainUL(int chain, boolean enable) {
        if (this.mFirewallChainStates.indexOfKey(chain) >= 0 && this.mFirewallChainStates.get(chain) == enable) {
            return;
        }
        this.mFirewallChainStates.put(chain, enable);
        try {
            this.mNetworkManager.setFirewallChainEnabled(chain, enable);
            this.mLogger.firewallChainEnabled(chain, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem enable firewall chain", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void resetUidFirewallRules(int uid) {
        try {
            this.mNetworkManager.setFirewallUidRule(1, uid, 0);
            this.mNetworkManager.setFirewallUidRule(2, uid, 0);
            this.mNetworkManager.setFirewallUidRule(3, uid, 0);
            this.mNetworkManager.setUidMeteredNetworkWhitelist(uid, false);
            this.mNetworkManager.setUidMeteredNetworkBlacklist(uid, false);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem resetting firewall uid rules for " + uid, e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    private long getTotalBytes(NetworkTemplate template, long start, long end) {
        return this.getNetworkTotalBytes(template, start, end);
    }

    private long getNetworkTotalBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getNetworkTotalBytes(template, start, end);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Failed to read network stats: " + e);
            return 0L;
        }
    }

    private NetworkStats getNetworkUidBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getNetworkUidBytes(template, start, end);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Failed to read network stats: " + e);
            return new NetworkStats(SystemClock.elapsedRealtime(), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mNetworkManager.isBandwidthControlEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static Intent buildAllowBackgroundDataIntent() {
        return new Intent(ACTION_ALLOW_BACKGROUND);
    }

    private static Intent buildSnoozeWarningIntent(NetworkTemplate template) {
        Intent intent = new Intent(ACTION_SNOOZE_WARNING);
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildSnoozeRapidIntent(NetworkTemplate template) {
        Intent intent = new Intent(ACTION_SNOOZE_RAPID);
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildNetworkOverLimitIntent(Resources res, NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(ComponentName.unflattenFromString(res.getString(17039760)));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildViewDataUsageIntent(Resources res, NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(ComponentName.unflattenFromString(res.getString(17039693)));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    @VisibleForTesting
    void addIdleHandler(MessageQueue.IdleHandler handler) {
        this.mHandler.getLooper().getQueue().addIdleHandler(handler);
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    @VisibleForTesting
    void updateRestrictBackgroundByLowPowerModeUL(PowerSaveState result) {
        boolean shouldInvokeRestrictBackground;
        this.mRestrictBackgroundPowerState = result;
        boolean restrictBackground = result.batterySaverEnabled;
        boolean localRestrictBgChangedInBsm = this.mRestrictBackgroundChangedInBsm;
        if (result.globalBatterySaverEnabled) {
            shouldInvokeRestrictBackground = !this.mRestrictBackground && result.batterySaverEnabled;
            this.mRestrictBackgroundBeforeBsm = this.mRestrictBackground;
            localRestrictBgChangedInBsm = false;
        } else {
            shouldInvokeRestrictBackground = !this.mRestrictBackgroundChangedInBsm;
            restrictBackground = this.mRestrictBackgroundBeforeBsm;
        }
        if (shouldInvokeRestrictBackground) {
            this.setRestrictBackgroundUL(restrictBackground);
        }
        this.mRestrictBackgroundChangedInBsm = localRestrictBgChangedInBsm;
    }

    private static void collectKeys(SparseIntArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    @Override
    public void factoryReset(String subscriber) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriber);
        for (NetworkPolicy policy : policies) {
            if (!policy.template.equals(template)) continue;
            policy.limitBytes = -1L;
            policy.inferred = false;
            policy.clearSnooze();
        }
        this.setNetworkPolicies(policies);
        this.setRestrictBackground(false);
        if (!this.mUserManager.hasUserRestriction("no_control_apps")) {
            for (int uid : this.getUidsWithPolicy(1)) {
                this.setUidPolicy(uid, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidNetworkingBlocked(int uid, boolean isNetworkMetered) {
        boolean isBackgroundRestricted;
        int uidRules;
        long startTime = this.mStatLogger.getTime();
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            uidRules = this.mUidRules.get(uid, 0);
            isBackgroundRestricted = this.mRestrictBackground;
        }
        boolean ret = NetworkPolicyManagerService.isUidNetworkingBlockedInternal(uid, uidRules, isNetworkMetered, isBackgroundRestricted, this.mLogger);
        this.mStatLogger.logDurationStat(1, startTime);
        return ret;
    }

    private static boolean isSystem(int uid) {
        return uid < 10000;
    }

    static boolean isUidNetworkingBlockedInternal(int uid, int uidRules, boolean isNetworkMetered, boolean isBackgroundRestricted, NetworkPolicyLogger logger) {
        boolean blocked;
        int reason = NetworkPolicyManagerService.isSystem(uid) ? 7 : (NetworkPolicyManagerService.hasRule(uidRules, 64) ? 0 : (!isNetworkMetered ? 1 : (NetworkPolicyManagerService.hasRule(uidRules, 4) ? 2 : (NetworkPolicyManagerService.hasRule(uidRules, 1) ? 3 : (NetworkPolicyManagerService.hasRule(uidRules, 2) ? 4 : (isBackgroundRestricted ? 5 : 6))))));
        switch (reason) {
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                blocked = false;
                break;
            }
            case 0: 
            case 2: 
            case 5: {
                blocked = true;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (logger != null) {
            logger.networkBlocked(uid, reason);
        }
        return blocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMeteredRestrictedPackagesInternal(Set<String> packageNames, int userId) {
        Object object = this.mUidRulesFirstLock;
        synchronized (object) {
            ArraySet<Integer> newRestrictedUids = new ArraySet<Integer>();
            for (String packageName : packageNames) {
                int uid = this.getUidForPackage(packageName, userId);
                if (uid < 0) continue;
                newRestrictedUids.add(uid);
            }
            Set<Integer> oldRestrictedUids = this.mMeteredRestrictedUids.get(userId);
            this.mMeteredRestrictedUids.put(userId, newRestrictedUids);
            this.handleRestrictedPackagesChangeUL(oldRestrictedUids, newRestrictedUids);
            this.mLogger.meteredRestrictedPkgsChanged(newRestrictedUids);
        }
    }

    private int getUidForPackage(String packageName, int userId) {
        try {
            return this.mContext.getPackageManager().getPackageUidAsUser(packageName, 0x402000, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -1;
        }
    }

    private int parseSubId(NetworkState state) {
        NetworkSpecifier spec;
        int subId = -1;
        if (state != null && state.networkCapabilities != null && state.networkCapabilities.hasTransport(0) && (spec = state.networkCapabilities.getNetworkSpecifier()) instanceof StringNetworkSpecifier) {
            try {
                subId = Integer.parseInt(((StringNetworkSpecifier)spec).specifier);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return subId;
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private int getSubIdLocked(Network network) {
        return this.mNetIdToSubId.get(network.netId, -1);
    }

    @GuardedBy(value={"mNetworkPoliciesSecondLock"})
    private SubscriptionPlan getPrimarySubscriptionPlanLocked(int subId) {
        SubscriptionPlan[] plans = this.mSubscriptionPlans.get(subId);
        if (!ArrayUtils.isEmpty(plans)) {
            for (SubscriptionPlan plan : plans) {
                if (plan.getCycleRule().isRecurring()) {
                    return plan;
                }
                Range<ZonedDateTime> cycle = plan.cycleIterator().next();
                if (!cycle.contains(ZonedDateTime.now(this.mClock))) continue;
                return plan;
            }
        }
        return null;
    }

    private void waitForAdminData() {
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.device_admin")) {
            ConcurrentUtils.waitForCountDownNoInterrupt(this.mAdminDataAvailableLatch, 10000L, "Wait for admin data");
        }
    }

    private void handleRestrictedPackagesChangeUL(Set<Integer> oldRestrictedUids, Set<Integer> newRestrictedUids) {
        if (!this.mNetworkManagerReady) {
            return;
        }
        if (oldRestrictedUids == null) {
            for (int uid : newRestrictedUids) {
                this.updateRulesForDataUsageRestrictionsUL(uid);
            }
            return;
        }
        for (int uid : oldRestrictedUids) {
            if (newRestrictedUids.contains(uid)) continue;
            this.updateRulesForDataUsageRestrictionsUL(uid);
        }
        for (int uid : newRestrictedUids) {
            if (oldRestrictedUids.contains(uid)) continue;
            this.updateRulesForDataUsageRestrictionsUL(uid);
        }
    }

    @GuardedBy(value={"mUidRulesFirstLock"})
    private boolean isRestrictedByAdminUL(int uid) {
        Set<Integer> restrictedUids = this.mMeteredRestrictedUids.get(UserHandle.getUserId(uid));
        return restrictedUids != null && restrictedUids.contains(uid);
    }

    private static boolean hasRule(int uidRules, int rule) {
        return (uidRules & rule) != 0;
    }

    private static NetworkState[] defeatNullable(NetworkState[] val) {
        return val != null ? val : new NetworkState[]{};
    }

    private static boolean getBooleanDefeatingNullable(PersistableBundle bundle, String key, boolean defaultValue) {
        return bundle != null ? bundle.getBoolean(key, defaultValue) : defaultValue;
    }

    private static boolean isHeadlessSystemUserBuild() {
        return RoSystemProperties.MULTIUSER_HEADLESS_SYSTEM_USER;
    }

    private class NotificationId {
        private final String mTag;
        private final int mId;

        NotificationId(NetworkPolicy policy, int type) {
            this.mTag = this.buildNotificationTag(policy, type);
            this.mId = type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NotificationId)) {
                return false;
            }
            NotificationId that = (NotificationId)o;
            return Objects.equals(this.mTag, that.mTag);
        }

        public int hashCode() {
            return Objects.hash(this.mTag);
        }

        private String buildNotificationTag(NetworkPolicy policy, int type) {
            return "NetworkPolicy:" + policy.template.hashCode() + ":" + type;
        }

        public String getTag() {
            return this.mTag;
        }

        public int getId() {
            return this.mId;
        }
    }

    private class NetworkPolicyManagerInternalImpl
    extends NetworkPolicyManagerInternal {
        private NetworkPolicyManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resetUserState(int userId) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                boolean changed = NetworkPolicyManagerService.this.removeUserStateUL(userId, false);
                boolean bl = changed = NetworkPolicyManagerService.this.addDefaultRestrictBackgroundWhitelistUidsUL(userId) || changed;
                if (changed) {
                    Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
                    synchronized (object2) {
                        NetworkPolicyManagerService.this.writePolicyAL();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUidRestrictedOnMeteredNetworks(int uid) {
            boolean isBackgroundRestricted;
            int uidRules;
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                uidRules = NetworkPolicyManagerService.this.mUidRules.get(uid, 32);
                isBackgroundRestricted = NetworkPolicyManagerService.this.mRestrictBackground;
            }
            return isBackgroundRestricted && !NetworkPolicyManagerService.hasRule(uidRules, 1) && !NetworkPolicyManagerService.hasRule(uidRules, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isUidNetworkingBlocked(int uid, String ifname) {
            boolean isNetworkMetered;
            boolean isBackgroundRestricted;
            int uidRules;
            long startTime = NetworkPolicyManagerService.this.mStatLogger.getTime();
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                uidRules = NetworkPolicyManagerService.this.mUidRules.get(uid, 0);
                isBackgroundRestricted = NetworkPolicyManagerService.this.mRestrictBackground;
            }
            Object object2 = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object2) {
                isNetworkMetered = NetworkPolicyManagerService.this.mMeteredIfaces.contains(ifname);
            }
            boolean ret = NetworkPolicyManagerService.isUidNetworkingBlockedInternal(uid, uidRules, isNetworkMetered, isBackgroundRestricted, NetworkPolicyManagerService.this.mLogger);
            NetworkPolicyManagerService.this.mStatLogger.logDurationStat(1, startTime);
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTempPowerSaveWhitelistChange(int appId, boolean added) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.mLogger.tempPowerSaveWlChanged(appId, added);
                if (added) {
                    NetworkPolicyManagerService.this.mPowerSaveTempWhitelistAppIds.put(appId, true);
                } else {
                    NetworkPolicyManagerService.this.mPowerSaveTempWhitelistAppIds.delete(appId);
                }
                NetworkPolicyManagerService.this.updateRulesForTempWhitelistChangeUL(appId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionPlan getSubscriptionPlan(Network network) {
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                int subId = NetworkPolicyManagerService.this.getSubIdLocked(network);
                return NetworkPolicyManagerService.this.getPrimarySubscriptionPlanLocked(subId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SubscriptionPlan getSubscriptionPlan(NetworkTemplate template) {
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                int subId = NetworkPolicyManagerService.this.findRelevantSubIdNL(template);
                return NetworkPolicyManagerService.this.getPrimarySubscriptionPlanLocked(subId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getSubscriptionOpportunisticQuota(Network network, int quotaType) {
            long quotaBytes;
            Object object = NetworkPolicyManagerService.this.mNetworkPoliciesSecondLock;
            synchronized (object) {
                quotaBytes = NetworkPolicyManagerService.this.mSubscriptionOpportunisticQuota.get(NetworkPolicyManagerService.this.getSubIdLocked(network), -1L);
            }
            if (quotaBytes == -1L) {
                return -1L;
            }
            if (quotaType == 1) {
                return (long)((float)quotaBytes * Settings.Global.getFloat(NetworkPolicyManagerService.this.mContext.getContentResolver(), "netpolicy_quota_frac_jobs", 0.5f));
            }
            if (quotaType == 2) {
                return (long)((float)quotaBytes * Settings.Global.getFloat(NetworkPolicyManagerService.this.mContext.getContentResolver(), "netpolicy_quota_frac_multipath", 0.5f));
            }
            return -1L;
        }

        @Override
        public void onAdminDataAvailable() {
            NetworkPolicyManagerService.this.mAdminDataAvailableLatch.countDown();
        }

        @Override
        public void setAppIdleWhitelist(int uid, boolean shouldWhitelist) {
            NetworkPolicyManagerService.this.setAppIdleWhitelist(uid, shouldWhitelist);
        }

        @Override
        public void setMeteredRestrictedPackages(Set<String> packageNames, int userId) {
            NetworkPolicyManagerService.this.setMeteredRestrictedPackagesInternal(packageNames, userId);
        }

        @Override
        public void setMeteredRestrictedPackagesAsync(Set<String> packageNames, int userId) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(17, userId, 0, packageNames).sendToTarget();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ChainToggleType {
    }

    private class AppIdleStateChangeListener
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        private AppIdleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle, int bucket, int reason) {
            try {
                int uid = NetworkPolicyManagerService.this.mContext.getPackageManager().getPackageUidAsUser(packageName, 8192, userId);
                Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.mLogger.appIdleStateChanged(uid, idle);
                    NetworkPolicyManagerService.this.updateRuleForAppIdleUL(uid);
                    NetworkPolicyManagerService.this.updateRulesForPowerRestrictionsUL(uid);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            Object object = NetworkPolicyManagerService.this.mUidRulesFirstLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.mLogger.paroleStateChanged(isParoleOn);
                NetworkPolicyManagerService.this.updateRulesForAppIdleParoleUL();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RestrictType {
    }

    static interface Stats {
        public static final int UPDATE_NETWORK_ENABLED = 0;
        public static final int IS_UID_NETWORKING_BLOCKED = 1;
        public static final int COUNT = 2;
    }
}

