/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.content.Context;
import android.net.NetworkPolicyManager;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.os.RemoteException;
import android.os.ShellCommand;
import com.android.server.net.NetworkPolicyManagerService;
import java.io.PrintWriter;
import java.util.List;

class NetworkPolicyManagerShellCommand
extends ShellCommand {
    private final NetworkPolicyManagerService mInterface;
    private final WifiManager mWifiManager;

    NetworkPolicyManagerShellCommand(Context context, NetworkPolicyManagerService service) {
        this.mInterface = service;
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "get": {
                    return this.runGet();
                }
                case "set": {
                    return this.runSet();
                }
                case "list": {
                    return this.runList();
                }
                case "add": {
                    return this.runAdd();
                }
                case "remove": {
                    return this.runRemove();
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        pw.println("Network policy manager (netpolicy) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("");
        pw.println("  add restrict-background-whitelist UID");
        pw.println("    Adds a UID to the whitelist for restrict background usage.");
        pw.println("  add restrict-background-blacklist UID");
        pw.println("    Adds a UID to the blacklist for restrict background usage.");
        pw.println("  add app-idle-whitelist UID");
        pw.println("    Adds a UID to the temporary app idle whitelist.");
        pw.println("  get restrict-background");
        pw.println("    Gets the global restrict background usage status.");
        pw.println("  list wifi-networks [true|false]");
        pw.println("    Lists all saved wifi networks and whether they are metered or not.");
        pw.println("    If a boolean argument is passed, filters just the metered (or unmetered)");
        pw.println("    networks.");
        pw.println("  list restrict-background-whitelist");
        pw.println("    Lists UIDs that are whitelisted for restrict background usage.");
        pw.println("  list restrict-background-blacklist");
        pw.println("    Lists UIDs that are blacklisted for restrict background usage.");
        pw.println("  remove restrict-background-whitelist UID");
        pw.println("    Removes a UID from the whitelist for restrict background usage.");
        pw.println("  remove restrict-background-blacklist UID");
        pw.println("    Removes a UID from the blacklist for restrict background usage.");
        pw.println("  remove app-idle-whitelist UID");
        pw.println("    Removes a UID from the temporary app idle whitelist.");
        pw.println("  set metered-network ID [undefined|true|false]");
        pw.println("    Toggles whether the given wi-fi network is metered.");
        pw.println("  set restrict-background BOOLEAN");
        pw.println("    Sets the global restrict background usage status.");
        pw.println("  set sub-plan-owner subId [packageName]");
        pw.println("    Sets the data plan owner package for subId.");
    }

    private int runGet() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to get");
            return -1;
        }
        switch (type) {
            case "restrict-background": {
                return this.getRestrictBackground();
            }
        }
        pw.println("Error: unknown get type '" + type + "'");
        return -1;
    }

    private int runSet() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to set");
            return -1;
        }
        switch (type) {
            case "metered-network": {
                return this.setMeteredWifiNetwork();
            }
            case "restrict-background": {
                return this.setRestrictBackground();
            }
            case "sub-plan-owner": {
                return this.setSubPlanOwner();
            }
        }
        pw.println("Error: unknown set type '" + type + "'");
        return -1;
    }

    private int runList() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to list");
            return -1;
        }
        switch (type) {
            case "app-idle-whitelist": {
                return this.listAppIdleWhitelist();
            }
            case "wifi-networks": {
                return this.listWifiNetworks();
            }
            case "restrict-background-whitelist": {
                return this.listRestrictBackgroundWhitelist();
            }
            case "restrict-background-blacklist": {
                return this.listRestrictBackgroundBlacklist();
            }
        }
        pw.println("Error: unknown list type '" + type + "'");
        return -1;
    }

    private int runAdd() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to add");
            return -1;
        }
        switch (type) {
            case "restrict-background-whitelist": {
                return this.addRestrictBackgroundWhitelist();
            }
            case "restrict-background-blacklist": {
                return this.addRestrictBackgroundBlacklist();
            }
            case "app-idle-whitelist": {
                return this.addAppIdleWhitelist();
            }
        }
        pw.println("Error: unknown add type '" + type + "'");
        return -1;
    }

    private int runRemove() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String type = this.getNextArg();
        if (type == null) {
            pw.println("Error: didn't specify type of data to remove");
            return -1;
        }
        switch (type) {
            case "restrict-background-whitelist": {
                return this.removeRestrictBackgroundWhitelist();
            }
            case "restrict-background-blacklist": {
                return this.removeRestrictBackgroundBlacklist();
            }
            case "app-idle-whitelist": {
                return this.removeAppIdleWhitelist();
            }
        }
        pw.println("Error: unknown remove type '" + type + "'");
        return -1;
    }

    private int listUidPolicies(String msg, int policy) throws RemoteException {
        int[] uids = this.mInterface.getUidsWithPolicy(policy);
        return this.listUidList(msg, uids);
    }

    private int listUidList(String msg, int[] uids) {
        PrintWriter pw = this.getOutPrintWriter();
        pw.print(msg);
        pw.print(": ");
        if (uids.length == 0) {
            pw.println("none");
        } else {
            for (int i = 0; i < uids.length; ++i) {
                int uid = uids[i];
                pw.print(uid);
                pw.print(' ');
            }
        }
        pw.println();
        return 0;
    }

    private int listRestrictBackgroundWhitelist() throws RemoteException {
        return this.listUidPolicies("Restrict background whitelisted UIDs", 4);
    }

    private int listRestrictBackgroundBlacklist() throws RemoteException {
        return this.listUidPolicies("Restrict background blacklisted UIDs", 1);
    }

    private int listAppIdleWhitelist() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        int[] uids = this.mInterface.getAppIdleWhitelist();
        return this.listUidList("App Idle whitelisted UIDs", uids);
    }

    private int getRestrictBackground() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        pw.print("Restrict background status: ");
        pw.println(this.mInterface.getRestrictBackground() ? "enabled" : "disabled");
        return 0;
    }

    private int setRestrictBackground() throws RemoteException {
        int enabled = this.getNextBooleanArg();
        if (enabled < 0) {
            return enabled;
        }
        this.mInterface.setRestrictBackground(enabled > 0);
        return 0;
    }

    private int setSubPlanOwner() throws RemoteException {
        int subId = Integer.parseInt(this.getNextArgRequired());
        String packageName = this.getNextArg();
        this.mInterface.setSubscriptionPlansOwner(subId, packageName);
        return 0;
    }

    private int setUidPolicy(int policy) throws RemoteException {
        int uid = this.getUidFromNextArg();
        if (uid < 0) {
            return uid;
        }
        this.mInterface.setUidPolicy(uid, policy);
        return 0;
    }

    private int resetUidPolicy(String errorMessage, int expectedPolicy) throws RemoteException {
        int uid = this.getUidFromNextArg();
        if (uid < 0) {
            return uid;
        }
        int actualPolicy = this.mInterface.getUidPolicy(uid);
        if (actualPolicy != expectedPolicy) {
            PrintWriter pw = this.getOutPrintWriter();
            pw.print("Error: UID ");
            pw.print(uid);
            pw.print(' ');
            pw.println(errorMessage);
            return -1;
        }
        this.mInterface.setUidPolicy(uid, 0);
        return 0;
    }

    private int addRestrictBackgroundWhitelist() throws RemoteException {
        return this.setUidPolicy(4);
    }

    private int removeRestrictBackgroundWhitelist() throws RemoteException {
        return this.resetUidPolicy("not whitelisted", 4);
    }

    private int addRestrictBackgroundBlacklist() throws RemoteException {
        return this.setUidPolicy(1);
    }

    private int removeRestrictBackgroundBlacklist() throws RemoteException {
        return this.resetUidPolicy("not blacklisted", 1);
    }

    private int setAppIdleWhitelist(boolean isWhitelisted) {
        int uid = this.getUidFromNextArg();
        if (uid < 0) {
            return uid;
        }
        this.mInterface.setAppIdleWhitelist(uid, isWhitelisted);
        return 0;
    }

    private int addAppIdleWhitelist() throws RemoteException {
        return this.setAppIdleWhitelist(true);
    }

    private int removeAppIdleWhitelist() throws RemoteException {
        return this.setAppIdleWhitelist(false);
    }

    private int listWifiNetworks() {
        PrintWriter pw = this.getOutPrintWriter();
        String arg = this.getNextArg();
        int match = arg == null ? 0 : (Boolean.parseBoolean(arg) ? 1 : 2);
        List<WifiConfiguration> configs = this.mWifiManager.getConfiguredNetworks();
        for (WifiConfiguration config : configs) {
            if (arg != null && config.meteredOverride != match) continue;
            pw.print(NetworkPolicyManager.resolveNetworkId(config));
            pw.print(';');
            pw.println(NetworkPolicyManagerShellCommand.overrideToString(config.meteredOverride));
        }
        return 0;
    }

    private int setMeteredWifiNetwork() throws RemoteException {
        PrintWriter pw = this.getOutPrintWriter();
        String networkId = this.getNextArg();
        if (networkId == null) {
            pw.println("Error: didn't specify networkId");
            return -1;
        }
        String arg = this.getNextArg();
        if (arg == null) {
            pw.println("Error: didn't specify meteredOverride");
            return -1;
        }
        this.mInterface.setWifiMeteredOverride(NetworkPolicyManager.resolveNetworkId(networkId), NetworkPolicyManagerShellCommand.stringToOverride(arg));
        return -1;
    }

    private static String overrideToString(int override) {
        switch (override) {
            case 1: {
                return "true";
            }
            case 2: {
                return "false";
            }
        }
        return "none";
    }

    private static int stringToOverride(String override) {
        switch (override) {
            case "true": {
                return 1;
            }
            case "false": {
                return 2;
            }
        }
        return 0;
    }

    private int getNextBooleanArg() {
        PrintWriter pw = this.getOutPrintWriter();
        String arg = this.getNextArg();
        if (arg == null) {
            pw.println("Error: didn't specify BOOLEAN");
            return -1;
        }
        return Boolean.valueOf(arg) != false ? 1 : 0;
    }

    private int getUidFromNextArg() {
        PrintWriter pw = this.getOutPrintWriter();
        String arg = this.getNextArg();
        if (arg == null) {
            pw.println("Error: didn't specify UID");
            return -1;
        }
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            pw.println("Error: UID (" + arg + ") should be a number");
            return -2;
        }
    }
}

