/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.AppOpsManager;
import android.app.admin.DevicePolicyManagerInternal;
import android.content.Context;
import android.os.UserHandle;
import android.telephony.TelephonyManager;
import com.android.server.LocalServices;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class NetworkStatsAccess {
    private NetworkStatsAccess() {
    }

    public static int checkAccessLevel(Context context, int callingUid, String callingPackage) {
        boolean isProfileOwner;
        boolean isDeviceOwner;
        DevicePolicyManagerInternal dpmi = LocalServices.getService(DevicePolicyManagerInternal.class);
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        boolean hasCarrierPrivileges = tm != null && tm.checkCarrierPrivilegesForPackageAnyPhone(callingPackage) == 1;
        boolean bl = isDeviceOwner = dpmi != null && dpmi.isActiveAdminWithPolicy(callingUid, -2);
        if (hasCarrierPrivileges || isDeviceOwner || UserHandle.getAppId(callingUid) == 1000) {
            return 3;
        }
        boolean hasAppOpsPermission = NetworkStatsAccess.hasAppOpsPermission(context, callingUid, callingPackage);
        if (hasAppOpsPermission || context.checkCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY") == 0) {
            return 2;
        }
        boolean bl2 = isProfileOwner = dpmi != null && dpmi.isActiveAdminWithPolicy(callingUid, -1);
        if (isProfileOwner) {
            return 1;
        }
        return 0;
    }

    public static boolean isAccessibleToUser(int uid, int callerUid, int accessLevel) {
        switch (accessLevel) {
            case 3: {
                return true;
            }
            case 2: {
                return uid == 1000 || uid == -4 || uid == -5 || uid == -1 || UserHandle.getUserId(uid) == UserHandle.getUserId(callerUid);
            }
            case 1: {
                return uid == 1000 || uid == -4 || uid == -5 || UserHandle.getUserId(uid) == UserHandle.getUserId(callerUid);
            }
        }
        return uid == callerUid;
    }

    private static boolean hasAppOpsPermission(Context context, int callingUid, String callingPackage) {
        if (callingPackage != null) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            int mode = appOps.noteOp(43, callingUid, callingPackage);
            if (mode == 3) {
                int permissionCheck = context.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS");
                return permissionCheck == 0;
            }
            return mode == 0;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Level {
        public static final int DEFAULT = 0;
        public static final int USER = 1;
        public static final int DEVICESUMMARY = 2;
        public static final int DEVICE = 3;
    }
}

