/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.net.ConnectivityManager;
import android.net.DataUsageRequest;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkStatsService;
import android.net.INetworkStatsSession;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkIdentity;
import android.net.NetworkStack;
import android.net.NetworkState;
import android.net.NetworkStats;
import android.net.NetworkStatsHistory;
import android.net.NetworkTemplate;
import android.os.BestClock;
import android.os.Binder;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.SubscriptionPlan;
import android.telephony.TelephonyManager;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.MathUtils;
import android.util.Slog;
import android.util.SparseIntArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.VpnInfo;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FileRotator;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.NetworkManagementSocketTagger;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.NetworkIdentitySet;
import com.android.server.net.NetworkPolicyManagerInternal;
import com.android.server.net.NetworkStatsAccess;
import com.android.server.net.NetworkStatsCollection;
import com.android.server.net.NetworkStatsFactory;
import com.android.server.net.NetworkStatsManagerInternal;
import com.android.server.net.NetworkStatsObservers;
import com.android.server.net.NetworkStatsRecorder;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.Clock;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class NetworkStatsService
extends INetworkStatsService.Stub {
    static final String TAG = "NetworkStats";
    static final boolean LOGD = Log.isLoggable("NetworkStats", 3);
    static final boolean LOGV = Log.isLoggable("NetworkStats", 2);
    private static final int MSG_PERFORM_POLL = 1;
    private static final int MSG_PERFORM_POLL_REGISTER_ALERT = 2;
    private static final int FLAG_PERSIST_NETWORK = 1;
    private static final int FLAG_PERSIST_UID = 2;
    private static final int FLAG_PERSIST_ALL = 3;
    private static final int FLAG_PERSIST_FORCE = 256;
    private static final int PERFORM_POLL_DELAY_MS = 1000;
    private static final String TAG_NETSTATS_ERROR = "netstats_error";
    private final Context mContext;
    private final INetworkManagementService mNetworkManager;
    private final AlarmManager mAlarmManager;
    private final Clock mClock;
    private final TelephonyManager mTeleManager;
    private final NetworkStatsSettings mSettings;
    private final NetworkStatsObservers mStatsObservers;
    private final File mSystemDir;
    private final File mBaseDir;
    private final PowerManager.WakeLock mWakeLock;
    private final boolean mUseBpfTrafficStats;
    @VisibleForTesting
    public static final String ACTION_NETWORK_STATS_POLL = "com.android.server.action.NETWORK_STATS_POLL";
    public static final String ACTION_NETWORK_STATS_UPDATED = "com.android.server.action.NETWORK_STATS_UPDATED";
    private PendingIntent mPollIntent;
    private static final String PREFIX_DEV = "dev";
    private static final String PREFIX_XT = "xt";
    private static final String PREFIX_UID = "uid";
    private static final String PREFIX_UID_TAG = "uid_tag";
    public static final String VT_INTERFACE = "vt_data0";
    private final Object mStatsLock = new Object();
    @GuardedBy(value={"mStatsLock"})
    private final ArrayMap<String, NetworkIdentitySet> mActiveIfaces = new ArrayMap();
    @GuardedBy(value={"mStatsLock"})
    private final ArrayMap<String, NetworkIdentitySet> mActiveUidIfaces = new ArrayMap();
    @GuardedBy(value={"mStatsLock"})
    private String mActiveIface;
    @GuardedBy(value={"mStatsLock"})
    private String[] mMobileIfaces = new String[0];
    @GuardedBy(value={"mStatsLock"})
    private Network[] mDefaultNetworks = new Network[0];
    @GuardedBy(value={"mStatsLock"})
    private VpnInfo[] mVpnInfos = new VpnInfo[0];
    private final DropBoxNonMonotonicObserver mNonMonotonicObserver = new DropBoxNonMonotonicObserver();
    @GuardedBy(value={"mStatsLock"})
    private NetworkStatsRecorder mDevRecorder;
    @GuardedBy(value={"mStatsLock"})
    private NetworkStatsRecorder mXtRecorder;
    @GuardedBy(value={"mStatsLock"})
    private NetworkStatsRecorder mUidRecorder;
    @GuardedBy(value={"mStatsLock"})
    private NetworkStatsRecorder mUidTagRecorder;
    @GuardedBy(value={"mStatsLock"})
    private NetworkStatsCollection mXtStatsCached;
    private SparseIntArray mActiveUidCounterSet = new SparseIntArray();
    private NetworkStats mUidOperations = new NetworkStats(0L, 10);
    private Handler mHandler;
    private Handler.Callback mHandlerCallback;
    private volatile boolean mSystemReady;
    private long mPersistThreshold = 0x200000L;
    private long mGlobalAlertBytes;
    private static final long POLL_RATE_LIMIT_MS = 15000L;
    private long mLastStatsSessionPoll;
    @GuardedBy(value={"mOpenSessionCallsPerUid"})
    private final SparseIntArray mOpenSessionCallsPerUid = new SparseIntArray();
    private static final int DUMP_STATS_SESSION_COUNT = 20;
    private BroadcastReceiver mTetherReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(1);
        }
    };
    private BroadcastReceiver mPollReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkStatsService.this.performPoll(3);
            NetworkStatsService.this.registerGlobalAlert();
        }
    };
    private BroadcastReceiver mRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.mWakeLock.acquire();
                try {
                    NetworkStatsService.this.removeUidsLocked(new int[]{uid});
                }
                finally {
                    NetworkStatsService.this.mWakeLock.release();
                }
            }
        }
    };
    private BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.mWakeLock.acquire();
                try {
                    NetworkStatsService.this.removeUserLocked(userId);
                }
                finally {
                    NetworkStatsService.this.mWakeLock.release();
                }
            }
        }
    };
    private BroadcastReceiver mShutdownReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkStatsService.this.mStatsLock;
            synchronized (object) {
                NetworkStatsService.this.shutdownLocked();
            }
        }
    };
    private INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        @Override
        public void limitReached(String limitName, String iface) {
            NetworkStatsService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkStatsService.TAG);
            if ("globalAlert".equals(limitName) && !NetworkStatsService.this.mHandler.hasMessages(2)) {
                NetworkStatsService.this.mHandler.sendEmptyMessageDelayed(2, 1000L);
            }
        }
    };
    private static int TYPE_RX_BYTES;
    private static int TYPE_RX_PACKETS;
    private static int TYPE_TX_BYTES;
    private static int TYPE_TX_PACKETS;
    private static int TYPE_TCP_RX_PACKETS;
    private static int TYPE_TCP_TX_PACKETS;

    private static File getDefaultSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    private static File getDefaultBaseDir() {
        File baseDir = new File(NetworkStatsService.getDefaultSystemDir(), "netstats");
        baseDir.mkdirs();
        return baseDir;
    }

    private static Clock getDefaultClock() {
        return new BestClock(ZoneOffset.UTC, SystemClock.currentNetworkTimeClock(), Clock.systemUTC());
    }

    public static NetworkStatsService create(Context context, INetworkManagementService networkManager) {
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(1, TAG);
        NetworkStatsService service = new NetworkStatsService(context, networkManager, alarmManager, wakeLock, NetworkStatsService.getDefaultClock(), TelephonyManager.getDefault(), new DefaultNetworkStatsSettings(context), new NetworkStatsObservers(), NetworkStatsService.getDefaultSystemDir(), NetworkStatsService.getDefaultBaseDir());
        service.registerLocalService();
        HandlerThread handlerThread = new HandlerThread(TAG);
        HandlerCallback callback = new HandlerCallback(service);
        handlerThread.start();
        NetworkStatsHandler handler = new NetworkStatsHandler(handlerThread.getLooper(), callback);
        service.setHandler(handler, callback);
        return service;
    }

    @VisibleForTesting
    NetworkStatsService(Context context, INetworkManagementService networkManager, AlarmManager alarmManager, PowerManager.WakeLock wakeLock, Clock clock, TelephonyManager teleManager, NetworkStatsSettings settings, NetworkStatsObservers statsObservers, File systemDir, File baseDir) {
        this.mContext = Preconditions.checkNotNull(context, "missing Context");
        this.mNetworkManager = Preconditions.checkNotNull(networkManager, "missing INetworkManagementService");
        this.mAlarmManager = Preconditions.checkNotNull(alarmManager, "missing AlarmManager");
        this.mClock = Preconditions.checkNotNull(clock, "missing Clock");
        this.mSettings = Preconditions.checkNotNull(settings, "missing NetworkStatsSettings");
        this.mTeleManager = Preconditions.checkNotNull(teleManager, "missing TelephonyManager");
        this.mWakeLock = Preconditions.checkNotNull(wakeLock, "missing WakeLock");
        this.mStatsObservers = Preconditions.checkNotNull(statsObservers, "missing NetworkStatsObservers");
        this.mSystemDir = Preconditions.checkNotNull(systemDir, "missing systemDir");
        this.mBaseDir = Preconditions.checkNotNull(baseDir, "missing baseDir");
        this.mUseBpfTrafficStats = new File("/sys/fs/bpf/map_netd_app_uid_stats_map").exists();
    }

    private void registerLocalService() {
        LocalServices.addService(NetworkStatsManagerInternal.class, new NetworkStatsManagerInternalImpl());
    }

    @VisibleForTesting
    void setHandler(Handler handler, Handler.Callback callback) {
        this.mHandler = handler;
        this.mHandlerCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        this.mSystemReady = true;
        if (!this.isBandwidthControlEnabled()) {
            Slog.w(TAG, "bandwidth controls disabled, unable to track stats");
            return;
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mDevRecorder = this.buildRecorder(PREFIX_DEV, this.mSettings.getDevConfig(), false);
            this.mXtRecorder = this.buildRecorder(PREFIX_XT, this.mSettings.getXtConfig(), false);
            this.mUidRecorder = this.buildRecorder(PREFIX_UID, this.mSettings.getUidConfig(), false);
            this.mUidTagRecorder = this.buildRecorder(PREFIX_UID_TAG, this.mSettings.getUidTagConfig(), true);
            this.updatePersistThresholdsLocked();
            this.maybeUpgradeLegacyStatsLocked();
            this.mXtStatsCached = this.mXtRecorder.getOrLoadCompleteLocked();
            this.bootstrapStatsLocked();
        }
        IntentFilter tetherFilter = new IntentFilter("android.net.conn.TETHER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mTetherReceiver, tetherFilter, null, this.mHandler);
        IntentFilter pollFilter = new IntentFilter(ACTION_NETWORK_STATS_POLL);
        this.mContext.registerReceiver(this.mPollReceiver, pollFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter removedFilter = new IntentFilter("android.intent.action.UID_REMOVED");
        this.mContext.registerReceiver(this.mRemovedReceiver, removedFilter, null, this.mHandler);
        IntentFilter userFilter = new IntentFilter("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        IntentFilter shutdownFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        this.mContext.registerReceiver(this.mShutdownReceiver, shutdownFilter);
        try {
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.registerPollAlarmLocked();
        this.registerGlobalAlert();
    }

    private NetworkStatsRecorder buildRecorder(String prefix, NetworkStatsSettings.Config config, boolean includeTags) {
        DropBoxManager dropBox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        return new NetworkStatsRecorder(new FileRotator(this.mBaseDir, prefix, config.rotateAgeMillis, config.deleteAgeMillis), this.mNonMonotonicObserver, dropBox, prefix, config.bucketDuration, includeTags);
    }

    @GuardedBy(value={"mStatsLock"})
    private void shutdownLocked() {
        this.mContext.unregisterReceiver(this.mTetherReceiver);
        this.mContext.unregisterReceiver(this.mPollReceiver);
        this.mContext.unregisterReceiver(this.mRemovedReceiver);
        this.mContext.unregisterReceiver(this.mUserReceiver);
        this.mContext.unregisterReceiver(this.mShutdownReceiver);
        long currentTime = this.mClock.millis();
        this.mDevRecorder.forcePersistLocked(currentTime);
        this.mXtRecorder.forcePersistLocked(currentTime);
        this.mUidRecorder.forcePersistLocked(currentTime);
        this.mUidTagRecorder.forcePersistLocked(currentTime);
        this.mSystemReady = false;
    }

    @GuardedBy(value={"mStatsLock"})
    private void maybeUpgradeLegacyStatsLocked() {
        try {
            File file = new File(this.mSystemDir, "netstats.bin");
            if (file.exists()) {
                this.mDevRecorder.importLegacyNetworkLocked(file);
                file.delete();
            }
            if ((file = new File(this.mSystemDir, "netstats_xt.bin")).exists()) {
                file.delete();
            }
            if ((file = new File(this.mSystemDir, "netstats_uid.bin")).exists()) {
                this.mUidRecorder.importLegacyUidLocked(file);
                this.mUidTagRecorder.importLegacyUidLocked(file);
                file.delete();
            }
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem during legacy upgrade", e);
        }
        catch (OutOfMemoryError e) {
            Log.wtf(TAG, "problem during legacy upgrade", e);
        }
    }

    private void registerPollAlarmLocked() {
        if (this.mPollIntent != null) {
            this.mAlarmManager.cancel(this.mPollIntent);
        }
        this.mPollIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_NETWORK_STATS_POLL), 0);
        long currentRealtime = SystemClock.elapsedRealtime();
        this.mAlarmManager.setInexactRepeating(3, currentRealtime, this.mSettings.getPollInterval(), this.mPollIntent);
    }

    private void registerGlobalAlert() {
        try {
            this.mNetworkManager.setGlobalAlert(this.mGlobalAlertBytes);
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "problem registering for global alert: " + e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Override
    public INetworkStatsSession openSession() {
        return this.openSessionInternal(4, null);
    }

    @Override
    public INetworkStatsSession openSessionForUsageStats(int flags, String callingPackage) {
        return this.openSessionInternal(flags, callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRateLimitedForPoll(int callingUid) {
        long lastCallTime;
        if (callingUid == 1000) {
            return false;
        }
        long now = SystemClock.elapsedRealtime();
        SparseIntArray sparseIntArray = this.mOpenSessionCallsPerUid;
        synchronized (sparseIntArray) {
            int calls = this.mOpenSessionCallsPerUid.get(callingUid, 0);
            this.mOpenSessionCallsPerUid.put(callingUid, calls + 1);
            lastCallTime = this.mLastStatsSessionPoll;
            this.mLastStatsSessionPoll = now;
        }
        return now - lastCallTime < 15000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetworkStatsSession openSessionInternal(int flags, final String callingPackage) {
        int usedFlags;
        this.assertBandwidthControlEnabled();
        final int callingUid = Binder.getCallingUid();
        int n = usedFlags = this.isRateLimitedForPoll(callingUid) ? flags & 0xFFFFFFFE : flags;
        if ((usedFlags & 3) != 0) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.performPoll(3);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return new INetworkStatsSession.Stub(){
            private final int mCallingUid;
            private final String mCallingPackage;
            private final int mAccessLevel;
            private NetworkStatsCollection mUidComplete;
            private NetworkStatsCollection mUidTagComplete;
            {
                this.mCallingUid = callingUid;
                this.mCallingPackage = callingPackage;
                this.mAccessLevel = NetworkStatsService.this.checkAccessLevel(callingPackage);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NetworkStatsCollection getUidComplete() {
                Object object = NetworkStatsService.this.mStatsLock;
                synchronized (object) {
                    if (this.mUidComplete == null) {
                        this.mUidComplete = NetworkStatsService.this.mUidRecorder.getOrLoadCompleteLocked();
                    }
                    return this.mUidComplete;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NetworkStatsCollection getUidTagComplete() {
                Object object = NetworkStatsService.this.mStatsLock;
                synchronized (object) {
                    if (this.mUidTagComplete == null) {
                        this.mUidTagComplete = NetworkStatsService.this.mUidTagRecorder.getOrLoadCompleteLocked();
                    }
                    return this.mUidTagComplete;
                }
            }

            @Override
            public int[] getRelevantUids() {
                return this.getUidComplete().getRelevantUids(this.mAccessLevel);
            }

            @Override
            public NetworkStats getDeviceSummaryForNetwork(NetworkTemplate template, long start, long end) {
                return NetworkStatsService.this.internalGetSummaryForNetwork(template, usedFlags, start, end, this.mAccessLevel, this.mCallingUid);
            }

            @Override
            public NetworkStats getSummaryForNetwork(NetworkTemplate template, long start, long end) {
                return NetworkStatsService.this.internalGetSummaryForNetwork(template, usedFlags, start, end, this.mAccessLevel, this.mCallingUid);
            }

            @Override
            public NetworkStatsHistory getHistoryForNetwork(NetworkTemplate template, int fields) {
                return NetworkStatsService.this.internalGetHistoryForNetwork(template, usedFlags, fields, this.mAccessLevel, this.mCallingUid);
            }

            @Override
            public NetworkStats getSummaryForAllUid(NetworkTemplate template, long start, long end, boolean includeTags) {
                try {
                    NetworkStats stats = this.getUidComplete().getSummary(template, start, end, this.mAccessLevel, this.mCallingUid);
                    if (includeTags) {
                        NetworkStats tagStats = this.getUidTagComplete().getSummary(template, start, end, this.mAccessLevel, this.mCallingUid);
                        stats.combineAllValues(tagStats);
                    }
                    return stats;
                }
                catch (NullPointerException e) {
                    Slog.wtf(NetworkStatsService.TAG, "NullPointerException in getSummaryForAllUid", e);
                    throw e;
                }
            }

            @Override
            public NetworkStatsHistory getHistoryForUid(NetworkTemplate template, int uid, int set, int tag, int fields) {
                if (tag == 0) {
                    return this.getUidComplete().getHistory(template, null, uid, set, tag, fields, Long.MIN_VALUE, Long.MAX_VALUE, this.mAccessLevel, this.mCallingUid);
                }
                return this.getUidTagComplete().getHistory(template, null, uid, set, tag, fields, Long.MIN_VALUE, Long.MAX_VALUE, this.mAccessLevel, this.mCallingUid);
            }

            @Override
            public NetworkStatsHistory getHistoryIntervalForUid(NetworkTemplate template, int uid, int set, int tag, int fields, long start, long end) {
                if (tag == 0) {
                    return this.getUidComplete().getHistory(template, null, uid, set, tag, fields, start, end, this.mAccessLevel, this.mCallingUid);
                }
                if (uid == Binder.getCallingUid()) {
                    return this.getUidTagComplete().getHistory(template, null, uid, set, tag, fields, start, end, this.mAccessLevel, this.mCallingUid);
                }
                throw new SecurityException("Calling package " + this.mCallingPackage + " cannot access tag information from a different uid");
            }

            @Override
            public void close() {
                this.mUidComplete = null;
                this.mUidTagComplete = null;
            }
        };
    }

    private int checkAccessLevel(String callingPackage) {
        return NetworkStatsAccess.checkAccessLevel(this.mContext, Binder.getCallingUid(), callingPackage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionPlan resolveSubscriptionPlan(NetworkTemplate template, int flags) {
        SubscriptionPlan plan = null;
        if ((flags & 4) != 0 && this.mSettings.getAugmentEnabled()) {
            if (LOGD) {
                Slog.d(TAG, "Resolving plan for " + template);
            }
            long token = Binder.clearCallingIdentity();
            try {
                plan = LocalServices.getService(NetworkPolicyManagerInternal.class).getSubscriptionPlan(template);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (LOGD) {
                Slog.d(TAG, "Resolved to plan " + plan);
            }
        }
        return plan;
    }

    private NetworkStats internalGetSummaryForNetwork(NetworkTemplate template, int flags, long start, long end, int accessLevel, int callingUid) {
        NetworkStatsHistory history = this.internalGetHistoryForNetwork(template, flags, -1, accessLevel, callingUid);
        long now = System.currentTimeMillis();
        NetworkStatsHistory.Entry entry = history.getValues(start, end, now, null);
        NetworkStats stats = new NetworkStats(end - start, 1);
        stats.addValues(new NetworkStats.Entry(NetworkStats.IFACE_ALL, -1, -1, 0, -1, -1, -1, entry.rxBytes, entry.rxPackets, entry.txBytes, entry.txPackets, entry.operations));
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkStatsHistory internalGetHistoryForNetwork(NetworkTemplate template, int flags, int fields, int accessLevel, int callingUid) {
        SubscriptionPlan augmentPlan = this.resolveSubscriptionPlan(template, flags);
        Object object = this.mStatsLock;
        synchronized (object) {
            return this.mXtStatsCached.getHistory(template, augmentPlan, -1, -1, 0, fields, Long.MIN_VALUE, Long.MAX_VALUE, accessLevel, callingUid);
        }
    }

    private long getNetworkTotalBytes(NetworkTemplate template, long start, long end) {
        this.assertSystemReady();
        this.assertBandwidthControlEnabled();
        return this.internalGetSummaryForNetwork(template, 4, start, end, 3, Binder.getCallingUid()).getTotalBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkStats getNetworkUidBytes(NetworkTemplate template, long start, long end) {
        NetworkStatsCollection uidComplete;
        this.assertSystemReady();
        this.assertBandwidthControlEnabled();
        Object object = this.mStatsLock;
        synchronized (object) {
            uidComplete = this.mUidRecorder.getOrLoadCompleteLocked();
        }
        return uidComplete.getSummary(template, start, end, 3, 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkStats getDataLayerSnapshotForUid(int uid) throws RemoteException {
        NetworkStats networkLayer;
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        }
        this.assertBandwidthControlEnabled();
        long token = Binder.clearCallingIdentity();
        try {
            networkLayer = this.mNetworkManager.getNetworkStatsUidDetail(uid, NetworkStats.INTERFACES_ALL);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        networkLayer.spliceOperationsFrom(this.mUidOperations);
        NetworkStats dataLayer = new NetworkStats(networkLayer.getElapsedRealtime(), networkLayer.size());
        NetworkStats.Entry entry = null;
        for (int i = 0; i < networkLayer.size(); ++i) {
            entry = networkLayer.getValues(i, entry);
            entry.iface = NetworkStats.IFACE_ALL;
            dataLayer.combineValues(entry);
        }
        return dataLayer;
    }

    @Override
    public NetworkStats getDetailedUidStats(String[] requiredIfaces) {
        try {
            String[] ifacesToQuery = NetworkStatsFactory.augmentWithStackedInterfaces(requiredIfaces);
            return this.getNetworkStatsUidDetail(ifacesToQuery);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Error compiling UID stats", e);
            return new NetworkStats(0L, 0);
        }
    }

    @Override
    public String[] getMobileIfaces() {
        return this.mMobileIfaces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void incrementOperationCount(int uid, int tag, int operationCount) {
        if (Binder.getCallingUid() != uid) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.UPDATE_DEVICE_STATS", TAG);
        }
        if (operationCount < 0) {
            throw new IllegalArgumentException("operation count can only be incremented");
        }
        if (tag == 0) {
            throw new IllegalArgumentException("operation count must have specific tag");
        }
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = this.mActiveUidCounterSet.get(uid, 0);
            this.mUidOperations.combineValues(this.mActiveIface, uid, set, tag, 0L, 0L, 0L, 0L, operationCount);
            this.mUidOperations.combineValues(this.mActiveIface, uid, set, 0, 0L, 0L, 0L, 0L, operationCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setUidForeground(int uid, boolean uidForeground) {
        Object object = this.mStatsLock;
        synchronized (object) {
            int set = uidForeground ? 1 : 0;
            int oldSet = this.mActiveUidCounterSet.get(uid, 0);
            if (oldSet != set) {
                this.mActiveUidCounterSet.put(uid, set);
                NetworkManagementSocketTagger.setKernelCounterSet(uid, set);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceUpdateIfaces(Network[] defaultNetworks, VpnInfo[] vpnArray, NetworkState[] networkStates, String activeIface) {
        NetworkStack.checkNetworkStackPermission(this.mContext);
        this.assertBandwidthControlEnabled();
        long token = Binder.clearCallingIdentity();
        try {
            this.updateIfaces(defaultNetworks, vpnArray, networkStates, activeIface);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public void forceUpdate() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_NETWORK_USAGE_HISTORY", TAG);
        this.assertBandwidthControlEnabled();
        long token = Binder.clearCallingIdentity();
        try {
            this.performPoll(3);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void advisePersistThreshold(long thresholdBytes) {
        this.assertBandwidthControlEnabled();
        this.mPersistThreshold = MathUtils.constrain(thresholdBytes, 131072L, 0x200000L);
        if (LOGV) {
            Slog.v(TAG, "advisePersistThreshold() given " + thresholdBytes + ", clamped to " + this.mPersistThreshold);
        }
        long currentTime = this.mClock.millis();
        Object object = this.mStatsLock;
        synchronized (object) {
            if (!this.mSystemReady) {
                return;
            }
            this.updatePersistThresholdsLocked();
            this.mDevRecorder.maybePersistLocked(currentTime);
            this.mXtRecorder.maybePersistLocked(currentTime);
            this.mUidRecorder.maybePersistLocked(currentTime);
            this.mUidTagRecorder.maybePersistLocked(currentTime);
        }
        this.registerGlobalAlert();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataUsageRequest registerUsageCallback(String callingPackage, DataUsageRequest request, Messenger messenger, IBinder binder) {
        DataUsageRequest normalizedRequest;
        Preconditions.checkNotNull(callingPackage, "calling package is null");
        Preconditions.checkNotNull(request, "DataUsageRequest is null");
        Preconditions.checkNotNull(request.template, "NetworkTemplate is null");
        Preconditions.checkNotNull(messenger, "messenger is null");
        Preconditions.checkNotNull(binder, "binder is null");
        int callingUid = Binder.getCallingUid();
        int accessLevel = this.checkAccessLevel(callingPackage);
        long token = Binder.clearCallingIdentity();
        try {
            normalizedRequest = this.mStatsObservers.register(request, messenger, binder, callingUid, accessLevel);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1));
        return normalizedRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUsageRequest(DataUsageRequest request) {
        Preconditions.checkNotNull(request, "DataUsageRequest is null");
        int callingUid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            this.mStatsObservers.unregister(request, callingUid);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public long getUidStats(int uid, int type) {
        return NetworkStatsService.nativeGetUidStat(uid, type, this.checkBpfStatsEnable());
    }

    @Override
    public long getIfaceStats(String iface, int type) {
        long nativeIfaceStats = NetworkStatsService.nativeGetIfaceStat(iface, type, this.checkBpfStatsEnable());
        if (nativeIfaceStats == -1L) {
            return nativeIfaceStats;
        }
        return nativeIfaceStats + this.getTetherStats(iface, type);
    }

    @Override
    public long getTotalStats(int type) {
        long nativeTotalStats = NetworkStatsService.nativeGetTotalStat(type, this.checkBpfStatsEnable());
        if (nativeTotalStats == -1L) {
            return nativeTotalStats;
        }
        return nativeTotalStats + this.getTetherStats(NetworkStats.IFACE_ALL, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getTetherStats(String iface, int type) {
        HashSet<String> limitIfaces;
        NetworkStats tetherSnapshot;
        long token = Binder.clearCallingIdentity();
        try {
            tetherSnapshot = this.getNetworkStatsTethering(0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Error get TetherStats: " + e);
            long l = 0L;
            return l;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (iface == NetworkStats.IFACE_ALL) {
            limitIfaces = null;
        } else {
            limitIfaces = new HashSet<String>();
            limitIfaces.add(iface);
        }
        NetworkStats.Entry entry = tetherSnapshot.getTotal(null, limitIfaces);
        if (LOGD) {
            Slog.d(TAG, "TetherStats: iface=" + iface + " type=" + type + " entry=" + entry);
        }
        switch (type) {
            case 0: {
                return entry.rxBytes;
            }
            case 1: {
                return entry.rxPackets;
            }
            case 2: {
                return entry.txBytes;
            }
            case 3: {
                return entry.txPackets;
            }
        }
        return 0L;
    }

    private boolean checkBpfStatsEnable() {
        return this.mUseBpfTrafficStats;
    }

    @GuardedBy(value={"mStatsLock"})
    private void updatePersistThresholdsLocked() {
        this.mDevRecorder.setPersistThreshold(this.mSettings.getDevPersistBytes(this.mPersistThreshold));
        this.mXtRecorder.setPersistThreshold(this.mSettings.getXtPersistBytes(this.mPersistThreshold));
        this.mUidRecorder.setPersistThreshold(this.mSettings.getUidPersistBytes(this.mPersistThreshold));
        this.mUidTagRecorder.setPersistThreshold(this.mSettings.getUidTagPersistBytes(this.mPersistThreshold));
        this.mGlobalAlertBytes = this.mSettings.getGlobalAlertBytes(this.mPersistThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIfaces(Network[] defaultNetworks, VpnInfo[] vpnArray, NetworkState[] networkStates, String activeIface) {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            try {
                this.mVpnInfos = vpnArray;
                this.mActiveIface = activeIface;
                this.updateIfacesLocked(defaultNetworks, networkStates);
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    @GuardedBy(value={"mStatsLock"})
    private void updateIfacesLocked(Network[] defaultNetworks, NetworkState[] states) {
        if (!this.mSystemReady) {
            return;
        }
        if (LOGV) {
            Slog.v(TAG, "updateIfacesLocked()");
        }
        this.performPollLocked(1);
        this.mActiveIfaces.clear();
        this.mActiveUidIfaces.clear();
        if (defaultNetworks != null) {
            this.mDefaultNetworks = defaultNetworks;
        }
        ArraySet<String> mobileIfaces = new ArraySet<String>();
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            boolean isMobile = ConnectivityManager.isNetworkTypeMobile(state.networkInfo.getType());
            boolean isDefault = ArrayUtils.contains(this.mDefaultNetworks, state.network);
            NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state, isDefault);
            String baseIface = state.linkProperties.getInterfaceName();
            if (baseIface != null) {
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveIfaces, baseIface).add(ident);
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveUidIfaces, baseIface).add(ident);
                if (state.networkCapabilities.hasCapability(4) && !ident.getMetered()) {
                    NetworkIdentity vtIdent = new NetworkIdentity(ident.getType(), ident.getSubType(), ident.getSubscriberId(), ident.getNetworkId(), ident.getRoaming(), true, true);
                    NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveIfaces, VT_INTERFACE).add(vtIdent);
                    NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveUidIfaces, VT_INTERFACE).add(vtIdent);
                }
                if (isMobile) {
                    mobileIfaces.add(baseIface);
                }
            }
            List<LinkProperties> stackedLinks = state.linkProperties.getStackedLinks();
            for (LinkProperties stackedLink : stackedLinks) {
                String stackedIface = stackedLink.getInterfaceName();
                if (stackedIface == null) continue;
                if (this.mUseBpfTrafficStats) {
                    NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveIfaces, stackedIface).add(ident);
                }
                NetworkStatsService.findOrCreateNetworkIdentitySet(this.mActiveUidIfaces, stackedIface).add(ident);
                if (isMobile) {
                    mobileIfaces.add(stackedIface);
                }
                NetworkStatsFactory.noteStackedIface(stackedIface, baseIface);
            }
        }
        this.mMobileIfaces = mobileIfaces.toArray(new String[mobileIfaces.size()]);
    }

    private static <K> NetworkIdentitySet findOrCreateNetworkIdentitySet(ArrayMap<K, NetworkIdentitySet> map, K key) {
        NetworkIdentitySet ident = map.get(key);
        if (ident == null) {
            ident = new NetworkIdentitySet();
            map.put(key, ident);
        }
        return ident;
    }

    @GuardedBy(value={"mStatsLock"})
    private void recordSnapshotLocked(long currentTime) throws RemoteException {
        Trace.traceBegin(0x200000L, "snapshotUid");
        NetworkStats uidSnapshot = this.getNetworkStatsUidDetail(NetworkStats.INTERFACES_ALL);
        Trace.traceEnd(0x200000L);
        Trace.traceBegin(0x200000L, "snapshotXt");
        NetworkStats xtSnapshot = this.getNetworkStatsXt();
        Trace.traceEnd(0x200000L);
        Trace.traceBegin(0x200000L, "snapshotDev");
        NetworkStats devSnapshot = this.mNetworkManager.getNetworkStatsSummaryDev();
        Trace.traceEnd(0x200000L);
        Trace.traceBegin(0x200000L, "snapshotTether");
        NetworkStats tetherSnapshot = this.getNetworkStatsTethering(0);
        Trace.traceEnd(0x200000L);
        xtSnapshot.combineAllValues(tetherSnapshot);
        devSnapshot.combineAllValues(tetherSnapshot);
        Trace.traceBegin(0x200000L, "recordDev");
        this.mDevRecorder.recordSnapshotLocked(devSnapshot, this.mActiveIfaces, null, currentTime);
        Trace.traceEnd(0x200000L);
        Trace.traceBegin(0x200000L, "recordXt");
        this.mXtRecorder.recordSnapshotLocked(xtSnapshot, this.mActiveIfaces, null, currentTime);
        Trace.traceEnd(0x200000L);
        VpnInfo[] vpnArray = this.mVpnInfos;
        Trace.traceBegin(0x200000L, "recordUid");
        this.mUidRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, vpnArray, currentTime);
        Trace.traceEnd(0x200000L);
        Trace.traceBegin(0x200000L, "recordUidTag");
        this.mUidTagRecorder.recordSnapshotLocked(uidSnapshot, this.mActiveUidIfaces, vpnArray, currentTime);
        Trace.traceEnd(0x200000L);
        this.mStatsObservers.updateStats(xtSnapshot, uidSnapshot, new ArrayMap<String, NetworkIdentitySet>(this.mActiveIfaces), new ArrayMap<String, NetworkIdentitySet>(this.mActiveUidIfaces), vpnArray, currentTime);
    }

    @GuardedBy(value={"mStatsLock"})
    private void bootstrapStatsLocked() {
        long currentTime = this.mClock.millis();
        try {
            this.recordSnapshotLocked(currentTime);
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "problem reading network stats: " + e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPoll(int flags) {
        Object object = this.mStatsLock;
        synchronized (object) {
            this.mWakeLock.acquire();
            try {
                this.performPollLocked(flags);
            }
            finally {
                this.mWakeLock.release();
            }
        }
    }

    @GuardedBy(value={"mStatsLock"})
    private void performPollLocked(int flags) {
        if (!this.mSystemReady) {
            return;
        }
        if (LOGV) {
            Slog.v(TAG, "performPollLocked(flags=0x" + Integer.toHexString(flags) + ")");
        }
        Trace.traceBegin(0x200000L, "performPollLocked");
        boolean persistNetwork = (flags & 1) != 0;
        boolean persistUid = (flags & 2) != 0;
        boolean persistForce = (flags & 0x100) != 0;
        long currentTime = this.mClock.millis();
        try {
            this.recordSnapshotLocked(currentTime);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem reading network stats", e);
            return;
        }
        catch (RemoteException e) {
            return;
        }
        Trace.traceBegin(0x200000L, "[persisting]");
        if (persistForce) {
            this.mDevRecorder.forcePersistLocked(currentTime);
            this.mXtRecorder.forcePersistLocked(currentTime);
            this.mUidRecorder.forcePersistLocked(currentTime);
            this.mUidTagRecorder.forcePersistLocked(currentTime);
        } else {
            if (persistNetwork) {
                this.mDevRecorder.maybePersistLocked(currentTime);
                this.mXtRecorder.maybePersistLocked(currentTime);
            }
            if (persistUid) {
                this.mUidRecorder.maybePersistLocked(currentTime);
                this.mUidTagRecorder.maybePersistLocked(currentTime);
            }
        }
        Trace.traceEnd(0x200000L);
        if (this.mSettings.getSampleEnabled()) {
            this.performSampleLocked();
        }
        Intent updatedIntent = new Intent(ACTION_NETWORK_STATS_UPDATED);
        updatedIntent.setFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(updatedIntent, UserHandle.ALL, "android.permission.READ_NETWORK_USAGE_HISTORY");
        Trace.traceEnd(0x200000L);
    }

    @GuardedBy(value={"mStatsLock"})
    private void performSampleLocked() {
        long currentTime = this.mClock.millis();
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileWildcard();
        NetworkStats.Entry devTotal = this.mDevRecorder.getTotalSinceBootLocked(template);
        NetworkStats.Entry xtTotal = this.mXtRecorder.getTotalSinceBootLocked(template);
        NetworkStats.Entry uidTotal = this.mUidRecorder.getTotalSinceBootLocked(template);
        EventLogTags.writeNetstatsMobileSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, currentTime);
        template = NetworkTemplate.buildTemplateWifiWildcard();
        devTotal = this.mDevRecorder.getTotalSinceBootLocked(template);
        xtTotal = this.mXtRecorder.getTotalSinceBootLocked(template);
        uidTotal = this.mUidRecorder.getTotalSinceBootLocked(template);
        EventLogTags.writeNetstatsWifiSample(devTotal.rxBytes, devTotal.rxPackets, devTotal.txBytes, devTotal.txPackets, xtTotal.rxBytes, xtTotal.rxPackets, xtTotal.txBytes, xtTotal.txPackets, uidTotal.rxBytes, uidTotal.rxPackets, uidTotal.txBytes, uidTotal.txPackets, currentTime);
    }

    @GuardedBy(value={"mStatsLock"})
    private void removeUidsLocked(int ... uids) {
        if (LOGV) {
            Slog.v(TAG, "removeUidsLocked() for UIDs " + Arrays.toString(uids));
        }
        this.performPollLocked(3);
        this.mUidRecorder.removeUidsLocked(uids);
        this.mUidTagRecorder.removeUidsLocked(uids);
        for (int uid : uids) {
            NetworkManagementSocketTagger.resetKernelUidStats(uid);
        }
    }

    @GuardedBy(value={"mStatsLock"})
    private void removeUserLocked(int userId) {
        if (LOGV) {
            Slog.v(TAG, "removeUserLocked() for userId=" + userId);
        }
        int[] uids = new int[]{};
        List<ApplicationInfo> apps = this.mContext.getPackageManager().getInstalledApplications(0x400200);
        for (ApplicationInfo app : apps) {
            int uid = UserHandle.getUid(userId, app.uid);
            uids = ArrayUtils.appendInt(uids, uid);
        }
        this.removeUidsLocked(uids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter rawWriter, String[] args) {
        if (!DumpUtils.checkDumpPermission(this.mContext, TAG, rawWriter)) {
            return;
        }
        long duration = 86400000L;
        HashSet<String> argSet = new HashSet<String>();
        for (String arg : args) {
            argSet.add(arg);
            if (!arg.startsWith("--duration=")) continue;
            try {
                duration = Long.parseLong(arg.substring(11));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        boolean poll = argSet.contains("--poll") || argSet.contains("poll");
        boolean checkin = argSet.contains("--checkin");
        boolean fullHistory = argSet.contains("--full") || argSet.contains("full");
        boolean includeUid = argSet.contains("--uid") || argSet.contains("detail");
        boolean includeTag = argSet.contains("--tag") || argSet.contains("detail");
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)rawWriter, "  ");
        Object object = this.mStatsLock;
        synchronized (object) {
            SparseIntArray calls;
            int i;
            if (args.length > 0 && "--proto".equals(args[0])) {
                this.dumpProtoLocked(fd);
                return;
            }
            if (poll) {
                this.performPollLocked(259);
                pw.println("Forced poll");
                return;
            }
            if (checkin) {
                long end = System.currentTimeMillis();
                long start = end - duration;
                pw.print("v1,");
                pw.print(start / 1000L);
                pw.print(',');
                pw.print(end / 1000L);
                pw.println();
                pw.println(PREFIX_XT);
                this.mXtRecorder.dumpCheckin(rawWriter, start, end);
                if (includeUid) {
                    pw.println(PREFIX_UID);
                    this.mUidRecorder.dumpCheckin(rawWriter, start, end);
                }
                if (includeTag) {
                    pw.println("tag");
                    this.mUidTagRecorder.dumpCheckin(rawWriter, start, end);
                }
                return;
            }
            pw.println("Active interfaces:");
            pw.increaseIndent();
            for (i = 0; i < this.mActiveIfaces.size(); ++i) {
                pw.printPair("iface", this.mActiveIfaces.keyAt(i));
                pw.printPair("ident", this.mActiveIfaces.valueAt(i));
                pw.println();
            }
            pw.decreaseIndent();
            pw.println("Active UID interfaces:");
            pw.increaseIndent();
            for (i = 0; i < this.mActiveUidIfaces.size(); ++i) {
                pw.printPair("iface", this.mActiveUidIfaces.keyAt(i));
                pw.printPair("ident", this.mActiveUidIfaces.valueAt(i));
                pw.println();
            }
            pw.decreaseIndent();
            SparseIntArray sparseIntArray = this.mOpenSessionCallsPerUid;
            synchronized (sparseIntArray) {
                calls = this.mOpenSessionCallsPerUid.clone();
            }
            int N = calls.size();
            long[] values = new long[N];
            for (int j = 0; j < N; ++j) {
                values[j] = (long)calls.valueAt(j) << 32 | (long)calls.keyAt(j);
            }
            Arrays.sort(values);
            pw.println("Top openSession callers (uid=count):");
            pw.increaseIndent();
            int end = Math.max(0, N - 20);
            for (int j = N - 1; j >= end; --j) {
                int uid = (int)(values[j] & 0xFFFFFFFFFFFFFFFFL);
                int count = (int)(values[j] >> 32);
                pw.print(uid);
                pw.print("=");
                pw.println(count);
            }
            pw.decreaseIndent();
            pw.println();
            pw.println("Dev stats:");
            pw.increaseIndent();
            this.mDevRecorder.dumpLocked(pw, fullHistory);
            pw.decreaseIndent();
            pw.println("Xt stats:");
            pw.increaseIndent();
            this.mXtRecorder.dumpLocked(pw, fullHistory);
            pw.decreaseIndent();
            if (includeUid) {
                pw.println("UID stats:");
                pw.increaseIndent();
                this.mUidRecorder.dumpLocked(pw, fullHistory);
                pw.decreaseIndent();
            }
            if (includeTag) {
                pw.println("UID tag stats:");
                pw.increaseIndent();
                this.mUidTagRecorder.dumpLocked(pw, fullHistory);
                pw.decreaseIndent();
            }
        }
    }

    @GuardedBy(value={"mStatsLock"})
    private void dumpProtoLocked(FileDescriptor fd) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        NetworkStatsService.dumpInterfaces(proto, 2246267895809L, this.mActiveIfaces);
        NetworkStatsService.dumpInterfaces(proto, 0x20B00000002L, this.mActiveUidIfaces);
        this.mDevRecorder.writeToProtoLocked(proto, 1146756268035L);
        this.mXtRecorder.writeToProtoLocked(proto, 1146756268036L);
        this.mUidRecorder.writeToProtoLocked(proto, 1146756268037L);
        this.mUidTagRecorder.writeToProtoLocked(proto, 1146756268038L);
        proto.flush();
    }

    private static void dumpInterfaces(ProtoOutputStream proto, long tag, ArrayMap<String, NetworkIdentitySet> ifaces) {
        for (int i = 0; i < ifaces.size(); ++i) {
            long start = proto.start(tag);
            proto.write(0x10900000001L, ifaces.keyAt(i));
            ifaces.valueAt(i).writeToProto(proto, 1146756268034L);
            proto.end(start);
        }
    }

    private NetworkStats getNetworkStatsUidDetail(String[] ifaces) throws RemoteException {
        NetworkStats uidSnapshot = this.mNetworkManager.getNetworkStatsUidDetail(-1, ifaces);
        NetworkStats tetherSnapshot = this.getNetworkStatsTethering(1);
        tetherSnapshot.filter(-1, ifaces, -1);
        NetworkStatsFactory.apply464xlatAdjustments(uidSnapshot, tetherSnapshot, this.mUseBpfTrafficStats);
        uidSnapshot.combineAllValues(tetherSnapshot);
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        NetworkStats vtStats = telephonyManager.getVtDataUsage(1);
        if (vtStats != null) {
            vtStats.filter(-1, ifaces, -1);
            NetworkStatsFactory.apply464xlatAdjustments(uidSnapshot, vtStats, this.mUseBpfTrafficStats);
            uidSnapshot.combineAllValues(vtStats);
        }
        uidSnapshot.combineAllValues(this.mUidOperations);
        return uidSnapshot;
    }

    private NetworkStats getNetworkStatsXt() throws RemoteException {
        NetworkStats xtSnapshot = this.mNetworkManager.getNetworkStatsSummaryXt();
        TelephonyManager telephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        NetworkStats vtSnapshot = telephonyManager.getVtDataUsage(0);
        if (vtSnapshot != null) {
            xtSnapshot.combineAllValues(vtSnapshot);
        }
        return xtSnapshot;
    }

    private NetworkStats getNetworkStatsTethering(int how) throws RemoteException {
        try {
            return this.mNetworkManager.getNetworkStatsTethering(how);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem reading network stats", e);
            return new NetworkStats(0L, 10);
        }
    }

    private void assertSystemReady() {
        if (!this.mSystemReady) {
            throw new IllegalStateException("System not ready");
        }
    }

    private void assertBandwidthControlEnabled() {
        if (!this.isBandwidthControlEnabled()) {
            throw new IllegalStateException("Bandwidth module disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mNetworkManager.isBandwidthControlEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private static native long nativeGetTotalStat(int var0, boolean var1);

    private static native long nativeGetIfaceStat(String var0, int var1, boolean var2);

    private static native long nativeGetUidStat(int var0, int var1, boolean var2);

    private static class DefaultNetworkStatsSettings
    implements NetworkStatsSettings {
        private final ContentResolver mResolver;

        public DefaultNetworkStatsSettings(Context context) {
            this.mResolver = Preconditions.checkNotNull(context.getContentResolver());
        }

        private long getGlobalLong(String name, long def) {
            return Settings.Global.getLong(this.mResolver, name, def);
        }

        private boolean getGlobalBoolean(String name, boolean def) {
            int defInt = def ? 1 : 0;
            return Settings.Global.getInt(this.mResolver, name, defInt) != 0;
        }

        @Override
        public long getPollInterval() {
            return this.getGlobalLong("netstats_poll_interval", 1800000L);
        }

        @Override
        public long getGlobalAlertBytes(long def) {
            return this.getGlobalLong("netstats_global_alert_bytes", def);
        }

        @Override
        public boolean getSampleEnabled() {
            return this.getGlobalBoolean("netstats_sample_enabled", true);
        }

        @Override
        public boolean getAugmentEnabled() {
            return this.getGlobalBoolean("netstats_augment_enabled", true);
        }

        @Override
        public NetworkStatsSettings.Config getDevConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_dev_bucket_duration", 3600000L), this.getGlobalLong("netstats_dev_rotate_age", 1296000000L), this.getGlobalLong("netstats_dev_delete_age", 7776000000L));
        }

        @Override
        public NetworkStatsSettings.Config getXtConfig() {
            return this.getDevConfig();
        }

        @Override
        public NetworkStatsSettings.Config getUidConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_uid_bucket_duration", 0x6DDD00L), this.getGlobalLong("netstats_uid_rotate_age", 1296000000L), this.getGlobalLong("netstats_uid_delete_age", 7776000000L));
        }

        @Override
        public NetworkStatsSettings.Config getUidTagConfig() {
            return new NetworkStatsSettings.Config(this.getGlobalLong("netstats_uid_tag_bucket_duration", 0x6DDD00L), this.getGlobalLong("netstats_uid_tag_rotate_age", 432000000L), this.getGlobalLong("netstats_uid_tag_delete_age", 1296000000L));
        }

        @Override
        public long getDevPersistBytes(long def) {
            return this.getGlobalLong("netstats_dev_persist_bytes", def);
        }

        @Override
        public long getXtPersistBytes(long def) {
            return this.getDevPersistBytes(def);
        }

        @Override
        public long getUidPersistBytes(long def) {
            return this.getGlobalLong("netstats_uid_persist_bytes", def);
        }

        @Override
        public long getUidTagPersistBytes(long def) {
            return this.getGlobalLong("netstats_uid_tag_persist_bytes", def);
        }
    }

    private class DropBoxNonMonotonicObserver
    implements NetworkStats.NonMonotonicObserver<String> {
        private DropBoxNonMonotonicObserver() {
        }

        @Override
        public void foundNonMonotonic(NetworkStats left, int leftIndex, NetworkStats right, int rightIndex, String cookie) {
            Log.w(NetworkStatsService.TAG, "Found non-monotonic values; saving to dropbox");
            StringBuilder builder = new StringBuilder();
            builder.append("found non-monotonic " + cookie + " values at left[" + leftIndex + "] - right[" + rightIndex + "]\n");
            builder.append("left=").append(left).append('\n');
            builder.append("right=").append(right).append('\n');
            NetworkStatsService.this.mContext.getSystemService(DropBoxManager.class).addText(NetworkStatsService.TAG_NETSTATS_ERROR, builder.toString());
        }

        @Override
        public void foundNonMonotonic(NetworkStats stats, int statsIndex, String cookie) {
            Log.w(NetworkStatsService.TAG, "Found non-monotonic values; saving to dropbox");
            StringBuilder builder = new StringBuilder();
            builder.append("Found non-monotonic " + cookie + " values at [" + statsIndex + "]\n");
            builder.append("stats=").append(stats).append('\n');
            NetworkStatsService.this.mContext.getSystemService(DropBoxManager.class).addText(NetworkStatsService.TAG_NETSTATS_ERROR, builder.toString());
        }
    }

    @VisibleForTesting
    static class HandlerCallback
    implements Handler.Callback {
        private final NetworkStatsService mService;

        HandlerCallback(NetworkStatsService service) {
            this.mService = service;
        }

        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.mService.performPoll(3);
                    return true;
                }
                case 2: {
                    this.mService.performPoll(1);
                    this.mService.registerGlobalAlert();
                    return true;
                }
            }
            return false;
        }
    }

    private class NetworkStatsManagerInternalImpl
    extends NetworkStatsManagerInternal {
        private NetworkStatsManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getNetworkTotalBytes(NetworkTemplate template, long start, long end) {
            Trace.traceBegin(0x200000L, "getNetworkTotalBytes");
            try {
                long l = NetworkStatsService.this.getNetworkTotalBytes(template, start, end);
                return l;
            }
            finally {
                Trace.traceEnd(0x200000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetworkStats getNetworkUidBytes(NetworkTemplate template, long start, long end) {
            Trace.traceBegin(0x200000L, "getNetworkUidBytes");
            try {
                NetworkStats networkStats = NetworkStatsService.this.getNetworkUidBytes(template, start, end);
                return networkStats;
            }
            finally {
                Trace.traceEnd(0x200000L);
            }
        }

        @Override
        public void setUidForeground(int uid, boolean uidForeground) {
            NetworkStatsService.this.setUidForeground(uid, uidForeground);
        }

        @Override
        public void advisePersistThreshold(long thresholdBytes) {
            NetworkStatsService.this.advisePersistThreshold(thresholdBytes);
        }

        @Override
        public void forceUpdate() {
            NetworkStatsService.this.forceUpdate();
        }
    }

    private static final class NetworkStatsHandler
    extends Handler {
        NetworkStatsHandler(Looper looper, Handler.Callback callback) {
            super(looper, callback);
        }
    }

    public static interface NetworkStatsSettings {
        public long getPollInterval();

        public boolean getSampleEnabled();

        public boolean getAugmentEnabled();

        public Config getDevConfig();

        public Config getXtConfig();

        public Config getUidConfig();

        public Config getUidTagConfig();

        public long getGlobalAlertBytes(long var1);

        public long getDevPersistBytes(long var1);

        public long getXtPersistBytes(long var1);

        public long getUidPersistBytes(long var1);

        public long getUidTagPersistBytes(long var1);

        public static class Config {
            public final long bucketDuration;
            public final long rotateAgeMillis;
            public final long deleteAgeMillis;

            public Config(long bucketDuration, long rotateAgeMillis, long deleteAgeMillis) {
                this.bucketDuration = bucketDuration;
                this.rotateAgeMillis = rotateAgeMillis;
                this.deleteAgeMillis = deleteAgeMillis;
            }
        }
    }
}

