/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net.watchlist;

import android.os.Environment;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.HexDump;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class WatchlistSettings {
    private static final String TAG = "WatchlistSettings";
    private static final String FILE_NAME = "watchlist_settings.xml";
    private static final int SECRET_KEY_LENGTH = 48;
    private static final WatchlistSettings sInstance = new WatchlistSettings();
    private final AtomicFile mXmlFile;
    private byte[] mPrivacySecretKey = null;

    public static WatchlistSettings getInstance() {
        return sInstance;
    }

    private WatchlistSettings() {
        this(WatchlistSettings.getSystemWatchlistFile());
    }

    static File getSystemWatchlistFile() {
        return new File(Environment.getDataSystemDirectory(), FILE_NAME);
    }

    @VisibleForTesting
    protected WatchlistSettings(File xmlFile) {
        this.mXmlFile = new AtomicFile(xmlFile, "net-watchlist");
        this.reloadSettings();
        if (this.mPrivacySecretKey == null) {
            this.mPrivacySecretKey = this.generatePrivacySecretKey();
            this.saveSettings();
        }
    }

    private void reloadSettings() {
        if (!this.mXmlFile.exists()) {
            return;
        }
        try (FileInputStream stream = this.mXmlFile.openRead();){
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            XmlUtils.beginDocument(parser, "network-watchlist-settings");
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if (!parser.getName().equals("secret-key")) continue;
                this.mPrivacySecretKey = this.parseSecretKey(parser);
            }
            Slog.i(TAG, "Reload watchlist settings done");
        }
        catch (IOException | IllegalStateException | IndexOutOfBoundsException | NullPointerException | NumberFormatException | XmlPullParserException e) {
            Slog.e(TAG, "Failed parsing xml", e);
        }
    }

    private byte[] parseSecretKey(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "secret-key");
        byte[] key = HexDump.hexStringToByteArray(parser.nextText());
        parser.require(3, null, "secret-key");
        if (key == null || key.length != 48) {
            Log.e(TAG, "Unable to parse secret key");
            return null;
        }
        return key;
    }

    synchronized byte[] getPrivacySecretKey() {
        byte[] key = new byte[48];
        System.arraycopy(this.mPrivacySecretKey, 0, key, 0, 48);
        return key;
    }

    private byte[] generatePrivacySecretKey() {
        byte[] key = new byte[48];
        new SecureRandom().nextBytes(key);
        return key;
    }

    private void saveSettings() {
        FileOutputStream stream;
        try {
            stream = this.mXmlFile.startWrite();
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to write display settings: " + e);
            return;
        }
        try {
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "network-watchlist-settings");
            out.startTag(null, "secret-key");
            out.text(HexDump.toHexString(this.mPrivacySecretKey));
            out.endTag(null, "secret-key");
            out.endTag(null, "network-watchlist-settings");
            out.endDocument();
            this.mXmlFile.finishWrite(stream);
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to write display settings, restoring backup.", e);
            this.mXmlFile.failWrite(stream);
        }
    }
}

