/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;

public class BadgeExtractor
implements NotificationSignalExtractor {
    private static final String TAG = "BadgeExtractor";
    private static final boolean DBG = false;
    private RankingConfig mConfig;

    @Override
    public void initialize(Context ctx, NotificationUsageStats usageStats) {
    }

    @Override
    public RankingReconsideration process(NotificationRecord record) {
        if (record == null || record.getNotification() == null) {
            return null;
        }
        if (this.mConfig == null) {
            return null;
        }
        boolean userWantsBadges = this.mConfig.badgingEnabled(record.sbn.getUser());
        boolean appCanShowBadge = this.mConfig.canShowBadge(record.sbn.getPackageName(), record.sbn.getUid());
        if (!userWantsBadges || !appCanShowBadge) {
            record.setShowBadge(false);
        } else if (record.getChannel() != null) {
            record.setShowBadge(record.getChannel().canShowBadge() && appCanShowBadge);
        } else {
            record.setShowBadge(appCanShowBadge);
        }
        if (record.isIntercepted() && (record.getSuppressedVisualEffects() & 0x40) != 0) {
            record.setShowBadge(false);
        }
        return null;
    }

    @Override
    public void setConfig(RankingConfig config) {
        this.mConfig = config;
    }

    @Override
    public void setZenHelper(ZenModeHelper helper) {
    }
}

