/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.CalendarContract;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Objects;

public class CalendarTracker {
    private static final String TAG = "ConditionProviders.CT";
    private static final boolean DEBUG = Log.isLoggable("ConditionProviders", 3);
    private static final boolean DEBUG_ATTENDEES = false;
    private static final int EVENT_CHECK_LOOKAHEAD = 86400000;
    private static final String[] INSTANCE_PROJECTION = new String[]{"begin", "end", "title", "visible", "event_id", "calendar_displayName", "ownerAccount", "calendar_id", "availability"};
    private static final String INSTANCE_ORDER_BY = "begin ASC";
    private static final String[] ATTENDEE_PROJECTION = new String[]{"event_id", "attendeeEmail", "attendeeStatus"};
    private static final String ATTENDEE_SELECTION = "event_id = ? AND attendeeEmail = ?";
    private final Context mSystemContext;
    private final Context mUserContext;
    private Callback mCallback;
    private boolean mRegistered;
    private final ContentObserver mObserver = new ContentObserver(null){

        @Override
        public void onChange(boolean selfChange, Uri u) {
            if (DEBUG) {
                Log.d(CalendarTracker.TAG, "onChange selfChange=" + selfChange + " uri=" + u + " u=" + CalendarTracker.this.mUserContext.getUserId());
            }
            CalendarTracker.this.mCallback.onChanged();
        }

        @Override
        public void onChange(boolean selfChange) {
            if (DEBUG) {
                Log.d(CalendarTracker.TAG, "onChange selfChange=" + selfChange);
            }
        }
    };

    public CalendarTracker(Context systemContext, Context userContext) {
        this.mSystemContext = systemContext;
        this.mUserContext = userContext;
    }

    public void setCallback(Callback callback) {
        if (this.mCallback == callback) {
            return;
        }
        this.mCallback = callback;
        this.setRegistered(this.mCallback != null);
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mCallback=");
        pw.println(this.mCallback);
        pw.print(prefix);
        pw.print("mRegistered=");
        pw.println(this.mRegistered);
        pw.print(prefix);
        pw.print("u=");
        pw.println(this.mUserContext.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArraySet<Long> getCalendarsWithAccess() {
        long start = System.currentTimeMillis();
        ArraySet<Long> rt = new ArraySet<Long>();
        String[] projection = new String[]{"_id"};
        String selection = "calendar_access_level >= 500 AND sync_events = 1";
        try (Cursor cursor = null;){
            cursor = this.mUserContext.getContentResolver().query(CalendarContract.Calendars.CONTENT_URI, projection, "calendar_access_level >= 500 AND sync_events = 1", null, null);
            while (cursor != null && cursor.moveToNext()) {
                rt.add(cursor.getLong(0));
            }
        }
        if (DEBUG) {
            Log.d(TAG, "getCalendarsWithAccess took " + (System.currentTimeMillis() - start));
        }
        return rt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CheckEventResult checkEvent(ZenModeConfig.EventInfo filter, long time) {
        Uri.Builder uriBuilder = CalendarContract.Instances.CONTENT_URI.buildUpon();
        ContentUris.appendId(uriBuilder, time);
        ContentUris.appendId(uriBuilder, time + 86400000L);
        Uri uri = uriBuilder.build();
        Cursor cursor = this.mUserContext.getContentResolver().query(uri, INSTANCE_PROJECTION, null, null, INSTANCE_ORDER_BY);
        CheckEventResult result = new CheckEventResult();
        result.recheckAt = time + 86400000L;
        try {
            ArraySet<Long> calendars = this.getCalendarsWithAccess();
            while (cursor != null && cursor.moveToNext()) {
                boolean meetsAttendee;
                boolean meetsAvailability;
                long begin = cursor.getLong(0);
                long end = cursor.getLong(1);
                String title = cursor.getString(2);
                boolean calendarVisible = cursor.getInt(3) == 1;
                int eventId = cursor.getInt(4);
                String name = cursor.getString(5);
                String owner = cursor.getString(6);
                long calendarId = cursor.getLong(7);
                int availability = cursor.getInt(8);
                boolean canAccessCal = calendars.contains(calendarId);
                if (DEBUG) {
                    Log.d(TAG, String.format("title=%s time=%s-%s vis=%s availability=%s eventId=%s name=%s owner=%s calId=%s canAccessCal=%s", title, new Date(begin), new Date(end), calendarVisible, CalendarTracker.availabilityToString(availability), eventId, name, owner, calendarId, canAccessCal));
                }
                boolean meetsTime = time >= begin && time < end;
                boolean meetsCalendar = calendarVisible && canAccessCal && (filter.calName == null && filter.calendarId == null || Objects.equals(filter.calendarId, calendarId) || Objects.equals(filter.calName, name));
                boolean bl = meetsAvailability = availability != 1;
                if (!meetsCalendar || !meetsAvailability) continue;
                if (DEBUG) {
                    Log.d(TAG, "  MEETS CALENDAR & AVAILABILITY");
                }
                if (!(meetsAttendee = this.meetsAttendee(filter, eventId, owner))) continue;
                if (DEBUG) {
                    Log.d(TAG, "    MEETS ATTENDEE");
                }
                if (meetsTime) {
                    if (DEBUG) {
                        Log.d(TAG, "      MEETS TIME");
                    }
                    result.inEvent = true;
                }
                if (begin > time && begin < result.recheckAt) {
                    result.recheckAt = begin;
                    continue;
                }
                if (end <= time || end >= result.recheckAt) continue;
                result.recheckAt = end;
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "error reading calendar", e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean meetsAttendee(ZenModeConfig.EventInfo filter, int eventId, String email) {
        long start = System.currentTimeMillis();
        String selection = ATTENDEE_SELECTION;
        String[] selectionArgs = new String[]{Integer.toString(eventId), email};
        Cursor cursor = this.mUserContext.getContentResolver().query(CalendarContract.Attendees.CONTENT_URI, ATTENDEE_PROJECTION, selection, selectionArgs, null);
        try {
            if (cursor == null || cursor.getCount() == 0) {
                if (DEBUG) {
                    Log.d(TAG, "No attendees found");
                }
                boolean bl = true;
                return bl;
            }
            boolean rt = false;
            while (cursor != null && cursor.moveToNext()) {
                long rowEventId = cursor.getLong(0);
                String rowEmail = cursor.getString(1);
                int status = cursor.getInt(2);
                boolean meetsReply = CalendarTracker.meetsReply(filter.reply, status);
                if (DEBUG) {
                    Log.d(TAG, "" + String.format("status=%s, meetsReply=%s", CalendarTracker.attendeeStatusToString(status), meetsReply));
                }
                boolean eventMeets = rowEventId == (long)eventId && Objects.equals(rowEmail, email) && meetsReply;
                rt |= eventMeets;
            }
            boolean bl = rt;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (DEBUG) {
                Log.d(TAG, "meetsAttendee took " + (System.currentTimeMillis() - start));
            }
        }
    }

    private void setRegistered(boolean registered) {
        if (this.mRegistered == registered) {
            return;
        }
        ContentResolver cr = this.mSystemContext.getContentResolver();
        int userId = this.mUserContext.getUserId();
        if (this.mRegistered) {
            if (DEBUG) {
                Log.d(TAG, "unregister content observer u=" + userId);
            }
            cr.unregisterContentObserver(this.mObserver);
        }
        this.mRegistered = registered;
        if (DEBUG) {
            Log.d(TAG, "mRegistered = " + registered + " u=" + userId);
        }
        if (this.mRegistered) {
            if (DEBUG) {
                Log.d(TAG, "register content observer u=" + userId);
            }
            cr.registerContentObserver(CalendarContract.Instances.CONTENT_URI, true, this.mObserver, userId);
            cr.registerContentObserver(CalendarContract.Events.CONTENT_URI, true, this.mObserver, userId);
            cr.registerContentObserver(CalendarContract.Calendars.CONTENT_URI, true, this.mObserver, userId);
        }
    }

    private static String attendeeStatusToString(int status) {
        switch (status) {
            case 0: {
                return "ATTENDEE_STATUS_NONE";
            }
            case 1: {
                return "ATTENDEE_STATUS_ACCEPTED";
            }
            case 2: {
                return "ATTENDEE_STATUS_DECLINED";
            }
            case 3: {
                return "ATTENDEE_STATUS_INVITED";
            }
            case 4: {
                return "ATTENDEE_STATUS_TENTATIVE";
            }
        }
        return "ATTENDEE_STATUS_UNKNOWN_" + status;
    }

    private static String availabilityToString(int availability) {
        switch (availability) {
            case 0: {
                return "AVAILABILITY_BUSY";
            }
            case 1: {
                return "AVAILABILITY_FREE";
            }
            case 2: {
                return "AVAILABILITY_TENTATIVE";
            }
        }
        return "AVAILABILITY_UNKNOWN_" + availability;
    }

    private static boolean meetsReply(int reply, int attendeeStatus) {
        switch (reply) {
            case 2: {
                return attendeeStatus == 1;
            }
            case 1: {
                return attendeeStatus == 1 || attendeeStatus == 4;
            }
            case 0: {
                return attendeeStatus != 2;
            }
        }
        return false;
    }

    public static interface Callback {
        public void onChanged();
    }

    public static class CheckEventResult {
        public boolean inEvent;
        public long recheckAt;
    }
}

