/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.INotificationManager;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.IPackageManager;
import android.net.Uri;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteException;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.notification.CountdownConditionProvider;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.PropConfig;
import com.android.server.notification.SystemConditionProviderService;
import com.android.server.notification.ZenLog;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public class ConditionProviders
extends ManagedServices {
    @VisibleForTesting
    static final String TAG_ENABLED_DND_APPS = "dnd_apps";
    private final ArrayList<ConditionRecord> mRecords = new ArrayList();
    private final ArraySet<String> mSystemConditionProviderNames;
    private final ArraySet<SystemConditionProviderService> mSystemConditionProviders = new ArraySet();
    private Callback mCallback;

    public ConditionProviders(Context context, ManagedServices.UserProfiles userProfiles, IPackageManager pm) {
        super(context, new Object(), userProfiles, pm);
        this.mSystemConditionProviderNames = ConditionProviders.safeSet(PropConfig.getStringArray(this.mContext, "system.condition.providers", 17236063));
        this.mApprovalLevel = 0;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public boolean isSystemProviderEnabled(String path) {
        return this.mSystemConditionProviderNames.contains(path);
    }

    public void addSystemProvider(SystemConditionProviderService service) {
        this.mSystemConditionProviders.add(service);
        service.attachBase(this.mContext);
        this.registerService(service.asInterface(), service.getComponent(), 0);
    }

    public Iterable<SystemConditionProviderService> getSystemProviders() {
        return this.mSystemConditionProviders;
    }

    @Override
    protected ManagedServices.Config getConfig() {
        ManagedServices.Config c = new ManagedServices.Config();
        c.caption = "condition provider";
        c.serviceInterface = "android.service.notification.ConditionProviderService";
        c.secureSettingName = "enabled_notification_policy_access_packages";
        c.xmlTag = TAG_ENABLED_DND_APPS;
        c.secondarySettingName = "enabled_notification_listeners";
        c.bindPermission = "android.permission.BIND_CONDITION_PROVIDER_SERVICE";
        c.settingsAction = "android.settings.ACTION_CONDITION_PROVIDER_SETTINGS";
        c.clientLabel = 17039667;
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        super.dump(pw, filter);
        Object object = this.mMutex;
        synchronized (object) {
            pw.print("    mRecords(");
            pw.print(this.mRecords.size());
            pw.println("):");
            for (int i = 0; i < this.mRecords.size(); ++i) {
                ConditionRecord r = this.mRecords.get(i);
                if (filter != null && !filter.matches(r.component)) continue;
                pw.print("      ");
                pw.println(r);
                String countdownDesc = CountdownConditionProvider.tryParseDescription(r.id);
                if (countdownDesc == null) continue;
                pw.print("        (");
                pw.print(countdownDesc);
                pw.println(")");
            }
        }
        pw.print("    mSystemConditionProviders: ");
        pw.println(this.mSystemConditionProviderNames);
        for (int i = 0; i < this.mSystemConditionProviders.size(); ++i) {
            this.mSystemConditionProviders.valueAt(i).dump(pw, filter);
        }
    }

    @Override
    protected IInterface asInterface(IBinder binder) {
        return IConditionProvider.Stub.asInterface(binder);
    }

    @Override
    protected boolean checkType(IInterface service) {
        return service instanceof IConditionProvider;
    }

    @Override
    public void onBootPhaseAppsCanStart() {
        super.onBootPhaseAppsCanStart();
        for (int i = 0; i < this.mSystemConditionProviders.size(); ++i) {
            this.mSystemConditionProviders.valueAt(i).onBootComplete();
        }
        if (this.mCallback != null) {
            this.mCallback.onBootComplete();
        }
    }

    @Override
    public void onUserSwitched(int user) {
        super.onUserSwitched(user);
        if (this.mCallback != null) {
            this.mCallback.onUserSwitched();
        }
    }

    @Override
    protected void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
        IConditionProvider provider = ConditionProviders.provider(info);
        try {
            provider.onConnected();
        }
        catch (RemoteException e) {
            Slog.e(this.TAG, "can't connect to service " + info, e);
        }
        if (this.mCallback != null) {
            this.mCallback.onServiceAdded(info.component);
        }
    }

    @Override
    protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
        if (removed == null) {
            return;
        }
        for (int i = this.mRecords.size() - 1; i >= 0; --i) {
            ConditionRecord r = this.mRecords.get(i);
            if (!r.component.equals(removed.component)) continue;
            this.mRecords.remove(i);
        }
    }

    @Override
    public void onPackagesChanged(boolean removingPackage, String[] pkgList, int[] uid) {
        if (removingPackage) {
            INotificationManager inm = NotificationManager.getService();
            if (pkgList != null && pkgList.length > 0) {
                for (String pkgName : pkgList) {
                    try {
                        inm.removeAutomaticZenRules(pkgName);
                        inm.setNotificationPolicyAccessGranted(pkgName, false);
                    }
                    catch (Exception e) {
                        Slog.e(this.TAG, "Failed to clean up rules for " + pkgName, e);
                    }
                }
            }
        }
        super.onPackagesChanged(removingPackage, pkgList, uid);
    }

    @Override
    protected boolean isValidEntry(String packageOrComponent, int userId) {
        return true;
    }

    @Override
    protected String getRequiredPermission() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagedServices.ManagedServiceInfo checkServiceToken(IConditionProvider provider) {
        Object object = this.mMutex;
        synchronized (object) {
            return this.checkServiceTokenLocked(provider);
        }
    }

    private Condition[] removeDuplicateConditions(String pkg, Condition[] conditions) {
        if (conditions == null || conditions.length == 0) {
            return null;
        }
        int N = conditions.length;
        ArrayMap<Uri, Condition> valid = new ArrayMap<Uri, Condition>(N);
        for (int i = 0; i < N; ++i) {
            Uri id2 = conditions[i].id;
            if (valid.containsKey(id2)) {
                Slog.w(this.TAG, "Ignoring condition from " + pkg + " for duplicate id: " + id2);
                continue;
            }
            valid.put(id2, conditions[i]);
        }
        if (valid.size() == 0) {
            return null;
        }
        if (valid.size() == N) {
            return conditions;
        }
        Condition[] rt = new Condition[valid.size()];
        for (int i = 0; i < rt.length; ++i) {
            rt[i] = (Condition)valid.valueAt(i);
        }
        return rt;
    }

    private ConditionRecord getRecordLocked(Uri id2, ComponentName component, boolean create) {
        if (id2 == null || component == null) {
            return null;
        }
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            ConditionRecord r = this.mRecords.get(i);
            if (!r.id.equals(id2) || !r.component.equals(component)) continue;
            return r;
        }
        if (create) {
            ConditionRecord r = new ConditionRecord(id2, component);
            this.mRecords.add(r);
            return r;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyConditions(String pkg, ManagedServices.ManagedServiceInfo info, Condition[] conditions) {
        Object object = this.mMutex;
        synchronized (object) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "notifyConditions pkg=" + pkg + " info=" + info + " conditions=" + (conditions == null ? null : Arrays.asList(conditions)));
            }
            if ((conditions = this.removeDuplicateConditions(pkg, conditions)) == null || conditions.length == 0) {
                return;
            }
            int N = conditions.length;
            for (int i = 0; i < N; ++i) {
                Condition c = conditions[i];
                ConditionRecord r = this.getRecordLocked(c.id, info.component, true);
                r.info = info;
                r.condition = c;
            }
        }
        for (Condition c : conditions) {
            if (this.mCallback == null) continue;
            this.mCallback.onConditionChanged(c.id, c);
        }
    }

    public IConditionProvider findConditionProvider(ComponentName component) {
        if (component == null) {
            return null;
        }
        for (ManagedServices.ManagedServiceInfo service : this.getServices()) {
            if (!component.equals(service.component)) continue;
            return ConditionProviders.provider(service);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Condition findCondition(ComponentName component, Uri conditionId) {
        if (component == null || conditionId == null) {
            return null;
        }
        Object object = this.mMutex;
        synchronized (object) {
            ConditionRecord r = this.getRecordLocked(conditionId, component, false);
            return r != null ? r.condition : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureRecordExists(ComponentName component, Uri conditionId, IConditionProvider provider) {
        Object object = this.mMutex;
        synchronized (object) {
            ConditionRecord r = this.getRecordLocked(conditionId, component, true);
            if (r.info == null) {
                r.info = this.checkServiceTokenLocked(provider);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean subscribeIfNecessary(ComponentName component, Uri conditionId) {
        Object object = this.mMutex;
        synchronized (object) {
            ConditionRecord r = this.getRecordLocked(conditionId, component, false);
            if (r == null) {
                Slog.w(this.TAG, "Unable to subscribe to " + component + " " + conditionId);
                return false;
            }
            if (r.subscribed) {
                return true;
            }
            this.subscribeLocked(r);
            return r.subscribed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeIfNecessary(ComponentName component, Uri conditionId) {
        Object object = this.mMutex;
        synchronized (object) {
            ConditionRecord r = this.getRecordLocked(conditionId, component, false);
            if (r == null) {
                Slog.w(this.TAG, "Unable to unsubscribe to " + component + " " + conditionId);
                return;
            }
            if (!r.subscribed) {
                return;
            }
            this.unsubscribeLocked(r);
        }
    }

    private void subscribeLocked(ConditionRecord r) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "subscribeLocked " + r);
        }
        IConditionProvider provider = ConditionProviders.provider(r);
        RemoteException re = null;
        if (provider != null) {
            try {
                Slog.d(this.TAG, "Subscribing to " + r.id + " with " + r.component);
                provider.onSubscribe(r.id);
                r.subscribed = true;
            }
            catch (RemoteException e) {
                Slog.w(this.TAG, "Error subscribing to " + r, e);
                re = e;
            }
        }
        ZenLog.traceSubscribe(r != null ? r.id : null, provider, re);
    }

    @SafeVarargs
    private static <T> ArraySet<T> safeSet(T ... items) {
        ArraySet<T> rt = new ArraySet<T>();
        if (items == null || items.length == 0) {
            return rt;
        }
        for (T item : items) {
            if (item == null) continue;
            rt.add(item);
        }
        return rt;
    }

    private void unsubscribeLocked(ConditionRecord r) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "unsubscribeLocked " + r);
        }
        IConditionProvider provider = ConditionProviders.provider(r);
        RemoteException re = null;
        if (provider != null) {
            try {
                provider.onUnsubscribe(r.id);
            }
            catch (RemoteException e) {
                Slog.w(this.TAG, "Error unsubscribing to " + r, e);
                re = e;
            }
            r.subscribed = false;
        }
        ZenLog.traceUnsubscribe(r != null ? r.id : null, provider, re);
    }

    private static IConditionProvider provider(ConditionRecord r) {
        return r == null ? null : ConditionProviders.provider(r.info);
    }

    private static IConditionProvider provider(ManagedServices.ManagedServiceInfo info) {
        return info == null ? null : (IConditionProvider)info.service;
    }

    public static interface Callback {
        public void onBootComplete();

        public void onServiceAdded(ComponentName var1);

        public void onConditionChanged(Uri var1, Condition var2);

        public void onUserSwitched();
    }

    private static class ConditionRecord {
        public final Uri id;
        public final ComponentName component;
        public Condition condition;
        public ManagedServices.ManagedServiceInfo info;
        public boolean subscribed;

        private ConditionRecord(Uri id2, ComponentName component) {
            this.id = id2;
            this.component = component;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("ConditionRecord[id=").append(this.id).append(",component=").append(this.component).append(",subscribed=").append(this.subscribed);
            return sb.append(']').toString();
        }
    }
}

