/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;

public class CriticalNotificationExtractor
implements NotificationSignalExtractor {
    private static final String TAG = "CriticalNotificationExt";
    private static final boolean DBG = false;
    private boolean mSupportsCriticalNotifications = false;
    static final int CRITICAL = 0;
    static final int CRITICAL_LOW = 1;
    static final int NORMAL = 2;

    @Override
    public void initialize(Context context, NotificationUsageStats usageStats) {
        this.mSupportsCriticalNotifications = this.supportsCriticalNotifications(context);
    }

    private boolean supportsCriticalNotifications(Context context) {
        return context.getPackageManager().hasSystemFeature("android.hardware.type.automotive", 0);
    }

    @Override
    public RankingReconsideration process(NotificationRecord record) {
        if (!this.mSupportsCriticalNotifications) {
            return null;
        }
        if (record == null || record.getNotification() == null) {
            return null;
        }
        if (record.isCategory("car_emergency")) {
            record.setCriticality(0);
        } else if (record.isCategory("car_warning")) {
            record.setCriticality(1);
        } else {
            record.setCriticality(2);
        }
        return null;
    }

    @Override
    public void setConfig(RankingConfig config) {
    }

    @Override
    public void setZenHelper(ZenModeHelper helper) {
    }
}

