/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.UserHandle;
import android.os.UserManager;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.notification.CalendarTracker;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.SystemConditionProviderService;
import java.io.PrintWriter;
import java.util.ArrayList;

public class EventConditionProvider
extends SystemConditionProviderService {
    private static final String TAG = "ConditionProviders.ECP";
    private static final boolean DEBUG = Log.isLoggable("ConditionProviders", 3);
    public static final ComponentName COMPONENT = new ComponentName("android", EventConditionProvider.class.getName());
    private static final String NOT_SHOWN = "...";
    private static final String SIMPLE_NAME = EventConditionProvider.class.getSimpleName();
    private static final String ACTION_EVALUATE = SIMPLE_NAME + ".EVALUATE";
    private static final int REQUEST_CODE_EVALUATE = 1;
    private static final String EXTRA_TIME = "time";
    private static final long CHANGE_DELAY = 2000L;
    private final Context mContext = this;
    private final ArraySet<Uri> mSubscriptions = new ArraySet();
    private final SparseArray<CalendarTracker> mTrackers = new SparseArray();
    private final Handler mWorker;
    private final HandlerThread mThread;
    private boolean mConnected;
    private boolean mRegistered;
    private boolean mBootComplete;
    private long mNextAlarmTime;
    private final CalendarTracker.Callback mTrackerCallback = new CalendarTracker.Callback(){

        @Override
        public void onChanged() {
            if (DEBUG) {
                Slog.d(EventConditionProvider.TAG, "mTrackerCallback.onChanged");
            }
            EventConditionProvider.this.mWorker.removeCallbacks(EventConditionProvider.this.mEvaluateSubscriptionsW);
            EventConditionProvider.this.mWorker.postDelayed(EventConditionProvider.this.mEvaluateSubscriptionsW, 2000L);
        }
    };
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (DEBUG) {
                Slog.d(EventConditionProvider.TAG, "onReceive " + intent.getAction());
            }
            EventConditionProvider.this.evaluateSubscriptions();
        }
    };
    private final Runnable mEvaluateSubscriptionsW = new Runnable(){

        @Override
        public void run() {
            EventConditionProvider.this.evaluateSubscriptionsW();
        }
    };

    public EventConditionProvider() {
        if (DEBUG) {
            Slog.d(TAG, "new " + SIMPLE_NAME + "()");
        }
        this.mThread = new HandlerThread(TAG, 10);
        this.mThread.start();
        this.mWorker = new Handler(this.mThread.getLooper());
    }

    @Override
    public ComponentName getComponent() {
        return COMPONENT;
    }

    @Override
    public boolean isValidConditionId(Uri id2) {
        return ZenModeConfig.isValidEventConditionId(id2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.print("    ");
        pw.print(SIMPLE_NAME);
        pw.println(":");
        pw.print("      mConnected=");
        pw.println(this.mConnected);
        pw.print("      mRegistered=");
        pw.println(this.mRegistered);
        pw.print("      mBootComplete=");
        pw.println(this.mBootComplete);
        EventConditionProvider.dumpUpcomingTime(pw, "mNextAlarmTime", this.mNextAlarmTime, System.currentTimeMillis());
        ArraySet<Uri> arraySet = this.mSubscriptions;
        synchronized (arraySet) {
            pw.println("      mSubscriptions=");
            for (Uri conditionId : this.mSubscriptions) {
                pw.print("        ");
                pw.println(conditionId);
            }
        }
        pw.println("      mTrackers=");
        for (int i = 0; i < this.mTrackers.size(); ++i) {
            pw.print("        user=");
            pw.println(this.mTrackers.keyAt(i));
            this.mTrackers.valueAt(i).dump("          ", pw);
        }
    }

    @Override
    public void onBootComplete() {
        if (DEBUG) {
            Slog.d(TAG, "onBootComplete");
        }
        if (this.mBootComplete) {
            return;
        }
        this.mBootComplete = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                EventConditionProvider.this.reloadTrackers();
            }
        }, filter);
        this.reloadTrackers();
    }

    @Override
    public void onConnected() {
        if (DEBUG) {
            Slog.d(TAG, "onConnected");
        }
        this.mConnected = true;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (DEBUG) {
            Slog.d(TAG, "onDestroy");
        }
        this.mConnected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onSubscribe " + conditionId);
        }
        if (!ZenModeConfig.isValidEventConditionId(conditionId)) {
            this.notifyCondition(this.createCondition(conditionId, 0));
            return;
        }
        ArraySet<Uri> arraySet = this.mSubscriptions;
        synchronized (arraySet) {
            if (this.mSubscriptions.add(conditionId)) {
                this.evaluateSubscriptions();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnsubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onUnsubscribe " + conditionId);
        }
        ArraySet<Uri> arraySet = this.mSubscriptions;
        synchronized (arraySet) {
            if (this.mSubscriptions.remove(conditionId)) {
                this.evaluateSubscriptions();
            }
        }
    }

    @Override
    public void attachBase(Context base) {
        this.attachBaseContext(base);
    }

    @Override
    public IConditionProvider asInterface() {
        return (IConditionProvider)((Object)this.onBind(null));
    }

    private void reloadTrackers() {
        if (DEBUG) {
            Slog.d(TAG, "reloadTrackers");
        }
        for (int i = 0; i < this.mTrackers.size(); ++i) {
            this.mTrackers.valueAt(i).setCallback(null);
        }
        this.mTrackers.clear();
        for (UserHandle user : UserManager.get(this.mContext).getUserProfiles()) {
            Context context;
            Context context2 = context = user.isSystem() ? this.mContext : EventConditionProvider.getContextForUser(this.mContext, user);
            if (context == null) {
                Slog.w(TAG, "Unable to create context for user " + user.getIdentifier());
                continue;
            }
            this.mTrackers.put(user.getIdentifier(), new CalendarTracker(this.mContext, context));
        }
        this.evaluateSubscriptions();
    }

    private void evaluateSubscriptions() {
        if (!this.mWorker.hasCallbacks(this.mEvaluateSubscriptionsW)) {
            this.mWorker.post(this.mEvaluateSubscriptionsW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateSubscriptionsW() {
        if (DEBUG) {
            Slog.d(TAG, "evaluateSubscriptions");
        }
        if (!this.mBootComplete) {
            if (DEBUG) {
                Slog.d(TAG, "Skipping evaluate before boot complete");
            }
            return;
        }
        long now = System.currentTimeMillis();
        ArrayList<Condition> conditionsToNotify = new ArrayList<Condition>();
        ArraySet<Uri> arraySet = this.mSubscriptions;
        synchronized (arraySet) {
            for (int i = 0; i < this.mTrackers.size(); ++i) {
                this.mTrackers.valueAt(i).setCallback(this.mSubscriptions.isEmpty() ? null : this.mTrackerCallback);
            }
            this.setRegistered(!this.mSubscriptions.isEmpty());
            long reevaluateAt = 0L;
            for (Uri conditionId : this.mSubscriptions) {
                CalendarTracker tracker;
                ZenModeConfig.EventInfo event = ZenModeConfig.tryParseEventConditionId(conditionId);
                if (event == null) {
                    conditionsToNotify.add(this.createCondition(conditionId, 0));
                    continue;
                }
                CalendarTracker.CheckEventResult result = null;
                if (event.calName == null) {
                    for (int i = 0; i < this.mTrackers.size(); ++i) {
                        tracker = this.mTrackers.valueAt(i);
                        CalendarTracker.CheckEventResult r = tracker.checkEvent(event, now);
                        if (result == null) {
                            result = r;
                            continue;
                        }
                        result.inEvent |= r.inEvent;
                        result.recheckAt = Math.min(result.recheckAt, r.recheckAt);
                    }
                } else {
                    int userId = ZenModeConfig.EventInfo.resolveUserId(event.userId);
                    tracker = this.mTrackers.get(userId);
                    if (tracker == null) {
                        Slog.w(TAG, "No calendar tracker found for user " + userId);
                        conditionsToNotify.add(this.createCondition(conditionId, 0));
                        continue;
                    }
                    result = tracker.checkEvent(event, now);
                }
                if (result.recheckAt != 0L && (reevaluateAt == 0L || result.recheckAt < reevaluateAt)) {
                    reevaluateAt = result.recheckAt;
                }
                if (!result.inEvent) {
                    conditionsToNotify.add(this.createCondition(conditionId, 0));
                    continue;
                }
                conditionsToNotify.add(this.createCondition(conditionId, 1));
            }
            this.rescheduleAlarm(now, reevaluateAt);
        }
        for (Condition condition : conditionsToNotify) {
            if (condition == null) continue;
            this.notifyCondition(condition);
        }
        if (DEBUG) {
            Slog.d(TAG, "evaluateSubscriptions took " + (System.currentTimeMillis() - now));
        }
    }

    private void rescheduleAlarm(long now, long time) {
        this.mNextAlarmTime = time;
        AlarmManager alarms = (AlarmManager)this.mContext.getSystemService("alarm");
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 1, new Intent(ACTION_EVALUATE).addFlags(0x10000000).putExtra(EXTRA_TIME, time), 0x8000000);
        alarms.cancel(pendingIntent);
        if (time == 0L || time < now) {
            if (DEBUG) {
                Slog.d(TAG, "Not scheduling evaluate: " + (time == 0L ? "no time specified" : "specified time in the past"));
            }
            return;
        }
        if (DEBUG) {
            Slog.d(TAG, String.format("Scheduling evaluate for %s, in %s, now=%s", EventConditionProvider.ts(time), EventConditionProvider.formatDuration(time - now), EventConditionProvider.ts(now)));
        }
        alarms.setExact(0, time, pendingIntent);
    }

    private Condition createCondition(Uri id2, int state) {
        String summary = NOT_SHOWN;
        String line1 = NOT_SHOWN;
        String line2 = NOT_SHOWN;
        return new Condition(id2, NOT_SHOWN, NOT_SHOWN, NOT_SHOWN, 0, state, 2);
    }

    private void setRegistered(boolean registered) {
        if (this.mRegistered == registered) {
            return;
        }
        if (DEBUG) {
            Slog.d(TAG, "setRegistered " + registered);
        }
        this.mRegistered = registered;
        if (this.mRegistered) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            filter.addAction(ACTION_EVALUATE);
            this.registerReceiver(this.mReceiver, filter);
        } else {
            this.unregisterReceiver(this.mReceiver);
        }
    }

    private static Context getContextForUser(Context context, UserHandle user) {
        try {
            return context.createPackageContextAsUser(context.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

