/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.service.notification.StatusBarNotification;
import android.util.Log;
import android.util.Slog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class GroupHelper {
    private static final String TAG = "GroupHelper";
    private static final boolean DEBUG = Log.isLoggable("GroupHelper", 3);
    protected static final String AUTOGROUP_KEY = "ranker_group";
    private final Callback mCallback;
    private final int mAutoGroupAtCount;
    Map<Integer, Map<String, LinkedHashSet<String>>> mUngroupedNotifications = new HashMap<Integer, Map<String, LinkedHashSet<String>>>();

    public GroupHelper(int autoGroupAtCount, Callback callback) {
        this.mAutoGroupAtCount = autoGroupAtCount;
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotificationPosted(StatusBarNotification sbn, boolean autogroupSummaryExists) {
        block11: {
            if (DEBUG) {
                Log.i(TAG, "POSTED " + sbn.getKey());
            }
            try {
                ArrayList<String> notificationsToGroup = new ArrayList<String>();
                if (!sbn.isAppGroup()) {
                    Map<Integer, Map<String, LinkedHashSet<String>>> map = this.mUngroupedNotifications;
                    synchronized (map) {
                        Map<String, LinkedHashSet<String>> ungroupedNotificationsByUser = this.mUngroupedNotifications.get(sbn.getUserId());
                        if (ungroupedNotificationsByUser == null) {
                            ungroupedNotificationsByUser = new HashMap<String, LinkedHashSet<String>>();
                        }
                        this.mUngroupedNotifications.put(sbn.getUserId(), ungroupedNotificationsByUser);
                        LinkedHashSet<String> notificationsForPackage = ungroupedNotificationsByUser.get(sbn.getPackageName());
                        if (notificationsForPackage == null) {
                            notificationsForPackage = new LinkedHashSet();
                        }
                        notificationsForPackage.add(sbn.getKey());
                        ungroupedNotificationsByUser.put(sbn.getPackageName(), notificationsForPackage);
                        if (notificationsForPackage.size() >= this.mAutoGroupAtCount || autogroupSummaryExists) {
                            notificationsToGroup.addAll(notificationsForPackage);
                        }
                    }
                    if (notificationsToGroup.size() > 0) {
                        this.adjustAutogroupingSummary(sbn.getUserId(), sbn.getPackageName(), (String)notificationsToGroup.get(0), true);
                        this.adjustNotificationBundling(notificationsToGroup, true);
                    }
                    break block11;
                }
                this.maybeUngroup(sbn, false, sbn.getUserId());
            }
            catch (Exception e) {
                Slog.e(TAG, "Failure processing new notification", e);
            }
        }
    }

    public void onNotificationRemoved(StatusBarNotification sbn) {
        try {
            this.maybeUngroup(sbn, true, sbn.getUserId());
        }
        catch (Exception e) {
            Slog.e(TAG, "Error processing canceled notification", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeUngroup(StatusBarNotification sbn, boolean notificationGone, int userId) {
        ArrayList<String> notificationsToUnAutogroup = new ArrayList<String>();
        boolean removeSummary = false;
        Map<Integer, Map<String, LinkedHashSet<String>>> map = this.mUngroupedNotifications;
        synchronized (map) {
            Map<String, LinkedHashSet<String>> ungroupedNotificationsByUser = this.mUngroupedNotifications.get(sbn.getUserId());
            if (ungroupedNotificationsByUser == null || ungroupedNotificationsByUser.size() == 0) {
                return;
            }
            LinkedHashSet<String> notificationsForPackage = ungroupedNotificationsByUser.get(sbn.getPackageName());
            if (notificationsForPackage == null || notificationsForPackage.size() == 0) {
                return;
            }
            if (notificationsForPackage.remove(sbn.getKey()) && !notificationGone) {
                notificationsToUnAutogroup.add(sbn.getKey());
            }
            if (notificationsForPackage.size() == 0) {
                ungroupedNotificationsByUser.remove(sbn.getPackageName());
                removeSummary = true;
            }
        }
        if (removeSummary) {
            this.adjustAutogroupingSummary(userId, sbn.getPackageName(), null, false);
        }
        if (notificationsToUnAutogroup.size() > 0) {
            this.adjustNotificationBundling(notificationsToUnAutogroup, false);
        }
    }

    private void adjustAutogroupingSummary(int userId, String packageName, String triggeringKey, boolean summaryNeeded) {
        if (summaryNeeded) {
            this.mCallback.addAutoGroupSummary(userId, packageName, triggeringKey);
        } else {
            this.mCallback.removeAutoGroupSummary(userId, packageName);
        }
    }

    private void adjustNotificationBundling(List<String> keys, boolean group) {
        for (String key : keys) {
            if (DEBUG) {
                Log.i(TAG, "Sending grouping adjustment for: " + key + " group? " + group);
            }
            if (group) {
                this.mCallback.addAutoGroup(key);
                continue;
            }
            this.mCallback.removeAutoGroup(key);
        }
    }

    protected static interface Callback {
        public void addAutoGroup(String var1);

        public void removeAutoGroup(String var1);

        public void addAutoGroupSummary(int var1, String var2, String var3);

        public void removeAutoGroupSummary(int var1, String var2);
    }
}

