/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.function.TriPredicate;
import com.android.server.notification.NotificationManagerService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ManagedServices {
    protected final String TAG = this.getClass().getSimpleName();
    protected final boolean DEBUG = Log.isLoggable(this.TAG, 3);
    private static final int ON_BINDING_DIED_REBIND_DELAY_MS = 10000;
    protected static final String ENABLED_SERVICES_SEPARATOR = ":";
    static final String TAG_MANAGED_SERVICES = "service_listing";
    static final String ATT_APPROVED_LIST = "approved";
    static final String ATT_USER_ID = "user";
    static final String ATT_IS_PRIMARY = "primary";
    static final String ATT_VERSION = "version";
    static final int DB_VERSION = 1;
    static final int APPROVAL_BY_PACKAGE = 0;
    static final int APPROVAL_BY_COMPONENT = 1;
    protected final Context mContext;
    protected final Object mMutex;
    private final UserProfiles mUserProfiles;
    private final IPackageManager mPm;
    protected final UserManager mUm;
    private final Config mConfig;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final ArrayList<ManagedServiceInfo> mServices = new ArrayList();
    private final ArrayList<Pair<ComponentName, Integer>> mServicesBound = new ArrayList();
    private final ArraySet<Pair<ComponentName, Integer>> mServicesRebinding = new ArraySet();
    private ArraySet<ComponentName> mEnabledServicesForCurrentProfiles = new ArraySet();
    private ArraySet<String> mEnabledServicesPackageNames = new ArraySet();
    private ArraySet<ComponentName> mSnoozingForCurrentProfiles = new ArraySet();
    private ArrayMap<Integer, ArrayMap<Boolean, ArraySet<String>>> mApproved = new ArrayMap();
    private boolean mUseXml;
    protected int mApprovalLevel;

    public ManagedServices(Context context, Object mutex, UserProfiles userProfiles, IPackageManager pm) {
        this.mContext = context;
        this.mMutex = mutex;
        this.mUserProfiles = userProfiles;
        this.mPm = pm;
        this.mConfig = this.getConfig();
        this.mApprovalLevel = 1;
        this.mUm = (UserManager)this.mContext.getSystemService(ATT_USER_ID);
    }

    protected abstract Config getConfig();

    private String getCaption() {
        return this.mConfig.caption;
    }

    protected abstract IInterface asInterface(IBinder var1);

    protected abstract boolean checkType(IInterface var1);

    protected abstract void onServiceAdded(ManagedServiceInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ManagedServiceInfo> getServices() {
        Object object = this.mMutex;
        synchronized (object) {
            ArrayList<ManagedServiceInfo> services = new ArrayList<ManagedServiceInfo>(this.mServices);
            return services;
        }
    }

    protected int getBindFlags() {
        return 0x5000001;
    }

    protected void onServiceRemovedLocked(ManagedServiceInfo removed) {
    }

    private ManagedServiceInfo newServiceInfo(IInterface service, ComponentName component, int userId, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
        return new ManagedServiceInfo(service, component, userId, isSystem, connection, targetSdkVersion);
    }

    public void onBootPhaseAppsCanStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    Allowed " + this.getCaption() + "s:");
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            int userId = this.mApproved.keyAt(i);
            ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.valueAt(i);
            if (approvedByType == null) continue;
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                boolean isPrimary = approvedByType.keyAt(j);
                ArraySet<String> approved = approvedByType.valueAt(j);
                if (approvedByType == null || approvedByType.size() <= 0) continue;
                pw.println("      " + String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved) + " (user: " + userId + " isPrimary: " + isPrimary + ")");
            }
        }
        pw.println("    All " + this.getCaption() + "s (" + this.mEnabledServicesForCurrentProfiles.size() + ") enabled for current profiles:");
        for (ComponentName cmpt : this.mEnabledServicesForCurrentProfiles) {
            if (filter != null && !filter.matches(cmpt)) continue;
            pw.println("      " + cmpt);
        }
        pw.println("    Live " + this.getCaption() + "s (" + this.mServices.size() + "):");
        Iterator<ComponentName> iterator = this.mMutex;
        synchronized (iterator) {
            for (ManagedServiceInfo info : this.mServices) {
                if (filter != null && !filter.matches(info.component)) continue;
                pw.println("      " + info.component + " (user " + info.userid + "): " + info.service + (info.isSystem ? " SYSTEM" : "") + (info.isGuest(this) ? " GUEST" : ""));
            }
        }
        pw.println("    Snoozed " + this.getCaption() + "s (" + this.mSnoozingForCurrentProfiles.size() + "):");
        for (ComponentName name : this.mSnoozingForCurrentProfiles) {
            pw.println("      " + name.flattenToShortString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(ProtoOutputStream proto, NotificationManagerService.DumpFilter filter) {
        proto.write(0x10900000001L, this.getCaption());
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            int userId = this.mApproved.keyAt(i);
            ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.valueAt(i);
            if (approvedByType == null) continue;
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                boolean isPrimary = approvedByType.keyAt(j);
                ArraySet<String> approved = approvedByType.valueAt(j);
                if (approvedByType == null || approvedByType.size() <= 0) continue;
                long sToken = proto.start(0x20B00000002L);
                for (String s : approved) {
                    proto.write(2237677961217L, s);
                }
                proto.write(1120986464258L, userId);
                proto.write(1133871366147L, isPrimary);
                proto.end(sToken);
            }
        }
        for (ComponentName cmpt : this.mEnabledServicesForCurrentProfiles) {
            if (filter != null && !filter.matches(cmpt)) continue;
            cmpt.writeToProto(proto, 2246267895811L);
        }
        Iterator<ComponentName> iterator = this.mMutex;
        synchronized (iterator) {
            for (ManagedServiceInfo info : this.mServices) {
                if (filter != null && !filter.matches(info.component)) continue;
                info.writeToProto(proto, 2246267895812L, this);
            }
        }
        for (ComponentName name : this.mSnoozingForCurrentProfiles) {
            name.writeToProto(proto, 2246267895813L);
        }
    }

    protected void onSettingRestored(String element, String value, int backupSdkInt, int userId) {
        if (!this.mUseXml) {
            Slog.d(this.TAG, "Restored managed service setting: " + element);
            if (this.mConfig.secureSettingName.equals(element) || this.mConfig.secondarySettingName != null && this.mConfig.secondarySettingName.equals(element)) {
                String currentSetting;
                if (backupSdkInt < 26 && !TextUtils.isEmpty(currentSetting = this.getApproved(userId, this.mConfig.secureSettingName.equals(element)))) {
                    value = !TextUtils.isEmpty(value) ? value + ENABLED_SERVICES_SEPARATOR + currentSetting : currentSetting;
                }
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), element, value, userId);
                this.loadAllowedComponentsFromSettings();
                this.rebindServices(false, userId);
            }
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup, int userId) throws IOException {
        out.startTag(null, this.getConfig().xmlTag);
        out.attribute(null, ATT_VERSION, String.valueOf(1));
        if (forBackup) {
            this.trimApprovedListsAccordingToInstalledServices(userId);
        }
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            ArrayMap<Boolean, ArraySet<String>> approvedByType;
            int approvedUserId = this.mApproved.keyAt(i);
            if (forBackup && approvedUserId != userId || (approvedByType = this.mApproved.valueAt(i)) == null) continue;
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                boolean isPrimary = approvedByType.keyAt(j);
                Set approved = approvedByType.valueAt(j);
                if (approved == null) continue;
                String allowedItems = String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved);
                out.startTag(null, TAG_MANAGED_SERVICES);
                out.attribute(null, ATT_APPROVED_LIST, allowedItems);
                out.attribute(null, ATT_USER_ID, Integer.toString(approvedUserId));
                out.attribute(null, ATT_IS_PRIMARY, Boolean.toString(isPrimary));
                this.writeExtraAttributes(out, approvedUserId);
                out.endTag(null, TAG_MANAGED_SERVICES);
                if (forBackup || !isPrimary) continue;
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), this.getConfig().secureSettingName, allowedItems, approvedUserId);
            }
        }
        this.writeExtraXmlTags(out);
        out.endTag(null, this.getConfig().xmlTag);
    }

    protected void writeExtraAttributes(XmlSerializer out, int userId) throws IOException {
    }

    protected void writeExtraXmlTags(XmlSerializer out) throws IOException {
    }

    protected void readExtraTag(String tag, XmlPullParser parser) throws IOException {
    }

    protected void migrateToXml() {
        this.loadAllowedComponentsFromSettings();
    }

    public void readXml(XmlPullParser parser, TriPredicate<String, Integer, String> allowedManagedServicePackages, boolean forRestore, int userId) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 1) {
            String tag = parser.getName();
            if (type == 3 && this.getConfig().xmlTag.equals(tag)) break;
            if (type != 2) continue;
            if (TAG_MANAGED_SERVICES.equals(tag)) {
                Slog.i(this.TAG, "Read " + this.mConfig.caption + " permissions from xml");
                String approved = XmlUtils.readStringAttribute(parser, ATT_APPROVED_LIST);
                int resolvedUserId = forRestore ? userId : XmlUtils.readIntAttribute(parser, ATT_USER_ID, 0);
                boolean isPrimary = XmlUtils.readBooleanAttribute(parser, ATT_IS_PRIMARY, true);
                this.readExtraAttributes(tag, parser, resolvedUserId);
                if (allowedManagedServicePackages != null && !allowedManagedServicePackages.test(this.getPackageName(approved), resolvedUserId, this.getRequiredPermission())) continue;
                if (this.mUm.getUserInfo(resolvedUserId) != null) {
                    this.addApprovedList(approved, resolvedUserId, isPrimary);
                }
                this.mUseXml = true;
                continue;
            }
            this.readExtraTag(tag, parser);
        }
        this.rebindServices(false, -1);
    }

    protected void readExtraAttributes(String tag, XmlPullParser parser, int userId) throws IOException {
    }

    protected abstract String getRequiredPermission();

    private void loadAllowedComponentsFromSettings() {
        for (UserInfo user : this.mUm.getUsers()) {
            ContentResolver cr = this.mContext.getContentResolver();
            this.addApprovedList(Settings.Secure.getStringForUser(cr, this.getConfig().secureSettingName, user.id), user.id, true);
            if (TextUtils.isEmpty(this.getConfig().secondarySettingName)) continue;
            this.addApprovedList(Settings.Secure.getStringForUser(cr, this.getConfig().secondarySettingName, user.id), user.id, false);
        }
        Slog.d(this.TAG, "Done loading approved values from settings");
    }

    protected void addApprovedList(String approved, int userId, boolean isPrimary) {
        String[] approvedArray;
        ArraySet<String> approvedList;
        ArrayMap<Boolean, ArraySet<String>> approvedByType;
        if (TextUtils.isEmpty(approved)) {
            approved = "";
        }
        if ((approvedByType = this.mApproved.get(userId)) == null) {
            approvedByType = new ArrayMap();
            this.mApproved.put(userId, approvedByType);
        }
        if ((approvedList = approvedByType.get(isPrimary)) == null) {
            approvedList = new ArraySet();
            approvedByType.put(isPrimary, approvedList);
        }
        for (String pkgOrComponent : approvedArray = approved.split(ENABLED_SERVICES_SEPARATOR)) {
            String approvedItem = this.getApprovedValue(pkgOrComponent);
            if (approvedItem == null) continue;
            approvedList.add(approvedItem);
        }
    }

    protected boolean isComponentEnabledForPackage(String pkg) {
        return this.mEnabledServicesPackageNames.contains(pkg);
    }

    protected void setPackageOrComponentEnabled(String pkgOrComponent, int userId, boolean isPrimary, boolean enabled) {
        String approvedItem;
        ArraySet<String> approved;
        Slog.i(this.TAG, (enabled ? " Allowing " : "Disallowing ") + this.mConfig.caption + " " + pkgOrComponent);
        ArrayMap<Boolean, ArraySet<String>> allowedByType = this.mApproved.get(userId);
        if (allowedByType == null) {
            allowedByType = new ArrayMap();
            this.mApproved.put(userId, allowedByType);
        }
        if ((approved = allowedByType.get(isPrimary)) == null) {
            approved = new ArraySet();
            allowedByType.put(isPrimary, approved);
        }
        if ((approvedItem = this.getApprovedValue(pkgOrComponent)) != null) {
            if (enabled) {
                approved.add(approvedItem);
            } else {
                approved.remove(approvedItem);
            }
        }
        this.rebindServices(false, userId);
    }

    private String getApprovedValue(String pkgOrComponent) {
        if (this.mApprovalLevel == 1) {
            if (ComponentName.unflattenFromString(pkgOrComponent) != null) {
                return pkgOrComponent;
            }
            return null;
        }
        return this.getPackageName(pkgOrComponent);
    }

    protected String getApproved(int userId, boolean primary) {
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        ArraySet approved = allowedByType.getOrDefault(primary, new ArraySet());
        return String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved);
    }

    protected List<ComponentName> getAllowedComponents(int userId) {
        ArrayList<ComponentName> allowedComponents = new ArrayList<ComponentName>();
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            for (int j = 0; j < allowed.size(); ++j) {
                ComponentName cn = ComponentName.unflattenFromString((String)allowed.valueAt(j));
                if (cn == null) continue;
                allowedComponents.add(cn);
            }
        }
        return allowedComponents;
    }

    protected List<String> getAllowedPackages(int userId) {
        ArrayList<String> allowedPackages = new ArrayList<String>();
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            for (int j = 0; j < allowed.size(); ++j) {
                String pkgName = this.getPackageName((String)allowed.valueAt(j));
                if (TextUtils.isEmpty(pkgName)) continue;
                allowedPackages.add(pkgName);
            }
        }
        return allowedPackages;
    }

    protected boolean isPackageOrComponentAllowed(String pkgOrComponent, int userId) {
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            if (!allowed.contains(pkgOrComponent)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPackageAllowed(String pkg, int userId) {
        if (pkg == null) {
            return false;
        }
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            for (String allowedEntry : allowed) {
                ComponentName component = ComponentName.unflattenFromString(allowedEntry);
                if (!(component != null ? pkg.equals(component.getPackageName()) : pkg.equals(allowedEntry))) continue;
                return true;
            }
        }
        return false;
    }

    public void onPackagesChanged(boolean removingPackage, String[] pkgList, int[] uidList) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onPackagesChanged removingPackage=" + removingPackage + " pkgList=" + (pkgList == null ? null : Arrays.asList(pkgList)) + " mEnabledServicesPackageNames=" + this.mEnabledServicesPackageNames);
        }
        if (pkgList != null && pkgList.length > 0) {
            boolean anyServicesInvolved = false;
            if (removingPackage && uidList != null) {
                int size = Math.min(pkgList.length, uidList.length);
                for (int i = 0; i < size; ++i) {
                    String pkg = pkgList[i];
                    int userId = UserHandle.getUserId(uidList[i]);
                    anyServicesInvolved = this.removeUninstalledItemsFromApprovedLists(userId, pkg);
                }
            }
            for (String pkgName : pkgList) {
                if (this.mEnabledServicesPackageNames.contains(pkgName)) {
                    anyServicesInvolved = true;
                }
                if (uidList == null || uidList.length <= 0) continue;
                for (int uid : uidList) {
                    if (!this.isPackageAllowed(pkgName, UserHandle.getUserId(uid))) continue;
                    anyServicesInvolved = true;
                }
            }
            if (anyServicesInvolved) {
                this.rebindServices(false, -1);
            }
        }
    }

    public void onUserRemoved(int user) {
        Slog.i(this.TAG, "Removing approved services for removed user " + user);
        this.mApproved.remove(user);
        this.rebindServices(true, user);
    }

    public void onUserSwitched(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserSwitched u=" + user);
        }
        this.rebindServices(true, user);
    }

    public void onUserUnlocked(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserUnlocked u=" + user);
        }
        this.rebindServices(false, user);
    }

    private ManagedServiceInfo getServiceFromTokenLocked(IInterface service) {
        if (service == null) {
            return null;
        }
        IBinder token = service.asBinder();
        int N = this.mServices.size();
        for (int i = 0; i < N; ++i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (info.service.asBinder() != token) continue;
            return info;
        }
        return null;
    }

    protected boolean isServiceTokenValidLocked(IInterface service) {
        if (service == null) {
            return false;
        }
        ManagedServiceInfo info = this.getServiceFromTokenLocked(service);
        return info != null;
    }

    protected ManagedServiceInfo checkServiceTokenLocked(IInterface service) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.getServiceFromTokenLocked(service);
        if (info != null) {
            return info;
        }
        throw new SecurityException("Disallowed call from unknown " + this.getCaption() + ": " + service + " " + service.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSameUser(IInterface service, int userId) {
        this.checkNotNull(service);
        Object object = this.mMutex;
        synchronized (object) {
            ManagedServiceInfo info = this.getServiceFromTokenLocked(service);
            if (info != null) {
                return info.isSameUser(userId);
            }
            return false;
        }
    }

    public void unregisterService(IInterface service, int userid) {
        this.checkNotNull(service);
        this.unregisterServiceImpl(service, userid);
    }

    public void registerService(IInterface service, ComponentName component, int userid) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.registerServiceImpl(service, component, userid);
        if (info != null) {
            this.onServiceAdded(info);
        }
    }

    protected void registerGuestService(ManagedServiceInfo guest) {
        this.checkNotNull(guest.service);
        if (!this.checkType(guest.service)) {
            throw new IllegalArgumentException();
        }
        if (this.registerServiceImpl(guest) != null) {
            this.onServiceAdded(guest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setComponentState(ComponentName component, boolean enabled) {
        boolean previous;
        boolean bl = previous = !this.mSnoozingForCurrentProfiles.contains(component);
        if (previous == enabled) {
            return;
        }
        if (enabled) {
            this.mSnoozingForCurrentProfiles.remove(component);
        } else {
            this.mSnoozingForCurrentProfiles.add(component);
        }
        Slog.d(this.TAG, (enabled ? "Enabling " : "Disabling ") + "component " + component.flattenToShortString());
        Object object = this.mMutex;
        synchronized (object) {
            IntArray userIds = this.mUserProfiles.getCurrentProfileIds();
            for (int i = 0; i < userIds.size(); ++i) {
                int userId = userIds.get(i);
                if (enabled) {
                    if (this.isPackageOrComponentAllowed(component.flattenToString(), userId) || this.isPackageOrComponentAllowed(component.getPackageName(), userId)) {
                        this.registerServiceLocked(component, userId);
                        continue;
                    }
                    Slog.d(this.TAG, component + " no longer has permission to be bound");
                    continue;
                }
                this.unregisterServiceLocked(component, userId);
            }
        }
    }

    private ArraySet<ComponentName> loadComponentNamesFromValues(ArraySet<String> approved, int userId) {
        if (approved == null || approved.size() == 0) {
            return new ArraySet<ComponentName>();
        }
        ArraySet<ComponentName> result = new ArraySet<ComponentName>(approved.size());
        for (int i = 0; i < approved.size(); ++i) {
            String packageOrComponent = approved.valueAt(i);
            if (TextUtils.isEmpty(packageOrComponent)) continue;
            ComponentName component = ComponentName.unflattenFromString(packageOrComponent);
            if (component != null) {
                result.add(component);
                continue;
            }
            result.addAll(this.queryPackageForServices(packageOrComponent, userId));
        }
        return result;
    }

    protected Set<ComponentName> queryPackageForServices(String packageName, int userId) {
        return this.queryPackageForServices(packageName, 0, userId);
    }

    protected Set<ComponentName> queryPackageForServices(String packageName, int extraFlags, int userId) {
        ArraySet<ComponentName> installed = new ArraySet<ComponentName>();
        PackageManager pm = this.mContext.getPackageManager();
        Intent queryIntent = new Intent(this.mConfig.serviceInterface);
        if (!TextUtils.isEmpty(packageName)) {
            queryIntent.setPackage(packageName);
        }
        List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(queryIntent, 0x84 | extraFlags, userId);
        if (this.DEBUG) {
            Slog.v(this.TAG, this.mConfig.serviceInterface + " services: " + installedServices);
        }
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                ComponentName component = new ComponentName(info.packageName, info.name);
                if (!this.mConfig.bindPermission.equals(info.permission)) {
                    Slog.w(this.TAG, "Skipping " + this.getCaption() + " service " + info.packageName + "/" + info.name + ": it does not require the permission " + this.mConfig.bindPermission);
                    continue;
                }
                installed.add(component);
            }
        }
        return installed;
    }

    protected Set<String> getAllowedPackages() {
        ArraySet<String> allowedPackages = new ArraySet<String>();
        for (int k = 0; k < this.mApproved.size(); ++k) {
            ArrayMap<Boolean, ArraySet<String>> allowedByType = this.mApproved.valueAt(k);
            for (int i = 0; i < allowedByType.size(); ++i) {
                ArraySet<String> allowed = allowedByType.valueAt(i);
                for (int j = 0; j < allowed.size(); ++j) {
                    String pkgName = this.getPackageName(allowed.valueAt(j));
                    if (TextUtils.isEmpty(pkgName)) continue;
                    allowedPackages.add(pkgName);
                }
            }
        }
        return allowedPackages;
    }

    private void trimApprovedListsAccordingToInstalledServices(int userId) {
        ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.get(userId);
        if (approvedByType == null) {
            return;
        }
        for (int i = 0; i < approvedByType.size(); ++i) {
            ArraySet<String> approved = approvedByType.valueAt(i);
            for (int j = approved.size() - 1; j >= 0; --j) {
                String approvedPackageOrComponent = approved.valueAt(j);
                if (!this.isValidEntry(approvedPackageOrComponent, userId)) {
                    approved.removeAt(j);
                    Slog.v(this.TAG, "Removing " + approvedPackageOrComponent + " from approved list; no matching services found");
                    continue;
                }
                if (!this.DEBUG) continue;
                Slog.v(this.TAG, "Keeping " + approvedPackageOrComponent + " on approved list; matching services found");
            }
        }
    }

    private boolean removeUninstalledItemsFromApprovedLists(int uninstalledUserId, String pkg) {
        boolean removed = false;
        ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.get(uninstalledUserId);
        if (approvedByType != null) {
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                ArraySet<String> approved = approvedByType.valueAt(j);
                int O = approved.size();
                for (int k = O - 1; k >= 0; --k) {
                    String packageOrComponent = approved.valueAt(k);
                    String packageName = this.getPackageName(packageOrComponent);
                    if (!TextUtils.equals(pkg, packageName)) continue;
                    approved.removeAt(k);
                    if (!this.DEBUG) continue;
                    Slog.v(this.TAG, "Removing " + packageOrComponent + " from approved list; uninstalled");
                }
            }
        }
        return removed;
    }

    protected String getPackageName(String packageOrComponent) {
        ComponentName component = ComponentName.unflattenFromString(packageOrComponent);
        if (component != null) {
            return component.getPackageName();
        }
        return packageOrComponent;
    }

    protected boolean isValidEntry(String packageOrComponent, int userId) {
        return this.hasMatchingServices(packageOrComponent, userId);
    }

    private boolean hasMatchingServices(String packageOrComponent, int userId) {
        if (!TextUtils.isEmpty(packageOrComponent)) {
            String packageName = this.getPackageName(packageOrComponent);
            return this.queryPackageForServices(packageName, userId).size() > 0;
        }
        return false;
    }

    @VisibleForTesting
    protected SparseArray<ArraySet<ComponentName>> getAllowedComponents(IntArray userIds) {
        int nUserIds = userIds.size();
        SparseArray<ArraySet<ComponentName>> componentsByUser = new SparseArray<ArraySet<ComponentName>>();
        for (int i = 0; i < nUserIds; ++i) {
            int userId = userIds.get(i);
            ArrayMap<Boolean, ArraySet<String>> approvedLists = this.mApproved.get(userId);
            if (approvedLists == null) continue;
            int N = approvedLists.size();
            for (int j = 0; j < N; ++j) {
                ArraySet<ComponentName> approvedByUser = componentsByUser.get(userId);
                if (approvedByUser == null) {
                    approvedByUser = new ArraySet();
                    componentsByUser.put(userId, approvedByUser);
                }
                approvedByUser.addAll(this.loadComponentNamesFromValues(approvedLists.valueAt(j), userId));
            }
        }
        return componentsByUser;
    }

    @GuardedBy(value={"mMutex"})
    protected void populateComponentsToBind(SparseArray<Set<ComponentName>> componentsToBind, IntArray activeUsers, SparseArray<ArraySet<ComponentName>> approvedComponentsByUser) {
        this.mEnabledServicesForCurrentProfiles.clear();
        this.mEnabledServicesPackageNames.clear();
        int nUserIds = activeUsers.size();
        for (int i = 0; i < nUserIds; ++i) {
            int userId = activeUsers.get(i);
            ArraySet<ComponentName> userComponents = approvedComponentsByUser.get(userId);
            if (null == userComponents) {
                componentsToBind.put(userId, new ArraySet());
                continue;
            }
            HashSet<ComponentName> add = new HashSet<ComponentName>(userComponents);
            add.removeAll(this.mSnoozingForCurrentProfiles);
            componentsToBind.put(userId, add);
            this.mEnabledServicesForCurrentProfiles.addAll(userComponents);
            for (int j = 0; j < userComponents.size(); ++j) {
                ComponentName component = userComponents.valueAt(j);
                this.mEnabledServicesPackageNames.add(component.getPackageName());
            }
        }
    }

    @GuardedBy(value={"mMutex"})
    protected Set<ManagedServiceInfo> getRemovableConnectedServices() {
        ArraySet<ManagedServiceInfo> removableBoundServices = new ArraySet<ManagedServiceInfo>();
        for (ManagedServiceInfo service : this.mServices) {
            if (service.isSystem || service.isGuest(this)) continue;
            removableBoundServices.add(service);
        }
        return removableBoundServices;
    }

    protected void populateComponentsToUnbind(boolean forceRebind, Set<ManagedServiceInfo> removableBoundServices, SparseArray<Set<ComponentName>> allowedComponentsToBind, SparseArray<Set<ComponentName>> componentsToUnbind) {
        for (ManagedServiceInfo info : removableBoundServices) {
            Set<ComponentName> allowedComponents = allowedComponentsToBind.get(info.userid);
            if (allowedComponents == null || !forceRebind && allowedComponents.contains(info.component)) continue;
            Set toUnbind = componentsToUnbind.get(info.userid, new ArraySet());
            toUnbind.add(info.component);
            componentsToUnbind.put(info.userid, toUnbind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebindServices(boolean forceRebind, int userToRebind) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "rebindServices " + forceRebind + " " + userToRebind);
        }
        IntArray userIds = this.mUserProfiles.getCurrentProfileIds();
        if (userToRebind != -1) {
            userIds = new IntArray(1);
            userIds.add(userToRebind);
        }
        SparseArray<Set<ComponentName>> componentsToBind = new SparseArray<Set<ComponentName>>();
        SparseArray<Set<ComponentName>> componentsToUnbind = new SparseArray<Set<ComponentName>>();
        Object object = this.mMutex;
        synchronized (object) {
            SparseArray<ArraySet<ComponentName>> approvedComponentsByUser = this.getAllowedComponents(userIds);
            Set<ManagedServiceInfo> removableBoundServices = this.getRemovableConnectedServices();
            this.populateComponentsToBind(componentsToBind, userIds, approvedComponentsByUser);
            this.populateComponentsToUnbind(forceRebind, removableBoundServices, componentsToBind, componentsToUnbind);
        }
        this.unbindFromServices(componentsToUnbind);
        this.bindToServices(componentsToBind);
    }

    protected void unbindFromServices(SparseArray<Set<ComponentName>> componentsToUnbind) {
        for (int i = 0; i < componentsToUnbind.size(); ++i) {
            int userId = componentsToUnbind.keyAt(i);
            Set<ComponentName> removableComponents = componentsToUnbind.get(userId);
            for (ComponentName cn : removableComponents) {
                Slog.v(this.TAG, "disabling " + this.getCaption() + " for user " + userId + ": " + cn);
                this.unregisterService(cn, userId);
            }
        }
    }

    private void bindToServices(SparseArray<Set<ComponentName>> componentsToBind) {
        for (int i = 0; i < componentsToBind.size(); ++i) {
            int userId = componentsToBind.keyAt(i);
            Set<ComponentName> add = componentsToBind.get(userId);
            for (ComponentName component : add) {
                try {
                    ServiceInfo info = this.mPm.getServiceInfo(component, 786432, userId);
                    if (info == null) {
                        Slog.w(this.TAG, "Not binding " + this.getCaption() + " service " + component + ": service not found");
                        continue;
                    }
                    if (!this.mConfig.bindPermission.equals(info.permission)) {
                        Slog.w(this.TAG, "Not binding " + this.getCaption() + " service " + component + ": it does not require the permission " + this.mConfig.bindPermission);
                        continue;
                    }
                    Slog.v(this.TAG, "enabling " + this.getCaption() + " for " + userId + ": " + component);
                    this.registerService(component, userId);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSystemService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid, true);
        }
    }

    private void registerServiceLocked(ComponentName name, int userid) {
        this.registerServiceLocked(name, userid, false);
    }

    private void registerServiceLocked(ComponentName name, final int userid, final boolean isSystem) {
        Pair<ComponentName, Integer> servicesBindingTag;
        if (this.DEBUG) {
            Slog.v(this.TAG, "registerService: " + name + " u=" + userid);
        }
        if (this.mServicesBound.contains(servicesBindingTag = Pair.create(name, userid))) {
            Slog.v(this.TAG, "Not registering " + name + " is already bound");
            return;
        }
        this.mServicesBound.add(servicesBindingTag);
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            Slog.v(this.TAG, "    disconnecting old " + this.getCaption() + ": " + info.service);
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            this.unbindService(info.connection, info.component, info.userid);
        }
        Intent intent = new Intent(this.mConfig.serviceInterface);
        intent.setComponent(name);
        intent.putExtra("android.intent.extra.client_label", this.mConfig.clientLabel);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent(this.mConfig.settingsAction), 0);
        intent.putExtra("android.intent.extra.client_intent", pendingIntent);
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfo(name.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        final int targetSdkVersion = appInfo != null ? appInfo.targetSdkVersion : 1;
        try {
            Slog.v(this.TAG, "binding: " + intent);
            ServiceConnection serviceConnection = new ServiceConnection(){
                IInterface mService;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder binder) {
                    Slog.v(ManagedServices.this.TAG, userid + " " + ManagedServices.this.getCaption() + " service connected: " + name);
                    boolean added = false;
                    ManagedServiceInfo info = null;
                    Object object = ManagedServices.this.mMutex;
                    synchronized (object) {
                        ManagedServices.this.mServicesRebinding.remove(servicesBindingTag);
                        try {
                            this.mService = ManagedServices.this.asInterface(binder);
                            info = ManagedServices.this.newServiceInfo(this.mService, name, userid, isSystem, this, targetSdkVersion);
                            binder.linkToDeath(info, 0);
                            added = ManagedServices.this.mServices.add(info);
                        }
                        catch (RemoteException e) {
                            Slog.e(ManagedServices.this.TAG, "Failed to linkToDeath, already dead", e);
                        }
                    }
                    if (added) {
                        ManagedServices.this.onServiceAdded(info);
                    }
                }

                @Override
                public void onServiceDisconnected(ComponentName name) {
                    Slog.v(ManagedServices.this.TAG, userid + " " + ManagedServices.this.getCaption() + " connection lost: " + name);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBindingDied(final ComponentName name) {
                    Slog.w(ManagedServices.this.TAG, userid + " " + ManagedServices.this.getCaption() + " binding died: " + name);
                    Object object = ManagedServices.this.mMutex;
                    synchronized (object) {
                        ManagedServices.this.unbindService(this, name, userid);
                        if (!ManagedServices.this.mServicesRebinding.contains(servicesBindingTag)) {
                            ManagedServices.this.mServicesRebinding.add(servicesBindingTag);
                            ManagedServices.this.mHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    ManagedServices.this.registerService(name, userid);
                                }
                            }, 10000L);
                        } else {
                            Slog.v(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " not rebinding in user " + userid + " as a previous rebind attempt was made: " + name);
                        }
                    }
                }

                @Override
                public void onNullBinding(ComponentName name) {
                    Slog.v(ManagedServices.this.TAG, "onNullBinding() called with: name = [" + name + "]");
                    ManagedServices.this.mServicesBound.remove(servicesBindingTag);
                }
            };
            if (!this.mContext.bindServiceAsUser(intent, serviceConnection, this.getBindFlags(), new UserHandle(userid))) {
                this.mServicesBound.remove(servicesBindingTag);
                Slog.w(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent + " in user " + userid);
                return;
            }
        }
        catch (SecurityException ex) {
            this.mServicesBound.remove(servicesBindingTag);
            Slog.e(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent, ex);
        }
    }

    boolean isBound(ComponentName cn, int userId) {
        Pair<ComponentName, Integer> servicesBindingTag = Pair.create(cn, userId);
        return this.mServicesBound.contains(servicesBindingTag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.unregisterServiceLocked(name, userid);
        }
    }

    private void unregisterServiceLocked(ComponentName name, int userid) {
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            this.unbindService(info.connection, info.component, info.userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo removeServiceImpl(IInterface service, int userid) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "removeServiceImpl service=" + service + " u=" + userid);
        }
        ManagedServiceInfo serviceInfo = null;
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (info.service.asBinder() != service.asBinder() || info.userid != userid) continue;
                Slog.d(this.TAG, "Removing active service " + info.component);
                serviceInfo = this.removeServiceLocked(i);
            }
        }
        return serviceInfo;
    }

    private ManagedServiceInfo removeServiceLocked(int i) {
        ManagedServiceInfo info = this.mServices.remove(i);
        this.onServiceRemovedLocked(info);
        return info;
    }

    private void checkNotNull(IInterface service) {
        if (service == null) {
            throw new IllegalArgumentException(this.getCaption() + " must not be null");
        }
    }

    private ManagedServiceInfo registerServiceImpl(IInterface service, ComponentName component, int userid) {
        ManagedServiceInfo info = this.newServiceInfo(service, component, userid, true, null, 21);
        return this.registerServiceImpl(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo registerServiceImpl(ManagedServiceInfo info) {
        Object object = this.mMutex;
        synchronized (object) {
            try {
                info.service.asBinder().linkToDeath(info, 0);
                this.mServices.add(info);
                return info;
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    private void unregisterServiceImpl(IInterface service, int userid) {
        ManagedServiceInfo info = this.removeServiceImpl(service, userid);
        if (info != null && info.connection != null && !info.isGuest(this)) {
            this.unbindService(info.connection, info.component, info.userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindService(ServiceConnection connection, ComponentName component, int userId) {
        try {
            this.mContext.unbindService(connection);
        }
        catch (IllegalArgumentException e) {
            Slog.e(this.TAG, this.getCaption() + " " + component + " could not be unbound", e);
        }
        Object object = this.mMutex;
        synchronized (object) {
            this.mServicesBound.remove(Pair.create(component, userId));
        }
    }

    public boolean isComponentEnabledForCurrentProfiles(ComponentName component) {
        return this.mEnabledServicesForCurrentProfiles.contains(component);
    }

    public static class Config {
        public String caption;
        public String serviceInterface;
        public String secureSettingName;
        public String secondarySettingName;
        public String xmlTag;
        public String bindPermission;
        public String settingsAction;
        public int clientLabel;
    }

    public static class UserProfiles {
        private final SparseArray<UserInfo> mCurrentProfiles = new SparseArray();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(Context context) {
            UserManager userManager = (UserManager)context.getSystemService(ManagedServices.ATT_USER_ID);
            if (userManager != null) {
                int currentUserId = ActivityManager.getCurrentUser();
                List<UserInfo> profiles = userManager.getProfiles(currentUserId);
                SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
                synchronized (sparseArray) {
                    this.mCurrentProfiles.clear();
                    for (UserInfo user : profiles) {
                        this.mCurrentProfiles.put(user.id, user);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IntArray getCurrentProfileIds() {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                IntArray users = new IntArray(this.mCurrentProfiles.size());
                int N = this.mCurrentProfiles.size();
                for (int i = 0; i < N; ++i) {
                    users.add(this.mCurrentProfiles.keyAt(i));
                }
                return users;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                return this.mCurrentProfiles.get(userId) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isManagedProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                UserInfo user = this.mCurrentProfiles.get(userId);
                return user != null && user.isManagedProfile();
            }
        }
    }

    public class ManagedServiceInfo
    implements IBinder.DeathRecipient {
        public IInterface service;
        public ComponentName component;
        public int userid;
        public boolean isSystem;
        public ServiceConnection connection;
        public int targetSdkVersion;

        public ManagedServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
            this.service = service;
            this.component = component;
            this.userid = userid;
            this.isSystem = isSystem;
            this.connection = connection;
            this.targetSdkVersion = targetSdkVersion;
        }

        public boolean isGuest(ManagedServices host) {
            return ManagedServices.this != host;
        }

        public ManagedServices getOwner() {
            return ManagedServices.this;
        }

        public String toString() {
            return "ManagedServiceInfo[" + "component=" + this.component + ",userid=" + this.userid + ",isSystem=" + this.isSystem + ",targetSdkVersion=" + this.targetSdkVersion + ",connection=" + (this.connection == null ? null : "<connection>") + ",service=" + this.service + ']';
        }

        public void writeToProto(ProtoOutputStream proto, long fieldId, ManagedServices host) {
            long token = proto.start(fieldId);
            this.component.writeToProto(proto, 0x10B00000001L);
            proto.write(1120986464258L, this.userid);
            proto.write(1138166333443L, this.service.getClass().getName());
            proto.write(1133871366148L, this.isSystem);
            proto.write(1133871366149L, this.isGuest(host));
            proto.end(token);
        }

        public boolean isSameUser(int userId) {
            if (!this.isEnabledForCurrentProfiles()) {
                return false;
            }
            return this.userid == userId;
        }

        public boolean enabledAndUserMatches(int nid) {
            if (!this.isEnabledForCurrentProfiles()) {
                return false;
            }
            if (this.userid == -1) {
                return true;
            }
            if (this.isSystem) {
                return true;
            }
            if (nid == -1 || nid == this.userid) {
                return true;
            }
            return this.supportsProfiles() && ManagedServices.this.mUserProfiles.isCurrentProfile(nid) && this.isPermittedForProfile(nid);
        }

        public boolean supportsProfiles() {
            return this.targetSdkVersion >= 21;
        }

        @Override
        public void binderDied() {
            if (ManagedServices.this.DEBUG) {
                Slog.d(ManagedServices.this.TAG, "binderDied");
            }
            ManagedServices.this.removeServiceImpl(this.service, this.userid);
        }

        public boolean isEnabledForCurrentProfiles() {
            if (this.isSystem) {
                return true;
            }
            if (this.connection == null) {
                return false;
            }
            return ManagedServices.this.mEnabledServicesForCurrentProfiles.contains(this.component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPermittedForProfile(int userId) {
            if (!ManagedServices.this.mUserProfiles.isManagedProfile(userId)) {
                return true;
            }
            DevicePolicyManager dpm = (DevicePolicyManager)ManagedServices.this.mContext.getSystemService("device_policy");
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = dpm.isNotificationListenerServicePermitted(this.component.getPackageName(), userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagedServiceInfo that = (ManagedServiceInfo)o;
            return this.userid == that.userid && this.isSystem == that.isSystem && this.targetSdkVersion == that.targetSdkVersion && Objects.equals(this.service, that.service) && Objects.equals(this.component, that.component) && Objects.equals(this.connection, that.connection);
        }

        public int hashCode() {
            return Objects.hash(this.service, this.component, this.userid, this.isSystem, this.connection, this.targetSdkVersion);
        }
    }
}

