/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.AutomaticZenRule;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.ITransientNotification;
import android.app.IUriGrantsManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.RemoteInput;
import android.app.UriGrantsManager;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.backup.BackupManager;
import android.app.role.OnRoleHoldersChangedListener;
import android.app.role.RoleManager;
import android.app.usage.UsageStatsManagerInternal;
import android.companion.ICompanionDeviceManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.AudioManagerInternal;
import android.media.IRingtonePlayer;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.VibrationEffect;
import android.os.Vibrator;
import android.provider.DeviceConfig;
import android.provider.Settings;
import android.service.notification.Adjustment;
import android.service.notification.Condition;
import android.service.notification.IConditionProvider;
import android.service.notification.INotificationListener;
import android.service.notification.IStatusBarNotificationHolder;
import android.service.notification.NotificationListenerService;
import android.service.notification.NotificationRankingUpdate;
import android.service.notification.NotificationStats;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.IntArray;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.StatsLog;
import android.util.Xml;
import android.util.proto.ProtoOutputStream;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.widget.Toast;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.internal.statusbar.NotificationVisibility;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.CollectionUtils;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.util.function.TriPredicate;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.lights.Light;
import com.android.server.lights.LightsManager;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.GroupHelper;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationDelegate;
import com.android.server.notification.NotificationManagerInternal;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationShellCmd;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.PreferencesHelper;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingHelper;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.SnoozeHelper;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeHelper;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.uri.UriGrantsManagerInternal;
import com.android.server.wm.WindowManagerInternal;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import libcore.io.IoUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class NotificationManagerService
extends SystemService {
    static final String TAG = "NotificationService";
    static final boolean DBG = Log.isLoggable("NotificationService", 3);
    public static final boolean ENABLE_CHILD_NOTIFICATIONS = SystemProperties.getBoolean("debug.child_notifs", true);
    static final boolean DEBUG_INTERRUPTIVENESS = SystemProperties.getBoolean("debug.notification.interruptiveness", false);
    static final int MAX_PACKAGE_NOTIFICATIONS = 25;
    static final float DEFAULT_MAX_NOTIFICATION_ENQUEUE_RATE = 5.0f;
    static final int MESSAGE_DURATION_REACHED = 2;
    static final int MESSAGE_SEND_RANKING_UPDATE = 4;
    static final int MESSAGE_LISTENER_HINTS_CHANGED = 5;
    static final int MESSAGE_LISTENER_NOTIFICATION_FILTER_CHANGED = 6;
    static final int MESSAGE_FINISH_TOKEN_TIMEOUT = 7;
    static final int MESSAGE_ON_PACKAGE_CHANGED = 8;
    private static final int MESSAGE_RECONSIDER_RANKING = 1000;
    private static final int MESSAGE_RANKING_SORT = 1001;
    static final int LONG_DELAY = 3500;
    static final int SHORT_DELAY = 2000;
    static final int FINISH_TOKEN_TIMEOUT = 11000;
    static final long[] DEFAULT_VIBRATE_PATTERN = new long[]{0L, 250L, 250L, 250L};
    static final long SNOOZE_UNTIL_UNSPECIFIED = -1L;
    static final int VIBRATE_PATTERN_MAXLEN = 17;
    static final int DEFAULT_STREAM_TYPE = 5;
    static final boolean ENABLE_BLOCKED_TOASTS = true;
    static final String[] DEFAULT_ALLOWED_ADJUSTMENTS = new String[]{"key_contextual_actions", "key_text_replies"};
    static final String[] NON_BLOCKABLE_DEFAULT_ROLES = new String[]{"android.app.role.DIALER", "android.app.role.EMERGENCY"};
    static final int MATCHES_CALL_FILTER_CONTACTS_TIMEOUT_MS = 3000;
    static final float MATCHES_CALL_FILTER_TIMEOUT_AFFINITY = 1.0f;
    private static final int EVENTLOG_ENQUEUE_STATUS_NEW = 0;
    private static final int EVENTLOG_ENQUEUE_STATUS_UPDATE = 1;
    private static final int EVENTLOG_ENQUEUE_STATUS_IGNORED = 2;
    private static final long MIN_PACKAGE_OVERRATE_LOG_INTERVAL = 5000L;
    private static final long DELAY_FOR_ASSISTANT_TIME = 100L;
    private static final String ACTION_NOTIFICATION_TIMEOUT = NotificationManagerService.class.getSimpleName() + ".TIMEOUT";
    private static final int REQUEST_CODE_TIMEOUT = 1;
    private static final String SCHEME_TIMEOUT = "timeout";
    private static final String EXTRA_KEY = "key";
    private IActivityManager mAm;
    private ActivityManager mActivityManager;
    private IPackageManager mPackageManager;
    private PackageManager mPackageManagerClient;
    AudioManager mAudioManager;
    AudioManagerInternal mAudioManagerInternal;
    StatusBarManagerInternal mStatusBar;
    Vibrator mVibrator;
    private WindowManagerInternal mWindowManagerInternal;
    private AlarmManager mAlarmManager;
    private ICompanionDeviceManager mCompanionManager;
    private AccessibilityManager mAccessibilityManager;
    private IDeviceIdleController mDeviceIdleController;
    private IUriGrantsManager mUgm;
    private UriGrantsManagerInternal mUgmInternal;
    private RoleObserver mRoleObserver;
    private UserManager mUm;
    final IBinder mForegroundToken = new Binder();
    private WorkerHandler mHandler;
    private final HandlerThread mRankingThread = new HandlerThread("ranker", 10);
    private Light mNotificationLight;
    Light mAttentionLight;
    private long[] mFallbackVibrationPattern;
    private boolean mUseAttentionLight;
    boolean mHasLight = true;
    boolean mLightEnabled;
    boolean mSystemReady;
    private boolean mDisableNotificationEffects;
    private int mCallState;
    private String mSoundNotificationKey;
    private String mVibrateNotificationKey;
    private final SparseArray<ArraySet<ComponentName>> mListenersDisablingEffects = new SparseArray();
    private List<ComponentName> mEffectsSuppressors = new ArrayList<ComponentName>();
    private int mListenerHints;
    private int mInterruptionFilter = 0;
    boolean mScreenOn = true;
    protected boolean mInCall = false;
    boolean mNotificationPulseEnabled;
    private Uri mInCallNotificationUri;
    private AudioAttributes mInCallNotificationAudioAttributes;
    private float mInCallNotificationVolume;
    private Binder mCallNotificationToken = null;
    final Object mNotificationLock = new Object();
    @GuardedBy(value={"mNotificationLock"})
    final ArrayList<NotificationRecord> mNotificationList = new ArrayList();
    @GuardedBy(value={"mNotificationLock"})
    final ArrayMap<String, NotificationRecord> mNotificationsByKey = new ArrayMap();
    @GuardedBy(value={"mNotificationLock"})
    final ArrayList<NotificationRecord> mEnqueuedNotifications = new ArrayList();
    @GuardedBy(value={"mNotificationLock"})
    final ArrayMap<Integer, ArrayMap<String, String>> mAutobundledSummaries = new ArrayMap();
    final ArrayList<ToastRecord> mToastQueue = new ArrayList();
    final ArrayMap<String, NotificationRecord> mSummaryByGroupKey = new ArrayMap();
    ArrayList<String> mLights = new ArrayList();
    private AppOpsManager mAppOps;
    private UsageStatsManagerInternal mAppUsageStats;
    private DevicePolicyManagerInternal mDpm;
    private Archive mArchive;
    private AtomicFile mPolicyFile;
    private static final int DB_VERSION = 1;
    private static final String TAG_NOTIFICATION_POLICY = "notification-policy";
    private static final String ATTR_VERSION = "version";
    private static final String LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_TAG = "allow-secure-notifications-on-lockscreen";
    private static final String LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_VALUE = "value";
    private RankingHelper mRankingHelper;
    private PreferencesHelper mPreferencesHelper;
    private final ManagedServices.UserProfiles mUserProfiles = new ManagedServices.UserProfiles();
    private NotificationListeners mListeners;
    private NotificationAssistants mAssistants;
    private ConditionProviders mConditionProviders;
    private NotificationUsageStats mUsageStats;
    private boolean mLockScreenAllowSecureNotifications = true;
    private static final int MY_UID = Process.myUid();
    private static final int MY_PID = Process.myPid();
    private static final IBinder WHITELIST_TOKEN = new Binder();
    private RankingHandler mRankingHandler;
    private long mLastOverRateLogTime;
    private float mMaxPackageEnqueueRate = 5.0f;
    private SnoozeHelper mSnoozeHelper;
    private GroupHelper mGroupHelper;
    private int mAutoGroupAtCount;
    private boolean mIsTelevision;
    private boolean mIsAutomotive;
    private boolean mNotificationEffectsEnabledForAutomotive;
    private MetricsLogger mMetricsLogger;
    private TriPredicate<String, Integer, String> mAllowedManagedServicePackages;
    @VisibleForTesting
    final NotificationDelegate mNotificationDelegate = new NotificationDelegate(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSetDisabled(int status) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationManagerService.this.mDisableNotificationEffects = (status & 0x40000) != 0;
                if (NotificationManagerService.this.disableNotificationEffects(null) != null) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        IRingtonePlayer player = NotificationManagerService.this.mAudioManager.getRingtonePlayer();
                        if (player != null) {
                            player.stopAsync();
                        }
                    }
                    catch (RemoteException remoteException) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    identity = Binder.clearCallingIdentity();
                    try {
                        NotificationManagerService.this.mVibrator.cancel();
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onClearAll(int callingUid, int callingPid, int userId) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, userId, 3, null, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationClick(int callingUid, int callingPid, String key, NotificationVisibility nv) {
            NotificationManagerService.this.exitIdle();
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Slog.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                MetricsLogger.action(r.getItemLogMaker().setType(4).addTaggedData(798, nv.rank).addTaggedData(1395, nv.count));
                EventLogTags.writeNotificationClicked(key, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now), nv.rank, nv.count);
                StatusBarNotification sbn = r.sbn;
                NotificationManagerService.this.cancelNotification(callingUid, callingPid, sbn.getPackageName(), sbn.getTag(), sbn.getId(), 16, 64, false, r.getUserId(), 1, nv.rank, nv.count, null);
                nv.recycle();
                NotificationManagerService.this.reportUserInteraction(r);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationActionClick(int callingUid, int callingPid, String key, int actionIndex, Notification.Action action, NotificationVisibility nv, boolean generatedByAssistant) {
            NotificationManagerService.this.exitIdle();
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r == null) {
                    Slog.w(NotificationManagerService.TAG, "No notification with key: " + key);
                    return;
                }
                long now = System.currentTimeMillis();
                MetricsLogger.action(r.getLogMaker(now).setCategory(129).setType(4).setSubtype(actionIndex).addTaggedData(798, nv.rank).addTaggedData(1395, nv.count).addTaggedData(1601, action.isContextual() ? 1 : 0).addTaggedData(1600, generatedByAssistant ? 1 : 0).addTaggedData(1629, nv.location.toMetricsEventEnum()));
                EventLogTags.writeNotificationActionClicked(key, actionIndex, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now), nv.rank, nv.count);
                nv.recycle();
                NotificationManagerService.this.reportUserInteraction(r);
                NotificationManagerService.this.mAssistants.notifyAssistantActionClicked(r.sbn, actionIndex, action, generatedByAssistant);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationClear(int callingUid, int callingPid, String pkg, String tag, int id2, int userId, String key, int dismissalSurface, int dismissalSentiment, NotificationVisibility nv) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.recordDismissalSurface(dismissalSurface);
                    r.recordDismissalSentiment(dismissalSentiment);
                }
            }
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 66, true, userId, 2, nv.rank, nv.count, null);
            nv.recycle();
        }

        @Override
        public void onPanelRevealed(boolean clearEffects, int items) {
            MetricsLogger.visible(NotificationManagerService.this.getContext(), 127);
            MetricsLogger.histogram(NotificationManagerService.this.getContext(), "note_load", items);
            EventLogTags.writeNotificationPanelRevealed(items);
            if (clearEffects) {
                this.clearEffects();
            }
        }

        @Override
        public void onPanelHidden() {
            MetricsLogger.hidden(NotificationManagerService.this.getContext(), 127);
            EventLogTags.writeNotificationPanelHidden();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearEffects() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "clearEffects");
                }
                NotificationManagerService.this.clearSoundLocked();
                NotificationManagerService.this.clearVibrateLocked();
                NotificationManagerService.this.clearLightsLocked();
            }
        }

        @Override
        public void onNotificationError(int callingUid, int callingPid, String pkg, String tag, int id2, int uid, int initialPid, String message, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 0, false, userId, 4, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationVisibilityChanged(NotificationVisibility[] newlyVisibleKeys, NotificationVisibility[] noLongerVisibleKeys) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r;
                for (NotificationVisibility nv : newlyVisibleKeys) {
                    boolean isHun;
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    if (!r.isSeen()) {
                        if (DBG) {
                            Slog.d(NotificationManagerService.TAG, "Marking notification as visible " + nv.key);
                        }
                        NotificationManagerService.this.reportSeen(r);
                    }
                    r.setVisibility(true, nv.rank, nv.count);
                    boolean bl = isHun = nv.location == NotificationVisibility.NotificationLocation.LOCATION_FIRST_HEADS_UP;
                    if (isHun || r.hasBeenVisiblyExpanded()) {
                        NotificationManagerService.this.logSmartSuggestionsVisible(r, nv.location.toMetricsEventEnum());
                    }
                    NotificationManagerService.this.maybeRecordInterruptionLocked(r);
                    nv.recycle();
                }
                for (NotificationVisibility nv : noLongerVisibleKeys) {
                    r = NotificationManagerService.this.mNotificationsByKey.get(nv.key);
                    if (r == null) continue;
                    r.setVisibility(false, nv.rank, nv.count);
                    nv.recycle();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationExpansionChanged(String key, boolean userAction, boolean expanded, int notificationLocation) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.stats.onExpansionChanged(userAction, expanded);
                    if (r.hasBeenVisiblyExpanded()) {
                        NotificationManagerService.this.logSmartSuggestionsVisible(r, notificationLocation);
                    }
                    if (userAction) {
                        MetricsLogger.action(r.getItemLogMaker().setType(expanded ? 3 : 14));
                    }
                    if (expanded && userAction) {
                        r.recordExpanded();
                        NotificationManagerService.this.reportUserInteraction(r);
                    }
                    NotificationManagerService.this.mAssistants.notifyAssistantExpansionChangedLocked(r.sbn, userAction, expanded);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationDirectReplied(String key) {
            NotificationManagerService.this.exitIdle();
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.recordDirectReplied();
                    NotificationManagerService.this.mMetricsLogger.write(r.getLogMaker().setCategory(1590).setType(4));
                    NotificationManagerService.this.reportUserInteraction(r);
                    NotificationManagerService.this.mAssistants.notifyAssistantNotificationDirectReplyLocked(r.sbn);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationSmartSuggestionsAdded(String key, int smartReplyCount, int smartActionCount, boolean generatedByAssistant, boolean editBeforeSending) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.setNumSmartRepliesAdded(smartReplyCount);
                    r.setNumSmartActionsAdded(smartActionCount);
                    r.setSuggestionsGeneratedByAssistant(generatedByAssistant);
                    r.setEditChoicesBeforeSending(editBeforeSending);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationSmartReplySent(String key, int replyIndex, CharSequence reply, int notificationLocation, boolean modifiedBeforeSending) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    LogMaker logMaker = r.getLogMaker().setCategory(1383).setSubtype(replyIndex).addTaggedData(1600, r.getSuggestionsGeneratedByAssistant() ? 1 : 0).addTaggedData(1629, notificationLocation).addTaggedData(1647, r.getEditChoicesBeforeSending() ? 1 : 0).addTaggedData(1648, modifiedBeforeSending ? 1 : 0);
                    NotificationManagerService.this.mMetricsLogger.write(logMaker);
                    NotificationManagerService.this.reportUserInteraction(r);
                    NotificationManagerService.this.mAssistants.notifyAssistantSuggestedReplySent(r.sbn, reply, r.getSuggestionsGeneratedByAssistant());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationSettingsViewed(String key) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    r.recordViewedSettings();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNotificationBubbleChanged(String key, boolean isBubble) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(key);
                if (r != null) {
                    StatusBarNotification n = r.sbn;
                    int callingUid = n.getUid();
                    String pkg = n.getPackageName();
                    r.getNotification().flags = isBubble && NotificationManagerService.this.isNotificationAppropriateToBubble(r, pkg, callingUid, null) ? (r.getNotification().flags |= 0x1000) : (r.getNotification().flags &= 0xFFFFEFFF);
                }
            }
        }
    };
    protected final BroadcastReceiver mLocaleChangeReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                SystemNotificationChannels.createAll(context);
                NotificationManagerService.this.mZenModeHelper.updateDefaultZenRules();
                NotificationManagerService.this.mPreferencesHelper.onLocaleChanged(context, ActivityManager.getCurrentUser());
            }
        }
    };
    private final BroadcastReceiver mRestoreReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.os.action.SETTING_RESTORED".equals(intent.getAction())) {
                try {
                    String element = intent.getStringExtra("setting_name");
                    String newValue = intent.getStringExtra("new_value");
                    int restoredFromSdkInt = intent.getIntExtra("restored_from_sdk_int", 0);
                    NotificationManagerService.this.mListeners.onSettingRestored(element, newValue, restoredFromSdkInt, this.getSendingUserId());
                    NotificationManagerService.this.mConditionProviders.onSettingRestored(element, newValue, restoredFromSdkInt, this.getSendingUserId());
                }
                catch (Exception e) {
                    Slog.wtf(NotificationManagerService.TAG, "Cannot restore managed services from settings", e);
                }
            }
        }
    };
    private final BroadcastReceiver mNotificationTimeoutReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (ACTION_NOTIFICATION_TIMEOUT.equals(action)) {
                NotificationRecord record;
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    record = NotificationManagerService.this.findNotificationByKeyLocked(intent.getStringExtra(NotificationManagerService.EXTRA_KEY));
                }
                if (record != null) {
                    NotificationManagerService.this.cancelNotification(record.sbn.getUid(), record.sbn.getInitialPid(), record.sbn.getPackageName(), record.sbn.getTag(), record.sbn.getId(), 0, 64, true, record.getUserId(), 19, null);
                }
            }
        }
    };
    private final BroadcastReceiver mPackageIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            boolean queryRestart = false;
            boolean queryRemove = false;
            boolean packageChanged = false;
            boolean cancelNotifications = true;
            boolean hideNotifications = false;
            boolean unhideNotifications = false;
            int reason = 5;
            if (action.equals("android.intent.action.PACKAGE_ADDED") || (queryRemove = action.equals("android.intent.action.PACKAGE_REMOVED")) || action.equals("android.intent.action.PACKAGE_RESTARTED") || (packageChanged = action.equals("android.intent.action.PACKAGE_CHANGED")) || (queryRestart = action.equals("android.intent.action.QUERY_PACKAGE_RESTART")) || action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE") || action.equals("android.intent.action.PACKAGES_SUSPENDED") || action.equals("android.intent.action.PACKAGES_UNSUSPENDED") || action.equals("android.intent.action.DISTRACTING_PACKAGES_CHANGED")) {
                boolean removingPackage;
                int changeUserId = intent.getIntExtra("android.intent.extra.user_handle", -1);
                String[] pkgList = null;
                int[] uidList = null;
                boolean bl = removingPackage = queryRemove && !intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if (DBG) {
                    Slog.i(NotificationManagerService.TAG, "action=" + action + " removing=" + removingPackage);
                }
                if (action.equals("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                } else if (action.equals("android.intent.action.PACKAGES_SUSPENDED")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                    cancelNotifications = false;
                    hideNotifications = true;
                } else if (action.equals("android.intent.action.PACKAGES_UNSUSPENDED")) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                    uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                    cancelNotifications = false;
                    unhideNotifications = true;
                } else if (action.equals("android.intent.action.DISTRACTING_PACKAGES_CHANGED")) {
                    int distractionRestrictions = intent.getIntExtra("android.intent.extra.distraction_restrictions", 0);
                    if ((distractionRestrictions & 2) != 0) {
                        pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                        uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                        cancelNotifications = false;
                        hideNotifications = true;
                    } else {
                        pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                        uidList = intent.getIntArrayExtra("android.intent.extra.changed_uid_list");
                        cancelNotifications = false;
                        unhideNotifications = true;
                    }
                } else if (queryRestart) {
                    pkgList = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                    uidList = new int[]{intent.getIntExtra("android.intent.extra.UID", -1)};
                } else {
                    Uri uri = intent.getData();
                    if (uri == null) {
                        return;
                    }
                    String pkgName = uri.getSchemeSpecificPart();
                    if (pkgName == null) {
                        return;
                    }
                    if (packageChanged) {
                        try {
                            int enabled = NotificationManagerService.this.mPackageManager.getApplicationEnabledSetting(pkgName, changeUserId != -1 ? changeUserId : 0);
                            if (enabled == 1 || enabled == 0) {
                                cancelNotifications = false;
                            }
                        }
                        catch (IllegalArgumentException e) {
                            if (DBG) {
                                Slog.i(NotificationManagerService.TAG, "Exception trying to look up app enabled setting", e);
                            }
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    pkgList = new String[]{pkgName};
                    uidList = new int[]{intent.getIntExtra("android.intent.extra.UID", -1)};
                }
                if (pkgList != null && pkgList.length > 0) {
                    for (String pkgName : pkgList) {
                        if (cancelNotifications) {
                            NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkgName, null, 0, 0, !queryRestart, changeUserId, reason, null);
                            continue;
                        }
                        if (hideNotifications) {
                            NotificationManagerService.this.hideNotificationsForPackages(pkgList);
                            continue;
                        }
                        if (!unhideNotifications) continue;
                        NotificationManagerService.this.unhideNotificationsForPackages(pkgList);
                    }
                }
                NotificationManagerService.this.mHandler.scheduleOnPackageChanged(removingPackage, changeUserId, pkgList, uidList);
            }
        }
    };
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.SCREEN_ON")) {
                NotificationManagerService.this.mScreenOn = true;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.SCREEN_OFF")) {
                NotificationManagerService.this.mScreenOn = false;
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.PHONE_STATE")) {
                NotificationManagerService.this.mInCall = TelephonyManager.EXTRA_STATE_OFFHOOK.equals(intent.getStringExtra("state"));
                NotificationManagerService.this.updateNotificationPulse();
            } else if (action.equals("android.intent.action.USER_STOPPED")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, null, 0, 0, true, userHandle, 6, null);
                }
            } else if (action.equals("android.intent.action.MANAGED_PROFILE_UNAVAILABLE")) {
                int userHandle = intent.getIntExtra("android.intent.extra.user_handle", -1);
                if (userHandle >= 0) {
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, null, null, 0, 0, true, userHandle, 15, null);
                }
            } else if (action.equals("android.intent.action.USER_PRESENT")) {
                NotificationManagerService.this.mNotificationLight.turnOff();
            } else if (action.equals("android.intent.action.USER_SWITCHED")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mUserProfiles.updateCache(context);
                if (!NotificationManagerService.this.mUserProfiles.isManagedProfile(userId)) {
                    NotificationManagerService.this.mSettingsObserver.update(null);
                    NotificationManagerService.this.mConditionProviders.onUserSwitched(userId);
                    NotificationManagerService.this.mListeners.onUserSwitched(userId);
                    NotificationManagerService.this.mZenModeHelper.onUserSwitched(userId);
                    NotificationManagerService.this.mPreferencesHelper.onUserSwitched(userId);
                }
                NotificationManagerService.this.mAssistants.onUserSwitched(userId);
            } else if (action.equals("android.intent.action.USER_ADDED")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                if (userId != -10000) {
                    NotificationManagerService.this.mUserProfiles.updateCache(context);
                    if (!NotificationManagerService.this.mUserProfiles.isManagedProfile(userId)) {
                        NotificationManagerService.this.readDefaultApprovedServices(userId);
                    }
                }
            } else if (action.equals("android.intent.action.USER_REMOVED")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mUserProfiles.updateCache(context);
                NotificationManagerService.this.mZenModeHelper.onUserRemoved(userId);
                NotificationManagerService.this.mPreferencesHelper.onUserRemoved(userId);
                NotificationManagerService.this.mListeners.onUserRemoved(userId);
                NotificationManagerService.this.mConditionProviders.onUserRemoved(userId);
                NotificationManagerService.this.mAssistants.onUserRemoved(userId);
                NotificationManagerService.this.handleSavePolicyFile();
            } else if (action.equals("android.intent.action.USER_UNLOCKED")) {
                int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                NotificationManagerService.this.mUserProfiles.updateCache(context);
                NotificationManagerService.this.mAssistants.onUserUnlocked(userId);
                if (!NotificationManagerService.this.mUserProfiles.isManagedProfile(userId)) {
                    NotificationManagerService.this.mConditionProviders.onUserUnlocked(userId);
                    NotificationManagerService.this.mListeners.onUserUnlocked(userId);
                    NotificationManagerService.this.mZenModeHelper.onUserUnlocked(userId);
                    NotificationManagerService.this.mPreferencesHelper.onUserUnlocked(userId);
                }
            }
        }
    };
    private SettingsObserver mSettingsObserver;
    protected ZenModeHelper mZenModeHelper;
    @VisibleForTesting
    final IBinder mService = new INotificationManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enqueueToast(String pkg, ITransientNotification callback, int duration, int displayId) {
            if (DBG) {
                Slog.i(NotificationManagerService.TAG, "enqueueToast pkg=" + pkg + " callback=" + callback + " duration=" + duration + " displayId=" + displayId);
            }
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not enqueuing toast. pkg=" + pkg + " callback=" + callback);
                return;
            }
            int callingUid = Binder.getCallingUid();
            boolean isSystemToast = NotificationManagerService.this.isCallerSystemOrPhone() || "android".equals(pkg);
            boolean isPackageSuspended = NotificationManagerService.this.isPackageSuspendedForUser(pkg, callingUid);
            boolean notificationsDisabledForPackage = !this.areNotificationsEnabledForPackage(pkg, callingUid);
            long callingIdentity = Binder.clearCallingIdentity();
            try {
                boolean appIsForeground;
                boolean bl = appIsForeground = NotificationManagerService.this.mActivityManager.getUidImportance(callingUid) == 100;
                if (!isSystemToast && (notificationsDisabledForPackage && !appIsForeground || isPackageSuspended)) {
                    Slog.e(NotificationManagerService.TAG, "Suppressing toast from package " + pkg + (isPackageSuspended ? " due to package suspended." : " by user request."));
                    return;
                }
            }
            finally {
                Binder.restoreCallingIdentity(callingIdentity);
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                int callingPid = Binder.getCallingPid();
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        ToastRecord record = NotificationManagerService.this.mToastQueue.get(index);
                        record.update(duration);
                    } else {
                        if (!isSystemToast) {
                            int count = 0;
                            int N = NotificationManagerService.this.mToastQueue.size();
                            for (int i = 0; i < N; ++i) {
                                ToastRecord r = NotificationManagerService.this.mToastQueue.get(i);
                                if (!r.pkg.equals(pkg) || ++count < 25) continue;
                                Slog.e(NotificationManagerService.TAG, "Package has already posted " + count + " toasts. Not showing more. Package=" + pkg);
                                return;
                            }
                        }
                        Binder token = new Binder();
                        NotificationManagerService.this.mWindowManagerInternal.addWindowToken(token, 2005, displayId);
                        ToastRecord record = new ToastRecord(callingPid, pkg, callback, duration, token, displayId);
                        NotificationManagerService.this.mToastQueue.add(record);
                        index = NotificationManagerService.this.mToastQueue.size() - 1;
                        NotificationManagerService.this.keepProcessAliveIfNeededLocked(callingPid);
                    }
                    if (index == 0) {
                        NotificationManagerService.this.showNextToastLocked();
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelToast(String pkg, ITransientNotification callback) {
            Slog.i(NotificationManagerService.TAG, "cancelToast pkg=" + pkg + " callback=" + callback);
            if (pkg == null || callback == null) {
                Slog.e(NotificationManagerService.TAG, "Not cancelling notification. pkg=" + pkg + " callback=" + callback);
                return;
            }
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        NotificationManagerService.this.cancelToastLocked(index);
                    } else {
                        Slog.w(NotificationManagerService.TAG, "Toast already cancelled. pkg=" + pkg + " callback=" + callback);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishToken(String pkg, ITransientNotification callback) {
            ArrayList<ToastRecord> arrayList = NotificationManagerService.this.mToastQueue;
            synchronized (arrayList) {
                long callingId = Binder.clearCallingIdentity();
                try {
                    int index = NotificationManagerService.this.indexOfToastLocked(pkg, callback);
                    if (index >= 0) {
                        ToastRecord record = NotificationManagerService.this.mToastQueue.get(index);
                        NotificationManagerService.this.finishTokenLocked(record.token, record.displayId);
                    } else {
                        Slog.w(NotificationManagerService.TAG, "Toast already killed. pkg=" + pkg + " callback=" + callback);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(callingId);
                }
            }
        }

        @Override
        public void enqueueNotificationWithTag(String pkg, String opPkg, String tag, int id2, Notification notification, int userId) throws RemoteException {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, Binder.getCallingUid(), Binder.getCallingPid(), tag, id2, notification, userId);
        }

        @Override
        public void cancelNotificationWithTag(String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelNotificationWithTag", pkg);
            int mustNotHaveFlags = NotificationManagerService.this.isCallingUidSystem() ? 0 : 1088;
            NotificationManagerService.this.cancelNotification(Binder.getCallingUid(), Binder.getCallingPid(), pkg, tag, id2, 0, mustNotHaveFlags, false, userId, 8, null);
        }

        @Override
        public void cancelAllNotifications(String pkg, int userId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, false, "cancelAllNotifications", pkg);
            NotificationManagerService.this.cancelAllNotificationsInt(Binder.getCallingUid(), Binder.getCallingPid(), pkg, null, 0, 64, true, userId, 9, null);
        }

        @Override
        public void setNotificationsEnabledForPackage(String pkg, int uid, boolean enabled) {
            this.enforceSystemOrSystemUI("setNotificationsEnabledForPackage");
            NotificationManagerService.this.mPreferencesHelper.setEnabled(pkg, uid, enabled);
            NotificationManagerService.this.mMetricsLogger.write(new LogMaker(147).setType(4).setPackageName(pkg).setSubtype(enabled ? 1 : 0));
            if (!enabled) {
                NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, null, 0, 0, true, UserHandle.getUserId(uid), 7, null);
            }
            try {
                NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.APP_BLOCK_STATE_CHANGED").putExtra("android.app.extra.BLOCKED_STATE", !enabled).addFlags(0x10000000).setPackage(pkg), UserHandle.of(UserHandle.getUserId(uid)), null);
            }
            catch (SecurityException e) {
                Slog.w(NotificationManagerService.TAG, "Can't notify app about app block change", e);
            }
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public void setNotificationsEnabledWithImportanceLockForPackage(String pkg, int uid, boolean enabled) {
            this.setNotificationsEnabledForPackage(pkg, uid, enabled);
            NotificationManagerService.this.mPreferencesHelper.setAppImportanceLocked(pkg, uid);
        }

        @Override
        public boolean areNotificationsEnabled(String pkg) {
            return this.areNotificationsEnabledForPackage(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean areNotificationsEnabledForPackage(String pkg, int uid) {
            this.enforceSystemOrSystemUIOrSamePackage(pkg, "Caller not system or systemui or same package");
            if (UserHandle.getCallingUserId() != UserHandle.getUserId(uid)) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS", "canNotifyAsPackage for uid " + uid);
            }
            return NotificationManagerService.this.mPreferencesHelper.getImportance(pkg, uid) != 0;
        }

        @Override
        public boolean areBubblesAllowed(String pkg) {
            return this.areBubblesAllowedForPackage(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean areBubblesAllowedForPackage(String pkg, int uid) {
            this.enforceSystemOrSystemUIOrSamePackage(pkg, "Caller not system or systemui or same package");
            if (UserHandle.getCallingUserId() != UserHandle.getUserId(uid)) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS", "canNotifyAsPackage for uid " + uid);
            }
            return NotificationManagerService.this.mPreferencesHelper.areBubblesAllowed(pkg, uid);
        }

        @Override
        public void setBubblesAllowed(String pkg, int uid, boolean allowed) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            NotificationManagerService.this.mPreferencesHelper.setBubblesAllowed(pkg, uid, allowed);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public boolean hasUserApprovedBubblesForPackage(String pkg, int uid) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            int lockedFields = NotificationManagerService.this.mPreferencesHelper.getAppLockedFields(pkg, uid);
            return (lockedFields & 2) != 0;
        }

        @Override
        public boolean shouldHideSilentStatusIcons(String callingPkg) {
            NotificationManagerService.this.checkCallerIsSameApp(callingPkg);
            if (NotificationManagerService.this.isCallerSystemOrPhone() || NotificationManagerService.this.mListeners.isListenerPackage(callingPkg)) {
                return NotificationManagerService.this.mPreferencesHelper.shouldHideSilentStatusIcons();
            }
            throw new SecurityException("Only available for notification listeners");
        }

        @Override
        public void setHideSilentStatusIcons(boolean hide) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mPreferencesHelper.setHideSilentStatusIcons(hide);
            NotificationManagerService.this.handleSavePolicyFile();
            NotificationManagerService.this.mListeners.onStatusBarIconsBehaviorChanged(hide);
        }

        @Override
        public int getPackageImportance(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mPreferencesHelper.getImportance(pkg, Binder.getCallingUid());
        }

        @Override
        public boolean canShowBadge(String pkg, int uid) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mPreferencesHelper.canShowBadge(pkg, uid);
        }

        @Override
        public void setShowBadge(String pkg, int uid, boolean showBadge) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mPreferencesHelper.setShowBadge(pkg, uid, showBadge);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public void setNotificationDelegate(String callingPkg, String delegate) {
            NotificationManagerService.this.checkCallerIsSameApp(callingPkg);
            int callingUid = Binder.getCallingUid();
            UserHandle user = UserHandle.getUserHandleForUid(callingUid);
            if (delegate == null) {
                NotificationManagerService.this.mPreferencesHelper.revokeNotificationDelegate(callingPkg, Binder.getCallingUid());
                NotificationManagerService.this.handleSavePolicyFile();
            } else {
                try {
                    ApplicationInfo info = NotificationManagerService.this.mPackageManager.getApplicationInfo(delegate, 786432, user.getIdentifier());
                    if (info != null) {
                        NotificationManagerService.this.mPreferencesHelper.setNotificationDelegate(callingPkg, callingUid, delegate, info.uid);
                        NotificationManagerService.this.handleSavePolicyFile();
                    }
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }

        @Override
        public String getNotificationDelegate(String callingPkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(callingPkg);
            return NotificationManagerService.this.mPreferencesHelper.getNotificationDelegate(callingPkg, Binder.getCallingUid());
        }

        @Override
        public boolean canNotifyAsPackage(String callingPkg, String targetPkg, int userId) {
            NotificationManagerService.this.checkCallerIsSameApp(callingPkg);
            int callingUid = Binder.getCallingUid();
            UserHandle user = UserHandle.getUserHandleForUid(callingUid);
            if (user.getIdentifier() != userId) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS", "canNotifyAsPackage for user " + userId);
            }
            if (callingPkg.equals(targetPkg)) {
                return true;
            }
            try {
                ApplicationInfo info = NotificationManagerService.this.mPackageManager.getApplicationInfo(targetPkg, 786432, userId);
                if (info != null) {
                    return NotificationManagerService.this.mPreferencesHelper.isDelegateAllowed(targetPkg, info.uid, callingPkg, callingUid);
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            return false;
        }

        @Override
        public void updateNotificationChannelGroupForPackage(String pkg, int uid, NotificationChannelGroup group) throws RemoteException {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            NotificationManagerService.this.createNotificationChannelGroup(pkg, uid, group, false, false);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public void createNotificationChannelGroups(String pkg, ParceledListSlice channelGroupList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            List groups = channelGroupList.getList();
            int groupSize = groups.size();
            for (int i = 0; i < groupSize; ++i) {
                NotificationChannelGroup group = (NotificationChannelGroup)groups.get(i);
                NotificationManagerService.this.createNotificationChannelGroup(pkg, Binder.getCallingUid(), group, true, false);
            }
            NotificationManagerService.this.handleSavePolicyFile();
        }

        private void createNotificationChannelsImpl(String pkg, int uid, ParceledListSlice channelsList) {
            List channels = channelsList.getList();
            int channelsSize = channels.size();
            boolean needsPolicyFileChange = false;
            for (int i = 0; i < channelsSize; ++i) {
                NotificationChannel channel = (NotificationChannel)channels.get(i);
                Preconditions.checkNotNull(channel, "channel in list is null");
                needsPolicyFileChange = NotificationManagerService.this.mPreferencesHelper.createNotificationChannel(pkg, uid, channel, true, NotificationManagerService.this.mConditionProviders.isPackageOrComponentAllowed(pkg, UserHandle.getUserId(uid)));
                if (!needsPolicyFileChange) continue;
                NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(uid), NotificationManagerService.this.mPreferencesHelper.getNotificationChannel(pkg, uid, channel.getId(), false), 1);
            }
            if (needsPolicyFileChange) {
                NotificationManagerService.this.handleSavePolicyFile();
            }
        }

        @Override
        public void createNotificationChannels(String pkg, ParceledListSlice channelsList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            this.createNotificationChannelsImpl(pkg, Binder.getCallingUid(), channelsList);
        }

        @Override
        public void createNotificationChannelsForPackage(String pkg, int uid, ParceledListSlice channelsList) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystem();
            this.createNotificationChannelsImpl(pkg, uid, channelsList);
        }

        @Override
        public NotificationChannel getNotificationChannel(String callingPkg, int userId, String targetPkg, String channelId) {
            if (this.canNotifyAsPackage(callingPkg, targetPkg, userId) || NotificationManagerService.this.isCallingUidSystem()) {
                int targetUid = -1;
                try {
                    targetUid = NotificationManagerService.this.mPackageManagerClient.getPackageUidAsUser(targetPkg, userId);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                return NotificationManagerService.this.mPreferencesHelper.getNotificationChannel(targetPkg, targetUid, channelId, false);
            }
            throw new SecurityException("Pkg " + callingPkg + " cannot read channels for " + targetPkg + " in " + userId);
        }

        @Override
        public NotificationChannel getNotificationChannelForPackage(String pkg, int uid, String channelId, boolean includeDeleted) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannel(pkg, uid, channelId, includeDeleted);
        }

        @Override
        public void deleteNotificationChannel(String pkg, String channelId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int callingUid = Binder.getCallingUid();
            if ("miscellaneous".equals(channelId)) {
                throw new IllegalArgumentException("Cannot delete default channel");
            }
            NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channelId, 0, 0, true, UserHandle.getUserId(callingUid), 17, null);
            NotificationManagerService.this.mPreferencesHelper.deleteNotificationChannel(pkg, callingUid, channelId);
            NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(callingUid), NotificationManagerService.this.mPreferencesHelper.getNotificationChannel(pkg, callingUid, channelId, true), 3);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public NotificationChannelGroup getNotificationChannelGroup(String pkg, String groupId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroupWithChannels(pkg, Binder.getCallingUid(), groupId, false);
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroups(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroups(pkg, Binder.getCallingUid(), false, false, true);
        }

        @Override
        public void deleteNotificationChannelGroup(String pkg, String groupId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int callingUid = Binder.getCallingUid();
            NotificationChannelGroup groupToDelete = NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroup(groupId, pkg, callingUid);
            if (groupToDelete != null) {
                List<NotificationChannel> deletedChannels = NotificationManagerService.this.mPreferencesHelper.deleteNotificationChannelGroup(pkg, callingUid, groupId);
                for (int i = 0; i < deletedChannels.size(); ++i) {
                    NotificationChannel deletedChannel = deletedChannels.get(i);
                    NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, deletedChannel.getId(), 0, 0, true, UserHandle.getUserId(Binder.getCallingUid()), 17, null);
                    NotificationManagerService.this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(callingUid), deletedChannel, 3);
                }
                NotificationManagerService.this.mListeners.notifyNotificationChannelGroupChanged(pkg, UserHandle.getUserHandleForUid(callingUid), groupToDelete, 3);
                NotificationManagerService.this.handleSavePolicyFile();
            }
        }

        @Override
        public void updateNotificationChannelForPackage(String pkg, int uid, NotificationChannel channel) {
            this.enforceSystemOrSystemUI("Caller not system or systemui");
            Preconditions.checkNotNull(channel);
            NotificationManagerService.this.updateNotificationChannelInt(pkg, uid, channel, false);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getNotificationChannelsForPackage");
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannels(pkg, uid, includeDeleted);
        }

        @Override
        public int getNumNotificationChannelsForPackage(String pkg, int uid, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getNumNotificationChannelsForPackage");
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannels(pkg, uid, includeDeleted).getList().size();
        }

        @Override
        public boolean onlyHasDefaultChannel(String pkg, int uid) {
            this.enforceSystemOrSystemUI("onlyHasDefaultChannel");
            return NotificationManagerService.this.mPreferencesHelper.onlyHasDefaultChannel(pkg, uid);
        }

        @Override
        public int getDeletedChannelCount(String pkg, int uid) {
            this.enforceSystemOrSystemUI("getDeletedChannelCount");
            return NotificationManagerService.this.mPreferencesHelper.getDeletedChannelCount(pkg, uid);
        }

        @Override
        public int getBlockedChannelCount(String pkg, int uid) {
            this.enforceSystemOrSystemUI("getBlockedChannelCount");
            return NotificationManagerService.this.mPreferencesHelper.getBlockedChannelCount(pkg, uid);
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsForPackage(String pkg, int uid, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getNotificationChannelGroupsForPackage");
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroups(pkg, uid, includeDeleted, true, false);
        }

        @Override
        public NotificationChannelGroup getPopulatedNotificationChannelGroupForPackage(String pkg, int uid, String groupId, boolean includeDeleted) {
            this.enforceSystemOrSystemUI("getPopulatedNotificationChannelGroupForPackage");
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroupWithChannels(pkg, uid, groupId, includeDeleted);
        }

        @Override
        public NotificationChannelGroup getNotificationChannelGroupForPackage(String groupId, String pkg, int uid) {
            this.enforceSystemOrSystemUI("getNotificationChannelGroupForPackage");
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroup(groupId, pkg, uid);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannels(String callingPkg, String targetPkg, int userId) {
            if (this.canNotifyAsPackage(callingPkg, targetPkg, userId) || NotificationManagerService.this.isCallingUidSystem()) {
                int targetUid = -1;
                try {
                    targetUid = NotificationManagerService.this.mPackageManagerClient.getPackageUidAsUser(targetPkg, userId);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                return NotificationManagerService.this.mPreferencesHelper.getNotificationChannels(targetPkg, targetUid, false);
            }
            throw new SecurityException("Pkg " + callingPkg + " cannot read channels for " + targetPkg + " in " + userId);
        }

        @Override
        public int getBlockedAppCount(int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mPreferencesHelper.getBlockedAppCount(userId);
        }

        @Override
        public int getAppsBypassingDndCount(int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mPreferencesHelper.getAppsBypassingDndCount(userId);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannelsBypassingDnd(String pkg, int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannelsBypassingDnd(pkg, userId);
        }

        @Override
        public boolean areChannelsBypassingDnd() {
            return NotificationManagerService.this.mPreferencesHelper.areChannelsBypassingDnd();
        }

        @Override
        public void clearData(String packageName, int uid, boolean fromApp) throws RemoteException {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.cancelAllNotificationsInt(MY_UID, MY_PID, packageName, null, 0, 0, true, UserHandle.getUserId(Binder.getCallingUid()), 17, null);
            String[] packages = new String[]{packageName};
            int[] uids = new int[]{uid};
            NotificationManagerService.this.mListeners.onPackagesChanged(true, packages, uids);
            NotificationManagerService.this.mAssistants.onPackagesChanged(true, packages, uids);
            NotificationManagerService.this.mConditionProviders.onPackagesChanged(true, packages, uids);
            NotificationManagerService.this.mSnoozeHelper.clearData(UserHandle.getUserId(uid), packageName);
            if (!fromApp) {
                NotificationManagerService.this.mPreferencesHelper.clearData(packageName, uid);
            }
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public List<String> getAllowedAssistantAdjustments(String pkg) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            if (!NotificationManagerService.this.isCallerSystemOrPhone() && !NotificationManagerService.this.mAssistants.isPackageAllowed(pkg, UserHandle.getCallingUserId())) {
                throw new SecurityException("Not currently an assistant");
            }
            return NotificationManagerService.this.mAssistants.getAllowedAssistantAdjustments();
        }

        @Override
        public void allowAssistantAdjustment(String adjustmentType) {
            NotificationManagerService.this.checkCallerIsSystemOrSystemUiOrShell();
            NotificationManagerService.this.mAssistants.allowAdjustmentType(adjustmentType);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public void disallowAssistantAdjustment(String adjustmentType) {
            NotificationManagerService.this.checkCallerIsSystemOrSystemUiOrShell();
            NotificationManagerService.this.mAssistants.disallowAdjustmentType(adjustmentType);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getActiveNotifications(String callingPkg) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getActiveNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    tmp = new StatusBarNotification[NotificationManagerService.this.mNotificationList.size()];
                    int N = NotificationManagerService.this.mNotificationList.size();
                    for (int i = 0; i < N; ++i) {
                        tmp[i] = NotificationManagerService.this.mNotificationList.get((int)i).sbn;
                    }
                }
            }
            return tmp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getAppActiveNotifications(String pkg, int incomingUserId) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            int userId = ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), incomingUserId, true, false, "getAppActiveNotifications", pkg);
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                StatusBarNotification sbn;
                ArrayMap<String, StatusBarNotification> map = new ArrayMap<String, StatusBarNotification>(NotificationManagerService.this.mNotificationList.size() + NotificationManagerService.this.mEnqueuedNotifications.size());
                int N = NotificationManagerService.this.mNotificationList.size();
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn2 = this.sanitizeSbn(pkg, userId, NotificationManagerService.this.mNotificationList.get((int)i).sbn);
                    if (sbn2 == null) continue;
                    map.put(sbn2.getKey(), sbn2);
                }
                for (NotificationRecord snoozed : NotificationManagerService.this.mSnoozeHelper.getSnoozed(userId, pkg)) {
                    sbn = this.sanitizeSbn(pkg, userId, snoozed.sbn);
                    if (sbn == null) continue;
                    map.put(sbn.getKey(), sbn);
                }
                int M = NotificationManagerService.this.mEnqueuedNotifications.size();
                for (int i = 0; i < M; ++i) {
                    sbn = this.sanitizeSbn(pkg, userId, NotificationManagerService.this.mEnqueuedNotifications.get((int)i).sbn);
                    if (sbn == null) continue;
                    map.put(sbn.getKey(), sbn);
                }
                ArrayList list = new ArrayList(map.size());
                list.addAll(map.values());
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        private StatusBarNotification sanitizeSbn(String pkg, int userId, StatusBarNotification sbn) {
            if (sbn.getUserId() == userId && (sbn.getPackageName().equals(pkg) || sbn.getOpPkg().equals(pkg))) {
                return new StatusBarNotification(sbn.getPackageName(), sbn.getOpPkg(), sbn.getId(), sbn.getTag(), sbn.getUid(), sbn.getInitialPid(), sbn.getNotification().clone(), sbn.getUser(), sbn.getOverrideGroupKey(), sbn.getPostTime());
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StatusBarNotification[] getHistoricalNotifications(String callingPkg, int count) {
            NotificationManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.ACCESS_NOTIFICATIONS", "NotificationManagerService.getHistoricalNotifications");
            StatusBarNotification[] tmp = null;
            int uid = Binder.getCallingUid();
            if (NotificationManagerService.this.mAppOps.noteOpNoThrow(25, uid, callingPkg) == 0) {
                Archive archive = NotificationManagerService.this.mArchive;
                synchronized (archive) {
                    tmp = NotificationManagerService.this.mArchive.getArray(count);
                }
            }
            return tmp;
        }

        @Override
        public void registerListener(INotificationListener listener, ComponentName component, int userid) {
            this.enforceSystemOrSystemUI("INotificationManager.registerListener");
            NotificationManagerService.this.mListeners.registerService(listener, component, userid);
        }

        @Override
        public void unregisterListener(INotificationListener token, int userid) {
            NotificationManagerService.this.mListeners.unregisterService(token, userid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationsFromListener(INotificationListener token, String[] keys) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (keys != null) {
                        int N = keys.length;
                        for (int i = 0; i < N; ++i) {
                            NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                            if (r == null) continue;
                            int userId = r.sbn.getUserId();
                            if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                                throw new SecurityException("Disallowed call from listener: " + info.service);
                            }
                            this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, r.sbn.getPackageName(), r.sbn.getTag(), r.sbn.getId(), userId);
                        }
                    } else {
                        NotificationManagerService.this.cancelAllLocked(callingUid, callingPid, info.userid, 11, info, info.supportsProfiles());
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestBindListener(ComponentName component) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(component.getPackageName());
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices manager = NotificationManagerService.this.mAssistants.isComponentEnabledForCurrentProfiles(component) ? NotificationManagerService.this.mAssistants : NotificationManagerService.this.mListeners;
                manager.setComponentState(component, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnbindListener(INotificationListener token) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    info.getOwner().setComponentState(info.component, false);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationsShownFromListener(INotificationListener token, String[] keys) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info;
                    block12: {
                        info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                        if (keys != null) break block12;
                        return;
                    }
                    ArrayList<NotificationRecord> seen = new ArrayList<NotificationRecord>();
                    int n = keys.length;
                    for (int i = 0; i < n; ++i) {
                        NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(keys[i]);
                        if (r == null) continue;
                        int userId = r.sbn.getUserId();
                        if (userId != info.userid && userId != -1 && !NotificationManagerService.this.mUserProfiles.isCurrentProfile(userId)) {
                            throw new SecurityException("Disallowed call from listener: " + info.service);
                        }
                        seen.add(r);
                        if (r.isSeen()) continue;
                        if (DBG) {
                            Slog.d(NotificationManagerService.TAG, "Marking notification as seen " + keys[i]);
                        }
                        NotificationManagerService.this.reportSeen(r);
                        r.setSeen();
                        NotificationManagerService.this.maybeRecordInterruptionLocked(r);
                    }
                    if (!seen.isEmpty()) {
                        NotificationManagerService.this.mAssistants.onNotificationsSeenLocked(seen);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        private void cancelNotificationFromListenerLocked(ManagedServices.ManagedServiceInfo info, int callingUid, int callingPid, String pkg, String tag, int id2, int userId) {
            NotificationManagerService.this.cancelNotification(callingUid, callingPid, pkg, tag, id2, 0, 4162, true, userId, 10, info);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snoozeNotificationUntilContextFromListener(INotificationListener token, String key, String snoozeCriterionId) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.snoozeNotificationInt(key, -1L, snoozeCriterionId, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snoozeNotificationUntilFromListener(INotificationListener token, String key, long duration) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.snoozeNotificationInt(key, duration, null, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unsnoozeNotificationFromAssistant(INotificationListener token, String key) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    NotificationManagerService.this.unsnoozeNotificationInt(key, info);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancelNotificationFromListener(INotificationListener token, String pkg, String tag, int id2) {
            int callingUid = Binder.getCallingUid();
            int callingPid = Binder.getCallingPid();
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    if (info.supportsProfiles()) {
                        Slog.e(NotificationManagerService.TAG, "Ignoring deprecated cancelNotification(pkg, tag, id) from " + info.component + " use cancelNotification(key) instead.");
                    } else {
                        this.cancelNotificationFromListenerLocked(info, callingUid, callingPid, pkg, tag, id2, info.userid);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getActiveNotificationsFromListener(INotificationListener token, String[] keys, int trim) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                boolean getKeys = keys != null;
                int N = getKeys ? keys.length : NotificationManagerService.this.mNotificationList.size();
                ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(N);
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn;
                    NotificationRecord r;
                    NotificationRecord notificationRecord = r = getKeys ? NotificationManagerService.this.mNotificationsByKey.get(keys[i]) : NotificationManagerService.this.mNotificationList.get(i);
                    if (r == null || !NotificationManagerService.this.isVisibleToListener(sbn = r.sbn, info)) continue;
                    StatusBarNotification sbnToSend = trim == 0 ? sbn : sbn.cloneLight();
                    list.add(sbnToSend);
                }
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<StatusBarNotification> getSnoozedNotificationsFromListener(INotificationListener token, int trim) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                List<NotificationRecord> snoozedRecords = NotificationManagerService.this.mSnoozeHelper.getSnoozed();
                int N = snoozedRecords.size();
                ArrayList<StatusBarNotification> list = new ArrayList<StatusBarNotification>(N);
                for (int i = 0; i < N; ++i) {
                    StatusBarNotification sbn;
                    NotificationRecord r = snoozedRecords.get(i);
                    if (r == null || !NotificationManagerService.this.isVisibleToListener(sbn = r.sbn, info)) continue;
                    StatusBarNotification sbnToSend = trim == 0 ? sbn : sbn.cloneLight();
                    list.add(sbnToSend);
                }
                return new ParceledListSlice<StatusBarNotification>(list);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clearRequestedListenerHints(INotificationListener token) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.removeDisabledHints(info);
                    NotificationManagerService.this.updateListenerHintsLocked();
                    NotificationManagerService.this.updateEffectsSuppressorLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestHintsFromListener(INotificationListener token, int hints) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    boolean disableEffects;
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    int disableEffectsMask = 7;
                    boolean bl = disableEffects = (hints & 7) != 0;
                    if (disableEffects) {
                        NotificationManagerService.this.addDisabledHints(info, hints);
                    } else {
                        NotificationManagerService.this.removeDisabledHints(info, hints);
                    }
                    NotificationManagerService.this.updateListenerHintsLocked();
                    NotificationManagerService.this.updateEffectsSuppressorLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getHintsFromListener(INotificationListener token) {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                return NotificationManagerService.this.mListenerHints;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestInterruptionFilterFromListener(INotificationListener token, int interruptionFilter) throws RemoteException {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                    NotificationManagerService.this.mZenModeHelper.requestFromListener(info.component, interruptionFilter);
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getInterruptionFilterFromListener(INotificationListener token) throws RemoteException {
            Light light = NotificationManagerService.this.mNotificationLight;
            synchronized (light) {
                return NotificationManagerService.this.mInterruptionFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOnNotificationPostedTrimFromListener(INotificationListener token, int trim) throws RemoteException {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
                if (info == null) {
                    return;
                }
                NotificationManagerService.this.mListeners.setOnNotificationPostedTrimLocked(info, trim);
            }
        }

        @Override
        public int getZenMode() {
            return NotificationManagerService.this.mZenModeHelper.getZenMode();
        }

        @Override
        public ZenModeConfig getZenModeConfig() {
            this.enforceSystemOrSystemUI("INotificationManager.getZenModeConfig");
            return NotificationManagerService.this.mZenModeHelper.getConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setZenMode(int mode, Uri conditionId, String reason) throws RemoteException {
            this.enforceSystemOrSystemUI("INotificationManager.setZenMode");
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(mode, conditionId, null, reason);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public List<ZenModeConfig.ZenRule> getZenRules() throws RemoteException {
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.getZenRules();
        }

        @Override
        public AutomaticZenRule getAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "getAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.getAutomaticZenRule(id2);
        }

        @Override
        public String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            if (automaticZenRule.getOwner() == null && automaticZenRule.getConfigurationActivity() == null) {
                throw new NullPointerException("Rule must have a conditionproviderservice and/or configuration activity");
            }
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            if (automaticZenRule.getZenPolicy() != null && automaticZenRule.getInterruptionFilter() != 2) {
                throw new IllegalArgumentException("ZenPolicy is only applicable to INTERRUPTION_FILTER_PRIORITY filters");
            }
            this.enforcePolicyAccess(Binder.getCallingUid(), "addAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.addAutomaticZenRule(automaticZenRule, "addAutomaticZenRule");
        }

        @Override
        public boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) throws RemoteException {
            Preconditions.checkNotNull(automaticZenRule, "automaticZenRule is null");
            Preconditions.checkNotNull(automaticZenRule.getName(), "Name is null");
            if (automaticZenRule.getOwner() == null && automaticZenRule.getConfigurationActivity() == null) {
                throw new NullPointerException("Rule must have a conditionproviderservice and/or configuration activity");
            }
            Preconditions.checkNotNull(automaticZenRule.getConditionId(), "ConditionId is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "updateAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.updateAutomaticZenRule(id2, automaticZenRule, "updateAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRule(String id2) throws RemoteException {
            Preconditions.checkNotNull(id2, "Id is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "removeAutomaticZenRule");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRule(id2, "removeAutomaticZenRule");
        }

        @Override
        public boolean removeAutomaticZenRules(String packageName) throws RemoteException {
            Preconditions.checkNotNull(packageName, "Package name is null");
            this.enforceSystemOrSystemUI("removeAutomaticZenRules");
            return NotificationManagerService.this.mZenModeHelper.removeAutomaticZenRules(packageName, "removeAutomaticZenRules");
        }

        @Override
        public int getRuleInstanceCount(ComponentName owner) throws RemoteException {
            Preconditions.checkNotNull(owner, "Owner is null");
            this.enforceSystemOrSystemUI("getRuleInstanceCount");
            return NotificationManagerService.this.mZenModeHelper.getCurrentInstanceCount(owner);
        }

        @Override
        public void setAutomaticZenRuleState(String id2, Condition condition) {
            Preconditions.checkNotNull(id2, "id is null");
            Preconditions.checkNotNull(condition, "Condition is null");
            this.enforcePolicyAccess(Binder.getCallingUid(), "setAutomaticZenRuleState");
            NotificationManagerService.this.mZenModeHelper.setAutomaticZenRuleState(id2, condition);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setInterruptionFilter(String pkg, int filter) throws RemoteException {
            this.enforcePolicyAccess(pkg, "setInterruptionFilter");
            int zen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
            if (zen == -1) {
                throw new IllegalArgumentException("Invalid filter: " + filter);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mZenModeHelper.setManualZenMode(zen, null, pkg, "setInterruptionFilter");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void notifyConditions(final String pkg, IConditionProvider provider, final Condition[] conditions) {
            final ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mConditionProviders.checkServiceToken(provider);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            NotificationManagerService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    NotificationManagerService.this.mConditionProviders.notifyConditions(pkg, info, conditions);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestUnbindProvider(IConditionProvider provider) {
            long identity = Binder.clearCallingIdentity();
            try {
                ManagedServices.ManagedServiceInfo info = NotificationManagerService.this.mConditionProviders.checkServiceToken(provider);
                info.getOwner().setComponentState(info.component, false);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void requestBindProvider(ComponentName component) {
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(component.getPackageName());
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.mConditionProviders.setComponentState(component, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        private void enforceSystemOrSystemUI(String message) {
            if (NotificationManagerService.this.isCallerSystemOrPhone()) {
                return;
            }
            NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
        }

        private void enforceSystemOrSystemUIOrSamePackage(String pkg, String message) {
            try {
                NotificationManagerService.this.checkCallerIsSystemOrSameApp(pkg);
            }
            catch (SecurityException e) {
                NotificationManagerService.this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", message);
            }
        }

        private void enforcePolicyAccess(int uid, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            boolean accessAllowed = false;
            String[] packages = NotificationManagerService.this.mPackageManagerClient.getPackagesForUid(uid);
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!NotificationManagerService.this.mConditionProviders.isPackageOrComponentAllowed(packages[i], UserHandle.getUserId(uid))) continue;
                accessAllowed = true;
            }
            if (!accessAllowed) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private void enforcePolicyAccess(String pkg, String method) {
            if (0 == NotificationManagerService.this.getContext().checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS")) {
                return;
            }
            NotificationManagerService.this.checkCallerIsSameApp(pkg);
            if (!this.checkPolicyAccess(pkg)) {
                Slog.w(NotificationManagerService.TAG, "Notification policy access denied calling " + method);
                throw new SecurityException("Notification policy access denied");
            }
        }

        private boolean checkPackagePolicyAccess(String pkg) {
            return NotificationManagerService.this.mConditionProviders.isPackageOrComponentAllowed(pkg, 10.getCallingUserHandle().getIdentifier());
        }

        private boolean checkPolicyAccess(String pkg) {
            try {
                int uid = NotificationManagerService.this.getContext().getPackageManager().getPackageUidAsUser(pkg, UserHandle.getCallingUserId());
                if (0 == ActivityManager.checkComponentPermission("android.permission.MANAGE_NOTIFICATIONS", uid, -1, true)) {
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
            return this.checkPackagePolicyAccess(pkg) || NotificationManagerService.this.mListeners.isComponentEnabledForPackage(pkg) || NotificationManagerService.this.mDpm != null && NotificationManagerService.this.mDpm.isActiveAdminWithPolicy(Binder.getCallingUid(), -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpAndUsageStatsPermission(NotificationManagerService.this.getContext(), NotificationManagerService.TAG, pw)) {
                return;
            }
            DumpFilter filter = DumpFilter.parseFromArguments(args);
            long token = Binder.clearCallingIdentity();
            try {
                if (filter.stats) {
                    NotificationManagerService.this.dumpJson(pw, filter);
                } else if (filter.proto) {
                    NotificationManagerService.this.dumpProto(fd, filter);
                } else if (filter.criticalPriority) {
                    NotificationManagerService.this.dumpNotificationRecords(pw, filter);
                } else {
                    NotificationManagerService.this.dumpImpl(pw, filter);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public ComponentName getEffectsSuppressor() {
            return !NotificationManagerService.this.mEffectsSuppressors.isEmpty() ? (ComponentName)NotificationManagerService.this.mEffectsSuppressors.get(0) : null;
        }

        @Override
        public boolean matchesCallFilter(Bundle extras) {
            this.enforceSystemOrSystemUI("INotificationManager.matchesCallFilter");
            return NotificationManagerService.this.mZenModeHelper.matchesCallFilter(Binder.getCallingUserHandle(), extras, NotificationManagerService.this.mRankingHelper.findExtractor(ValidateNotificationPeople.class), 3000, 1.0f);
        }

        @Override
        public boolean isSystemConditionProviderEnabled(String path) {
            this.enforceSystemOrSystemUI("INotificationManager.isSystemConditionProviderEnabled");
            return NotificationManagerService.this.mConditionProviders.isSystemProviderEnabled(path);
        }

        @Override
        public byte[] getBackupPayload(int user) {
            NotificationManagerService.this.checkCallerIsSystem();
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "getBackupPayload u=" + user);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                NotificationManagerService.this.writePolicyXml(baos, true, user);
                return baos.toByteArray();
            }
            catch (IOException e) {
                Slog.w(NotificationManagerService.TAG, "getBackupPayload: error writing payload for user " + user, e);
                return null;
            }
        }

        @Override
        public void applyRestore(byte[] payload, int user) {
            NotificationManagerService.this.checkCallerIsSystem();
            if (DBG) {
                Slog.d(NotificationManagerService.TAG, "applyRestore u=" + user + " payload=" + (payload != null ? new String(payload, StandardCharsets.UTF_8) : null));
            }
            if (payload == null) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: no payload to restore for user " + user);
                return;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            try {
                NotificationManagerService.this.readPolicyXml(bais, true, user);
                NotificationManagerService.this.handleSavePolicyFile();
            }
            catch (IOException | NumberFormatException | XmlPullParserException e) {
                Slog.w(NotificationManagerService.TAG, "applyRestore: error reading payload", e);
            }
        }

        @Override
        public boolean isNotificationPolicyAccessGranted(String pkg) {
            return this.checkPolicyAccess(pkg);
        }

        @Override
        public boolean isNotificationPolicyAccessGrantedForPackage(String pkg) {
            this.enforceSystemOrSystemUIOrSamePackage(pkg, "request policy access status for another package");
            return this.checkPolicyAccess(pkg);
        }

        @Override
        public void setNotificationPolicyAccessGranted(String pkg, boolean granted) throws RemoteException {
            this.setNotificationPolicyAccessGrantedForUser(pkg, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicyAccessGrantedForUser(String pkg, int userId, boolean granted) {
            NotificationManagerService.this.checkCallerIsSystemOrShell();
            long identity = Binder.clearCallingIdentity();
            try {
                if (NotificationManagerService.this.mAllowedManagedServicePackages.test(pkg, userId, NotificationManagerService.this.mConditionProviders.getRequiredPermission())) {
                    NotificationManagerService.this.mConditionProviders.setPackageOrComponentEnabled(pkg, userId, true, granted);
                    NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(pkg).addFlags(0x4000000), UserHandle.of(userId), null);
                    NotificationManagerService.this.handleSavePolicyFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotificationManager.Policy getNotificationPolicy(String pkg) {
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManager.Policy policy = NotificationManagerService.this.mZenModeHelper.getNotificationPolicy();
                return policy;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NotificationManager.Policy getConsolidatedNotificationPolicy() {
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManager.Policy policy = NotificationManagerService.this.mZenModeHelper.getConsolidatedNotificationPolicy();
                return policy;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationPolicy(String pkg, NotificationManager.Policy policy) {
            this.enforcePolicyAccess(pkg, "setNotificationPolicy");
            long identity = Binder.clearCallingIdentity();
            try {
                ApplicationInfo applicationInfo = NotificationManagerService.this.mPackageManager.getApplicationInfo(pkg, 0, UserHandle.getUserId(MY_UID));
                NotificationManager.Policy currPolicy = NotificationManagerService.this.mZenModeHelper.getNotificationPolicy();
                if (applicationInfo.targetSdkVersion < 28) {
                    int priorityCategories = policy.priorityCategories;
                    priorityCategories &= 0xFFFFFFDF;
                    priorityCategories &= 0xFFFFFFBF;
                    priorityCategories &= 0xFFFFFF7F;
                    priorityCategories |= currPolicy.priorityCategories & 0x20;
                    priorityCategories |= currPolicy.priorityCategories & 0x40;
                    policy = new NotificationManager.Policy(priorityCategories |= currPolicy.priorityCategories & 0x80, policy.priorityCallSenders, policy.priorityMessageSenders, policy.suppressedVisualEffects);
                }
                int newVisualEffects = NotificationManagerService.this.calculateSuppressedVisualEffects(policy, currPolicy, applicationInfo.targetSdkVersion);
                policy = new NotificationManager.Policy(policy.priorityCategories, policy.priorityCallSenders, policy.priorityMessageSenders, newVisualEffects);
                ZenLog.traceSetNotificationPolicy(pkg, applicationInfo.targetSdkVersion, policy);
                NotificationManagerService.this.mZenModeHelper.setNotificationPolicy(policy);
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public List<String> getEnabledNotificationListenerPackages() {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.getAllowedPackages(10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public List<ComponentName> getEnabledNotificationListeners(int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.getAllowedComponents(userId);
        }

        @Override
        public ComponentName getAllowedNotificationAssistantForUser(int userId) {
            NotificationManagerService.this.checkCallerIsSystemOrSystemUiOrShell();
            List<ComponentName> allowedComponents = NotificationManagerService.this.mAssistants.getAllowedComponents(userId);
            if (allowedComponents.size() > 1) {
                throw new IllegalStateException("At most one NotificationAssistant: " + allowedComponents.size());
            }
            return CollectionUtils.firstOrNull(allowedComponents);
        }

        @Override
        public ComponentName getAllowedNotificationAssistant() {
            return this.getAllowedNotificationAssistantForUser(10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public boolean isNotificationListenerAccessGranted(ComponentName listener) {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(listener.getPackageName());
            return NotificationManagerService.this.mListeners.isPackageOrComponentAllowed(listener.flattenToString(), 10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public boolean isNotificationListenerAccessGrantedForUser(ComponentName listener, int userId) {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystem();
            return NotificationManagerService.this.mListeners.isPackageOrComponentAllowed(listener.flattenToString(), userId);
        }

        @Override
        public boolean isNotificationAssistantAccessGranted(ComponentName assistant) {
            Preconditions.checkNotNull(assistant);
            NotificationManagerService.this.checkCallerIsSystemOrSameApp(assistant.getPackageName());
            return NotificationManagerService.this.mAssistants.isPackageOrComponentAllowed(assistant.flattenToString(), 10.getCallingUserHandle().getIdentifier());
        }

        @Override
        public void setNotificationListenerAccessGranted(ComponentName listener, boolean granted) throws RemoteException {
            this.setNotificationListenerAccessGrantedForUser(listener, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        @Override
        public void setNotificationAssistantAccessGranted(ComponentName assistant, boolean granted) {
            this.setNotificationAssistantAccessGrantedForUser(assistant, 10.getCallingUserHandle().getIdentifier(), granted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationListenerAccessGrantedForUser(ComponentName listener, int userId, boolean granted) {
            Preconditions.checkNotNull(listener);
            NotificationManagerService.this.checkCallerIsSystemOrShell();
            long identity = Binder.clearCallingIdentity();
            try {
                if (NotificationManagerService.this.mAllowedManagedServicePackages.test(listener.getPackageName(), userId, NotificationManagerService.this.mListeners.getRequiredPermission())) {
                    NotificationManagerService.this.mConditionProviders.setPackageOrComponentEnabled(listener.flattenToString(), userId, false, granted);
                    NotificationManagerService.this.mListeners.setPackageOrComponentEnabled(listener.flattenToString(), userId, true, granted);
                    NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(listener.getPackageName()).addFlags(0x40000000), UserHandle.of(userId), null);
                    NotificationManagerService.this.handleSavePolicyFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNotificationAssistantAccessGrantedForUser(ComponentName assistant, int userId, boolean granted) {
            NotificationManagerService.this.checkCallerIsSystemOrSystemUiOrShell();
            for (UserInfo ui : NotificationManagerService.this.mUm.getEnabledProfiles(userId)) {
                NotificationManagerService.this.mAssistants.setUserSet(ui.id, true);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                NotificationManagerService.this.setNotificationAssistantAccessGrantedForUserInternal(assistant, userId, granted);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyEnqueuedAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) {
            boolean foundEnqueued = false;
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord r = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(adjustment.getKey(), r.getKey()) || !Objects.equals(adjustment.getUser(), r.getUserId()) || !NotificationManagerService.this.mAssistants.isSameUser(token, r.getUserId())) continue;
                        NotificationManagerService.this.applyAdjustment(r, adjustment);
                        r.applyAdjustments();
                        r.calculateImportance();
                        foundEnqueued = true;
                        break;
                    }
                    if (!foundEnqueued) {
                        this.applyAdjustmentFromAssistant(token, adjustment);
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void applyAdjustmentFromAssistant(INotificationListener token, Adjustment adjustment) {
            ArrayList<Adjustment> adjustments = new ArrayList<Adjustment>();
            adjustments.add(adjustment);
            this.applyAdjustmentsFromAssistant(token, adjustments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyAdjustmentsFromAssistant(INotificationListener token, List<Adjustment> adjustments) {
            boolean needsSort = false;
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.mAssistants.checkServiceTokenLocked(token);
                    for (Adjustment adjustment : adjustments) {
                        NotificationRecord r = NotificationManagerService.this.mNotificationsByKey.get(adjustment.getKey());
                        if (r == null || !NotificationManagerService.this.mAssistants.isSameUser(token, r.getUserId())) continue;
                        NotificationManagerService.this.applyAdjustment(r, adjustment);
                        if (adjustment.getSignals().containsKey("key_importance") && adjustment.getSignals().getInt("key_importance") == 0) {
                            this.cancelNotificationsFromListener(token, new String[]{r.getKey()});
                            continue;
                        }
                        needsSort = true;
                    }
                }
                if (needsSort) {
                    NotificationManagerService.this.mRankingHandler.requestSort();
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        @Override
        public void updateNotificationChannelGroupFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannelGroup group) throws RemoteException {
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user, false);
            NotificationManagerService.this.createNotificationChannelGroup(pkg, this.getUidForPackageAndUser(pkg, user), group, false, true);
            NotificationManagerService.this.handleSavePolicyFile();
        }

        @Override
        public void updateNotificationChannelFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user, NotificationChannel channel) throws RemoteException {
            Preconditions.checkNotNull(channel);
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user, false);
            NotificationManagerService.this.updateNotificationChannelInt(pkg, this.getUidForPackageAndUser(pkg, user), channel, true);
        }

        @Override
        public ParceledListSlice<NotificationChannel> getNotificationChannelsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user, true);
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannels(pkg, this.getUidForPackageAndUser(pkg, user), false);
        }

        @Override
        public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroupsFromPrivilegedListener(INotificationListener token, String pkg, UserHandle user) throws RemoteException {
            Preconditions.checkNotNull(pkg);
            Preconditions.checkNotNull(user);
            this.verifyPrivilegedListener(token, user, true);
            ArrayList<NotificationChannelGroup> groups = new ArrayList<NotificationChannelGroup>();
            groups.addAll(NotificationManagerService.this.mPreferencesHelper.getNotificationChannelGroups(pkg, this.getUidForPackageAndUser(pkg, user)));
            return new ParceledListSlice<NotificationChannelGroup>(groups);
        }

        @Override
        public void setPrivateNotificationsAllowed(boolean allow) {
            if (0 != NotificationManagerService.this.getContext().checkCallingPermission("android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")) {
                throw new SecurityException("Requires CONTROL_KEYGUARD_SECURE_NOTIFICATIONS permission");
            }
            if (allow != NotificationManagerService.this.mLockScreenAllowSecureNotifications) {
                NotificationManagerService.this.mLockScreenAllowSecureNotifications = allow;
                NotificationManagerService.this.handleSavePolicyFile();
            }
        }

        @Override
        public boolean getPrivateNotificationsAllowed() {
            if (0 != NotificationManagerService.this.getContext().checkCallingPermission("android.permission.CONTROL_KEYGUARD_SECURE_NOTIFICATIONS")) {
                throw new SecurityException("Requires CONTROL_KEYGUARD_SECURE_NOTIFICATIONS permission");
            }
            return NotificationManagerService.this.mLockScreenAllowSecureNotifications;
        }

        @Override
        public boolean isPackagePaused(String pkg) {
            Preconditions.checkNotNull(pkg);
            NotificationManagerService.this.checkCallerIsSameApp(pkg);
            PackageManagerInternal pmi = LocalServices.getService(PackageManagerInternal.class);
            int flags = pmi.getDistractingPackageRestrictions(pkg, Binder.getCallingUserHandle().getIdentifier());
            boolean isPaused = (flags & 2) != 0;
            return isPaused |= NotificationManagerService.this.isPackageSuspendedForUser(pkg, Binder.getCallingUid());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyPrivilegedListener(INotificationListener token, UserHandle user, boolean assistantAllowed) {
            ManagedServices.ManagedServiceInfo info;
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                info = NotificationManagerService.this.mListeners.checkServiceTokenLocked(token);
            }
            if (!NotificationManagerService.this.hasCompanionDevice(info)) {
                object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    if (!assistantAllowed || !NotificationManagerService.this.mAssistants.isServiceTokenValidLocked(info.service)) {
                        throw new SecurityException(info + " does not have access");
                    }
                }
            }
            if (!info.enabledAndUserMatches(user.getIdentifier())) {
                throw new SecurityException(info + " does not have access");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getUidForPackageAndUser(String pkg, UserHandle user) throws RemoteException {
            int uid = 0;
            long identity = Binder.clearCallingIdentity();
            try {
                uid = NotificationManagerService.this.mPackageManager.getPackageUid(pkg, 0, user.getIdentifier());
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            return uid;
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) throws RemoteException {
            new NotificationShellCmd(NotificationManagerService.this).exec(this, in, out, err, args, callback, resultReceiver);
        }
    };
    private final NotificationManagerInternal mInternalService = new NotificationManagerInternal(){

        @Override
        public NotificationChannel getNotificationChannel(String pkg, int uid, String channelId) {
            return NotificationManagerService.this.mPreferencesHelper.getNotificationChannel(pkg, uid, channelId, false);
        }

        @Override
        public void enqueueNotification(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int userId) {
            NotificationManagerService.this.enqueueNotificationInternal(pkg, opPkg, callingUid, callingPid, tag, id2, notification, userId);
        }

        @Override
        public void removeForegroundServiceFlagFromNotification(String pkg, int notificationId, int userId) {
            NotificationManagerService.this.checkCallerIsSystem();
            NotificationManagerService.this.mHandler.post(() -> {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    List enqueued = NotificationManagerService.this.findNotificationsByListLocked(NotificationManagerService.this.mEnqueuedNotifications, pkg, null, notificationId, userId);
                    for (int i = 0; i < enqueued.size(); ++i) {
                        this.removeForegroundServiceFlagLocked((NotificationRecord)enqueued.get(i));
                    }
                    NotificationRecord r = NotificationManagerService.this.findNotificationByListLocked(NotificationManagerService.this.mNotificationList, pkg, null, notificationId, userId);
                    if (r != null) {
                        this.removeForegroundServiceFlagLocked(r);
                        NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
                        NotificationManagerService.this.mListeners.notifyPostedLocked(r, r);
                    }
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        private void removeForegroundServiceFlagLocked(NotificationRecord r) {
            if (r == null) {
                return;
            }
            StatusBarNotification sbn = r.sbn;
            sbn.getNotification().flags = r.mOriginalFlags & 0xFFFFFFBF;
        }
    };

    protected void readDefaultApprovedServices(int userId) {
        String defaultDndAccess;
        String defaultListenerAccess = this.getContext().getResources().getString(17039704);
        if (defaultListenerAccess != null) {
            for (String whitelisted : defaultListenerAccess.split(":")) {
                Set<ComponentName> approvedListeners = this.mListeners.queryPackageForServices(whitelisted, 786432, userId);
                for (ComponentName cn : approvedListeners) {
                    try {
                        this.getBinderService().setNotificationListenerAccessGrantedForUser(cn, userId, true);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if ((defaultDndAccess = this.getContext().getResources().getString(17039703)) != null) {
            for (String whitelisted : defaultDndAccess.split(":")) {
                try {
                    this.getBinderService().setNotificationPolicyAccessGranted(whitelisted, true);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setDefaultAssistantForUser(userId);
    }

    protected void setDefaultAssistantForUser(int userId) {
        ArrayList<ComponentName> validAssistants = new ArrayList<ComponentName>(this.mAssistants.queryPackageForServices(null, 786432, userId));
        ArrayList<String> candidateStrs = new ArrayList<String>();
        candidateStrs.add(DeviceConfig.getProperty("systemui", "nas_default_service"));
        candidateStrs.add(this.getContext().getResources().getString(17039697));
        for (String candidateStr : candidateStrs) {
            if (TextUtils.isEmpty(candidateStr)) continue;
            ComponentName candidate = ComponentName.unflattenFromString(candidateStr);
            if (candidate != null && validAssistants.contains(candidate)) {
                this.setNotificationAssistantAccessGrantedForUserInternal(candidate, userId, true);
                Slog.d(TAG, String.format("Set default NAS to be %s in %d", candidateStr, userId));
                return;
            }
            Slog.w(TAG, "Invalid default NAS config is found: " + candidateStr);
        }
    }

    void readPolicyXml(InputStream stream, boolean forRestore, int userId) throws XmlPullParserException, NumberFormatException, IOException {
        XmlPullParser parser = Xml.newPullParser();
        parser.setInput(stream, StandardCharsets.UTF_8.name());
        XmlUtils.beginDocument(parser, TAG_NOTIFICATION_POLICY);
        boolean migratedManagedServices = false;
        boolean ineligibleForManagedServices = forRestore && this.mUm.isManagedProfile(userId);
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if ("zen".equals(parser.getName())) {
                this.mZenModeHelper.readXml(parser, forRestore, userId);
            } else if ("ranking".equals(parser.getName())) {
                this.mPreferencesHelper.readXml(parser, forRestore, userId);
            }
            if (this.mListeners.getConfig().xmlTag.equals(parser.getName())) {
                if (ineligibleForManagedServices) continue;
                this.mListeners.readXml(parser, this.mAllowedManagedServicePackages, forRestore, userId);
                migratedManagedServices = true;
            } else if (this.mAssistants.getConfig().xmlTag.equals(parser.getName())) {
                if (ineligibleForManagedServices) continue;
                this.mAssistants.readXml(parser, this.mAllowedManagedServicePackages, forRestore, userId);
                migratedManagedServices = true;
            } else if (this.mConditionProviders.getConfig().xmlTag.equals(parser.getName())) {
                if (ineligibleForManagedServices) continue;
                this.mConditionProviders.readXml(parser, this.mAllowedManagedServicePackages, forRestore, userId);
                migratedManagedServices = true;
            }
            if (!LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_TAG.equals(parser.getName()) || forRestore && userId != 0) continue;
            this.mLockScreenAllowSecureNotifications = NotificationManagerService.safeBoolean(parser.getAttributeValue(null, LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_VALUE), true);
        }
        if (!migratedManagedServices) {
            this.mListeners.migrateToXml();
            this.mAssistants.migrateToXml();
            this.mConditionProviders.migrateToXml();
            this.handleSavePolicyFile();
        }
        this.mAssistants.resetDefaultAssistantsIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void loadPolicyFile() {
        if (DBG) {
            Slog.d(TAG, "loadPolicyFile");
        }
        AtomicFile atomicFile = this.mPolicyFile;
        synchronized (atomicFile) {
            FileInputStream infile = null;
            try {
                infile = this.mPolicyFile.openRead();
                this.readPolicyXml(infile, false, -1);
            }
            catch (FileNotFoundException e) {
                this.readDefaultApprovedServices(0);
            }
            catch (IOException e) {
                Log.wtf(TAG, "Unable to read notification policy", e);
            }
            catch (NumberFormatException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            catch (XmlPullParserException e) {
                Log.wtf(TAG, "Unable to parse notification policy", e);
            }
            finally {
                IoUtils.closeQuietly(infile);
            }
        }
    }

    @VisibleForTesting
    protected void handleSavePolicyFile() {
        IoThread.getHandler().post(() -> {
            if (DBG) {
                Slog.d(TAG, "handleSavePolicyFile");
            }
            AtomicFile atomicFile = this.mPolicyFile;
            synchronized (atomicFile) {
                FileOutputStream stream;
                try {
                    stream = this.mPolicyFile.startWrite();
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed to save policy file", e);
                    return;
                }
                try {
                    this.writePolicyXml(stream, false, -1);
                    this.mPolicyFile.finishWrite(stream);
                }
                catch (IOException e) {
                    Slog.w(TAG, "Failed to save policy file, restoring backup", e);
                    this.mPolicyFile.failWrite(stream);
                }
            }
            BackupManager.dataChanged(this.getContext().getPackageName());
        });
    }

    private void writePolicyXml(OutputStream stream, boolean forBackup, int userId) throws IOException {
        FastXmlSerializer out = new FastXmlSerializer();
        out.setOutput(stream, StandardCharsets.UTF_8.name());
        out.startDocument(null, true);
        out.startTag(null, TAG_NOTIFICATION_POLICY);
        out.attribute(null, ATTR_VERSION, Integer.toString(1));
        this.mZenModeHelper.writeXml(out, forBackup, null, userId);
        this.mPreferencesHelper.writeXml(out, forBackup, userId);
        this.mListeners.writeXml(out, forBackup, userId);
        this.mAssistants.writeXml(out, forBackup, userId);
        this.mConditionProviders.writeXml(out, forBackup, userId);
        if (!forBackup || userId == 0) {
            this.writeSecureNotificationsPolicy(out);
        }
        out.endTag(null, TAG_NOTIFICATION_POLICY);
        out.endDocument();
    }

    @VisibleForTesting
    void logSmartSuggestionsVisible(NotificationRecord r, int notificationLocation) {
        if (!(r.getNumSmartRepliesAdded() <= 0 && r.getNumSmartActionsAdded() <= 0 || r.hasSeenSmartReplies())) {
            r.setSeenSmartReplies(true);
            LogMaker logMaker = r.getLogMaker().setCategory(1382).addTaggedData(1384, r.getNumSmartRepliesAdded()).addTaggedData(1599, r.getNumSmartActionsAdded()).addTaggedData(1600, r.getSuggestionsGeneratedByAssistant() ? 1 : 0).addTaggedData(1629, notificationLocation).addTaggedData(1647, r.getEditChoicesBeforeSending() ? 1 : 0);
            this.mMetricsLogger.write(logMaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mNotificationLock"})
    private void clearSoundLocked() {
        this.mSoundNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
            if (player != null) {
                player.stopAsync();
            }
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private void clearVibrateLocked() {
        this.mVibrateNotificationKey = null;
        long identity = Binder.clearCallingIdentity();
        try {
            this.mVibrator.cancel();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private void clearLightsLocked() {
        this.mLights.clear();
        this.updateLightsLocked();
    }

    static long[] getLongArray(Resources r, int resid, int maxlen, long[] def) {
        int[] ar = r.getIntArray(resid);
        if (ar == null) {
            return def;
        }
        int len = ar.length > maxlen ? maxlen : ar.length;
        long[] out = new long[len];
        for (int i = 0; i < len; ++i) {
            out[i] = ar[i];
        }
        return out;
    }

    public NotificationManagerService(Context context) {
        super(context);
        Notification.processWhitelistToken = WHITELIST_TOKEN;
    }

    @VisibleForTesting
    void setAudioManager(AudioManager audioMananger) {
        this.mAudioManager = audioMananger;
    }

    @VisibleForTesting
    void setHints(int hints) {
        this.mListenerHints = hints;
    }

    @VisibleForTesting
    void setVibrator(Vibrator vibrator) {
        this.mVibrator = vibrator;
    }

    @VisibleForTesting
    void setLights(Light light) {
        this.mNotificationLight = light;
        this.mAttentionLight = light;
        this.mNotificationPulseEnabled = true;
    }

    @VisibleForTesting
    void setScreenOn(boolean on) {
        this.mScreenOn = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getNotificationRecordCount() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            int count = this.mNotificationList.size() + this.mNotificationsByKey.size() + this.mSummaryByGroupKey.size() + this.mEnqueuedNotifications.size();
            for (NotificationRecord posted : this.mNotificationList) {
                if (this.mNotificationsByKey.containsKey(posted.getKey())) {
                    --count;
                }
                if (!posted.sbn.isGroup() || !posted.getNotification().isGroupSummary()) continue;
                --count;
            }
            return count;
        }
    }

    @VisibleForTesting
    void clearNotifications() {
        this.mEnqueuedNotifications.clear();
        this.mNotificationList.clear();
        this.mNotificationsByKey.clear();
        this.mSummaryByGroupKey.clear();
    }

    @VisibleForTesting
    void addNotification(NotificationRecord r) {
        this.mNotificationList.add(r);
        this.mNotificationsByKey.put(r.sbn.getKey(), r);
        if (r.sbn.isGroup()) {
            this.mSummaryByGroupKey.put(r.getGroupKey(), r);
        }
    }

    @VisibleForTesting
    void addEnqueuedNotification(NotificationRecord r) {
        this.mEnqueuedNotifications.add(r);
    }

    @VisibleForTesting
    NotificationRecord getNotificationRecord(String key) {
        return this.mNotificationsByKey.get(key);
    }

    @VisibleForTesting
    void setSystemReady(boolean systemReady) {
        this.mSystemReady = systemReady;
    }

    @VisibleForTesting
    void setHandler(WorkerHandler handler) {
        this.mHandler = handler;
    }

    @VisibleForTesting
    void setFallbackVibrationPattern(long[] vibrationPattern) {
        this.mFallbackVibrationPattern = vibrationPattern;
    }

    @VisibleForTesting
    void setPackageManager(IPackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    @VisibleForTesting
    void setRankingHelper(RankingHelper rankingHelper) {
        this.mRankingHelper = rankingHelper;
    }

    @VisibleForTesting
    void setPreferencesHelper(PreferencesHelper prefHelper) {
        this.mPreferencesHelper = prefHelper;
    }

    @VisibleForTesting
    void setRankingHandler(RankingHandler rankingHandler) {
        this.mRankingHandler = rankingHandler;
    }

    @VisibleForTesting
    void setZenHelper(ZenModeHelper zenHelper) {
        this.mZenModeHelper = zenHelper;
    }

    @VisibleForTesting
    void setIsAutomotive(boolean isAutomotive) {
        this.mIsAutomotive = isAutomotive;
    }

    @VisibleForTesting
    void setNotificationEffectsEnabledForAutomotive(boolean isEnabled) {
        this.mNotificationEffectsEnabledForAutomotive = isEnabled;
    }

    @VisibleForTesting
    void setIsTelevision(boolean isTelevision) {
        this.mIsTelevision = isTelevision;
    }

    @VisibleForTesting
    void setUsageStats(NotificationUsageStats us) {
        this.mUsageStats = us;
    }

    @VisibleForTesting
    void setAccessibilityManager(AccessibilityManager am) {
        this.mAccessibilityManager = am;
    }

    @VisibleForTesting
    void init(Looper looper, IPackageManager packageManager, PackageManager packageManagerClient, LightsManager lightsManager, NotificationListeners notificationListeners, NotificationAssistants notificationAssistants, ConditionProviders conditionProviders, ICompanionDeviceManager companionManager, SnoozeHelper snoozeHelper, NotificationUsageStats usageStats, AtomicFile policyFile, ActivityManager activityManager, GroupHelper groupHelper, IActivityManager am, UsageStatsManagerInternal appUsageStats, DevicePolicyManagerInternal dpm, IUriGrantsManager ugm, UriGrantsManagerInternal ugmInternal, AppOpsManager appOps, UserManager userManager) {
        String[] extractorNames;
        Resources resources = this.getContext().getResources();
        this.mMaxPackageEnqueueRate = Settings.Global.getFloat(this.getContext().getContentResolver(), "max_notification_enqueue_rate", 5.0f);
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
        this.mAm = am;
        this.mUgm = ugm;
        this.mUgmInternal = ugmInternal;
        this.mPackageManager = packageManager;
        this.mPackageManagerClient = packageManagerClient;
        this.mAppOps = appOps;
        this.mVibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        this.mAppUsageStats = appUsageStats;
        this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
        this.mCompanionManager = companionManager;
        this.mActivityManager = activityManager;
        this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        this.mDpm = dpm;
        this.mUm = userManager;
        this.mHandler = new WorkerHandler(looper);
        this.mRankingThread.start();
        try {
            extractorNames = resources.getStringArray(17236046);
        }
        catch (Resources.NotFoundException e) {
            extractorNames = new String[]{};
        }
        this.mUsageStats = usageStats;
        this.mMetricsLogger = new MetricsLogger();
        this.mRankingHandler = new RankingHandlerWorker(this.mRankingThread.getLooper());
        this.mConditionProviders = conditionProviders;
        this.mZenModeHelper = new ZenModeHelper(this.getContext(), this.mHandler.getLooper(), this.mConditionProviders);
        this.mZenModeHelper.addCallback(new ZenModeHelper.Callback(){

            @Override
            public void onConfigChanged() {
                NotificationManagerService.this.handleSavePolicyFile();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void onZenModeChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.INTERRUPTION_FILTER_CHANGED");
                NotificationManagerService.this.getContext().sendBroadcastAsUser(new Intent("android.app.action.INTERRUPTION_FILTER_CHANGED_INTERNAL").addFlags(0x4000000), UserHandle.ALL, "android.permission.MANAGE_NOTIFICATIONS");
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.updateInterruptionFilterLocked();
                }
                NotificationManagerService.this.mRankingHandler.requestSort();
            }

            @Override
            void onPolicyChanged() {
                NotificationManagerService.this.sendRegisteredOnlyBroadcast("android.app.action.NOTIFICATION_POLICY_CHANGED");
                NotificationManagerService.this.mRankingHandler.requestSort();
            }
        });
        this.mPreferencesHelper = new PreferencesHelper(this.getContext(), this.mPackageManagerClient, this.mRankingHandler, this.mZenModeHelper);
        this.mRankingHelper = new RankingHelper(this.getContext(), this.mRankingHandler, this.mPreferencesHelper, this.mZenModeHelper, this.mUsageStats, extractorNames);
        this.mSnoozeHelper = snoozeHelper;
        this.mGroupHelper = groupHelper;
        this.mListeners = notificationListeners;
        this.mAssistants = notificationAssistants;
        this.mAllowedManagedServicePackages = this::canUseManagedServices;
        this.mPolicyFile = policyFile;
        this.loadPolicyFile();
        this.mStatusBar = this.getLocalService(StatusBarManagerInternal.class);
        if (this.mStatusBar != null) {
            this.mStatusBar.setNotificationDelegate(this.mNotificationDelegate);
        }
        this.mNotificationLight = lightsManager.getLight(4);
        this.mAttentionLight = lightsManager.getLight(5);
        this.mFallbackVibrationPattern = NotificationManagerService.getLongArray(resources, 17236045, 17, DEFAULT_VIBRATE_PATTERN);
        this.mInCallNotificationUri = Uri.parse("file://" + resources.getString(17039743));
        this.mInCallNotificationAudioAttributes = new AudioAttributes.Builder().setContentType(4).setUsage(2).build();
        this.mInCallNotificationVolume = resources.getFloat(17105060);
        this.mUseAttentionLight = resources.getBoolean(17891555);
        this.mHasLight = resources.getBoolean(17891468);
        if (0 == Settings.Global.getInt(this.getContext().getContentResolver(), "device_provisioned", 0)) {
            this.mDisableNotificationEffects = true;
        }
        this.mZenModeHelper.initZenMode();
        this.mInterruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        this.mUserProfiles.updateCache(this.getContext());
        this.listenForCallState();
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mArchive = new Archive(resources.getInteger(17694860));
        this.mIsTelevision = this.mPackageManagerClient.hasSystemFeature("android.software.leanback") || this.mPackageManagerClient.hasSystemFeature("android.hardware.type.television");
        this.mIsAutomotive = this.mPackageManagerClient.hasSystemFeature("android.hardware.type.automotive", 0);
        this.mNotificationEffectsEnabledForAutomotive = resources.getBoolean(17891448);
        this.mPreferencesHelper.lockChannelsForOEM(this.getContext().getResources().getStringArray(17236044));
        this.mZenModeHelper.setPriorityOnlyDndExemptPackages(this.getContext().getResources().getStringArray(17236048));
    }

    @Override
    public void onStart() {
        SnoozeHelper snoozeHelper = new SnoozeHelper(this.getContext(), new SnoozeHelper.Callback(){

            @Override
            public void repost(int userId, NotificationRecord r) {
                try {
                    if (DBG) {
                        Slog.d(NotificationManagerService.TAG, "Reposting " + r.getKey());
                    }
                    NotificationManagerService.this.enqueueNotificationInternal(r.sbn.getPackageName(), r.sbn.getOpPkg(), r.sbn.getUid(), r.sbn.getInitialPid(), r.sbn.getTag(), r.sbn.getId(), r.sbn.getNotification(), userId);
                }
                catch (Exception e) {
                    Slog.e(NotificationManagerService.TAG, "Cannot un-snooze notification", e);
                }
            }
        }, this.mUserProfiles);
        File systemDir = new File(Environment.getDataDirectory(), "system");
        this.init(Looper.myLooper(), AppGlobals.getPackageManager(), this.getContext().getPackageManager(), this.getLocalService(LightsManager.class), new NotificationListeners(AppGlobals.getPackageManager()), new NotificationAssistants(this.getContext(), this.mNotificationLock, this.mUserProfiles, AppGlobals.getPackageManager()), new ConditionProviders(this.getContext(), this.mUserProfiles, AppGlobals.getPackageManager()), null, snoozeHelper, new NotificationUsageStats(this.getContext()), new AtomicFile(new File(systemDir, "notification_policy.xml"), TAG_NOTIFICATION_POLICY), (ActivityManager)this.getContext().getSystemService("activity"), this.getGroupHelper(), ActivityManager.getService(), LocalServices.getService(UsageStatsManagerInternal.class), LocalServices.getService(DevicePolicyManagerInternal.class), UriGrantsManager.getService(), LocalServices.getService(UriGrantsManagerInternal.class), (AppOpsManager)this.getContext().getSystemService("appops"), this.getContext().getSystemService(UserManager.class));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.PHONE_STATE");
        filter.addAction("android.intent.action.USER_PRESENT");
        filter.addAction("android.intent.action.USER_STOPPED");
        filter.addAction("android.intent.action.USER_SWITCHED");
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_UNLOCKED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_UNAVAILABLE");
        this.getContext().registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, filter, null, null);
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.PACKAGE_ADDED");
        pkgFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        pkgFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        pkgFilter.addAction("android.intent.action.PACKAGE_RESTARTED");
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, pkgFilter, null, null);
        IntentFilter suspendedPkgFilter = new IntentFilter();
        suspendedPkgFilter.addAction("android.intent.action.PACKAGES_SUSPENDED");
        suspendedPkgFilter.addAction("android.intent.action.PACKAGES_UNSUSPENDED");
        suspendedPkgFilter.addAction("android.intent.action.DISTRACTING_PACKAGES_CHANGED");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, suspendedPkgFilter, null, null);
        IntentFilter sdFilter = new IntentFilter("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.getContext().registerReceiverAsUser(this.mPackageIntentReceiver, UserHandle.ALL, sdFilter, null, null);
        IntentFilter timeoutFilter = new IntentFilter(ACTION_NOTIFICATION_TIMEOUT);
        timeoutFilter.addDataScheme(SCHEME_TIMEOUT);
        this.getContext().registerReceiver(this.mNotificationTimeoutReceiver, timeoutFilter);
        IntentFilter settingsRestoredFilter = new IntentFilter("android.os.action.SETTING_RESTORED");
        this.getContext().registerReceiver(this.mRestoreReceiver, settingsRestoredFilter);
        IntentFilter localeChangedFilter = new IntentFilter("android.intent.action.LOCALE_CHANGED");
        this.getContext().registerReceiver(this.mLocaleChangeReceiver, localeChangedFilter);
        this.publishBinderService("notification", this.mService, false, 5);
        this.publishLocalService(NotificationManagerInternal.class, this.mInternalService);
    }

    private void registerDeviceConfigChange() {
        DeviceConfig.addOnPropertiesChangedListener("systemui", this.getContext().getMainExecutor(), properties -> {
            if (!"systemui".equals(properties.getNamespace())) {
                return;
            }
            if (properties.getKeyset().contains("nas_default_service")) {
                this.mAssistants.resetDefaultAssistantsIfNecessary();
            }
        });
    }

    private GroupHelper getGroupHelper() {
        this.mAutoGroupAtCount = this.getContext().getResources().getInteger(17694741);
        return new GroupHelper(this.mAutoGroupAtCount, new GroupHelper.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addAutoGroup(String key) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.addAutogroupKeyLocked(key);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAutoGroup(String key) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.removeAutogroupKeyLocked(key);
                }
            }

            @Override
            public void addAutoGroupSummary(int userId, String pkg, String triggeringKey) {
                NotificationManagerService.this.createAutoGroupSummary(userId, pkg, triggeringKey);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAutoGroupSummary(int userId, String pkg) {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    NotificationManagerService.this.clearAutogroupSummaryLocked(userId, pkg);
                }
            }
        });
    }

    private void sendRegisteredOnlyBroadcast(String action) {
        Intent intent = new Intent(action);
        this.getContext().sendBroadcastAsUser(intent.addFlags(0x40000000), UserHandle.ALL, null);
        intent.setFlags(0);
        Set<String> dndApprovedPackages = this.mConditionProviders.getAllowedPackages();
        for (String pkg : dndApprovedPackages) {
            intent.setPackage(pkg);
            this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
        }
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mSystemReady = true;
            this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
            this.mAudioManagerInternal = this.getLocalService(AudioManagerInternal.class);
            this.mWindowManagerInternal = LocalServices.getService(WindowManagerInternal.class);
            this.mZenModeHelper.onSystemReady();
            this.mRoleObserver = new RoleObserver(this.getContext().getSystemService(RoleManager.class), this.mPackageManager, this.getContext().getMainExecutor());
            this.mRoleObserver.init();
        } else if (phase == 600) {
            this.mSettingsObserver.observe();
            this.mListeners.onBootPhaseAppsCanStart();
            this.mAssistants.onBootPhaseAppsCanStart();
            this.mConditionProviders.onBootPhaseAppsCanStart();
            this.registerDeviceConfigChange();
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private void updateListenerHintsLocked() {
        int hints = this.calculateHints();
        if (hints == this.mListenerHints) {
            return;
        }
        ZenLog.traceListenerHintsChanged(this.mListenerHints, hints, this.mEffectsSuppressors.size());
        this.mListenerHints = hints;
        this.scheduleListenerHintsChanged(hints);
    }

    @GuardedBy(value={"mNotificationLock"})
    private void updateEffectsSuppressorLocked() {
        long updatedSuppressedEffects = this.calculateSuppressedEffects();
        if (updatedSuppressedEffects == this.mZenModeHelper.getSuppressedEffects()) {
            return;
        }
        ArrayList<ComponentName> suppressors = this.getSuppressors();
        ZenLog.traceEffectsSuppressorChanged(this.mEffectsSuppressors, suppressors, updatedSuppressedEffects);
        this.mEffectsSuppressors = suppressors;
        this.mZenModeHelper.setSuppressedEffects(updatedSuppressedEffects);
        this.sendRegisteredOnlyBroadcast("android.os.action.ACTION_EFFECTS_SUPPRESSOR_CHANGED");
    }

    private void exitIdle() {
        try {
            if (this.mDeviceIdleController != null) {
                this.mDeviceIdleController.exitIdle("notification interaction");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void updateNotificationChannelInt(String pkg, int uid, NotificationChannel channel, boolean fromListener) {
        if (channel.getImportance() == 0) {
            this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channel.getId(), 0, 0, true, UserHandle.getUserId(uid), 17, null);
            if (this.isUidSystemOrPhone(uid)) {
                IntArray profileIds = this.mUserProfiles.getCurrentProfileIds();
                int N = profileIds.size();
                for (int i = 0; i < N; ++i) {
                    int profileId = profileIds.get(i);
                    this.cancelAllNotificationsInt(MY_UID, MY_PID, pkg, channel.getId(), 0, 0, true, profileId, 17, null);
                }
            }
        }
        NotificationChannel preUpdate = this.mPreferencesHelper.getNotificationChannel(pkg, uid, channel.getId(), true);
        this.mPreferencesHelper.updateNotificationChannel(pkg, uid, channel, true);
        this.maybeNotifyChannelOwner(pkg, uid, preUpdate, channel);
        if (!fromListener) {
            NotificationChannel modifiedChannel = this.mPreferencesHelper.getNotificationChannel(pkg, uid, channel.getId(), false);
            this.mListeners.notifyNotificationChannelChanged(pkg, UserHandle.getUserHandleForUid(uid), modifiedChannel, 2);
        }
        this.handleSavePolicyFile();
    }

    private void maybeNotifyChannelOwner(String pkg, int uid, NotificationChannel preUpdate, NotificationChannel update) {
        try {
            if (preUpdate.getImportance() == 0 && update.getImportance() != 0 || preUpdate.getImportance() != 0 && update.getImportance() == 0) {
                this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_CHANNEL_BLOCK_STATE_CHANGED").putExtra("android.app.extra.NOTIFICATION_CHANNEL_ID", update.getId()).putExtra("android.app.extra.BLOCKED_STATE", update.getImportance() == 0).addFlags(0x10000000).setPackage(pkg), UserHandle.of(UserHandle.getUserId(uid)), null);
            }
        }
        catch (SecurityException e) {
            Slog.w(TAG, "Can't notify app about channel change", e);
        }
    }

    private void createNotificationChannelGroup(String pkg, int uid, NotificationChannelGroup group, boolean fromApp, boolean fromListener) {
        Preconditions.checkNotNull(group);
        Preconditions.checkNotNull(pkg);
        NotificationChannelGroup preUpdate = this.mPreferencesHelper.getNotificationChannelGroup(group.getId(), pkg, uid);
        this.mPreferencesHelper.createNotificationChannelGroup(pkg, uid, group, fromApp);
        if (!fromApp) {
            this.maybeNotifyChannelGroupOwner(pkg, uid, preUpdate, group);
        }
        if (!fromListener) {
            this.mListeners.notifyNotificationChannelGroupChanged(pkg, UserHandle.of(UserHandle.getCallingUserId()), group, 1);
        }
    }

    private void maybeNotifyChannelGroupOwner(String pkg, int uid, NotificationChannelGroup preUpdate, NotificationChannelGroup update) {
        try {
            if (preUpdate.isBlocked() != update.isBlocked()) {
                this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_CHANNEL_GROUP_BLOCK_STATE_CHANGED").putExtra("android.app.extra.NOTIFICATION_CHANNEL_GROUP_ID", update.getId()).putExtra("android.app.extra.BLOCKED_STATE", update.isBlocked()).addFlags(0x10000000).setPackage(pkg), UserHandle.of(UserHandle.getUserId(uid)), null);
            }
        }
        catch (SecurityException e) {
            Slog.w(TAG, "Can't notify app about group change", e);
        }
    }

    private ArrayList<ComponentName> getSuppressors() {
        ArrayList<ComponentName> names = new ArrayList<ComponentName>();
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            ArraySet<ComponentName> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            for (ComponentName info : serviceInfoList) {
                names.add(info);
            }
        }
        return names;
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info) {
        return this.removeDisabledHints(info, 0);
    }

    private boolean removeDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        boolean removed = false;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ComponentName> listeners = this.mListenersDisablingEffects.valueAt(i);
            if (hints != 0 && (hint & hints) != hint) continue;
            removed |= listeners.remove(info.component);
        }
        return removed;
    }

    private void addDisabledHints(ManagedServices.ManagedServiceInfo info, int hints) {
        if ((hints & 1) != 0) {
            this.addDisabledHint(info, 1);
        }
        if ((hints & 2) != 0) {
            this.addDisabledHint(info, 2);
        }
        if ((hints & 4) != 0) {
            this.addDisabledHint(info, 4);
        }
    }

    private void addDisabledHint(ManagedServices.ManagedServiceInfo info, int hint) {
        if (this.mListenersDisablingEffects.indexOfKey(hint) < 0) {
            this.mListenersDisablingEffects.put(hint, new ArraySet());
        }
        ArraySet<ComponentName> hintListeners = this.mListenersDisablingEffects.get(hint);
        hintListeners.add(info.component);
    }

    private int calculateHints() {
        int hints = 0;
        for (int i = this.mListenersDisablingEffects.size() - 1; i >= 0; --i) {
            int hint = this.mListenersDisablingEffects.keyAt(i);
            ArraySet<ComponentName> serviceInfoList = this.mListenersDisablingEffects.valueAt(i);
            if (serviceInfoList.isEmpty()) continue;
            hints |= hint;
        }
        return hints;
    }

    private long calculateSuppressedEffects() {
        int hints = this.calculateHints();
        long suppressedEffects = 0L;
        if ((hints & 1) != 0) {
            suppressedEffects |= 3L;
        }
        if ((hints & 2) != 0) {
            suppressedEffects |= 1L;
        }
        if ((hints & 4) != 0) {
            suppressedEffects |= 2L;
        }
        return suppressedEffects;
    }

    @GuardedBy(value={"mNotificationLock"})
    private void updateInterruptionFilterLocked() {
        int interruptionFilter = this.mZenModeHelper.getZenModeListenerInterruptionFilter();
        if (interruptionFilter == this.mInterruptionFilter) {
            return;
        }
        this.mInterruptionFilter = interruptionFilter;
        this.scheduleInterruptionFilterChanged(interruptionFilter);
    }

    @VisibleForTesting
    INotificationManager getBinderService() {
        return INotificationManager.Stub.asInterface(this.mService);
    }

    @GuardedBy(value={"mNotificationLock"})
    protected void reportSeen(NotificationRecord r) {
        if (!r.isProxied()) {
            this.mAppUsageStats.reportEvent(r.sbn.getPackageName(), this.getRealUserId(r.sbn.getUserId()), 10);
        }
    }

    protected int calculateSuppressedVisualEffects(NotificationManager.Policy incomingPolicy, NotificationManager.Policy currPolicy, int targetSdkVersion) {
        if (incomingPolicy.suppressedVisualEffects == -1) {
            return incomingPolicy.suppressedVisualEffects;
        }
        int[] effectsIntroducedInP = new int[]{4, 8, 16, 32, 64, 128, 256};
        int newSuppressedVisualEffects = incomingPolicy.suppressedVisualEffects;
        if (targetSdkVersion < 28) {
            for (int i = 0; i < effectsIntroducedInP.length; ++i) {
                newSuppressedVisualEffects &= ~effectsIntroducedInP[i];
                newSuppressedVisualEffects |= currPolicy.suppressedVisualEffects & effectsIntroducedInP[i];
            }
            if ((newSuppressedVisualEffects & 1) != 0) {
                newSuppressedVisualEffects |= 8;
                newSuppressedVisualEffects |= 4;
            }
            if ((newSuppressedVisualEffects & 2) != 0) {
                newSuppressedVisualEffects |= 0x10;
            }
        } else {
            boolean hasNewEffects;
            boolean bl = hasNewEffects = newSuppressedVisualEffects - 2 - 1 > 0;
            if (hasNewEffects) {
                if (((newSuppressedVisualEffects &= 0xFFFFFFFC) & 0x10) != 0) {
                    newSuppressedVisualEffects |= 2;
                }
                if ((newSuppressedVisualEffects & 8) != 0 && (newSuppressedVisualEffects & 4) != 0 && (newSuppressedVisualEffects & 0x80) != 0) {
                    newSuppressedVisualEffects |= 1;
                }
            } else {
                if ((newSuppressedVisualEffects & 1) != 0) {
                    newSuppressedVisualEffects |= 8;
                    newSuppressedVisualEffects |= 4;
                    newSuppressedVisualEffects |= 0x80;
                }
                if ((newSuppressedVisualEffects & 2) != 0) {
                    newSuppressedVisualEffects |= 0x10;
                }
            }
        }
        return newSuppressedVisualEffects;
    }

    @GuardedBy(value={"mNotificationLock"})
    protected void maybeRecordInterruptionLocked(NotificationRecord r) {
        if (r.isInterruptive() && !r.hasRecordedInterruption()) {
            this.mAppUsageStats.reportInterruptiveNotification(r.sbn.getPackageName(), r.getChannel().getId(), this.getRealUserId(r.sbn.getUserId()));
            r.setRecordedInterruption(true);
        }
    }

    protected void reportUserInteraction(NotificationRecord r) {
        this.mAppUsageStats.reportEvent(r.sbn.getPackageName(), this.getRealUserId(r.sbn.getUserId()), 7);
    }

    private int getRealUserId(int userId) {
        return userId == -1 ? 0 : userId;
    }

    @VisibleForTesting
    NotificationManagerInternal getInternalService() {
        return this.mInternalService;
    }

    @VisibleForTesting
    protected void setNotificationAssistantAccessGrantedForUserInternal(ComponentName assistant, int baseUserId, boolean granted) {
        List<UserInfo> users = this.mUm.getEnabledProfiles(baseUserId);
        if (users != null) {
            for (UserInfo user : users) {
                int userId = user.id;
                if (assistant == null) {
                    ComponentName allowedAssistant = CollectionUtils.firstOrNull(this.mAssistants.getAllowedComponents(userId));
                    if (allowedAssistant == null) continue;
                    this.setNotificationAssistantAccessGrantedForUserInternal(allowedAssistant, userId, false);
                    continue;
                }
                if (granted && !this.mAllowedManagedServicePackages.test(assistant.getPackageName(), userId, this.mAssistants.getRequiredPermission())) continue;
                this.mConditionProviders.setPackageOrComponentEnabled(assistant.flattenToString(), userId, false, granted);
                this.mAssistants.setPackageOrComponentEnabled(assistant.flattenToString(), userId, true, granted);
                this.getContext().sendBroadcastAsUser(new Intent("android.app.action.NOTIFICATION_POLICY_ACCESS_GRANTED_CHANGED").setPackage(assistant.getPackageName()).addFlags(0x40000000), UserHandle.of(userId), null);
                this.handleSavePolicyFile();
            }
        }
    }

    private void applyAdjustment(NotificationRecord r, Adjustment adjustment) {
        if (r == null) {
            return;
        }
        if (adjustment.getSignals() != null) {
            Bundle adjustments = adjustment.getSignals();
            Bundle.setDefusable(adjustments, true);
            ArrayList<String> toRemove = new ArrayList<String>();
            for (String potentialKey : adjustments.keySet()) {
                if (this.mAssistants.isAdjustmentAllowed(potentialKey)) continue;
                toRemove.add(potentialKey);
            }
            for (String removeKey : toRemove) {
                adjustments.remove(removeKey);
            }
            r.addAdjustment(adjustment);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    void addAutogroupKeyLocked(String key) {
        NotificationRecord r = this.mNotificationsByKey.get(key);
        if (r == null) {
            return;
        }
        if (r.sbn.getOverrideGroupKey() == null) {
            this.addAutoGroupAdjustment(r, "ranker_group");
            EventLogTags.writeNotificationAutogrouped(key);
            this.mRankingHandler.requestSort();
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    void removeAutogroupKeyLocked(String key) {
        NotificationRecord r = this.mNotificationsByKey.get(key);
        if (r == null) {
            return;
        }
        if (r.sbn.getOverrideGroupKey() != null) {
            this.addAutoGroupAdjustment(r, null);
            EventLogTags.writeNotificationUnautogrouped(key);
            this.mRankingHandler.requestSort();
        }
    }

    private void addAutoGroupAdjustment(NotificationRecord r, String overrideGroupKey) {
        Bundle signals = new Bundle();
        signals.putString("key_group_key", overrideGroupKey);
        Adjustment adjustment = new Adjustment(r.sbn.getPackageName(), r.getKey(), signals, (CharSequence)"", r.sbn.getUserId());
        r.addAdjustment(adjustment);
    }

    @GuardedBy(value={"mNotificationLock"})
    private void clearAutogroupSummaryLocked(int userId, String pkg) {
        NotificationRecord removed;
        ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(userId);
        if (summaries != null && summaries.containsKey(pkg) && (removed = this.findNotificationByKeyLocked(summaries.remove(pkg))) != null) {
            boolean wasPosted = this.removeFromNotificationListsLocked(removed);
            this.cancelNotificationLocked(removed, false, 16, wasPosted, null);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private boolean hasAutoGroupSummaryLocked(StatusBarNotification sbn) {
        ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(sbn.getUserId());
        return summaries != null && summaries.containsKey(sbn.getPackageName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAutoGroupSummary(int userId, String pkg, String triggeringKey) {
        NotificationRecord summaryRecord = null;
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord notificationRecord = this.mNotificationsByKey.get(triggeringKey);
            if (notificationRecord == null) {
                return;
            }
            StatusBarNotification adjustedSbn = notificationRecord.sbn;
            userId = adjustedSbn.getUser().getIdentifier();
            ArrayMap<String, String> summaries = this.mAutobundledSummaries.get(userId);
            if (summaries == null) {
                summaries = new ArrayMap();
            }
            this.mAutobundledSummaries.put(userId, summaries);
            if (!summaries.containsKey(pkg)) {
                ApplicationInfo appInfo = (ApplicationInfo)adjustedSbn.getNotification().extras.getParcelable("android.appInfo");
                Bundle extras = new Bundle();
                extras.putParcelable("android.appInfo", appInfo);
                String channelId = notificationRecord.getChannel().getId();
                Notification summaryNotification = new Notification.Builder(this.getContext(), channelId).setSmallIcon(adjustedSbn.getNotification().getSmallIcon()).setGroupSummary(true).setGroupAlertBehavior(2).setGroup("ranker_group").setFlag(1024, true).setFlag(512, true).setColor(adjustedSbn.getNotification().color).setLocalOnly(true).build();
                summaryNotification.extras.putAll(extras);
                Intent appIntent = this.getContext().getPackageManager().getLaunchIntentForPackage(pkg);
                if (appIntent != null) {
                    summaryNotification.contentIntent = PendingIntent.getActivityAsUser(this.getContext(), 0, appIntent, 0, null, UserHandle.of(userId));
                }
                StatusBarNotification summarySbn = new StatusBarNotification(adjustedSbn.getPackageName(), adjustedSbn.getOpPkg(), Integer.MAX_VALUE, "ranker_group", adjustedSbn.getUid(), adjustedSbn.getInitialPid(), summaryNotification, adjustedSbn.getUser(), "ranker_group", System.currentTimeMillis());
                summaryRecord = new NotificationRecord(this.getContext(), summarySbn, notificationRecord.getChannel());
                summaryRecord.setIsAppImportanceLocked(notificationRecord.getIsAppImportanceLocked());
                summaries.put(pkg, summarySbn.getKey());
            }
        }
        if (summaryRecord != null && this.checkDisqualifyingFeatures(userId, MY_UID, summaryRecord.sbn.getId(), summaryRecord.sbn.getTag(), summaryRecord, true)) {
            this.mHandler.post(new EnqueueNotificationRunnable(userId, summaryRecord));
        }
    }

    private String disableNotificationEffects(NotificationRecord record) {
        if (this.mDisableNotificationEffects) {
            return "booleanState";
        }
        if ((this.mListenerHints & 1) != 0) {
            return "listenerHints";
        }
        if (record != null && record.getAudioAttributes() != null) {
            if ((this.mListenerHints & 2) != 0 && record.getAudioAttributes().getUsage() != 2) {
                return "listenerNoti";
            }
            if ((this.mListenerHints & 4) != 0 && record.getAudioAttributes().getUsage() == 2) {
                return "listenerCall";
            }
        }
        if (this.mCallState != 0 && !this.mZenModeHelper.isCall(record)) {
            return "callState";
        }
        return null;
    }

    private void dumpJson(PrintWriter pw, DumpFilter filter) {
        JSONObject dump = new JSONObject();
        try {
            dump.put("service", "Notification Manager");
            dump.put("bans", this.mPreferencesHelper.dumpBansJson(filter));
            dump.put("ranking", this.mPreferencesHelper.dumpJson(filter));
            dump.put("stats", this.mUsageStats.dumpJson(filter));
            dump.put("channels", this.mPreferencesHelper.dumpChannelsJson(filter));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        pw.println(dump);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpProto(FileDescriptor fd, DumpFilter filter) {
        ProtoOutputStream proto = new ProtoOutputStream(fd);
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord nr;
            int i;
            int N = this.mNotificationList.size();
            for (i = 0; i < N; ++i) {
                nr = this.mNotificationList.get(i);
                if (filter.filtered && !filter.matches(nr.sbn)) continue;
                nr.dump(proto, 2246267895809L, filter.redact, 1);
            }
            N = this.mEnqueuedNotifications.size();
            for (i = 0; i < N; ++i) {
                nr = this.mEnqueuedNotifications.get(i);
                if (filter.filtered && !filter.matches(nr.sbn)) continue;
                nr.dump(proto, 2246267895809L, filter.redact, 0);
            }
            List<NotificationRecord> snoozed = this.mSnoozeHelper.getSnoozed();
            N = snoozed.size();
            for (int i2 = 0; i2 < N; ++i2) {
                NotificationRecord nr2 = snoozed.get(i2);
                if (filter.filtered && !filter.matches(nr2.sbn)) continue;
                nr2.dump(proto, 2246267895809L, filter.redact, 2);
            }
            long zenLog = proto.start(1146756268034L);
            this.mZenModeHelper.dump(proto);
            for (ComponentName suppressor : this.mEffectsSuppressors) {
                suppressor.writeToProto(proto, 2246267895812L);
            }
            proto.end(zenLog);
            long listenersToken = proto.start(1146756268035L);
            this.mListeners.dump(proto, filter);
            proto.end(listenersToken);
            proto.write(1120986464260L, this.mListenerHints);
            for (int i3 = 0; i3 < this.mListenersDisablingEffects.size(); ++i3) {
                long effectsToken = proto.start(2246267895813L);
                proto.write(0x10500000001L, this.mListenersDisablingEffects.keyAt(i3));
                ArraySet<ComponentName> listeners = this.mListenersDisablingEffects.valueAt(i3);
                for (int j = 0; j < listeners.size(); ++j) {
                    ComponentName componentName = listeners.valueAt(j);
                    componentName.writeToProto(proto, 2246267895811L);
                }
                proto.end(effectsToken);
            }
            long assistantsToken = proto.start(1146756268038L);
            this.mAssistants.dump(proto, filter);
            proto.end(assistantsToken);
            long conditionsToken = proto.start(1146756268039L);
            this.mConditionProviders.dump(proto, filter);
            proto.end(conditionsToken);
            long rankingToken = proto.start(1146756268040L);
            this.mRankingHelper.dump(proto, filter);
            this.mPreferencesHelper.dump(proto, filter);
            proto.end(rankingToken);
        }
        proto.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpNotificationRecords(PrintWriter pw, DumpFilter filter) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            int N = this.mNotificationList.size();
            if (N > 0) {
                pw.println("  Notification List:");
                for (int i = 0; i < N; ++i) {
                    NotificationRecord nr = this.mNotificationList.get(i);
                    if (filter.filtered && !filter.matches(nr.sbn)) continue;
                    nr.dump(pw, "    ", this.getContext(), filter.redact);
                }
                pw.println("  ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpImpl(PrintWriter pw, DumpFilter filter) {
        int i;
        int N;
        Object object;
        boolean zenOnly;
        pw.print("Current Notification Manager state");
        if (filter.filtered) {
            pw.print(" (filtered to ");
            pw.print(filter);
            pw.print(")");
        }
        pw.println(':');
        boolean bl = zenOnly = filter.filtered && filter.zen;
        if (!zenOnly) {
            object = this.mToastQueue;
            synchronized (object) {
                N = this.mToastQueue.size();
                if (N > 0) {
                    pw.println("  Toast Queue:");
                    for (i = 0; i < N; ++i) {
                        this.mToastQueue.get(i).dump(pw, "    ", filter);
                    }
                    pw.println("  ");
                }
            }
        }
        object = this.mNotificationLock;
        synchronized (object) {
            if (!zenOnly) {
                if (!filter.normalPriority) {
                    this.dumpNotificationRecords(pw, filter);
                }
                if (!filter.filtered) {
                    N = this.mLights.size();
                    if (N > 0) {
                        pw.println("  Lights List:");
                        for (i = 0; i < N; ++i) {
                            if (i == N - 1) {
                                pw.print("  > ");
                            } else {
                                pw.print("    ");
                            }
                            pw.println(this.mLights.get(i));
                        }
                        pw.println("  ");
                    }
                    pw.println("  mUseAttentionLight=" + this.mUseAttentionLight);
                    pw.println("  mHasLight=" + this.mHasLight);
                    pw.println("  mNotificationPulseEnabled=" + this.mNotificationPulseEnabled);
                    pw.println("  mSoundNotificationKey=" + this.mSoundNotificationKey);
                    pw.println("  mVibrateNotificationKey=" + this.mVibrateNotificationKey);
                    pw.println("  mDisableNotificationEffects=" + this.mDisableNotificationEffects);
                    pw.println("  mCallState=" + NotificationManagerService.callStateToString(this.mCallState));
                    pw.println("  mSystemReady=" + this.mSystemReady);
                    pw.println("  mMaxPackageEnqueueRate=" + this.mMaxPackageEnqueueRate);
                }
                pw.println("  mArchive=" + this.mArchive.toString());
                Iterator<StatusBarNotification> iter = this.mArchive.descendingIterator();
                int j = 0;
                while (iter.hasNext()) {
                    StatusBarNotification sbn = iter.next();
                    if (filter != null && !filter.matches(sbn)) continue;
                    pw.println("    " + sbn);
                    if (++j < 5) continue;
                    if (!iter.hasNext()) break;
                    pw.println("    ...");
                    break;
                }
                if (!zenOnly) {
                    N = this.mEnqueuedNotifications.size();
                    if (N > 0) {
                        pw.println("  Enqueued Notification List:");
                        for (int i2 = 0; i2 < N; ++i2) {
                            NotificationRecord nr = this.mEnqueuedNotifications.get(i2);
                            if (filter.filtered && !filter.matches(nr.sbn)) continue;
                            nr.dump(pw, "    ", this.getContext(), filter.redact);
                        }
                        pw.println("  ");
                    }
                    this.mSnoozeHelper.dump(pw, filter);
                }
            }
            if (!zenOnly) {
                pw.println("\n  Ranking Config:");
                this.mRankingHelper.dump(pw, "    ", filter);
                pw.println("\n Notification Preferences:");
                this.mPreferencesHelper.dump(pw, "    ", filter);
                pw.println("\n  Notification listeners:");
                this.mListeners.dump(pw, filter);
                pw.print("    mListenerHints: ");
                pw.println(this.mListenerHints);
                pw.print("    mListenersDisablingEffects: (");
                N = this.mListenersDisablingEffects.size();
                for (int i3 = 0; i3 < N; ++i3) {
                    int hint = this.mListenersDisablingEffects.keyAt(i3);
                    if (i3 > 0) {
                        pw.print(';');
                    }
                    pw.print("hint[" + hint + "]:");
                    ArraySet<ComponentName> listeners = this.mListenersDisablingEffects.valueAt(i3);
                    int listenerSize = listeners.size();
                    for (int j = 0; j < listenerSize; ++j) {
                        ComponentName listener;
                        if (j > 0) {
                            pw.print(',');
                        }
                        if ((listener = listeners.valueAt(j)) == null) continue;
                        pw.print(listener);
                    }
                }
                pw.println(')');
                pw.println("\n  Notification assistant services:");
                this.mAssistants.dump(pw, filter);
            }
            if (!filter.filtered || zenOnly) {
                pw.println("\n  Zen Mode:");
                pw.print("    mInterruptionFilter=");
                pw.println(this.mInterruptionFilter);
                this.mZenModeHelper.dump(pw, "    ");
                pw.println("\n  Zen Log:");
                ZenLog.dump(pw, "    ");
            }
            pw.println("\n  Condition providers:");
            this.mConditionProviders.dump(pw, filter);
            pw.println("\n  Group summaries:");
            for (Map.Entry<String, NotificationRecord> entry : this.mSummaryByGroupKey.entrySet()) {
                NotificationRecord r = entry.getValue();
                pw.println("    " + entry.getKey() + " -> " + r.getKey());
                if (this.mNotificationsByKey.get(r.getKey()) == r) continue;
                pw.println("!!!!!!LEAK: Record not found in mNotificationsByKey.");
                r.dump(pw, "      ", this.getContext(), filter.redact);
            }
            if (!zenOnly) {
                pw.println("\n  Usage Stats:");
                this.mUsageStats.dump(pw, "    ", filter);
            }
        }
    }

    void enqueueNotificationInternal(String pkg, String opPkg, int callingUid, int callingPid, String tag, int id2, Notification notification, int incomingUserId) {
        int intentCount;
        NotificationChannel channel;
        if (DBG) {
            Slog.v(TAG, "enqueueNotificationInternal: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        if (pkg == null || notification == null) {
            throw new IllegalArgumentException("null not allowed: pkg=" + pkg + " id=" + id2 + " notification=" + notification);
        }
        int userId = ActivityManager.handleIncomingUser(callingPid, callingUid, incomingUserId, true, false, "enqueueNotification", pkg);
        UserHandle user = UserHandle.of(userId);
        int notificationUid = this.resolveNotificationUid(opPkg, pkg, callingUid, userId);
        this.checkRestrictedCategories(notification);
        try {
            this.fixNotification(notification, pkg, userId);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.e(TAG, "Cannot create a context for sending app", e);
            return;
        }
        this.mUsageStats.registerEnqueuedByApp(pkg);
        String channelId = notification.getChannelId();
        if (this.mIsTelevision && new Notification.TvExtender(notification).getChannelId() != null) {
            channelId = new Notification.TvExtender(notification).getChannelId();
        }
        if ((channel = this.mPreferencesHelper.getNotificationChannel(pkg, notificationUid, channelId, false)) == null) {
            boolean appNotificationsOff;
            String noChannelStr = "No Channel found for pkg=" + pkg + ", channelId=" + channelId + ", id=" + id2 + ", tag=" + tag + ", opPkg=" + opPkg + ", callingUid=" + callingUid + ", userId=" + userId + ", incomingUserId=" + incomingUserId + ", notificationUid=" + notificationUid + ", notification=" + notification;
            Slog.e(TAG, noChannelStr);
            boolean bl = appNotificationsOff = this.mPreferencesHelper.getImportance(pkg, notificationUid) == 0;
            if (!appNotificationsOff) {
                this.doChannelWarningToast("Developer warning for package \"" + pkg + "\"\nFailed to post notification on channel \"" + channelId + "\"\nSee log for more details");
            }
            return;
        }
        StatusBarNotification n = new StatusBarNotification(pkg, opPkg, id2, tag, notificationUid, callingPid, notification, user, null, System.currentTimeMillis());
        NotificationRecord r = new NotificationRecord(this.getContext(), n, channel);
        r.setIsAppImportanceLocked(this.mPreferencesHelper.getIsAppImportanceLocked(pkg, callingUid));
        if ((notification.flags & 0x40) != 0) {
            boolean fgServiceShown = channel.isFgServiceShown();
            if (!((channel.getUserLockedFields() & 4) != 0 && fgServiceShown || r.getImportance() != 1 && r.getImportance() != 0)) {
                if (TextUtils.isEmpty(channelId) || "miscellaneous".equals(channelId)) {
                    r.setSystemImportance(2);
                } else {
                    channel.setImportance(2);
                    r.setSystemImportance(2);
                    if (!fgServiceShown) {
                        channel.unlockFields(4);
                        channel.setFgServiceShown(true);
                    }
                    this.mPreferencesHelper.updateNotificationChannel(pkg, notificationUid, channel, false);
                    r.updateNotificationChannel(channel);
                }
            } else if (!(fgServiceShown || TextUtils.isEmpty(channelId) || "miscellaneous".equals(channelId))) {
                channel.setFgServiceShown(true);
                r.updateNotificationChannel(channel);
            }
        }
        if (!this.checkDisqualifyingFeatures(userId, notificationUid, id2, tag, r, r.sbn.getOverrideGroupKey() != null)) {
            return;
        }
        if (notification.allPendingIntents != null && (intentCount = notification.allPendingIntents.size()) > 0) {
            ActivityManagerInternal am = LocalServices.getService(ActivityManagerInternal.class);
            long duration = LocalServices.getService(DeviceIdleController.LocalService.class).getNotificationWhitelistDuration();
            for (int i = 0; i < intentCount; ++i) {
                PendingIntent pendingIntent = notification.allPendingIntents.valueAt(i);
                if (pendingIntent == null) continue;
                am.setPendingIntentWhitelistDuration(pendingIntent.getTarget(), WHITELIST_TOKEN, duration);
                am.setPendingIntentAllowBgActivityStarts(pendingIntent.getTarget(), WHITELIST_TOKEN, 7);
            }
        }
        this.mHandler.post(new EnqueueNotificationRunnable(userId, r));
    }

    @VisibleForTesting
    protected void fixNotification(Notification notification, String pkg, int userId) throws PackageManager.NameNotFoundException {
        int fullscreenIntentPermission;
        ApplicationInfo ai = this.mPackageManagerClient.getApplicationInfoAsUser(pkg, 0x10000000, userId == -1 ? 0 : userId);
        Notification.addFieldsFromContext(ai, notification);
        int canColorize = this.mPackageManagerClient.checkPermission("android.permission.USE_COLORIZED_NOTIFICATIONS", pkg);
        notification.flags = canColorize == 0 ? (notification.flags |= 0x800) : (notification.flags &= 0xFFFFF7FF);
        if (notification.fullScreenIntent != null && ai.targetSdkVersion >= 29 && (fullscreenIntentPermission = this.mPackageManagerClient.checkPermission("android.permission.USE_FULL_SCREEN_INTENT", pkg)) != 0) {
            notification.fullScreenIntent = null;
            Slog.w(TAG, "Package " + pkg + ": Use of fullScreenIntent requires the USE_FULL_SCREEN_INTENT permission");
        }
    }

    private void flagNotificationForBubbles(NotificationRecord r, String pkg, int userId, NotificationRecord oldRecord) {
        Notification notification = r.getNotification();
        notification.flags = this.isNotificationAppropriateToBubble(r, pkg, userId, oldRecord) ? (notification.flags |= 0x1000) : (notification.flags &= 0xFFFFEFFF);
    }

    private boolean isNotificationAppropriateToBubble(NotificationRecord r, String pkg, int userId, NotificationRecord oldRecord) {
        Notification notification = r.getNotification();
        Notification.BubbleMetadata metadata = notification.getBubbleMetadata();
        boolean intentCanBubble = metadata != null && this.canLaunchInActivityView(this.getContext(), metadata.getIntent(), pkg);
        boolean canBubble = intentCanBubble && this.mPreferencesHelper.areBubblesAllowed(pkg, userId) && this.mPreferencesHelper.bubblesEnabled(r.sbn.getUser()) && r.getChannel().canBubble() && !this.mActivityManager.isLowRamDevice();
        boolean appIsForeground = this.mActivityManager.getPackageImportance(pkg) == 100;
        ArrayList peopleList = notification.extras != null ? notification.extras.getParcelableArrayList("android.people.list") : null;
        boolean isForegroundCall = "call".equals(notification.category) && (notification.flags & 0x40) != 0;
        Class<? extends Notification.Style> style2 = notification.getNotificationStyle();
        boolean isMessageStyle = Notification.MessagingStyle.class.equals(style2);
        boolean notificationAppropriateToBubble = isMessageStyle && this.hasValidRemoteInput(notification) || peopleList != null && !peopleList.isEmpty() && isForegroundCall;
        boolean bubbleUpdate = oldRecord != null && (oldRecord.getNotification().flags & 0x1000) != 0;
        return canBubble && (notificationAppropriateToBubble || appIsForeground || bubbleUpdate);
    }

    private boolean hasValidRemoteInput(Notification n) {
        Notification.Action[] actions = n.actions;
        if (actions != null) {
            for (int i = 0; i < actions.length; ++i) {
                Notification.Action action = actions[i];
                RemoteInput[] inputs = action.getRemoteInputs();
                if (inputs == null || inputs.length <= 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected boolean canLaunchInActivityView(Context context, PendingIntent pendingIntent, String packageName) {
        ActivityInfo info;
        Intent intent;
        if (pendingIntent == null) {
            Log.w(TAG, "Unable to create bubble -- no intent");
            return false;
        }
        long token = Binder.clearCallingIdentity();
        try {
            intent = pendingIntent.getIntent();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        ActivityInfo activityInfo = info = intent != null ? intent.resolveActivityInfo(context.getPackageManager(), 0) : null;
        if (info == null) {
            StatsLog.write(173, packageName, 1);
            Log.w(TAG, "Unable to send as bubble -- couldn't find activity info for intent: " + intent);
            return false;
        }
        if (!ActivityInfo.isResizeableMode(info.resizeMode)) {
            StatsLog.write(173, packageName, 2);
            Log.w(TAG, "Unable to send as bubble -- activity is not resizable for intent: " + intent);
            return false;
        }
        if (info.documentLaunchMode != 2) {
            StatsLog.write(173, packageName, 3);
            Log.w(TAG, "Unable to send as bubble -- activity is not documentLaunchMode=always for intent: " + intent);
            return false;
        }
        if ((info.flags & Integer.MIN_VALUE) == 0) {
            Log.w(TAG, "Unable to send as bubble -- activity is not embeddable for intent: " + intent);
            return false;
        }
        return true;
    }

    private void doChannelWarningToast(CharSequence toastText) {
        Binder.withCleanCallingIdentity(() -> {
            boolean warningEnabled;
            int defaultWarningEnabled = Build.IS_DEBUGGABLE ? 1 : 0;
            boolean bl = warningEnabled = Settings.Global.getInt(this.getContext().getContentResolver(), "show_notification_channel_warnings", defaultWarningEnabled) != 0;
            if (warningEnabled) {
                Toast toast = Toast.makeText(this.getContext(), this.mHandler.getLooper(), toastText, 0);
                toast.show();
            }
        });
    }

    @VisibleForTesting
    int resolveNotificationUid(String callingPkg, String targetPkg, int callingUid, int userId) {
        if (userId == -1) {
            userId = 0;
        }
        if (this.isCallerSameApp(targetPkg, callingUid, userId) && (TextUtils.equals(callingPkg, targetPkg) || this.isCallerSameApp(callingPkg, callingUid, userId))) {
            return callingUid;
        }
        int targetUid = -1;
        try {
            targetUid = this.mPackageManagerClient.getPackageUidAsUser(targetPkg, userId);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (targetUid != -1 && (this.isCallerAndroid(callingPkg, callingUid) || this.mPreferencesHelper.isDelegateAllowed(targetPkg, targetUid, callingPkg, callingUid))) {
            return targetUid;
        }
        throw new SecurityException("Caller " + callingPkg + ":" + callingUid + " cannot post for pkg " + targetPkg + " in user " + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDisqualifyingFeatures(int userId, int uid, int id2, String tag, NotificationRecord r, boolean isAutogroup) {
        String pkg = r.sbn.getPackageName();
        boolean isSystemNotification = this.isUidSystemOrPhone(uid) || "android".equals(pkg);
        boolean isNotificationFromListener = this.mListeners.isListenerPackage(pkg);
        if (!isSystemNotification && !isNotificationFromListener) {
            Object object = this.mNotificationLock;
            synchronized (object) {
                float appEnqueueRate;
                int callingUid = Binder.getCallingUid();
                if (this.mNotificationsByKey.get(r.sbn.getKey()) == null && this.isCallerInstantApp(callingUid, userId)) {
                    throw new SecurityException("Instant app " + pkg + " cannot create notifications");
                }
                if (this.mNotificationsByKey.get(r.sbn.getKey()) != null && !r.getNotification().hasCompletedProgress() && !isAutogroup && (appEnqueueRate = this.mUsageStats.getAppEnqueueRate(pkg)) > this.mMaxPackageEnqueueRate) {
                    this.mUsageStats.registerOverRateQuota(pkg);
                    long now = SystemClock.elapsedRealtime();
                    if (now - this.mLastOverRateLogTime > 5000L) {
                        Slog.e(TAG, "Package enqueue rate is " + appEnqueueRate + ". Shedding " + r.sbn.getKey() + ". package=" + pkg);
                        this.mLastOverRateLogTime = now;
                    }
                    return false;
                }
                int count = this.getNotificationCountLocked(pkg, userId, id2, tag);
                if (count >= 25) {
                    this.mUsageStats.registerOverCountQuota(pkg);
                    Slog.e(TAG, "Package has already posted or enqueued " + count + " notifications.  Not showing more.  package=" + pkg);
                    return false;
                }
            }
        }
        if (this.mSnoozeHelper.isSnoozed(userId, pkg, r.getKey())) {
            MetricsLogger.action(r.getLogMaker().setType(6).setCategory(831));
            if (DBG) {
                Slog.d(TAG, "Ignored enqueue for snoozed notification " + r.getKey());
            }
            this.mSnoozeHelper.update(userId, r);
            this.handleSavePolicyFile();
            return false;
        }
        return !this.isBlocked(r, this.mUsageStats);
    }

    @GuardedBy(value={"mNotificationLock"})
    protected int getNotificationCountLocked(String pkg, int userId, int excludedId, String excludedTag) {
        int count = 0;
        int N = this.mNotificationList.size();
        for (int i = 0; i < N; ++i) {
            NotificationRecord existing = this.mNotificationList.get(i);
            if (!existing.sbn.getPackageName().equals(pkg) || existing.sbn.getUserId() != userId || existing.sbn.getId() == excludedId && TextUtils.equals(existing.sbn.getTag(), excludedTag)) continue;
            ++count;
        }
        int M = this.mEnqueuedNotifications.size();
        for (int i = 0; i < M; ++i) {
            NotificationRecord existing = this.mEnqueuedNotifications.get(i);
            if (!existing.sbn.getPackageName().equals(pkg) || existing.sbn.getUserId() != userId) continue;
            ++count;
        }
        return count;
    }

    protected boolean isBlocked(NotificationRecord r, NotificationUsageStats usageStats) {
        if (this.isBlocked(r)) {
            Slog.e(TAG, "Suppressing notification from package by user request.");
            usageStats.registerBlocked(r);
            return true;
        }
        return false;
    }

    private boolean isBlocked(NotificationRecord r) {
        int callingUid;
        String pkg = r.sbn.getPackageName();
        return this.mPreferencesHelper.isGroupBlocked(pkg, callingUid = r.sbn.getUid(), r.getChannel().getGroup()) || this.mPreferencesHelper.getImportance(pkg, callingUid) == 0 || r.getImportance() == 0;
    }

    @GuardedBy(value={"mNotificationLock"})
    private boolean isPackageSuspendedLocked(NotificationRecord r) {
        String pkg = r.sbn.getPackageName();
        int callingUid = r.sbn.getUid();
        return this.isPackageSuspendedForUser(pkg, callingUid);
    }

    @GuardedBy(value={"mNotificationLock"})
    @VisibleForTesting
    protected boolean isVisuallyInterruptive(NotificationRecord old, NotificationRecord r) {
        String newText;
        String newTitle;
        if (r.sbn.isGroup() && r.sbn.getNotification().isGroupSummary()) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is not interruptive: summary");
            }
            return false;
        }
        if (old == null) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: new notification");
            }
            return true;
        }
        if (r == null) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is not interruptive: null");
            }
            return false;
        }
        Notification oldN = old.sbn.getNotification();
        Notification newN = r.sbn.getNotification();
        if (oldN.extras == null || newN.extras == null) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is not interruptive: no extras");
            }
            return false;
        }
        if ((r.sbn.getNotification().flags & 0x40) != 0) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is not interruptive: foreground service");
            }
            return false;
        }
        String oldTitle = String.valueOf(oldN.extras.get("android.title"));
        if (!Objects.equals(oldTitle, newTitle = String.valueOf(newN.extras.get("android.title")))) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: changed title");
                Slog.v(TAG, "INTERRUPTIVENESS: " + String.format("   old title: %s (%s@0x%08x)", oldTitle, oldTitle.getClass(), oldTitle.hashCode()));
                Slog.v(TAG, "INTERRUPTIVENESS: " + String.format("   new title: %s (%s@0x%08x)", newTitle, newTitle.getClass(), newTitle.hashCode()));
            }
            return true;
        }
        String oldText = String.valueOf(oldN.extras.get("android.text"));
        if (!Objects.equals(oldText, newText = String.valueOf(newN.extras.get("android.text")))) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: changed text");
                Slog.v(TAG, "INTERRUPTIVENESS: " + String.format("   old text: %s (%s@0x%08x)", oldText, oldText.getClass(), oldText.hashCode()));
                Slog.v(TAG, "INTERRUPTIVENESS: " + String.format("   new text: %s (%s@0x%08x)", newText, newText.getClass(), newText.hashCode()));
            }
            return true;
        }
        if (oldN.hasCompletedProgress() != newN.hasCompletedProgress()) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: completed progress");
            }
            return true;
        }
        if (Notification.areActionsVisiblyDifferent(oldN, newN)) {
            if (DEBUG_INTERRUPTIVENESS) {
                Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: changed actions");
            }
            return true;
        }
        try {
            Notification.Builder oldB = Notification.Builder.recoverBuilder(this.getContext(), oldN);
            Notification.Builder newB = Notification.Builder.recoverBuilder(this.getContext(), newN);
            if (Notification.areStyledNotificationsVisiblyDifferent(oldB, newB)) {
                if (DEBUG_INTERRUPTIVENESS) {
                    Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: styles differ");
                }
                return true;
            }
            if (Notification.areRemoteViewsChanged(oldB, newB)) {
                if (DEBUG_INTERRUPTIVENESS) {
                    Slog.v(TAG, "INTERRUPTIVENESS: " + r.getKey() + " is interruptive: remoteviews differ");
                }
                return true;
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "error recovering builder", e);
        }
        return false;
    }

    private boolean isCritical(NotificationRecord record) {
        return record.getCriticality() < 2;
    }

    @GuardedBy(value={"mNotificationLock"})
    private void handleGroupedNotificationLocked(NotificationRecord r, NotificationRecord old, int callingUid, int callingPid) {
        NotificationRecord removedSummary;
        boolean oldIsSummary;
        StatusBarNotification sbn = r.sbn;
        Notification n = sbn.getNotification();
        if (n.isGroupSummary() && !sbn.isAppGroup()) {
            n.flags &= 0xFFFFFDFF;
        }
        String group = sbn.getGroupKey();
        boolean isSummary = n.isGroupSummary();
        Notification oldN = old != null ? old.sbn.getNotification() : null;
        String oldGroup = old != null ? old.sbn.getGroupKey() : null;
        boolean bl = oldIsSummary = old != null && oldN.isGroupSummary();
        if (oldIsSummary && (removedSummary = this.mSummaryByGroupKey.remove(oldGroup)) != old) {
            String removedKey = removedSummary != null ? removedSummary.getKey() : "<null>";
            Slog.w(TAG, "Removed summary didn't match old notification: old=" + old.getKey() + ", removed=" + removedKey);
        }
        if (isSummary) {
            this.mSummaryByGroupKey.put(group, r);
        }
        if (!(!oldIsSummary || isSummary && oldGroup.equals(group))) {
            this.cancelGroupChildrenLocked(old, callingUid, callingPid, null, false, null);
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mNotificationLock"})
    void scheduleTimeoutLocked(NotificationRecord record) {
        if (record.getNotification().getTimeoutAfter() > 0L) {
            PendingIntent pi = PendingIntent.getBroadcast(this.getContext(), 1, new Intent(ACTION_NOTIFICATION_TIMEOUT).setData(new Uri.Builder().scheme(SCHEME_TIMEOUT).appendPath(record.getKey()).build()).addFlags(0x10000000).putExtra(EXTRA_KEY, record.getKey()), 0x8000000);
            this.mAlarmManager.setExactAndAllowWhileIdle(2, SystemClock.elapsedRealtime() + record.getNotification().getTimeoutAfter(), pi);
        }
    }

    @VisibleForTesting
    @GuardedBy(value={"mNotificationLock"})
    void buzzBeepBlinkLocked(NotificationRecord record) {
        if (this.mIsAutomotive && !this.mNotificationEffectsEnabledForAutomotive) {
            return;
        }
        boolean buzz = false;
        boolean beep = false;
        boolean blink = false;
        Notification notification = record.sbn.getNotification();
        String key = record.getKey();
        boolean aboveThreshold = this.mIsAutomotive ? record.getImportance() > 3 : record.getImportance() >= 3;
        boolean wasBeep = key != null && key.equals(this.mSoundNotificationKey);
        boolean wasBuzz = key != null && key.equals(this.mVibrateNotificationKey);
        boolean hasValidVibrate = false;
        boolean hasValidSound = false;
        boolean sentAccessibilityEvent = false;
        if (!record.isUpdate && record.getImportance() > 1) {
            this.sendAccessibilityEvent(notification, record.sbn.getPackageName());
            sentAccessibilityEvent = true;
        }
        if (aboveThreshold && this.isNotificationForCurrentUser(record) && this.mSystemReady && this.mAudioManager != null) {
            boolean hasAudibleAlert;
            Uri soundUri = record.getSound();
            hasValidSound = soundUri != null && !Uri.EMPTY.equals(soundUri);
            long[] vibration = record.getVibration();
            if (vibration == null && hasValidSound && this.mAudioManager.getRingerModeInternal() == 1 && this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(record.getAudioAttributes())) == 0) {
                vibration = this.mFallbackVibrationPattern;
            }
            hasValidVibrate = vibration != null;
            boolean bl = hasAudibleAlert = hasValidSound || hasValidVibrate;
            if (hasAudibleAlert && !this.shouldMuteNotificationLocked(record)) {
                boolean ringerModeSilent;
                if (!sentAccessibilityEvent) {
                    this.sendAccessibilityEvent(notification, record.sbn.getPackageName());
                    sentAccessibilityEvent = true;
                }
                if (DBG) {
                    Slog.v(TAG, "Interrupting!");
                }
                if (hasValidSound) {
                    if (this.mInCall) {
                        this.playInCallNotification();
                        beep = true;
                    } else {
                        beep = this.playSound(record, soundUri);
                    }
                    if (beep) {
                        this.mSoundNotificationKey = key;
                    }
                }
                boolean bl2 = ringerModeSilent = this.mAudioManager.getRingerModeInternal() == 0;
                if (!this.mInCall && hasValidVibrate && !ringerModeSilent && (buzz = this.playVibration(record, vibration, hasValidSound))) {
                    this.mVibrateNotificationKey = key;
                }
            } else if ((record.getFlags() & 4) != 0) {
                hasValidSound = false;
            }
        }
        if (wasBeep && !hasValidSound) {
            this.clearSoundLocked();
        }
        if (wasBuzz && !hasValidVibrate) {
            this.clearVibrateLocked();
        }
        boolean wasShowLights = this.mLights.remove(key);
        if (this.canShowLightsLocked(record, aboveThreshold)) {
            this.mLights.add(key);
            this.updateLightsLocked();
            if (this.mUseAttentionLight) {
                this.mAttentionLight.pulse();
            }
            blink = true;
        } else if (wasShowLights) {
            this.updateLightsLocked();
        }
        if (buzz || beep || blink) {
            if (record.sbn.isGroup() && record.sbn.getNotification().isGroupSummary()) {
                if (DEBUG_INTERRUPTIVENESS) {
                    Slog.v(TAG, "INTERRUPTIVENESS: " + record.getKey() + " is not interruptive: summary");
                }
            } else {
                if (DEBUG_INTERRUPTIVENESS) {
                    Slog.v(TAG, "INTERRUPTIVENESS: " + record.getKey() + " is interruptive: alerted");
                }
                record.setInterruptive(true);
            }
            MetricsLogger.action(record.getLogMaker().setCategory(199).setType(1).setSubtype((buzz ? 1 : 0) | (beep ? 2 : 0) | (blink ? 4 : 0)));
            EventLogTags.writeNotificationAlert(key, buzz ? 1 : 0, beep ? 1 : 0, blink ? 1 : 0);
        }
        record.setAudiblyAlerted(buzz || beep);
    }

    @GuardedBy(value={"mNotificationLock"})
    boolean canShowLightsLocked(NotificationRecord record, boolean aboveThreshold) {
        if (!this.mHasLight) {
            return false;
        }
        if (!this.mNotificationPulseEnabled) {
            return false;
        }
        if (record.getLight() == null) {
            return false;
        }
        if (!aboveThreshold) {
            return false;
        }
        if ((record.getSuppressedVisualEffects() & 8) != 0) {
            return false;
        }
        Notification notification = record.getNotification();
        if (record.isUpdate && (notification.flags & 8) != 0) {
            return false;
        }
        if (record.sbn.isGroup() && record.getNotification().suppressAlertingDueToGrouping()) {
            return false;
        }
        return !this.mInCall && !this.mScreenOn;
    }

    @GuardedBy(value={"mNotificationLock"})
    boolean shouldMuteNotificationLocked(NotificationRecord record) {
        Notification notification = record.getNotification();
        if (record.isUpdate && (notification.flags & 8) != 0) {
            return true;
        }
        String disableEffects = this.disableNotificationEffects(record);
        if (disableEffects != null) {
            ZenLog.traceDisableEffects(record, disableEffects);
            return true;
        }
        if (record.isIntercepted()) {
            return true;
        }
        if (record.sbn.isGroup() && notification.suppressAlertingDueToGrouping()) {
            return true;
        }
        String pkg = record.sbn.getPackageName();
        if (this.mUsageStats.isAlertRateLimited(pkg)) {
            Slog.e(TAG, "Muting recently noisy " + record.getKey());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playSound(NotificationRecord record, Uri soundUri) {
        boolean looping;
        boolean bl = looping = (record.getNotification().flags & 4) != 0;
        if (!this.mAudioManager.isAudioFocusExclusive() && this.mAudioManager.getStreamVolume(AudioAttributes.toLegacyStreamType(record.getAudioAttributes())) != 0) {
            long identity = Binder.clearCallingIdentity();
            try {
                IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                if (player != null) {
                    if (DBG) {
                        Slog.v(TAG, "Playing sound " + soundUri + " with attributes " + record.getAudioAttributes());
                    }
                    player.playAsync(soundUri, record.sbn.getUser(), looping, record.getAudioAttributes());
                    boolean bl2 = true;
                    return bl2;
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean playVibration(NotificationRecord record, long[] vibration, boolean delayVibForSound) {
        long identity = Binder.clearCallingIdentity();
        try {
            VibrationEffect effect;
            try {
                boolean insistent = (record.getNotification().flags & 4) != 0;
                effect = VibrationEffect.createWaveform(vibration, insistent ? 0 : -1);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Error creating vibration waveform with pattern: " + Arrays.toString(vibration));
                boolean bl = false;
                Binder.restoreCallingIdentity(identity);
                return bl;
            }
            if (delayVibForSound) {
                new Thread(() -> {
                    int waitMs = this.mAudioManager.getFocusRampTimeMs(3, record.getAudioAttributes());
                    if (DBG) {
                        Slog.v(TAG, "Delaying vibration by " + waitMs + "ms");
                    }
                    try {
                        Thread.sleep(waitMs);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Object object = this.mNotificationLock;
                    synchronized (object) {
                        if (this.mNotificationsByKey.get(record.getKey()) != null) {
                            this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getOpPkg(), effect, "Notification (delayed)", record.getAudioAttributes());
                        } else {
                            Slog.e(TAG, "No vibration for canceled notification : " + record.getKey());
                        }
                    }
                }).start();
            } else {
                this.mVibrator.vibrate(record.sbn.getUid(), record.sbn.getPackageName(), effect, "Notification", record.getAudioAttributes());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNotificationForCurrentUser(NotificationRecord record) {
        int currentUser;
        long token = Binder.clearCallingIdentity();
        try {
            currentUser = ActivityManager.getCurrentUser();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return record.getUserId() == -1 || record.getUserId() == currentUser || this.mUserProfiles.isCurrentProfile(record.getUserId());
    }

    protected void playInCallNotification() {
        if (this.mAudioManager.getRingerModeInternal() == 2 && Settings.Secure.getInt(this.getContext().getContentResolver(), "in_call_notification_enabled", 1) != 0) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        IRingtonePlayer player = NotificationManagerService.this.mAudioManager.getRingtonePlayer();
                        if (player != null) {
                            if (NotificationManagerService.this.mCallNotificationToken != null) {
                                player.stop(NotificationManagerService.this.mCallNotificationToken);
                            }
                            NotificationManagerService.this.mCallNotificationToken = new Binder();
                            player.play(NotificationManagerService.this.mCallNotificationToken, NotificationManagerService.this.mInCallNotificationUri, NotificationManagerService.this.mInCallNotificationAudioAttributes, NotificationManagerService.this.mInCallNotificationVolume, false);
                        }
                    }
                    catch (RemoteException remoteException) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                }
            }.start();
        }
    }

    @GuardedBy(value={"mToastQueue"})
    void showNextToastLocked() {
        ToastRecord record = this.mToastQueue.get(0);
        while (record != null) {
            if (DBG) {
                Slog.d(TAG, "Show pkg=" + record.pkg + " callback=" + record.callback);
            }
            try {
                record.callback.show(record.token);
                this.scheduleDurationReachedLocked(record);
                return;
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Object died trying to show notification " + record.callback + " in package " + record.pkg);
                int index = this.mToastQueue.indexOf(record);
                if (index >= 0) {
                    this.mToastQueue.remove(index);
                }
                this.keepProcessAliveIfNeededLocked(record.pid);
                if (this.mToastQueue.size() > 0) {
                    record = this.mToastQueue.get(0);
                    continue;
                }
                record = null;
            }
        }
    }

    @GuardedBy(value={"mToastQueue"})
    void cancelToastLocked(int index) {
        ToastRecord record = this.mToastQueue.get(index);
        try {
            record.callback.hide();
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Object died trying to hide notification " + record.callback + " in package " + record.pkg);
        }
        ToastRecord lastToast = this.mToastQueue.remove(index);
        this.mWindowManagerInternal.removeWindowToken(lastToast.token, false, lastToast.displayId);
        this.scheduleKillTokenTimeout(lastToast);
        this.keepProcessAliveIfNeededLocked(record.pid);
        if (this.mToastQueue.size() > 0) {
            this.showNextToastLocked();
        }
    }

    void finishTokenLocked(IBinder t, int displayId) {
        this.mHandler.removeCallbacksAndMessages(t);
        this.mWindowManagerInternal.removeWindowToken(t, true, displayId);
    }

    @GuardedBy(value={"mToastQueue"})
    private void scheduleDurationReachedLocked(ToastRecord r) {
        this.mHandler.removeCallbacksAndMessages(r);
        Message m = Message.obtain(this.mHandler, 2, r);
        int delay = r.duration == 1 ? 3500 : 2000;
        delay = this.mAccessibilityManager.getRecommendedTimeoutMillis(delay, 2);
        this.mHandler.sendMessageDelayed(m, delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDurationReached(ToastRecord record) {
        if (DBG) {
            Slog.d(TAG, "Timeout pkg=" + record.pkg + " callback=" + record.callback);
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            int index = this.indexOfToastLocked(record.pkg, record.callback);
            if (index >= 0) {
                this.cancelToastLocked(index);
            }
        }
    }

    @GuardedBy(value={"mToastQueue"})
    private void scheduleKillTokenTimeout(ToastRecord r) {
        this.mHandler.removeCallbacksAndMessages(r);
        Message m = Message.obtain(this.mHandler, 7, r);
        this.mHandler.sendMessageDelayed(m, 11000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKillTokenTimeout(ToastRecord record) {
        if (DBG) {
            Slog.d(TAG, "Kill Token Timeout token=" + record.token);
        }
        ArrayList<ToastRecord> arrayList = this.mToastQueue;
        synchronized (arrayList) {
            this.finishTokenLocked(record.token, record.displayId);
        }
    }

    @GuardedBy(value={"mToastQueue"})
    int indexOfToastLocked(String pkg, ITransientNotification callback) {
        IBinder cbak = callback.asBinder();
        ArrayList<ToastRecord> list = this.mToastQueue;
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ToastRecord r = list.get(i);
            if (!r.pkg.equals(pkg) || r.callback.asBinder() != cbak) continue;
            return i;
        }
        return -1;
    }

    @GuardedBy(value={"mToastQueue"})
    void keepProcessAliveIfNeededLocked(int pid) {
        int toastCount = 0;
        ArrayList<ToastRecord> list = this.mToastQueue;
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ToastRecord r = list.get(i);
            if (r.pid != pid) continue;
            ++toastCount;
        }
        try {
            this.mAm.setProcessImportant(this.mForegroundToken, pid, toastCount > 0, "toast");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRankingReconsideration(Message message) {
        boolean changed;
        if (!(message.obj instanceof RankingReconsideration)) {
            return;
        }
        RankingReconsideration recon = (RankingReconsideration)message.obj;
        recon.run();
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord record = this.mNotificationsByKey.get(recon.getKey());
            if (record == null) {
                return;
            }
            int indexBefore = this.findNotificationRecordIndexLocked(record);
            boolean interceptBefore = record.isIntercepted();
            int visibilityBefore = record.getPackageVisibilityOverride();
            recon.applyChangesLocked(record);
            this.applyZenModeLocked(record);
            this.mRankingHelper.sort(this.mNotificationList);
            int indexAfter = this.findNotificationRecordIndexLocked(record);
            boolean interceptAfter = record.isIntercepted();
            int visibilityAfter = record.getPackageVisibilityOverride();
            boolean bl = changed = indexBefore != indexAfter || interceptBefore != interceptAfter || visibilityBefore != visibilityAfter;
            if (interceptBefore && !interceptAfter && record.isNewEnoughForAlerting(System.currentTimeMillis())) {
                this.buzzBeepBlinkLocked(record);
            }
        }
        if (changed) {
            this.mHandler.scheduleSendRankingUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleRankingSort() {
        if (this.mRankingHelper == null) {
            return;
        }
        Object object = this.mNotificationLock;
        synchronized (object) {
            NotificationRecord r;
            int i;
            int N = this.mNotificationList.size();
            ArrayList<String> orderBefore = new ArrayList<String>(N);
            int[] visibilities = new int[N];
            boolean[] showBadges = new boolean[N];
            boolean[] allowBubbles = new boolean[N];
            ArrayList<NotificationChannel> channelBefore = new ArrayList<NotificationChannel>(N);
            ArrayList<String> groupKeyBefore = new ArrayList<String>(N);
            ArrayList<ArrayList<String>> overridePeopleBefore = new ArrayList<ArrayList<String>>(N);
            ArrayList<ArrayList<SnoozeCriterion>> snoozeCriteriaBefore = new ArrayList<ArrayList<SnoozeCriterion>>(N);
            ArrayList<Integer> userSentimentBefore = new ArrayList<Integer>(N);
            ArrayList<Integer> suppressVisuallyBefore = new ArrayList<Integer>(N);
            ArrayList<ArrayList<Notification.Action>> systemSmartActionsBefore = new ArrayList<ArrayList<Notification.Action>>(N);
            ArrayList<ArrayList<CharSequence>> smartRepliesBefore = new ArrayList<ArrayList<CharSequence>>(N);
            int[] importancesBefore = new int[N];
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                orderBefore.add(r.getKey());
                visibilities[i] = r.getPackageVisibilityOverride();
                showBadges[i] = r.canShowBadge();
                allowBubbles[i] = r.canBubble();
                channelBefore.add(r.getChannel());
                groupKeyBefore.add(r.getGroupKey());
                overridePeopleBefore.add(r.getPeopleOverride());
                snoozeCriteriaBefore.add(r.getSnoozeCriteria());
                userSentimentBefore.add(r.getUserSentiment());
                suppressVisuallyBefore.add(r.getSuppressedVisualEffects());
                systemSmartActionsBefore.add(r.getSystemGeneratedSmartActions());
                smartRepliesBefore.add(r.getSmartReplies());
                importancesBefore[i] = r.getImportance();
                this.mRankingHelper.extractSignals(r);
            }
            this.mRankingHelper.sort(this.mNotificationList);
            for (i = 0; i < N; ++i) {
                r = this.mNotificationList.get(i);
                if (((String)orderBefore.get(i)).equals(r.getKey()) && visibilities[i] == r.getPackageVisibilityOverride() && showBadges[i] == r.canShowBadge() && allowBubbles[i] == r.canBubble() && Objects.equals(channelBefore.get(i), r.getChannel()) && Objects.equals(groupKeyBefore.get(i), r.getGroupKey()) && Objects.equals(overridePeopleBefore.get(i), r.getPeopleOverride()) && Objects.equals(snoozeCriteriaBefore.get(i), r.getSnoozeCriteria()) && Objects.equals(userSentimentBefore.get(i), r.getUserSentiment()) && Objects.equals(suppressVisuallyBefore.get(i), r.getSuppressedVisualEffects()) && Objects.equals(systemSmartActionsBefore.get(i), r.getSystemGeneratedSmartActions()) && Objects.equals(smartRepliesBefore.get(i), r.getSmartReplies()) && importancesBefore[i] == r.getImportance()) continue;
                this.mHandler.scheduleSendRankingUpdate();
                return;
            }
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private void recordCallerLocked(NotificationRecord record) {
        if (this.mZenModeHelper.isCall(record)) {
            this.mZenModeHelper.recordCaller(record);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private void applyZenModeLocked(NotificationRecord record) {
        record.setIntercepted(this.mZenModeHelper.shouldIntercept(record));
        if (record.isIntercepted()) {
            record.setSuppressedVisualEffects(this.mZenModeHelper.getConsolidatedNotificationPolicy().suppressedVisualEffects);
        } else {
            record.setSuppressedVisualEffects(0);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    private int findNotificationRecordIndexLocked(NotificationRecord target) {
        return this.mRankingHelper.indexOf(this.mNotificationList, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendRankingUpdate() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyRankingUpdateLocked(null);
        }
    }

    private void scheduleListenerHintsChanged(int state) {
        this.mHandler.removeMessages(5);
        this.mHandler.obtainMessage(5, state, 0).sendToTarget();
    }

    private void scheduleInterruptionFilterChanged(int listenerInterruptionFilter) {
        this.mHandler.removeMessages(6);
        this.mHandler.obtainMessage(6, listenerInterruptionFilter, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerHintsChanged(int hints) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyListenerHintsChangedLocked(hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleListenerInterruptionFilterChanged(int interruptionFilter) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.mListeners.notifyInterruptionFilterChanged(interruptionFilter);
        }
    }

    private void handleOnPackageChanged(boolean removingPackage, int changeUserId, String[] pkgList, int[] uidList) {
        boolean preferencesChanged = removingPackage;
        this.mListeners.onPackagesChanged(removingPackage, pkgList, uidList);
        this.mAssistants.onPackagesChanged(removingPackage, pkgList, uidList);
        this.mConditionProviders.onPackagesChanged(removingPackage, pkgList, uidList);
        if (preferencesChanged |= this.mPreferencesHelper.onPackagesChanged(removingPackage, changeUserId, pkgList, uidList)) {
            this.handleSavePolicyFile();
        }
    }

    static int clamp(int x, int low, int high) {
        return x < low ? low : (x > high ? high : x);
    }

    void sendAccessibilityEvent(Notification notification, CharSequence packageName) {
        if (!this.mAccessibilityManager.isEnabled()) {
            return;
        }
        AccessibilityEvent event = AccessibilityEvent.obtain(64);
        event.setPackageName(packageName);
        event.setClassName(Notification.class.getName());
        event.setParcelableData(notification);
        CharSequence tickerText = notification.tickerText;
        if (!TextUtils.isEmpty(tickerText)) {
            event.getText().add(tickerText);
        }
        this.mAccessibilityManager.sendAccessibilityEvent(event);
    }

    @GuardedBy(value={"mNotificationLock"})
    private boolean removeFromNotificationListsLocked(NotificationRecord r) {
        boolean wasPosted = false;
        NotificationRecord recordInList = null;
        recordInList = this.findNotificationByListLocked(this.mNotificationList, r.getKey());
        if (recordInList != null) {
            this.mNotificationList.remove(recordInList);
            this.mNotificationsByKey.remove(recordInList.sbn.getKey());
            wasPosted = true;
        }
        while ((recordInList = this.findNotificationByListLocked(this.mEnqueuedNotifications, r.getKey())) != null) {
            this.mEnqueuedNotifications.remove(recordInList);
        }
        return wasPosted;
    }

    @GuardedBy(value={"mNotificationLock"})
    private void cancelNotificationLocked(NotificationRecord r, boolean sendDelete, int reason, boolean wasPosted, String listenerName) {
        this.cancelNotificationLocked(r, sendDelete, reason, -1, -1, wasPosted, listenerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"mNotificationLock"})
    private void cancelNotificationLocked(final NotificationRecord r, boolean sendDelete, int reason, int rank, int count, boolean wasPosted, String listenerName) {
        ArrayMap<String, String> summaries;
        PendingIntent deleteIntent;
        String canceledKey = r.getKey();
        this.recordCallerLocked(r);
        if (r.getStats().getDismissalSurface() == -1) {
            r.recordDismissalSurface(0);
        }
        if (sendDelete && (deleteIntent = r.getNotification().deleteIntent) != null) {
            try {
                LocalServices.getService(ActivityManagerInternal.class).clearPendingIntentAllowBgActivityStarts(deleteIntent.getTarget(), WHITELIST_TOKEN);
                deleteIntent.send();
            }
            catch (PendingIntent.CanceledException ex) {
                Slog.w(TAG, "canceled PendingIntent for " + r.sbn.getPackageName(), ex);
            }
        }
        if (wasPosted) {
            if (r.getNotification().getSmallIcon() != null) {
                if (reason != 18) {
                    r.isCanceled = true;
                }
                this.mListeners.notifyRemovedLocked(r, reason, r.getStats());
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationManagerService.this.mGroupHelper.onNotificationRemoved(r.sbn);
                    }
                });
            }
            if (canceledKey.equals(this.mSoundNotificationKey)) {
                this.mSoundNotificationKey = null;
                long identity = Binder.clearCallingIdentity();
                try {
                    IRingtonePlayer player = this.mAudioManager.getRingtonePlayer();
                    if (player != null) {
                        player.stopAsync();
                    }
                }
                catch (RemoteException player) {
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            if (canceledKey.equals(this.mVibrateNotificationKey)) {
                this.mVibrateNotificationKey = null;
                long identity = Binder.clearCallingIdentity();
                try {
                    this.mVibrator.cancel();
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            this.mLights.remove(canceledKey);
        }
        switch (reason) {
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                this.mUsageStats.registerDismissedByUser(r);
                break;
            }
            case 8: 
            case 9: {
                this.mUsageStats.registerRemovedByApp(r);
            }
        }
        String groupKey = r.getGroupKey();
        NotificationRecord groupSummary = this.mSummaryByGroupKey.get(groupKey);
        if (groupSummary != null && groupSummary.getKey().equals(canceledKey)) {
            this.mSummaryByGroupKey.remove(groupKey);
        }
        if ((summaries = this.mAutobundledSummaries.get(r.sbn.getUserId())) != null && r.sbn.getKey().equals(summaries.get(r.sbn.getPackageName()))) {
            summaries.remove(r.sbn.getPackageName());
        }
        this.mArchive.record(r.sbn);
        long now = System.currentTimeMillis();
        LogMaker logMaker = r.getItemLogMaker().setType(5).setSubtype(reason);
        if (rank != -1 && count != -1) {
            logMaker.addTaggedData(798, rank).addTaggedData(1395, count);
        }
        MetricsLogger.action(logMaker);
        EventLogTags.writeNotificationCanceled(canceledKey, reason, r.getLifespanMs(now), r.getFreshnessMs(now), r.getExposureMs(now), rank, count, listenerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void updateUriPermissions(NotificationRecord newRecord, NotificationRecord oldRecord, String targetPkg, int targetUserId) {
        Uri uri;
        ArraySet<Uri> oldUris;
        String key;
        String string2 = key = newRecord != null ? newRecord.getKey() : oldRecord.getKey();
        if (DBG) {
            Slog.d(TAG, key + ": updating permissions");
        }
        ArraySet<Uri> newUris = newRecord != null ? newRecord.getGrantableUris() : null;
        ArraySet<Uri> arraySet = oldUris = oldRecord != null ? oldRecord.getGrantableUris() : null;
        if (newUris == null && oldUris == null) {
            return;
        }
        IBinder permissionOwner = null;
        if (newRecord != null && permissionOwner == null) {
            permissionOwner = newRecord.permissionOwner;
        }
        if (oldRecord != null && permissionOwner == null) {
            permissionOwner = oldRecord.permissionOwner;
        }
        if (newUris != null && permissionOwner == null) {
            if (DBG) {
                Slog.d(TAG, key + ": creating owner");
            }
            permissionOwner = this.mUgmInternal.newUriPermissionOwner("NOTIF:" + key);
        }
        if (newUris == null && permissionOwner != null) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (DBG) {
                    Slog.d(TAG, key + ": destroying owner");
                }
                this.mUgmInternal.revokeUriPermissionFromOwner(permissionOwner, null, -1, UserHandle.getUserId(oldRecord.getUid()));
                permissionOwner = null;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        if (newUris != null && permissionOwner != null) {
            for (int i = 0; i < newUris.size(); ++i) {
                uri = newUris.valueAt(i);
                if (oldUris != null && oldUris.contains(uri)) continue;
                if (DBG) {
                    Slog.d(TAG, key + ": granting " + uri);
                }
                this.grantUriPermission(permissionOwner, uri, newRecord.getUid(), targetPkg, targetUserId);
            }
        }
        if (oldUris != null && permissionOwner != null) {
            for (int i = 0; i < oldUris.size(); ++i) {
                uri = oldUris.valueAt(i);
                if (newUris != null && newUris.contains(uri)) continue;
                if (DBG) {
                    Slog.d(TAG, key + ": revoking " + uri);
                }
                this.revokeUriPermission(permissionOwner, uri, oldRecord.getUid());
            }
        }
        if (newRecord != null) {
            newRecord.permissionOwner = permissionOwner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantUriPermission(IBinder owner, Uri uri, int sourceUid, String targetPkg, int targetUserId) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgm.grantUriPermissionFromOwner(owner, sourceUid, targetPkg, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)), targetUserId);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeUriPermission(IBinder owner, Uri uri, int sourceUid) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgmInternal.revokeUriPermissionFromOwner(owner, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void cancelNotification(int callingUid, int callingPid, String pkg, String tag, int id2, int mustHaveFlags, int mustNotHaveFlags, boolean sendDelete, int userId, int reason, ManagedServices.ManagedServiceInfo listener) {
        this.cancelNotification(callingUid, callingPid, pkg, tag, id2, mustHaveFlags, mustNotHaveFlags, sendDelete, userId, reason, -1, -1, listener);
    }

    void cancelNotification(int callingUid, int callingPid, String pkg, String tag, int id2, int mustHaveFlags, int mustNotHaveFlags, boolean sendDelete, int userId, int reason, int rank, int count, ManagedServices.ManagedServiceInfo listener) {
        this.mHandler.scheduleCancelNotification(new CancelNotificationRunnable(callingUid, callingPid, pkg, tag, id2, mustHaveFlags, mustNotHaveFlags, sendDelete, userId, reason, rank, count, listener));
    }

    private boolean notificationMatchesUserId(NotificationRecord r, int userId) {
        return userId == -1 || r.getUserId() == -1 || r.getUserId() == userId;
    }

    private boolean notificationMatchesCurrentProfiles(NotificationRecord r, int userId) {
        return this.notificationMatchesUserId(r, userId) || this.mUserProfiles.isCurrentProfile(r.getUserId());
    }

    void cancelAllNotificationsInt(final int callingUid, final int callingPid, final String pkg, final String channelId, final int mustHaveFlags, final int mustNotHaveFlags, final boolean doit, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String listenerName = listener == null ? null : listener.component.toShortString();
                EventLogTags.writeNotificationCancelAll(callingUid, callingPid, pkg, userId, mustHaveFlags, mustNotHaveFlags, reason, listenerName);
                if (!doit) {
                    return;
                }
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    FlagChecker flagChecker = flags -> {
                        if ((flags & mustHaveFlags) != mustHaveFlags) {
                            return false;
                        }
                        return (flags & mustNotHaveFlags) == 0;
                    };
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mNotificationList, callingUid, callingPid, pkg, true, channelId, flagChecker, false, userId, false, reason, listenerName, true);
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mEnqueuedNotifications, callingUid, callingPid, pkg, true, channelId, flagChecker, false, userId, false, reason, listenerName, false);
                    NotificationManagerService.this.mSnoozeHelper.cancel(userId, pkg);
                }
            }
        });
    }

    @GuardedBy(value={"mNotificationLock"})
    private void cancelAllNotificationsByListLocked(ArrayList<NotificationRecord> notificationList, int callingUid, int callingPid, String pkg, boolean nullPkgIndicatesUserSwitch, String channelId, FlagChecker flagChecker, boolean includeCurrentProfiles, int userId, boolean sendDelete, int reason, String listenerName, boolean wasPosted) {
        ArrayList<NotificationRecord> canceledNotifications = null;
        for (int i = notificationList.size() - 1; i >= 0; --i) {
            NotificationRecord r = notificationList.get(i);
            if (!includeCurrentProfiles ? !this.notificationMatchesUserId(r, userId) : !this.notificationMatchesCurrentProfiles(r, userId)) continue;
            if (nullPkgIndicatesUserSwitch && pkg == null && r.getUserId() == -1 || !flagChecker.apply(r.getFlags()) || pkg != null && !r.sbn.getPackageName().equals(pkg) || channelId != null && !channelId.equals(r.getChannel().getId())) continue;
            if (canceledNotifications == null) {
                canceledNotifications = new ArrayList<NotificationRecord>();
            }
            notificationList.remove(i);
            this.mNotificationsByKey.remove(r.getKey());
            r.recordDismissalSentiment(1);
            canceledNotifications.add(r);
            this.cancelNotificationLocked(r, sendDelete, reason, wasPosted, listenerName);
        }
        if (canceledNotifications != null) {
            int M = canceledNotifications.size();
            for (int i = 0; i < M; ++i) {
                this.cancelGroupChildrenLocked((NotificationRecord)canceledNotifications.get(i), callingUid, callingPid, listenerName, false, flagChecker);
            }
            this.updateLightsLocked();
        }
    }

    void snoozeNotificationInt(String key, long duration, String snoozeCriterionId, ManagedServices.ManagedServiceInfo listener) {
        String listenerName;
        String string2 = listenerName = listener == null ? null : listener.component.toShortString();
        if (duration <= 0L && snoozeCriterionId == null || key == null) {
            return;
        }
        if (DBG) {
            Slog.d(TAG, String.format("snooze event(%s, %d, %s, %s)", key, duration, snoozeCriterionId, listenerName));
        }
        this.mHandler.post(new SnoozeNotificationRunnable(key, duration, snoozeCriterionId));
    }

    void unsnoozeNotificationInt(String key, ManagedServices.ManagedServiceInfo listener) {
        String listenerName;
        String string2 = listenerName = listener == null ? null : listener.component.toShortString();
        if (DBG) {
            Slog.d(TAG, String.format("unsnooze event(%s, %s)", key, listenerName));
        }
        this.mSnoozeHelper.repost(key);
        this.handleSavePolicyFile();
    }

    @GuardedBy(value={"mNotificationLock"})
    void cancelAllLocked(final int callingUid, final int callingPid, final int userId, final int reason, final ManagedServices.ManagedServiceInfo listener, final boolean includeCurrentProfiles) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = NotificationManagerService.this.mNotificationLock;
                synchronized (object) {
                    String listenerName = listener == null ? null : listener.component.toShortString();
                    EventLogTags.writeNotificationCancelAll(callingUid, callingPid, null, userId, 0, 0, reason, listenerName);
                    FlagChecker flagChecker = flags -> {
                        int flagsToCheck = 34;
                        if (11 == reason) {
                            flagsToCheck |= 0x1000;
                        }
                        return (flags & flagsToCheck) == 0;
                    };
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mNotificationList, callingUid, callingPid, null, false, null, flagChecker, includeCurrentProfiles, userId, true, reason, listenerName, true);
                    NotificationManagerService.this.cancelAllNotificationsByListLocked(NotificationManagerService.this.mEnqueuedNotifications, callingUid, callingPid, null, false, null, flagChecker, includeCurrentProfiles, userId, true, reason, listenerName, false);
                    NotificationManagerService.this.mSnoozeHelper.cancel(userId, includeCurrentProfiles);
                }
            }
        });
    }

    @GuardedBy(value={"mNotificationLock"})
    private void cancelGroupChildrenLocked(NotificationRecord r, int callingUid, int callingPid, String listenerName, boolean sendDelete, FlagChecker flagChecker) {
        Notification n = r.getNotification();
        if (!n.isGroupSummary()) {
            return;
        }
        String pkg = r.sbn.getPackageName();
        if (pkg == null) {
            if (DBG) {
                Slog.e(TAG, "No package for group summary: " + r.getKey());
            }
            return;
        }
        this.cancelGroupChildrenByListLocked(this.mNotificationList, r, callingUid, callingPid, listenerName, sendDelete, true, flagChecker);
        this.cancelGroupChildrenByListLocked(this.mEnqueuedNotifications, r, callingUid, callingPid, listenerName, sendDelete, false, flagChecker);
    }

    @GuardedBy(value={"mNotificationLock"})
    private void cancelGroupChildrenByListLocked(ArrayList<NotificationRecord> notificationList, NotificationRecord parentNotification, int callingUid, int callingPid, String listenerName, boolean sendDelete, boolean wasPosted, FlagChecker flagChecker) {
        String pkg = parentNotification.sbn.getPackageName();
        int userId = parentNotification.getUserId();
        int reason = 12;
        for (int i = notificationList.size() - 1; i >= 0; --i) {
            NotificationRecord childR = notificationList.get(i);
            StatusBarNotification childSbn = childR.sbn;
            if (!childSbn.isGroup() || childSbn.getNotification().isGroupSummary() || !childR.getGroupKey().equals(parentNotification.getGroupKey()) || (childR.getFlags() & 0x40) != 0 || flagChecker != null && !flagChecker.apply(childR.getFlags())) continue;
            EventLogTags.writeNotificationCancel(callingUid, callingPid, pkg, childSbn.getId(), childSbn.getTag(), userId, 0, 0, 12, listenerName);
            notificationList.remove(i);
            this.mNotificationsByKey.remove(childR.getKey());
            this.cancelNotificationLocked(childR, sendDelete, 12, wasPosted, listenerName);
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    void updateLightsLocked() {
        NotificationRecord ledNotification = null;
        while (ledNotification == null && !this.mLights.isEmpty()) {
            String owner = this.mLights.get(this.mLights.size() - 1);
            ledNotification = this.mNotificationsByKey.get(owner);
            if (ledNotification != null) continue;
            Slog.wtfStack(TAG, "LED Notification does not exist: " + owner);
            this.mLights.remove(owner);
        }
        if (ledNotification == null || this.mInCall || this.mScreenOn) {
            this.mNotificationLight.turnOff();
        } else {
            NotificationRecord.Light light = ledNotification.getLight();
            if (light != null && this.mNotificationPulseEnabled) {
                this.mNotificationLight.setFlashing(light.color, 1, light.onMs, light.offMs);
            }
        }
    }

    @GuardedBy(value={"mNotificationLock"})
    List<NotificationRecord> findGroupNotificationsLocked(String pkg, String groupKey, int userId) {
        ArrayList<NotificationRecord> records = new ArrayList<NotificationRecord>();
        records.addAll(this.findGroupNotificationByListLocked(this.mNotificationList, pkg, groupKey, userId));
        records.addAll(this.findGroupNotificationByListLocked(this.mEnqueuedNotifications, pkg, groupKey, userId));
        return records;
    }

    @GuardedBy(value={"mNotificationLock"})
    private List<NotificationRecord> findGroupNotificationByListLocked(ArrayList<NotificationRecord> list, String pkg, String groupKey, int userId) {
        ArrayList<NotificationRecord> records = new ArrayList<NotificationRecord>();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || !r.getGroupKey().equals(groupKey) || !r.sbn.getPackageName().equals(pkg)) continue;
            records.add(r);
        }
        return records;
    }

    @GuardedBy(value={"mNotificationLock"})
    private NotificationRecord findNotificationByKeyLocked(String key) {
        NotificationRecord r = this.findNotificationByListLocked(this.mNotificationList, key);
        if (r != null) {
            return r;
        }
        r = this.findNotificationByListLocked(this.mEnqueuedNotifications, key);
        if (r != null) {
            return r;
        }
        return null;
    }

    @GuardedBy(value={"mNotificationLock"})
    NotificationRecord findNotificationLocked(String pkg, String tag, int id2, int userId) {
        NotificationRecord r = this.findNotificationByListLocked(this.mNotificationList, pkg, tag, id2, userId);
        if (r != null) {
            return r;
        }
        r = this.findNotificationByListLocked(this.mEnqueuedNotifications, pkg, tag, id2, userId);
        if (r != null) {
            return r;
        }
        return null;
    }

    @GuardedBy(value={"mNotificationLock"})
    private NotificationRecord findNotificationByListLocked(ArrayList<NotificationRecord> list, String pkg, String tag, int id2, int userId) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || r.sbn.getId() != id2 || !TextUtils.equals(r.sbn.getTag(), tag) || !r.sbn.getPackageName().equals(pkg)) continue;
            return r;
        }
        return null;
    }

    @GuardedBy(value={"mNotificationLock"})
    private List<NotificationRecord> findNotificationsByListLocked(ArrayList<NotificationRecord> list, String pkg, String tag, int id2, int userId) {
        ArrayList<NotificationRecord> matching = new ArrayList<NotificationRecord>();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            NotificationRecord r = list.get(i);
            if (!this.notificationMatchesUserId(r, userId) || r.sbn.getId() != id2 || !TextUtils.equals(r.sbn.getTag(), tag) || !r.sbn.getPackageName().equals(pkg)) continue;
            matching.add(r);
        }
        return matching;
    }

    @GuardedBy(value={"mNotificationLock"})
    private NotificationRecord findNotificationByListLocked(ArrayList<NotificationRecord> list, String key) {
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            if (!key.equals(list.get(i).getKey())) continue;
            return list.get(i);
        }
        return null;
    }

    @GuardedBy(value={"mNotificationLock"})
    int indexOfNotificationLocked(String key) {
        int N = this.mNotificationList.size();
        for (int i = 0; i < N; ++i) {
            if (!key.equals(this.mNotificationList.get(i).getKey())) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void hideNotificationsForPackages(String[] pkgs) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            List<String> pkgList = Arrays.asList(pkgs);
            ArrayList<NotificationRecord> changedNotifications = new ArrayList<NotificationRecord>();
            int numNotifications = this.mNotificationList.size();
            for (int i = 0; i < numNotifications; ++i) {
                NotificationRecord rec = this.mNotificationList.get(i);
                if (!pkgList.contains(rec.sbn.getPackageName())) continue;
                rec.setHidden(true);
                changedNotifications.add(rec);
            }
            this.mListeners.notifyHiddenLocked(changedNotifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void unhideNotificationsForPackages(String[] pkgs) {
        Object object = this.mNotificationLock;
        synchronized (object) {
            List<String> pkgList = Arrays.asList(pkgs);
            ArrayList<NotificationRecord> changedNotifications = new ArrayList<NotificationRecord>();
            int numNotifications = this.mNotificationList.size();
            for (int i = 0; i < numNotifications; ++i) {
                NotificationRecord rec = this.mNotificationList.get(i);
                if (!pkgList.contains(rec.sbn.getPackageName())) continue;
                rec.setHidden(false);
                changedNotifications.add(rec);
            }
            this.mListeners.notifyUnhiddenLocked(changedNotifications);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationPulse() {
        Object object = this.mNotificationLock;
        synchronized (object) {
            this.updateLightsLocked();
        }
    }

    protected boolean isCallingUidSystem() {
        int uid = Binder.getCallingUid();
        return uid == 1000;
    }

    protected boolean isUidSystemOrPhone(int uid) {
        int appid = UserHandle.getAppId(uid);
        return appid == 1000 || appid == 1001 || uid == 0;
    }

    protected boolean isCallerSystemOrPhone() {
        return this.isUidSystemOrPhone(Binder.getCallingUid());
    }

    private void checkCallerIsSystemOrShell() {
        if (Binder.getCallingUid() == 2000) {
            return;
        }
        this.checkCallerIsSystem();
    }

    private void checkCallerIsSystem() {
        if (this.isCallerSystemOrPhone()) {
            return;
        }
        throw new SecurityException("Disallowed call for uid " + Binder.getCallingUid());
    }

    private void checkCallerIsSystemOrSystemUiOrShell() {
        if (Binder.getCallingUid() == 2000) {
            return;
        }
        if (this.isCallerSystemOrPhone()) {
            return;
        }
        this.getContext().enforceCallingPermission("android.permission.STATUS_BAR_SERVICE", null);
    }

    private void checkCallerIsSystemOrSameApp(String pkg) {
        if (this.isCallerSystemOrPhone()) {
            return;
        }
        this.checkCallerIsSameApp(pkg);
    }

    private boolean isCallerAndroid(String callingPkg, int uid) {
        return this.isUidSystemOrPhone(uid) && callingPkg != null && "android".equals(callingPkg);
    }

    private void checkRestrictedCategories(Notification notification) {
        block4: {
            try {
                if (!this.mPackageManager.hasSystemFeature("android.hardware.type.automotive", 0)) {
                    return;
                }
            }
            catch (RemoteException re) {
                if (!DBG) break block4;
                Slog.e(TAG, "Unable to confirm if it's safe to skip category restrictions check thus the check will be done anyway");
            }
        }
        if ("car_emergency".equals(notification.category) || "car_warning".equals(notification.category) || "car_information".equals(notification.category)) {
            this.checkCallerIsSystem();
        }
    }

    @VisibleForTesting
    boolean isCallerInstantApp(int callingUid, int userId) {
        if (this.isUidSystemOrPhone(callingUid)) {
            return false;
        }
        if (userId == -1) {
            userId = 0;
        }
        try {
            String[] pkgs = this.mPackageManager.getPackagesForUid(callingUid);
            if (pkgs == null) {
                throw new SecurityException("Unknown uid " + callingUid);
            }
            String pkg = pkgs[0];
            this.mAppOps.checkPackage(callingUid, pkg);
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(pkg, 0, userId);
            if (ai == null) {
                throw new SecurityException("Unknown package " + pkg);
            }
            return ai.isInstantApp();
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown uid " + callingUid, re);
        }
    }

    private void checkCallerIsSameApp(String pkg) {
        this.checkCallerIsSameApp(pkg, Binder.getCallingUid(), UserHandle.getCallingUserId());
    }

    private void checkCallerIsSameApp(String pkg, int uid, int userId) {
        try {
            ApplicationInfo ai = this.mPackageManager.getApplicationInfo(pkg, 0, userId);
            if (ai == null) {
                throw new SecurityException("Unknown package " + pkg);
            }
            if (!UserHandle.isSameApp(ai.uid, uid)) {
                throw new SecurityException("Calling uid " + uid + " gave package " + pkg + " which is owned by uid " + ai.uid);
            }
        }
        catch (RemoteException re) {
            throw new SecurityException("Unknown package " + pkg + "\n" + re);
        }
    }

    private boolean isCallerSameApp(String pkg) {
        try {
            this.checkCallerIsSameApp(pkg);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private boolean isCallerSameApp(String pkg, int uid, int userId) {
        try {
            this.checkCallerIsSameApp(pkg, uid, userId);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static String callStateToString(int state) {
        switch (state) {
            case 0: {
                return "CALL_STATE_IDLE";
            }
            case 1: {
                return "CALL_STATE_RINGING";
            }
            case 2: {
                return "CALL_STATE_OFFHOOK";
            }
        }
        return "CALL_STATE_UNKNOWN_" + state;
    }

    private void listenForCallState() {
        TelephonyManager.from(this.getContext()).listen(new PhoneStateListener(){

            @Override
            public void onCallStateChanged(int state, String incomingNumber) {
                if (NotificationManagerService.this.mCallState == state) {
                    return;
                }
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "Call state changed: " + NotificationManagerService.callStateToString(state));
                }
                NotificationManagerService.this.mCallState = state;
            }
        }, 32);
    }

    @GuardedBy(value={"mNotificationLock"})
    private NotificationRankingUpdate makeRankingUpdateLocked(ManagedServices.ManagedServiceInfo info) {
        int N = this.mNotificationList.size();
        ArrayList<NotificationListenerService.Ranking> rankings = new ArrayList<NotificationListenerService.Ranking>();
        for (int i = 0; i < N; ++i) {
            NotificationRecord record = this.mNotificationList.get(i);
            if (!this.isVisibleToListener(record.sbn, info)) continue;
            String key = record.sbn.getKey();
            NotificationListenerService.Ranking ranking = new NotificationListenerService.Ranking();
            ranking.populate(key, rankings.size(), !record.isIntercepted(), record.getPackageVisibilityOverride(), record.getSuppressedVisualEffects(), record.getImportance(), record.getImportanceExplanation(), record.sbn.getOverrideGroupKey(), record.getChannel(), record.getPeopleOverride(), record.getSnoozeCriteria(), record.canShowBadge(), record.getUserSentiment(), record.isHidden(), record.getLastAudiblyAlertedMs(), record.getSound() != null || record.getVibration() != null, record.getSystemGeneratedSmartActions(), record.getSmartReplies(), record.canBubble());
            rankings.add(ranking);
        }
        return new NotificationRankingUpdate(rankings.toArray(new NotificationListenerService.Ranking[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasCompanionDevice(ManagedServices.ManagedServiceInfo info) {
        if (this.mCompanionManager == null) {
            this.mCompanionManager = this.getCompanionManager();
        }
        if (this.mCompanionManager == null) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<String> associations = this.mCompanionManager.getAssociations(info.component.getPackageName(), info.userid);
            if (!ArrayUtils.isEmpty(associations)) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SecurityException associations) {
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Cannot reach companion device service", re);
        }
        catch (Exception e) {
            Slog.e(TAG, "Cannot verify listener " + info, e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return false;
    }

    protected ICompanionDeviceManager getCompanionManager() {
        return ICompanionDeviceManager.Stub.asInterface(ServiceManager.getService("companiondevice"));
    }

    private boolean isVisibleToListener(StatusBarNotification sbn, ManagedServices.ManagedServiceInfo listener) {
        return listener.enabledAndUserMatches(sbn.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPackageSuspendedForUser(String pkg, int uid) {
        long identity = Binder.clearCallingIdentity();
        int userId = UserHandle.getUserId(uid);
        try {
            boolean bl = this.mPackageManager.isPackageSuspendedForUser(pkg, userId);
            return bl;
        }
        catch (RemoteException re) {
            throw new SecurityException("Could not talk to package manager service");
        }
        catch (IllegalArgumentException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @VisibleForTesting
    boolean canUseManagedServices(String pkg, Integer userId, String requiredPermission) {
        boolean canUseManagedServices = !this.mActivityManager.isLowRamDevice() || this.mPackageManagerClient.hasSystemFeature("android.hardware.type.watch");
        for (String whitelisted : this.getContext().getResources().getStringArray(17235977)) {
            if (!whitelisted.equals(pkg)) continue;
            canUseManagedServices = true;
        }
        if (requiredPermission != null) {
            try {
                if (this.mPackageManager.checkPermission(requiredPermission, pkg, userId) != 0) {
                    canUseManagedServices = false;
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "can't talk to pm", e);
            }
        }
        return canUseManagedServices;
    }

    @VisibleForTesting
    void resetAssistantUserSet(int userId) {
        this.mAssistants.setUserSet(userId, false);
        this.handleSavePolicyFile();
    }

    @VisibleForTesting
    ComponentName getApprovedAssistant(int userId) {
        List<ComponentName> allowedComponents = this.mAssistants.getAllowedComponents(userId);
        return CollectionUtils.firstOrNull(allowedComponents);
    }

    @VisibleForTesting
    protected void simulatePackageSuspendBroadcast(boolean suspend, String pkg) {
        Bundle extras = new Bundle();
        extras.putStringArray("android.intent.extra.changed_package_list", new String[]{pkg});
        String action = suspend ? "android.intent.action.PACKAGES_SUSPENDED" : "android.intent.action.PACKAGES_UNSUSPENDED";
        Intent intent = new Intent(action);
        intent.putExtras(extras);
        this.mPackageIntentReceiver.onReceive(this.getContext(), intent);
    }

    @VisibleForTesting
    protected void simulatePackageDistractionBroadcast(int flag, String[] pkgs) {
        Bundle extras = new Bundle();
        extras.putStringArray("android.intent.extra.changed_package_list", pkgs);
        extras.putInt("android.intent.extra.distraction_restrictions", flag);
        Intent intent = new Intent("android.intent.action.DISTRACTING_PACKAGES_CHANGED");
        intent.putExtras(extras);
        this.mPackageIntentReceiver.onReceive(this.getContext(), intent);
    }

    private void writeSecureNotificationsPolicy(XmlSerializer out) throws IOException {
        out.startTag(null, LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_TAG);
        out.attribute(null, LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_VALUE, Boolean.toString(this.mLockScreenAllowSecureNotifications));
        out.endTag(null, LOCKSCREEN_ALLOW_SECURE_NOTIFICATIONS_TAG);
    }

    private static boolean safeBoolean(String val, boolean defValue) {
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.parseBoolean(val);
    }

    private static final class StatusBarNotificationHolder
    extends IStatusBarNotificationHolder.Stub {
        private StatusBarNotification mValue;

        public StatusBarNotificationHolder(StatusBarNotification value) {
            this.mValue = value;
        }

        @Override
        public StatusBarNotification get() {
            StatusBarNotification value = this.mValue;
            this.mValue = null;
            return value;
        }
    }

    public static final class DumpFilter {
        public boolean filtered = false;
        public String pkgFilter;
        public boolean zen;
        public long since;
        public boolean stats;
        public boolean redact = true;
        public boolean proto = false;
        public boolean criticalPriority = false;
        public boolean normalPriority = false;

        public static DumpFilter parseFromArguments(String[] args) {
            DumpFilter filter = new DumpFilter();
            block8: for (int ai = 0; ai < args.length; ++ai) {
                String a = args[ai];
                if ("--proto".equals(a)) {
                    filter.proto = true;
                    continue;
                }
                if ("--noredact".equals(a) || "--reveal".equals(a)) {
                    filter.redact = false;
                    continue;
                }
                if ("p".equals(a) || "pkg".equals(a) || "--package".equals(a)) {
                    if (ai >= args.length - 1) continue;
                    filter.pkgFilter = args[++ai].trim().toLowerCase();
                    if (filter.pkgFilter.isEmpty()) {
                        filter.pkgFilter = null;
                        continue;
                    }
                    filter.filtered = true;
                    continue;
                }
                if ("--zen".equals(a) || "zen".equals(a)) {
                    filter.filtered = true;
                    filter.zen = true;
                    continue;
                }
                if ("--stats".equals(a)) {
                    filter.stats = true;
                    if (ai < args.length - 1) {
                        filter.since = Long.parseLong(args[++ai]);
                        continue;
                    }
                    filter.since = 0L;
                    continue;
                }
                if (!"--dump-priority".equals(a) || ai >= args.length - 1) continue;
                switch (args[++ai]) {
                    case "CRITICAL": {
                        filter.criticalPriority = true;
                        continue block8;
                    }
                    case "NORMAL": {
                        filter.normalPriority = true;
                    }
                }
            }
            return filter;
        }

        public boolean matches(StatusBarNotification sbn) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : sbn != null && (this.matches(sbn.getPackageName()) || this.matches(sbn.getOpPkg()));
        }

        public boolean matches(ComponentName component) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : component != null && this.matches(component.getPackageName());
        }

        public boolean matches(String pkg) {
            if (!this.filtered) {
                return true;
            }
            return this.zen ? true : pkg != null && pkg.toLowerCase().contains(this.pkgFilter);
        }

        public String toString() {
            return this.stats ? "stats" : (this.zen ? "zen" : '\'' + this.pkgFilter + '\'');
        }
    }

    class RoleObserver
    implements OnRoleHoldersChangedListener {
        private ArrayMap<String, ArrayMap<Integer, ArraySet<String>>> mNonBlockableDefaultApps;
        private final RoleManager mRm;
        private final IPackageManager mPm;
        private final Executor mExecutor;

        RoleObserver(RoleManager roleManager, IPackageManager pkgMgr, Executor executor) {
            this.mRm = roleManager;
            this.mPm = pkgMgr;
            this.mExecutor = executor;
        }

        public void init() {
            List<UserInfo> users = NotificationManagerService.this.mUm.getUsers();
            this.mNonBlockableDefaultApps = new ArrayMap();
            for (int i = 0; i < NON_BLOCKABLE_DEFAULT_ROLES.length; ++i) {
                ArrayMap<Integer, ArraySet<String>> userToApprovedList = new ArrayMap<Integer, ArraySet<String>>();
                this.mNonBlockableDefaultApps.put(NON_BLOCKABLE_DEFAULT_ROLES[i], userToApprovedList);
                for (int j = 0; j < users.size(); ++j) {
                    Integer userId = users.get(j).getUserHandle().getIdentifier();
                    ArraySet<String> approvedForUserId = new ArraySet<String>(this.mRm.getRoleHoldersAsUser(NON_BLOCKABLE_DEFAULT_ROLES[i], UserHandle.of(userId)));
                    ArraySet<Pair<String, Integer>> approvedAppUids = new ArraySet<Pair<String, Integer>>();
                    for (String pkg : approvedForUserId) {
                        approvedAppUids.add(new Pair<String, Integer>(pkg, this.getUidForPackage(pkg, userId)));
                    }
                    userToApprovedList.put(userId, approvedForUserId);
                    NotificationManagerService.this.mPreferencesHelper.updateDefaultApps(userId, null, approvedAppUids);
                }
            }
            this.mRm.addOnRoleHoldersChangedListenerAsUser(this.mExecutor, this, UserHandle.ALL);
        }

        @VisibleForTesting
        public boolean isApprovedPackageForRoleForUser(String role, String pkg, int userId) {
            return this.mNonBlockableDefaultApps.get(role).get(userId).contains(pkg);
        }

        @Override
        public void onRoleHoldersChanged(String roleName, UserHandle user) {
            boolean relevantChange = false;
            for (int i = 0; i < NON_BLOCKABLE_DEFAULT_ROLES.length; ++i) {
                if (!NON_BLOCKABLE_DEFAULT_ROLES[i].equals(roleName)) continue;
                relevantChange = true;
                break;
            }
            if (!relevantChange) {
                return;
            }
            ArraySet<String> roleHolders = new ArraySet<String>(this.mRm.getRoleHoldersAsUser(roleName, user));
            ArrayMap prevApprovedForRole = this.mNonBlockableDefaultApps.getOrDefault(roleName, new ArrayMap());
            ArraySet previouslyApproved = prevApprovedForRole.getOrDefault(user.getIdentifier(), new ArraySet());
            ArraySet<String> toRemove = new ArraySet<String>();
            ArraySet<Pair<String, Integer>> toAdd = new ArraySet<Pair<String, Integer>>();
            for (String previous : previouslyApproved) {
                if (roleHolders.contains(previous)) continue;
                toRemove.add(previous);
            }
            for (String nowApproved : roleHolders) {
                if (previouslyApproved.contains(nowApproved)) continue;
                toAdd.add(new Pair<String, Integer>(nowApproved, this.getUidForPackage(nowApproved, user.getIdentifier())));
            }
            prevApprovedForRole.put(user.getIdentifier(), roleHolders);
            this.mNonBlockableDefaultApps.put(roleName, prevApprovedForRole);
            NotificationManagerService.this.mPreferencesHelper.updateDefaultApps(user.getIdentifier(), toRemove, toAdd);
        }

        private int getUidForPackage(String pkg, int userId) {
            try {
                return this.mPm.getPackageUid(pkg, 131072, userId);
            }
            catch (RemoteException e) {
                Slog.e(NotificationManagerService.TAG, "role manager has bad default " + pkg + " " + userId);
                return -1;
            }
        }
    }

    public class NotificationListeners
    extends ManagedServices {
        static final String TAG_ENABLED_NOTIFICATION_LISTENERS = "enabled_listeners";
        private final ArraySet<ManagedServices.ManagedServiceInfo> mLightTrimListeners;

        public NotificationListeners(IPackageManager pm) {
            super(NotificationManagerService.this.getContext(), NotificationManagerService.this.mNotificationLock, NotificationManagerService.this.mUserProfiles, pm);
            this.mLightTrimListeners = new ArraySet();
        }

        @Override
        protected int getBindFlags() {
            return 0x5000101;
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification listener";
            c.serviceInterface = "android.service.notification.NotificationListenerService";
            c.xmlTag = TAG_ENABLED_NOTIFICATION_LISTENERS;
            c.secureSettingName = "enabled_notification_listeners";
            c.bindPermission = "android.permission.BIND_NOTIFICATION_LISTENER_SERVICE";
            c.settingsAction = "android.settings.ACTION_NOTIFICATION_LISTENER_SETTINGS";
            c.clientLabel = 17040513;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationRankingUpdate update;
            INotificationListener listener = (INotificationListener)info.service;
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                update = NotificationManagerService.this.makeRankingUpdateLocked(info);
            }
            try {
                listener.onListenerConnected(update);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        @Override
        @GuardedBy(value={"mNotificationLock"})
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            if (NotificationManagerService.this.removeDisabledHints(removed)) {
                NotificationManagerService.this.updateListenerHintsLocked();
                NotificationManagerService.this.updateEffectsSuppressorLocked();
            }
            this.mLightTrimListeners.remove(removed);
        }

        @Override
        protected String getRequiredPermission() {
            return null;
        }

        @GuardedBy(value={"mNotificationLock"})
        public void setOnNotificationPostedTrimLocked(ManagedServices.ManagedServiceInfo info, int trim) {
            if (trim == 1) {
                this.mLightTrimListeners.add(info);
            } else {
                this.mLightTrimListeners.remove(info);
            }
        }

        public int getOnNotificationPostedTrim(ManagedServices.ManagedServiceInfo info) {
            return this.mLightTrimListeners.contains(info) ? 1 : 0;
        }

        public void onStatusBarIconsBehaviorChanged(boolean hideSilentStatusIcons) {
            for (ManagedServices.ManagedServiceInfo info : this.getServices()) {
                NotificationManagerService.this.mHandler.post(() -> {
                    INotificationListener listener = (INotificationListener)info.service;
                    try {
                        listener.onStatusBarIconsBehaviorChanged(hideSilentStatusIcons);
                    }
                    catch (RemoteException ex) {
                        Slog.e(this.TAG, "unable to notify listener (hideSilentStatusIcons): " + listener, ex);
                    }
                });
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyPostedLocked(NotificationRecord r, NotificationRecord old) {
            this.notifyPostedLocked(r, old, true);
        }

        @GuardedBy(value={"mNotificationLock"})
        private void notifyPostedLocked(NotificationRecord r, NotificationRecord old, boolean notifyAllListeners) {
            StatusBarNotification sbn = r.sbn;
            StatusBarNotification oldSbn = old != null ? old.sbn : null;
            TrimCache trimCache = new TrimCache(sbn);
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                boolean oldSbnVisible;
                boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info);
                boolean bl = oldSbnVisible = oldSbn != null ? NotificationManagerService.this.isVisibleToListener(oldSbn, info) : false;
                if (!oldSbnVisible && !sbnVisible || r.isHidden() && info.targetSdkVersion < 28 || !notifyAllListeners && info.targetSdkVersion >= 28) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                if (oldSbnVisible && !sbnVisible) {
                    final StatusBarNotification oldSbnLightClone = oldSbn.cloneLight();
                    NotificationManagerService.this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            NotificationListeners.this.notifyRemoved(info, oldSbnLightClone, update, null, 6);
                        }
                    });
                    continue;
                }
                int targetUserId = info.userid == -1 ? 0 : info.userid;
                NotificationManagerService.this.updateUriPermissions(r, old, info.component.getPackageName(), targetUserId);
                final StatusBarNotification sbnToPost = trimCache.ForListener(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyPosted(info, sbnToPost, update);
                    }
                });
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyRemovedLocked(NotificationRecord r, final int reason, NotificationStats notificationStats) {
            StatusBarNotification sbn = r.sbn;
            final StatusBarNotification sbnLight = sbn.cloneLight();
            for (final ManagedServices.ManagedServiceInfo info : this.getServices()) {
                if (!NotificationManagerService.this.isVisibleToListener(sbn, info) || r.isHidden() && reason != 14 && info.targetSdkVersion < 28 || reason == 14 && info.targetSdkVersion >= 28) continue;
                final NotificationStats stats = NotificationManagerService.this.mAssistants.isServiceTokenValidLocked(info.service) ? notificationStats : null;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(info);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRemoved(info, sbnLight, update, stats, reason);
                    }
                });
            }
            NotificationManagerService.this.mHandler.post(() -> NotificationManagerService.this.updateUriPermissions(null, r, null, 0));
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyRankingUpdateLocked(List<NotificationRecord> changedHiddenNotifications) {
            boolean isHiddenRankingUpdate = changedHiddenNotifications != null && changedHiddenNotifications.size() > 0;
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                boolean notifyThisListener = false;
                if (isHiddenRankingUpdate && serviceInfo.targetSdkVersion >= 28) {
                    for (NotificationRecord rec : changedHiddenNotifications) {
                        if (!NotificationManagerService.this.isVisibleToListener(rec.sbn, serviceInfo)) continue;
                        notifyThisListener = true;
                        break;
                    }
                }
                if (!notifyThisListener && isHiddenRankingUpdate) continue;
                final NotificationRankingUpdate update = NotificationManagerService.this.makeRankingUpdateLocked(serviceInfo);
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyRankingUpdate(serviceInfo, update);
                    }
                });
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyListenerHintsChangedLocked(final int hints) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyListenerHintsChanged(serviceInfo, hints);
                    }
                });
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyHiddenLocked(List<NotificationRecord> changedNotifications) {
            if (changedNotifications == null || changedNotifications.size() == 0) {
                return;
            }
            this.notifyRankingUpdateLocked(changedNotifications);
            int numChangedNotifications = changedNotifications.size();
            for (int i = 0; i < numChangedNotifications; ++i) {
                NotificationRecord rec = changedNotifications.get(i);
                NotificationManagerService.this.mListeners.notifyRemovedLocked(rec, 14, rec.getStats());
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        public void notifyUnhiddenLocked(List<NotificationRecord> changedNotifications) {
            if (changedNotifications == null || changedNotifications.size() == 0) {
                return;
            }
            this.notifyRankingUpdateLocked(changedNotifications);
            int numChangedNotifications = changedNotifications.size();
            for (int i = 0; i < numChangedNotifications; ++i) {
                NotificationRecord rec = changedNotifications.get(i);
                NotificationManagerService.this.mListeners.notifyPostedLocked(rec, rec, false);
            }
        }

        public void notifyInterruptionFilterChanged(final int interruptionFilter) {
            for (final ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.isEnabledForCurrentProfiles()) continue;
                NotificationManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        NotificationListeners.this.notifyInterruptionFilterChanged(serviceInfo, interruptionFilter);
                    }
                });
            }
        }

        protected void notifyNotificationChannelChanged(String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
            if (channel == null) {
                return;
            }
            for (ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.enabledAndUserMatches(UserHandle.getCallingUserId())) continue;
                BackgroundThread.getHandler().post(() -> {
                    if (NotificationManagerService.this.hasCompanionDevice(serviceInfo)) {
                        this.notifyNotificationChannelChanged(serviceInfo, pkg, user, channel, modificationType);
                    }
                });
            }
        }

        protected void notifyNotificationChannelGroupChanged(String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
            if (group == null) {
                return;
            }
            for (ManagedServices.ManagedServiceInfo serviceInfo : this.getServices()) {
                if (!serviceInfo.enabledAndUserMatches(UserHandle.getCallingUserId())) continue;
                BackgroundThread.getHandler().post(() -> {
                    if (NotificationManagerService.this.hasCompanionDevice(serviceInfo)) {
                        this.notifyNotificationChannelGroupChanged(serviceInfo, pkg, user, group, modificationType);
                    }
                });
            }
        }

        private void notifyPosted(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationPosted(sbnHolder, rankingUpdate);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (posted): " + listener, ex);
            }
        }

        private void notifyRemoved(ManagedServices.ManagedServiceInfo info, StatusBarNotification sbn, NotificationRankingUpdate rankingUpdate, NotificationStats stats, int reason) {
            if (!info.enabledAndUserMatches(sbn.getUserId())) {
                return;
            }
            INotificationListener listener = (INotificationListener)info.service;
            StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbn);
            try {
                listener.onNotificationRemoved(sbnHolder, rankingUpdate, stats, reason);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (removed): " + listener, ex);
            }
        }

        private void notifyRankingUpdate(ManagedServices.ManagedServiceInfo info, NotificationRankingUpdate rankingUpdate) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationRankingUpdate(rankingUpdate);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (ranking update): " + listener, ex);
            }
        }

        private void notifyListenerHintsChanged(ManagedServices.ManagedServiceInfo info, int hints) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onListenerHintsChanged(hints);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (listener hints): " + listener, ex);
            }
        }

        private void notifyInterruptionFilterChanged(ManagedServices.ManagedServiceInfo info, int interruptionFilter) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onInterruptionFilterChanged(interruptionFilter);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (interruption filter): " + listener, ex);
            }
        }

        void notifyNotificationChannelChanged(ManagedServices.ManagedServiceInfo info, String pkg, UserHandle user, NotificationChannel channel, int modificationType) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationChannelModification(pkg, user, channel, modificationType);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (channel changed): " + listener, ex);
            }
        }

        private void notifyNotificationChannelGroupChanged(ManagedServices.ManagedServiceInfo info, String pkg, UserHandle user, NotificationChannelGroup group, int modificationType) {
            INotificationListener listener = (INotificationListener)info.service;
            try {
                listener.onNotificationChannelGroupModification(pkg, user, group, modificationType);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify listener (channel group changed): " + listener, ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean isListenerPackage(String packageName) {
            if (packageName == null) {
                return false;
            }
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                ManagedServices.ManagedServiceInfo serviceInfo;
                Iterator<ManagedServices.ManagedServiceInfo> iterator = this.getServices().iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    serviceInfo = iterator.next();
                } while (!packageName.equals(serviceInfo.component.getPackageName()));
                return true;
            }
        }
    }

    public class NotificationAssistants
    extends ManagedServices {
        static final String TAG_ENABLED_NOTIFICATION_ASSISTANTS = "enabled_assistants";
        private static final String ATT_USER_SET = "user_set";
        private static final String TAG_ALLOWED_ADJUSTMENT_TYPES = "q_allowed_adjustments";
        private static final String ATT_TYPES = "types";
        private final Object mLock;
        @GuardedBy(value={"mLock"})
        private ArrayMap<Integer, Boolean> mUserSetMap;
        private Set<String> mAllowedAdjustments;

        public NotificationAssistants(Context context, Object lock, ManagedServices.UserProfiles up, IPackageManager pm) {
            super(context, lock, up, pm);
            this.mLock = new Object();
            this.mUserSetMap = new ArrayMap();
            this.mAllowedAdjustments = new ArraySet<String>();
            for (int i = 0; i < DEFAULT_ALLOWED_ADJUSTMENTS.length; ++i) {
                this.mAllowedAdjustments.add(DEFAULT_ALLOWED_ADJUSTMENTS[i]);
            }
        }

        @Override
        protected ManagedServices.Config getConfig() {
            ManagedServices.Config c = new ManagedServices.Config();
            c.caption = "notification assistant";
            c.serviceInterface = "android.service.notification.NotificationAssistantService";
            c.xmlTag = TAG_ENABLED_NOTIFICATION_ASSISTANTS;
            c.secureSettingName = "enabled_notification_assistant";
            c.bindPermission = "android.permission.BIND_NOTIFICATION_ASSISTANT_SERVICE";
            c.settingsAction = "android.settings.MANAGE_DEFAULT_APPS_SETTINGS";
            c.clientLabel = 17040515;
            return c;
        }

        @Override
        protected IInterface asInterface(IBinder binder) {
            return INotificationListener.Stub.asInterface(binder);
        }

        @Override
        protected boolean checkType(IInterface service) {
            return service instanceof INotificationListener;
        }

        @Override
        protected void onServiceAdded(ManagedServices.ManagedServiceInfo info) {
            NotificationManagerService.this.mListeners.registerGuestService(info);
        }

        @Override
        @GuardedBy(value={"mNotificationLock"})
        protected void onServiceRemovedLocked(ManagedServices.ManagedServiceInfo removed) {
            NotificationManagerService.this.mListeners.unregisterService(removed.service, removed.userid);
        }

        @Override
        public void onUserUnlocked(int user) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "onUserUnlocked u=" + user);
            }
            this.rebindServices(true, user);
        }

        @Override
        protected String getRequiredPermission() {
            return "android.permission.REQUEST_NOTIFICATION_ASSISTANT_SERVICE";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeExtraXmlTags(XmlSerializer out) throws IOException {
            Object object = this.mLock;
            synchronized (object) {
                out.startTag(null, TAG_ALLOWED_ADJUSTMENT_TYPES);
                out.attribute(null, ATT_TYPES, TextUtils.join((CharSequence)",", this.mAllowedAdjustments));
                out.endTag(null, TAG_ALLOWED_ADJUSTMENT_TYPES);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void readExtraTag(String tag, XmlPullParser parser) throws IOException {
            if (TAG_ALLOWED_ADJUSTMENT_TYPES.equals(tag)) {
                String types = XmlUtils.readStringAttribute(parser, ATT_TYPES);
                Object object = this.mLock;
                synchronized (object) {
                    this.mAllowedAdjustments.clear();
                    if (!TextUtils.isEmpty(types)) {
                        this.mAllowedAdjustments.addAll(Arrays.asList(types.split(",")));
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void allowAdjustmentType(String type) {
            Iterator<ManagedServices.ManagedServiceInfo> iterator = this.mLock;
            synchronized (iterator) {
                this.mAllowedAdjustments.add(type);
            }
            for (ManagedServices.ManagedServiceInfo info : this.getServices()) {
                NotificationManagerService.this.mHandler.post(() -> this.notifyCapabilitiesChanged(info));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void disallowAdjustmentType(String type) {
            Iterator<ManagedServices.ManagedServiceInfo> iterator = this.mLock;
            synchronized (iterator) {
                this.mAllowedAdjustments.remove(type);
            }
            for (ManagedServices.ManagedServiceInfo info : this.getServices()) {
                NotificationManagerService.this.mHandler.post(() -> this.notifyCapabilitiesChanged(info));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<String> getAllowedAssistantAdjustments() {
            Object object = this.mLock;
            synchronized (object) {
                ArrayList<String> types = new ArrayList<String>();
                types.addAll(this.mAllowedAdjustments);
                return types;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isAdjustmentAllowed(String type) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mAllowedAdjustments.contains(type);
            }
        }

        protected void onNotificationsSeenLocked(ArrayList<NotificationRecord> records) {
            for (ManagedServices.ManagedServiceInfo info : this.getServices()) {
                ArrayList<String> keys = new ArrayList<String>(records.size());
                for (NotificationRecord r : records) {
                    boolean sbnVisible = NotificationManagerService.this.isVisibleToListener(r.sbn, info) && info.isSameUser(r.getUserId());
                    if (!sbnVisible) continue;
                    keys.add(r.getKey());
                }
                if (keys.isEmpty()) continue;
                NotificationManagerService.this.mHandler.post(() -> this.notifySeen(info, keys));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean hasUserSet(int userId) {
            Object object = this.mLock;
            synchronized (object) {
                return this.mUserSetMap.getOrDefault(userId, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setUserSet(int userId, boolean set) {
            Object object = this.mLock;
            synchronized (object) {
                this.mUserSetMap.put(userId, set);
            }
        }

        @Override
        protected void writeExtraAttributes(XmlSerializer out, int userId) throws IOException {
            out.attribute(null, ATT_USER_SET, Boolean.toString(this.hasUserSet(userId)));
        }

        @Override
        protected void readExtraAttributes(String tag, XmlPullParser parser, int userId) throws IOException {
            boolean userSet = XmlUtils.readBooleanAttribute(parser, ATT_USER_SET, false);
            this.setUserSet(userId, userSet);
        }

        private void notifyCapabilitiesChanged(ManagedServices.ManagedServiceInfo info) {
            INotificationListener assistant = (INotificationListener)info.service;
            try {
                assistant.onAllowedAdjustmentsChanged();
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify assistant (capabilities): " + assistant, ex);
            }
        }

        private void notifySeen(ManagedServices.ManagedServiceInfo info, ArrayList<String> keys) {
            INotificationListener assistant = (INotificationListener)info.service;
            try {
                assistant.onNotificationsSeen(keys);
            }
            catch (RemoteException ex) {
                Slog.e(this.TAG, "unable to notify assistant (seen): " + assistant, ex);
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        private void onNotificationEnqueuedLocked(NotificationRecord r) {
            boolean debug = this.isVerboseLogEnabled();
            if (debug) {
                Slog.v(this.TAG, "onNotificationEnqueuedLocked() called with: r = [" + r + "]");
            }
            StatusBarNotification sbn = r.sbn;
            this.notifyAssistantLocked(sbn, true, (assistant, sbnHolder) -> {
                try {
                    if (debug) {
                        Slog.v(this.TAG, "calling onNotificationEnqueuedWithChannel " + sbnHolder);
                    }
                    assistant.onNotificationEnqueuedWithChannel((IStatusBarNotificationHolder)sbnHolder, r.getChannel());
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (enqueued): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        void notifyAssistantExpansionChangedLocked(StatusBarNotification sbn, boolean isUserAction, boolean isExpanded) {
            String key = sbn.getKey();
            this.notifyAssistantLocked(sbn, false, (assistant, sbnHolder) -> {
                try {
                    assistant.onNotificationExpansionChanged(key, isUserAction, isExpanded);
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (expanded): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        void notifyAssistantNotificationDirectReplyLocked(StatusBarNotification sbn) {
            String key = sbn.getKey();
            this.notifyAssistantLocked(sbn, false, (assistant, sbnHolder) -> {
                try {
                    assistant.onNotificationDirectReply(key);
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (expanded): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        void notifyAssistantSuggestedReplySent(StatusBarNotification sbn, CharSequence reply, boolean generatedByAssistant) {
            String key = sbn.getKey();
            this.notifyAssistantLocked(sbn, false, (assistant, sbnHolder) -> {
                try {
                    assistant.onSuggestedReplySent(key, reply, generatedByAssistant ? 1 : 0);
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (snoozed): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        void notifyAssistantActionClicked(StatusBarNotification sbn, int actionIndex, Notification.Action action, boolean generatedByAssistant) {
            String key = sbn.getKey();
            this.notifyAssistantLocked(sbn, false, (assistant, sbnHolder) -> {
                try {
                    assistant.onActionClicked(key, action, generatedByAssistant ? 1 : 0);
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (snoozed): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        private void notifyAssistantSnoozedLocked(StatusBarNotification sbn, String snoozeCriterionId) {
            this.notifyAssistantLocked(sbn, false, (assistant, sbnHolder) -> {
                try {
                    assistant.onNotificationSnoozedUntilContext((IStatusBarNotificationHolder)sbnHolder, snoozeCriterionId);
                }
                catch (RemoteException ex) {
                    Slog.e(this.TAG, "unable to notify assistant (snoozed): " + assistant, ex);
                }
            });
        }

        @GuardedBy(value={"mNotificationLock"})
        private void notifyAssistantLocked(StatusBarNotification sbn, boolean sameUserOnly, BiConsumer<INotificationListener, StatusBarNotificationHolder> callback) {
            TrimCache trimCache = new TrimCache(sbn);
            boolean debug = this.isVerboseLogEnabled();
            if (debug) {
                Slog.v(this.TAG, "notifyAssistantLocked() called with: sbn = [" + sbn + "], sameUserOnly = [" + sameUserOnly + "], callback = [" + callback + "]");
            }
            for (ManagedServices.ManagedServiceInfo info : this.getServices()) {
                boolean sbnVisible;
                boolean bl = sbnVisible = NotificationManagerService.this.isVisibleToListener(sbn, info) && (!sameUserOnly || info.isSameUser(sbn.getUserId()));
                if (debug) {
                    Slog.v(this.TAG, "notifyAssistantLocked info=" + info + " snbVisible=" + sbnVisible);
                }
                if (!sbnVisible) continue;
                INotificationListener assistant = (INotificationListener)info.service;
                StatusBarNotification sbnToPost = trimCache.ForListener(info);
                StatusBarNotificationHolder sbnHolder = new StatusBarNotificationHolder(sbnToPost);
                NotificationManagerService.this.mHandler.post(() -> callback.accept(assistant, sbnHolder));
            }
        }

        public boolean isEnabled() {
            return !this.getServices().isEmpty();
        }

        protected void resetDefaultAssistantsIfNecessary() {
            List<UserInfo> activeUsers = this.mUm.getUsers(true);
            for (UserInfo userInfo : activeUsers) {
                int userId = userInfo.getUserHandle().getIdentifier();
                if (this.hasUserSet(userId)) continue;
                Slog.d(this.TAG, "Approving default notification assistant for user " + userId);
                NotificationManagerService.this.setDefaultAssistantForUser(userId);
            }
        }

        @Override
        protected void setPackageOrComponentEnabled(String pkgOrComponent, int userId, boolean isPrimary, boolean enabled) {
            List<ComponentName> allowedComponents;
            if (enabled && !(allowedComponents = this.getAllowedComponents(userId)).isEmpty()) {
                ComponentName currentComponent = CollectionUtils.firstOrNull(allowedComponents);
                if (currentComponent.flattenToString().equals(pkgOrComponent)) {
                    return;
                }
                NotificationManagerService.this.setNotificationAssistantAccessGrantedForUserInternal(currentComponent, userId, false);
            }
            super.setPackageOrComponentEnabled(pkgOrComponent, userId, isPrimary, enabled);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(PrintWriter pw, DumpFilter filter) {
            super.dump(pw, filter);
            pw.println("    Has user set:");
            Object object = this.mLock;
            synchronized (object) {
                Set<Integer> userIds = this.mUserSetMap.keySet();
                for (int userId : userIds) {
                    pw.println("      userId=" + userId + " value=" + this.mUserSetMap.get(userId));
                }
            }
        }

        private boolean isVerboseLogEnabled() {
            return Log.isLoggable("notification_assistant", 2);
        }
    }

    private class TrimCache {
        StatusBarNotification heavy;
        StatusBarNotification sbnClone;
        StatusBarNotification sbnCloneLight;

        TrimCache(StatusBarNotification sbn) {
            this.heavy = sbn;
        }

        StatusBarNotification ForListener(ManagedServices.ManagedServiceInfo info) {
            if (NotificationManagerService.this.mListeners.getOnNotificationPostedTrim(info) == 1) {
                if (this.sbnCloneLight == null) {
                    this.sbnCloneLight = this.heavy.cloneLight();
                }
                return this.sbnCloneLight;
            }
            if (this.sbnClone == null) {
                this.sbnClone = this.heavy.clone();
            }
            return this.sbnClone;
        }
    }

    private static interface FlagChecker {
        public boolean apply(int var1);
    }

    private final class RankingHandlerWorker
    extends Handler
    implements RankingHandler {
        public RankingHandlerWorker(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    NotificationManagerService.this.handleRankingReconsideration(msg);
                    break;
                }
                case 1001: {
                    NotificationManagerService.this.handleRankingSort();
                }
            }
        }

        @Override
        public void requestSort() {
            this.removeMessages(1001);
            Message msg = Message.obtain();
            msg.what = 1001;
            this.sendMessage(msg);
        }

        @Override
        public void requestReconsideration(RankingReconsideration recon) {
            Message m = Message.obtain(this, 1000, recon);
            long delay = recon.getDelay(TimeUnit.MILLISECONDS);
            this.sendMessageDelayed(m, delay);
        }
    }

    protected class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 2: {
                    NotificationManagerService.this.handleDurationReached((ToastRecord)msg.obj);
                    break;
                }
                case 7: {
                    NotificationManagerService.this.handleKillTokenTimeout((ToastRecord)msg.obj);
                    break;
                }
                case 4: {
                    NotificationManagerService.this.handleSendRankingUpdate();
                    break;
                }
                case 5: {
                    NotificationManagerService.this.handleListenerHintsChanged(msg.arg1);
                    break;
                }
                case 6: {
                    NotificationManagerService.this.handleListenerInterruptionFilterChanged(msg.arg1);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    NotificationManagerService.this.handleOnPackageChanged((Boolean)args.arg1, args.argi1, (String[])args.arg2, (int[])args.arg3);
                    args.recycle();
                }
            }
        }

        protected void scheduleSendRankingUpdate() {
            if (!this.hasMessages(4)) {
                Message m = Message.obtain((Handler)this, 4);
                this.sendMessage(m);
            }
        }

        protected void scheduleCancelNotification(CancelNotificationRunnable cancelRunnable) {
            if (!this.hasCallbacks(cancelRunnable)) {
                this.sendMessage(Message.obtain((Handler)this, cancelRunnable));
            }
        }

        protected void scheduleOnPackageChanged(boolean removingPackage, int changeUserId, String[] pkgList, int[] uidList) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = removingPackage;
            args.argi1 = changeUserId;
            args.arg2 = pkgList;
            args.arg3 = uidList;
            this.sendMessage(Message.obtain(this, 8, args));
        }
    }

    protected class PostNotificationRunnable
    implements Runnable {
        private final String key;

        PostNotificationRunnable(String key) {
            this.key = key;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                try {
                    NotificationRecord r = null;
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord enqueued = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(this.key, enqueued.getKey())) continue;
                        r = enqueued;
                        break;
                    }
                    if (r == null) {
                        Slog.i(NotificationManagerService.TAG, "Cannot find enqueued record for key: " + this.key);
                        return;
                    }
                    if (NotificationManagerService.this.isBlocked(r)) {
                        Slog.i(NotificationManagerService.TAG, "notification blocked by assistant request");
                        return;
                    }
                    boolean isPackageSuspended = NotificationManagerService.this.isPackageSuspendedLocked(r);
                    r.setHidden(isPackageSuspended);
                    if (isPackageSuspended) {
                        NotificationManagerService.this.mUsageStats.registerSuspendedByAdmin(r);
                    }
                    NotificationRecord old = NotificationManagerService.this.mNotificationsByKey.get(this.key);
                    final StatusBarNotification n = r.sbn;
                    Notification notification = n.getNotification();
                    int index = NotificationManagerService.this.indexOfNotificationLocked(n.getKey());
                    if (index < 0) {
                        NotificationManagerService.this.mNotificationList.add(r);
                        NotificationManagerService.this.mUsageStats.registerPostedByApp(r);
                        r.setInterruptive(NotificationManagerService.this.isVisuallyInterruptive(null, r));
                    } else {
                        old = NotificationManagerService.this.mNotificationList.get(index);
                        NotificationManagerService.this.mNotificationList.set(index, r);
                        NotificationManagerService.this.mUsageStats.registerUpdatedByApp(r, old);
                        notification.flags |= old.getNotification().flags & 0x40;
                        r.isUpdate = true;
                        r.setTextChanged(NotificationManagerService.this.isVisuallyInterruptive(old, r));
                    }
                    NotificationManagerService.this.mNotificationsByKey.put(n.getKey(), r);
                    if ((notification.flags & 0x40) != 0) {
                        notification.flags |= 0x22;
                    }
                    NotificationManagerService.this.mRankingHelper.extractSignals(r);
                    NotificationManagerService.this.mRankingHelper.sort(NotificationManagerService.this.mNotificationList);
                    if (!r.isHidden()) {
                        NotificationManagerService.this.buzzBeepBlinkLocked(r);
                    }
                    if (notification.getSmallIcon() != null) {
                        StatusBarNotification oldSbn = old != null ? old.sbn : null;
                        NotificationManagerService.this.mListeners.notifyPostedLocked(r, old);
                        if (!(oldSbn != null && Objects.equals(oldSbn.getGroup(), n.getGroup()) || NotificationManagerService.this.isCritical(r))) {
                            NotificationManagerService.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    NotificationManagerService.this.mGroupHelper.onNotificationPosted(n, NotificationManagerService.this.hasAutoGroupSummaryLocked(n));
                                }
                            });
                        }
                    } else {
                        Slog.e(NotificationManagerService.TAG, "Not posting notification without small icon: " + notification);
                        if (old != null && !old.isCanceled) {
                            NotificationManagerService.this.mListeners.notifyRemovedLocked(r, 4, r.getStats());
                            NotificationManagerService.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    NotificationManagerService.this.mGroupHelper.onNotificationRemoved(n);
                                }
                            });
                        }
                        Slog.e(NotificationManagerService.TAG, "WARNING: In a future release this will crash the app: " + n.getPackageName());
                    }
                    NotificationManagerService.this.maybeRecordInterruptionLocked(r);
                }
                finally {
                    int N = NotificationManagerService.this.mEnqueuedNotifications.size();
                    for (int i = 0; i < N; ++i) {
                        NotificationRecord enqueued = NotificationManagerService.this.mEnqueuedNotifications.get(i);
                        if (!Objects.equals(this.key, enqueued.getKey())) continue;
                        NotificationManagerService.this.mEnqueuedNotifications.remove(i);
                        break;
                    }
                }
                return;
            }
        }
    }

    protected class EnqueueNotificationRunnable
    implements Runnable {
        private final NotificationRecord r;
        private final int userId;

        EnqueueNotificationRunnable(int userId, NotificationRecord r) {
            this.userId = userId;
            this.r = r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord old;
                NotificationManagerService.this.mEnqueuedNotifications.add(this.r);
                NotificationManagerService.this.scheduleTimeoutLocked(this.r);
                StatusBarNotification n = this.r.sbn;
                if (DBG) {
                    Slog.d(NotificationManagerService.TAG, "EnqueueNotificationRunnable.run for: " + n.getKey());
                }
                if ((old = NotificationManagerService.this.mNotificationsByKey.get(n.getKey())) != null) {
                    this.r.copyRankingInformation(old);
                }
                int callingUid = n.getUid();
                int callingPid = n.getInitialPid();
                Notification notification = n.getNotification();
                String pkg = n.getPackageName();
                int id2 = n.getId();
                String tag = n.getTag();
                NotificationManagerService.this.flagNotificationForBubbles(this.r, pkg, callingUid, old);
                NotificationManagerService.this.handleGroupedNotificationLocked(this.r, old, callingUid, callingPid);
                if (n.isGroup() && notification.isGroupChild()) {
                    NotificationManagerService.this.mSnoozeHelper.repostGroupSummary(pkg, this.r.getUserId(), n.getGroupKey());
                }
                if (!pkg.equals("com.android.providers.downloads") || Log.isLoggable("DownloadManager", 2)) {
                    int enqueueStatus = 0;
                    if (old != null) {
                        enqueueStatus = 1;
                    }
                    EventLogTags.writeNotificationEnqueue(callingUid, callingPid, pkg, id2, tag, this.userId, notification.toString(), enqueueStatus);
                }
                if (NotificationManagerService.this.mAssistants.isEnabled()) {
                    NotificationManagerService.this.mAssistants.onNotificationEnqueuedLocked(this.r);
                    NotificationManagerService.this.mHandler.postDelayed(new PostNotificationRunnable(this.r.getKey()), 100L);
                } else {
                    NotificationManagerService.this.mHandler.post(new PostNotificationRunnable(this.r.getKey()));
                }
            }
        }
    }

    protected class CancelNotificationRunnable
    implements Runnable {
        private final int mCallingUid;
        private final int mCallingPid;
        private final String mPkg;
        private final String mTag;
        private final int mId;
        private final int mMustHaveFlags;
        private final int mMustNotHaveFlags;
        private final boolean mSendDelete;
        private final int mUserId;
        private final int mReason;
        private final int mRank;
        private final int mCount;
        private final ManagedServices.ManagedServiceInfo mListener;

        CancelNotificationRunnable(int callingUid, int callingPid, String pkg, String tag, int id2, int mustHaveFlags, int mustNotHaveFlags, boolean sendDelete, int userId, int reason, int rank, int count, ManagedServices.ManagedServiceInfo listener) {
            this.mCallingUid = callingUid;
            this.mCallingPid = callingPid;
            this.mPkg = pkg;
            this.mTag = tag;
            this.mId = id2;
            this.mMustHaveFlags = mustHaveFlags;
            this.mMustNotHaveFlags = mustNotHaveFlags;
            this.mSendDelete = sendDelete;
            this.mUserId = userId;
            this.mReason = reason;
            this.mRank = rank;
            this.mCount = count;
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String listenerName;
            String string2 = listenerName = this.mListener == null ? null : this.mListener.component.toShortString();
            if (DBG) {
                EventLogTags.writeNotificationCancel(this.mCallingUid, this.mCallingPid, this.mPkg, this.mId, this.mTag, this.mUserId, this.mMustHaveFlags, this.mMustNotHaveFlags, this.mReason, listenerName);
            }
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                boolean wasSnoozed;
                NotificationRecord r = NotificationManagerService.this.findNotificationLocked(this.mPkg, this.mTag, this.mId, this.mUserId);
                if (r != null) {
                    if (this.mReason == 1) {
                        NotificationManagerService.this.mUsageStats.registerClickedByUser(r);
                    }
                    if ((r.getNotification().flags & this.mMustHaveFlags) != this.mMustHaveFlags) {
                        return;
                    }
                    if ((r.getNotification().flags & this.mMustNotHaveFlags) != 0) {
                        return;
                    }
                    boolean wasPosted = NotificationManagerService.this.removeFromNotificationListsLocked(r);
                    NotificationManagerService.this.cancelNotificationLocked(r, this.mSendDelete, this.mReason, this.mRank, this.mCount, wasPosted, listenerName);
                    NotificationManagerService.this.cancelGroupChildrenLocked(r, this.mCallingUid, this.mCallingPid, listenerName, this.mSendDelete, null);
                    NotificationManagerService.this.updateLightsLocked();
                } else if (this.mReason != 18 && (wasSnoozed = NotificationManagerService.this.mSnoozeHelper.cancel(this.mUserId, this.mPkg, this.mTag, this.mId))) {
                    NotificationManagerService.this.handleSavePolicyFile();
                }
            }
        }
    }

    protected class SnoozeNotificationRunnable
    implements Runnable {
        private final String mKey;
        private final long mDuration;
        private final String mSnoozeCriterionId;

        SnoozeNotificationRunnable(String key, long duration, String snoozeCriterionId) {
            this.mKey = key;
            this.mDuration = duration;
            this.mSnoozeCriterionId = snoozeCriterionId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NotificationManagerService.this.mNotificationLock;
            synchronized (object) {
                NotificationRecord r = NotificationManagerService.this.findNotificationByKeyLocked(this.mKey);
                if (r != null) {
                    this.snoozeLocked(r);
                }
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        void snoozeLocked(NotificationRecord r) {
            if (r.sbn.isGroup()) {
                List<NotificationRecord> groupNotifications = NotificationManagerService.this.findGroupNotificationsLocked(r.sbn.getPackageName(), r.sbn.getGroupKey(), r.sbn.getUserId());
                if (r.getNotification().isGroupSummary()) {
                    for (int i = 0; i < groupNotifications.size(); ++i) {
                        this.snoozeNotificationLocked(groupNotifications.get(i));
                    }
                } else if (NotificationManagerService.this.mSummaryByGroupKey.containsKey(r.sbn.getGroupKey())) {
                    if (groupNotifications.size() != 2) {
                        this.snoozeNotificationLocked(r);
                    } else {
                        for (int i = 0; i < groupNotifications.size(); ++i) {
                            this.snoozeNotificationLocked(groupNotifications.get(i));
                        }
                    }
                } else {
                    this.snoozeNotificationLocked(r);
                }
            } else {
                this.snoozeNotificationLocked(r);
            }
        }

        @GuardedBy(value={"mNotificationLock"})
        void snoozeNotificationLocked(NotificationRecord r) {
            MetricsLogger.action(r.getLogMaker().setCategory(831).setType(2).addTaggedData(1139, this.mDuration).addTaggedData(832, this.mSnoozeCriterionId == null ? 0 : 1));
            NotificationManagerService.this.reportUserInteraction(r);
            boolean wasPosted = NotificationManagerService.this.removeFromNotificationListsLocked(r);
            NotificationManagerService.this.cancelNotificationLocked(r, false, 18, wasPosted, null);
            NotificationManagerService.this.updateLightsLocked();
            if (this.mSnoozeCriterionId != null) {
                NotificationManagerService.this.mAssistants.notifyAssistantSnoozedLocked(r.sbn, this.mSnoozeCriterionId);
                NotificationManagerService.this.mSnoozeHelper.snooze(r);
            } else {
                NotificationManagerService.this.mSnoozeHelper.snooze(r, this.mDuration);
            }
            r.recordSnoozed();
            NotificationManagerService.this.handleSavePolicyFile();
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri NOTIFICATION_BADGING_URI;
        private final Uri NOTIFICATION_BUBBLES_URI;
        private final Uri NOTIFICATION_LIGHT_PULSE_URI;
        private final Uri NOTIFICATION_RATE_LIMIT_URI;

        SettingsObserver(Handler handler) {
            super(handler);
            this.NOTIFICATION_BADGING_URI = Settings.Secure.getUriFor("notification_badging");
            this.NOTIFICATION_BUBBLES_URI = Settings.Secure.getUriFor("notification_bubbles");
            this.NOTIFICATION_LIGHT_PULSE_URI = Settings.System.getUriFor("notification_light_pulse");
            this.NOTIFICATION_RATE_LIMIT_URI = Settings.Global.getUriFor("max_notification_enqueue_rate");
        }

        void observe() {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            resolver.registerContentObserver(this.NOTIFICATION_BADGING_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_LIGHT_PULSE_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_RATE_LIMIT_URI, false, this, -1);
            resolver.registerContentObserver(this.NOTIFICATION_BUBBLES_URI, false, this, -1);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            ContentResolver resolver = NotificationManagerService.this.getContext().getContentResolver();
            if (uri == null || this.NOTIFICATION_LIGHT_PULSE_URI.equals(uri)) {
                boolean pulseEnabled;
                boolean bl = pulseEnabled = Settings.System.getIntForUser(resolver, "notification_light_pulse", 0, -2) != 0;
                if (NotificationManagerService.this.mNotificationPulseEnabled != pulseEnabled) {
                    NotificationManagerService.this.mNotificationPulseEnabled = pulseEnabled;
                    NotificationManagerService.this.updateNotificationPulse();
                }
            }
            if (uri == null || this.NOTIFICATION_RATE_LIMIT_URI.equals(uri)) {
                NotificationManagerService.this.mMaxPackageEnqueueRate = Settings.Global.getFloat(resolver, "max_notification_enqueue_rate", NotificationManagerService.this.mMaxPackageEnqueueRate);
            }
            if (uri == null || this.NOTIFICATION_BADGING_URI.equals(uri)) {
                NotificationManagerService.this.mPreferencesHelper.updateBadgingEnabled();
            }
            if (uri == null || this.NOTIFICATION_BUBBLES_URI.equals(uri)) {
                NotificationManagerService.this.mPreferencesHelper.updateBubblesEnabled();
            }
        }
    }

    private static final class ToastRecord {
        final int pid;
        final String pkg;
        final ITransientNotification callback;
        int duration;
        int displayId;
        Binder token;

        ToastRecord(int pid, String pkg, ITransientNotification callback, int duration, Binder token, int displayId) {
            this.pid = pid;
            this.pkg = pkg;
            this.callback = callback;
            this.duration = duration;
            this.token = token;
            this.displayId = displayId;
        }

        void update(int duration) {
            this.duration = duration;
        }

        void dump(PrintWriter pw, String prefix, DumpFilter filter) {
            if (filter != null && !filter.matches(this.pkg)) {
                return;
            }
            pw.println(prefix + this);
        }

        public final String toString() {
            return "ToastRecord{" + Integer.toHexString(System.identityHashCode(this)) + " pkg=" + this.pkg + " callback=" + this.callback + " duration=" + this.duration;
        }
    }

    private static class Archive {
        final int mBufferSize;
        final ArrayDeque<StatusBarNotification> mBuffer;

        public Archive(int size) {
            this.mBufferSize = size;
            this.mBuffer = new ArrayDeque(this.mBufferSize);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int N = this.mBuffer.size();
            sb.append("Archive (");
            sb.append(N);
            sb.append(" notification");
            sb.append(N == 1 ? ")" : "s)");
            return sb.toString();
        }

        public void record(StatusBarNotification nr) {
            if (this.mBuffer.size() == this.mBufferSize) {
                this.mBuffer.removeFirst();
            }
            this.mBuffer.addLast(nr.cloneLight());
        }

        public Iterator<StatusBarNotification> descendingIterator() {
            return this.mBuffer.descendingIterator();
        }

        public StatusBarNotification[] getArray(int count) {
            if (count == 0) {
                count = this.mBufferSize;
            }
            StatusBarNotification[] a = new StatusBarNotification[Math.min(count, this.mBuffer.size())];
            Iterator<StatusBarNotification> iter = this.descendingIterator();
            int i = 0;
            while (iter.hasNext() && i < count) {
                a[i++] = iter.next();
            }
            return a;
        }
    }
}

