/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.IActivityManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.content.ContentProvider;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.AudioSystem;
import android.metrics.LogMaker;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.Adjustment;
import android.service.notification.NotificationListenerService;
import android.service.notification.NotificationStats;
import android.service.notification.SnoozeCriterion;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Log;
import android.util.TimeUtils;
import android.util.proto.ProtoOutputStream;
import android.widget.RemoteViews;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.uri.UriGrantsManagerInternal;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class NotificationRecord {
    static final String TAG = "NotificationRecord";
    static final boolean DBG = Log.isLoggable("NotificationRecord", 3);
    private static final int MAX_SOUND_DELAY_MS = 2000;
    final StatusBarNotification sbn;
    IActivityManager mAm;
    UriGrantsManagerInternal mUgmInternal;
    final int mTargetSdkVersion;
    final int mOriginalFlags;
    private final Context mContext;
    NotificationUsageStats.SingleNotificationStats stats;
    boolean isCanceled;
    IBinder permissionOwner;
    private float mContactAffinity;
    private boolean mRecentlyIntrusive;
    private long mLastIntrusive;
    private boolean mIntercept;
    private boolean mHidden;
    private long mRankingTimeMs;
    private long mCreationTimeMs;
    private long mVisibleSinceMs;
    @VisibleForTesting
    final long mUpdateTimeMs;
    private long mInterruptionTimeMs;
    private long mLastAudiblyAlertedMs;
    public boolean isUpdate;
    private int mPackagePriority;
    private int mAuthoritativeRank;
    private String mGlobalSortKey;
    private int mPackageVisibility;
    private int mSystemImportance = -1000;
    private int mAssistantImportance = -1000;
    private int mImportance = -1000;
    private int mCriticality = 2;
    private int mImportanceExplanationCode = 0;
    private int mInitialImportanceExplanationCode = 0;
    private int mSuppressedVisualEffects = 0;
    private String mUserExplanation;
    private boolean mPreChannelsNotification = true;
    private Uri mSound;
    private long[] mVibration;
    private AudioAttributes mAttributes;
    private NotificationChannel mChannel;
    private ArrayList<String> mPeopleOverride;
    private ArrayList<SnoozeCriterion> mSnoozeCriteria;
    private boolean mShowBadge;
    private boolean mAllowBubble;
    private Light mLight;
    private ArrayList<Notification.Action> mSystemGeneratedSmartActions;
    private ArrayList<CharSequence> mSmartReplies;
    private final List<Adjustment> mAdjustments;
    private String mAdjustmentIssuer;
    private final NotificationStats mStats;
    private int mUserSentiment;
    private boolean mIsInterruptive;
    private boolean mTextChanged;
    private boolean mRecordedInterruption;
    private int mNumberOfSmartRepliesAdded;
    private int mNumberOfSmartActionsAdded;
    private boolean mSuggestionsGeneratedByAssistant;
    private boolean mEditChoicesBeforeSending;
    private boolean mHasSeenSmartReplies;
    private boolean mIsAppImportanceLocked;
    private ArraySet<Uri> mGrantableUris;

    public NotificationRecord(Context context, StatusBarNotification sbn, NotificationChannel channel) {
        this.sbn = sbn;
        this.mTargetSdkVersion = LocalServices.getService(PackageManagerInternal.class).getPackageTargetSdkVersion(sbn.getPackageName());
        this.mAm = ActivityManager.getService();
        this.mUgmInternal = LocalServices.getService(UriGrantsManagerInternal.class);
        this.mOriginalFlags = sbn.getNotification().flags;
        this.mRankingTimeMs = this.calculateRankingTimeMs(0L);
        this.mUpdateTimeMs = this.mCreationTimeMs = sbn.getPostTime();
        this.mInterruptionTimeMs = this.mCreationTimeMs;
        this.mContext = context;
        this.stats = new NotificationUsageStats.SingleNotificationStats();
        this.mChannel = channel;
        this.mPreChannelsNotification = this.isPreChannelsNotification();
        this.mSound = this.calculateSound();
        this.mVibration = this.calculateVibration();
        this.mAttributes = this.calculateAttributes();
        this.mImportance = this.calculateInitialImportance();
        this.mLight = this.calculateLights();
        this.mAdjustments = new ArrayList<Adjustment>();
        this.mStats = new NotificationStats();
        this.calculateUserSentiment();
        this.calculateGrantableUris();
    }

    private boolean isPreChannelsNotification() {
        return "miscellaneous".equals(this.getChannel().getId()) && this.mTargetSdkVersion < 26;
    }

    private Uri calculateSound() {
        Notification n = this.sbn.getNotification();
        if (this.mContext.getPackageManager().hasSystemFeature("android.software.leanback")) {
            return null;
        }
        Uri sound = this.mChannel.getSound();
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x20) == 0) {
            boolean useDefaultSound = (n.defaults & 1) != 0;
            sound = useDefaultSound ? Settings.System.DEFAULT_NOTIFICATION_URI : n.sound;
        }
        return sound;
    }

    private Light calculateLights() {
        Light light;
        int defaultLightColor = this.mContext.getResources().getColor(17170725);
        int defaultLightOn = this.mContext.getResources().getInteger(17694777);
        int defaultLightOff = this.mContext.getResources().getInteger(17694776);
        int channelLightColor = this.getChannel().getLightColor() != 0 ? this.getChannel().getLightColor() : defaultLightColor;
        Light light2 = light = this.getChannel().shouldShowLights() ? new Light(channelLightColor, defaultLightOn, defaultLightOff) : null;
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 8) == 0) {
            Notification notification = this.sbn.getNotification();
            if ((notification.flags & 1) != 0) {
                light = new Light(notification.ledARGB, notification.ledOnMS, notification.ledOffMS);
                if ((notification.defaults & 4) != 0) {
                    light = new Light(defaultLightColor, defaultLightOn, defaultLightOff);
                }
            } else {
                light = null;
            }
        }
        return light;
    }

    private long[] calculateVibration() {
        long[] defaultVibration = NotificationManagerService.getLongArray(this.mContext.getResources(), 17236004, 17, NotificationManagerService.DEFAULT_VIBRATE_PATTERN);
        long[] vibration = this.getChannel().shouldVibrate() ? (this.getChannel().getVibrationPattern() == null ? defaultVibration : this.getChannel().getVibrationPattern()) : null;
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x10) == 0) {
            Notification notification = this.sbn.getNotification();
            boolean useDefaultVibrate = (notification.defaults & 2) != 0;
            vibration = useDefaultVibrate ? defaultVibration : notification.vibrate;
        }
        return vibration;
    }

    private AudioAttributes calculateAttributes() {
        Notification n = this.sbn.getNotification();
        AudioAttributes attributes = this.getChannel().getAudioAttributes();
        if (attributes == null) {
            attributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        }
        if (this.mPreChannelsNotification && (this.getChannel().getUserLockedFields() & 0x20) == 0) {
            if (n.audioAttributes != null) {
                attributes = n.audioAttributes;
            } else if (n.audioStreamType >= 0 && n.audioStreamType < AudioSystem.getNumStreamTypes()) {
                attributes = new AudioAttributes.Builder().setInternalLegacyStreamType(n.audioStreamType).build();
            } else if (n.audioStreamType != -1) {
                Log.w(TAG, String.format("Invalid stream type: %d", n.audioStreamType));
            }
        }
        return attributes;
    }

    private int calculateInitialImportance() {
        Notification n = this.sbn.getNotification();
        int importance = this.getChannel().getImportance();
        int n2 = this.mInitialImportanceExplanationCode = this.getChannel().hasUserSetImportance() ? 2 : 1;
        if (0 != (n.flags & 0x80)) {
            n.priority = 2;
        }
        int requestedImportance = 3;
        n.priority = NotificationManagerService.clamp(n.priority, -2, 2);
        switch (n.priority) {
            case -2: {
                requestedImportance = 1;
                break;
            }
            case -1: {
                requestedImportance = 2;
                break;
            }
            case 0: {
                requestedImportance = 3;
                break;
            }
            case 1: 
            case 2: {
                requestedImportance = 4;
            }
        }
        this.stats.requestedImportance = requestedImportance;
        boolean bl = this.stats.isNoisy = this.mSound != null || this.mVibration != null;
        if (this.mPreChannelsNotification && (importance == -1000 || !this.getChannel().hasUserSetImportance())) {
            if (!this.stats.isNoisy && requestedImportance > 2) {
                requestedImportance = 2;
            }
            if (this.stats.isNoisy && requestedImportance < 3) {
                requestedImportance = 3;
            }
            if (n.fullScreenIntent != null) {
                requestedImportance = 4;
            }
            importance = requestedImportance;
            this.mInitialImportanceExplanationCode = 5;
        }
        this.stats.naturalImportance = importance;
        return importance;
    }

    public void copyRankingInformation(NotificationRecord previous) {
        this.mContactAffinity = previous.mContactAffinity;
        this.mRecentlyIntrusive = previous.mRecentlyIntrusive;
        this.mPackagePriority = previous.mPackagePriority;
        this.mPackageVisibility = previous.mPackageVisibility;
        this.mIntercept = previous.mIntercept;
        this.mHidden = previous.mHidden;
        this.mRankingTimeMs = this.calculateRankingTimeMs(previous.getRankingTimeMs());
        this.mCreationTimeMs = previous.mCreationTimeMs;
        this.mVisibleSinceMs = previous.mVisibleSinceMs;
        if (previous.sbn.getOverrideGroupKey() != null && !this.sbn.isAppGroup()) {
            this.sbn.setOverrideGroupKey(previous.sbn.getOverrideGroupKey());
        }
    }

    public Notification getNotification() {
        return this.sbn.getNotification();
    }

    public int getFlags() {
        return this.sbn.getNotification().flags;
    }

    public UserHandle getUser() {
        return this.sbn.getUser();
    }

    public String getKey() {
        return this.sbn.getKey();
    }

    public int getUserId() {
        return this.sbn.getUserId();
    }

    public int getUid() {
        return this.sbn.getUid();
    }

    void dump(ProtoOutputStream proto, long fieldId, boolean redact, int state) {
        long token = proto.start(fieldId);
        proto.write(0x10900000001L, this.sbn.getKey());
        proto.write(1159641169922L, state);
        if (this.getChannel() != null) {
            proto.write(1138166333444L, this.getChannel().getId());
        }
        proto.write(0x10800000008L, this.getLight() != null);
        proto.write(1133871366151L, this.getVibration() != null);
        proto.write(1120986464259L, this.sbn.getNotification().flags);
        proto.write(0x10900000009L, this.getGroupKey());
        proto.write(0x1110000000AL, this.getImportance());
        if (this.getSound() != null) {
            proto.write(1138166333445L, this.getSound().toString());
        }
        if (this.getAudioAttributes() != null) {
            this.getAudioAttributes().writeToProto(proto, 1146756268038L);
        }
        proto.write(1138166333451L, this.sbn.getPackageName());
        proto.write(1138166333452L, this.sbn.getOpPkg());
        proto.end(token);
    }

    String formatRemoteViews(RemoteViews rv) {
        if (rv == null) {
            return "null";
        }
        return String.format("%s/0x%08x (%d bytes): %s", rv.getPackage(), rv.getLayoutId(), rv.estimateMemoryUsage(), rv.toString());
    }

    void dump(PrintWriter pw, String prefix, Context baseContext, boolean redact) {
        Notification notification = this.sbn.getNotification();
        Icon icon = notification.getSmallIcon();
        String iconStr = String.valueOf(icon);
        if (icon != null && icon.getType() == 2) {
            iconStr = iconStr + " / " + NotificationRecord.idDebugString(baseContext, icon.getResPackage(), icon.getResId());
        }
        pw.println(prefix + this);
        prefix = prefix + "  ";
        pw.println(prefix + "uid=" + this.sbn.getUid() + " userId=" + this.sbn.getUserId());
        pw.println(prefix + "opPkg=" + this.sbn.getOpPkg());
        pw.println(prefix + "icon=" + iconStr);
        pw.println(prefix + "flags=0x" + Integer.toHexString(notification.flags));
        pw.println(prefix + "pri=" + notification.priority);
        pw.println(prefix + "key=" + this.sbn.getKey());
        pw.println(prefix + "seen=" + this.mStats.hasSeen());
        pw.println(prefix + "groupKey=" + this.getGroupKey());
        pw.println(prefix + "fullscreenIntent=" + notification.fullScreenIntent);
        pw.println(prefix + "contentIntent=" + notification.contentIntent);
        pw.println(prefix + "deleteIntent=" + notification.deleteIntent);
        pw.println(prefix + "number=" + notification.number);
        pw.println(prefix + "groupAlertBehavior=" + notification.getGroupAlertBehavior());
        pw.print(prefix + "tickerText=");
        if (!TextUtils.isEmpty(notification.tickerText)) {
            String ticker = notification.tickerText.toString();
            if (redact) {
                pw.print(ticker.length() > 16 ? ticker.substring(0, 8) : "");
                pw.println("...");
            } else {
                pw.println(ticker);
            }
        } else {
            pw.println("null");
        }
        pw.println(prefix + "contentView=" + this.formatRemoteViews(notification.contentView));
        pw.println(prefix + "bigContentView=" + this.formatRemoteViews(notification.bigContentView));
        pw.println(prefix + "headsUpContentView=" + this.formatRemoteViews(notification.headsUpContentView));
        pw.print(prefix + String.format("color=0x%08x", notification.color));
        pw.println(prefix + "timeout=" + TimeUtils.formatForLogging(notification.getTimeoutAfter()));
        if (notification.actions != null && notification.actions.length > 0) {
            pw.println(prefix + "actions={");
            int N = notification.actions.length;
            for (int i = 0; i < N; ++i) {
                Notification.Action action = notification.actions[i];
                if (action == null) continue;
                pw.println(String.format("%s    [%d] \"%s\" -> %s", prefix, i, action.title, action.actionIntent == null ? "null" : action.actionIntent.toString()));
            }
            pw.println(prefix + "  }");
        }
        if (notification.extras != null && notification.extras.size() > 0) {
            pw.println(prefix + "extras={");
            for (String key : notification.extras.keySet()) {
                pw.print(prefix + "    " + key + "=");
                Object val = notification.extras.get(key);
                if (val == null) {
                    pw.println("null");
                    continue;
                }
                pw.print(val.getClass().getSimpleName());
                if (!redact || !(val instanceof CharSequence) && !(val instanceof String)) {
                    if (val instanceof Bitmap) {
                        pw.print(String.format(" (%dx%d)", ((Bitmap)val).getWidth(), ((Bitmap)val).getHeight()));
                    } else if (val.getClass().isArray()) {
                        int N = Array.getLength(val);
                        pw.print(" (" + N + ")");
                        if (!redact) {
                            for (int j = 0; j < N; ++j) {
                                pw.println();
                                pw.print(String.format("%s      [%d] %s", prefix, j, String.valueOf(Array.get(val, j))));
                            }
                        }
                    } else {
                        pw.print(" (" + String.valueOf(val) + ")");
                    }
                }
                pw.println();
            }
            pw.println(prefix + "}");
        }
        pw.println(prefix + "stats=" + this.stats.toString());
        pw.println(prefix + "mContactAffinity=" + this.mContactAffinity);
        pw.println(prefix + "mRecentlyIntrusive=" + this.mRecentlyIntrusive);
        pw.println(prefix + "mPackagePriority=" + this.mPackagePriority);
        pw.println(prefix + "mPackageVisibility=" + this.mPackageVisibility);
        pw.println(prefix + "mSystemImportance=" + NotificationListenerService.Ranking.importanceToString(this.mSystemImportance));
        pw.println(prefix + "mAsstImportance=" + NotificationListenerService.Ranking.importanceToString(this.mAssistantImportance));
        pw.println(prefix + "mImportance=" + NotificationListenerService.Ranking.importanceToString(this.mImportance));
        pw.println(prefix + "mImportanceExplanation=" + this.getImportanceExplanation());
        pw.println(prefix + "mIsAppImportanceLocked=" + this.mIsAppImportanceLocked);
        pw.println(prefix + "mIntercept=" + this.mIntercept);
        pw.println(prefix + "mHidden==" + this.mHidden);
        pw.println(prefix + "mGlobalSortKey=" + this.mGlobalSortKey);
        pw.println(prefix + "mRankingTimeMs=" + this.mRankingTimeMs);
        pw.println(prefix + "mCreationTimeMs=" + this.mCreationTimeMs);
        pw.println(prefix + "mVisibleSinceMs=" + this.mVisibleSinceMs);
        pw.println(prefix + "mUpdateTimeMs=" + this.mUpdateTimeMs);
        pw.println(prefix + "mInterruptionTimeMs=" + this.mInterruptionTimeMs);
        pw.println(prefix + "mSuppressedVisualEffects= " + this.mSuppressedVisualEffects);
        if (this.mPreChannelsNotification) {
            pw.println(prefix + String.format("defaults=0x%08x flags=0x%08x", notification.defaults, notification.flags));
            pw.println(prefix + "n.sound=" + notification.sound);
            pw.println(prefix + "n.audioStreamType=" + notification.audioStreamType);
            pw.println(prefix + "n.audioAttributes=" + notification.audioAttributes);
            pw.println(prefix + String.format("  led=0x%08x onMs=%d offMs=%d", notification.ledARGB, notification.ledOnMS, notification.ledOffMS));
            pw.println(prefix + "vibrate=" + Arrays.toString(notification.vibrate));
        }
        pw.println(prefix + "mSound= " + this.mSound);
        pw.println(prefix + "mVibration= " + this.mVibration);
        pw.println(prefix + "mAttributes= " + this.mAttributes);
        pw.println(prefix + "mLight= " + this.mLight);
        pw.println(prefix + "mShowBadge=" + this.mShowBadge);
        pw.println(prefix + "mColorized=" + notification.isColorized());
        pw.println(prefix + "mIsInterruptive=" + this.mIsInterruptive);
        pw.println(prefix + "effectiveNotificationChannel=" + this.getChannel());
        if (this.getPeopleOverride() != null) {
            pw.println(prefix + "overridePeople= " + TextUtils.join((CharSequence)",", this.getPeopleOverride()));
        }
        if (this.getSnoozeCriteria() != null) {
            pw.println(prefix + "snoozeCriteria=" + TextUtils.join((CharSequence)",", this.getSnoozeCriteria()));
        }
        pw.println(prefix + "mAdjustments=" + this.mAdjustments);
    }

    static String idDebugString(Context baseContext, String packageName, int id2) {
        Context c;
        if (packageName != null) {
            try {
                c = baseContext.createPackageContext(packageName, 0);
            }
            catch (PackageManager.NameNotFoundException e) {
                c = baseContext;
            }
        } else {
            c = baseContext;
        }
        Resources r = c.getResources();
        try {
            return r.getResourceName(id2);
        }
        catch (Resources.NotFoundException e) {
            return "<name unknown>";
        }
    }

    public final String toString() {
        return String.format("NotificationRecord(0x%08x: pkg=%s user=%s id=%d tag=%s importance=%d key=%sappImportanceLocked=%s: %s)", System.identityHashCode(this), this.sbn.getPackageName(), this.sbn.getUser(), this.sbn.getId(), this.sbn.getTag(), this.mImportance, this.sbn.getKey(), this.mIsAppImportanceLocked, this.sbn.getNotification());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasAdjustment(String key) {
        List<Adjustment> list = this.mAdjustments;
        synchronized (list) {
            Adjustment adjustment;
            Iterator<Adjustment> iterator = this.mAdjustments.iterator();
            do {
                if (!iterator.hasNext()) return false;
            } while (!(adjustment = iterator.next()).getSignals().containsKey(key));
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdjustment(Adjustment adjustment) {
        List<Adjustment> list = this.mAdjustments;
        synchronized (list) {
            this.mAdjustments.add(adjustment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAdjustments() {
        long now = System.currentTimeMillis();
        List<Adjustment> list = this.mAdjustments;
        synchronized (list) {
            for (Adjustment adjustment : this.mAdjustments) {
                Bundle signals = adjustment.getSignals();
                if (signals.containsKey("key_people")) {
                    ArrayList<String> people = adjustment.getSignals().getStringArrayList("key_people");
                    this.setPeopleOverride(people);
                }
                if (signals.containsKey("key_snooze_criteria")) {
                    ArrayList<SnoozeCriterion> snoozeCriterionList = adjustment.getSignals().getParcelableArrayList("key_snooze_criteria");
                    this.setSnoozeCriteria(snoozeCriterionList);
                }
                if (signals.containsKey("key_group_key")) {
                    String groupOverrideKey = adjustment.getSignals().getString("key_group_key");
                    this.setOverrideGroupKey(groupOverrideKey);
                }
                if (signals.containsKey("key_user_sentiment") && !this.mIsAppImportanceLocked && (this.getChannel().getUserLockedFields() & 4) == 0) {
                    this.setUserSentiment(adjustment.getSignals().getInt("key_user_sentiment", 0));
                }
                if (signals.containsKey("key_contextual_actions")) {
                    this.setSystemGeneratedSmartActions(signals.getParcelableArrayList("key_contextual_actions"));
                }
                if (signals.containsKey("key_text_replies")) {
                    this.setSmartReplies(signals.getCharSequenceArrayList("key_text_replies"));
                }
                if (signals.containsKey("key_importance")) {
                    int importance = signals.getInt("key_importance");
                    importance = Math.max(-1000, importance);
                    importance = Math.min(4, importance);
                    this.setAssistantImportance(importance);
                }
                if (signals.isEmpty() || adjustment.getIssuer() == null) continue;
                this.mAdjustmentIssuer = adjustment.getIssuer();
            }
            this.mAdjustments.clear();
        }
    }

    public void setIsAppImportanceLocked(boolean isAppImportanceLocked) {
        this.mIsAppImportanceLocked = isAppImportanceLocked;
        this.calculateUserSentiment();
    }

    public void setContactAffinity(float contactAffinity) {
        this.mContactAffinity = contactAffinity;
    }

    public float getContactAffinity() {
        return this.mContactAffinity;
    }

    public void setRecentlyIntrusive(boolean recentlyIntrusive) {
        this.mRecentlyIntrusive = recentlyIntrusive;
        if (recentlyIntrusive) {
            this.mLastIntrusive = System.currentTimeMillis();
        }
    }

    public boolean isRecentlyIntrusive() {
        return this.mRecentlyIntrusive;
    }

    public long getLastIntrusive() {
        return this.mLastIntrusive;
    }

    public void setPackagePriority(int packagePriority) {
        this.mPackagePriority = packagePriority;
    }

    public int getPackagePriority() {
        return this.mPackagePriority;
    }

    public void setPackageVisibilityOverride(int packageVisibility) {
        this.mPackageVisibility = packageVisibility;
    }

    public int getPackageVisibilityOverride() {
        return this.mPackageVisibility;
    }

    private String getUserExplanation() {
        if (this.mUserExplanation == null) {
            this.mUserExplanation = this.mContext.getResources().getString(17040133);
        }
        return this.mUserExplanation;
    }

    public void setSystemImportance(int importance) {
        this.mSystemImportance = importance;
        this.calculateImportance();
    }

    public void setAssistantImportance(int importance) {
        this.mAssistantImportance = importance;
    }

    public int getAssistantImportance() {
        return this.mAssistantImportance;
    }

    protected void calculateImportance() {
        this.mImportance = this.calculateInitialImportance();
        this.mImportanceExplanationCode = this.mInitialImportanceExplanationCode;
        if (!(this.getChannel().hasUserSetImportance() || this.mAssistantImportance == -1000 || this.getChannel().isImportanceLockedByOEM() || this.getChannel().isImportanceLockedByCriticalDeviceFunction())) {
            this.mImportance = this.mAssistantImportance;
            this.mImportanceExplanationCode = 3;
        }
        if (this.mSystemImportance != -1000) {
            this.mImportance = this.mSystemImportance;
            this.mImportanceExplanationCode = 4;
        }
    }

    public int getImportance() {
        return this.mImportance;
    }

    public CharSequence getImportanceExplanation() {
        switch (this.mImportanceExplanationCode) {
            case 0: {
                return null;
            }
            case 1: 
            case 5: {
                return "app";
            }
            case 2: {
                return "user";
            }
            case 3: {
                return "asst";
            }
            case 4: {
                return "system";
            }
        }
        return null;
    }

    public boolean setIntercepted(boolean intercept) {
        this.mIntercept = intercept;
        return this.mIntercept;
    }

    public void setCriticality(int criticality) {
        this.mCriticality = criticality;
    }

    public int getCriticality() {
        return this.mCriticality;
    }

    public boolean isIntercepted() {
        return this.mIntercept;
    }

    public boolean isNewEnoughForAlerting(long now) {
        return this.getFreshnessMs(now) <= 2000;
    }

    public void setHidden(boolean hidden) {
        this.mHidden = hidden;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    public void setSuppressedVisualEffects(int effects) {
        this.mSuppressedVisualEffects = effects;
    }

    public int getSuppressedVisualEffects() {
        return this.mSuppressedVisualEffects;
    }

    public boolean isCategory(String category) {
        return Objects.equals(this.getNotification().category, category);
    }

    public boolean isAudioAttributesUsage(int usage) {
        return this.mAttributes != null && this.mAttributes.getUsage() == usage;
    }

    public long getRankingTimeMs() {
        return this.mRankingTimeMs;
    }

    public int getFreshnessMs(long now) {
        return (int)(now - this.mUpdateTimeMs);
    }

    public int getLifespanMs(long now) {
        return (int)(now - this.mCreationTimeMs);
    }

    public int getExposureMs(long now) {
        return this.mVisibleSinceMs == 0L ? 0 : (int)(now - this.mVisibleSinceMs);
    }

    public int getInterruptionMs(long now) {
        return (int)(now - this.mInterruptionTimeMs);
    }

    public void setVisibility(boolean visible, int rank, int count) {
        long now = System.currentTimeMillis();
        this.mVisibleSinceMs = visible ? now : this.mVisibleSinceMs;
        this.stats.onVisibilityChanged(visible);
        MetricsLogger.action(this.getLogMaker(now).setCategory(128).setType(visible ? 1 : 2).addTaggedData(798, rank).addTaggedData(1395, count));
        if (visible) {
            this.setSeen();
            MetricsLogger.histogram(this.mContext, "note_freshness", this.getFreshnessMs(now));
        }
        EventLogTags.writeNotificationVisibility(this.getKey(), visible ? 1 : 0, this.getLifespanMs(now), this.getFreshnessMs(now), 0, rank);
    }

    private long calculateRankingTimeMs(long previousRankingTimeMs) {
        Notification n = this.getNotification();
        if (n.when != 0L && n.when <= this.sbn.getPostTime()) {
            return n.when;
        }
        if (previousRankingTimeMs > 0L) {
            return previousRankingTimeMs;
        }
        return this.sbn.getPostTime();
    }

    public void setGlobalSortKey(String globalSortKey) {
        this.mGlobalSortKey = globalSortKey;
    }

    public String getGlobalSortKey() {
        return this.mGlobalSortKey;
    }

    public boolean isSeen() {
        return this.mStats.hasSeen();
    }

    public void setSeen() {
        this.mStats.setSeen();
        if (this.mTextChanged) {
            this.setInterruptive(true);
        }
    }

    public void setAuthoritativeRank(int authoritativeRank) {
        this.mAuthoritativeRank = authoritativeRank;
    }

    public int getAuthoritativeRank() {
        return this.mAuthoritativeRank;
    }

    public String getGroupKey() {
        return this.sbn.getGroupKey();
    }

    public void setOverrideGroupKey(String overrideGroupKey) {
        this.sbn.setOverrideGroupKey(overrideGroupKey);
    }

    public NotificationChannel getChannel() {
        return this.mChannel;
    }

    public boolean getIsAppImportanceLocked() {
        return this.mIsAppImportanceLocked;
    }

    protected void updateNotificationChannel(NotificationChannel channel) {
        if (channel != null) {
            this.mChannel = channel;
            this.calculateImportance();
            this.calculateUserSentiment();
        }
    }

    public void setShowBadge(boolean showBadge) {
        this.mShowBadge = showBadge;
    }

    public boolean canBubble() {
        return this.mAllowBubble;
    }

    public void setAllowBubble(boolean allow) {
        this.mAllowBubble = allow;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    public Light getLight() {
        return this.mLight;
    }

    public Uri getSound() {
        return this.mSound;
    }

    public long[] getVibration() {
        return this.mVibration;
    }

    public AudioAttributes getAudioAttributes() {
        return this.mAttributes;
    }

    public ArrayList<String> getPeopleOverride() {
        return this.mPeopleOverride;
    }

    public void setInterruptive(boolean interruptive) {
        this.mIsInterruptive = interruptive;
        long now = System.currentTimeMillis();
        long l = this.mInterruptionTimeMs = interruptive ? now : this.mInterruptionTimeMs;
        if (interruptive) {
            MetricsLogger.action(this.getLogMaker().setCategory(1501).setType(1).addTaggedData(1500, this.getInterruptionMs(now)));
            MetricsLogger.histogram(this.mContext, "note_interruptive", this.getInterruptionMs(now));
        }
    }

    public void setAudiblyAlerted(boolean audiblyAlerted) {
        this.mLastAudiblyAlertedMs = audiblyAlerted ? System.currentTimeMillis() : -1L;
    }

    public void setTextChanged(boolean textChanged) {
        this.mTextChanged = textChanged;
    }

    public void setRecordedInterruption(boolean recorded) {
        this.mRecordedInterruption = recorded;
    }

    public boolean hasRecordedInterruption() {
        return this.mRecordedInterruption;
    }

    public boolean isInterruptive() {
        return this.mIsInterruptive;
    }

    public long getLastAudiblyAlertedMs() {
        return this.mLastAudiblyAlertedMs;
    }

    protected void setPeopleOverride(ArrayList<String> people) {
        this.mPeopleOverride = people;
    }

    public ArrayList<SnoozeCriterion> getSnoozeCriteria() {
        return this.mSnoozeCriteria;
    }

    protected void setSnoozeCriteria(ArrayList<SnoozeCriterion> snoozeCriteria) {
        this.mSnoozeCriteria = snoozeCriteria;
    }

    private void calculateUserSentiment() {
        if ((this.getChannel().getUserLockedFields() & 4) != 0 || this.mIsAppImportanceLocked) {
            this.mUserSentiment = 1;
        }
    }

    private void setUserSentiment(int userSentiment) {
        this.mUserSentiment = userSentiment;
    }

    public int getUserSentiment() {
        return this.mUserSentiment;
    }

    public NotificationStats getStats() {
        return this.mStats;
    }

    public void recordExpanded() {
        this.mStats.setExpanded();
    }

    public void recordDirectReplied() {
        this.mStats.setDirectReplied();
    }

    public void recordDismissalSurface(int surface) {
        this.mStats.setDismissalSurface(surface);
    }

    public void recordDismissalSentiment(int sentiment) {
        this.mStats.setDismissalSentiment(sentiment);
    }

    public void recordSnoozed() {
        this.mStats.setSnoozed();
    }

    public void recordViewedSettings() {
        this.mStats.setViewedSettings();
    }

    public void setNumSmartRepliesAdded(int noReplies) {
        this.mNumberOfSmartRepliesAdded = noReplies;
    }

    public int getNumSmartRepliesAdded() {
        return this.mNumberOfSmartRepliesAdded;
    }

    public void setNumSmartActionsAdded(int noActions) {
        this.mNumberOfSmartActionsAdded = noActions;
    }

    public int getNumSmartActionsAdded() {
        return this.mNumberOfSmartActionsAdded;
    }

    public void setSuggestionsGeneratedByAssistant(boolean generatedByAssistant) {
        this.mSuggestionsGeneratedByAssistant = generatedByAssistant;
    }

    public boolean getSuggestionsGeneratedByAssistant() {
        return this.mSuggestionsGeneratedByAssistant;
    }

    public boolean getEditChoicesBeforeSending() {
        return this.mEditChoicesBeforeSending;
    }

    public void setEditChoicesBeforeSending(boolean editChoicesBeforeSending) {
        this.mEditChoicesBeforeSending = editChoicesBeforeSending;
    }

    public boolean hasSeenSmartReplies() {
        return this.mHasSeenSmartReplies;
    }

    public void setSeenSmartReplies(boolean hasSeenSmartReplies) {
        this.mHasSeenSmartReplies = hasSeenSmartReplies;
    }

    public boolean hasBeenVisiblyExpanded() {
        return this.stats.hasBeenVisiblyExpanded();
    }

    public void setSystemGeneratedSmartActions(ArrayList<Notification.Action> systemGeneratedSmartActions) {
        this.mSystemGeneratedSmartActions = systemGeneratedSmartActions;
    }

    public ArrayList<Notification.Action> getSystemGeneratedSmartActions() {
        return this.mSystemGeneratedSmartActions;
    }

    public void setSmartReplies(ArrayList<CharSequence> smartReplies) {
        this.mSmartReplies = smartReplies;
    }

    public ArrayList<CharSequence> getSmartReplies() {
        return this.mSmartReplies;
    }

    public boolean isProxied() {
        return !Objects.equals(this.sbn.getPackageName(), this.sbn.getOpPkg());
    }

    public ArraySet<Uri> getGrantableUris() {
        return this.mGrantableUris;
    }

    protected void calculateGrantableUris() {
        NotificationChannel channel;
        Notification notification = this.getNotification();
        notification.visitUris(uri -> this.visitGrantableUri((Uri)uri, false));
        if (notification.getChannelId() != null && (channel = this.getChannel()) != null) {
            this.visitGrantableUri(channel.getSound(), (channel.getUserLockedFields() & 0x20) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitGrantableUri(Uri uri, boolean userOverriddenUri) {
        if (uri == null || !"content".equals(uri.getScheme())) {
            return;
        }
        int sourceUid = this.sbn.getUid();
        if (sourceUid == 1000) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mUgmInternal.checkGrantUriPermission(sourceUid, null, ContentProvider.getUriWithoutUserId(uri), 1, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(sourceUid)));
            if (this.mGrantableUris == null) {
                this.mGrantableUris = new ArraySet();
            }
            this.mGrantableUris.add(uri);
        }
        catch (SecurityException e) {
            if (!userOverriddenUri) {
                if (this.mTargetSdkVersion >= 28) {
                    throw e;
                }
                Log.w(TAG, "Ignoring " + uri + " from " + sourceUid + ": " + e.getMessage());
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    public LogMaker getLogMaker(long now) {
        LogMaker lm = this.sbn.getLogMaker().addTaggedData(858, this.mImportance).addTaggedData(793, this.getLifespanMs(now)).addTaggedData(795, this.getFreshnessMs(now)).addTaggedData(794, this.getExposureMs(now)).addTaggedData(1500, this.getInterruptionMs(now));
        if (this.mImportanceExplanationCode != 0) {
            lm.addTaggedData(1688, this.mImportanceExplanationCode);
            if ((this.mImportanceExplanationCode == 3 || this.mImportanceExplanationCode == 4) && this.stats.naturalImportance != -1000) {
                lm.addTaggedData(1690, this.mInitialImportanceExplanationCode);
                lm.addTaggedData(1689, this.stats.naturalImportance);
            }
        }
        if (this.mAssistantImportance != -1000) {
            lm.addTaggedData(1691, this.mAssistantImportance);
        }
        if (this.mAdjustmentIssuer != null) {
            lm.addTaggedData(1742, this.mAdjustmentIssuer.hashCode());
        }
        return lm;
    }

    public LogMaker getLogMaker() {
        return this.getLogMaker(System.currentTimeMillis());
    }

    public LogMaker getItemLogMaker() {
        return this.getLogMaker().setCategory(128);
    }

    @VisibleForTesting
    static final class Light {
        public final int color;
        public final int onMs;
        public final int offMs;

        public Light(int color2, int onMs, int offMs) {
            this.color = color2;
            this.onMs = onMs;
            this.offMs = offMs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Light light = (Light)o;
            if (this.color != light.color) {
                return false;
            }
            if (this.onMs != light.onMs) {
                return false;
            }
            return this.offMs == light.offMs;
        }

        public int hashCode() {
            int result = this.color;
            result = 31 * result + this.onMs;
            result = 31 * result + this.offMs;
            return result;
        }

        public String toString() {
            return "Light{color=" + this.color + ", onMs=" + this.onMs + ", offMs=" + this.offMs + '}';
        }
    }
}

