/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.INotificationManager;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.app.Person;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Slog;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.Collections;

public class NotificationShellCmd
extends ShellCommand {
    private static final String USAGE = "usage: cmd notification SUBCMD [args]\n\nSUBCMDs:\n  allow_listener COMPONENT [user_id (current user if not specified)]\n  disallow_listener COMPONENT [user_id (current user if not specified)]\n  allow_assistant COMPONENT [user_id (current user if not specified)]\n  remove_assistant COMPONENT [user_id (current user if not specified)]\n  allow_dnd PACKAGE [user_id (current user if not specified)]\n  disallow_dnd PACKAGE [user_id (current user if not specified)]\n  suspend_package PACKAGE\n  unsuspend_package PACKAGE\n  reset_assistant_user_set [user_id (current user if not specified)]\n  get_approved_assistant [user_id (current user if not specified)]\n  post [--help | flags] TAG TEXT";
    private static final String NOTIFY_USAGE = "usage: cmd notification post [flags] <tag> <text>\n\nflags:\n  -h|--help\n  -v|--verbose\n  -t|--title <text>\n  -i|--icon <iconspec>\n  -I|--large-icon <iconspec>\n  -S|--style <style> [styleargs]\n  -c|--content-intent <intentspec>\n\nstyles: (default none)\n  bigtext\n  bigpicture --picture <iconspec>\n  inbox --line <text> --line <text> ...\n  messaging --conversation <title> --message <who>:<text> ...\n  media\n\nan <iconspec> is one of\n  file:///data/local/tmp/<img.png>\n  content://<provider>/<path>\n  @[<package>:]drawable/<img>\n  data:base64,<B64DATA==>\n\nan <intentspec> is (broadcast|service|activity) <args>\n  <args> are as described in `am start`";
    public static final int NOTIFICATION_ID = 1138;
    public static final String NOTIFICATION_PACKAGE = "com.android.shell";
    public static final String CHANNEL_ID = "shellcmd";
    public static final String CHANNEL_NAME = "Shell command";
    public static final int CHANNEL_IMP = 3;
    private final NotificationManagerService mDirectService;
    private final INotificationManager mBinderService;

    public NotificationShellCmd(NotificationManagerService service) {
        this.mDirectService = service;
        this.mBinderService = service.getBinderService();
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd.replace('-', '_')) {
                case "allow_dnd": {
                    String packageName = this.getNextArgRequired();
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationPolicyAccessGrantedForUser(packageName, userId, true);
                    break;
                }
                case "disallow_dnd": {
                    String packageName = this.getNextArgRequired();
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationPolicyAccessGrantedForUser(packageName, userId, false);
                    break;
                }
                case "allow_listener": {
                    ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                    if (cn == null) {
                        pw.println("Invalid listener - must be a ComponentName");
                        return -1;
                    }
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationListenerAccessGrantedForUser(cn, userId, true);
                    break;
                }
                case "disallow_listener": {
                    ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                    if (cn == null) {
                        pw.println("Invalid listener - must be a ComponentName");
                        return -1;
                    }
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationListenerAccessGrantedForUser(cn, userId, false);
                    break;
                }
                case "allow_assistant": {
                    ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                    if (cn == null) {
                        pw.println("Invalid assistant - must be a ComponentName");
                        return -1;
                    }
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationAssistantAccessGrantedForUser(cn, userId, true);
                    break;
                }
                case "disallow_assistant": {
                    ComponentName cn = ComponentName.unflattenFromString(this.getNextArgRequired());
                    if (cn == null) {
                        pw.println("Invalid assistant - must be a ComponentName");
                        return -1;
                    }
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mBinderService.setNotificationAssistantAccessGrantedForUser(cn, userId, false);
                    break;
                }
                case "suspend_package": {
                    this.mDirectService.simulatePackageSuspendBroadcast(true, this.getNextArgRequired());
                    break;
                }
                case "unsuspend_package": {
                    this.mDirectService.simulatePackageSuspendBroadcast(false, this.getNextArgRequired());
                    break;
                }
                case "distract_package": {
                    this.mDirectService.simulatePackageDistractionBroadcast(Integer.parseInt(this.getNextArgRequired()), this.getNextArgRequired().split(","));
                    break;
                }
                case "reset_assistant_user_set": {
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    this.mDirectService.resetAssistantUserSet(userId);
                    break;
                }
                case "get_approved_assistant": {
                    ComponentName approvedAssistant;
                    int userId = ActivityManager.getCurrentUser();
                    if (this.peekNextArg() != null) {
                        userId = Integer.parseInt(this.getNextArgRequired());
                    }
                    if ((approvedAssistant = this.mDirectService.getApprovedAssistant(userId)) == null) {
                        pw.println("null");
                        break;
                    }
                    pw.println(approvedAssistant.flattenToString());
                    break;
                }
                case "post": 
                case "notify": {
                    this.doNotify(pw);
                    break;
                }
                default: {
                    return this.handleDefaultCommands(cmd);
                }
            }
        }
        catch (Exception e) {
            pw.println("Error occurred. Check logcat for details. " + e.getMessage());
            Slog.e("NotificationService", "Error running shell command", e);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureChannel() throws RemoteException {
        int uid = Binder.getCallingUid();
        int userid = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            if (this.mBinderService.getNotificationChannelForPackage(NOTIFICATION_PACKAGE, uid, CHANNEL_ID, false) == null) {
                NotificationChannel chan = new NotificationChannel(CHANNEL_ID, CHANNEL_NAME, 3);
                Slog.v("NotificationService", "creating shell channel for user " + userid + " uid " + uid + ": " + chan);
                this.mBinderService.createNotificationChannelsForPackage(NOTIFICATION_PACKAGE, uid, new ParceledListSlice<NotificationChannel>(Collections.singletonList(chan)));
                Slog.v("NotificationService", "created channel: " + this.mBinderService.getNotificationChannelForPackage(NOTIFICATION_PACKAGE, uid, CHANNEL_ID, false));
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    Icon parseIcon(Resources res, String encoded) throws IllegalArgumentException {
        if (TextUtils.isEmpty(encoded)) {
            return null;
        }
        if (encoded.startsWith("/")) {
            encoded = "file://" + encoded;
        }
        if (encoded.startsWith("http:") || encoded.startsWith("https:") || encoded.startsWith("content:") || encoded.startsWith("file:") || encoded.startsWith("android.resource:")) {
            Uri asUri = Uri.parse(encoded);
            return Icon.createWithContentUri(asUri);
        }
        if (encoded.startsWith("@")) {
            int resid = res.getIdentifier(encoded.substring(1), "drawable", "android");
            if (resid != 0) {
                return Icon.createWithResource(res, resid);
            }
        } else if (encoded.startsWith("data:")) {
            encoded = encoded.substring(encoded.indexOf(44) + 1);
            byte[] bits = Base64.decode(encoded, 0);
            return Icon.createWithData(bits, 0, bits.length);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doNotify(PrintWriter pw) throws RemoteException, URISyntaxException {
        String opt;
        Context context = this.mDirectService.getContext();
        Resources res = context.getResources();
        Notification.Builder builder = new Notification.Builder(context, CHANNEL_ID);
        boolean verbose = false;
        Notification.BigPictureStyle bigPictureStyle = null;
        Notification.BigTextStyle bigTextStyle = null;
        Notification.InboxStyle inboxStyle = null;
        Notification.MediaStyle mediaStyle = null;
        Notification.MessagingStyle messagingStyle = null;
        Icon smallIcon = null;
        while ((opt = this.getNextOption()) != null) {
            boolean large = false;
            block34 : switch (opt) {
                case "-v": 
                case "--verbose": {
                    verbose = true;
                    break;
                }
                case "-t": 
                case "--title": 
                case "title": {
                    builder.setContentTitle(this.getNextArgRequired());
                    break;
                }
                case "-I": 
                case "--large-icon": 
                case "--largeicon": 
                case "largeicon": 
                case "large-icon": {
                    large = true;
                }
                case "-i": 
                case "--icon": 
                case "icon": {
                    String iconSpec = this.getNextArgRequired();
                    Icon icon = this.parseIcon(res, iconSpec);
                    if (icon == null) {
                        pw.println("error: invalid icon: " + iconSpec);
                        return -1;
                    }
                    if (large) {
                        builder.setLargeIcon(icon);
                        large = false;
                        break;
                    }
                    smallIcon = icon;
                    break;
                }
                case "-c": 
                case "--content-intent": 
                case "content-intent": 
                case "--intent": 
                case "intent": {
                    String intentKind = null;
                    switch (this.peekNextArg()) {
                        case "broadcast": 
                        case "service": 
                        case "activity": {
                            intentKind = this.getNextArg();
                        }
                    }
                    Intent intent = Intent.parseCommandArgs(this, null);
                    if (intent.getData() == null) {
                        intent.setData(Uri.parse("xyz:" + System.currentTimeMillis()));
                    }
                    PendingIntent pi = "broadcast".equals(intentKind) ? PendingIntent.getBroadcastAsUser(context, 0, intent, 0x8000000, UserHandle.CURRENT) : ("service".equals(intentKind) ? PendingIntent.getService(context, 0, intent, 0x8000000) : PendingIntent.getActivityAsUser(context, 0, intent, 0x8000000, null, UserHandle.CURRENT));
                    builder.setContentIntent(pi);
                    break;
                }
                case "-S": 
                case "--style": {
                    String styleSpec;
                    switch (styleSpec = this.getNextArgRequired().toLowerCase()) {
                        case "bigtext": {
                            bigTextStyle = new Notification.BigTextStyle();
                            builder.setStyle(bigTextStyle);
                            break block34;
                        }
                        case "bigpicture": {
                            bigPictureStyle = new Notification.BigPictureStyle();
                            builder.setStyle(bigPictureStyle);
                            break block34;
                        }
                        case "inbox": {
                            inboxStyle = new Notification.InboxStyle();
                            builder.setStyle(inboxStyle);
                            break block34;
                        }
                        case "messaging": {
                            String name = "You";
                            if ("--user".equals(this.peekNextArg())) {
                                this.getNextArg();
                                name = this.getNextArgRequired();
                            }
                            messagingStyle = new Notification.MessagingStyle(new Person.Builder().setName(name).build());
                            builder.setStyle(messagingStyle);
                            break block34;
                        }
                        case "media": {
                            mediaStyle = new Notification.MediaStyle();
                            builder.setStyle(mediaStyle);
                            break block34;
                        }
                    }
                    throw new IllegalArgumentException("unrecognized notification style: " + styleSpec);
                }
                case "--bigText": 
                case "--bigtext": 
                case "--big-text": {
                    if (bigTextStyle == null) {
                        throw new IllegalArgumentException("--bigtext requires --style bigtext");
                    }
                    bigTextStyle.bigText(this.getNextArgRequired());
                    break;
                }
                case "--picture": {
                    if (bigPictureStyle == null) {
                        throw new IllegalArgumentException("--picture requires --style bigpicture");
                    }
                    String pictureSpec = this.getNextArgRequired();
                    Icon pictureAsIcon = this.parseIcon(res, pictureSpec);
                    if (pictureAsIcon == null) {
                        throw new IllegalArgumentException("bad picture spec: " + pictureSpec);
                    }
                    Drawable d = pictureAsIcon.loadDrawable(context);
                    if (d instanceof BitmapDrawable) {
                        bigPictureStyle.bigPicture(((BitmapDrawable)d).getBitmap());
                        break;
                    }
                    throw new IllegalArgumentException("not a bitmap: " + pictureSpec);
                }
                case "--line": {
                    if (inboxStyle == null) {
                        throw new IllegalArgumentException("--line requires --style inbox");
                    }
                    inboxStyle.addLine(this.getNextArgRequired());
                    break;
                }
                case "--message": {
                    if (messagingStyle == null) {
                        throw new IllegalArgumentException("--message requires --style messaging");
                    }
                    String arg = this.getNextArgRequired();
                    String[] parts = arg.split(":", 2);
                    if (parts.length > 1) {
                        messagingStyle.addMessage((CharSequence)parts[1], System.currentTimeMillis(), parts[0]);
                        break;
                    }
                    messagingStyle.addMessage((CharSequence)parts[0], System.currentTimeMillis(), (new String[]{messagingStyle.getUserDisplayName().toString(), "Them"})[messagingStyle.getMessages().size() % 2]);
                    break;
                }
                case "--conversation": {
                    if (messagingStyle == null) {
                        throw new IllegalArgumentException("--conversation requires --style messaging");
                    }
                    messagingStyle.setConversationTitle(this.getNextArgRequired());
                    break;
                }
                default: {
                    pw.println(NOTIFY_USAGE);
                    return 0;
                }
            }
        }
        String tag = this.getNextArg();
        String text = this.getNextArg();
        if (tag == null || text == null) {
            pw.println(NOTIFY_USAGE);
            return -1;
        }
        builder.setContentText(text);
        if (smallIcon == null) {
            builder.setSmallIcon(17301623);
        } else {
            builder.setSmallIcon(smallIcon);
        }
        this.ensureChannel();
        Notification n = builder.build();
        pw.println("posting:\n  " + n);
        Slog.v("NotificationManager", "posting: " + n);
        int userId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            this.mBinderService.enqueueNotificationWithTag(NOTIFICATION_PACKAGE, "android", tag, 1138, n, userId);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        if (verbose) {
            NotificationRecord nr = this.mDirectService.findNotificationLocked(NOTIFICATION_PACKAGE, tag, 1138, userId);
            int tries = 3;
            while (tries-- > 0 && nr == null) {
                try {
                    pw.println("waiting for notification to post...");
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                nr = this.mDirectService.findNotificationLocked(NOTIFICATION_PACKAGE, tag, 1138, userId);
            }
            if (nr == null) {
                pw.println("warning: couldn't find notification after enqueueing");
            } else {
                pw.println("posted: ");
                nr.dump(pw, "  ", context, false);
            }
        }
        return 0;
    }

    @Override
    public void onHelp() {
        this.getOutPrintWriter().println(USAGE);
    }
}

