/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.metrics.LogMaker;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.NotificationListenerService;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.ZenModeHelper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PreferencesHelper
implements RankingConfig {
    private static final String TAG = "NotificationPrefHelper";
    private static final int XML_VERSION = 1;
    private static final int UNKNOWN_UID = -10000;
    private static final String NON_BLOCKABLE_CHANNEL_DELIM = ":";
    @VisibleForTesting
    static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String TAG_CHANNEL = "channel";
    private static final String TAG_GROUP = "channelGroup";
    private static final String TAG_DELEGATE = "delegate";
    private static final String TAG_STATUS_ICONS = "silent_status_icons";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_ID = "id";
    private static final String ATT_ALLOW_BUBBLE = "allow_bubble";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_VISIBILITY = "visibility";
    private static final String ATT_IMPORTANCE = "importance";
    private static final String ATT_SHOW_BADGE = "show_badge";
    private static final String ATT_APP_USER_LOCKED_FIELDS = "app_user_locked_fields";
    private static final String ATT_ENABLED = "enabled";
    private static final String ATT_USER_ALLOWED = "allowed";
    private static final String ATT_HIDE_SILENT = "hide_gentle";
    private static final int DEFAULT_PRIORITY = 0;
    private static final int DEFAULT_VISIBILITY = -1000;
    private static final int DEFAULT_IMPORTANCE = -1000;
    @VisibleForTesting
    static final boolean DEFAULT_HIDE_SILENT_STATUS_BAR_ICONS = false;
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final boolean DEFAULT_ALLOW_BUBBLE = true;
    private static final boolean DEFAULT_OEM_LOCKED_IMPORTANCE = false;
    private static final boolean DEFAULT_APP_LOCKED_IMPORTANCE = false;
    private static final int DEFAULT_LOCKED_APP_FIELDS = 0;
    private final ArrayMap<String, PackagePreferences> mPackagePreferences = new ArrayMap();
    private final ArrayMap<String, PackagePreferences> mRestoredWithoutUids = new ArrayMap();
    private final Context mContext;
    private final PackageManager mPm;
    private final RankingHandler mRankingHandler;
    private final ZenModeHelper mZenModeHelper;
    private SparseBooleanArray mBadgingEnabled;
    private SparseBooleanArray mBubblesEnabled;
    private boolean mAreChannelsBypassingDnd;
    private boolean mHideSilentStatusBarIcons = false;

    public PreferencesHelper(Context context, PackageManager pm, RankingHandler rankingHandler, ZenModeHelper zenHelper) {
        this.mContext = context;
        this.mZenModeHelper = zenHelper;
        this.mRankingHandler = rankingHandler;
        this.mPm = pm;
        this.updateBadgingEnabled();
        this.updateBubblesEnabled();
        this.syncChannelsBypassingDnd(this.mContext.getUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXml(XmlPullParser parser, boolean forRestore, int userId) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            this.mRestoredWithoutUids.clear();
            while ((type = parser.next()) != 1) {
                tag = parser.getName();
                if (type == 3 && TAG_RANKING.equals(tag)) {
                    return;
                }
                if (type != 2) continue;
                if (TAG_STATUS_ICONS.equals(tag)) {
                    if (forRestore && userId != 0) continue;
                    this.mHideSilentStatusBarIcons = XmlUtils.readBooleanAttribute(parser, ATT_HIDE_SILENT, false);
                    continue;
                }
                if (!TAG_PACKAGE.equals(tag)) continue;
                int uid = XmlUtils.readIntAttribute(parser, ATT_UID, -10000);
                String name = parser.getAttributeValue(null, ATT_NAME);
                if (TextUtils.isEmpty(name)) continue;
                if (forRestore) {
                    try {
                        uid = this.mPm.getPackageUidAsUser(name, userId);
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                PackagePreferences r = this.getOrCreatePackagePreferencesLocked(name, uid, XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000), XmlUtils.readIntAttribute(parser, ATT_PRIORITY, 0), XmlUtils.readIntAttribute(parser, ATT_VISIBILITY, -1000), XmlUtils.readBooleanAttribute(parser, ATT_SHOW_BADGE, true), XmlUtils.readBooleanAttribute(parser, ATT_ALLOW_BUBBLE, true));
                r.importance = XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000);
                r.priority = XmlUtils.readIntAttribute(parser, ATT_PRIORITY, 0);
                r.visibility = XmlUtils.readIntAttribute(parser, ATT_VISIBILITY, -1000);
                r.showBadge = XmlUtils.readBooleanAttribute(parser, ATT_SHOW_BADGE, true);
                r.lockedAppFields = XmlUtils.readIntAttribute(parser, ATT_APP_USER_LOCKED_FIELDS, 0);
                int innerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > innerDepth)) {
                    String id2;
                    if (type == 3 || type == 4) continue;
                    String tagName = parser.getName();
                    if (TAG_GROUP.equals(tagName)) {
                        id2 = parser.getAttributeValue(null, ATT_ID);
                        String groupName = parser.getAttributeValue(null, ATT_NAME);
                        if (!TextUtils.isEmpty(id2)) {
                            NotificationChannelGroup group = new NotificationChannelGroup(id2, groupName);
                            group.populateFromXml(parser);
                            r.groups.put(id2, group);
                        }
                    }
                    if (TAG_CHANNEL.equals(tagName)) {
                        id2 = parser.getAttributeValue(null, ATT_ID);
                        String channelName = parser.getAttributeValue(null, ATT_NAME);
                        int channelImportance = XmlUtils.readIntAttribute(parser, ATT_IMPORTANCE, -1000);
                        if (!TextUtils.isEmpty(id2) && !TextUtils.isEmpty(channelName)) {
                            NotificationChannel channel = new NotificationChannel(id2, channelName, channelImportance);
                            if (forRestore) {
                                channel.populateFromXmlForRestore(parser, this.mContext);
                            } else {
                                channel.populateFromXml(parser);
                            }
                            channel.setImportanceLockedByCriticalDeviceFunction(r.defaultAppLockedImportance);
                            r.channels.put(id2, channel);
                        }
                    }
                    if (!TAG_DELEGATE.equals(tagName)) continue;
                    int delegateId = XmlUtils.readIntAttribute(parser, ATT_UID, -10000);
                    String delegateName = XmlUtils.readStringAttribute(parser, ATT_NAME);
                    boolean delegateEnabled = XmlUtils.readBooleanAttribute(parser, ATT_ENABLED, true);
                    boolean userAllowed = XmlUtils.readBooleanAttribute(parser, ATT_USER_ALLOWED, true);
                    Delegate d = null;
                    if (delegateId != -10000 && !TextUtils.isEmpty(delegateName)) {
                        d = new Delegate(delegateName, delegateId, delegateEnabled, userAllowed);
                    }
                    r.delegate = d;
                }
                try {
                    this.deleteDefaultChannelIfNeededLocked(r);
                }
                catch (PackageManager.NameNotFoundException e) {
                    Slog.e(TAG, "deleteDefaultChannelIfNeededLocked - Exception: " + e);
                }
            }
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private PackagePreferences getPackagePreferencesLocked(String pkg, int uid) {
        String key = PreferencesHelper.packagePreferencesKey(pkg, uid);
        return this.mPackagePreferences.get(key);
    }

    private PackagePreferences getOrCreatePackagePreferencesLocked(String pkg, int uid) {
        return this.getOrCreatePackagePreferencesLocked(pkg, uid, -1000, 0, -1000, true, true);
    }

    private PackagePreferences getOrCreatePackagePreferencesLocked(String pkg, int uid, int importance, int priority, int visibility, boolean showBadge, boolean allowBubble) {
        PackagePreferences r;
        String key = PreferencesHelper.packagePreferencesKey(pkg, uid);
        PackagePreferences packagePreferences = r = uid == -10000 ? this.mRestoredWithoutUids.get(pkg) : this.mPackagePreferences.get(key);
        if (r == null) {
            r = new PackagePreferences();
            r.pkg = pkg;
            r.uid = uid;
            r.importance = importance;
            r.priority = priority;
            r.visibility = visibility;
            r.showBadge = showBadge;
            r.allowBubble = allowBubble;
            try {
                this.createDefaultChannelIfNeededLocked(r);
            }
            catch (PackageManager.NameNotFoundException e) {
                Slog.e(TAG, "createDefaultChannelIfNeededLocked - Exception: " + e);
            }
            if (r.uid == -10000) {
                this.mRestoredWithoutUids.put(pkg, r);
            } else {
                this.mPackagePreferences.put(key, r);
            }
        }
        return r;
    }

    private boolean shouldHaveDefaultChannel(PackagePreferences r) throws PackageManager.NameNotFoundException {
        int userId = UserHandle.getUserId(r.uid);
        ApplicationInfo applicationInfo = this.mPm.getApplicationInfoAsUser(r.pkg, 0, userId);
        return applicationInfo.targetSdkVersion < 26;
    }

    private boolean deleteDefaultChannelIfNeededLocked(PackagePreferences r) throws PackageManager.NameNotFoundException {
        if (!r.channels.containsKey("miscellaneous")) {
            return false;
        }
        if (this.shouldHaveDefaultChannel(r)) {
            return false;
        }
        r.channels.remove("miscellaneous");
        return true;
    }

    private boolean createDefaultChannelIfNeededLocked(PackagePreferences r) throws PackageManager.NameNotFoundException {
        if (r.channels.containsKey("miscellaneous")) {
            r.channels.get("miscellaneous").setName(this.mContext.getString(17039846));
            return false;
        }
        if (!this.shouldHaveDefaultChannel(r)) {
            return false;
        }
        NotificationChannel channel = new NotificationChannel("miscellaneous", this.mContext.getString(17039846), r.importance);
        channel.setBypassDnd(r.priority == 2);
        channel.setLockscreenVisibility(r.visibility);
        if (r.importance != -1000) {
            channel.lockFields(4);
        }
        if (r.priority != 0) {
            channel.lockFields(1);
        }
        if (r.visibility != -1000) {
            channel.lockFields(2);
        }
        r.channels.put(channel.getId(), channel);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXml(XmlSerializer out, boolean forBackup, int userId) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        if (this.mHideSilentStatusBarIcons && (!forBackup || userId == 0)) {
            out.startTag(null, TAG_STATUS_ICONS);
            out.attribute(null, ATT_HIDE_SILENT, String.valueOf(this.mHideSilentStatusBarIcons));
            out.endTag(null, TAG_STATUS_ICONS);
        }
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            for (int i = 0; i < N; ++i) {
                boolean hasNonDefaultSettings;
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                if (forBackup && UserHandle.getUserId(r.uid) != userId) continue;
                boolean bl = hasNonDefaultSettings = r.importance != -1000 || r.priority != 0 || r.visibility != -1000 || !r.showBadge || r.lockedAppFields != 0 || r.channels.size() > 0 || r.groups.size() > 0 || r.delegate != null || !r.allowBubble;
                if (!hasNonDefaultSettings) continue;
                out.startTag(null, TAG_PACKAGE);
                out.attribute(null, ATT_NAME, r.pkg);
                if (r.importance != -1000) {
                    out.attribute(null, ATT_IMPORTANCE, Integer.toString(r.importance));
                }
                if (r.priority != 0) {
                    out.attribute(null, ATT_PRIORITY, Integer.toString(r.priority));
                }
                if (r.visibility != -1000) {
                    out.attribute(null, ATT_VISIBILITY, Integer.toString(r.visibility));
                }
                if (!r.allowBubble) {
                    out.attribute(null, ATT_ALLOW_BUBBLE, Boolean.toString(r.allowBubble));
                }
                out.attribute(null, ATT_SHOW_BADGE, Boolean.toString(r.showBadge));
                out.attribute(null, ATT_APP_USER_LOCKED_FIELDS, Integer.toString(r.lockedAppFields));
                if (!forBackup) {
                    out.attribute(null, ATT_UID, Integer.toString(r.uid));
                }
                if (r.delegate != null) {
                    out.startTag(null, TAG_DELEGATE);
                    out.attribute(null, ATT_NAME, r.delegate.mPkg);
                    out.attribute(null, ATT_UID, Integer.toString(r.delegate.mUid));
                    if (!r.delegate.mEnabled) {
                        out.attribute(null, ATT_ENABLED, Boolean.toString(r.delegate.mEnabled));
                    }
                    if (!r.delegate.mUserAllowed) {
                        out.attribute(null, ATT_USER_ALLOWED, Boolean.toString(r.delegate.mUserAllowed));
                    }
                    out.endTag(null, TAG_DELEGATE);
                }
                for (NotificationChannelGroup group : r.groups.values()) {
                    group.writeXml(out);
                }
                for (NotificationChannel channel : r.channels.values()) {
                    if (forBackup) {
                        if (channel.isDeleted()) continue;
                        channel.writeXmlForBackup(out, this.mContext);
                        continue;
                    }
                    channel.writeXml(out);
                }
                out.endTag(null, TAG_PACKAGE);
            }
        }
        out.endTag(null, TAG_RANKING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBubblesAllowed(String pkg, int uid, boolean allowed) {
        boolean changed = false;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences p = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            changed = p.allowBubble != allowed;
            p.allowBubble = allowed;
            p.lockedAppFields |= 2;
        }
        if (changed) {
            this.updateConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areBubblesAllowed(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)pkg, (int)uid).allowBubble;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppLockedFields(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)pkg, (int)uid).lockedAppFields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getImportance(String packageName, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)packageName, (int)uid).importance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getIsAppImportanceLocked(String packageName, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int userLockedFields = this.getOrCreatePackagePreferencesLocked((String)packageName, (int)uid).lockedAppFields;
            return (userLockedFields & 1) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canShowBadge(String packageName, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)packageName, (int)uid).showBadge;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShowBadge(String packageName, int uid, boolean showBadge) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            this.getOrCreatePackagePreferencesLocked((String)packageName, (int)uid).showBadge = showBadge;
        }
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGroupBlocked(String packageName, int uid, String groupId) {
        if (groupId == null) {
            return false;
        }
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(packageName, uid);
            NotificationChannelGroup group = r.groups.get(groupId);
            if (group == null) {
                return false;
            }
            return group.isBlocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPackagePriority(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)pkg, (int)uid).priority;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPackageVisibility(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            return this.getOrCreatePackagePreferencesLocked((String)pkg, (int)uid).visibility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNotificationChannelGroup(String pkg, int uid, NotificationChannelGroup group, boolean fromTargetApp) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(group);
        Preconditions.checkNotNull(group.getId());
        Preconditions.checkNotNull(!TextUtils.isEmpty(group.getName()));
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            if (r == null) {
                throw new IllegalArgumentException("Invalid package");
            }
            NotificationChannelGroup oldGroup = r.groups.get(group.getId());
            if (!group.equals(oldGroup)) {
                MetricsLogger.action(this.getChannelGroupLog(group.getId(), pkg));
            }
            if (oldGroup != null) {
                group.setChannels(oldGroup.getChannels());
                if (fromTargetApp) {
                    group.setBlocked(oldGroup.isBlocked());
                    group.unlockFields(group.getUserLockedFields());
                    group.lockFields(oldGroup.getUserLockedFields());
                } else if (group.isBlocked() != oldGroup.isBlocked()) {
                    group.lockFields(1);
                    this.updateChannelsBypassingDnd(this.mContext.getUserId());
                }
            }
            r.groups.put(group.getId(), group);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean createNotificationChannel(String pkg, int uid, NotificationChannel channel, boolean fromTargetApp, boolean hasDndAccess) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channel);
        Preconditions.checkNotNull(channel.getId());
        Preconditions.checkArgument(!TextUtils.isEmpty(channel.getName()));
        boolean needsPolicyFileChange = false;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            if (r == null) {
                throw new IllegalArgumentException("Invalid package");
            }
            if (channel.getGroup() != null && !r.groups.containsKey(channel.getGroup())) {
                throw new IllegalArgumentException("NotificationChannelGroup doesn't exist");
            }
            if ("miscellaneous".equals(channel.getId())) {
                throw new IllegalArgumentException("Reserved id");
            }
            NotificationChannel existing = r.channels.get(channel.getId());
            if (existing != null && fromTargetApp) {
                boolean bypassDnd;
                if (existing.isDeleted()) {
                    existing.setDeleted(false);
                    needsPolicyFileChange = true;
                    MetricsLogger.action(this.getChannelLog(channel, pkg).setType(1));
                }
                if (!Objects.equals(channel.getName().toString(), existing.getName().toString())) {
                    existing.setName(channel.getName().toString());
                    needsPolicyFileChange = true;
                }
                if (!Objects.equals(channel.getDescription(), existing.getDescription())) {
                    existing.setDescription(channel.getDescription());
                    needsPolicyFileChange = true;
                }
                if (channel.isBlockableSystem() != existing.isBlockableSystem()) {
                    existing.setBlockableSystem(channel.isBlockableSystem());
                    needsPolicyFileChange = true;
                }
                if (channel.getGroup() != null && existing.getGroup() == null) {
                    existing.setGroup(channel.getGroup());
                    needsPolicyFileChange = true;
                }
                int previousExistingImportance = existing.getImportance();
                if (existing.getUserLockedFields() == 0 && channel.getImportance() < existing.getImportance()) {
                    existing.setImportance(channel.getImportance());
                    needsPolicyFileChange = true;
                }
                if (existing.getUserLockedFields() == 0 && hasDndAccess && (bypassDnd = channel.canBypassDnd()) != existing.canBypassDnd()) {
                    existing.setBypassDnd(bypassDnd);
                    needsPolicyFileChange = true;
                    if (bypassDnd != this.mAreChannelsBypassingDnd || previousExistingImportance != existing.getImportance()) {
                        this.updateChannelsBypassingDnd(this.mContext.getUserId());
                    }
                }
                this.updateConfig();
                return needsPolicyFileChange;
            }
            needsPolicyFileChange = true;
            if (channel.getImportance() < 0 || channel.getImportance() > 5) {
                throw new IllegalArgumentException("Invalid importance level");
            }
            if (fromTargetApp && !hasDndAccess) {
                channel.setBypassDnd(r.priority == 2);
            }
            if (fromTargetApp) {
                channel.setLockscreenVisibility(r.visibility);
            }
            this.clearLockedFieldsLocked(channel);
            channel.setImportanceLockedByOEM(r.oemLockedImportance);
            if (!channel.isImportanceLockedByOEM() && r.futureOemLockedChannels.remove(channel.getId())) {
                channel.setImportanceLockedByOEM(true);
            }
            channel.setImportanceLockedByCriticalDeviceFunction(r.defaultAppLockedImportance);
            if (channel.getLockscreenVisibility() == 1) {
                channel.setLockscreenVisibility(-1000);
            }
            if (!r.showBadge) {
                channel.setShowBadge(false);
            }
            r.channels.put(channel.getId(), channel);
            if (channel.canBypassDnd() != this.mAreChannelsBypassingDnd) {
                this.updateChannelsBypassingDnd(this.mContext.getUserId());
            }
            MetricsLogger.action(this.getChannelLog(channel, pkg).setType(1));
        }
        return needsPolicyFileChange;
    }

    void clearLockedFieldsLocked(NotificationChannel channel) {
        channel.unlockFields(channel.getUserLockedFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNotificationChannel(String pkg, int uid, NotificationChannel updatedChannel, boolean fromUser) {
        Preconditions.checkNotNull(updatedChannel);
        Preconditions.checkNotNull(updatedChannel.getId());
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            if (r == null) {
                throw new IllegalArgumentException("Invalid package");
            }
            NotificationChannel channel = r.channels.get(updatedChannel.getId());
            if (channel == null || channel.isDeleted()) {
                throw new IllegalArgumentException("Channel does not exist");
            }
            if (updatedChannel.getLockscreenVisibility() == 1) {
                updatedChannel.setLockscreenVisibility(-1000);
            }
            if (fromUser) {
                updatedChannel.lockFields(channel.getUserLockedFields());
                this.lockFieldsForUpdateLocked(channel, updatedChannel);
            } else {
                updatedChannel.unlockFields(updatedChannel.getUserLockedFields());
            }
            updatedChannel.setImportanceLockedByOEM(channel.isImportanceLockedByOEM());
            if (updatedChannel.isImportanceLockedByOEM()) {
                updatedChannel.setImportance(channel.getImportance());
            }
            updatedChannel.setImportanceLockedByCriticalDeviceFunction(r.defaultAppLockedImportance);
            if (updatedChannel.isImportanceLockedByCriticalDeviceFunction() && updatedChannel.getImportance() == 0) {
                updatedChannel.setImportance(channel.getImportance());
            }
            r.channels.put(updatedChannel.getId(), updatedChannel);
            if (this.onlyHasDefaultChannel(pkg, uid)) {
                r.importance = updatedChannel.getImportance();
                r.priority = updatedChannel.canBypassDnd() ? 2 : 0;
                r.visibility = updatedChannel.getLockscreenVisibility();
                r.showBadge = updatedChannel.canShowBadge();
            }
            if (!channel.equals(updatedChannel)) {
                MetricsLogger.action(this.getChannelLog(updatedChannel, pkg).setSubtype(fromUser ? 1 : 0));
            }
            if (updatedChannel.canBypassDnd() != this.mAreChannelsBypassingDnd || channel.getImportance() != updatedChannel.getImportance()) {
                this.updateChannelsBypassingDnd(this.mContext.getUserId());
            }
        }
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotificationChannel getNotificationChannel(String pkg, int uid, String channelId, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            NotificationChannel nc;
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return null;
            }
            if (channelId == null) {
                channelId = "miscellaneous";
            }
            if ((nc = r.channels.get(channelId)) != null && (includeDeleted || !nc.isDeleted())) {
                return nc;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteNotificationChannel(String pkg, int uid, String channelId) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return;
            }
            NotificationChannel channel = r.channels.get(channelId);
            if (channel != null) {
                channel.setDeleted(true);
                LogMaker lm = this.getChannelLog(channel, pkg);
                lm.setType(2);
                MetricsLogger.action(lm);
                if (this.mAreChannelsBypassingDnd && channel.canBypassDnd()) {
                    this.updateChannelsBypassingDnd(this.mContext.getUserId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @VisibleForTesting
    public void permanentlyDeleteNotificationChannel(String pkg, int uid, String channelId) {
        Preconditions.checkNotNull(pkg);
        Preconditions.checkNotNull(channelId);
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return;
            }
            r.channels.remove(channelId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void permanentlyDeleteNotificationChannels(String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N;
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return;
            }
            for (int i = N = r.channels.size() - 1; i >= 0; --i) {
                String key = r.channels.keyAt(i);
                if ("miscellaneous".equals(key)) continue;
                r.channels.remove(key);
            }
        }
    }

    public boolean shouldHideSilentStatusIcons() {
        return this.mHideSilentStatusBarIcons;
    }

    public void setHideSilentStatusIcons(boolean hide) {
        this.mHideSilentStatusBarIcons = hide;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockChannelsForOEM(String[] appOrChannelList) {
        if (appOrChannelList == null) {
            return;
        }
        for (String appOrChannel : appOrChannelList) {
            String[] appSplit;
            if (TextUtils.isEmpty(appOrChannel) || (appSplit = appOrChannel.split(NON_BLOCKABLE_CHANNEL_DELIM)) == null || appSplit.length <= 0) continue;
            String appName = appSplit[0];
            String channelId = appSplit.length == 2 ? appSplit[1] : null;
            ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
            synchronized (arrayMap) {
                for (PackagePreferences r : this.mPackagePreferences.values()) {
                    if (!r.pkg.equals(appName)) continue;
                    if (channelId == null) {
                        r.oemLockedImportance = true;
                        for (NotificationChannel channel : r.channels.values()) {
                            channel.setImportanceLockedByOEM(true);
                        }
                        continue;
                    }
                    NotificationChannel channel = r.channels.get(channelId);
                    if (channel != null) {
                        channel.setImportanceLockedByOEM(true);
                        continue;
                    }
                    r.futureOemLockedChannels.add(channelId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDefaultApps(int userId, ArraySet<String> toRemove, ArraySet<Pair<String, Integer>> toAdd) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            for (PackagePreferences packagePreferences : this.mPackagePreferences.values()) {
                if (userId != UserHandle.getUserId(packagePreferences.uid) || toRemove == null || !toRemove.contains(packagePreferences.pkg)) continue;
                packagePreferences.defaultAppLockedImportance = false;
                for (NotificationChannel channel : packagePreferences.channels.values()) {
                    channel.setImportanceLockedByCriticalDeviceFunction(false);
                }
            }
            if (toAdd != null) {
                for (Pair pair : toAdd) {
                    PackagePreferences p = this.getOrCreatePackagePreferencesLocked((String)pair.first, (Integer)pair.second);
                    p.defaultAppLockedImportance = true;
                    for (NotificationChannel channel : p.channels.values()) {
                        channel.setImportanceLockedByCriticalDeviceFunction(true);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationChannelGroup getNotificationChannelGroupWithChannels(String pkg, int uid, String groupId, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null || groupId == null || !r.groups.containsKey(groupId)) {
                return null;
            }
            NotificationChannelGroup group = r.groups.get(groupId).clone();
            group.setChannels(new ArrayList<NotificationChannel>());
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (!includeDeleted && nc.isDeleted() || !groupId.equals(nc.getGroup())) continue;
                group.addChannel(nc);
            }
            return group;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationChannelGroup getNotificationChannelGroup(String groupId, String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return null;
            }
            return r.groups.get(groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid, boolean includeDeleted, boolean includeNonGrouped, boolean includeEmpty) {
        Preconditions.checkNotNull(pkg);
        ArrayMap<String, NotificationChannelGroup> groups = new ArrayMap<String, NotificationChannelGroup>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return ParceledListSlice.emptyList();
            }
            NotificationChannelGroup nonGrouped = new NotificationChannelGroup(null, null);
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (!includeDeleted && nc.isDeleted()) continue;
                if (nc.getGroup() != null) {
                    if (r.groups.get(nc.getGroup()) == null) continue;
                    NotificationChannelGroup ncg = (NotificationChannelGroup)groups.get(nc.getGroup());
                    if (ncg == null) {
                        ncg = r.groups.get(nc.getGroup()).clone();
                        ncg.setChannels(new ArrayList<NotificationChannel>());
                        groups.put(nc.getGroup(), ncg);
                    }
                    ncg.addChannel(nc);
                    continue;
                }
                nonGrouped.addChannel(nc);
            }
            if (includeNonGrouped && nonGrouped.getChannels().size() > 0) {
                groups.put(null, nonGrouped);
            }
            if (includeEmpty) {
                for (NotificationChannelGroup group : r.groups.values()) {
                    if (groups.containsKey(group.getId())) continue;
                    groups.put(group.getId(), group);
                }
            }
            return new ParceledListSlice<NotificationChannelGroup>(new ArrayList(groups.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NotificationChannel> deleteNotificationChannelGroup(String pkg, int uid, String groupId) {
        ArrayList<NotificationChannel> deletedChannels = new ArrayList<NotificationChannel>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null || TextUtils.isEmpty(groupId)) {
                return deletedChannels;
            }
            r.groups.remove(groupId);
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (!groupId.equals(nc.getGroup())) continue;
                nc.setDeleted(true);
                deletedChannels.add(nc);
            }
        }
        return deletedChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<NotificationChannelGroup> getNotificationChannelGroups(String pkg, int uid) {
        ArrayList<NotificationChannelGroup> groups = new ArrayList<NotificationChannelGroup>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return groups;
            }
            groups.addAll(r.groups.values());
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<NotificationChannel> getNotificationChannels(String pkg, int uid, boolean includeDeleted) {
        Preconditions.checkNotNull(pkg);
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return ParceledListSlice.emptyList();
            }
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (!includeDeleted && nc.isDeleted()) continue;
                channels.add(nc);
            }
            return new ParceledListSlice<NotificationChannel>(channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParceledListSlice<NotificationChannel> getNotificationChannelsBypassingDnd(String pkg, int userId) {
        ArrayList<NotificationChannel> channels = new ArrayList<NotificationChannel>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.mPackagePreferences.get(PreferencesHelper.packagePreferencesKey(pkg, userId));
            if (r != null && r.importance != 0) {
                for (NotificationChannel channel : r.channels.values()) {
                    if (!this.channelIsLiveLocked(r, channel) || !channel.canBypassDnd()) continue;
                    channels.add(channel);
                }
            }
        }
        return new ParceledListSlice<NotificationChannel>(channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onlyHasDefaultChannel(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getOrCreatePackagePreferencesLocked(pkg, uid);
            return r.channels.size() == 1 && r.channels.containsKey("miscellaneous");
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeletedChannelCount(String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        int deletedCount = 0;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return deletedCount;
            }
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (!nc.isDeleted()) continue;
                ++deletedCount;
            }
            return deletedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockedChannelCount(String pkg, int uid) {
        Preconditions.checkNotNull(pkg);
        int blockedCount = 0;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences r = this.getPackagePreferencesLocked(pkg, uid);
            if (r == null) {
                return blockedCount;
            }
            int N = r.channels.size();
            for (int i = 0; i < N; ++i) {
                NotificationChannel nc = r.channels.valueAt(i);
                if (nc.isDeleted() || 0 != nc.getImportance()) continue;
                ++blockedCount;
            }
            return blockedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBlockedAppCount(int userId) {
        int count = 0;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            for (int i = 0; i < N; ++i) {
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                if (userId != UserHandle.getUserId(r.uid) || r.importance != 0) continue;
                ++count;
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAppsBypassingDndCount(int userId) {
        int count = 0;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int numPackagePreferences = this.mPackagePreferences.size();
            block3: for (int i = 0; i < numPackagePreferences; ++i) {
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                if (userId != UserHandle.getUserId(r.uid) || r.importance == 0) continue;
                for (NotificationChannel channel : r.channels.values()) {
                    if (!this.channelIsLiveLocked(r, channel) || !channel.canBypassDnd()) continue;
                    ++count;
                    continue block3;
                }
            }
        }
        return count;
    }

    private void syncChannelsBypassingDnd(int userId) {
        this.mAreChannelsBypassingDnd = (this.mZenModeHelper.getNotificationPolicy().state & 1) == 1;
        this.updateChannelsBypassingDnd(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void updateChannelsBypassingDnd(int userId) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        // MONITORENTER : arrayMap
        int numPackagePreferences = this.mPackagePreferences.size();
        int i = 0;
        while (true) {
            if (i >= numPackagePreferences) {
                // MONITOREXIT : arrayMap
                if (!this.mAreChannelsBypassingDnd) return;
                this.mAreChannelsBypassingDnd = false;
                this.updateZenPolicy(false);
                return;
            }
            PackagePreferences r = this.mPackagePreferences.valueAt(i);
            if (userId == UserHandle.getUserId(r.uid) && r.importance != 0) {
                for (NotificationChannel channel : r.channels.values()) {
                    if (!this.channelIsLiveLocked(r, channel) || !channel.canBypassDnd()) continue;
                    if (!this.mAreChannelsBypassingDnd) {
                        this.mAreChannelsBypassingDnd = true;
                        this.updateZenPolicy(true);
                    }
                    // MONITOREXIT : arrayMap
                    return;
                }
            }
            ++i;
        }
    }

    private boolean channelIsLiveLocked(PackagePreferences pkgPref, NotificationChannel channel) {
        if (this.isGroupBlocked(pkgPref.pkg, pkgPref.uid, channel.getGroup())) {
            return false;
        }
        return !channel.isDeleted() && channel.getImportance() != 0;
    }

    public void updateZenPolicy(boolean areChannelsBypassingDnd) {
        NotificationManager.Policy policy = this.mZenModeHelper.getNotificationPolicy();
        this.mZenModeHelper.setNotificationPolicy(new NotificationManager.Policy(policy.priorityCategories, policy.priorityCallSenders, policy.priorityMessageSenders, policy.suppressedVisualEffects, areChannelsBypassingDnd ? 1 : 0));
    }

    public boolean areChannelsBypassingDnd() {
        return this.mAreChannelsBypassingDnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImportance(String pkgName, int uid, int importance) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            this.getOrCreatePackagePreferencesLocked((String)pkgName, (int)uid).importance = importance;
        }
        this.updateConfig();
    }

    public void setEnabled(String packageName, int uid, boolean enabled) {
        boolean wasEnabled;
        boolean bl = wasEnabled = this.getImportance(packageName, uid) != 0;
        if (wasEnabled == enabled) {
            return;
        }
        this.setImportance(packageName, uid, enabled ? -1000 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppImportanceLocked(String packageName, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences prefs = this.getOrCreatePackagePreferencesLocked(packageName, uid);
            if ((prefs.lockedAppFields & 1) != 0) {
                return;
            }
            prefs.lockedAppFields |= 1;
        }
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNotificationDelegate(String sourcePkg, int sourceUid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences prefs = this.getPackagePreferencesLocked(sourcePkg, sourceUid);
            if (prefs == null || prefs.delegate == null) {
                return null;
            }
            if (!prefs.delegate.mUserAllowed || !prefs.delegate.mEnabled) {
                return null;
            }
            return prefs.delegate.mPkg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationDelegate(String sourcePkg, int sourceUid, String delegatePkg, int delegateUid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            Delegate delegate;
            PackagePreferences prefs = this.getOrCreatePackagePreferencesLocked(sourcePkg, sourceUid);
            boolean userAllowed = prefs.delegate == null || prefs.delegate.mUserAllowed;
            prefs.delegate = delegate = new Delegate(delegatePkg, delegateUid, true, userAllowed);
        }
        this.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revokeNotificationDelegate(String sourcePkg, int sourceUid) {
        boolean changed = false;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences prefs = this.getPackagePreferencesLocked(sourcePkg, sourceUid);
            if (prefs != null && prefs.delegate != null) {
                prefs.delegate.mEnabled = false;
                changed = true;
            }
        }
        if (changed) {
            this.updateConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toggleNotificationDelegate(String sourcePkg, int sourceUid, boolean userAllowed) {
        boolean changed = false;
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences prefs = this.getPackagePreferencesLocked(sourcePkg, sourceUid);
            if (prefs != null && prefs.delegate != null) {
                prefs.delegate.mUserAllowed = userAllowed;
                changed = true;
            }
        }
        if (changed) {
            this.updateConfig();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDelegateAllowed(String sourcePkg, int sourceUid, String potentialDelegatePkg, int potentialDelegateUid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences prefs = this.getPackagePreferencesLocked(sourcePkg, sourceUid);
            return prefs != null && prefs.isValidDelegate(potentialDelegatePkg, potentialDelegateUid);
        }
    }

    @VisibleForTesting
    void lockFieldsForUpdateLocked(NotificationChannel original, NotificationChannel update) {
        if (original.canBypassDnd() != update.canBypassDnd()) {
            update.lockFields(1);
        }
        if (original.getLockscreenVisibility() != update.getLockscreenVisibility()) {
            update.lockFields(2);
        }
        if (original.getImportance() != update.getImportance()) {
            update.lockFields(4);
        }
        if (original.shouldShowLights() != update.shouldShowLights() || original.getLightColor() != update.getLightColor()) {
            update.lockFields(8);
        }
        if (!Objects.equals(original.getSound(), update.getSound())) {
            update.lockFields(32);
        }
        if (!Arrays.equals(original.getVibrationPattern(), update.getVibrationPattern()) || original.shouldVibrate() != update.shouldVibrate()) {
            update.lockFields(16);
        }
        if (original.canShowBadge() != update.canShowBadge()) {
            update.lockFields(128);
        }
        if (original.canBubble() != update.canBubble()) {
            update.lockFields(256);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        pw.print(prefix);
        pw.println("per-package config:");
        pw.println("PackagePreferences:");
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PreferencesHelper.dumpPackagePreferencesLocked(pw, prefix, filter, this.mPackagePreferences);
        }
        pw.println("Restored without uid:");
        PreferencesHelper.dumpPackagePreferencesLocked(pw, prefix, filter, this.mRestoredWithoutUids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(ProtoOutputStream proto, NotificationManagerService.DumpFilter filter) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PreferencesHelper.dumpPackagePreferencesLocked(proto, 0x20B00000002L, filter, this.mPackagePreferences);
        }
        PreferencesHelper.dumpPackagePreferencesLocked(proto, 2246267895811L, filter, this.mRestoredWithoutUids);
    }

    private static void dumpPackagePreferencesLocked(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter, ArrayMap<String, PackagePreferences> packagePreferences) {
        int N = packagePreferences.size();
        for (int i = 0; i < N; ++i) {
            PackagePreferences r = packagePreferences.valueAt(i);
            if (!filter.matches(r.pkg)) continue;
            pw.print(prefix);
            pw.print("  AppSettings: ");
            pw.print(r.pkg);
            pw.print(" (");
            pw.print(r.uid == -10000 ? "UNKNOWN_UID" : Integer.toString(r.uid));
            pw.print(')');
            if (r.importance != -1000) {
                pw.print(" importance=");
                pw.print(NotificationListenerService.Ranking.importanceToString(r.importance));
            }
            if (r.priority != 0) {
                pw.print(" priority=");
                pw.print(Notification.priorityToString(r.priority));
            }
            if (r.visibility != -1000) {
                pw.print(" visibility=");
                pw.print(Notification.visibilityToString(r.visibility));
            }
            if (!r.showBadge) {
                pw.print(" showBadge=");
                pw.print(r.showBadge);
            }
            if (r.defaultAppLockedImportance) {
                pw.print(" defaultAppLocked=");
                pw.print(r.defaultAppLockedImportance);
            }
            if (r.oemLockedImportance) {
                pw.print(" oemLocked=");
                pw.print(r.oemLockedImportance);
            }
            if (!r.futureOemLockedChannels.isEmpty()) {
                pw.print(" futureLockedChannels=");
                pw.print(r.futureOemLockedChannels);
            }
            pw.println();
            for (NotificationChannel channel : r.channels.values()) {
                pw.print(prefix);
                channel.dump(pw, "    ", filter.redact);
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                pw.print(prefix);
                pw.print("  ");
                pw.print("  ");
                pw.println(group);
            }
        }
    }

    private static void dumpPackagePreferencesLocked(ProtoOutputStream proto, long fieldId, NotificationManagerService.DumpFilter filter, ArrayMap<String, PackagePreferences> packagePreferences) {
        int N = packagePreferences.size();
        for (int i = 0; i < N; ++i) {
            PackagePreferences r = packagePreferences.valueAt(i);
            if (!filter.matches(r.pkg)) continue;
            long fToken = proto.start(fieldId);
            proto.write(0x10900000001L, r.pkg);
            proto.write(1120986464258L, r.uid);
            proto.write(0x11100000003L, r.importance);
            proto.write(1120986464260L, r.priority);
            proto.write(0x11100000005L, r.visibility);
            proto.write(1133871366150L, r.showBadge);
            for (NotificationChannel channel : r.channels.values()) {
                channel.writeToProto(proto, 2246267895815L);
            }
            for (NotificationChannelGroup group : r.groups.values()) {
                group.writeToProto(proto, 2246267895816L);
            }
            proto.end(fToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject ranking = new JSONObject();
        JSONArray PackagePreferencess = new JSONArray();
        try {
            ranking.put("noUid", this.mRestoredWithoutUids.size());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            for (int i = 0; i < N; ++i) {
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                if (filter != null && !filter.matches(r.pkg)) continue;
                JSONObject PackagePreferences2 = new JSONObject();
                try {
                    PackagePreferences2.put("userId", UserHandle.getUserId(r.uid));
                    PackagePreferences2.put("packageName", r.pkg);
                    if (r.importance != -1000) {
                        PackagePreferences2.put(ATT_IMPORTANCE, NotificationListenerService.Ranking.importanceToString(r.importance));
                    }
                    if (r.priority != 0) {
                        PackagePreferences2.put(ATT_PRIORITY, Notification.priorityToString(r.priority));
                    }
                    if (r.visibility != -1000) {
                        PackagePreferences2.put(ATT_VISIBILITY, Notification.visibilityToString(r.visibility));
                    }
                    if (!r.showBadge) {
                        PackagePreferences2.put("showBadge", (Object)r.showBadge);
                    }
                    JSONArray channels = new JSONArray();
                    for (NotificationChannel channel : r.channels.values()) {
                        channels.put(channel.toJson());
                    }
                    PackagePreferences2.put("channels", channels);
                    JSONArray groups = new JSONArray();
                    for (NotificationChannelGroup group : r.groups.values()) {
                        groups.put(group.toJson());
                    }
                    PackagePreferences2.put("groups", groups);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                PackagePreferencess.put(PackagePreferences2);
            }
        }
        try {
            ranking.put("PackagePreferencess", PackagePreferencess);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ranking;
    }

    public JSONArray dumpBansJson(NotificationManagerService.DumpFilter filter) {
        JSONArray bans = new JSONArray();
        Map<Integer, String> packageBans = this.getPackageBans();
        for (Map.Entry<Integer, String> ban : packageBans.entrySet()) {
            int userId = UserHandle.getUserId(ban.getKey());
            String packageName = ban.getValue();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject banJson = new JSONObject();
            try {
                banJson.put("userId", userId);
                banJson.put("packageName", packageName);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            bans.put(banJson);
        }
        return bans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, String> getPackageBans() {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            ArrayMap<Integer, String> packageBans = new ArrayMap<Integer, String>(N);
            for (int i = 0; i < N; ++i) {
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                if (r.importance != 0) continue;
                packageBans.put(r.uid, r.pkg);
            }
            return packageBans;
        }
    }

    public JSONArray dumpChannelsJson(NotificationManagerService.DumpFilter filter) {
        JSONArray channels = new JSONArray();
        Map<String, Integer> packageChannels = this.getPackageChannels();
        for (Map.Entry<String, Integer> channelCount : packageChannels.entrySet()) {
            String packageName = channelCount.getKey();
            if (filter != null && !filter.matches(packageName)) continue;
            JSONObject channelCountJson = new JSONObject();
            try {
                channelCountJson.put("packageName", packageName);
                channelCountJson.put("channelCount", channelCount.getValue());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            channels.put(channelCountJson);
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Integer> getPackageChannels() {
        ArrayMap<String, Integer> packageChannels = new ArrayMap<String, Integer>();
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mPackagePreferences.size(); ++i) {
                PackagePreferences r = this.mPackagePreferences.valueAt(i);
                int channelCount = 0;
                for (int j = 0; j < r.channels.size(); ++j) {
                    if (r.channels.valueAt(j).isDeleted()) continue;
                    ++channelCount;
                }
                packageChannels.put(r.pkg, channelCount);
            }
        }
        return packageChannels;
    }

    public void onUserSwitched(int userId) {
        this.syncChannelsBypassingDnd(userId);
    }

    public void onUserUnlocked(int userId) {
        this.syncChannelsBypassingDnd(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserRemoved(int userId) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            for (int i = N - 1; i >= 0; --i) {
                PackagePreferences PackagePreferences2 = this.mPackagePreferences.valueAt(i);
                if (UserHandle.getUserId(PackagePreferences2.uid) != userId) continue;
                this.mPackagePreferences.removeAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onLocaleChanged(Context context, int userId) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            int N = this.mPackagePreferences.size();
            for (int i = 0; i < N; ++i) {
                PackagePreferences PackagePreferences2 = this.mPackagePreferences.valueAt(i);
                if (UserHandle.getUserId(PackagePreferences2.uid) != userId || !PackagePreferences2.channels.containsKey("miscellaneous")) continue;
                PackagePreferences2.channels.get("miscellaneous").setName(context.getResources().getString(17039846));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onPackagesChanged(boolean removingPackage, int changeUserId, String[] pkgList, int[] uidList) {
        if (pkgList == null || pkgList.length == 0) {
            return false;
        }
        boolean updated = false;
        if (removingPackage) {
            int size = Math.min(pkgList.length, uidList.length);
            for (int i = 0; i < size; ++i) {
                String pkg = pkgList[i];
                int uid = uidList[i];
                ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
                synchronized (arrayMap) {
                    this.mPackagePreferences.remove(PreferencesHelper.packagePreferencesKey(pkg, uid));
                }
                this.mRestoredWithoutUids.remove(pkg);
                updated = true;
            }
        } else {
            for (String pkg : pkgList) {
                ArrayMap<String, PackagePreferences> arrayMap;
                PackagePreferences r = this.mRestoredWithoutUids.get(pkg);
                if (r != null) {
                    try {
                        r.uid = this.mPm.getPackageUidAsUser(r.pkg, changeUserId);
                        this.mRestoredWithoutUids.remove(pkg);
                        arrayMap = this.mPackagePreferences;
                        synchronized (arrayMap) {
                            this.mPackagePreferences.put(PreferencesHelper.packagePreferencesKey(r.pkg, r.uid), r);
                        }
                        updated = true;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        // empty catch block
                    }
                }
                try {
                    arrayMap = this.mPackagePreferences;
                    synchronized (arrayMap) {
                        PackagePreferences fullPackagePreferences = this.getPackagePreferencesLocked(pkg, this.mPm.getPackageUidAsUser(pkg, changeUserId));
                        if (fullPackagePreferences != null) {
                            updated |= this.createDefaultChannelIfNeededLocked(fullPackagePreferences);
                            updated |= this.deleteDefaultChannelIfNeededLocked(fullPackagePreferences);
                        }
                    }
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (updated) {
            this.updateConfig();
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearData(String pkg, int uid) {
        ArrayMap<String, PackagePreferences> arrayMap = this.mPackagePreferences;
        synchronized (arrayMap) {
            PackagePreferences p = this.getPackagePreferencesLocked(pkg, uid);
            if (p != null) {
                p.channels = new ArrayMap();
                p.groups = new ArrayMap<String, NotificationChannelGroup>();
                p.delegate = null;
                p.lockedAppFields = 0;
                p.allowBubble = true;
                p.importance = -1000;
                p.priority = 0;
                p.visibility = -1000;
                p.showBadge = true;
            }
        }
    }

    private LogMaker getChannelLog(NotificationChannel channel, String pkg) {
        return new LogMaker(856).setType(6).setPackageName(pkg).addTaggedData(857, channel.getId()).addTaggedData(858, channel.getImportance());
    }

    private LogMaker getChannelGroupLog(String groupId, String pkg) {
        return new LogMaker(859).setType(6).addTaggedData(860, groupId).setPackageName(pkg);
    }

    public void updateBubblesEnabled() {
        if (this.mBubblesEnabled == null) {
            this.mBubblesEnabled = new SparseBooleanArray();
        }
        boolean changed = false;
        for (int index = 0; index < this.mBubblesEnabled.size(); ++index) {
            int userId = this.mBubblesEnabled.keyAt(index);
            boolean oldValue = this.mBubblesEnabled.get(userId);
            boolean newValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_bubbles", 1, userId) != 0;
            this.mBubblesEnabled.put(userId, newValue);
            changed |= oldValue != newValue;
        }
        if (changed) {
            this.updateConfig();
        }
    }

    @Override
    public boolean bubblesEnabled(UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        if (userId == -1) {
            return false;
        }
        if (this.mBubblesEnabled.indexOfKey(userId) < 0) {
            this.mBubblesEnabled.put(userId, Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_bubbles", 1, userId) != 0);
        }
        return this.mBubblesEnabled.get(userId, true);
    }

    public void updateBadgingEnabled() {
        if (this.mBadgingEnabled == null) {
            this.mBadgingEnabled = new SparseBooleanArray();
        }
        boolean changed = false;
        for (int index = 0; index < this.mBadgingEnabled.size(); ++index) {
            int userId = this.mBadgingEnabled.keyAt(index);
            boolean oldValue = this.mBadgingEnabled.get(userId);
            boolean newValue = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_badging", 1, userId) != 0;
            this.mBadgingEnabled.put(userId, newValue);
            changed |= oldValue != newValue;
        }
        if (changed) {
            this.updateConfig();
        }
    }

    @Override
    public boolean badgingEnabled(UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        if (userId == -1) {
            return false;
        }
        if (this.mBadgingEnabled.indexOfKey(userId) < 0) {
            this.mBadgingEnabled.put(userId, Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "notification_badging", 1, userId) != 0);
        }
        return this.mBadgingEnabled.get(userId, true);
    }

    private void updateConfig() {
        this.mRankingHandler.requestSort();
    }

    private static String packagePreferencesKey(String pkg, int uid) {
        return pkg + "|" + uid;
    }

    private static class Delegate {
        static final boolean DEFAULT_ENABLED = true;
        static final boolean DEFAULT_USER_ALLOWED = true;
        String mPkg;
        int mUid = -10000;
        boolean mEnabled = true;
        boolean mUserAllowed = true;

        Delegate(String pkg, int uid, boolean enabled, boolean userAllowed) {
            this.mPkg = pkg;
            this.mUid = uid;
            this.mEnabled = enabled;
            this.mUserAllowed = userAllowed;
        }

        public boolean isAllowed(String pkg, int uid) {
            if (pkg == null || uid == -10000) {
                return false;
            }
            return pkg.equals(this.mPkg) && uid == this.mUid && this.mUserAllowed && this.mEnabled;
        }
    }

    private static class PackagePreferences {
        String pkg;
        int uid = -10000;
        int importance = -1000;
        int priority = 0;
        int visibility = -1000;
        boolean showBadge = true;
        boolean allowBubble = true;
        int lockedAppFields = 0;
        boolean oemLockedImportance = false;
        List<String> futureOemLockedChannels = new ArrayList<String>();
        boolean defaultAppLockedImportance = false;
        Delegate delegate = null;
        ArrayMap<String, NotificationChannel> channels = new ArrayMap();
        Map<String, NotificationChannelGroup> groups = new ConcurrentHashMap<String, NotificationChannelGroup>();

        private PackagePreferences() {
        }

        public boolean isValidDelegate(String pkg, int uid) {
            return this.delegate != null && this.delegate.isAllowed(pkg, uid);
        }
    }

    public static @interface LockableAppFields {
        public static final int USER_LOCKED_IMPORTANCE = 1;
        public static final int USER_LOCKED_BUBBLE = 2;
    }
}

