/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.Context;
import android.util.ArrayMap;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingHandler;
import com.android.server.notification.RankingReconsideration;
import com.android.server.notification.ZenModeHelper;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;

public class RankingHelper {
    private static final String TAG = "RankingHelper";
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator;
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp = new ArrayMap();
    private final Context mContext;
    private final RankingHandler mRankingHandler;

    public RankingHelper(Context context, RankingHandler rankingHandler, RankingConfig config, ZenModeHelper zenHelper, NotificationUsageStats usageStats, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        this.mPreliminaryComparator = new NotificationComparator(this.mContext);
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext, usageStats);
                extractor.setConfig(config);
                extractor.setZenHelper(zenHelper);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                this.mRankingHandler.requestReconsideration(recon);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        Collections.sort(notificationList, this.mPreliminaryComparator);
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                NotificationRecord existingProxy = this.mProxyByGroupTmp.get(groupKey);
                if (existingProxy != null) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("crtcl=0x%04x:intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", record.getCriticality(), Character.valueOf((char)(record.isRecentlyIntrusive() && record.getImportance() > 1 ? 48 : 49)), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        int N = this.mSignalExtractors.length;
        pw.print(prefix);
        pw.print("mSignalExtractors.length = ");
        pw.println(N);
        for (int i = 0; i < N; ++i) {
            pw.print(prefix);
            pw.print("  ");
            pw.println(this.mSignalExtractors[i].getClass().getSimpleName());
        }
    }

    public void dump(ProtoOutputStream proto, NotificationManagerService.DumpFilter filter) {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            proto.write(2237677961217L, this.mSignalExtractors[i].getClass().getSimpleName());
        }
    }
}

