/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AppOpsManager;
import android.app.AutomaticZenRule;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.graphics.drawable.Icon;
import android.media.AudioAttributes;
import android.media.AudioManagerInternal;
import android.media.VolumePolicy;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.Condition;
import android.service.notification.ZenModeConfig;
import android.service.notification.ZenPolicy;
import android.util.AndroidRuntimeException;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.server.LocalServices;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.ManagedServices;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeConditions;
import com.android.server.notification.ZenModeFiltering;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeHelper {
    static final String TAG = "ZenModeHelper";
    static final boolean DEBUG = Log.isLoggable("ZenModeHelper", 3);
    private static final int RULE_INSTANCE_GRACE_PERIOD = 259200000;
    private final Context mContext;
    private final H mHandler;
    private final SettingsObserver mSettingsObserver;
    private final AppOpsManager mAppOps;
    @VisibleForTesting
    protected final NotificationManager mNotificationManager;
    @VisibleForTesting
    protected ZenModeConfig mDefaultConfig;
    private final ArrayList<Callback> mCallbacks = new ArrayList();
    private final ZenModeFiltering mFiltering;
    protected final RingerModeDelegate mRingerModeDelegate = new RingerModeDelegate();
    @VisibleForTesting
    protected final ZenModeConditions mConditions;
    @VisibleForTesting
    final SparseArray<ZenModeConfig> mConfigs = new SparseArray();
    private final Metrics mMetrics = new Metrics();
    private final ManagedServices.Config mServiceConfig;
    @VisibleForTesting
    protected int mZenMode;
    @VisibleForTesting
    protected NotificationManager.Policy mConsolidatedPolicy;
    private int mUser = 0;
    @VisibleForTesting
    protected ZenModeConfig mConfig;
    @VisibleForTesting
    protected AudioManagerInternal mAudioManager;
    protected PackageManager mPm;
    private long mSuppressedEffects;
    public static final long SUPPRESSED_EFFECT_NOTIFICATIONS = 1L;
    public static final long SUPPRESSED_EFFECT_CALLS = 2L;
    public static final long SUPPRESSED_EFFECT_ALL = 3L;
    @VisibleForTesting
    protected boolean mIsBootComplete;
    private String[] mPriorityOnlyDndExemptPackages;

    public ZenModeHelper(Context context, Looper looper, ConditionProviders conditionProviders) {
        this.mContext = context;
        this.mHandler = new H(looper);
        this.addCallback(this.mMetrics);
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mNotificationManager = context.getSystemService(NotificationManager.class);
        this.mDefaultConfig = this.readDefaultConfig(this.mContext.getResources());
        this.updateDefaultAutomaticRuleNames();
        this.mConfig = this.mDefaultConfig.copy();
        this.mConfigs.put(0, this.mConfig);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mFiltering = new ZenModeFiltering(this.mContext);
        this.mConditions = new ZenModeConditions(this, conditionProviders);
        this.mServiceConfig = conditionProviders.getConfig();
    }

    public Looper getLooper() {
        return this.mHandler.getLooper();
    }

    public String toString() {
        return TAG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchesCallFilter(UserHandle userHandle, Bundle extras, ValidateNotificationPeople validator, int contactsTimeoutMs, float timeoutAffinity) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return ZenModeFiltering.matchesCallFilter(this.mContext, this.mZenMode, this.mConsolidatedPolicy, userHandle, extras, validator, contactsTimeoutMs, timeoutAffinity);
        }
    }

    public boolean isCall(NotificationRecord record) {
        return this.mFiltering.isCall(record);
    }

    public void recordCaller(NotificationRecord record) {
        this.mFiltering.recordCall(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldIntercept(NotificationRecord record) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return this.mFiltering.shouldIntercept(this.mZenMode, this.mConsolidatedPolicy, record);
        }
    }

    public void addCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void initZenMode() {
        if (DEBUG) {
            Log.d(TAG, "initZenMode");
        }
        this.evaluateZenMode("init", true);
    }

    public void onSystemReady() {
        if (DEBUG) {
            Log.d(TAG, "onSystemReady");
        }
        this.mAudioManager = LocalServices.getService(AudioManagerInternal.class);
        if (this.mAudioManager != null) {
            this.mAudioManager.setRingerModeDelegate(this.mRingerModeDelegate);
        }
        this.mPm = this.mContext.getPackageManager();
        this.mHandler.postMetricsTimer();
        this.cleanUpZenRules();
        this.evaluateZenMode("onSystemReady", true);
        this.mIsBootComplete = true;
        this.showZenUpgradeNotification(this.mZenMode);
    }

    public void onUserSwitched(int user) {
        this.loadConfigForUser(user, "onUserSwitched");
    }

    public void onUserRemoved(int user) {
        if (user < 0) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "onUserRemoved u=" + user);
        }
        this.mConfigs.remove(user);
    }

    public void onUserUnlocked(int user) {
        this.loadConfigForUser(user, "onUserUnlocked");
    }

    void setPriorityOnlyDndExemptPackages(String[] packages) {
        this.mPriorityOnlyDndExemptPackages = packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigForUser(int user, String reason) {
        ZenModeConfig config;
        if (this.mUser == user || user < 0) {
            return;
        }
        this.mUser = user;
        if (DEBUG) {
            Log.d(TAG, reason + " u=" + user);
        }
        if ((config = this.mConfigs.get(user)) == null) {
            if (DEBUG) {
                Log.d(TAG, reason + " generating default config for user " + user);
            }
            config = this.mDefaultConfig.copy();
            config.user = user;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            this.setConfigLocked(config, null, reason);
        }
        this.cleanUpZenRules();
    }

    public int getZenModeListenerInterruptionFilter() {
        return NotificationManager.zenModeToInterruptionFilter(this.mZenMode);
    }

    public void requestFromListener(ComponentName name, int filter) {
        int newZen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
        if (newZen != -1) {
            this.setManualZenMode(newZen, null, name != null ? name.getPackageName() : null, "listener:" + (name != null ? name.flattenToShortString() : null));
        }
    }

    public void setSuppressedEffects(long suppressedEffects) {
        if (this.mSuppressedEffects == suppressedEffects) {
            return;
        }
        this.mSuppressedEffects = suppressedEffects;
        this.applyRestrictions();
    }

    public long getSuppressedEffects() {
        return this.mSuppressedEffects;
    }

    public int getZenMode() {
        return this.mZenMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZenModeConfig.ZenRule> getZenRules() {
        ArrayList<ZenModeConfig.ZenRule> rules = new ArrayList<ZenModeConfig.ZenRule>();
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return rules;
            }
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (!this.canManageAutomaticZenRule(rule)) continue;
                rules.add(rule);
            }
        }
        return rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AutomaticZenRule getAutomaticZenRule(String id2) {
        ZenModeConfig.ZenRule rule;
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return null;
            }
            rule = this.mConfig.automaticRules.get(id2);
        }
        if (rule == null) {
            return null;
        }
        if (this.canManageAutomaticZenRule(rule)) {
            return this.createAutomaticZenRule(rule);
        }
        return null;
    }

    public String addAutomaticZenRule(AutomaticZenRule automaticZenRule, String reason) {
        if (!this.isSystemRule(automaticZenRule)) {
            ComponentInfo component = this.getServiceInfo(automaticZenRule.getOwner());
            if (component == null) {
                component = this.getActivityInfo(automaticZenRule.getConfigurationActivity());
            }
            if (component == null) {
                throw new IllegalArgumentException("Lacking enabled CPS or config activity");
            }
            int ruleInstanceLimit = -1;
            if (component.metaData != null) {
                ruleInstanceLimit = component.metaData.getInt("android.service.zen.automatic.ruleInstanceLimit", -1);
            }
            int newRuleInstanceCount = this.getCurrentInstanceCount(automaticZenRule.getOwner()) + this.getCurrentInstanceCount(automaticZenRule.getConfigurationActivity()) + 1;
            if (ruleInstanceLimit > 0 && ruleInstanceLimit < newRuleInstanceCount) {
                throw new IllegalArgumentException("Rule instance limit exceeded");
            }
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                throw new AndroidRuntimeException("Could not create rule");
            }
            if (DEBUG) {
                Log.d(TAG, "addAutomaticZenRule rule= " + automaticZenRule + " reason=" + reason);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
            this.populateZenRule(automaticZenRule, rule, true);
            newConfig.automaticRules.put(rule.id, rule);
            if (this.setConfigLocked(newConfig, reason, rule.component, true)) {
                return rule.id;
            }
            throw new AndroidRuntimeException("Could not create rule");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAutomaticZenRule(String ruleId, AutomaticZenRule automaticZenRule, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            if (DEBUG) {
                Log.d(TAG, "updateAutomaticZenRule zenRule=" + automaticZenRule + " reason=" + reason);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            if (ruleId == null) {
                throw new IllegalArgumentException("Rule doesn't exist");
            }
            ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(ruleId);
            if (rule == null || !this.canManageAutomaticZenRule(rule)) {
                throw new SecurityException("Cannot update rules not owned by your condition provider");
            }
            this.populateZenRule(automaticZenRule, rule, false);
            return this.setConfigLocked(newConfig, reason, rule.component, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAutomaticZenRule(String id2, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(id2);
            if (rule == null) {
                return false;
            }
            if (this.canManageAutomaticZenRule(rule)) {
                newConfig.automaticRules.remove(id2);
                if (DEBUG) {
                    Log.d(TAG, "removeZenRule zenRule=" + id2 + " reason=" + reason);
                }
            } else {
                throw new SecurityException("Cannot delete rules not owned by your condition provider");
            }
            return this.setConfigLocked(newConfig, reason, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAutomaticZenRules(String packageName, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return false;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            for (int i = newConfig.automaticRules.size() - 1; i >= 0; --i) {
                ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(newConfig.automaticRules.keyAt(i));
                if (!rule.pkg.equals(packageName) || !this.canManageAutomaticZenRule(rule)) continue;
                newConfig.automaticRules.removeAt(i);
            }
            return this.setConfigLocked(newConfig, reason, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutomaticZenRuleState(String id2, Condition condition) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            this.setAutomaticZenRuleStateLocked(newConfig, newConfig.automaticRules.get(id2), condition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutomaticZenRuleState(Uri ruleDefinition, Condition condition) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return;
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            this.setAutomaticZenRuleStateLocked(newConfig, this.findMatchingRule(newConfig, ruleDefinition, condition), condition);
        }
    }

    private void setAutomaticZenRuleStateLocked(ZenModeConfig config, ZenModeConfig.ZenRule rule, Condition condition) {
        if (rule == null) {
            return;
        }
        rule.condition = condition;
        this.updateSnoozing(rule);
        this.setConfigLocked(config, rule.component, "conditionChanged");
    }

    private ZenModeConfig.ZenRule findMatchingRule(ZenModeConfig config, Uri id2, Condition condition) {
        if (this.ruleMatches(id2, condition, config.manualRule)) {
            return config.manualRule;
        }
        for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
            if (!this.ruleMatches(id2, condition, automaticRule)) continue;
            return automaticRule;
        }
        return null;
    }

    private boolean ruleMatches(Uri id2, Condition condition, ZenModeConfig.ZenRule rule) {
        if (id2 == null || rule == null || rule.conditionId == null) {
            return false;
        }
        if (!rule.conditionId.equals(id2)) {
            return false;
        }
        return !Objects.equals(condition, rule.condition);
    }

    private boolean updateSnoozing(ZenModeConfig.ZenRule rule) {
        if (rule != null && rule.snoozing && !rule.isTrueOrUnknown()) {
            rule.snoozing = false;
            if (DEBUG) {
                Log.d(TAG, "Snoozing reset for " + rule.conditionId);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentInstanceCount(ComponentName cn) {
        if (cn == null) {
            return 0;
        }
        int count = 0;
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (!cn.equals(rule.component) && !cn.equals(rule.configurationActivity)) continue;
                ++count;
            }
        }
        return count;
    }

    public boolean canManageAutomaticZenRule(ZenModeConfig.ZenRule rule) {
        int callingUid = Binder.getCallingUid();
        if (callingUid == 0 || callingUid == 1000) {
            return true;
        }
        if (this.mContext.checkCallingPermission("android.permission.MANAGE_NOTIFICATIONS") == 0) {
            return true;
        }
        String[] packages = this.mPm.getPackagesForUid(Binder.getCallingUid());
        if (packages != null) {
            int packageCount = packages.length;
            for (int i = 0; i < packageCount; ++i) {
                if (!packages[i].equals(rule.pkg)) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateDefaultZenRules() {
        this.updateDefaultAutomaticRuleNames();
        for (ZenModeConfig.ZenRule defaultRule : this.mDefaultConfig.automaticRules.values()) {
            ZenModeConfig.ZenRule currRule = this.mConfig.automaticRules.get(defaultRule.id);
            if (currRule == null || currRule.modified || currRule.enabled || defaultRule.name.equals(currRule.name) || !this.canManageAutomaticZenRule(currRule)) continue;
            if (DEBUG) {
                Slog.d(TAG, "Locale change - updating default zen rule name from " + currRule.name + " to " + defaultRule.name);
            }
            currRule.name = defaultRule.name;
            this.updateAutomaticZenRule(defaultRule.id, this.createAutomaticZenRule(currRule), "locale changed");
        }
    }

    private boolean isSystemRule(AutomaticZenRule rule) {
        return rule.getOwner() != null && "android".equals(rule.getOwner().getPackageName());
    }

    private ServiceInfo getServiceInfo(ComponentName owner) {
        Intent queryIntent = new Intent();
        queryIntent.setComponent(owner);
        List<ResolveInfo> installedServices = this.mPm.queryIntentServicesAsUser(queryIntent, 132, UserHandle.getCallingUserId());
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                if (!this.mServiceConfig.bindPermission.equals(info.permission)) continue;
                return info;
            }
        }
        return null;
    }

    private ActivityInfo getActivityInfo(ComponentName configActivity) {
        int count;
        int i;
        Intent queryIntent = new Intent();
        queryIntent.setComponent(configActivity);
        List<ResolveInfo> installedComponents = this.mPm.queryIntentActivitiesAsUser(queryIntent, 129, UserHandle.getCallingUserId());
        if (installedComponents != null && (i = 0) < (count = installedComponents.size())) {
            ResolveInfo resolveInfo = installedComponents.get(i);
            return resolveInfo.activityInfo;
        }
        return null;
    }

    private void populateZenRule(AutomaticZenRule automaticZenRule, ZenModeConfig.ZenRule rule, boolean isNew) {
        if (isNew) {
            rule.id = ZenModeConfig.newRuleId();
            rule.creationTime = System.currentTimeMillis();
            rule.component = automaticZenRule.getOwner();
            rule.configurationActivity = automaticZenRule.getConfigurationActivity();
            String string2 = rule.pkg = rule.component != null ? rule.component.getPackageName() : rule.configurationActivity.getPackageName();
        }
        if (rule.enabled != automaticZenRule.isEnabled()) {
            rule.snoozing = false;
        }
        rule.name = automaticZenRule.getName();
        rule.condition = null;
        rule.conditionId = automaticZenRule.getConditionId();
        rule.enabled = automaticZenRule.isEnabled();
        rule.modified = automaticZenRule.isModified();
        rule.zenPolicy = automaticZenRule.getZenPolicy();
        rule.zenMode = NotificationManager.zenModeFromInterruptionFilter(automaticZenRule.getInterruptionFilter(), 0);
    }

    protected AutomaticZenRule createAutomaticZenRule(ZenModeConfig.ZenRule rule) {
        return new AutomaticZenRule(rule.name, rule.component, rule.configurationActivity, rule.conditionId, rule.zenPolicy, NotificationManager.zenModeToInterruptionFilter(rule.zenMode), rule.enabled, rule.creationTime);
    }

    public void setManualZenMode(int zenMode, Uri conditionId, String caller, String reason) {
        this.setManualZenMode(zenMode, conditionId, reason, caller, true);
        Settings.Secure.putInt(this.mContext.getContentResolver(), "show_zen_settings_suggestion", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setManualZenMode(int zenMode, Uri conditionId, String reason, String caller, boolean setRingerMode) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig == null) {
                return;
            }
            if (!Settings.Global.isValidZenMode(zenMode)) {
                return;
            }
            if (DEBUG) {
                Log.d(TAG, "setManualZenMode " + Settings.Global.zenModeToString(zenMode) + " conditionId=" + conditionId + " reason=" + reason + " setRingerMode=" + setRingerMode);
            }
            ZenModeConfig newConfig = this.mConfig.copy();
            if (zenMode == 0) {
                newConfig.manualRule = null;
                for (ZenModeConfig.ZenRule automaticRule : newConfig.automaticRules.values()) {
                    if (!automaticRule.isAutomaticActive()) continue;
                    automaticRule.snoozing = true;
                }
            } else {
                ZenModeConfig.ZenRule newRule = new ZenModeConfig.ZenRule();
                newRule.enabled = true;
                newRule.zenMode = zenMode;
                newRule.conditionId = conditionId;
                newRule.enabler = caller;
                newConfig.manualRule = newRule;
            }
            this.setConfigLocked(newConfig, reason, null, setRingerMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(ProtoOutputStream proto) {
        proto.write(0x10E00000001L, this.mZenMode);
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig.manualRule != null) {
                this.mConfig.manualRule.writeToProto(proto, 0x20B00000002L);
            }
            for (ZenModeConfig.ZenRule rule : this.mConfig.automaticRules.values()) {
                if (!rule.enabled || rule.condition.state != 1 || rule.snoozing) continue;
                rule.writeToProto(proto, 0x20B00000002L);
            }
            this.mConfig.toNotificationPolicy().writeToProto(proto, 1146756268037L);
            proto.write(1120986464259L, this.mSuppressedEffects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mZenMode=");
        pw.println(Settings.Global.zenModeToString(this.mZenMode));
        pw.print("mConsolidatedPolicy=" + this.mConsolidatedPolicy.toString());
        int N = this.mConfigs.size();
        for (int i = 0; i < N; ++i) {
            ZenModeHelper.dump(pw, prefix, "mConfigs[u=" + this.mConfigs.keyAt(i) + "]", this.mConfigs.valueAt(i));
        }
        pw.print(prefix);
        pw.print("mUser=");
        pw.println(this.mUser);
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeHelper.dump(pw, prefix, "mConfig", this.mConfig);
        }
        pw.print(prefix);
        pw.print("mSuppressedEffects=");
        pw.println(this.mSuppressedEffects);
        this.mFiltering.dump(pw, prefix);
        this.mConditions.dump(pw, prefix);
    }

    private static void dump(PrintWriter pw, String prefix, String var, ZenModeConfig config) {
        pw.print(prefix);
        pw.print(var);
        pw.print('=');
        if (config == null) {
            pw.println(config);
            return;
        }
        pw.printf("allow(alarms=%b,media=%b,system=%b,calls=%b,callsFrom=%s,repeatCallers=%b,messages=%b,messagesFrom=%s,events=%b,reminders=%b)\n", config.allowAlarms, config.allowMedia, config.allowSystem, config.allowCalls, ZenModeConfig.sourceToString(config.allowCallsFrom), config.allowRepeatCallers, config.allowMessages, ZenModeConfig.sourceToString(config.allowMessagesFrom), config.allowEvents, config.allowReminders);
        pw.printf(" disallow(visualEffects=%s)\n", config.suppressedVisualEffects);
        pw.print(prefix);
        pw.print("  manualRule=");
        pw.println(config.manualRule);
        if (config.automaticRules.isEmpty()) {
            return;
        }
        int N = config.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            pw.print(prefix);
            pw.print(i == 0 ? "  automaticRules=" : "                 ");
            pw.println(config.automaticRules.valueAt(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readXml(XmlPullParser parser, boolean forRestore, int userId) throws XmlPullParserException, IOException {
        ZenModeConfig config = ZenModeConfig.readXml(parser);
        String reason = "readXml";
        if (config != null) {
            if (forRestore) {
                config.user = userId;
                config.manualRule = null;
            }
            boolean allRulesDisabled = true;
            boolean hasDefaultRules = config.automaticRules.containsAll(ZenModeConfig.DEFAULT_RULE_IDS);
            long time = System.currentTimeMillis();
            if (config.automaticRules != null && config.automaticRules.size() > 0) {
                for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
                    if (forRestore) {
                        automaticRule.snoozing = false;
                        automaticRule.condition = null;
                        automaticRule.creationTime = time;
                    }
                    allRulesDisabled &= !automaticRule.enabled;
                }
            }
            if (!hasDefaultRules && allRulesDisabled && (forRestore || config.version < 8)) {
                config.automaticRules = new ArrayMap();
                for (ZenModeConfig.ZenRule rule : this.mDefaultConfig.automaticRules.values()) {
                    config.automaticRules.put(rule.id, rule);
                }
                reason = reason + ", reset to default rules";
            }
            int n = userId = userId == -1 ? 0 : userId;
            if (config.version < 8) {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 1, userId);
            } else {
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "zen_settings_updated", 1, userId);
            }
            if (DEBUG) {
                Log.d(TAG, reason);
            }
            ZenModeConfig zenModeConfig = this.mConfig;
            synchronized (zenModeConfig) {
                this.setConfigLocked(config, null, reason);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeXml(XmlSerializer out, boolean forBackup, Integer version, int userId) throws IOException {
        SparseArray<ZenModeConfig> sparseArray = this.mConfigs;
        synchronized (sparseArray) {
            int n = this.mConfigs.size();
            for (int i = 0; i < n; ++i) {
                if (forBackup && this.mConfigs.keyAt(i) != userId) continue;
                this.mConfigs.valueAt(i).writeXml(out, version);
            }
        }
    }

    public NotificationManager.Policy getNotificationPolicy() {
        return ZenModeHelper.getNotificationPolicy(this.mConfig);
    }

    private static NotificationManager.Policy getNotificationPolicy(ZenModeConfig config) {
        return config == null ? null : config.toNotificationPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null || this.mConfig == null) {
            return;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeConfig newConfig = this.mConfig.copy();
            newConfig.applyNotificationPolicy(policy);
            this.setConfigLocked(newConfig, null, "setNotificationPolicy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpZenRules() {
        long currentTime = System.currentTimeMillis();
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenModeConfig newConfig = this.mConfig.copy();
            if (newConfig.automaticRules != null) {
                for (int i = newConfig.automaticRules.size() - 1; i >= 0; --i) {
                    ZenModeConfig.ZenRule rule = newConfig.automaticRules.get(newConfig.automaticRules.keyAt(i));
                    if (259200000L >= currentTime - rule.creationTime) continue;
                    try {
                        if (rule.pkg == null) continue;
                        this.mPm.getPackageInfo(rule.pkg, 0x400000);
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        newConfig.automaticRules.removeAt(i);
                    }
                }
            }
            this.setConfigLocked(newConfig, null, "cleanUpZenRules");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZenModeConfig getConfig() {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            return this.mConfig.copy();
        }
    }

    public NotificationManager.Policy getConsolidatedNotificationPolicy() {
        if (this.mConsolidatedPolicy == null) {
            return null;
        }
        return this.mConsolidatedPolicy.copy();
    }

    public boolean setConfigLocked(ZenModeConfig config, ComponentName triggeringComponent, String reason) {
        return this.setConfigLocked(config, reason, triggeringComponent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfig(ZenModeConfig config, ComponentName triggeringComponent, String reason) {
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            this.setConfigLocked(config, triggeringComponent, reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setConfigLocked(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
        long identity = Binder.clearCallingIdentity();
        try {
            boolean policyChanged;
            if (config == null || !config.isValid()) {
                Log.w(TAG, "Invalid config in setConfigLocked; " + config);
                boolean bl = false;
                return bl;
            }
            if (config.user != this.mUser) {
                this.mConfigs.put(config.user, config);
                if (DEBUG) {
                    Log.d(TAG, "setConfigLocked: store config for user " + config.user);
                }
                boolean bl = true;
                return bl;
            }
            this.mConditions.evaluateConfig(config, null, false);
            this.mConfigs.put(config.user, config);
            if (DEBUG) {
                Log.d(TAG, "setConfigLocked reason=" + reason, new Throwable());
            }
            ZenLog.traceConfig(reason, this.mConfig, config);
            boolean bl = policyChanged = !Objects.equals(ZenModeHelper.getNotificationPolicy(this.mConfig), ZenModeHelper.getNotificationPolicy(config));
            if (!config.equals(this.mConfig)) {
                this.dispatchOnConfigChanged();
                this.updateConsolidatedPolicy(reason);
            }
            if (policyChanged) {
                this.dispatchOnPolicyChanged();
            }
            this.mConfig = config;
            this.mHandler.postApplyConfig(config, reason, triggeringComponent, setRingerMode);
            boolean bl2 = true;
            return bl2;
        }
        catch (SecurityException e) {
            Log.wtf(TAG, "Invalid rule in config", e);
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void applyConfig(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
        String val = Integer.toString(config.hashCode());
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_config_etag", val);
        this.evaluateZenMode(reason, setRingerMode);
        this.mConditions.evaluateConfig(config, triggeringComponent, true);
    }

    private int getZenModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode", 0);
    }

    @VisibleForTesting
    protected void setZenModeSetting(int zen) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "zen_mode", zen);
        this.showZenUpgradeNotification(zen);
    }

    private int getPreviousRingerModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode_ringer_level", 2);
    }

    private void setPreviousRingerModeSetting(Integer previousRingerLevel) {
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_ringer_level", previousRingerLevel == null ? null : Integer.toString(previousRingerLevel));
    }

    @VisibleForTesting
    protected void evaluateZenMode(String reason, boolean setRingerMode) {
        if (DEBUG) {
            Log.d(TAG, "evaluateZenMode");
        }
        if (this.mConfig == null) {
            return;
        }
        int policyHashBefore = this.mConsolidatedPolicy == null ? 0 : this.mConsolidatedPolicy.hashCode();
        int zenBefore = this.mZenMode;
        int zen = this.computeZenMode();
        ZenLog.traceSetZenMode(zen, reason);
        this.mZenMode = zen;
        this.setZenModeSetting(this.mZenMode);
        this.updateConsolidatedPolicy(reason);
        this.updateRingerModeAffectedStreams();
        if (setRingerMode && (zen != zenBefore || zen == 1 && policyHashBefore != this.mConsolidatedPolicy.hashCode())) {
            this.applyZenToRingerMode();
        }
        this.applyRestrictions();
        if (zen != zenBefore) {
            this.mHandler.postDispatchOnZenModeChanged();
        }
    }

    private void updateRingerModeAffectedStreams() {
        if (this.mAudioManager != null) {
            this.mAudioManager.updateRingerModeAffectedStreamsInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int computeZenMode() {
        if (this.mConfig == null) {
            return 0;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            if (this.mConfig.manualRule != null) {
                return this.mConfig.manualRule.zenMode;
            }
            int zen = 0;
            for (ZenModeConfig.ZenRule automaticRule : this.mConfig.automaticRules.values()) {
                if (!automaticRule.isAutomaticActive() || ZenModeHelper.zenSeverity(automaticRule.zenMode) <= ZenModeHelper.zenSeverity(zen)) continue;
                if (Settings.Secure.getInt(this.mContext.getContentResolver(), "zen_settings_suggestion_viewed", 1) == 0) {
                    Settings.Secure.putInt(this.mContext.getContentResolver(), "show_zen_settings_suggestion", 1);
                }
                zen = automaticRule.zenMode;
            }
            return zen;
        }
    }

    private void applyCustomPolicy(ZenPolicy policy, ZenModeConfig.ZenRule rule) {
        if (rule.zenMode == 3) {
            policy.apply(new ZenPolicy.Builder().disallowAllSounds().build());
        } else if (rule.zenMode == 4) {
            policy.apply(new ZenPolicy.Builder().disallowAllSounds().allowAlarms(true).allowMedia(true).build());
        } else {
            policy.apply(rule.zenPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConsolidatedPolicy(String reason) {
        if (this.mConfig == null) {
            return;
        }
        ZenModeConfig zenModeConfig = this.mConfig;
        synchronized (zenModeConfig) {
            ZenPolicy policy = new ZenPolicy();
            if (this.mConfig.manualRule != null) {
                this.applyCustomPolicy(policy, this.mConfig.manualRule);
            }
            for (ZenModeConfig.ZenRule automaticRule : this.mConfig.automaticRules.values()) {
                if (!automaticRule.isAutomaticActive()) continue;
                this.applyCustomPolicy(policy, automaticRule);
            }
            NotificationManager.Policy newPolicy = this.mConfig.toNotificationPolicy(policy);
            if (!Objects.equals(this.mConsolidatedPolicy, newPolicy)) {
                this.mConsolidatedPolicy = newPolicy;
                this.dispatchOnConsolidatedPolicyChanged();
                ZenLog.traceSetConsolidatedZenPolicy(this.mConsolidatedPolicy, reason);
            }
        }
    }

    private void updateDefaultAutomaticRuleNames() {
        for (ZenModeConfig.ZenRule rule : this.mDefaultConfig.automaticRules.values()) {
            if ("EVENTS_DEFAULT_RULE".equals(rule.id)) {
                rule.name = this.mContext.getResources().getString(17041324);
                continue;
            }
            if (!"EVERY_NIGHT_DEFAULT_RULE".equals(rule.id)) continue;
            rule.name = this.mContext.getResources().getString(17041325);
        }
    }

    @VisibleForTesting
    protected void applyRestrictions() {
        boolean zenPriorityOnly = this.mZenMode == 1;
        boolean zenSilence = this.mZenMode == 2;
        boolean zenAlarmsOnly = this.mZenMode == 3;
        boolean allowCalls = this.mConsolidatedPolicy.allowCalls();
        boolean allowRepeatCallers = this.mConsolidatedPolicy.allowRepeatCallers();
        boolean allowSystem = this.mConsolidatedPolicy.allowSystem();
        boolean allowMedia = this.mConsolidatedPolicy.allowMedia();
        boolean allowAlarms = this.mConsolidatedPolicy.allowAlarms();
        boolean muteNotifications = (this.mSuppressedEffects & 1L) != 0L;
        boolean muteCalls = zenAlarmsOnly || zenPriorityOnly && !allowCalls && !allowRepeatCallers || (this.mSuppressedEffects & 2L) != 0L;
        boolean muteAlarms = zenPriorityOnly && !allowAlarms;
        boolean muteMedia = zenPriorityOnly && !allowMedia;
        boolean muteSystem = zenAlarmsOnly || zenPriorityOnly && !allowSystem;
        boolean muteEverything = zenSilence || zenPriorityOnly && ZenModeConfig.areAllZenBehaviorSoundsMuted(this.mConsolidatedPolicy);
        for (int usage : AudioAttributes.SDK_USAGES) {
            int suppressionBehavior = AudioAttributes.SUPPRESSIBLE_USAGES.get(usage);
            if (suppressionBehavior == 3) {
                this.applyRestrictions(zenPriorityOnly, false, usage);
                continue;
            }
            if (suppressionBehavior == 1) {
                this.applyRestrictions(zenPriorityOnly, muteNotifications || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 2) {
                this.applyRestrictions(zenPriorityOnly, muteCalls || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 4) {
                this.applyRestrictions(zenPriorityOnly, muteAlarms || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 5) {
                this.applyRestrictions(zenPriorityOnly, muteMedia || muteEverything, usage);
                continue;
            }
            if (suppressionBehavior == 6) {
                if (usage == 13) {
                    this.applyRestrictions(zenPriorityOnly, muteSystem || muteEverything, usage, 28);
                    this.applyRestrictions(zenPriorityOnly, false, usage, 3);
                    continue;
                }
                this.applyRestrictions(zenPriorityOnly, muteSystem || muteEverything, usage);
                continue;
            }
            this.applyRestrictions(zenPriorityOnly, muteEverything, usage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void applyRestrictions(boolean zenPriorityOnly, boolean mute, int usage, int code) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAppOps.setRestriction(code, usage, mute ? 1 : 0, zenPriorityOnly ? this.mPriorityOnlyDndExemptPackages : null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @VisibleForTesting
    protected void applyRestrictions(boolean zenPriorityOnly, boolean mute, int usage) {
        this.applyRestrictions(zenPriorityOnly, mute, usage, 3);
        this.applyRestrictions(zenPriorityOnly, mute, usage, 28);
    }

    @VisibleForTesting
    protected void applyZenToRingerMode() {
        int ringerModeInternal;
        if (this.mAudioManager == null) {
            return;
        }
        int newRingerModeInternal = ringerModeInternal = this.mAudioManager.getRingerModeInternal();
        switch (this.mZenMode) {
            case 2: 
            case 3: {
                if (ringerModeInternal == 0) break;
                this.setPreviousRingerModeSetting(ringerModeInternal);
                newRingerModeInternal = 0;
                break;
            }
            case 1: {
                break;
            }
            case 0: {
                if (ringerModeInternal != 0) break;
                newRingerModeInternal = this.getPreviousRingerModeSetting();
                this.setPreviousRingerModeSetting(null);
            }
        }
        if (newRingerModeInternal != -1) {
            this.mAudioManager.setRingerModeInternal(newRingerModeInternal, TAG);
        }
    }

    private void dispatchOnConfigChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onConfigChanged();
        }
    }

    private void dispatchOnPolicyChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onPolicyChanged();
        }
    }

    private void dispatchOnConsolidatedPolicyChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onConsolidatedPolicyChanged();
        }
    }

    private void dispatchOnZenModeChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onZenModeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenModeConfig readDefaultConfig(Resources resources) {
        XmlResourceParser parser = null;
        try {
            parser = resources.getXml(0x1170007);
            while (parser.next() != 1) {
                ZenModeConfig config = ZenModeConfig.readXml(parser);
                if (config == null) continue;
                ZenModeConfig zenModeConfig = config;
                return zenModeConfig;
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Error reading default zen mode config from resource", e);
        }
        finally {
            IoUtils.closeQuietly(parser);
        }
        return new ZenModeConfig();
    }

    private static int zenSeverity(int zen) {
        switch (zen) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    private void showZenUpgradeNotification(int zen) {
        boolean showNotification;
        boolean isWatch = this.mContext.getPackageManager().hasSystemFeature("android.hardware.type.watch");
        boolean bl = showNotification = this.mIsBootComplete && zen != 0 && !isWatch && Settings.Secure.getInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 0) != 0 && Settings.Secure.getInt(this.mContext.getContentResolver(), "zen_settings_updated", 0) != 1;
        if (isWatch) {
            Settings.Secure.putInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 0);
        }
        if (showNotification) {
            this.mNotificationManager.notify(TAG, 48, this.createZenUpgradeNotification());
            Settings.Secure.putInt(this.mContext.getContentResolver(), "show_zen_upgrade_notification", 0);
        }
    }

    @VisibleForTesting
    protected Notification createZenUpgradeNotification() {
        Bundle extras = new Bundle();
        extras.putString("android.substName", this.mContext.getResources().getString(17040058));
        int title = 17041335;
        int content = 17041334;
        int drawable2 = 17302850;
        if (NotificationManager.Policy.areAllVisualEffectsSuppressed(this.getConsolidatedNotificationPolicy().suppressedVisualEffects)) {
            title = 17041337;
            content = 17041336;
            drawable2 = 17302379;
        }
        Intent onboardingIntent = new Intent("android.settings.ZEN_MODE_ONBOARDING");
        onboardingIntent.addFlags(0x10008000);
        return new Notification.Builder(this.mContext, SystemNotificationChannels.DO_NOT_DISTURB).setAutoCancel(true).setSmallIcon(17302795).setLargeIcon(Icon.createWithResource(this.mContext, drawable2)).setContentTitle(this.mContext.getResources().getString(title)).setContentText(this.mContext.getResources().getString(content)).setContentIntent(PendingIntent.getActivity(this.mContext, 0, onboardingIntent, 0x8000000)).setAutoCancel(true).setLocalOnly(true).addExtras(extras).setStyle(new Notification.BigTextStyle()).build();
    }

    public static class Callback {
        void onConfigChanged() {
        }

        void onZenModeChanged() {
        }

        void onPolicyChanged() {
        }

        void onConsolidatedPolicyChanged() {
        }
    }

    private final class H
    extends Handler {
        private static final int MSG_DISPATCH = 1;
        private static final int MSG_METRICS = 2;
        private static final int MSG_APPLY_CONFIG = 4;
        private static final long METRICS_PERIOD_MS = 21600000L;

        private H(Looper looper) {
            super(looper);
        }

        private void postDispatchOnZenModeChanged() {
            this.removeMessages(1);
            this.sendEmptyMessage(1);
        }

        private void postMetricsTimer() {
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(2, 21600000L);
        }

        private void postApplyConfig(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
            this.sendMessage(this.obtainMessage(4, new ConfigMessageData(config, reason, triggeringComponent, setRingerMode)));
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZenModeHelper.this.dispatchOnZenModeChanged();
                    break;
                }
                case 2: {
                    ZenModeHelper.this.mMetrics.emit();
                    break;
                }
                case 4: {
                    ConfigMessageData applyConfigData = (ConfigMessageData)msg.obj;
                    ZenModeHelper.this.applyConfig(applyConfigData.config, applyConfigData.reason, applyConfigData.triggeringComponent, applyConfigData.setRingerMode);
                }
            }
        }

        private final class ConfigMessageData {
            public final ZenModeConfig config;
            public ComponentName triggeringComponent;
            public final String reason;
            public final boolean setRingerMode;

            ConfigMessageData(ZenModeConfig config, String reason, ComponentName triggeringComponent, boolean setRingerMode) {
                this.config = config;
                this.reason = reason;
                this.setRingerMode = setRingerMode;
                this.triggeringComponent = triggeringComponent;
            }
        }
    }

    private final class Metrics
    extends Callback {
        private static final String COUNTER_MODE_PREFIX = "dnd_mode_";
        private static final String COUNTER_TYPE_PREFIX = "dnd_type_";
        private static final int DND_OFF = 0;
        private static final int DND_ON_MANUAL = 1;
        private static final int DND_ON_AUTOMATIC = 2;
        private static final String COUNTER_RULE = "dnd_rule_count";
        private static final long MINIMUM_LOG_PERIOD_MS = 60000L;
        private int mPreviousZenMode = -1;
        private long mModeLogTimeMs = 0L;
        private int mNumZenRules = -1;
        private long mRuleCountLogTime = 0L;
        private int mPreviousZenType = -1;
        private long mTypeLogTimeMs = 0L;

        private Metrics() {
        }

        @Override
        void onZenModeChanged() {
            this.emit();
        }

        @Override
        void onConfigChanged() {
            this.emit();
        }

        private void emit() {
            ZenModeHelper.this.mHandler.postMetricsTimer();
            this.emitZenMode();
            this.emitRules();
            this.emitDndType();
        }

        private void emitZenMode() {
            long now = SystemClock.elapsedRealtime();
            long since = now - this.mModeLogTimeMs;
            if (this.mPreviousZenMode != ZenModeHelper.this.mZenMode || since > 60000L) {
                if (this.mPreviousZenMode != -1) {
                    MetricsLogger.count(ZenModeHelper.this.mContext, COUNTER_MODE_PREFIX + this.mPreviousZenMode, (int)since);
                }
                this.mPreviousZenMode = ZenModeHelper.this.mZenMode;
                this.mModeLogTimeMs = now;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitRules() {
            long now = SystemClock.elapsedRealtime();
            long since = now - this.mRuleCountLogTime;
            ZenModeConfig zenModeConfig = ZenModeHelper.this.mConfig;
            synchronized (zenModeConfig) {
                int numZenRules = ZenModeHelper.this.mConfig.automaticRules.size();
                if (this.mNumZenRules != numZenRules || since > 60000L) {
                    if (this.mNumZenRules != -1) {
                        MetricsLogger.count(ZenModeHelper.this.mContext, COUNTER_RULE, numZenRules - this.mNumZenRules);
                    }
                    this.mNumZenRules = numZenRules;
                    this.mRuleCountLogTime = since;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitDndType() {
            long now = SystemClock.elapsedRealtime();
            long since = now - this.mTypeLogTimeMs;
            ZenModeConfig zenModeConfig = ZenModeHelper.this.mConfig;
            synchronized (zenModeConfig) {
                int zenType;
                boolean dndOn;
                boolean bl = dndOn = ZenModeHelper.this.mZenMode != 0;
                int n = !dndOn ? 0 : (zenType = ZenModeHelper.this.mConfig.manualRule != null ? 1 : 2);
                if (zenType != this.mPreviousZenType || since > 60000L) {
                    if (this.mPreviousZenType != -1) {
                        MetricsLogger.count(ZenModeHelper.this.mContext, COUNTER_TYPE_PREFIX + this.mPreviousZenType, (int)since);
                    }
                    this.mTypeLogTimeMs = now;
                    this.mPreviousZenType = zenType;
                }
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri ZEN_MODE;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.ZEN_MODE = Settings.Global.getUriFor("zen_mode");
        }

        public void observe() {
            ContentResolver resolver = ZenModeHelper.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.ZEN_MODE, false, this);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            if (this.ZEN_MODE.equals(uri) && ZenModeHelper.this.mZenMode != ZenModeHelper.this.getZenModeSetting()) {
                if (DEBUG) {
                    Log.d(ZenModeHelper.TAG, "Fixing zen mode setting");
                }
                ZenModeHelper.this.setZenModeSetting(ZenModeHelper.this.mZenMode);
            }
        }
    }

    @VisibleForTesting
    protected final class RingerModeDelegate
    implements AudioManagerInternal.RingerModeDelegate {
        protected RingerModeDelegate() {
        }

        public String toString() {
            return ZenModeHelper.TAG;
        }

        @Override
        public int onSetRingerModeInternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeExternal, VolumePolicy policy) {
            boolean isChange = ringerModeOld != ringerModeNew;
            int ringerModeExternalOut = ringerModeNew;
            if (ZenModeHelper.this.mZenMode == 0 || ZenModeHelper.this.mZenMode == 1 && !ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig)) {
                ZenModeHelper.this.setPreviousRingerModeSetting(ringerModeNew);
            }
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (!isChange || !policy.doNotDisturbWhenSilent) break;
                    if (ZenModeHelper.this.mZenMode == 0) {
                        newZen = 1;
                    }
                    ZenModeHelper.this.setPreviousRingerModeSetting(ringerModeOld);
                    break;
                }
                case 1: 
                case 2: {
                    if (isChange && ringerModeOld == 0 && (ZenModeHelper.this.mZenMode == 2 || ZenModeHelper.this.mZenMode == 3 || ZenModeHelper.this.mZenMode == 1 && ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig))) {
                        newZen = 0;
                        break;
                    }
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    ringerModeExternalOut = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeInternal", null, false);
            }
            if (isChange || newZen != -1 || ringerModeExternal != ringerModeExternalOut) {
                ZenLog.traceSetRingerModeInternal(ringerModeOld, ringerModeNew, caller, ringerModeExternal, ringerModeExternalOut);
            }
            return ringerModeExternalOut;
        }

        @Override
        public int onSetRingerModeExternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeInternal, VolumePolicy policy) {
            int ringerModeInternalOut = ringerModeNew;
            boolean isChange = ringerModeOld != ringerModeNew;
            boolean isVibrate = ringerModeInternal == 1;
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (isChange) {
                        if (ZenModeHelper.this.mZenMode == 0) {
                            newZen = 1;
                        }
                        ringerModeInternalOut = isVibrate ? 1 : 0;
                        break;
                    }
                    ringerModeInternalOut = ringerModeInternal;
                    break;
                }
                case 1: 
                case 2: {
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    newZen = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeExternal", caller, false);
            }
            ZenLog.traceSetRingerModeExternal(ringerModeOld, ringerModeNew, caller, ringerModeInternal, ringerModeInternalOut);
            return ringerModeInternalOut;
        }

        @Override
        public boolean canVolumeDownEnterSilent() {
            return ZenModeHelper.this.mZenMode == 0;
        }

        @Override
        public int getRingerModeAffectedStreams(int streams) {
            streams |= 0x26;
            streams = ZenModeHelper.this.mZenMode == 2 ? (streams |= 0x18) : (streams &= 0xFFFFFFE7);
            streams = ZenModeHelper.this.mZenMode == 1 && ZenModeConfig.areAllPriorityOnlyNotificationZenSoundsMuted(ZenModeHelper.this.mConfig) ? (streams &= 0xFFFFFFFD) : (streams |= 2);
            return streams;
        }
    }
}

