/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.oemlock;

import android.app.ActivityManager;
import android.content.Context;
import android.hardware.oemlock.V1_0.IOemLock;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.UserManagerInternal;
import android.service.oemlock.IOemLockService;
import android.util.Slog;
import com.android.server.LocalServices;
import com.android.server.PersistentDataBlockManagerInternal;
import com.android.server.SystemService;
import com.android.server.oemlock.OemLock;
import com.android.server.oemlock.PersistentDataBlockLock;
import com.android.server.oemlock.VendorLock;
import com.android.server.pm.UserRestrictionsUtils;

public class OemLockService
extends SystemService {
    private static final String TAG = "OemLock";
    private static final String FLASH_LOCK_PROP = "ro.boot.flash.locked";
    private static final String FLASH_LOCK_UNLOCKED = "0";
    private Context mContext;
    private OemLock mOemLock;
    private final UserManagerInternal.UserRestrictionsListener mUserRestrictionsListener = new UserManagerInternal.UserRestrictionsListener(){

        @Override
        public void onUserRestrictionsChanged(int userId, Bundle newRestrictions, Bundle prevRestrictions) {
            if (UserRestrictionsUtils.restrictionsChanged(prevRestrictions, newRestrictions, "no_factory_reset")) {
                boolean unlockAllowedByAdmin;
                boolean bl = unlockAllowedByAdmin = !newRestrictions.getBoolean("no_factory_reset");
                if (!unlockAllowedByAdmin) {
                    OemLockService.this.mOemLock.setOemUnlockAllowedByDevice(false);
                    OemLockService.this.setPersistentDataBlockOemUnlockAllowedBit(false);
                }
            }
        }
    };
    private final IBinder mService = new IOemLockService.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getLockName() {
            OemLockService.this.enforceManageCarrierOemUnlockPermission();
            long token = Binder.clearCallingIdentity();
            try {
                String string2 = OemLockService.this.mOemLock.getLockName();
                return string2;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) {
            OemLockService.this.enforceManageCarrierOemUnlockPermission();
            OemLockService.this.enforceUserIsAdmin();
            long token = Binder.clearCallingIdentity();
            try {
                OemLockService.this.mOemLock.setOemUnlockAllowedByCarrier(allowed, signature);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOemUnlockAllowedByCarrier() {
            OemLockService.this.enforceManageCarrierOemUnlockPermission();
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = OemLockService.this.mOemLock.isOemUnlockAllowedByCarrier();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setOemUnlockAllowedByUser(boolean allowedByUser) {
            if (ActivityManager.isUserAMonkey()) {
                return;
            }
            OemLockService.this.enforceManageUserOemUnlockPermission();
            OemLockService.this.enforceUserIsAdmin();
            long token = Binder.clearCallingIdentity();
            try {
                if (!OemLockService.this.isOemUnlockAllowedByAdmin()) {
                    throw new SecurityException("Admin does not allow OEM unlock");
                }
                if (!OemLockService.this.mOemLock.isOemUnlockAllowedByCarrier()) {
                    throw new SecurityException("Carrier does not allow OEM unlock");
                }
                OemLockService.this.mOemLock.setOemUnlockAllowedByDevice(allowedByUser);
                OemLockService.this.setPersistentDataBlockOemUnlockAllowedBit(allowedByUser);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOemUnlockAllowedByUser() {
            OemLockService.this.enforceManageUserOemUnlockPermission();
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = OemLockService.this.mOemLock.isOemUnlockAllowedByDevice();
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isOemUnlockAllowed() {
            OemLockService.this.enforceOemUnlockReadPermission();
            long token = Binder.clearCallingIdentity();
            try {
                boolean allowed = OemLockService.this.mOemLock.isOemUnlockAllowedByCarrier() && OemLockService.this.mOemLock.isOemUnlockAllowedByDevice();
                OemLockService.this.setPersistentDataBlockOemUnlockAllowedBit(allowed);
                boolean bl = allowed;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public boolean isDeviceOemUnlocked() {
            String locked;
            OemLockService.this.enforceOemUnlockReadPermission();
            switch (locked = SystemProperties.get(OemLockService.FLASH_LOCK_PROP)) {
                case "0": {
                    return true;
                }
            }
            return false;
        }
    };

    public static boolean isHalPresent() {
        return VendorLock.getOemLockHalService() != null;
    }

    private static OemLock getOemLock(Context context) {
        IOemLock oemLockHal = VendorLock.getOemLockHalService();
        if (oemLockHal != null) {
            Slog.i(TAG, "Using vendor lock via the HAL");
            return new VendorLock(context, oemLockHal);
        }
        Slog.i(TAG, "Using persistent data block based lock");
        return new PersistentDataBlockLock(context);
    }

    public OemLockService(Context context) {
        this(context, OemLockService.getOemLock(context));
    }

    OemLockService(Context context, OemLock oemLock) {
        super(context);
        this.mContext = context;
        this.mOemLock = oemLock;
        LocalServices.getService(UserManagerInternal.class).addUserRestrictionsListener(this.mUserRestrictionsListener);
    }

    @Override
    public void onStart() {
        this.publishBinderService("oem_lock", this.mService);
    }

    private void setPersistentDataBlockOemUnlockAllowedBit(boolean allowed) {
        PersistentDataBlockManagerInternal pdbmi = LocalServices.getService(PersistentDataBlockManagerInternal.class);
        if (pdbmi != null && !(this.mOemLock instanceof PersistentDataBlockLock)) {
            Slog.i(TAG, "Update OEM Unlock bit in pst partition to " + allowed);
            pdbmi.forceOemUnlockEnabled(allowed);
        }
    }

    private boolean isOemUnlockAllowedByAdmin() {
        return !UserManager.get(this.mContext).hasUserRestriction("no_factory_reset", UserHandle.SYSTEM);
    }

    private void enforceManageCarrierOemUnlockPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CARRIER_OEM_UNLOCK_STATE", "Can't manage OEM unlock allowed by carrier");
    }

    private void enforceManageUserOemUnlockPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USER_OEM_UNLOCK_STATE", "Can't manage OEM unlock allowed by user");
    }

    private void enforceOemUnlockReadPermission() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.READ_OEM_UNLOCK_STATE") == -1 && this.mContext.checkCallingOrSelfPermission("android.permission.OEM_UNLOCK_STATE") == -1) {
            throw new SecurityException("Can't access OEM unlock state. Requires READ_OEM_UNLOCK_STATE or OEM_UNLOCK_STATE permission.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceUserIsAdmin() {
        int userId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            if (!UserManager.get(this.mContext).isUserAdmin(userId)) {
                throw new SecurityException("Must be an admin user");
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }
}

