/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.os.IBinder;
import android.os.IIdmap2;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.util.Slog;
import com.android.internal.os.BackgroundThread;
import com.android.server.om.OverlayManagerServiceImpl;
import com.android.server.pm.Installer;
import java.io.File;

class IdmapManager {
    private static final boolean FEATURE_FLAG_IDMAP2 = true;
    private final Installer mInstaller;
    private final OverlayManagerServiceImpl.PackageManagerHelper mPackageManager;
    private IIdmap2 mIdmap2Service;
    private static final boolean VENDOR_IS_Q_OR_LATER;

    IdmapManager(Installer installer, OverlayManagerServiceImpl.PackageManagerHelper packageManager) {
        this.mInstaller = installer;
        this.mPackageManager = packageManager;
        this.connectToIdmap2d();
    }

    boolean createIdmap(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) {
        int sharedGid = UserHandle.getSharedAppGid(targetPackage.applicationInfo.uid);
        String targetPath = targetPackage.applicationInfo.getBaseCodePath();
        String overlayPath = overlayPackage.applicationInfo.getBaseCodePath();
        try {
            int policies = this.calculateFulfilledPolicies(targetPackage, overlayPackage, userId);
            boolean enforce = this.enforceOverlayable(overlayPackage);
            if (this.mIdmap2Service.verifyIdmap(overlayPath, policies, enforce, userId)) {
                return true;
            }
            return this.mIdmap2Service.createIdmap(targetPath, overlayPath, policies, enforce, userId) != null;
        }
        catch (Exception e) {
            Slog.w("OverlayManager", "failed to generate idmap for " + targetPath + " and " + overlayPath + ": " + e.getMessage());
            return false;
        }
    }

    boolean removeIdmap(OverlayInfo oi, int userId) {
        try {
            return this.mIdmap2Service.removeIdmap(oi.baseCodePath, userId);
        }
        catch (Exception e) {
            Slog.w("OverlayManager", "failed to remove idmap for " + oi.baseCodePath + ": " + e.getMessage());
            return false;
        }
    }

    boolean idmapExists(OverlayInfo oi) {
        return new File(this.getIdmapPath(oi.baseCodePath, oi.userId)).isFile();
    }

    boolean idmapExists(PackageInfo overlayPackage, int userId) {
        return new File(this.getIdmapPath(overlayPackage.applicationInfo.getBaseCodePath(), userId)).isFile();
    }

    private String getIdmapPath(String overlayPackagePath, int userId) {
        try {
            return this.mIdmap2Service.getIdmapPath(overlayPackagePath, userId);
        }
        catch (Exception e) {
            Slog.w("OverlayManager", "failed to get idmap path for " + overlayPackagePath + ": " + e.getMessage());
            return "";
        }
    }

    private void connectToIdmap2d() {
        IBinder binder = ServiceManager.getService("idmap");
        if (binder != null) {
            try {
                binder.linkToDeath(new IBinder.DeathRecipient(){

                    @Override
                    public void binderDied() {
                        Slog.w("OverlayManager", "service 'idmap' died; reconnecting...");
                        IdmapManager.this.connectToIdmap2d();
                    }
                }, 0);
            }
            catch (RemoteException e) {
                binder = null;
            }
        }
        if (binder != null) {
            this.mIdmap2Service = IIdmap2.Stub.asInterface(binder);
        } else {
            Slog.w("OverlayManager", "service 'idmap' not found; trying again...");
            BackgroundThread.getHandler().postDelayed(() -> this.connectToIdmap2d(), 1000L);
        }
    }

    private boolean enforceOverlayable(PackageInfo overlayPackage) {
        ApplicationInfo ai = overlayPackage.applicationInfo;
        if (ai.targetSdkVersion >= 29) {
            return true;
        }
        if (ai.isVendor()) {
            return VENDOR_IS_Q_OR_LATER;
        }
        return !ai.isSystemApp() && !ai.isSignedWithPlatformKey();
    }

    private int calculateFulfilledPolicies(PackageInfo targetPackage, PackageInfo overlayPackage, int userId) {
        ApplicationInfo ai = overlayPackage.applicationInfo;
        int fulfilledPolicies = 1;
        if (this.mPackageManager.signaturesMatching(targetPackage.packageName, overlayPackage.packageName, userId)) {
            fulfilledPolicies |= 0x10;
        }
        if (ai.isVendor()) {
            return fulfilledPolicies | 4;
        }
        if (ai.isProduct()) {
            return fulfilledPolicies | 8;
        }
        if (ai.isOdm()) {
            return fulfilledPolicies | 0x20;
        }
        if (ai.isOem()) {
            return fulfilledPolicies | 0x40;
        }
        if (ai.isProductServices()) {
            return fulfilledPolicies;
        }
        if (ai.isSystemApp()) {
            return fulfilledPolicies | 2;
        }
        return fulfilledPolicies;
    }

    static {
        boolean isQOrLater;
        String value = SystemProperties.get("ro.vndk.version", "29");
        try {
            isQOrLater = Integer.parseInt(value) >= 29;
        }
        catch (NumberFormatException e) {
            isQOrLater = true;
        }
        VENDOR_IS_Q_OR_LATER = isQOrLater;
    }
}

