/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.om.IOverlayManager;
import android.content.om.OverlayInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManagerInternal;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ShellCallback;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.SparseArray;
import com.android.server.FgThread;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.om.DumpState;
import com.android.server.om.IdmapManager;
import com.android.server.om.OverlayManagerServiceImpl;
import com.android.server.om.OverlayManagerSettings;
import com.android.server.om.OverlayManagerShellCommand;
import com.android.server.pm.Installer;
import com.android.server.pm.UserManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParserException;

public final class OverlayManagerService
extends SystemService {
    static final String TAG = "OverlayManager";
    static final boolean DEBUG = false;
    private static final String DEFAULT_OVERLAYS_PROP = "ro.boot.vendor.overlay.theme";
    private final Object mLock = new Object();
    private final AtomicFile mSettingsFile;
    private final PackageManagerHelper mPackageManager;
    private final UserManagerService mUserManager;
    private final OverlayManagerSettings mSettings;
    private final OverlayManagerServiceImpl mImpl;
    private final AtomicBoolean mPersistSettingsScheduled = new AtomicBoolean(false);
    private final IBinder mService = new IOverlayManager.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<String, List<OverlayInfo>> getAllOverlays(int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#getAllOverlays " + userId);
                userId = this.handleIncomingUser(userId, "getAllOverlays");
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    Map<String, List<OverlayInfo>> map = OverlayManagerService.this.mImpl.getOverlaysForUser(userId);
                    return map;
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#getOverlayInfosForTarget " + targetPackageName);
                userId = this.handleIncomingUser(userId, "getOverlayInfosForTarget");
                if (targetPackageName == null) {
                    List<OverlayInfo> list = Collections.emptyList();
                    return list;
                }
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    List<OverlayInfo> list = OverlayManagerService.this.mImpl.getOverlayInfosForTarget(targetPackageName, userId);
                    return list;
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OverlayInfo getOverlayInfo(String packageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#getOverlayInfo " + packageName);
                userId = this.handleIncomingUser(userId, "getOverlayInfo");
                if (packageName == null) {
                    OverlayInfo overlayInfo = null;
                    return overlayInfo;
                }
                Object object = OverlayManagerService.this.mLock;
                synchronized (object) {
                    OverlayInfo overlayInfo = OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
                    return overlayInfo;
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setEnabled(String packageName, boolean enable, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setEnabled " + packageName + " " + enable);
                this.enforceChangeOverlayPackagesPermission("setEnabled");
                userId = this.handleIncomingUser(userId, "setEnabled");
                if (packageName == null) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setEnabled(packageName, enable, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setEnabledExclusive(String packageName, boolean enable, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setEnabledExclusive " + packageName + " " + enable);
                this.enforceChangeOverlayPackagesPermission("setEnabledExclusive");
                userId = this.handleIncomingUser(userId, "setEnabledExclusive");
                if (packageName == null || !enable) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setEnabledExclusive(packageName, false, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setEnabledExclusiveInCategory(String packageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setEnabledExclusiveInCategory " + packageName);
                this.enforceChangeOverlayPackagesPermission("setEnabledExclusiveInCategory");
                userId = this.handleIncomingUser(userId, "setEnabledExclusiveInCategory");
                if (packageName == null) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setEnabledExclusive(packageName, true, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setPriority(String packageName, String parentPackageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setPriority " + packageName + " " + parentPackageName);
                this.enforceChangeOverlayPackagesPermission("setPriority");
                userId = this.handleIncomingUser(userId, "setPriority");
                if (packageName == null || parentPackageName == null) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setPriority(packageName, parentPackageName, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setHighestPriority(String packageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setHighestPriority " + packageName);
                this.enforceChangeOverlayPackagesPermission("setHighestPriority");
                userId = this.handleIncomingUser(userId, "setHighestPriority");
                if (packageName == null) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setHighestPriority(packageName, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean setLowestPriority(String packageName, int userId) throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#setLowestPriority " + packageName);
                this.enforceChangeOverlayPackagesPermission("setLowestPriority");
                userId = this.handleIncomingUser(userId, "setLowestPriority");
                if (packageName == null) {
                    boolean bl = false;
                    return bl;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        boolean bl = OverlayManagerService.this.mImpl.setLowestPriority(packageName, userId);
                        return bl;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public String[] getDefaultOverlayPackages() throws RemoteException {
            try {
                Trace.traceBegin(0x4000000L, "OMS#getDefaultOverlayPackages");
                OverlayManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.MODIFY_THEME_OVERLAY", null);
                long ident = Binder.clearCallingIdentity();
                try {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        String[] stringArray = OverlayManagerService.this.mImpl.getDefaultOverlayPackages();
                        return stringArray;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new OverlayManagerShellCommand(this).exec(this, in, out, err, args, callback, resultReceiver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            String opt;
            DumpState dumpState = new DumpState();
            dumpState.setUserId(UserHandle.getUserId(Binder.getCallingUid()));
            int opti = 0;
            while (opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-') {
                ++opti;
                if ("-h".equals(opt)) {
                    pw.println("dump [-h] [--verbose] [--user USER_ID] [[FIELD] PACKAGE]");
                    pw.println("  Print debugging information about the overlay manager.");
                    pw.println("  With optional parameter PACKAGE, limit output to the specified");
                    pw.println("  package. With optional parameter FIELD, limit output to");
                    pw.println("  the value of that SettingsItem field. Field names are");
                    pw.println("  case insensitive and out.println the m prefix can be omitted,");
                    pw.println("  so the following are equivalent: mState, mstate, State, state.");
                    return;
                }
                if ("--user".equals(opt)) {
                    if (++opti >= args.length) {
                        pw.println("Error: user missing argument");
                        return;
                    }
                    try {
                        dumpState.setUserId(Integer.parseInt(args[opti]));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        pw.println("Error: user argument is not a number: " + args[opti]);
                        return;
                    }
                }
                if ("--verbose".equals(opt)) {
                    dumpState.setVerbose(true);
                    continue;
                }
                pw.println("Unknown argument: " + opt + "; use -h for help");
            }
            if (opti < args.length) {
                String arg = args[opti];
                ++opti;
                switch (arg) {
                    case "packagename": 
                    case "userid": 
                    case "targetpackagename": 
                    case "targetoverlayablename": 
                    case "basecodepath": 
                    case "state": 
                    case "isenabled": 
                    case "isstatic": 
                    case "priority": 
                    case "category": {
                        dumpState.setField(arg);
                        break;
                    }
                    default: {
                        dumpState.setPackageName(arg);
                    }
                }
            }
            if (dumpState.getPackageName() == null && opti < args.length) {
                dumpState.setPackageName(args[opti]);
                ++opti;
            }
            this.enforceDumpPermission("dump");
            Object object = OverlayManagerService.this.mLock;
            synchronized (object) {
                OverlayManagerService.this.mImpl.dump(pw, dumpState);
                if (dumpState.getPackageName() == null) {
                    OverlayManagerService.this.mPackageManager.dump(pw, dumpState);
                }
            }
        }

        private int handleIncomingUser(int userId, String message) {
            return ActivityManager.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, message, null);
        }

        private void enforceChangeOverlayPackagesPermission(String message) {
            OverlayManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.CHANGE_OVERLAY_PACKAGES", message);
        }

        private void enforceDumpPermission(String message) {
            OverlayManagerService.this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", message);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OverlayManagerService(Context context, Installer installer) {
        super(context);
        try {
            Trace.traceBegin(0x4000000L, "OMS#OverlayManagerService");
            this.mSettingsFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "overlays.xml"), "overlays");
            this.mPackageManager = new PackageManagerHelper();
            this.mUserManager = UserManagerService.getInstance();
            IdmapManager im = new IdmapManager(installer, this.mPackageManager);
            this.mSettings = new OverlayManagerSettings();
            this.mImpl = new OverlayManagerServiceImpl(this.mPackageManager, im, this.mSettings, OverlayManagerService.getDefaultOverlayPackages(), new OverlayChangeListener());
            IntentFilter packageFilter = new IntentFilter();
            packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
            packageFilter.addAction("android.intent.action.PACKAGE_CHANGED");
            packageFilter.addAction("android.intent.action.PACKAGE_REMOVED");
            packageFilter.addDataScheme("package");
            this.getContext().registerReceiverAsUser(new PackageReceiver(), UserHandle.ALL, packageFilter, null, null);
            IntentFilter userFilter = new IntentFilter();
            userFilter.addAction("android.intent.action.USER_ADDED");
            userFilter.addAction("android.intent.action.USER_REMOVED");
            this.getContext().registerReceiverAsUser(new UserReceiver(), UserHandle.ALL, userFilter, null, null);
            this.restoreSettings();
            this.initIfNeeded();
            this.onSwitchUser(0);
            this.publishBinderService("overlay", this.mService);
            this.publishLocalService(OverlayManagerService.class, this);
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
    }

    @Override
    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        UserManager um = this.getContext().getSystemService(UserManager.class);
        List<UserInfo> users = um.getUsers(true);
        Object object = this.mLock;
        synchronized (object) {
            int userCount = users.size();
            for (int i = 0; i < userCount; ++i) {
                UserInfo userInfo = users.get(i);
                if (userInfo.supportsSwitchTo() || userInfo.id == 0) continue;
                ArrayList<String> targets = this.mImpl.updateOverlaysForUser(users.get((int)i).id);
                this.updateOverlayPaths(users.get((int)i).id, targets);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int newUserId) {
        try {
            Trace.traceBegin(0x4000000L, "OMS#onSwitchUser " + newUserId);
            Object object = this.mLock;
            synchronized (object) {
                ArrayList<String> targets = this.mImpl.updateOverlaysForUser(newUserId);
                this.updateAssets(newUserId, targets);
            }
            this.schedulePersistSettings();
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
    }

    private static String[] getDefaultOverlayPackages() {
        String str = SystemProperties.get(DEFAULT_OVERLAYS_PROP);
        if (TextUtils.isEmpty(str)) {
            return EmptyArray.STRING;
        }
        ArraySet<String> defaultPackages = new ArraySet<String>();
        for (String packageName : str.split(";")) {
            if (TextUtils.isEmpty(packageName)) continue;
            defaultPackages.add(packageName);
        }
        return defaultPackages.toArray(new String[defaultPackages.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOverlayPaths(int userId, List<String> targetPackageNames) {
        try {
            Trace.traceBegin(0x4000000L, "OMS#updateOverlayPaths " + targetPackageNames);
            PackageManagerInternal pm = LocalServices.getService(PackageManagerInternal.class);
            boolean updateFrameworkRes = targetPackageNames.contains("android");
            if (updateFrameworkRes) {
                targetPackageNames = pm.getTargetPackageNames(userId);
            }
            ArrayMap pendingChanges = new ArrayMap(targetPackageNames.size());
            Object object = this.mLock;
            synchronized (object) {
                List<String> frameworkOverlays = this.mImpl.getEnabledOverlayPackageNames("android", userId);
                int n = targetPackageNames.size();
                for (int i = 0; i < n; ++i) {
                    String targetPackageName = targetPackageNames.get(i);
                    ArrayList<String> list = new ArrayList<String>();
                    if (!"android".equals(targetPackageName)) {
                        list.addAll(frameworkOverlays);
                    }
                    list.addAll(this.mImpl.getEnabledOverlayPackageNames(targetPackageName, userId));
                    pendingChanges.put(targetPackageName, list);
                }
            }
            int n = targetPackageNames.size();
            for (int i = 0; i < n; ++i) {
                String targetPackageName = targetPackageNames.get(i);
                if (pm.setEnabledOverlayPackages(userId, targetPackageName, (List)pendingChanges.get(targetPackageName))) continue;
                Slog.e(TAG, String.format("Failed to change enabled overlays for %s user %d", targetPackageName, userId));
            }
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
    }

    private void updateAssets(int userId, String targetPackageName) {
        this.updateAssets(userId, Collections.singletonList(targetPackageName));
    }

    private void updateAssets(int userId, List<String> targetPackageNames) {
        this.updateOverlayPaths(userId, targetPackageNames);
        IActivityManager am = ActivityManager.getService();
        try {
            am.scheduleApplicationInfoChanged(targetPackageNames, userId);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void schedulePersistSettings() {
        if (this.mPersistSettingsScheduled.getAndSet(true)) {
            return;
        }
        IoThread.getHandler().post(() -> {
            this.mPersistSettingsScheduled.set(false);
            Object object = this.mLock;
            synchronized (object) {
                FileOutputStream stream = null;
                try {
                    stream = this.mSettingsFile.startWrite();
                    this.mSettings.persist(stream);
                    this.mSettingsFile.finishWrite(stream);
                }
                catch (IOException | XmlPullParserException e) {
                    this.mSettingsFile.failWrite(stream);
                    Slog.e(TAG, "failed to persist overlay state", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSettings() {
        try {
            Trace.traceBegin(0x4000000L, "OMS#restoreSettings");
            Object object = this.mLock;
            synchronized (object) {
                block24: {
                    if (this.mSettingsFile.getBaseFile().exists()) break block24;
                    return;
                }
                try (FileInputStream stream = this.mSettingsFile.openRead();){
                    this.mSettings.restore(stream);
                    List<UserInfo> liveUsers = this.mUserManager.getUsers(true);
                    int[] liveUserIds = new int[liveUsers.size()];
                    for (int i = 0; i < liveUsers.size(); ++i) {
                        liveUserIds[i] = liveUsers.get(i).getUserHandle().getIdentifier();
                    }
                    Arrays.sort(liveUserIds);
                    for (int userId : this.mSettings.getUsers()) {
                        if (Arrays.binarySearch(liveUserIds, userId) >= 0) continue;
                        this.mSettings.removeUser(userId);
                    }
                }
                catch (IOException | XmlPullParserException e) {
                    Slog.e(TAG, "failed to restore overlay state", e);
                }
            }
        }
        finally {
            Trace.traceEnd(0x4000000L);
        }
    }

    private static final class PackageManagerHelper
    implements OverlayManagerServiceImpl.PackageManagerHelper {
        private final IPackageManager mPackageManager;
        private final PackageManagerInternal mPackageManagerInternal;
        private final SparseArray<HashMap<String, PackageInfo>> mCache = new SparseArray();
        private static final String TAB1 = "    ";
        private static final String TAB2 = "        ";

        PackageManagerHelper() {
            this.mPackageManager = AppGlobals.getPackageManager();
            this.mPackageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        }

        public PackageInfo getPackageInfo(String packageName, int userId, boolean useCache) {
            PackageInfo cachedPi;
            if (useCache && (cachedPi = this.getCachedPackageInfo(packageName, userId)) != null) {
                return cachedPi;
            }
            try {
                PackageInfo pi = this.mPackageManager.getPackageInfo(packageName, 0, userId);
                if (useCache && pi != null) {
                    this.cachePackageInfo(packageName, userId, pi);
                }
                return pi;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }

        @Override
        public PackageInfo getPackageInfo(String packageName, int userId) {
            return this.getPackageInfo(packageName, userId, true);
        }

        @Override
        public boolean signaturesMatching(String packageName1, String packageName2, int userId) {
            try {
                return this.mPackageManager.checkSignatures(packageName1, packageName2) == 0;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        @Override
        public List<PackageInfo> getOverlayPackages(int userId) {
            return this.mPackageManagerInternal.getOverlayPackages(userId);
        }

        public PackageInfo getCachedPackageInfo(String packageName, int userId) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            return map == null ? null : map.get(packageName);
        }

        public void cachePackageInfo(String packageName, int userId, PackageInfo pi) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            if (map == null) {
                map = new HashMap();
                this.mCache.put(userId, map);
            }
            map.put(packageName, pi);
        }

        public void forgetPackageInfo(String packageName, int userId) {
            HashMap<String, PackageInfo> map = this.mCache.get(userId);
            if (map == null) {
                return;
            }
            map.remove(packageName);
            if (map.isEmpty()) {
                this.mCache.delete(userId);
            }
        }

        public void forgetAllPackageInfos(int userId) {
            this.mCache.delete(userId);
        }

        public void dump(PrintWriter pw, DumpState dumpState) {
            pw.println("PackageInfo cache");
            if (!dumpState.isVerbose()) {
                int count = 0;
                int n = this.mCache.size();
                for (int i = 0; i < n; ++i) {
                    int userId = this.mCache.keyAt(i);
                    count += this.mCache.get(userId).size();
                }
                pw.println(TAB1 + count + " package(s)");
                return;
            }
            if (this.mCache.size() == 0) {
                pw.println("    <empty>");
                return;
            }
            int n = this.mCache.size();
            for (int i = 0; i < n; ++i) {
                int userId = this.mCache.keyAt(i);
                pw.println("    User " + userId);
                HashMap<String, PackageInfo> map = this.mCache.get(userId);
                for (Map.Entry<String, PackageInfo> entry : map.entrySet()) {
                    pw.println(TAB2 + entry.getKey() + ": " + entry.getValue());
                }
            }
        }
    }

    private final class OverlayChangeListener
    implements OverlayManagerServiceImpl.OverlayChangeListener {
        private OverlayChangeListener() {
        }

        @Override
        public void onOverlaysChanged(String targetPackageName, int userId) {
            OverlayManagerService.this.schedulePersistSettings();
            FgThread.getHandler().post(() -> {
                OverlayManagerService.this.updateAssets(userId, targetPackageName);
                Intent intent = new Intent("android.intent.action.OVERLAY_CHANGED", Uri.fromParts("package", targetPackageName, null));
                intent.setFlags(0x4000000);
                try {
                    ActivityManager.getService().broadcastIntent(null, intent, null, null, 0, null, null, null, -1, null, false, false, userId);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            });
        }
    }

    private final class UserReceiver
    extends BroadcastReceiver {
        private UserReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            switch (intent.getAction()) {
                case "android.intent.action.USER_ADDED": {
                    if (userId == -10000) break;
                    try {
                        ArrayList<String> targets;
                        Trace.traceBegin(0x4000000L, "OMS ACTION_USER_ADDED");
                        Object object = OverlayManagerService.this.mLock;
                        synchronized (object) {
                            targets = OverlayManagerService.this.mImpl.updateOverlaysForUser(userId);
                        }
                        OverlayManagerService.this.updateOverlayPaths(userId, targets);
                        break;
                    }
                    finally {
                        Trace.traceEnd(0x4000000L);
                    }
                }
                case "android.intent.action.USER_REMOVED": {
                    if (userId == -10000) break;
                    try {
                        Trace.traceBegin(0x4000000L, "OMS ACTION_USER_REMOVED");
                        Object object = OverlayManagerService.this.mLock;
                        synchronized (object) {
                            OverlayManagerService.this.mImpl.onUserRemoved(userId);
                            OverlayManagerService.this.mPackageManager.forgetAllPackageInfos(userId);
                            break;
                        }
                    }
                    finally {
                        Trace.traceEnd(0x4000000L);
                    }
                }
            }
        }
    }

    private final class PackageReceiver
    extends BroadcastReceiver {
        private PackageReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                Slog.e(OverlayManagerService.TAG, "Cannot handle package broadcast with null action");
                return;
            }
            Uri data = intent.getData();
            if (data == null) {
                Slog.e(OverlayManagerService.TAG, "Cannot handle package broadcast with null data");
                return;
            }
            String packageName = data.getSchemeSpecificPart();
            boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
            int extraUid = intent.getIntExtra("android.intent.extra.UID", -10000);
            int[] userIds = extraUid == -10000 ? OverlayManagerService.this.mUserManager.getUserIds() : new int[]{UserHandle.getUserId(extraUid)};
            switch (action) {
                case "android.intent.action.PACKAGE_ADDED": {
                    if (replacing) {
                        this.onPackageReplaced(packageName, userIds);
                        break;
                    }
                    this.onPackageAdded(packageName, userIds);
                    break;
                }
                case "android.intent.action.PACKAGE_CHANGED": {
                    this.onPackageChanged(packageName, userIds);
                    break;
                }
                case "android.intent.action.PACKAGE_REMOVED": {
                    if (replacing) {
                        this.onPackageReplacing(packageName, userIds);
                        break;
                    }
                    this.onPackageRemoved(packageName, userIds);
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageAdded(String packageName, int[] userIds) {
            try {
                Trace.traceBegin(0x4000000L, "OMS#onPackageAdded " + packageName);
                for (int userId : userIds) {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                        if (pi != null && !pi.applicationInfo.isInstantApp()) {
                            OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                            if (pi.isOverlayPackage()) {
                                OverlayManagerService.this.mImpl.onOverlayPackageAdded(packageName, userId);
                            } else {
                                OverlayManagerService.this.mImpl.onTargetPackageAdded(packageName, userId);
                            }
                        }
                    }
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageChanged(String packageName, int[] userIds) {
            try {
                Trace.traceBegin(0x4000000L, "OMS#onPackageChanged " + packageName);
                for (int userId : userIds) {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                        if (pi != null && pi.applicationInfo.isInstantApp()) {
                            OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                            if (pi.isOverlayPackage()) {
                                OverlayManagerService.this.mImpl.onOverlayPackageChanged(packageName, userId);
                            } else {
                                OverlayManagerService.this.mImpl.onTargetPackageChanged(packageName, userId);
                            }
                        }
                    }
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageReplacing(String packageName, int[] userIds) {
            try {
                Trace.traceBegin(0x4000000L, "OMS#onPackageReplacing " + packageName);
                for (int userId : userIds) {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        OverlayManagerService.this.mPackageManager.forgetPackageInfo(packageName, userId);
                        OverlayInfo oi = OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
                        if (oi != null) {
                            OverlayManagerService.this.mImpl.onOverlayPackageReplacing(packageName, userId);
                        }
                    }
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageReplaced(String packageName, int[] userIds) {
            try {
                Trace.traceBegin(0x4000000L, "OMS#onPackageReplaced " + packageName);
                for (int userId : userIds) {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        PackageInfo pi = OverlayManagerService.this.mPackageManager.getPackageInfo(packageName, userId, false);
                        if (pi != null && !pi.applicationInfo.isInstantApp()) {
                            OverlayManagerService.this.mPackageManager.cachePackageInfo(packageName, userId, pi);
                            if (pi.isOverlayPackage()) {
                                OverlayManagerService.this.mImpl.onOverlayPackageReplaced(packageName, userId);
                            } else {
                                OverlayManagerService.this.mImpl.onTargetPackageReplaced(packageName, userId);
                            }
                        }
                    }
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onPackageRemoved(String packageName, int[] userIds) {
            try {
                Trace.traceBegin(0x4000000L, "OMS#onPackageRemoved " + packageName);
                for (int userId : userIds) {
                    Object object = OverlayManagerService.this.mLock;
                    synchronized (object) {
                        OverlayManagerService.this.mPackageManager.forgetPackageInfo(packageName, userId);
                        OverlayInfo oi = OverlayManagerService.this.mImpl.getOverlayInfo(packageName, userId);
                        if (oi != null) {
                            OverlayManagerService.this.mImpl.onOverlayPackageRemoved(packageName, userId);
                        } else {
                            OverlayManagerService.this.mImpl.onTargetPackageRemoved(packageName, userId);
                        }
                    }
                }
            }
            finally {
                Trace.traceEnd(0x4000000L);
            }
        }
    }
}

