/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.om;

import android.content.om.OverlayInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.server.om.DumpState;
import com.android.server.om.IdmapManager;
import com.android.server.om.OverlayManagerSettings;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class OverlayManagerServiceImpl {
    @Deprecated
    private static final int FLAG_TARGET_IS_BEING_REPLACED = 1;
    private static final int FLAG_OVERLAY_IS_BEING_REPLACED = 2;
    private final PackageManagerHelper mPackageManager;
    private final IdmapManager mIdmapManager;
    private final OverlayManagerSettings mSettings;
    private final String[] mDefaultOverlays;
    private final OverlayChangeListener mListener;

    private static boolean mustReinitializeOverlay(PackageInfo theTruth, OverlayInfo oldSettings) {
        if (oldSettings == null) {
            return true;
        }
        if (!Objects.equals(theTruth.overlayTarget, oldSettings.targetPackageName)) {
            return true;
        }
        if (!Objects.equals(theTruth.targetOverlayableName, oldSettings.targetOverlayableName)) {
            return true;
        }
        if (theTruth.isStaticOverlayPackage() != oldSettings.isStatic) {
            return true;
        }
        return theTruth.isStaticOverlayPackage() && theTruth.overlayPriority != oldSettings.priority;
    }

    OverlayManagerServiceImpl(PackageManagerHelper packageManager, IdmapManager idmapManager, OverlayManagerSettings settings, String[] defaultOverlays, OverlayChangeListener listener) {
        this.mPackageManager = packageManager;
        this.mIdmapManager = idmapManager;
        this.mSettings = settings;
        this.mDefaultOverlays = defaultOverlays;
        this.mListener = listener;
    }

    ArrayList<String> updateOverlaysForUser(int newUserId) {
        OverlayInfo oi;
        int i;
        OverlayInfo oi2;
        ArraySet<String> packagesToUpdateAssets = new ArraySet<String>();
        ArrayMap<String, List<OverlayInfo>> tmp = this.mSettings.getOverlaysForUser(newUserId);
        int tmpSize = tmp.size();
        ArrayMap<String, OverlayInfo> storedOverlayInfos = new ArrayMap<String, OverlayInfo>(tmpSize);
        for (int i2 = 0; i2 < tmpSize; ++i2) {
            List<OverlayInfo> chunk = tmp.valueAt(i2);
            int chunkSize = chunk.size();
            for (int j = 0; j < chunkSize; ++j) {
                oi2 = chunk.get(j);
                storedOverlayInfos.put(oi2.packageName, oi2);
            }
        }
        List<PackageInfo> overlayPackages = this.mPackageManager.getOverlayPackages(newUserId);
        int overlayPackagesSize = overlayPackages.size();
        for (int i3 = 0; i3 < overlayPackagesSize; ++i3) {
            PackageInfo overlayPackage = overlayPackages.get(i3);
            if (OverlayManagerServiceImpl.mustReinitializeOverlay(overlayPackage, oi2 = (OverlayInfo)storedOverlayInfos.get(overlayPackage.packageName))) {
                if (oi2 != null) {
                    packagesToUpdateAssets.add(oi2.targetPackageName);
                }
                this.mSettings.init(overlayPackage.packageName, newUserId, overlayPackage.overlayTarget, overlayPackage.targetOverlayableName, overlayPackage.applicationInfo.getBaseCodePath(), overlayPackage.isStaticOverlayPackage(), overlayPackage.overlayPriority, overlayPackage.overlayCategory);
            }
            storedOverlayInfos.remove(overlayPackage.packageName);
        }
        int storedOverlayInfosSize = storedOverlayInfos.size();
        for (i = 0; i < storedOverlayInfosSize; ++i) {
            oi2 = (OverlayInfo)storedOverlayInfos.valueAt(i);
            this.mSettings.remove(oi2.packageName, oi2.userId);
            this.removeIdmapIfPossible(oi2);
            packagesToUpdateAssets.add(oi2.targetPackageName);
        }
        for (i = 0; i < overlayPackagesSize; ++i) {
            PackageInfo overlayPackage = overlayPackages.get(i);
            try {
                this.updateState(overlayPackage.overlayTarget, overlayPackage.packageName, newUserId, 0);
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                this.mSettings.remove(overlayPackage.packageName, newUserId);
            }
            packagesToUpdateAssets.add(overlayPackage.overlayTarget);
        }
        Iterator iter = packagesToUpdateAssets.iterator();
        while (iter.hasNext()) {
            String targetPackageName = (String)iter.next();
            if (this.mPackageManager.getPackageInfo(targetPackageName, newUserId) != null) continue;
            iter.remove();
        }
        ArraySet<String> enabledCategories = new ArraySet<String>();
        ArrayMap<String, List<OverlayInfo>> userOverlays = this.mSettings.getOverlaysForUser(newUserId);
        int userOverlayTargetCount = userOverlays.size();
        for (int i4 = 0; i4 < userOverlayTargetCount; ++i4) {
            List<OverlayInfo> overlayList = userOverlays.valueAt(i4);
            int overlayCount = overlayList != null ? overlayList.size() : 0;
            for (int j = 0; j < overlayCount; ++j) {
                oi = overlayList.get(j);
                if (!oi.isEnabled()) continue;
                enabledCategories.add(oi.category);
            }
        }
        for (String defaultOverlay : this.mDefaultOverlays) {
            try {
                oi = this.mSettings.getOverlayInfo(defaultOverlay, newUserId);
                if (enabledCategories.contains(oi.category)) continue;
                Slog.w("OverlayManager", "Enabling default overlay '" + defaultOverlay + "' for target '" + oi.targetPackageName + "' in category '" + oi.category + "' for user " + newUserId);
                this.mSettings.setEnabled(oi.packageName, newUserId, true);
                if (!this.updateState(oi.targetPackageName, oi.packageName, newUserId, 0)) continue;
                packagesToUpdateAssets.add(oi.targetPackageName);
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "Failed to set default overlay '" + defaultOverlay + "' for user " + newUserId, e);
            }
        }
        return new ArrayList<String>(packagesToUpdateAssets);
    }

    void onUserRemoved(int userId) {
        this.mSettings.removeUser(userId);
    }

    void onTargetPackageAdded(String packageName, int userId) {
        this.updateAndRefreshOverlaysForTarget(packageName, userId, 0);
    }

    void onTargetPackageChanged(String packageName, int userId) {
        this.updateAndRefreshOverlaysForTarget(packageName, userId, 0);
    }

    void onTargetPackageReplacing(String packageName, int userId) {
        this.updateAndRefreshOverlaysForTarget(packageName, userId, 0);
    }

    void onTargetPackageReplaced(String packageName, int userId) {
        this.updateAndRefreshOverlaysForTarget(packageName, userId, 0);
    }

    void onTargetPackageRemoved(String packageName, int userId) {
        this.updateAndRefreshOverlaysForTarget(packageName, userId, 0);
    }

    private void updateAndRefreshOverlaysForTarget(String targetPackageName, int userId, int flags) {
        List<OverlayInfo> targetOverlays = this.mSettings.getOverlaysForTarget(targetPackageName, userId);
        boolean modified = false;
        for (OverlayInfo overlayInfo : targetOverlays) {
            PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(overlayInfo.packageName, userId);
            if (overlayPackage == null) {
                modified |= this.mSettings.remove(overlayInfo.packageName, overlayInfo.userId);
                this.removeIdmapIfPossible(overlayInfo);
                continue;
            }
            try {
                modified |= this.updateState(targetPackageName, overlayInfo.packageName, userId, flags);
            }
            catch (OverlayManagerSettings.BadKeyException e) {
                Slog.e("OverlayManager", "failed to update settings", e);
                modified |= this.mSettings.remove(overlayInfo.packageName, userId);
            }
        }
        if (!modified) {
            Object[] resourceDirs;
            ArrayList<String> enabledOverlayPaths = new ArrayList<String>(targetOverlays.size());
            for (OverlayInfo oi : this.mSettings.getOverlaysForTarget("android", userId)) {
                if (!oi.isEnabled()) continue;
                enabledOverlayPaths.add(oi.baseCodePath);
            }
            for (OverlayInfo oi : targetOverlays) {
                if (!oi.isEnabled()) continue;
                enabledOverlayPaths.add(oi.baseCodePath);
            }
            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(targetPackageName, userId);
            ApplicationInfo appInfo = packageInfo == null ? null : packageInfo.applicationInfo;
            Object[] objectArray = resourceDirs = appInfo == null ? null : appInfo.resourceDirs;
            if (ArrayUtils.size(resourceDirs) != enabledOverlayPaths.size()) {
                modified = true;
            } else if (resourceDirs != null) {
                for (int index = 0; index < resourceDirs.length; ++index) {
                    if (((String)resourceDirs[index]).equals(enabledOverlayPaths.get(index))) continue;
                    modified = true;
                    break;
                }
            }
        }
        if (modified) {
            this.mListener.onOverlaysChanged(targetPackageName, userId);
        }
    }

    void onOverlayPackageAdded(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            Slog.w("OverlayManager", "overlay package " + packageName + " was added, but couldn't be found");
            this.onOverlayPackageRemoved(packageName, userId);
            return;
        }
        this.mSettings.init(packageName, userId, overlayPackage.overlayTarget, overlayPackage.targetOverlayableName, overlayPackage.applicationInfo.getBaseCodePath(), overlayPackage.isStaticOverlayPackage(), overlayPackage.overlayPriority, overlayPackage.overlayCategory);
        try {
            if (this.updateState(overlayPackage.overlayTarget, packageName, userId, 0)) {
                this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
            this.mSettings.remove(packageName, userId);
        }
    }

    void onOverlayPackageChanged(String packageName, int userId) {
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            if (this.updateState(oi.targetPackageName, packageName, userId, 0)) {
                this.mListener.onOverlaysChanged(oi.targetPackageName, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
        }
    }

    void onOverlayPackageReplacing(String packageName, int userId) {
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            if (this.updateState(oi.targetPackageName, packageName, userId, 2)) {
                this.removeIdmapIfPossible(oi);
                this.mListener.onOverlaysChanged(oi.targetPackageName, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
        }
    }

    void onOverlayPackageReplaced(String packageName, int userId) {
        PackageInfo pkg = this.mPackageManager.getPackageInfo(packageName, userId);
        if (pkg == null) {
            Slog.w("OverlayManager", "overlay package " + packageName + " was replaced, but couldn't be found");
            this.onOverlayPackageRemoved(packageName, userId);
            return;
        }
        try {
            OverlayInfo oldOi = this.mSettings.getOverlayInfo(packageName, userId);
            if (OverlayManagerServiceImpl.mustReinitializeOverlay(pkg, oldOi)) {
                if (oldOi != null && !oldOi.targetPackageName.equals(pkg.overlayTarget)) {
                    this.mListener.onOverlaysChanged(pkg.overlayTarget, userId);
                }
                this.mSettings.init(packageName, userId, pkg.overlayTarget, pkg.targetOverlayableName, pkg.applicationInfo.getBaseCodePath(), pkg.isStaticOverlayPackage(), pkg.overlayPriority, pkg.overlayCategory);
            }
            if (this.updateState(pkg.overlayTarget, packageName, userId, 0)) {
                this.mListener.onOverlaysChanged(pkg.overlayTarget, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to update settings", e);
        }
    }

    void onOverlayPackageRemoved(String packageName, int userId) {
        try {
            OverlayInfo overlayInfo = this.mSettings.getOverlayInfo(packageName, userId);
            if (this.mSettings.remove(packageName, userId)) {
                this.removeIdmapIfPossible(overlayInfo);
                this.mListener.onOverlaysChanged(overlayInfo.targetPackageName, userId);
            }
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            Slog.e("OverlayManager", "failed to remove overlay", e);
        }
    }

    OverlayInfo getOverlayInfo(String packageName, int userId) {
        try {
            return this.mSettings.getOverlayInfo(packageName, userId);
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return null;
        }
    }

    List<OverlayInfo> getOverlayInfosForTarget(String targetPackageName, int userId) {
        return this.mSettings.getOverlaysForTarget(targetPackageName, userId);
    }

    Map<String, List<OverlayInfo>> getOverlaysForUser(int userId) {
        return this.mSettings.getOverlaysForUser(userId);
    }

    boolean setEnabled(String packageName, boolean enable, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (overlayPackage.isStaticOverlayPackage()) {
            return false;
        }
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            boolean modified = this.mSettings.setEnabled(packageName, userId, enable);
            if (modified |= this.updateState(oi.targetPackageName, oi.packageName, userId, 0)) {
                this.mListener.onOverlaysChanged(oi.targetPackageName, userId);
            }
            return true;
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return false;
        }
    }

    boolean setEnabledExclusive(String packageName, boolean withinCategory, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        try {
            OverlayInfo oi = this.mSettings.getOverlayInfo(packageName, userId);
            String targetPackageName = oi.targetPackageName;
            List<OverlayInfo> allOverlays = this.getOverlayInfosForTarget(targetPackageName, userId);
            boolean modified = false;
            allOverlays.remove(oi);
            for (int i = 0; i < allOverlays.size(); ++i) {
                String disabledOverlayPackageName = allOverlays.get((int)i).packageName;
                PackageInfo disabledOverlayPackageInfo = this.mPackageManager.getPackageInfo(disabledOverlayPackageName, userId);
                if (disabledOverlayPackageInfo == null) {
                    modified |= this.mSettings.remove(disabledOverlayPackageName, userId);
                    continue;
                }
                if (disabledOverlayPackageInfo.isStaticOverlayPackage() || withinCategory && !Objects.equals(disabledOverlayPackageInfo.overlayCategory, oi.category)) continue;
                modified |= this.mSettings.setEnabled(disabledOverlayPackageName, userId, false);
                modified |= this.updateState(targetPackageName, disabledOverlayPackageName, userId, 0);
            }
            modified |= this.mSettings.setEnabled(packageName, userId, true);
            if (modified |= this.updateState(targetPackageName, packageName, userId, 0)) {
                this.mListener.onOverlaysChanged(targetPackageName, userId);
            }
            return true;
        }
        catch (OverlayManagerSettings.BadKeyException e) {
            return false;
        }
    }

    private boolean isPackageUpdatableOverlay(String packageName, int userId) {
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        return overlayPackage != null && !overlayPackage.isStaticOverlayPackage();
    }

    boolean setPriority(String packageName, String newParentPackageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setPriority(packageName, newParentPackageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    boolean setHighestPriority(String packageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setHighestPriority(packageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    boolean setLowestPriority(String packageName, int userId) {
        if (!this.isPackageUpdatableOverlay(packageName, userId)) {
            return false;
        }
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(packageName, userId);
        if (overlayPackage == null) {
            return false;
        }
        if (this.mSettings.setLowestPriority(packageName, userId)) {
            this.mListener.onOverlaysChanged(overlayPackage.overlayTarget, userId);
        }
        return true;
    }

    void dump(PrintWriter pw, DumpState dumpState) {
        this.mSettings.dump(pw, dumpState);
        if (dumpState.getPackageName() == null) {
            pw.println("Default overlays: " + TextUtils.join((CharSequence)";", this.mDefaultOverlays));
        }
    }

    String[] getDefaultOverlayPackages() {
        return this.mDefaultOverlays;
    }

    List<String> getEnabledOverlayPackageNames(String targetPackageName, int userId) {
        List<OverlayInfo> overlays = this.mSettings.getOverlaysForTarget(targetPackageName, userId);
        ArrayList<String> paths = new ArrayList<String>(overlays.size());
        int n = overlays.size();
        for (int i = 0; i < n; ++i) {
            OverlayInfo oi = overlays.get(i);
            if (!oi.isEnabled()) continue;
            paths.add(oi.packageName);
        }
        return paths;
    }

    private boolean updateState(String targetPackageName, String overlayPackageName, int userId, int flags) throws OverlayManagerSettings.BadKeyException {
        int newState;
        int currentState;
        PackageInfo targetPackage = this.mPackageManager.getPackageInfo(targetPackageName, userId);
        PackageInfo overlayPackage = this.mPackageManager.getPackageInfo(overlayPackageName, userId);
        if (!(targetPackage == null || overlayPackage == null || "android".equals(targetPackageName) && overlayPackage.isStaticOverlayPackage())) {
            this.mIdmapManager.createIdmap(targetPackage, overlayPackage, userId);
        }
        boolean modified = false;
        if (overlayPackage != null) {
            modified |= this.mSettings.setBaseCodePath(overlayPackageName, userId, overlayPackage.applicationInfo.getBaseCodePath());
            modified |= this.mSettings.setCategory(overlayPackageName, userId, overlayPackage.overlayCategory);
        }
        if ((currentState = this.mSettings.getState(overlayPackageName, userId)) != (newState = this.calculateNewState(targetPackage, overlayPackage, userId, flags))) {
            modified |= this.mSettings.setState(overlayPackageName, userId, newState);
        }
        return modified;
    }

    private int calculateNewState(PackageInfo targetPackage, PackageInfo overlayPackage, int userId, int flags) throws OverlayManagerSettings.BadKeyException {
        if ((flags & 1) != 0) {
            return 4;
        }
        if ((flags & 2) != 0) {
            return 5;
        }
        if (targetPackage == null) {
            return 0;
        }
        if (!this.mIdmapManager.idmapExists(overlayPackage, userId)) {
            return 1;
        }
        if (overlayPackage.isStaticOverlayPackage()) {
            return 6;
        }
        boolean enabled = this.mSettings.getEnabled(overlayPackage.packageName, userId);
        return enabled ? 3 : 2;
    }

    private void removeIdmapIfPossible(OverlayInfo oi) {
        int[] userIds;
        if (!this.mIdmapManager.idmapExists(oi)) {
            return;
        }
        for (int userId : userIds = this.mSettings.getUsers()) {
            try {
                OverlayInfo tmp = this.mSettings.getOverlayInfo(oi.packageName, userId);
                if (tmp == null || !tmp.isEnabled()) continue;
                return;
            }
            catch (OverlayManagerSettings.BadKeyException badKeyException) {
                // empty catch block
            }
        }
        this.mIdmapManager.removeIdmap(oi, oi.userId);
    }

    static interface PackageManagerHelper {
        public PackageInfo getPackageInfo(String var1, int var2);

        public boolean signaturesMatching(String var1, String var2, int var3);

        public List<PackageInfo> getOverlayPackages(int var1);
    }

    static interface OverlayChangeListener {
        public void onOverlaysChanged(String var1, int var2);
    }
}

