/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.os;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IDumpstate;
import android.os.IDumpstateListener;
import android.os.IDumpstateToken;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserManager;
import android.util.ArraySet;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import com.android.server.SystemConfig;
import java.io.FileDescriptor;

class BugreportManagerServiceImpl
extends IDumpstate.Stub {
    private static final String TAG = "BugreportManagerService";
    private static final String BUGREPORT_SERVICE = "bugreportd";
    private static final long DEFAULT_BUGREPORT_SERVICE_TIMEOUT_MILLIS = 30000L;
    private final Object mLock = new Object();
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final ArraySet<String> mBugreportWhitelistedPackages;

    BugreportManagerServiceImpl(Context context) {
        this.mContext = context;
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mBugreportWhitelistedPackages = SystemConfig.getInstance().getBugreportWhitelistedPackages();
    }

    @Override
    public IDumpstateToken setListener(String name, IDumpstateListener listener, boolean getSectionDetails) {
        throw new UnsupportedOperationException("setListener is not allowed on this service");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startBugreport(int callingUidUnused, String callingPackage, FileDescriptor bugreportFd, FileDescriptor screenshotFd, int bugreportMode, IDumpstateListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "startBugreport");
        Preconditions.checkNotNull(callingPackage);
        Preconditions.checkNotNull(bugreportFd);
        Preconditions.checkNotNull(listener);
        this.validateBugreportMode(bugreportMode);
        long identity = Binder.clearCallingIdentity();
        try {
            this.ensureIsPrimaryUser();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        int callingUid = Binder.getCallingUid();
        this.mAppOps.checkPackage(callingUid, callingPackage);
        if (!this.mBugreportWhitelistedPackages.contains(callingPackage)) {
            throw new SecurityException(callingPackage + " is not whitelisted to use Bugreport API");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.startBugreportLocked(callingUid, callingPackage, bugreportFd, screenshotFd, bugreportMode, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelBugreport() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "startBugreport");
        Object object = this.mLock;
        synchronized (object) {
            SystemProperties.set("ctl.stop", BUGREPORT_SERVICE);
        }
    }

    private void validateBugreportMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2 && mode != 3 && mode != 4 && mode != 5) {
            Slog.w(TAG, "Unknown bugreport mode: " + mode);
            throw new IllegalArgumentException("Unknown bugreport mode: " + mode);
        }
    }

    private void ensureIsPrimaryUser() {
        UserInfo currentUser = null;
        try {
            currentUser = ActivityManager.getService().getCurrentUser();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        UserInfo primaryUser = UserManager.get(this.mContext).getPrimaryUser();
        if (currentUser == null) {
            this.logAndThrow("No current user. Only primary user is allowed to take bugreports.");
        }
        if (primaryUser == null) {
            this.logAndThrow("No primary user. Only primary user is allowed to take bugreports.");
        }
        if (primaryUser.id != currentUser.id) {
            this.logAndThrow("Current user not primary user. Only primary user is allowed to take bugreports.");
        }
    }

    @GuardedBy(value={"mLock"})
    private void startBugreportLocked(int callingUid, String callingPackage, FileDescriptor bugreportFd, FileDescriptor screenshotFd, int bugreportMode, IDumpstateListener listener) {
        if (this.isDumpstateBinderServiceRunningLocked()) {
            Slog.w(TAG, "'dumpstate' is already running. Cannot start a new bugreport while another one is currently in progress.");
            this.reportError(listener, 5);
            return;
        }
        IDumpstate ds = this.startAndGetDumpstateBinderServiceLocked();
        if (ds == null) {
            Slog.w(TAG, "Unable to get bugreport service");
            this.reportError(listener, 2);
            return;
        }
        DumpstateListener myListener = new DumpstateListener(listener, ds);
        try {
            ds.startBugreport(callingUid, callingPackage, bugreportFd, screenshotFd, bugreportMode, myListener);
        }
        catch (RemoteException e) {
            this.cancelBugreport();
        }
    }

    @GuardedBy(value={"mLock"})
    private boolean isDumpstateBinderServiceRunningLocked() {
        IDumpstate ds = IDumpstate.Stub.asInterface(ServiceManager.getService("dumpstate"));
        return ds != null;
    }

    @GuardedBy(value={"mLock"})
    private IDumpstate startAndGetDumpstateBinderServiceLocked() {
        SystemProperties.set("ctl.start", BUGREPORT_SERVICE);
        IDumpstate ds = null;
        boolean timedOut = false;
        int totalTimeWaitedMillis = 0;
        int seedWaitTimeMillis = 500;
        while (!timedOut) {
            ds = IDumpstate.Stub.asInterface(ServiceManager.getService("dumpstate"));
            if (ds != null) {
                Slog.i(TAG, "Got bugreport service handle.");
                break;
            }
            SystemClock.sleep(seedWaitTimeMillis);
            Slog.i(TAG, "Waiting to get dumpstate service handle (" + totalTimeWaitedMillis + "ms)");
            timedOut = (long)(totalTimeWaitedMillis += (seedWaitTimeMillis *= 2)) > 30000L;
        }
        if (timedOut) {
            Slog.w(TAG, "Timed out waiting to get dumpstate service handle (" + totalTimeWaitedMillis + "ms)");
        }
        return ds;
    }

    private void reportError(IDumpstateListener listener, int errorCode) {
        try {
            listener.onError(errorCode);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "onError() transaction threw RemoteException: " + e.getMessage());
        }
    }

    private void logAndThrow(String message) {
        Slog.w(TAG, message);
        throw new IllegalArgumentException(message);
    }

    private final class DumpstateListener
    extends IDumpstateListener.Stub
    implements IBinder.DeathRecipient {
        private final IDumpstateListener mListener;
        private final IDumpstate mDs;
        private boolean mDone = false;

        DumpstateListener(IDumpstateListener listener, IDumpstate ds) {
            this.mListener = listener;
            this.mDs = ds;
            try {
                this.mDs.asBinder().linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.e(BugreportManagerServiceImpl.TAG, "Unable to register Death Recipient for IDumpstate", e);
            }
        }

        @Override
        public void onProgress(int progress) throws RemoteException {
            this.mListener.onProgress(progress);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onError(int errorCode) throws RemoteException {
            Object object = BugreportManagerServiceImpl.this.mLock;
            synchronized (object) {
                this.mDone = true;
            }
            this.mListener.onError(errorCode);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFinished() throws RemoteException {
            Object object = BugreportManagerServiceImpl.this.mLock;
            synchronized (object) {
                this.mDone = true;
            }
            this.mListener.onFinished();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = BugreportManagerServiceImpl.this.mLock;
            synchronized (object) {
                if (!this.mDone) {
                    Slog.e(BugreportManagerServiceImpl.TAG, "IDumpstate likely crashed. Notifying listener");
                    try {
                        this.mListener.onError(2);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            this.mDs.asBinder().unlinkToDeath(this, 0);
        }

        @Override
        public void onProgressUpdated(int progress) throws RemoteException {
        }

        @Override
        public void onMaxProgressUpdated(int maxProgress) throws RemoteException {
        }

        @Override
        public void onSectionComplete(String title, int status, int size, int durationMs) throws RemoteException {
        }
    }
}

