/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.os;

import android.content.Context;
import android.os.IDeviceIdentifiersPolicyService;
import android.os.RemoteException;
import android.os.SystemProperties;
import com.android.internal.telephony.TelephonyPermissions;
import com.android.server.SystemService;

public final class DeviceIdentifiersPolicyService
extends SystemService {
    public DeviceIdentifiersPolicyService(Context context) {
        super(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("device_identifiers", new DeviceIdentifiersPolicy(this.getContext()));
    }

    private static final class DeviceIdentifiersPolicy
    extends IDeviceIdentifiersPolicyService.Stub {
        private final Context mContext;

        public DeviceIdentifiersPolicy(Context context) {
            this.mContext = context;
        }

        @Override
        public String getSerial() throws RemoteException {
            if (!TelephonyPermissions.checkCallingOrSelfReadDeviceIdentifiers(this.mContext, null, "getSerial")) {
                return "unknown";
            }
            return SystemProperties.get("ro.serialno", "unknown");
        }

        @Override
        public String getSerialForPackage(String callingPackage) throws RemoteException {
            if (!TelephonyPermissions.checkCallingOrSelfReadDeviceIdentifiers(this.mContext, callingPackage, "getSerial")) {
                return "unknown";
            }
            return SystemProperties.get("ro.serialno", "unknown");
        }
    }
}

