/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.apex.ApexInfo;
import android.apex.ApexInfoList;
import android.apex.ApexSessionInfo;
import android.apex.IApexService;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageParser;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.sysprop.ApexProperties;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import java.io.File;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

class ApexManager {
    static final String TAG = "ApexManager";
    private final IApexService mApexService;
    private final Context mContext;
    private final Object mLock = new Object();
    @GuardedBy(value={"mLock"})
    private List<PackageInfo> mAllPackagesCache;
    @GuardedBy(value={"mLock"})
    private ArrayMap<String, PackageInfo> mApexNameToPackageInfoCache;
    static final int MATCH_ACTIVE_PACKAGE = 1;
    static final int MATCH_FACTORY_PACKAGE = 2;

    ApexManager(Context context) {
        try {
            this.mApexService = IApexService.Stub.asInterface(ServiceManager.getServiceOrThrow("apexservice"));
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new IllegalStateException("Required service apexservice not available");
        }
        this.mContext = context;
    }

    void systemReady() {
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                ApexManager.this.onBootCompleted();
                ApexManager.this.mContext.unregisterReceiver(this);
            }
        }, new IntentFilter("android.intent.action.BOOT_COMPLETED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateAllPackagesCacheIfNeeded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAllPackagesCache != null) {
                return;
            }
            this.mApexNameToPackageInfoCache = new ArrayMap();
            try {
                ApexInfo[] allPkgs;
                this.mAllPackagesCache = new ArrayList<PackageInfo>();
                HashSet<String> activePackagesSet = new HashSet<String>();
                HashSet<String> factoryPackagesSet = new HashSet<String>();
                for (ApexInfo ai : allPkgs = this.mApexService.getAllPackages()) {
                    if (!new File(ai.packagePath).isDirectory()) {
                        try {
                            PackageInfo pkg = PackageParser.generatePackageInfoFromApex(ai, 0x8000080);
                            this.mAllPackagesCache.add(pkg);
                            if (ai.isActive) {
                                if (activePackagesSet.contains(pkg.packageName)) {
                                    throw new IllegalStateException("Two active packages have the same name: " + pkg.packageName);
                                }
                                activePackagesSet.add(ai.packageName);
                                this.mApexNameToPackageInfoCache.put(ai.packageName, pkg);
                            }
                            if (!ai.isFactory) continue;
                            if (factoryPackagesSet.contains(pkg.packageName)) {
                                throw new IllegalStateException("Two factory packages have the same name: " + pkg.packageName);
                            }
                            factoryPackagesSet.add(ai.packageName);
                            continue;
                        }
                        catch (PackageParser.PackageParserException pe) {
                            throw new IllegalStateException("Unable to parse: " + ai, pe);
                        }
                    }
                    break;
                }
            }
            catch (RemoteException re) {
                Slog.e(TAG, "Unable to retrieve packages from apexservice: " + re.toString());
                throw new RuntimeException(re);
            }
        }
    }

    PackageInfo getPackageInfo(String packageName, int flags) {
        this.populateAllPackagesCacheIfNeeded();
        boolean matchActive = (flags & 1) != 0;
        boolean matchFactory = (flags & 2) != 0;
        for (PackageInfo packageInfo : this.mAllPackagesCache) {
            if (!packageInfo.packageName.equals(packageName) || matchActive && !ApexManager.isActive(packageInfo) || matchFactory && !ApexManager.isFactory(packageInfo)) continue;
            return packageInfo;
        }
        return null;
    }

    @Deprecated
    PackageInfo getPackageInfoForApexName(String apexName) {
        this.populateAllPackagesCacheIfNeeded();
        return this.mApexNameToPackageInfoCache.get(apexName);
    }

    List<PackageInfo> getActivePackages() {
        this.populateAllPackagesCacheIfNeeded();
        return this.mAllPackagesCache.stream().filter(item -> ApexManager.isActive(item)).collect(Collectors.toList());
    }

    List<PackageInfo> getFactoryPackages() {
        this.populateAllPackagesCacheIfNeeded();
        return this.mAllPackagesCache.stream().filter(item -> ApexManager.isFactory(item)).collect(Collectors.toList());
    }

    List<PackageInfo> getInactivePackages() {
        this.populateAllPackagesCacheIfNeeded();
        return this.mAllPackagesCache.stream().filter(item -> !ApexManager.isActive(item)).collect(Collectors.toList());
    }

    boolean isApexPackage(String packageName) {
        this.populateAllPackagesCacheIfNeeded();
        for (PackageInfo packageInfo : this.mAllPackagesCache) {
            if (!packageInfo.packageName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    ApexSessionInfo getStagedSessionInfo(int sessionId) {
        try {
            ApexSessionInfo apexSessionInfo = this.mApexService.getStagedSessionInfo(sessionId);
            if (apexSessionInfo.isUnknown) {
                return null;
            }
            return apexSessionInfo;
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to contact apexservice", re);
            throw new RuntimeException(re);
        }
    }

    boolean submitStagedSession(int sessionId, int[] childSessionIds, ApexInfoList apexInfoList) {
        try {
            return this.mApexService.submitStagedSession(sessionId, childSessionIds, apexInfoList);
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to contact apexservice", re);
            throw new RuntimeException(re);
        }
    }

    boolean markStagedSessionReady(int sessionId) {
        try {
            return this.mApexService.markStagedSessionReady(sessionId);
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to contact apexservice", re);
            throw new RuntimeException(re);
        }
    }

    void markStagedSessionSuccessful(int sessionId) {
        try {
            this.mApexService.markStagedSessionSuccessful(sessionId);
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to contact apexservice", re);
            throw new RuntimeException(re);
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to mark session " + sessionId + " as successful", e);
        }
    }

    boolean isApexSupported() {
        return ApexProperties.updatable().orElse(false);
    }

    boolean abortActiveSession() {
        try {
            this.mApexService.abortActiveSession();
            return true;
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to contact apexservice", re);
            return false;
        }
    }

    boolean uninstallApex(String apexPackagePath) {
        try {
            this.mApexService.unstagePackages(Collections.singletonList(apexPackagePath));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isActive(PackageInfo packageInfo) {
        return (packageInfo.applicationInfo.flags & 0x800000) != 0;
    }

    private static boolean isFactory(PackageInfo packageInfo) {
        return (packageInfo.applicationInfo.flags & 1) != 0;
    }

    void dumpFromPackagesCache(List<PackageInfo> packagesCache, String packageName, IndentingPrintWriter ipw) {
        ipw.println();
        ipw.increaseIndent();
        for (PackageInfo pi : packagesCache) {
            if (packageName != null && !packageName.equals(pi.packageName)) continue;
            ipw.println(pi.packageName);
            ipw.increaseIndent();
            ipw.println("Version: " + pi.versionCode);
            ipw.println("Path: " + pi.applicationInfo.sourceDir);
            ipw.println("IsActive: " + ApexManager.isActive(pi));
            ipw.println("IsFactory: " + ApexManager.isFactory(pi));
            ipw.decreaseIndent();
        }
        ipw.decreaseIndent();
        ipw.println();
    }

    void dump(PrintWriter pw, String packageName) {
        IndentingPrintWriter ipw = new IndentingPrintWriter(pw, "  ", 120);
        try {
            ApexSessionInfo[] sessions;
            this.populateAllPackagesCacheIfNeeded();
            ipw.println();
            ipw.println("Active APEX packages:");
            this.dumpFromPackagesCache(this.getActivePackages(), packageName, ipw);
            ipw.println("Inactive APEX packages:");
            this.dumpFromPackagesCache(this.getInactivePackages(), packageName, ipw);
            ipw.println("Factory APEX packages:");
            this.dumpFromPackagesCache(this.getFactoryPackages(), packageName, ipw);
            ipw.increaseIndent();
            ipw.println("APEX session state:");
            ipw.increaseIndent();
            for (ApexSessionInfo si : sessions = this.mApexService.getSessions()) {
                ipw.println("Session ID: " + si.sessionId);
                ipw.increaseIndent();
                if (si.isUnknown) {
                    ipw.println("State: UNKNOWN");
                } else if (si.isVerified) {
                    ipw.println("State: VERIFIED");
                } else if (si.isStaged) {
                    ipw.println("State: STAGED");
                } else if (si.isActivated) {
                    ipw.println("State: ACTIVATED");
                } else if (si.isActivationFailed) {
                    ipw.println("State: ACTIVATION FAILED");
                } else if (si.isSuccess) {
                    ipw.println("State: SUCCESS");
                } else if (si.isRollbackInProgress) {
                    ipw.println("State: ROLLBACK IN PROGRESS");
                } else if (si.isRolledBack) {
                    ipw.println("State: ROLLED BACK");
                } else if (si.isRollbackFailed) {
                    ipw.println("State: ROLLBACK FAILED");
                }
                ipw.decreaseIndent();
            }
            ipw.decreaseIndent();
        }
        catch (RemoteException e) {
            ipw.println("Couldn't communicate with apexd.");
        }
    }

    public void onBootCompleted() {
        this.populateAllPackagesCacheIfNeeded();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface PackageInfoFlags {
    }
}

